package apple.metalperformanceshaders;

import apple.NSObject;
import apple.foundation.NSArray;
import apple.foundation.NSMethodSignature;
import apple.foundation.NSSet;
import org.moe.natj.c.ann.FunctionPtr;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.Generated;
import org.moe.natj.general.ann.Library;
import org.moe.natj.general.ann.Mapped;
import org.moe.natj.general.ann.MappedReturn;
import org.moe.natj.general.ann.NInt;
import org.moe.natj.general.ann.NUInt;
import org.moe.natj.general.ann.Owned;
import org.moe.natj.general.ann.Runtime;
import org.moe.natj.general.ptr.VoidPtr;
import org.moe.natj.objc.Class;
import org.moe.natj.objc.ObjCRuntime;
import org.moe.natj.objc.SEL;
import org.moe.natj.objc.ann.ObjCClassBinding;
import org.moe.natj.objc.ann.Selector;
import org.moe.natj.objc.map.ObjCObjectMapper;

/**
 * A node for a MPSCNNDilatedPooling kernel
 * 
 * This class corresponds to the MPSCNNDilatedPooling class.
 */
@Generated
@Library("MetalPerformanceShaders")
@Runtime(ObjCRuntime.class)
@ObjCClassBinding
public class MPSCNNDilatedPoolingMaxNode extends MPSNNFilterNode {
    static {
        NatJ.register();
    }

    @Generated
    protected MPSCNNDilatedPoolingMaxNode(Pointer peer) {
        super(peer);
    }

    @Generated
    @Selector("accessInstanceVariablesDirectly")
    public static native boolean accessInstanceVariablesDirectly();

    @Generated
    @Owned
    @Selector("alloc")
    public static native MPSCNNDilatedPoolingMaxNode alloc();

    @Generated
    @Selector("allocWithZone:")
    @MappedReturn(ObjCObjectMapper.class)
    public static native Object allocWithZone(VoidPtr zone);

    @Generated
    @Selector("automaticallyNotifiesObserversForKey:")
    public static native boolean automaticallyNotifiesObserversForKey(String key);

    @Generated
    @Selector("cancelPreviousPerformRequestsWithTarget:")
    public static native void cancelPreviousPerformRequestsWithTarget(@Mapped(ObjCObjectMapper.class) Object aTarget);

    @Generated
    @Selector("cancelPreviousPerformRequestsWithTarget:selector:object:")
    public static native void cancelPreviousPerformRequestsWithTargetSelectorObject(
            @Mapped(ObjCObjectMapper.class) Object aTarget, SEL aSelector,
            @Mapped(ObjCObjectMapper.class) Object anArgument);

    @Generated
    @Selector("classFallbacksForKeyedArchiver")
    public static native NSArray<String> classFallbacksForKeyedArchiver();

    @Generated
    @Selector("classForKeyedUnarchiver")
    public static native Class classForKeyedUnarchiver();

    @Generated
    @Selector("debugDescription")
    public static native String debugDescription_static();

    @Generated
    @Selector("description")
    public static native String description_static();

    @Generated
    @Selector("dilationRateX")
    @NUInt
    public native long dilationRateX();

    @Generated
    @Selector("dilationRateY")
    @NUInt
    public native long dilationRateY();

    @Generated
    @Selector("hash")
    @NUInt
    public static native long hash_static();

    @Generated
    @Selector("init")
    public native MPSCNNDilatedPoolingMaxNode init();

    /**
     * Convenience initializer for MPSCNNDilatedPooling nodes with square non-overlapping kernels
     * 
     * @param      sourceNode      The MPSNNImageNode representing the source MPSImage for the filter
     * @param      size            kernelWidth = kernelHeight = strideInPixelsX = strideInPixelsY = dilationRateX = dilationRateY = size
     * @return     A new MPSNNFilter node for a MPSCNNDilatedPooling kernel.
     */
    @Generated
    @Selector("initWithSource:filterSize:")
    public native MPSCNNDilatedPoolingMaxNode initWithSourceFilterSize(MPSNNImageNode sourceNode, @NUInt long size);

    /**
     * Convenience initializer for MPSCNNDilatedPooling nodes with square kernels and equal dilation factors
     * 
     * @param      sourceNode      The MPSNNImageNode representing the source MPSImage for the filter
     * @param      size            kernelWidth = kernelHeight = size
     * @param      stride          strideInPixelsX = strideInPixelsY = stride
     * @param      dilationRate    dilationRateX = dilationRateY = stride
     * @return     A new MPSNNFilter node for a MPSCNNDilatedPooling kernel.
     */
    @Generated
    @Selector("initWithSource:filterSize:stride:dilationRate:")
    public native MPSCNNDilatedPoolingMaxNode initWithSourceFilterSizeStrideDilationRate(MPSNNImageNode sourceNode,
            @NUInt long size, @NUInt long stride, @NUInt long dilationRate);

    /**
     * Init a node representing a MPSCNNPooling kernel
     * 
     * @param      sourceNode              The MPSNNImageNode representing the source MPSImage for the filter
     * @param      kernelWidth             The width of the max filter window
     * @param      kernelHeight            The height of the max filter window
     * @param      strideInPixelsX         The output stride (downsampling factor) in the x dimension.
     * @param      strideInPixelsY         The output stride (downsampling factor) in the y dimension.
     * @param      dilationRateX           The dilation factor in the x dimension.
     * @param      dilationRateY           The dilation factor in the y dimension.
     * @return     A new MPSNNFilter node for a MPSCNNPooling kernel.
     */
    @Generated
    @Selector("initWithSource:kernelWidth:kernelHeight:strideInPixelsX:strideInPixelsY:dilationRateX:dilationRateY:")
    public native MPSCNNDilatedPoolingMaxNode initWithSourceKernelWidthKernelHeightStrideInPixelsXStrideInPixelsYDilationRateXDilationRateY(
            MPSNNImageNode sourceNode, @NUInt long kernelWidth, @NUInt long kernelHeight, @NUInt long strideInPixelsX,
            @NUInt long strideInPixelsY, @NUInt long dilationRateX, @NUInt long dilationRateY);

    @Generated
    @Selector("instanceMethodForSelector:")
    @FunctionPtr(name = "call_instanceMethodForSelector_ret")
    public static native NSObject.Function_instanceMethodForSelector_ret instanceMethodForSelector(SEL aSelector);

    @Generated
    @Selector("instanceMethodSignatureForSelector:")
    public static native NSMethodSignature instanceMethodSignatureForSelector(SEL aSelector);

    @Generated
    @Selector("instancesRespondToSelector:")
    public static native boolean instancesRespondToSelector(SEL aSelector);

    @Generated
    @Selector("isSubclassOfClass:")
    public static native boolean isSubclassOfClass(Class aClass);

    @Generated
    @Selector("keyPathsForValuesAffectingValueForKey:")
    public static native NSSet<String> keyPathsForValuesAffectingValueForKey(String key);

    @Generated
    @Owned
    @Selector("new")
    @MappedReturn(ObjCObjectMapper.class)
    public static native Object new_objc();

    /**
     * Convenience initializer for MPSCNNDilatedPooling nodes with square non-overlapping kernels
     * 
     * @param      sourceNode      The MPSNNImageNode representing the source MPSImage for the filter
     * @param      size            kernelWidth = kernelHeight = strideInPixelsX = strideInPixelsY = dilationRateX = dilationRateY = size
     * @return     A new MPSNNFilter node for a MPSCNNDilatedPooling kernel.
     */
    @Generated
    @Selector("nodeWithSource:filterSize:")
    public static native MPSCNNDilatedPoolingMaxNode nodeWithSourceFilterSize(MPSNNImageNode sourceNode,
            @NUInt long size);

    /**
     * Convenience initializer for MPSCNNDilatedPooling nodes with square kernels and equal dilation factors
     * 
     * @param      sourceNode      The MPSNNImageNode representing the source MPSImage for the filter
     * @param      size            kernelWidth = kernelHeight = size
     * @param      stride          strideInPixelsX = strideInPixelsY = stride
     * @param      dilationRate    dilationRateX = dilationRateY = stride
     * @return     A new MPSNNFilter node for a MPSCNNDilatedPooling kernel.
     */
    @Generated
    @Selector("nodeWithSource:filterSize:stride:dilationRate:")
    public static native MPSCNNDilatedPoolingMaxNode nodeWithSourceFilterSizeStrideDilationRate(
            MPSNNImageNode sourceNode, @NUInt long size, @NUInt long stride, @NUInt long dilationRate);

    @Generated
    @Selector("resolveClassMethod:")
    public static native boolean resolveClassMethod(SEL sel);

    @Generated
    @Selector("resolveInstanceMethod:")
    public static native boolean resolveInstanceMethod(SEL sel);

    @Generated
    @Selector("setVersion:")
    public static native void setVersion_static(@NInt long aVersion);

    @Generated
    @Selector("superclass")
    public static native Class superclass_static();

    @Generated
    @Selector("version")
    @NInt
    public static native long version_static();
}