/*
Copyright 2014-2016 Intel Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package apple.networkextension;

import apple.NSObject;
import apple.foundation.NSArray;
import apple.foundation.NSError;
import apple.foundation.NSMethodSignature;
import apple.foundation.NSSet;
import org.moe.natj.c.ann.FunctionPtr;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.Generated;
import org.moe.natj.general.ann.Library;
import org.moe.natj.general.ann.Mapped;
import org.moe.natj.general.ann.MappedReturn;
import org.moe.natj.general.ann.NInt;
import org.moe.natj.general.ann.NUInt;
import org.moe.natj.general.ann.Owned;
import org.moe.natj.general.ann.Runtime;
import org.moe.natj.general.ptr.VoidPtr;
import org.moe.natj.objc.Class;
import org.moe.natj.objc.ObjCRuntime;
import org.moe.natj.objc.SEL;
import org.moe.natj.objc.ann.ObjCBlock;
import org.moe.natj.objc.ann.ObjCClassBinding;
import org.moe.natj.objc.ann.Selector;
import org.moe.natj.objc.map.ObjCObjectMapper;

/**
 * [@interface] NEFilterProvider
 * 
 * The NEFilterProvider class is an abstract base class that declares the programmatic interface of an
 * object that implements a socket filter.
 * 
 * NEFilterProvider is part of NetworkExtension.framework
 */
@Generated
@Library("NetworkExtension")
@Runtime(ObjCRuntime.class)
@ObjCClassBinding
public class NEFilterProvider extends NEProvider {
    static {
        NatJ.register();
    }

    @Generated
    protected NEFilterProvider(Pointer peer) {
        super(peer);
    }

    @Generated
    @Selector("accessInstanceVariablesDirectly")
    public static native boolean accessInstanceVariablesDirectly();

    @Generated
    @Owned
    @Selector("alloc")
    public static native NEFilterProvider alloc();

    @Generated
    @Selector("allocWithZone:")
    @MappedReturn(ObjCObjectMapper.class)
    public static native Object allocWithZone(VoidPtr zone);

    @Generated
    @Selector("automaticallyNotifiesObserversForKey:")
    public static native boolean automaticallyNotifiesObserversForKey(String key);

    @Generated
    @Selector("cancelPreviousPerformRequestsWithTarget:")
    public static native void cancelPreviousPerformRequestsWithTarget(@Mapped(ObjCObjectMapper.class) Object aTarget);

    @Generated
    @Selector("cancelPreviousPerformRequestsWithTarget:selector:object:")
    public static native void cancelPreviousPerformRequestsWithTargetSelectorObject(
            @Mapped(ObjCObjectMapper.class) Object aTarget, SEL aSelector,
            @Mapped(ObjCObjectMapper.class) Object anArgument);

    @Generated
    @Selector("classFallbacksForKeyedArchiver")
    public static native NSArray<String> classFallbacksForKeyedArchiver();

    @Generated
    @Selector("classForKeyedUnarchiver")
    public static native Class classForKeyedUnarchiver();

    @Generated
    @Selector("debugDescription")
    public static native String debugDescription_static();

    @Generated
    @Selector("description")
    public static native String description_static();

    @Generated
    @Selector("hash")
    @NUInt
    public static native long hash_static();

    @Generated
    @Selector("instanceMethodForSelector:")
    @FunctionPtr(name = "call_instanceMethodForSelector_ret")
    public static native NSObject.Function_instanceMethodForSelector_ret instanceMethodForSelector(SEL aSelector);

    @Generated
    @Selector("instanceMethodSignatureForSelector:")
    public static native NSMethodSignature instanceMethodSignatureForSelector(SEL aSelector);

    @Generated
    @Selector("instancesRespondToSelector:")
    public static native boolean instancesRespondToSelector(SEL aSelector);

    @Generated
    @Selector("isSubclassOfClass:")
    public static native boolean isSubclassOfClass(Class aClass);

    @Generated
    @Selector("keyPathsForValuesAffectingValueForKey:")
    public static native NSSet<String> keyPathsForValuesAffectingValueForKey(String key);

    @Generated
    @Owned
    @Selector("new")
    @MappedReturn(ObjCObjectMapper.class)
    public static native Object new_objc();

    @Generated
    @Selector("resolveClassMethod:")
    public static native boolean resolveClassMethod(SEL sel);

    @Generated
    @Selector("resolveInstanceMethod:")
    public static native boolean resolveInstanceMethod(SEL sel);

    @Generated
    @Selector("setVersion:")
    public static native void setVersion_static(@NInt long aVersion);

    @Generated
    @Selector("superclass")
    public static native Class superclass_static();

    @Generated
    @Selector("version")
    @NInt
    public static native long version_static();

    /**
     * [@property] filterConfiguration
     * 
     * An NEContentFilterConfiguration object containing the current filter configuration. The value of this
     * property can change during the lifetime of a filter. Filter implementations can use KVO to be notified when the
     * configuration changes.
     */
    @Generated
    @Selector("filterConfiguration")
    public native NEFilterProviderConfiguration filterConfiguration();

    @Generated
    @Selector("init")
    public native NEFilterProvider init();

    /**
     * startFilterWithCompletionHandler:
     * 
     * This function is called by the framework when the content filter is being started. Subclasses must
     * override this method and perform whatever steps are necessary to start the filter.
     * 
     * @param completionHandler A block that must be called when the process of starting the filter is complete. If the
     * filter was started successfully, subclass implementations must pass the nil value to this block. If an error occurred
     * while starting the filter, sublcass implementations must pass a non-nil NSError containing more details about the error.
     */
    @Generated
    @Selector("startFilterWithCompletionHandler:")
    public native void startFilterWithCompletionHandler(
            @ObjCBlock(name = "call_startFilterWithCompletionHandler") Block_startFilterWithCompletionHandler completionHandler);

    /**
     * stopFilterWithReason:completionHandler:
     * 
     * This function is called by the framework when the content filter is being stopped. Subclasses must
     * override this method and perform whatever steps are necessary to stop the filter.
     * 
     * @param reason An NEProviderStopReason indicating why the filter is being stopped.
     * @param completionHandler A block that must be called when the process of stopping the filter is complete.
     */
    @Generated
    @Selector("stopFilterWithReason:completionHandler:")
    public native void stopFilterWithReasonCompletionHandler(@NInt long reason,
            @ObjCBlock(name = "call_stopFilterWithReasonCompletionHandler") Block_stopFilterWithReasonCompletionHandler completionHandler);

    @Runtime(ObjCRuntime.class)
    @Generated
    public interface Block_startFilterWithCompletionHandler {
        @Generated
        void call_startFilterWithCompletionHandler(NSError error);
    }

    @Runtime(ObjCRuntime.class)
    @Generated
    public interface Block_stopFilterWithReasonCompletionHandler {
        @Generated
        void call_stopFilterWithReasonCompletionHandler();
    }

    /**
     * handleReport:
     * 
     * This function is called by the framework when the data provider extension returns a verdict with the report property set to True.
     *     Subclass implementations may override this method to handle the flow report.
     * 
     * @param report The report being delivered.
     */
    @Generated
    @Selector("handleReport:")
    public native void handleReport(NEFilterReport report);
}
