/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBigIntegerAssert;
import org.assertj.core.api.AbstractBooleanArrayAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractCharArrayAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractCharacterAssert;
import org.assertj.core.api.AbstractClassAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractDoubleArrayAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractFloatArrayAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractFutureAssert;
import org.assertj.core.api.AbstractInputStreamAssert;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLongArrayAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractShortArrayAssert;
import org.assertj.core.api.AbstractShortAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AbstractUriAssert;
import org.assertj.core.api.AbstractUrlAssert;
import org.assertj.core.api.AssertDelegateTarget;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AtomicBooleanAssert;
import org.assertj.core.api.AtomicIntegerArrayAssert;
import org.assertj.core.api.AtomicIntegerAssert;
import org.assertj.core.api.AtomicIntegerFieldUpdaterAssert;
import org.assertj.core.api.AtomicLongArrayAssert;
import org.assertj.core.api.AtomicLongAssert;
import org.assertj.core.api.AtomicLongFieldUpdaterAssert;
import org.assertj.core.api.AtomicMarkableReferenceAssert;
import org.assertj.core.api.AtomicReferenceArrayAssert;
import org.assertj.core.api.AtomicReferenceAssert;
import org.assertj.core.api.AtomicReferenceFieldUpdaterAssert;
import org.assertj.core.api.AtomicStampedReferenceAssert;
import org.assertj.core.api.BigDecimalAssert;
import org.assertj.core.api.BigIntegerAssert;
import org.assertj.core.api.BooleanArrayAssert;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.ByteArrayAssert;
import org.assertj.core.api.ByteAssert;
import org.assertj.core.api.CharArrayAssert;
import org.assertj.core.api.CharSequenceAssert;
import org.assertj.core.api.CharacterAssert;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.ClassBasedNavigableIterableAssert;
import org.assertj.core.api.ClassBasedNavigableListAssert;
import org.assertj.core.api.Condition;
import org.assertj.core.api.DateAssert;
import org.assertj.core.api.DoubleArrayAssert;
import org.assertj.core.api.DoubleAssert;
import org.assertj.core.api.FactoryBasedNavigableIterableAssert;
import org.assertj.core.api.FactoryBasedNavigableListAssert;
import org.assertj.core.api.Fail;
import org.assertj.core.api.FileAssert;
import org.assertj.core.api.FloatArrayAssert;
import org.assertj.core.api.FloatAssert;
import org.assertj.core.api.FutureAssert;
import org.assertj.core.api.GenericComparableAssert;
import org.assertj.core.api.InputStreamAssert;
import org.assertj.core.api.IntArrayAssert;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.LongArrayAssert;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ShortArrayAssert;
import org.assertj.core.api.ShortAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.UriAssert;
import org.assertj.core.api.UrlAssert;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.api.filter.InFilter;
import org.assertj.core.api.filter.NotFilter;
import org.assertj.core.api.filter.NotInFilter;
import org.assertj.core.condition.AllOf;
import org.assertj.core.condition.AnyOf;
import org.assertj.core.condition.DoesNotHave;
import org.assertj.core.condition.Not;
import org.assertj.core.data.Index;
import org.assertj.core.data.MapEntry;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.groups.Properties;
import org.assertj.core.groups.Tuple;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Files;
import org.assertj.core.util.URLs;
import org.assertj.core.util.introspection.FieldSupport;

public class Java6Assertions {
    @CheckReturnValue
    public static AtomicBooleanAssert assertThat(AtomicBoolean actual) {
        return new AtomicBooleanAssert(actual);
    }

    @CheckReturnValue
    public static AtomicIntegerAssert assertThat(AtomicInteger actual) {
        return new AtomicIntegerAssert(actual);
    }

    @CheckReturnValue
    public static AtomicIntegerArrayAssert assertThat(AtomicIntegerArray actual) {
        return new AtomicIntegerArrayAssert(actual);
    }

    @CheckReturnValue
    public static <OBJECT> AtomicIntegerFieldUpdaterAssert<OBJECT> assertThat(AtomicIntegerFieldUpdater<OBJECT> actual) {
        return new AtomicIntegerFieldUpdaterAssert<OBJECT>(actual);
    }

    @CheckReturnValue
    public static AtomicLongAssert assertThat(AtomicLong actual) {
        return new AtomicLongAssert(actual);
    }

    @CheckReturnValue
    public static AtomicLongArrayAssert assertThat(AtomicLongArray actual) {
        return new AtomicLongArrayAssert(actual);
    }

    @CheckReturnValue
    public static <OBJECT> AtomicLongFieldUpdaterAssert<OBJECT> assertThat(AtomicLongFieldUpdater<OBJECT> actual) {
        return new AtomicLongFieldUpdaterAssert<OBJECT>(actual);
    }

    @CheckReturnValue
    public static <VALUE> AtomicReferenceAssert<VALUE> assertThat(AtomicReference<VALUE> actual) {
        return new AtomicReferenceAssert<VALUE>(actual);
    }

    @CheckReturnValue
    public static <ELEMENT> AtomicReferenceArrayAssert<ELEMENT> assertThat(AtomicReferenceArray<ELEMENT> actual) {
        return new AtomicReferenceArrayAssert<ELEMENT>(actual);
    }

    @CheckReturnValue
    public static <FIELD, OBJECT> AtomicReferenceFieldUpdaterAssert<FIELD, OBJECT> assertThat(AtomicReferenceFieldUpdater<OBJECT, FIELD> actual) {
        return new AtomicReferenceFieldUpdaterAssert<FIELD, OBJECT>(actual);
    }

    @CheckReturnValue
    public static <VALUE> AtomicMarkableReferenceAssert<VALUE> assertThat(AtomicMarkableReference<VALUE> actual) {
        return new AtomicMarkableReferenceAssert<VALUE>(actual);
    }

    @CheckReturnValue
    public static <VALUE> AtomicStampedReferenceAssert<VALUE> assertThat(AtomicStampedReference<VALUE> actual) {
        return new AtomicStampedReferenceAssert<VALUE>(actual);
    }

    @CheckReturnValue
    public static AbstractBigDecimalAssert<?> assertThat(BigDecimal actual) {
        return new BigDecimalAssert(actual);
    }

    @CheckReturnValue
    public static AbstractBigIntegerAssert<?> assertThat(BigInteger actual) {
        return new BigIntegerAssert(actual);
    }

    @CheckReturnValue
    public static AbstractUriAssert<?> assertThat(URI actual) {
        return new UriAssert(actual);
    }

    @CheckReturnValue
    public static AbstractUrlAssert<?> assertThat(URL actual) {
        return new UrlAssert(actual);
    }

    @CheckReturnValue
    public static AbstractBooleanAssert<?> assertThat(boolean actual) {
        return new BooleanAssert(actual);
    }

    @CheckReturnValue
    public static AbstractBooleanAssert<?> assertThat(Boolean actual) {
        return new BooleanAssert(actual);
    }

    @CheckReturnValue
    public static AbstractBooleanArrayAssert<?> assertThat(boolean[] actual) {
        return new BooleanArrayAssert(actual);
    }

    @CheckReturnValue
    public static AbstractByteAssert<?> assertThat(byte actual) {
        return new ByteAssert(actual);
    }

    @CheckReturnValue
    public static AbstractByteAssert<?> assertThat(Byte actual) {
        return new ByteAssert(actual);
    }

    @CheckReturnValue
    public static AbstractByteArrayAssert<?> assertThat(byte[] actual) {
        return new ByteArrayAssert(actual);
    }

    @CheckReturnValue
    public static AbstractCharacterAssert<?> assertThat(char actual) {
        return new CharacterAssert(Character.valueOf(actual));
    }

    @CheckReturnValue
    public static AbstractCharArrayAssert<?> assertThat(char[] actual) {
        return new CharArrayAssert(actual);
    }

    @CheckReturnValue
    public static AbstractCharacterAssert<?> assertThat(Character actual) {
        return new CharacterAssert(actual);
    }

    @CheckReturnValue
    public static AbstractClassAssert<?> assertThat(Class<?> actual) {
        return new ClassAssert(actual);
    }

    @CheckReturnValue
    public static <T extends Comparable<? super T>> AbstractComparableAssert<?, T> assertThat(T actual) {
        return new GenericComparableAssert<T>(actual);
    }

    @CheckReturnValue
    public static <T> AbstractIterableAssert<?, Iterable<? extends T>, T, ObjectAssert<T>> assertThat(Iterable<? extends T> actual) {
        return new IterableAssert<T>(actual);
    }

    @CheckReturnValue
    public static <T> AbstractIterableAssert<?, Iterable<? extends T>, T, ObjectAssert<T>> assertThat(Iterator<? extends T> actual) {
        return new IterableAssert<T>(actual);
    }

    @CheckReturnValue
    public static AbstractDoubleAssert<?> assertThat(double actual) {
        return new DoubleAssert(actual);
    }

    @CheckReturnValue
    public static AbstractDoubleAssert<?> assertThat(Double actual) {
        return new DoubleAssert(actual);
    }

    @CheckReturnValue
    public static AbstractDoubleArrayAssert<?> assertThat(double[] actual) {
        return new DoubleArrayAssert(actual);
    }

    @CheckReturnValue
    public static AbstractFileAssert<?> assertThat(File actual) {
        return new FileAssert(actual);
    }

    @CheckReturnValue
    public static <RESULT> AbstractFutureAssert<?, ? extends Future<? extends RESULT>, RESULT> assertThat(Future<RESULT> actual) {
        return new FutureAssert<RESULT>(actual);
    }

    @CheckReturnValue
    public static AbstractInputStreamAssert<?, ? extends InputStream> assertThat(InputStream actual) {
        return new InputStreamAssert(actual);
    }

    @CheckReturnValue
    public static AbstractFloatAssert<?> assertThat(float actual) {
        return new FloatAssert(actual);
    }

    @CheckReturnValue
    public static AbstractFloatAssert<?> assertThat(Float actual) {
        return new FloatAssert(actual);
    }

    @CheckReturnValue
    public static AbstractFloatArrayAssert<?> assertThat(float[] actual) {
        return new FloatArrayAssert(actual);
    }

    @CheckReturnValue
    public static AbstractIntegerAssert<?> assertThat(int actual) {
        return new IntegerAssert(actual);
    }

    @CheckReturnValue
    public static AbstractIntArrayAssert<?> assertThat(int[] actual) {
        return new IntArrayAssert(actual);
    }

    @CheckReturnValue
    public static AbstractIntegerAssert<?> assertThat(Integer actual) {
        return new IntegerAssert(actual);
    }

    @CheckReturnValue
    public static <T> AbstractListAssert<?, List<? extends T>, T, ObjectAssert<T>> assertThat(List<? extends T> actual) {
        return new ListAssert<T>(actual);
    }

    public static <ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> FactoryBasedNavigableIterableAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(Iterable<? extends ELEMENT> actual, AssertFactory<ELEMENT, ELEMENT_ASSERT> assertFactory) {
        return new FactoryBasedNavigableIterableAssert(actual, FactoryBasedNavigableIterableAssert.class, assertFactory);
    }

    public static <ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> ClassBasedNavigableIterableAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(ACTUAL actual, Class<ELEMENT_ASSERT> assertClass) {
        return new ClassBasedNavigableIterableAssert(actual, ClassBasedNavigableIterableAssert.class, assertClass);
    }

    public static <ACTUAL extends List<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> FactoryBasedNavigableListAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(List<? extends ELEMENT> actual, AssertFactory<ELEMENT, ELEMENT_ASSERT> assertFactory) {
        return new FactoryBasedNavigableListAssert(actual, FactoryBasedNavigableListAssert.class, assertFactory);
    }

    public static <ELEMENT, ACTUAL extends List<? extends ELEMENT>, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> ClassBasedNavigableListAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(List<? extends ELEMENT> actual, Class<ELEMENT_ASSERT> assertClass) {
        return new ClassBasedNavigableListAssert(actual, assertClass);
    }

    @CheckReturnValue
    public static AbstractLongAssert<?> assertThat(long actual) {
        return new LongAssert(actual);
    }

    @CheckReturnValue
    public static AbstractLongAssert<?> assertThat(Long actual) {
        return new LongAssert(actual);
    }

    @CheckReturnValue
    public static AbstractLongArrayAssert<?> assertThat(long[] actual) {
        return new LongArrayAssert(actual);
    }

    @CheckReturnValue
    public static <T> AbstractObjectAssert<?, T> assertThat(T actual) {
        return new ObjectAssert<T>(actual);
    }

    @CheckReturnValue
    public static <T extends AssertDelegateTarget> T assertThat(T assertion) {
        return assertion;
    }

    public static <T> T assertThat(AssertProvider<T> component) {
        return component.assertThat();
    }

    @CheckReturnValue
    public static <T> AbstractObjectArrayAssert<?, T> assertThat(T[] actual) {
        return new ObjectArrayAssert<T>(actual);
    }

    @CheckReturnValue
    public static <K, V> MapAssert<K, V> assertThat(Map<K, V> actual) {
        return new MapAssert<K, V>(actual);
    }

    @CheckReturnValue
    public static AbstractShortAssert<?> assertThat(short actual) {
        return new ShortAssert(actual);
    }

    @CheckReturnValue
    public static AbstractShortAssert<?> assertThat(Short actual) {
        return new ShortAssert(actual);
    }

    @CheckReturnValue
    public static AbstractShortArrayAssert<?> assertThat(short[] actual) {
        return new ShortArrayAssert(actual);
    }

    @CheckReturnValue
    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assertThat(CharSequence actual) {
        return new CharSequenceAssert(actual);
    }

    @CheckReturnValue
    public static AbstractCharSequenceAssert<?, String> assertThat(String actual) {
        return new StringAssert(actual);
    }

    @CheckReturnValue
    public static AbstractDateAssert<?> assertThat(Date actual) {
        return new DateAssert(actual);
    }

    @CheckReturnValue
    public static AbstractThrowableAssert<?, ? extends Throwable> assertThat(Throwable actual) {
        return new ThrowableAssert(actual);
    }

    @CheckReturnValue
    public static AbstractThrowableAssert<?, ? extends Throwable> assertThatThrownBy(ThrowableAssert.ThrowingCallable shouldRaiseThrowable) {
        return new ThrowableAssert(Java6Assertions.catchThrowable(shouldRaiseThrowable)).hasBeenThrown();
    }

    public static Throwable catchThrowable(ThrowableAssert.ThrowingCallable shouldRaiseThrowable) {
        return ThrowableAssert.catchThrowable(shouldRaiseThrowable);
    }

    public static void fail(String failureMessage) {
        Fail.fail(failureMessage);
    }

    public static void fail(String failureMessage, Object ... args) {
        Fail.fail(failureMessage, args);
    }

    public static void fail(String failureMessage, Throwable realCause) {
        Fail.fail(failureMessage, realCause);
    }

    public static void failBecauseExceptionWasNotThrown(Class<? extends Throwable> throwableClass) {
        Fail.shouldHaveThrown(throwableClass);
    }

    public static void shouldHaveThrown(Class<? extends Throwable> throwableClass) {
        Fail.shouldHaveThrown(throwableClass);
    }

    public static void setMaxLengthForSingleLineDescription(int maxLengthForSingleLineDescription) {
        StandardRepresentation.setMaxLengthForSingleLineDescription(maxLengthForSingleLineDescription);
    }

    public static void setMaxElementsForPrinting(int maxElementsForPrinting) {
        StandardRepresentation.setMaxElementsForPrinting(maxElementsForPrinting);
    }

    public static <T> Properties<T> extractProperty(String propertyName, Class<T> propertyType) {
        return Properties.extractProperty(propertyName, propertyType);
    }

    public static Properties<Object> extractProperty(String propertyName) {
        return Properties.extractProperty(propertyName);
    }

    public static Tuple tuple(Object ... values) {
        return Tuple.tuple(values);
    }

    public static void setAllowExtractingPrivateFields(boolean allowExtractingPrivateFields) {
        FieldSupport.extraction().setAllowUsingPrivateFields(allowExtractingPrivateFields);
    }

    public static void setAllowComparingPrivateFields(boolean allowComparingPrivateFields) {
        FieldSupport.comparison().setAllowUsingPrivateFields(allowComparingPrivateFields);
    }

    public static <K, V> MapEntry<K, V> entry(K key, V value) {
        return MapEntry.entry(key, value);
    }

    public static Index atIndex(int index) {
        return Index.atIndex(index);
    }

    public static Offset<Double> offset(Double value) {
        return Offset.offset(value);
    }

    public static Offset<Float> offset(Float value) {
        return Offset.offset(value);
    }

    public static Offset<Double> within(Double value) {
        return Offset.offset(value);
    }

    public static Offset<Float> within(Float value) {
        return Offset.offset(value);
    }

    public static Offset<BigDecimal> within(BigDecimal value) {
        return Offset.offset(value);
    }

    public static Offset<BigInteger> within(BigInteger value) {
        return Offset.offset(value);
    }

    public static Offset<Byte> within(Byte value) {
        return Offset.offset(value);
    }

    public static Offset<Integer> within(Integer value) {
        return Offset.offset(value);
    }

    public static Offset<Short> within(Short value) {
        return Offset.offset(value);
    }

    public static Offset<Long> within(Long value) {
        return Offset.offset(value);
    }

    public static Offset<Double> byLessThan(Double value) {
        return Offset.offset(value);
    }

    public static Offset<Float> byLessThan(Float value) {
        return Offset.offset(value);
    }

    public static Offset<BigDecimal> byLessThan(BigDecimal value) {
        return Offset.offset(value);
    }

    public static Offset<BigInteger> byLessThan(BigInteger value) {
        return Offset.offset(value);
    }

    public static Offset<Byte> byLessThan(Byte value) {
        return Offset.offset(value);
    }

    public static Offset<Integer> byLessThan(Integer value) {
        return Offset.offset(value);
    }

    public static Offset<Short> byLessThan(Short value) {
        return Offset.offset(value);
    }

    public static Offset<Long> byLessThan(Long value) {
        return Offset.offset(value);
    }

    public static Percentage withinPercentage(Double value) {
        return Percentage.withPercentage(value);
    }

    public static Percentage withinPercentage(Integer value) {
        return Percentage.withPercentage(value.intValue());
    }

    public static Percentage withinPercentage(Long value) {
        return Percentage.withPercentage(value.longValue());
    }

    @SafeVarargs
    public static <T> Condition<T> allOf(Condition<? super T> ... conditions) {
        return AllOf.allOf(conditions);
    }

    public static <T> Condition<T> allOf(Iterable<? extends Condition<? super T>> conditions) {
        return AllOf.allOf(conditions);
    }

    @SafeVarargs
    public static <T> Condition<T> anyOf(Condition<? super T> ... conditions) {
        return AnyOf.anyOf(conditions);
    }

    public static <T> Condition<T> anyOf(Iterable<? extends Condition<? super T>> conditions) {
        return AnyOf.anyOf(conditions);
    }

    public static <T> DoesNotHave<T> doesNotHave(Condition<? super T> condition) {
        return DoesNotHave.doesNotHave(condition);
    }

    public static <T> Not<T> not(Condition<? super T> condition) {
        return Not.not(condition);
    }

    public static <E> Filters<E> filter(E[] array) {
        return Filters.filter(array);
    }

    public static <E> Filters<E> filter(Iterable<E> iterableToFilter) {
        return Filters.filter(iterableToFilter);
    }

    public static InFilter in(Object ... values) {
        return InFilter.in(values);
    }

    public static NotInFilter notIn(Object ... valuesNotToMatch) {
        return NotInFilter.notIn(valuesNotToMatch);
    }

    public static NotFilter not(Object valueNotToMatch) {
        return NotFilter.not(valueNotToMatch);
    }

    public static String contentOf(File file, Charset charset) {
        return Files.contentOf(file, charset);
    }

    public static String contentOf(File file, String charsetName) {
        return Files.contentOf(file, charsetName);
    }

    public static String contentOf(File file) {
        return Files.contentOf(file, Charset.defaultCharset());
    }

    public static List<String> linesOf(File file) {
        return Files.linesOf(file, Charset.defaultCharset());
    }

    public static List<String> linesOf(File file, Charset charset) {
        return Files.linesOf(file, charset);
    }

    public static List<String> linesOf(File file, String charsetName) {
        return Files.linesOf(file, charsetName);
    }

    public static String contentOf(URL url, Charset charset) {
        return URLs.contentOf(url, charset);
    }

    public static String contentOf(URL url, String charsetName) {
        return URLs.contentOf(url, charsetName);
    }

    public static String contentOf(URL url) {
        return URLs.contentOf(url, Charset.defaultCharset());
    }

    public static List<String> linesOf(URL url) {
        return URLs.linesOf(url, Charset.defaultCharset());
    }

    public static List<String> linesOf(URL url, Charset charset) {
        return URLs.linesOf(url, charset);
    }

    public static List<String> linesOf(URL url, String charsetName) {
        return URLs.linesOf(url, charsetName);
    }

    public static void setLenientDateParsing(boolean value) {
        AbstractDateAssert.setLenientDateParsing(value);
    }

    public static void registerCustomDateFormat(DateFormat userCustomDateFormat) {
        AbstractDateAssert.registerCustomDateFormat(userCustomDateFormat);
    }

    public static void registerCustomDateFormat(String userCustomDateFormatPattern) {
        AbstractDateAssert.registerCustomDateFormat(userCustomDateFormatPattern);
    }

    public static void useDefaultDateFormatsOnly() {
        AbstractDateAssert.useDefaultDateFormatsOnly();
    }

    protected Java6Assertions() {
    }
}

