/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mustangproject.BankDetails;
import org.mustangproject.Contact;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableContact;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableTradeParty;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlement;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementDebit;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TradeParty
implements IZUGFeRDExportableTradeParty {
    protected String name;
    protected String zip;
    protected String street;
    protected String location;
    protected String country;
    protected String taxID = null;
    protected String vatID = null;
    protected String ID = null;
    protected String additionalAddress = null;
    protected List<BankDetails> bankDetails = new ArrayList<BankDetails>();
    protected List<IZUGFeRDTradeSettlementDebit> debitDetails = new ArrayList<IZUGFeRDTradeSettlementDebit>();
    protected Contact contact = null;

    public TradeParty(String name, String street, String zip, String location, String country) {
        this.name = name;
        this.street = street;
        this.zip = zip;
        this.location = location;
        this.country = country;
    }

    public TradeParty(NodeList nodes) {
        if (nodes.getLength() > 0) {
            for (int nodeIndex = 0; nodeIndex < nodes.getLength(); ++nodeIndex) {
                Node currentItemNode = nodes.item(nodeIndex);
                NodeList itemChilds = currentItemNode.getChildNodes();
                for (int itemChildIndex = 0; itemChildIndex < itemChilds.getLength(); ++itemChildIndex) {
                    if (itemChilds.item(itemChildIndex).getLocalName() == null) continue;
                    if (itemChilds.item(itemChildIndex).getLocalName().equals("Name")) {
                        this.setName(itemChilds.item(itemChildIndex).getTextContent());
                    }
                    if (itemChilds.item(itemChildIndex).getLocalName().equals("DefinedTradeContact")) {
                        NodeList contact = itemChilds.item(itemChildIndex).getChildNodes();
                        this.setContact(new Contact(contact));
                    }
                    if (itemChilds.item(itemChildIndex).getLocalName().equals("PostalTradeAddress")) {
                        NodeList postal = itemChilds.item(itemChildIndex).getChildNodes();
                        for (int postalChildIndex = 0; postalChildIndex < postal.getLength(); ++postalChildIndex) {
                            if (postal.item(postalChildIndex).getLocalName() == null) continue;
                            if (postal.item(postalChildIndex).getLocalName().equals("LineOne")) {
                                this.setStreet(postal.item(postalChildIndex).getTextContent());
                            }
                            if (postal.item(postalChildIndex).getLocalName().equals("LineTwo")) {
                                this.setAdditionalAddress(postal.item(postalChildIndex).getTextContent());
                            }
                            if (postal.item(postalChildIndex).getLocalName().equals("CityName")) {
                                this.setLocation(postal.item(postalChildIndex).getTextContent());
                            }
                            if (postal.item(postalChildIndex).getLocalName().equals("PostcodeCode")) {
                                this.setZIP(postal.item(postalChildIndex).getTextContent());
                            }
                            if (!postal.item(postalChildIndex).getLocalName().equals("CountryID")) continue;
                            this.setCountry(postal.item(postalChildIndex).getTextContent());
                        }
                    }
                    if (!itemChilds.item(itemChildIndex).getLocalName().equals("SpecifiedTaxRegistration")) continue;
                    NodeList taxChilds = itemChilds.item(itemChildIndex).getChildNodes();
                    for (int taxChildIndex = 0; taxChildIndex < taxChilds.getLength(); ++taxChildIndex) {
                        if (taxChilds.item(taxChildIndex).getLocalName() == null || !taxChilds.item(taxChildIndex).getLocalName().equals("ID") || taxChilds.item(taxChildIndex).getAttributes().getNamedItem("schemeID") == null) continue;
                        if (taxChilds.item(taxChildIndex).getAttributes().getNamedItem("schemeID").getNodeValue().equals("VA")) {
                            this.setVATID(taxChilds.item(taxChildIndex).getFirstChild().getNodeValue());
                        }
                        if (!taxChilds.item(taxChildIndex).getAttributes().getNamedItem("schemeID").getNodeValue().equals("FC")) continue;
                        this.setTaxID(taxChilds.item(taxChildIndex).getFirstChild().getNodeValue());
                    }
                }
            }
        }
    }

    @Override
    public String getID() {
        return this.ID;
    }

    public TradeParty setID(String ID2) {
        this.ID = ID2;
        return this;
    }

    public TradeParty setContact(Contact c) {
        this.contact = c;
        return this;
    }

    public TradeParty addBankDetails(BankDetails s) {
        this.bankDetails.add(s);
        return this;
    }

    public TradeParty addDebitDetails(IZUGFeRDTradeSettlementDebit debitDetail) {
        this.debitDetails.add(debitDetail);
        return this;
    }

    public List<BankDetails> getBankDetails() {
        return this.bankDetails;
    }

    public TradeParty addTaxID(String taxID) {
        this.taxID = taxID;
        return this;
    }

    public TradeParty addVATID(String vatID) {
        this.vatID = vatID;
        return this;
    }

    @Override
    public String getVATID() {
        return this.vatID;
    }

    public TradeParty setVATID(String VATid) {
        this.vatID = VATid;
        return this;
    }

    @Override
    public String getTaxID() {
        return this.taxID;
    }

    public TradeParty setTaxID(String tax) {
        this.taxID = tax;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TradeParty setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getZIP() {
        return this.zip;
    }

    public TradeParty setZIP(String zip) {
        this.zip = zip;
        return this;
    }

    @Override
    public String getStreet() {
        return this.street;
    }

    public TradeParty setStreet(String street) {
        this.street = street;
        return this;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public TradeParty setLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    public TradeParty setCountry(String country) {
        this.country = country;
        return this;
    }

    public String getVatID() {
        return this.vatID;
    }

    @Override
    public IZUGFeRDExportableContact getContact() {
        return this.contact;
    }

    public IZUGFeRDTradeSettlement[] getAsTradeSettlement() {
        if (this.bankDetails.isEmpty() && this.debitDetails.isEmpty()) {
            return null;
        }
        List tradeSettlements = Stream.concat(this.bankDetails.stream(), this.debitDetails.stream()).map(IZUGFeRDTradeSettlement.class::cast).collect(Collectors.toList());
        IZUGFeRDTradeSettlement[] result = new IZUGFeRDTradeSettlement[tradeSettlements.size()];
        for (int i = 0; i < tradeSettlements.size(); ++i) {
            IZUGFeRDTradeSettlement izugFeRDTradeSettlement;
            result[i] = izugFeRDTradeSettlement = (IZUGFeRDTradeSettlement)tradeSettlements.get(i);
        }
        return result;
    }

    @Override
    public String getAdditionalAddress() {
        return this.additionalAddress;
    }

    public TradeParty setAdditionalAddress(String additionalAddress) {
        this.additionalAddress = additionalAddress;
        return this;
    }
}

