/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.math.BigDecimal;

public interface IZUGFeRDExportableProduct {
    public String getUnit();

    public String getName();

    public String getDescription();

    default public String getSellerAssignedID() {
        return null;
    }

    default public String getBuyerAssignedID() {
        return null;
    }

    public BigDecimal getVATPercent();

    default public boolean isIntraCommunitySupply() {
        return false;
    }

    default public boolean isReverseCharge() {
        return false;
    }

    default public String getTaxCategoryCode() {
        if (this.isIntraCommunitySupply()) {
            return "K";
        }
        if (this.isReverseCharge()) {
            return "AE";
        }
        if (this.getVATPercent().compareTo(BigDecimal.ZERO) == 0) {
            return "Z";
        }
        return "S";
    }

    default public String getTaxExemptionReason() {
        if (this.isIntraCommunitySupply()) {
            return "Intra-community supply";
        }
        if (this.isReverseCharge()) {
            return "Reverse Charge";
        }
        return null;
    }
}

