/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.math.BigDecimal;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;

public class LineCalculator {
    private BigDecimal price;
    private BigDecimal priceGross;
    private BigDecimal itemTotalNetAmount;
    private BigDecimal itemTotalVATAmount;
    private BigDecimal allowance = BigDecimal.ZERO;
    private BigDecimal charge = BigDecimal.ZERO;

    public LineCalculator(IZUGFeRDExportableItem currentItem) {
        if (currentItem.getItemAllowances() != null && currentItem.getItemAllowances().length > 0) {
            for (IZUGFeRDAllowanceCharge allowance : currentItem.getItemAllowances()) {
                this.addAllowance(allowance.getTotalAmount(currentItem));
            }
        }
        if (currentItem.getItemCharges() != null && currentItem.getItemCharges().length > 0) {
            for (IZUGFeRDAllowanceCharge charge : currentItem.getItemCharges()) {
                this.addCharge(charge.getTotalAmount(currentItem));
            }
        }
        BigDecimal multiplicator = currentItem.getProduct().getVATPercent().divide(BigDecimal.valueOf(100L));
        this.priceGross = currentItem.getPrice();
        this.price = this.priceGross.subtract(this.allowance).add(this.charge);
        this.itemTotalNetAmount = currentItem.getQuantity().multiply(this.getPrice()).divide(currentItem.getBasisQuantity()).setScale(2, 4);
        this.itemTotalVATAmount = this.itemTotalNetAmount.multiply(multiplicator);
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getItemTotalNetAmount() {
        return this.itemTotalNetAmount;
    }

    public BigDecimal getItemTotalVATAmount() {
        return this.itemTotalVATAmount;
    }

    public BigDecimal getItemTotalGrossAmount() {
        return this.itemTotalNetAmount;
    }

    public BigDecimal getPriceGross() {
        return this.priceGross;
    }

    public void addAllowance(BigDecimal b) {
        this.allowance = this.allowance.add(b);
    }

    public void addCharge(BigDecimal b) {
        this.charge = this.charge.add(b);
    }
}

