/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IXMLProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentDiscountTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlement;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementDebit;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementPayment;
import org.mustangproject.ZUGFeRD.LineCalculator;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.TransactionCalculator;
import org.mustangproject.ZUGFeRD.VATAmount;
import org.mustangproject.ZUGFeRD.ZUGFeRD2PullProvider;
import org.mustangproject.ZUGFeRD.ZUGFeRDDateFormat;
import org.mustangproject.ZUGFeRD.model.TaxCategoryCodeTypeConstants;

public class ZUGFeRD1PullProvider
extends ZUGFeRD2PullProvider
implements IXMLProvider {
    protected byte[] zugferdData;
    private String paymentTermsDescription;
    protected Profile profile = Profiles.getByName("COMFORT", 1);

    @Override
    public void setTest() {
    }

    private String vatFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 2);
    }

    private String currencyFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 2);
    }

    private String priceFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 4);
    }

    private String quantityFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 4);
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public byte[] getXML() {
        byte[] res = this.zugferdData;
        StringWriter sw = new StringWriter();
        Document document = null;
        try {
            document = DocumentHelper.parseText(new String(this.zugferdData));
        }
        catch (DocumentException e1) {
            Logger.getLogger(ZUGFeRD1PullProvider.class.getName()).log(Level.SEVERE, null, e1);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(sw, format);
            writer.write(document);
            res = sw.toString().getBytes("UTF-8");
        }
        catch (IOException e) {
            Logger.getLogger(ZUGFeRD1PullProvider.class.getName()).log(Level.SEVERE, null, e);
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generateXML(IExportableTransaction trans) {
        this.trans = trans;
        this.calc = new TransactionCalculator(trans);
        boolean hasDueDate = false;
        SimpleDateFormat germanDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        String exemptionReason = "";
        if (trans.getPaymentTermDescription() != null) {
            this.paymentTermsDescription = trans.getPaymentTermDescription();
        }
        if (this.paymentTermsDescription == null) {
            this.paymentTermsDescription = "Zahlbar ohne Abzug bis " + germanDateFormat.format(trans.getDueDate());
        }
        String senderReg = "";
        if (trans.getOwnOrganisationFullPlaintextInfo() != null) {
            senderReg = "<ram:IncludedNote>\n\t\t<ram:Content>\n" + XMLTools.encodeXML(trans.getOwnOrganisationFullPlaintextInfo()) + "\t\t</ram:Content>\n<ram:SubjectCode>REG</ram:SubjectCode>\n</ram:IncludedNote>\n";
        }
        String rebateAgreement = "";
        if (trans.rebateAgreementExists()) {
            rebateAgreement = "<ram:IncludedNote>\n\t\t<ram:Content>Es bestehen Rabatt- und Bonusvereinbarungen.</ram:Content>\n<ram:SubjectCode>AAK</ram:SubjectCode>\n</ram:IncludedNote>\n";
        }
        String subjectNote = "";
        if (trans.getSubjectNote() != null) {
            subjectNote = "<ram:IncludedNote>\n\t\t<ram:Content>" + XMLTools.encodeXML(trans.getSubjectNote()) + "</ram:Content>\n</ram:IncludedNote>\n";
        }
        String typecode = "380";
        if (trans.getDocumentCode() != null) {
            typecode = trans.getDocumentCode();
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<rsm:CrossIndustryDocument xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:rsm=\"urn:ferd:CrossIndustryDocument:invoice:1p0\" xmlns:ram=\"urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:12\" xmlns:udt=\"urn:un:unece:uncefact:data:standard:UnqualifiedDataType:15\">\n\t<rsm:SpecifiedExchangedDocumentContext>\n\t\t<ram:GuidelineSpecifiedDocumentContextParameter>\n\t\t\t<ram:ID>" + this.getProfile().getID() + "</ram:ID>\n\t\t</ram:GuidelineSpecifiedDocumentContextParameter>\n\t</rsm:SpecifiedExchangedDocumentContext>\n\t<rsm:HeaderExchangedDocument>\n\t\t<ram:ID>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:ID>\n     <ram:Name>RECHNUNG</ram:Name>\n\t\t<ram:TypeCode>" + typecode + "</ram:TypeCode>\n\t\t<ram:IssueDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getIssueDate()) + "</ram:IssueDateTime>\n" + subjectNote + rebateAgreement + senderReg + "\t</rsm:HeaderExchangedDocument>\n\t<rsm:SpecifiedSupplyChainTradeTransaction>\n";
        xml = xml + "\t\t<ram:ApplicableSupplyChainTradeAgreement>\n";
        if (trans.getReferenceNumber() != null) {
            xml = xml + "\t\t\t<ram:BuyerReference>" + XMLTools.encodeXML(trans.getReferenceNumber()) + "</ram:BuyerReference>\n";
        }
        xml = xml + "\t\t\t<ram:SellerTradeParty>\n";
        xml = xml + this.getTradePartyAsXML(trans.getSender(), true, false);
        xml = xml + "\t\t\t</ram:SellerTradeParty>\n\t\t\t<ram:BuyerTradeParty>\n";
        xml = xml + this.getTradePartyAsXML(trans.getRecipient(), false, false);
        if (trans.getOwnVATID() != null && trans.getOwnOrganisationName() != null) {
            xml = xml + "            <ram:SpecifiedTaxRegistration>\n               <ram:ID schemeID=\"VA\">" + XMLTools.encodeXML(trans.getOwnVATID()) + "</ram:ID>\n            </ram:SpecifiedTaxRegistration>";
        }
        xml = xml + "\t\t\t</ram:BuyerTradeParty>\n";
        if (trans.getSellerOrderReferencedDocumentID() != null) {
            xml = xml + "   <ram:SellerOrderReferencedDocument>\n       <ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getSellerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID>\n   </ram:SellerOrderReferencedDocument>\n";
        }
        if (trans.getBuyerOrderReferencedDocumentID() != null) {
            xml = xml + "   <ram:BuyerOrderReferencedDocument>\n       <ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getBuyerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID>\n   </ram:BuyerOrderReferencedDocument>\n";
        }
        xml = xml + "\t\t</ram:ApplicableSupplyChainTradeAgreement>\n\t\t<ram:ApplicableSupplyChainTradeDelivery>\n";
        if (this.trans.getDeliveryAddress() != null) {
            xml = xml + "<ram:ShipToTradeParty>" + this.getTradePartyAsXML(this.trans.getDeliveryAddress(), false, true) + "</ram:ShipToTradeParty>";
        }
        xml = xml + "\t\t\t<ram:ActualDeliverySupplyChainEvent>\n\t\t\t\t<ram:OccurrenceDateTime>";
        if (trans.getDeliveryDate() == null) {
            throw new IllegalStateException("No delivery date provided");
        }
        xml = xml + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDeliveryDate());
        xml = xml + "</ram:OccurrenceDateTime>\n";
        xml = xml + "\t\t\t</ram:ActualDeliverySupplyChainEvent>\n\t\t</ram:ApplicableSupplyChainTradeDelivery>\n\t\t<ram:ApplicableSupplyChainTradeSettlement>\n\t\t\t<ram:PaymentReference>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:PaymentReference>\n\t\t\t<ram:InvoiceCurrencyCode>" + trans.getCurrency() + "</ram:InvoiceCurrencyCode>\n";
        if (trans.getTradeSettlementPayment() != null) {
            for (IZUGFeRDTradeSettlement iZUGFeRDTradeSettlement : trans.getTradeSettlementPayment()) {
                if (iZUGFeRDTradeSettlement == null) continue;
                hasDueDate = true;
                xml = xml + iZUGFeRDTradeSettlement.getSettlementXML();
            }
        }
        if (trans.getTradeSettlement() != null) {
            for (IZUGFeRDTradeSettlement iZUGFeRDTradeSettlement : trans.getTradeSettlement()) {
                if (iZUGFeRDTradeSettlement == null) continue;
                if (iZUGFeRDTradeSettlement instanceof IZUGFeRDTradeSettlementPayment) {
                    hasDueDate = true;
                }
                xml = xml + iZUGFeRDTradeSettlement.getSettlementXML();
            }
        }
        HashMap<BigDecimal, VATAmount> VATPercentAmountMap = this.calc.getVATPercentAmountMap();
        for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
            VATAmount vATAmount = VATPercentAmountMap.get(currentTaxPercent);
            if (vATAmount == null) continue;
            String amountCategoryCode = vATAmount.getCategoryCode();
            boolean displayExemptionReason = TaxCategoryCodeTypeConstants.CATEGORY_CODES_WITH_EXEMPTION_REASON.contains(amountCategoryCode);
            xml = xml + "\t\t\t<ram:ApplicableTradeTax>\n\t\t\t\t<ram:CalculatedAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(vATAmount.getCalculated()) + "</ram:CalculatedAmount>\n\t\t\t\t<ram:TypeCode>VAT</ram:TypeCode>\n" + (displayExemptionReason ? exemptionReason : "") + "\t\t\t\t<ram:BasisAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(vATAmount.getBasis()) + "</ram:BasisAmount>\n\t\t\t\t<ram:CategoryCode>" + vATAmount.getCategoryCode() + "</ram:CategoryCode>\n\t\t\t\t<ram:ApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:ApplicablePercent>\n\t\t\t</ram:ApplicableTradeTax>\n";
        }
        if (trans.getPaymentTerms() == null) {
            xml = xml + "\t\t\t<ram:SpecifiedTradePaymentTerms>\n\t\t\t\t<ram:Description>" + this.paymentTermsDescription + "</ram:Description>\n";
            if (trans.getTradeSettlement() != null) {
                void var13_23;
                IZUGFeRDTradeSettlement[] iZUGFeRDTradeSettlementArray = trans.getTradeSettlement();
                int currentTaxPercent = iZUGFeRDTradeSettlementArray.length;
                boolean bl = false;
                while (var13_23 < currentTaxPercent) {
                    IZUGFeRDTradeSettlement payment = iZUGFeRDTradeSettlementArray[var13_23];
                    if (payment != null && payment instanceof IZUGFeRDTradeSettlementDebit) {
                        xml = xml + payment.getPaymentXML();
                    }
                    ++var13_23;
                }
            }
            if (hasDueDate && trans.getDueDate() != null) {
                xml = xml + "\t\t\t\t<ram:DueDateDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDueDate()) + "</ram:DueDateDateTime>\n";
            }
            xml = xml + "\t\t\t</ram:SpecifiedTradePaymentTerms>\n";
        } else {
            xml = xml + this.buildPaymentTermsXml();
        }
        xml = xml + "\t\t\t<ram:SpecifiedTradeSettlementMonetarySummation>\n\t\t\t\t<ram:LineTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getTotal()) + "</ram:LineTotalAmount>\n\t\t\t\t<ram:ChargeTotalAmount currencyID=\"" + trans.getCurrency() + "\">0.00</ram:ChargeTotalAmount>\n\t\t\t\t<ram:AllowanceTotalAmount currencyID=\"" + trans.getCurrency() + "\">0.00</ram:AllowanceTotalAmount>\n\t\t\t\t<ram:TaxBasisTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getTotal()) + "</ram:TaxBasisTotalAmount>\n\t\t\t\t<ram:TaxTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getGrandTotal().subtract(this.calc.getTotal())) + "</ram:TaxTotalAmount>\n\t\t\t\t<ram:GrandTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getGrandTotal()) + "</ram:GrandTotalAmount>\n             <ram:TotalPrepaidAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getTotalPrepaid()) + "</ram:TotalPrepaidAmount>\n\t\t\t\t<ram:DuePayableAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getGrandTotal().subtract(this.calc.getTotalPrepaid())) + "</ram:DuePayableAmount>\n\t\t\t</ram:SpecifiedTradeSettlementMonetarySummation>\n\t\t</ram:ApplicableSupplyChainTradeSettlement>\n";
        int lineID = 0;
        for (IZUGFeRDExportableItem currentItem : trans.getZFItems()) {
            ++lineID;
            if (currentItem.getProduct().getTaxExemptionReason() != null) {
                exemptionReason = "<ram:ExemptionReason>" + XMLTools.encodeXML(currentItem.getProduct().getTaxExemptionReason()) + "</ram:ExemptionReason>";
            }
            LineCalculator lc = new LineCalculator(currentItem);
            xml = xml + "\t\t<ram:IncludedSupplyChainTradeLineItem>\n\t\t\t<ram:AssociatedDocumentLineDocument>\n\t\t\t\t<ram:LineID>" + lineID + "</ram:LineID>\n\t\t\t</ram:AssociatedDocumentLineDocument>\n\t\t\t<ram:SpecifiedSupplyChainTradeAgreement>\n\t\t\t\t<ram:GrossPriceProductTradePrice>\n\t\t\t\t\t<ram:ChargeAmount currencyID=\"" + trans.getCurrency() + "\">" + this.priceFormat(lc.getPriceGross()) + "</ram:ChargeAmount>\n\t\t\t\t\t<ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getBasisQuantity()) + "</ram:BasisQuantity>\n\t\t\t\t</ram:GrossPriceProductTradePrice>\n\t\t\t\t<ram:NetPriceProductTradePrice>\n\t\t\t\t\t<ram:ChargeAmount currencyID=\"" + trans.getCurrency() + "\">" + this.priceFormat(currentItem.getPrice()) + "</ram:ChargeAmount>\n\t\t\t\t\t<ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getBasisQuantity()) + "</ram:BasisQuantity>\n\t\t\t\t</ram:NetPriceProductTradePrice>\n\t\t\t</ram:SpecifiedSupplyChainTradeAgreement>\n\t\t\t<ram:SpecifiedSupplyChainTradeDelivery>\n\t\t\t\t<ram:BilledQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getQuantity()) + "</ram:BilledQuantity>\n\t\t\t</ram:SpecifiedSupplyChainTradeDelivery>\n\t\t\t<ram:SpecifiedSupplyChainTradeSettlement>\n\t\t\t\t<ram:ApplicableTradeTax>\n\t\t\t\t\t<ram:TypeCode>VAT</ram:TypeCode>\n" + exemptionReason + "\t\t\t\t\t<ram:CategoryCode>" + currentItem.getProduct().getTaxCategoryCode() + "</ram:CategoryCode>\n\t\t\t\t\t<ram:ApplicablePercent>" + this.vatFormat(currentItem.getProduct().getVATPercent()) + "</ram:ApplicablePercent>\n\t\t\t\t</ram:ApplicableTradeTax>\n\t\t\t\t<ram:SpecifiedTradeSettlementMonetarySummation>\n\t\t\t\t\t<ram:LineTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(lc.getItemTotalNetAmount()) + "</ram:LineTotalAmount>\n\t\t\t\t</ram:SpecifiedTradeSettlementMonetarySummation>\n";
            if (currentItem.getAdditionalReferencedDocumentID() != null) {
                xml = xml + "\t\t\t<ram:AdditionalReferencedDocument><ram:ID>" + currentItem.getAdditionalReferencedDocumentID() + "</ram:ID><ram:TypeCode>130</ram:TypeCode></ram:AdditionalReferencedDocument>\n";
            }
            xml = xml + "\t\t\t</ram:SpecifiedSupplyChainTradeSettlement>\n\t\t\t<ram:SpecifiedTradeProduct>\n";
            if (currentItem.getProduct().getSellerAssignedID() != null) {
                xml = xml + "\t\t\t\t<ram:SellerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getSellerAssignedID()) + "</ram:SellerAssignedID>\n";
            }
            if (currentItem.getProduct().getBuyerAssignedID() != null) {
                xml = xml + "\t\t\t\t<ram:BuyerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getBuyerAssignedID()) + "</ram:BuyerAssignedID>\n";
            }
            xml = xml + "\t\t\t\t\t<ram:Name>" + XMLTools.encodeXML(currentItem.getProduct().getName()) + "</ram:Name>\n\t\t\t\t<ram:Description>" + XMLTools.encodeXML(currentItem.getProduct().getDescription()) + "</ram:Description>\n\t\t\t</ram:SpecifiedTradeProduct>\n\t\t</ram:IncludedSupplyChainTradeLineItem>\n";
        }
        xml = xml + "\t</rsm:SpecifiedSupplyChainTradeTransaction>\n</rsm:CrossIndustryDocument>";
        try {
            byte[] zugferdRaw = xml.getBytes("UTF-8");
            this.zugferdData = XMLTools.removeBOM(zugferdRaw);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(ZUGFeRD1PullProvider.class.getName()).log(Level.SEVERE, null, unsupportedEncodingException);
        }
    }

    @Override
    public void setProfile(Profile p) {
        this.profile = p;
    }

    private String buildPaymentTermsXml() {
        String paymentTermsXml = "<ram:SpecifiedTradePaymentTerms>";
        IZUGFeRDPaymentTerms paymentTerms = this.trans.getPaymentTerms();
        IZUGFeRDPaymentDiscountTerms discountTerms = paymentTerms.getDiscountTerms();
        Date dueDate = paymentTerms.getDueDate();
        if (dueDate != null && discountTerms != null && discountTerms.getBaseDate() != null) {
            throw new IllegalStateException("if paymentTerms.dueDate is specified, paymentTerms.discountTerms.baseDate has not to be specified");
        }
        paymentTermsXml = paymentTermsXml + "<ram:Description>" + paymentTerms.getDescription() + "</ram:Description>";
        if (dueDate != null) {
            paymentTermsXml = paymentTermsXml + "<ram:DueDateDateTime>";
            paymentTermsXml = paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(dueDate);
            paymentTermsXml = paymentTermsXml + "</ram:DueDateDateTime>";
        }
        if (discountTerms != null) {
            paymentTermsXml = paymentTermsXml + "<ram:ApplicableTradePaymentDiscountTerms>";
            String currency = this.trans.getCurrency();
            String basisAmount = this.currencyFormat(this.calc.getGrandTotal());
            paymentTermsXml = paymentTermsXml + "<ram:BasisAmount currencyID=\"" + currency + "\">" + basisAmount + "</ram:BasisAmount>";
            paymentTermsXml = paymentTermsXml + "<ram:CalculationPercent>" + discountTerms.getCalculationPercentage().toString() + "</ram:CalculationPercent>";
            if (discountTerms.getBaseDate() != null) {
                Date baseDate = discountTerms.getBaseDate();
                paymentTermsXml = paymentTermsXml + "<ram:BasisDateTime>";
                paymentTermsXml = paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(baseDate);
                paymentTermsXml = paymentTermsXml + "</ram:BasisDateTime>";
                paymentTermsXml = paymentTermsXml + "<ram:BasisPeriodMeasure unitCode=\"" + discountTerms.getBasePeriodUnitCode() + "\">" + discountTerms.getBasePeriodMeasure() + "</ram:BasisPeriodMeasure>";
            }
            paymentTermsXml = paymentTermsXml + "</ram:ApplicableTradePaymentDiscountTerms>";
        }
        paymentTermsXml = paymentTermsXml + "</ram:SpecifiedTradePaymentTerms>";
        return paymentTermsXml;
    }
}

