/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mustangproject.FileAttachment;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IAbsoluteValueProvider;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IReferencedDocument;
import org.mustangproject.ZUGFeRD.IXMLProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableTradeParty;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentDiscountTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlement;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementDebit;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementPayment;
import org.mustangproject.ZUGFeRD.LineCalculator;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.TransactionCalculator;
import org.mustangproject.ZUGFeRD.VATAmount;
import org.mustangproject.ZUGFeRD.ZUGFeRDDateFormat;
import org.mustangproject.ZUGFeRD.model.TaxCategoryCodeTypeConstants;

public class ZUGFeRD2PullProvider
implements IXMLProvider {
    protected byte[] zugferdData;
    protected IExportableTransaction trans;
    protected TransactionCalculator calc;
    private String paymentTermsDescription;
    protected Profile profile = Profiles.getByName("EN16931");

    @Override
    public void setTest() {
    }

    private String vatFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 2);
    }

    private String currencyFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 2);
    }

    private String priceFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 4);
    }

    private String quantityFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 4);
    }

    @Override
    public byte[] getXML() {
        byte[] res = this.zugferdData;
        StringWriter sw = new StringWriter();
        Document document = null;
        try {
            document = DocumentHelper.parseText(new String(this.zugferdData));
        }
        catch (DocumentException e1) {
            Logger.getLogger(ZUGFeRD2PullProvider.class.getName()).log(Level.SEVERE, null, e1);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(sw, format);
            writer.write(document);
            res = sw.toString().getBytes("UTF-8");
        }
        catch (IOException e) {
            Logger.getLogger(ZUGFeRD2PullProvider.class.getName()).log(Level.SEVERE, null, e);
        }
        return res;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    protected String getTradePartyAsXML(IZUGFeRDExportableTradeParty party, boolean isSender, boolean isShipToTradeParty) {
        String xml = "";
        if (party.getID() != null) {
            xml = xml + "\t<ram:ID>" + XMLTools.encodeXML(party.getID()) + "</ram:ID>\n";
        } else if (party.getGlobalIDScheme() != null && party.getGlobalID() != null) {
            xml = xml + "           <ram:GlobalID schemeID=\"" + XMLTools.encodeXML(party.getGlobalIDScheme()) + "\">" + XMLTools.encodeXML(party.getGlobalID()) + "</ram:GlobalID>\n";
        }
        xml = xml + "\t<ram:Name>" + XMLTools.encodeXML(party.getName()) + "</ram:Name>\n";
        if (party.getContact() != null && (isSender || this.profile == Profiles.getByName("Extended") || this.profile == Profiles.getByName("XRechnung"))) {
            xml = xml + "<ram:DefinedTradeContact>\n";
            if (party.getContact().getPhone() != null) {
                xml = xml + "<ram:PersonName>" + XMLTools.encodeXML(party.getContact().getName()) + "</ram:PersonName>\n";
            }
            if (party.getContact().getPhone() != null) {
                xml = xml + "     <ram:TelephoneUniversalCommunication>\n        <ram:CompleteNumber>" + XMLTools.encodeXML(party.getContact().getPhone()) + "</ram:CompleteNumber>\n     </ram:TelephoneUniversalCommunication>\n";
            }
            if (party.getContact().getFax() != null && this.profile == Profiles.getByName("Extended")) {
                xml = xml + "     <ram:FaxUniversalCommunication>\n        <ram:CompleteNumber>" + XMLTools.encodeXML(party.getContact().getFax()) + "</ram:CompleteNumber>\n     </ram:FaxUniversalCommunication>\n";
            }
            if (party.getContact().getEMail() != null) {
                xml = xml + "     <ram:EmailURIUniversalCommunication>\n        <ram:URIID>" + XMLTools.encodeXML(party.getContact().getEMail()) + "</ram:URIID>\n     </ram:EmailURIUniversalCommunication>\n";
            }
            xml = xml + "  </ram:DefinedTradeContact>";
        }
        xml = xml + "\t\t\t\t<ram:PostalTradeAddress>\n\t\t\t\t\t<ram:PostcodeCode>" + XMLTools.encodeXML(party.getZIP()) + "</ram:PostcodeCode>\n";
        if (party.getStreet() != null) {
            xml = xml + "\t\t\t\t\t<ram:LineOne>" + XMLTools.encodeXML(party.getStreet()) + "</ram:LineOne>\n";
        }
        if (party.getAdditionalAddress() != null) {
            xml = xml + "\t\t\t\t<ram:LineTwo>" + XMLTools.encodeXML(party.getAdditionalAddress()) + "</ram:LineTwo>\n";
        }
        xml = xml + "\t\t\t\t\t<ram:CityName>" + XMLTools.encodeXML(party.getLocation()) + "</ram:CityName>\n\t\t\t\t\t<ram:CountryID>" + XMLTools.encodeXML(party.getCountry()) + "</ram:CountryID>\n\t\t\t\t</ram:PostalTradeAddress>\n";
        if (party.getVATID() != null && !isShipToTradeParty) {
            xml = xml + "\t\t\t\t<ram:SpecifiedTaxRegistration>\n\t\t\t\t\t<ram:ID schemeID=\"VA\">" + XMLTools.encodeXML(party.getVATID()) + "</ram:ID>\n\t\t\t\t</ram:SpecifiedTaxRegistration>\n";
        }
        if (party.getTaxID() != null && !isShipToTradeParty) {
            xml = xml + "\t\t\t\t<ram:SpecifiedTaxRegistration>\n\t\t\t\t\t<ram:ID schemeID=\"FC\">" + XMLTools.encodeXML(party.getTaxID()) + "</ram:ID>\n\t\t\t\t</ram:SpecifiedTaxRegistration>\n";
        }
        return xml;
    }

    protected String getAllowanceChargeStr(IZUGFeRDAllowanceCharge allowance, IAbsoluteValueProvider item) {
        String percentage = "";
        String chargeIndicator = "false";
        if (allowance.getPercent() != null && this.profile == Profiles.getByName("Extended")) {
            percentage = "<ram:CalculationPercent>" + this.vatFormat(allowance.getPercent()) + "</ram:CalculationPercent>";
            percentage = percentage + "<ram:BasisAmount>" + item.getValue() + "</ram:BasisAmount>";
        }
        if (allowance.isCharge()) {
            chargeIndicator = "true";
        }
        String reason = "";
        if (allowance.getReason() != null && this.profile == Profiles.getByName("Extended")) {
            reason = "<ram:Reason>" + XMLTools.encodeXML(allowance.getReason()) + "</ram:Reason>";
        }
        String allowanceChargeStr = "<ram:AppliedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>" + chargeIndicator + "</udt:Indicator></ram:ChargeIndicator>" + percentage + "<ram:ActualAmount>" + this.priceFormat(allowance.getTotalAmount(item)) + "</ram:ActualAmount>" + reason + "</ram:AppliedTradeAllowanceCharge>";
        return allowanceChargeStr;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generateXML(IExportableTransaction trans) {
        this.trans = trans;
        this.calc = new TransactionCalculator(trans);
        boolean hasDueDate = false;
        SimpleDateFormat germanDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        String exemptionReason = "";
        if (trans.getPaymentTermDescription() != null) {
            this.paymentTermsDescription = trans.getPaymentTermDescription();
        }
        if (this.paymentTermsDescription == null && trans.getDocumentCode() != "384") {
            this.paymentTermsDescription = "Zahlbar ohne Abzug bis " + germanDateFormat.format(trans.getDueDate());
        }
        String senderReg = "";
        if (trans.getOwnOrganisationFullPlaintextInfo() != null) {
            senderReg = "<ram:IncludedNote>\n\t\t<ram:Content>\n" + XMLTools.encodeXML(trans.getOwnOrganisationFullPlaintextInfo()) + "\t\t</ram:Content>\n<ram:SubjectCode>REG</ram:SubjectCode>\n</ram:IncludedNote>\n";
        }
        String rebateAgreement = "";
        if (trans.rebateAgreementExists()) {
            rebateAgreement = "<ram:IncludedNote>\n\t\t<ram:Content>Es bestehen Rabatt- und Bonusvereinbarungen.</ram:Content>\n<ram:SubjectCode>AAK</ram:SubjectCode>\n</ram:IncludedNote>\n";
        }
        String subjectNote = "";
        if (trans.getSubjectNote() != null) {
            subjectNote = "<ram:IncludedNote>\n\t\t<ram:Content>" + XMLTools.encodeXML(trans.getSubjectNote()) + "</ram:Content>\n</ram:IncludedNote>\n";
        }
        String typecode = "380";
        if (trans.getDocumentCode() != null) {
            typecode = trans.getDocumentCode();
        }
        String notes = "";
        if (trans.getNotes() != null) {
            for (String currentNote : trans.getNotes()) {
                notes = notes + "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(currentNote) + "</ram:Content></ram:IncludedNote>";
            }
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<rsm:CrossIndustryInvoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:rsm=\"urn:un:unece:uncefact:data:standard:CrossIndustryInvoice:100\" xmlns:ram=\"urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100\" xmlns:udt=\"urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100\" xmlns:qdt=\"urn:un:unece:uncefact:data:standard:QualifiedDataType:100\">\n\t<rsm:ExchangedDocumentContext>\n\t\t<ram:GuidelineSpecifiedDocumentContextParameter>\n\t\t\t<ram:ID>" + this.getProfile().getID() + "</ram:ID>\n\t\t</ram:GuidelineSpecifiedDocumentContextParameter>\n\t</rsm:ExchangedDocumentContext>\n\t<rsm:ExchangedDocument>\n\t\t<ram:ID>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:ID>\n\t\t<ram:TypeCode>" + typecode + "</ram:TypeCode>\n\t\t<ram:IssueDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getIssueDate()) + "</ram:IssueDateTime>\n" + notes + subjectNote + rebateAgreement + senderReg + "\t</rsm:ExchangedDocument>\n\t<rsm:SupplyChainTradeTransaction>\n";
        int lineID = 0;
        for (IZUGFeRDExportableItem iZUGFeRDExportableItem : trans.getZFItems()) {
            int n;
            ++lineID;
            if (iZUGFeRDExportableItem.getProduct().getTaxExemptionReason() != null) {
                exemptionReason = "<ram:ExemptionReason>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getTaxExemptionReason()) + "</ram:ExemptionReason>";
            }
            notes = "";
            if (iZUGFeRDExportableItem.getNotes() != null) {
                for (String currentNote : iZUGFeRDExportableItem.getNotes()) {
                    notes = notes + "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(currentNote) + "</ram:Content></ram:IncludedNote>";
                }
            }
            LineCalculator lc = new LineCalculator(iZUGFeRDExportableItem);
            xml = xml + "\t\t<ram:IncludedSupplyChainTradeLineItem>\n\t\t\t<ram:AssociatedDocumentLineDocument>\n\t\t\t\t<ram:LineID>" + lineID + "</ram:LineID>\n" + notes + "\t\t\t</ram:AssociatedDocumentLineDocument>\n\t\t\t<ram:SpecifiedTradeProduct>\n";
            if (iZUGFeRDExportableItem.getProduct().getSellerAssignedID() != null) {
                xml = xml + "\t\t\t\t<ram:SellerAssignedID>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getSellerAssignedID()) + "</ram:SellerAssignedID>\n";
            }
            if (iZUGFeRDExportableItem.getProduct().getBuyerAssignedID() != null) {
                xml = xml + "\t\t\t\t<ram:BuyerAssignedID>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getBuyerAssignedID()) + "</ram:BuyerAssignedID>\n";
            }
            String allowanceChargeStr = "";
            if (iZUGFeRDExportableItem.getItemAllowances() != null && iZUGFeRDExportableItem.getItemAllowances().length > 0) {
                IZUGFeRDAllowanceCharge[] iZUGFeRDAllowanceChargeArray = iZUGFeRDExportableItem.getItemAllowances();
                int n2 = iZUGFeRDAllowanceChargeArray.length;
                for (n = 0; n < n2; ++n) {
                    IZUGFeRDAllowanceCharge allowance = iZUGFeRDAllowanceChargeArray[n];
                    allowanceChargeStr = allowanceChargeStr + this.getAllowanceChargeStr(allowance, iZUGFeRDExportableItem);
                }
            }
            if (iZUGFeRDExportableItem.getItemCharges() != null && iZUGFeRDExportableItem.getItemCharges().length > 0) {
                IZUGFeRDAllowanceCharge[] iZUGFeRDAllowanceChargeArray = iZUGFeRDExportableItem.getItemCharges();
                int n3 = iZUGFeRDAllowanceChargeArray.length;
                for (n = 0; n < n3; ++n) {
                    IZUGFeRDAllowanceCharge charge = iZUGFeRDAllowanceChargeArray[n];
                    allowanceChargeStr = allowanceChargeStr + this.getAllowanceChargeStr(charge, iZUGFeRDExportableItem);
                }
            }
            xml = xml + "\t\t\t\t\t<ram:Name>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getName()) + "</ram:Name>\n\t\t\t\t<ram:Description>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getDescription()) + "</ram:Description>\n\t\t\t</ram:SpecifiedTradeProduct>\n\t\t\t<ram:SpecifiedLineTradeAgreement>\n";
            if (iZUGFeRDExportableItem.getReferencedDocuments() != null) {
                IReferencedDocument[] iReferencedDocumentArray = iZUGFeRDExportableItem.getReferencedDocuments();
                int n4 = iReferencedDocumentArray.length;
                for (n = 0; n < n4; ++n) {
                    IReferencedDocument currentReferencedDocument = iReferencedDocumentArray[n];
                    xml = xml + "<ram:AdditionalReferencedDocument>\n<ram:IssuerAssignedID>" + XMLTools.encodeXML(currentReferencedDocument.getIssuerAssignedID()) + "</ram:IssuerAssignedID>\n<ram:TypeCode>" + XMLTools.encodeXML(currentReferencedDocument.getTypeCode()) + "</ram:TypeCode>\n<ram:ReferenceTypeCode>" + XMLTools.encodeXML(currentReferencedDocument.getReferenceTypeCode()) + "</ram:ReferenceTypeCode>\n</ram:AdditionalReferencedDocument>\n";
                }
            }
            if (iZUGFeRDExportableItem.getBuyerOrderReferencedDocumentLineID() != null) {
                xml = xml + "\t\t\t\t<ram:BuyerOrderReferencedDocument> \n\t\t\t\t\t<ram:LineID>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getBuyerOrderReferencedDocumentLineID()) + "</ram:LineID>\n\t\t\t\t</ram:BuyerOrderReferencedDocument>\n";
            }
            xml = xml + "\t\t\t\t<ram:GrossPriceProductTradePrice>\n\t\t\t\t\t<ram:ChargeAmount>" + this.priceFormat(lc.getPriceGross()) + "</ram:ChargeAmount>\n<ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getUnit()) + "\">" + this.quantityFormat(iZUGFeRDExportableItem.getBasisQuantity()) + "</ram:BasisQuantity>\n" + allowanceChargeStr + "\t\t\t\t</ram:GrossPriceProductTradePrice>\n\t\t\t\t<ram:NetPriceProductTradePrice>\n\t\t\t\t\t<ram:ChargeAmount>" + this.priceFormat(lc.getPrice()) + "</ram:ChargeAmount>\n\t\t\t\t\t<ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getUnit()) + "\">" + this.quantityFormat(iZUGFeRDExportableItem.getBasisQuantity()) + "</ram:BasisQuantity>\n\t\t\t\t</ram:NetPriceProductTradePrice>\n\t\t\t</ram:SpecifiedLineTradeAgreement>\n\t\t\t<ram:SpecifiedLineTradeDelivery>\n\t\t\t\t<ram:BilledQuantity unitCode=\"" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getUnit()) + "\">" + this.quantityFormat(iZUGFeRDExportableItem.getQuantity()) + "</ram:BilledQuantity>\n\t\t\t</ram:SpecifiedLineTradeDelivery>\n\t\t\t<ram:SpecifiedLineTradeSettlement>\n\t\t\t\t<ram:ApplicableTradeTax>\n\t\t\t\t\t<ram:TypeCode>VAT</ram:TypeCode>\n" + exemptionReason + "\t\t\t\t\t<ram:CategoryCode>" + iZUGFeRDExportableItem.getProduct().getTaxCategoryCode() + "</ram:CategoryCode>\n\t\t\t\t\t<ram:RateApplicablePercent>" + this.vatFormat(iZUGFeRDExportableItem.getProduct().getVATPercent()) + "</ram:RateApplicablePercent>\n\t\t\t\t</ram:ApplicableTradeTax>\n";
            if (iZUGFeRDExportableItem.getDetailedDeliveryPeriodFrom() != null || iZUGFeRDExportableItem.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:BillingSpecifiedPeriod>";
                if (iZUGFeRDExportableItem.getDetailedDeliveryPeriodFrom() != null) {
                    xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(iZUGFeRDExportableItem.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
                }
                if (iZUGFeRDExportableItem.getDetailedDeliveryPeriodTo() != null) {
                    xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(iZUGFeRDExportableItem.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
                }
                xml = xml + "</ram:BillingSpecifiedPeriod>";
            }
            xml = xml + "\t\t\t\t<ram:SpecifiedTradeSettlementLineMonetarySummation>\n\t\t\t\t\t<ram:LineTotalAmount>" + this.currencyFormat(lc.getItemTotalNetAmount()) + "</ram:LineTotalAmount>\n\t\t\t\t</ram:SpecifiedTradeSettlementLineMonetarySummation>\n";
            if (iZUGFeRDExportableItem.getAdditionalReferencedDocumentID() != null) {
                xml = xml + "\t\t\t<ram:AdditionalReferencedDocument><ram:IssuerAssignedID>" + iZUGFeRDExportableItem.getAdditionalReferencedDocumentID() + "</ram:IssuerAssignedID><ram:TypeCode>130</ram:TypeCode></ram:AdditionalReferencedDocument>\n";
            }
            xml = xml + "\t\t\t</ram:SpecifiedLineTradeSettlement>\n\t\t</ram:IncludedSupplyChainTradeLineItem>\n";
        }
        xml = xml + "\t\t<ram:ApplicableHeaderTradeAgreement>\n";
        if (trans.getReferenceNumber() != null) {
            xml = xml + "\t\t\t<ram:BuyerReference>" + XMLTools.encodeXML(trans.getReferenceNumber()) + "</ram:BuyerReference>\n";
        }
        xml = xml + "\t\t\t<ram:SellerTradeParty>\n" + this.getTradePartyAsXML(trans.getSender(), true, false) + "\t\t\t</ram:SellerTradeParty>\n\t\t\t<ram:BuyerTradeParty>\n";
        xml = xml + this.getTradePartyAsXML(trans.getRecipient(), false, false);
        xml = xml + "\t\t\t</ram:BuyerTradeParty>\n";
        if (trans.getSellerOrderReferencedDocumentID() != null) {
            xml = xml + "   <ram:SellerOrderReferencedDocument>\n       <ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getSellerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID>\n   </ram:SellerOrderReferencedDocument>\n";
        }
        if (trans.getBuyerOrderReferencedDocumentID() != null) {
            xml = xml + "   <ram:BuyerOrderReferencedDocument>\n       <ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getBuyerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID>\n   </ram:BuyerOrderReferencedDocument>\n";
        }
        if (trans.getContractReferencedDocument() != null) {
            xml = xml + "   <ram:ContractReferencedDocument>\n       <ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getContractReferencedDocument()) + "</ram:IssuerAssignedID>\n    </ram:ContractReferencedDocument>\n";
        }
        if (trans.getAdditionalReferencedDocuments() != null) {
            for (FileAttachment fileAttachment : trans.getAdditionalReferencedDocuments()) {
                String documentContent = new String(Base64.getEncoder().encodeToString(fileAttachment.getData()));
                xml = xml + "  <ram:AdditionalReferencedDocument>\n    <ram:IssuerAssignedID>" + fileAttachment.getFilename() + "</ram:IssuerAssignedID>\n    <ram:TypeCode>916</ram:TypeCode>\n    <ram:Name>" + fileAttachment.getDescription() + "</ram:Name>\n    <ram:AttachmentBinaryObject mimeCode=\"" + fileAttachment.getMimetype() + "\"\n      filename=\"" + fileAttachment.getFilename() + "\">" + documentContent + "</ram:AttachmentBinaryObject>\n  </ram:AdditionalReferencedDocument>\n";
            }
        }
        if (trans.getSpecifiedProcuringProjectID() != null) {
            xml = xml + "   <ram:SpecifiedProcuringProject>\n       <ram:ID>" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectID()) + "</ram:ID>\n";
            if (trans.getSpecifiedProcuringProjectName() != null) {
                xml = xml + "       <ram:Name >" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectName()) + "</ram:Name>\n";
            }
            xml = xml + "    </ram:SpecifiedProcuringProject>\n";
        }
        xml = xml + "\t\t</ram:ApplicableHeaderTradeAgreement>\n\t\t<ram:ApplicableHeaderTradeDelivery>\n";
        if (this.trans.getDeliveryAddress() != null) {
            xml = xml + "<ram:ShipToTradeParty>" + this.getTradePartyAsXML(this.trans.getDeliveryAddress(), false, true) + "</ram:ShipToTradeParty>";
        }
        xml = xml + "\t\t\t<ram:ActualDeliverySupplyChainEvent>\n\t\t\t\t<ram:OccurrenceDateTime>";
        if (trans.getDeliveryDate() == null) {
            throw new IllegalStateException("No delivery date provided");
        }
        xml = xml + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDeliveryDate());
        xml = xml + "</ram:OccurrenceDateTime>\n";
        xml = xml + "\t\t\t</ram:ActualDeliverySupplyChainEvent>\n\t\t</ram:ApplicableHeaderTradeDelivery>\n\t\t<ram:ApplicableHeaderTradeSettlement>\n\t\t\t<ram:PaymentReference>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:PaymentReference>\n\t\t\t<ram:InvoiceCurrencyCode>" + trans.getCurrency() + "</ram:InvoiceCurrencyCode>\n";
        if (trans.getTradeSettlementPayment() != null) {
            for (IZUGFeRDTradeSettlementPayment iZUGFeRDTradeSettlementPayment : trans.getTradeSettlementPayment()) {
                if (iZUGFeRDTradeSettlementPayment == null) continue;
                hasDueDate = true;
                xml = xml + iZUGFeRDTradeSettlementPayment.getSettlementXML();
            }
        }
        if (trans.getTradeSettlement() != null) {
            for (IZUGFeRDTradeSettlement iZUGFeRDTradeSettlement : trans.getTradeSettlement()) {
                if (iZUGFeRDTradeSettlement == null) continue;
                if (iZUGFeRDTradeSettlement instanceof IZUGFeRDTradeSettlementPayment) {
                    hasDueDate = true;
                }
                xml = xml + iZUGFeRDTradeSettlement.getSettlementXML();
            }
        }
        if (trans.getDocumentCode() == "384") {
            hasDueDate = false;
        }
        HashMap<BigDecimal, VATAmount> VATPercentAmountMap = this.calc.getVATPercentAmountMap();
        for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
            VATAmount vATAmount = (VATAmount)VATPercentAmountMap.get(currentTaxPercent);
            if (vATAmount == null) continue;
            String amountCategoryCode = vATAmount.getCategoryCode();
            boolean displayExemptionReason = TaxCategoryCodeTypeConstants.CATEGORY_CODES_WITH_EXEMPTION_REASON.contains(amountCategoryCode);
            xml = xml + "\t\t\t<ram:ApplicableTradeTax>\n\t\t\t\t<ram:CalculatedAmount>" + this.currencyFormat(vATAmount.getCalculated()) + "</ram:CalculatedAmount>\n\t\t\t\t<ram:TypeCode>VAT</ram:TypeCode>\n" + (displayExemptionReason ? exemptionReason : "") + "\t\t\t\t<ram:BasisAmount>" + this.currencyFormat(vATAmount.getBasis()) + "</ram:BasisAmount>\n\t\t\t\t<ram:CategoryCode>" + amountCategoryCode + "</ram:CategoryCode>\n\t\t\t\t<ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:RateApplicablePercent>\n\t\t\t</ram:ApplicableTradeTax>\n";
        }
        if (trans.getDetailedDeliveryPeriodFrom() != null || trans.getDetailedDeliveryPeriodTo() != null) {
            xml = xml + "<ram:BillingSpecifiedPeriod>";
            if (trans.getDetailedDeliveryPeriodFrom() != null) {
                xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
            }
            if (trans.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
            }
            xml = xml + "</ram:BillingSpecifiedPeriod>";
        }
        if (trans.getZFCharges() != null && trans.getZFCharges().length > 0) {
            for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
                if (this.calc.getChargesForPercent(currentTaxPercent).compareTo(BigDecimal.ZERO) == 0) continue;
                xml = xml + "\t <ram:SpecifiedTradeAllowanceCharge>\n        <ram:ChargeIndicator>\n          <udt:Indicator>true</udt:Indicator>\n        </ram:ChargeIndicator>\n        <ram:ActualAmount>" + this.currencyFormat(this.calc.getChargesForPercent(currentTaxPercent)) + "</ram:ActualAmount>\n        <ram:Reason>" + XMLTools.encodeXML(this.calc.getChargeReasonForPercent(currentTaxPercent)) + "</ram:Reason>\n        <ram:CategoryTradeTax>\n          <ram:TypeCode>VAT</ram:TypeCode>\n          <ram:CategoryCode>" + ((VATAmount)VATPercentAmountMap.get(currentTaxPercent)).getCategoryCode() + "</ram:CategoryCode>\n          <ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:RateApplicablePercent>\n        </ram:CategoryTradeTax>\n      </ram:SpecifiedTradeAllowanceCharge>\t\n";
            }
        }
        if (trans.getZFAllowances() != null && trans.getZFAllowances().length > 0) {
            for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
                if (this.calc.getAllowancesForPercent(currentTaxPercent).compareTo(BigDecimal.ZERO) == 0) continue;
                xml = xml + "\t <ram:SpecifiedTradeAllowanceCharge>\n        <ram:ChargeIndicator>\n          <udt:Indicator>false</udt:Indicator>\n        </ram:ChargeIndicator>\n        <ram:ActualAmount>" + this.currencyFormat(this.calc.getAllowancesForPercent(currentTaxPercent)) + "</ram:ActualAmount>\n        <ram:Reason>" + XMLTools.encodeXML(this.calc.getAllowanceReasonForPercent(currentTaxPercent)) + "</ram:Reason>\n        <ram:CategoryTradeTax>\n          <ram:TypeCode>VAT</ram:TypeCode>\n          <ram:CategoryCode>" + ((VATAmount)VATPercentAmountMap.get(currentTaxPercent)).getCategoryCode() + "</ram:CategoryCode>\n          <ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:RateApplicablePercent>\n        </ram:CategoryTradeTax>\n      </ram:SpecifiedTradeAllowanceCharge>\t\n";
            }
        }
        if (trans.getPaymentTerms() == null && (this.paymentTermsDescription != null || trans.getTradeSettlement() != null || hasDueDate)) {
            xml = xml + "<ram:SpecifiedTradePaymentTerms>\n";
            if (this.paymentTermsDescription != null) {
                xml = xml + "<ram:Description>" + this.paymentTermsDescription + "</ram:Description>\n";
            }
            if (trans.getTradeSettlement() != null) {
                void var15_32;
                IZUGFeRDTradeSettlement[] currentNote = trans.getTradeSettlement();
                int currentTaxPercent = currentNote.length;
                boolean bl = false;
                while (var15_32 < currentTaxPercent) {
                    IZUGFeRDTradeSettlement payment = currentNote[var15_32];
                    if (payment != null && payment instanceof IZUGFeRDTradeSettlementDebit) {
                        xml = xml + payment.getPaymentXML();
                    }
                    ++var15_32;
                }
            }
            if (hasDueDate && trans.getDueDate() != null) {
                xml = xml + "\t\t\t\t<ram:DueDateDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDueDate()) + "</ram:DueDateDateTime>\n";
            }
            xml = xml + "\t\t\t</ram:SpecifiedTradePaymentTerms>\n";
        } else {
            xml = xml + this.buildPaymentTermsXml();
        }
        String allowanceTotalLine = "<ram:AllowanceTotalAmount>" + this.currencyFormat(this.calc.getAllowancesForPercent(null)) + "</ram:AllowanceTotalAmount>";
        String chargesTotalLine = "<ram:ChargeTotalAmount>" + this.currencyFormat(this.calc.getChargesForPercent(null)) + "</ram:ChargeTotalAmount>";
        xml = xml + "\t\t\t<ram:SpecifiedTradeSettlementHeaderMonetarySummation>\n\t\t\t\t<ram:LineTotalAmount>" + this.currencyFormat(this.calc.getTotal()) + "</ram:LineTotalAmount>\n" + chargesTotalLine + allowanceTotalLine + "\t\t\t\t<ram:TaxBasisTotalAmount>" + this.currencyFormat(this.calc.getTaxBasis()) + "</ram:TaxBasisTotalAmount>\n\t\t\t\t<ram:TaxTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getGrandTotal().subtract(this.calc.getTaxBasis())) + "</ram:TaxTotalAmount>\n\t\t\t\t<ram:GrandTotalAmount>" + this.currencyFormat(this.calc.getGrandTotal()) + "</ram:GrandTotalAmount>\n             <ram:TotalPrepaidAmount>" + this.currencyFormat(this.calc.getTotalPrepaid()) + "</ram:TotalPrepaidAmount>\n\t\t\t\t<ram:DuePayableAmount>" + this.currencyFormat(this.calc.getGrandTotal().subtract(this.calc.getTotalPrepaid())) + "</ram:DuePayableAmount>\n\t\t\t</ram:SpecifiedTradeSettlementHeaderMonetarySummation>\n";
        if (trans.getInvoiceReferencedDocumentID() != null) {
            xml = xml + "   <ram:InvoiceReferencedDocument>\n       <ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getInvoiceReferencedDocumentID()) + "</ram:IssuerAssignedID>\n";
            if (trans.getInvoiceReferencedIssueDate() != null) {
                xml = xml + "<ram:FormattedIssueDateTime>" + ZUGFeRDDateFormat.DATE.qdtFormat(trans.getInvoiceReferencedIssueDate()) + "</ram:FormattedIssueDateTime>\n";
            }
            xml = xml + "   </ram:InvoiceReferencedDocument>\n";
        }
        xml = xml + "\t\t</ram:ApplicableHeaderTradeSettlement>\n";
        xml = xml + "\t</rsm:SupplyChainTradeTransaction>\n</rsm:CrossIndustryInvoice>";
        try {
            byte[] byArray = xml.getBytes("UTF-8");
            this.zugferdData = XMLTools.removeBOM(byArray);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(ZUGFeRD2PullProvider.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    @Override
    public void setProfile(Profile p) {
        this.profile = p;
    }

    private String buildPaymentTermsXml() {
        IZUGFeRDPaymentTerms paymentTerms = this.trans.getPaymentTerms();
        if (paymentTerms == null) {
            return "";
        }
        String paymentTermsXml = "<ram:SpecifiedTradePaymentTerms>";
        IZUGFeRDPaymentDiscountTerms discountTerms = paymentTerms.getDiscountTerms();
        Date dueDate = paymentTerms.getDueDate();
        if (dueDate != null && discountTerms != null && discountTerms.getBaseDate() != null) {
            throw new IllegalStateException("if paymentTerms.dueDate is specified, paymentTerms.discountTerms.baseDate has not to be specified");
        }
        paymentTermsXml = paymentTermsXml + "<ram:Description>" + paymentTerms.getDescription() + "</ram:Description>";
        if (dueDate != null) {
            paymentTermsXml = paymentTermsXml + "<ram:DueDateDateTime>";
            paymentTermsXml = paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(dueDate);
            paymentTermsXml = paymentTermsXml + "</ram:DueDateDateTime>";
        }
        if (discountTerms != null) {
            paymentTermsXml = paymentTermsXml + "<ram:ApplicableTradePaymentDiscountTerms>";
            String currency = this.trans.getCurrency();
            String basisAmount = this.currencyFormat(this.calc.getGrandTotal());
            paymentTermsXml = paymentTermsXml + "<ram:BasisAmount currencyID=\"" + currency + "\">" + basisAmount + "</ram:BasisAmount>";
            paymentTermsXml = paymentTermsXml + "<ram:CalculationPercent>" + discountTerms.getCalculationPercentage().toString() + "</ram:CalculationPercent>";
            if (discountTerms.getBaseDate() != null) {
                Date baseDate = discountTerms.getBaseDate();
                paymentTermsXml = paymentTermsXml + "<ram:BasisDateTime>";
                paymentTermsXml = paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(baseDate);
                paymentTermsXml = paymentTermsXml + "</ram:BasisDateTime>";
                paymentTermsXml = paymentTermsXml + "<ram:BasisPeriodMeasure unitCode=\"" + discountTerms.getBasePeriodUnitCode() + "\">" + discountTerms.getBasePeriodMeasure() + "</ram:BasisPeriodMeasure>";
            }
            paymentTermsXml = paymentTermsXml + "</ram:ApplicableTradePaymentDiscountTerms>";
        }
        paymentTermsXml = paymentTermsXml + "</ram:SpecifiedTradePaymentTerms>";
        return paymentTermsXml;
    }
}

