/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "../../../node_modules/@emotion/is-prop-valid/dist/is-prop-valid.browser.esm.js":
/*!**************************************************************************************!*\
  !*** ../../../node_modules/@emotion/is-prop-valid/dist/is-prop-valid.browser.esm.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
var _memoize = _interopRequireDefault(__webpack_require__(/*! @emotion/memoize */ "../../../node_modules/@emotion/memoize/dist/memoize.browser.esm.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var reactPropsRegex = /^((children|dangerouslySetInnerHTML|key|ref|autoFocus|defaultValue|defaultChecked|innerHTML|suppressContentEditableWarning|suppressHydrationWarning|valueLink|accept|acceptCharset|accessKey|action|allow|allowUserMedia|allowPaymentRequest|allowFullScreen|allowTransparency|alt|async|autoComplete|autoPlay|capture|cellPadding|cellSpacing|challenge|charSet|checked|cite|classID|className|cols|colSpan|content|contentEditable|contextMenu|controls|controlsList|coords|crossOrigin|data|dateTime|decoding|default|defer|dir|disabled|disablePictureInPicture|download|draggable|encType|form|formAction|formEncType|formMethod|formNoValidate|formTarget|frameBorder|headers|height|hidden|high|href|hrefLang|htmlFor|httpEquiv|id|inputMode|integrity|is|keyParams|keyType|kind|label|lang|list|loading|loop|low|marginHeight|marginWidth|max|maxLength|media|mediaGroup|method|min|minLength|multiple|muted|name|nonce|noValidate|open|optimum|pattern|placeholder|playsInline|poster|preload|profile|radioGroup|readOnly|referrerPolicy|rel|required|reversed|role|rows|rowSpan|sandbox|scope|scoped|scrolling|seamless|selected|shape|size|sizes|slot|span|spellCheck|src|srcDoc|srcLang|srcSet|start|step|style|summary|tabIndex|target|title|type|useMap|value|width|wmode|wrap|about|datatype|inlist|prefix|property|resource|typeof|vocab|autoCapitalize|autoCorrect|autoSave|color|inert|itemProp|itemScope|itemType|itemID|itemRef|on|results|security|unselectable|accentHeight|accumulate|additive|alignmentBaseline|allowReorder|alphabetic|amplitude|arabicForm|ascent|attributeName|attributeType|autoReverse|azimuth|baseFrequency|baselineShift|baseProfile|bbox|begin|bias|by|calcMode|capHeight|clip|clipPathUnits|clipPath|clipRule|colorInterpolation|colorInterpolationFilters|colorProfile|colorRendering|contentScriptType|contentStyleType|cursor|cx|cy|d|decelerate|descent|diffuseConstant|direction|display|divisor|dominantBaseline|dur|dx|dy|edgeMode|elevation|enableBackground|end|exponent|externalResourcesRequired|fill|fillOpacity|fillRule|filter|filterRes|filterUnits|floodColor|floodOpacity|focusable|fontFamily|fontSize|fontSizeAdjust|fontStretch|fontStyle|fontVariant|fontWeight|format|from|fr|fx|fy|g1|g2|glyphName|glyphOrientationHorizontal|glyphOrientationVertical|glyphRef|gradientTransform|gradientUnits|hanging|horizAdvX|horizOriginX|ideographic|imageRendering|in|in2|intercept|k|k1|k2|k3|k4|kernelMatrix|kernelUnitLength|kerning|keyPoints|keySplines|keyTimes|lengthAdjust|letterSpacing|lightingColor|limitingConeAngle|local|markerEnd|markerMid|markerStart|markerHeight|markerUnits|markerWidth|mask|maskContentUnits|maskUnits|mathematical|mode|numOctaves|offset|opacity|operator|order|orient|orientation|origin|overflow|overlinePosition|overlineThickness|panose1|paintOrder|pathLength|patternContentUnits|patternTransform|patternUnits|pointerEvents|points|pointsAtX|pointsAtY|pointsAtZ|preserveAlpha|preserveAspectRatio|primitiveUnits|r|radius|refX|refY|renderingIntent|repeatCount|repeatDur|requiredExtensions|requiredFeatures|restart|result|rotate|rx|ry|scale|seed|shapeRendering|slope|spacing|specularConstant|specularExponent|speed|spreadMethod|startOffset|stdDeviation|stemh|stemv|stitchTiles|stopColor|stopOpacity|strikethroughPosition|strikethroughThickness|string|stroke|strokeDasharray|strokeDashoffset|strokeLinecap|strokeLinejoin|strokeMiterlimit|strokeOpacity|strokeWidth|surfaceScale|systemLanguage|tableValues|targetX|targetY|textAnchor|textDecoration|textRendering|textLength|to|transform|u1|u2|underlinePosition|underlineThickness|unicode|unicodeBidi|unicodeRange|unitsPerEm|vAlphabetic|vHanging|vIdeographic|vMathematical|values|vectorEffect|version|vertAdvY|vertOriginX|vertOriginY|viewBox|viewTarget|visibility|widths|wordSpacing|writingMode|x|xHeight|x1|x2|xChannelSelector|xlinkActuate|xlinkArcrole|xlinkHref|xlinkRole|xlinkShow|xlinkTitle|xlinkType|xmlBase|xmlns|xmlnsXlink|xmlLang|xmlSpace|y|y1|y2|yChannelSelector|z|zoomAndPan|for|class|autofocus)|(([Dd][Aa][Tt][Aa]|[Aa][Rr][Ii][Aa]|x)-.*))$/; // https://esbench.com/bench/5bfee68a4cd7e6009ef61d23

var index = (0, _memoize.default)(function (prop) {
  return reactPropsRegex.test(prop) || prop.charCodeAt(0) === 111
  /* o */ && prop.charCodeAt(1) === 110
  /* n */ && prop.charCodeAt(2) < 91;
}
/* Z+1 */);
var _default = exports["default"] = index;

/***/ }),

/***/ "../../../node_modules/@emotion/memoize/dist/memoize.browser.esm.js":
/*!**************************************************************************!*\
  !*** ../../../node_modules/@emotion/memoize/dist/memoize.browser.esm.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
function memoize(fn) {
  var cache = {};
  return function (arg) {
    if (cache[arg] === undefined) cache[arg] = fn(arg);
    return cache[arg];
  };
}
var _default = exports["default"] = memoize;

/***/ }),

/***/ "../../../node_modules/@floating-ui/core/dist/floating-ui.core.esm.js":
/*!****************************************************************************!*\
  !*** ../../../node_modules/@floating-ui/core/dist/floating-ui.core.esm.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.computePosition = exports.autoPlacement = exports.arrow = void 0;
exports.detectOverflow = detectOverflow;
exports.offset = exports.limitShift = exports.inline = exports.hide = exports.flip = void 0;
exports.rectToClientRect = rectToClientRect;
exports.size = exports.shift = void 0;
function getAlignment(placement) {
  return placement.split('-')[1];
}
function getLengthFromAxis(axis) {
  return axis === 'y' ? 'height' : 'width';
}
function getSide(placement) {
  return placement.split('-')[0];
}
function getMainAxisFromPlacement(placement) {
  return ['top', 'bottom'].includes(getSide(placement)) ? 'x' : 'y';
}
function computeCoordsFromPlacement(_ref, placement, rtl) {
  let {
    reference,
    floating
  } = _ref;
  const commonX = reference.x + reference.width / 2 - floating.width / 2;
  const commonY = reference.y + reference.height / 2 - floating.height / 2;
  const mainAxis = getMainAxisFromPlacement(placement);
  const length = getLengthFromAxis(mainAxis);
  const commonAlign = reference[length] / 2 - floating[length] / 2;
  const side = getSide(placement);
  const isVertical = mainAxis === 'x';
  let coords;
  switch (side) {
    case 'top':
      coords = {
        x: commonX,
        y: reference.y - floating.height
      };
      break;
    case 'bottom':
      coords = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;
    case 'right':
      coords = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;
    case 'left':
      coords = {
        x: reference.x - floating.width,
        y: commonY
      };
      break;
    default:
      coords = {
        x: reference.x,
        y: reference.y
      };
  }
  switch (getAlignment(placement)) {
    case 'start':
      coords[mainAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
      break;
    case 'end':
      coords[mainAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
      break;
  }
  return coords;
}

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a reference element when it is given a certain positioning strategy.
 *
 * This export does not have any `platform` interface logic. You will need to
 * write one for the platform you are using Floating UI with.
 */
const computePosition = async (reference, floating, config) => {
  const {
    placement = 'bottom',
    strategy = 'absolute',
    middleware = [],
    platform
  } = config;
  const validMiddleware = middleware.filter(Boolean);
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(floating));
  let rects = await platform.getElementRects({
    reference,
    floating,
    strategy
  });
  let {
    x,
    y
  } = computeCoordsFromPlacement(rects, placement, rtl);
  let statefulPlacement = placement;
  let middlewareData = {};
  let resetCount = 0;
  for (let i = 0; i < validMiddleware.length; i++) {
    const {
      name,
      fn
    } = validMiddleware[i];
    const {
      x: nextX,
      y: nextY,
      data,
      reset
    } = await fn({
      x,
      y,
      initialPlacement: placement,
      placement: statefulPlacement,
      strategy,
      middlewareData,
      rects,
      platform,
      elements: {
        reference,
        floating
      }
    });
    x = nextX != null ? nextX : x;
    y = nextY != null ? nextY : y;
    middlewareData = {
      ...middlewareData,
      [name]: {
        ...middlewareData[name],
        ...data
      }
    };
    if (reset && resetCount <= 50) {
      resetCount++;
      if (typeof reset === 'object') {
        if (reset.placement) {
          statefulPlacement = reset.placement;
        }
        if (reset.rects) {
          rects = reset.rects === true ? await platform.getElementRects({
            reference,
            floating,
            strategy
          }) : reset.rects;
        }
        ({
          x,
          y
        } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
      }
      i = -1;
      continue;
    }
  }
  return {
    x,
    y,
    placement: statefulPlacement,
    strategy,
    middlewareData
  };
};
exports.computePosition = computePosition;
function evaluate(value, param) {
  return typeof value === 'function' ? value(param) : value;
}
function expandPaddingObject(padding) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...padding
  };
}
function getSideObjectFromPadding(padding) {
  return typeof padding !== 'number' ? expandPaddingObject(padding) : {
    top: padding,
    right: padding,
    bottom: padding,
    left: padding
  };
}
function rectToClientRect(rect) {
  return {
    ...rect,
    top: rect.y,
    left: rect.x,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height
  };
}

/**
 * Resolves with an object of overflow side offsets that determine how much the
 * element is overflowing a given clipping boundary on each side.
 * - positive = overflowing the boundary by that number of pixels
 * - negative = how many pixels left before it will overflow
 * - 0 = lies flush with the boundary
 * @see https://floating-ui.com/docs/detectOverflow
 */
async function detectOverflow(state, options) {
  var _await$platform$isEle;
  if (options === void 0) {
    options = {};
  }
  const {
    x,
    y,
    platform,
    rects,
    elements,
    strategy
  } = state;
  const {
    boundary = 'clippingAncestors',
    rootBoundary = 'viewport',
    elementContext = 'floating',
    altBoundary = false,
    padding = 0
  } = evaluate(options, state);
  const paddingObject = getSideObjectFromPadding(padding);
  const altContext = elementContext === 'floating' ? 'reference' : 'floating';
  const element = elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = rectToClientRect(await platform.getClippingRect({
    element: ((_await$platform$isEle = await (platform.isElement == null ? void 0 : platform.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || (await (platform.getDocumentElement == null ? void 0 : platform.getDocumentElement(elements.floating))),
    boundary,
    rootBoundary,
    strategy
  }));
  const rect = elementContext === 'floating' ? {
    ...rects.floating,
    x,
    y
  } : rects.reference;
  const offsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(elements.floating));
  const offsetScale = (await (platform.isElement == null ? void 0 : platform.isElement(offsetParent))) ? (await (platform.getScale == null ? void 0 : platform.getScale(offsetParent))) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  };
  const elementClientRect = rectToClientRect(platform.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform.convertOffsetParentRelativeRectToViewportRelativeRect({
    rect,
    offsetParent,
    strategy
  }) : rect);
  return {
    top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
    bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
    left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
    right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
  };
}
const min = Math.min;
const max = Math.max;
function within(min$1, value, max$1) {
  return max(min$1, min(value, max$1));
}

/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow = options => ({
  name: 'arrow',
  options,
  async fn(state) {
    const {
      x,
      y,
      placement,
      rects,
      platform,
      elements
    } = state;
    // Since `element` is required, we don't Partial<> the type.
    const {
      element,
      padding = 0
    } = evaluate(options, state) || {};
    if (element == null) {
      return {};
    }
    const paddingObject = getSideObjectFromPadding(padding);
    const coords = {
      x,
      y
    };
    const axis = getMainAxisFromPlacement(placement);
    const length = getLengthFromAxis(axis);
    const arrowDimensions = await platform.getDimensions(element);
    const isYAxis = axis === 'y';
    const minProp = isYAxis ? 'top' : 'left';
    const maxProp = isYAxis ? 'bottom' : 'right';
    const clientProp = isYAxis ? 'clientHeight' : 'clientWidth';
    const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];
    const startDiff = coords[axis] - rects.reference[axis];
    const arrowOffsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(element));
    let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;

    // DOM platform can return `window` as the `offsetParent`.
    if (!clientSize || !(await (platform.isElement == null ? void 0 : platform.isElement(arrowOffsetParent)))) {
      clientSize = elements.floating[clientProp] || rects.floating[length];
    }
    const centerToReference = endDiff / 2 - startDiff / 2;

    // If the padding is large enough that it causes the arrow to no longer be
    // centered, modify the padding so that it is centered.
    const largestPossiblePadding = clientSize / 2 - arrowDimensions[length] / 2 - 1;
    const minPadding = min(paddingObject[minProp], largestPossiblePadding);
    const maxPadding = min(paddingObject[maxProp], largestPossiblePadding);

    // Make sure the arrow doesn't overflow the floating element if the center
    // point is outside the floating element's bounds.
    const min$1 = minPadding;
    const max = clientSize - arrowDimensions[length] - maxPadding;
    const center = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;
    const offset = within(min$1, center, max);

    // If the reference is small enough that the arrow's padding causes it to
    // to point to nothing for an aligned placement, adjust the offset of the
    // floating element itself. This stops `shift()` from taking action, but can
    // be worked around by calling it again after the `arrow()` if desired.
    const shouldAddOffset = getAlignment(placement) != null && center != offset && rects.reference[length] / 2 - (center < min$1 ? minPadding : maxPadding) - arrowDimensions[length] / 2 < 0;
    const alignmentOffset = shouldAddOffset ? center < min$1 ? min$1 - center : max - center : 0;
    return {
      [axis]: coords[axis] - alignmentOffset,
      data: {
        [axis]: offset,
        centerOffset: center - offset
      }
    };
  }
});
exports.arrow = arrow;
const sides = ['top', 'right', 'bottom', 'left'];
const allPlacements = /*#__PURE__*/sides.reduce((acc, side) => acc.concat(side, side + "-start", side + "-end"), []);
const oppositeSideMap = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, side => oppositeSideMap[side]);
}
function getAlignmentSides(placement, rects, rtl) {
  if (rtl === void 0) {
    rtl = false;
  }
  const alignment = getAlignment(placement);
  const mainAxis = getMainAxisFromPlacement(placement);
  const length = getLengthFromAxis(mainAxis);
  let mainAlignmentSide = mainAxis === 'x' ? alignment === (rtl ? 'end' : 'start') ? 'right' : 'left' : alignment === 'start' ? 'bottom' : 'top';
  if (rects.reference[length] > rects.floating[length]) {
    mainAlignmentSide = getOppositePlacement(mainAlignmentSide);
  }
  return {
    main: mainAlignmentSide,
    cross: getOppositePlacement(mainAlignmentSide)
  };
}
const oppositeAlignmentMap = {
  start: 'end',
  end: 'start'
};
function getOppositeAlignmentPlacement(placement) {
  return placement.replace(/start|end/g, alignment => oppositeAlignmentMap[alignment]);
}
function getPlacementList(alignment, autoAlignment, allowedPlacements) {
  const allowedPlacementsSortedByAlignment = alignment ? [...allowedPlacements.filter(placement => getAlignment(placement) === alignment), ...allowedPlacements.filter(placement => getAlignment(placement) !== alignment)] : allowedPlacements.filter(placement => getSide(placement) === placement);
  return allowedPlacementsSortedByAlignment.filter(placement => {
    if (alignment) {
      return getAlignment(placement) === alignment || (autoAlignment ? getOppositeAlignmentPlacement(placement) !== placement : false);
    }
    return true;
  });
}
/**
 * Optimizes the visibility of the floating element by choosing the placement
 * that has the most space available automatically, without needing to specify a
 * preferred placement. Alternative to `flip`.
 * @see https://floating-ui.com/docs/autoPlacement
 */
const autoPlacement = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'autoPlacement',
    options,
    async fn(state) {
      var _middlewareData$autoP, _middlewareData$autoP2, _placementsThatFitOnE;
      const {
        rects,
        middlewareData,
        placement,
        platform,
        elements
      } = state;
      const {
        crossAxis = false,
        alignment,
        allowedPlacements = allPlacements,
        autoAlignment = true,
        ...detectOverflowOptions
      } = evaluate(options, state);
      const placements = alignment !== undefined || allowedPlacements === allPlacements ? getPlacementList(alignment || null, autoAlignment, allowedPlacements) : allowedPlacements;
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const currentIndex = ((_middlewareData$autoP = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP.index) || 0;
      const currentPlacement = placements[currentIndex];
      if (currentPlacement == null) {
        return {};
      }
      const {
        main,
        cross
      } = getAlignmentSides(currentPlacement, rects, await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating)));

      // Make `computeCoords` start from the right place.
      if (placement !== currentPlacement) {
        return {
          reset: {
            placement: placements[0]
          }
        };
      }
      const currentOverflows = [overflow[getSide(currentPlacement)], overflow[main], overflow[cross]];
      const allOverflows = [...(((_middlewareData$autoP2 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP2.overflows) || []), {
        placement: currentPlacement,
        overflows: currentOverflows
      }];
      const nextPlacement = placements[currentIndex + 1];

      // There are more placements to check.
      if (nextPlacement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: nextPlacement
          }
        };
      }
      const placementsSortedByMostSpace = allOverflows.map(d => {
        const alignment = getAlignment(d.placement);
        return [d.placement, alignment && crossAxis ?
        // Check along the mainAxis and main crossAxis side.
        d.overflows.slice(0, 2).reduce((acc, v) => acc + v, 0) :
        // Check only the mainAxis.
        d.overflows[0], d.overflows];
      }).sort((a, b) => a[1] - b[1]);
      const placementsThatFitOnEachSide = placementsSortedByMostSpace.filter(d => d[2].slice(0,
      // Aligned placements should not check their opposite crossAxis
      // side.
      getAlignment(d[0]) ? 2 : 3).every(v => v <= 0));
      const resetPlacement = ((_placementsThatFitOnE = placementsThatFitOnEachSide[0]) == null ? void 0 : _placementsThatFitOnE[0]) || placementsSortedByMostSpace[0][0];
      if (resetPlacement !== placement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: resetPlacement
          }
        };
      }
      return {};
    }
  };
};
exports.autoPlacement = autoPlacement;
function getExpandedPlacements(placement) {
  const oppositePlacement = getOppositePlacement(placement);
  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
}
function getSideList(side, isStart, rtl) {
  const lr = ['left', 'right'];
  const rl = ['right', 'left'];
  const tb = ['top', 'bottom'];
  const bt = ['bottom', 'top'];
  switch (side) {
    case 'top':
    case 'bottom':
      if (rtl) return isStart ? rl : lr;
      return isStart ? lr : rl;
    case 'left':
    case 'right':
      return isStart ? tb : bt;
    default:
      return [];
  }
}
function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
  const alignment = getAlignment(placement);
  let list = getSideList(getSide(placement), direction === 'start', rtl);
  if (alignment) {
    list = list.map(side => side + "-" + alignment);
    if (flipAlignment) {
      list = list.concat(list.map(getOppositeAlignmentPlacement));
    }
  }
  return list;
}

/**
 * Optimizes the visibility of the floating element by flipping the `placement`
 * in order to keep it in view when the preferred placement(s) will overflow the
 * clipping boundary. Alternative to `autoPlacement`.
 * @see https://floating-ui.com/docs/flip
 */
const flip = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'flip',
    options,
    async fn(state) {
      var _middlewareData$flip;
      const {
        placement,
        middlewareData,
        rects,
        initialPlacement,
        platform,
        elements
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true,
        fallbackPlacements: specifiedFallbackPlacements,
        fallbackStrategy = 'bestFit',
        fallbackAxisSideDirection = 'none',
        flipAlignment = true,
        ...detectOverflowOptions
      } = evaluate(options, state);
      const side = getSide(placement);
      const isBasePlacement = getSide(initialPlacement) === initialPlacement;
      const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
      const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [getOppositePlacement(initialPlacement)] : getExpandedPlacements(initialPlacement));
      if (!specifiedFallbackPlacements && fallbackAxisSideDirection !== 'none') {
        fallbackPlacements.push(...getOppositeAxisPlacements(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
      }
      const placements = [initialPlacement, ...fallbackPlacements];
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const overflows = [];
      let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
      if (checkMainAxis) {
        overflows.push(overflow[side]);
      }
      if (checkCrossAxis) {
        const {
          main,
          cross
        } = getAlignmentSides(placement, rects, rtl);
        overflows.push(overflow[main], overflow[cross]);
      }
      overflowsData = [...overflowsData, {
        placement,
        overflows
      }];

      // One or more sides is overflowing.
      if (!overflows.every(side => side <= 0)) {
        var _middlewareData$flip2, _overflowsData$filter;
        const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
        const nextPlacement = placements[nextIndex];
        if (nextPlacement) {
          // Try next placement and re-run the lifecycle.
          return {
            data: {
              index: nextIndex,
              overflows: overflowsData
            },
            reset: {
              placement: nextPlacement
            }
          };
        }

        // First, find the candidates that fit on the mainAxis side of overflow,
        // then find the placement that fits the best on the main crossAxis side.
        let resetPlacement = (_overflowsData$filter = overflowsData.filter(d => d.overflows[0] <= 0).sort((a, b) => a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;

        // Otherwise fallback.
        if (!resetPlacement) {
          switch (fallbackStrategy) {
            case 'bestFit':
              {
                var _overflowsData$map$so;
                const placement = (_overflowsData$map$so = overflowsData.map(d => [d.placement, d.overflows.filter(overflow => overflow > 0).reduce((acc, overflow) => acc + overflow, 0)]).sort((a, b) => a[1] - b[1])[0]) == null ? void 0 : _overflowsData$map$so[0];
                if (placement) {
                  resetPlacement = placement;
                }
                break;
              }
            case 'initialPlacement':
              resetPlacement = initialPlacement;
              break;
          }
        }
        if (placement !== resetPlacement) {
          return {
            reset: {
              placement: resetPlacement
            }
          };
        }
      }
      return {};
    }
  };
};
exports.flip = flip;
function getSideOffsets(overflow, rect) {
  return {
    top: overflow.top - rect.height,
    right: overflow.right - rect.width,
    bottom: overflow.bottom - rect.height,
    left: overflow.left - rect.width
  };
}
function isAnySideFullyClipped(overflow) {
  return sides.some(side => overflow[side] >= 0);
}
/**
 * Provides data to hide the floating element in applicable situations, such as
 * when it is not in the same clipping context as the reference element.
 * @see https://floating-ui.com/docs/hide
 */
const hide = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'hide',
    options,
    async fn(state) {
      const {
        rects
      } = state;
      const {
        strategy = 'referenceHidden',
        ...detectOverflowOptions
      } = evaluate(options, state);
      switch (strategy) {
        case 'referenceHidden':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              elementContext: 'reference'
            });
            const offsets = getSideOffsets(overflow, rects.reference);
            return {
              data: {
                referenceHiddenOffsets: offsets,
                referenceHidden: isAnySideFullyClipped(offsets)
              }
            };
          }
        case 'escaped':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              altBoundary: true
            });
            const offsets = getSideOffsets(overflow, rects.floating);
            return {
              data: {
                escapedOffsets: offsets,
                escaped: isAnySideFullyClipped(offsets)
              }
            };
          }
        default:
          {
            return {};
          }
      }
    }
  };
};
exports.hide = hide;
function getBoundingRect(rects) {
  const minX = min(...rects.map(rect => rect.left));
  const minY = min(...rects.map(rect => rect.top));
  const maxX = max(...rects.map(rect => rect.right));
  const maxY = max(...rects.map(rect => rect.bottom));
  return {
    x: minX,
    y: minY,
    width: maxX - minX,
    height: maxY - minY
  };
}
function getRectsByLine(rects) {
  const sortedRects = rects.slice().sort((a, b) => a.y - b.y);
  const groups = [];
  let prevRect = null;
  for (let i = 0; i < sortedRects.length; i++) {
    const rect = sortedRects[i];
    if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {
      groups.push([rect]);
    } else {
      groups[groups.length - 1].push(rect);
    }
    prevRect = rect;
  }
  return groups.map(rect => rectToClientRect(getBoundingRect(rect)));
}
/**
 * Provides improved positioning for inline reference elements that can span
 * over multiple lines, such as hyperlinks or range selections.
 * @see https://floating-ui.com/docs/inline
 */
const inline = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'inline',
    options,
    async fn(state) {
      const {
        placement,
        elements,
        rects,
        platform,
        strategy
      } = state;
      // A MouseEvent's client{X,Y} coords can be up to 2 pixels off a
      // ClientRect's bounds, despite the event listener being triggered. A
      // padding of 2 seems to handle this issue.
      const {
        padding = 2,
        x,
        y
      } = evaluate(options, state);
      const nativeClientRects = Array.from((await (platform.getClientRects == null ? void 0 : platform.getClientRects(elements.reference))) || []);
      const clientRects = getRectsByLine(nativeClientRects);
      const fallback = rectToClientRect(getBoundingRect(nativeClientRects));
      const paddingObject = getSideObjectFromPadding(padding);
      function getBoundingClientRect() {
        // There are two rects and they are disjoined.
        if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x != null && y != null) {
          // Find the first rect in which the point is fully inside.
          return clientRects.find(rect => x > rect.left - paddingObject.left && x < rect.right + paddingObject.right && y > rect.top - paddingObject.top && y < rect.bottom + paddingObject.bottom) || fallback;
        }

        // There are 2 or more connected rects.
        if (clientRects.length >= 2) {
          if (getMainAxisFromPlacement(placement) === 'x') {
            const firstRect = clientRects[0];
            const lastRect = clientRects[clientRects.length - 1];
            const isTop = getSide(placement) === 'top';
            const top = firstRect.top;
            const bottom = lastRect.bottom;
            const left = isTop ? firstRect.left : lastRect.left;
            const right = isTop ? firstRect.right : lastRect.right;
            const width = right - left;
            const height = bottom - top;
            return {
              top,
              bottom,
              left,
              right,
              width,
              height,
              x: left,
              y: top
            };
          }
          const isLeftSide = getSide(placement) === 'left';
          const maxRight = max(...clientRects.map(rect => rect.right));
          const minLeft = min(...clientRects.map(rect => rect.left));
          const measureRects = clientRects.filter(rect => isLeftSide ? rect.left === minLeft : rect.right === maxRight);
          const top = measureRects[0].top;
          const bottom = measureRects[measureRects.length - 1].bottom;
          const left = minLeft;
          const right = maxRight;
          const width = right - left;
          const height = bottom - top;
          return {
            top,
            bottom,
            left,
            right,
            width,
            height,
            x: left,
            y: top
          };
        }
        return fallback;
      }
      const resetRects = await platform.getElementRects({
        reference: {
          getBoundingClientRect
        },
        floating: elements.floating,
        strategy
      });
      if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {
        return {
          reset: {
            rects: resetRects
          }
        };
      }
      return {};
    }
  };
};
exports.inline = inline;
async function convertValueToCoords(state, options) {
  const {
    placement,
    platform,
    elements
  } = state;
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
  const side = getSide(placement);
  const alignment = getAlignment(placement);
  const isVertical = getMainAxisFromPlacement(placement) === 'x';
  const mainAxisMulti = ['left', 'top'].includes(side) ? -1 : 1;
  const crossAxisMulti = rtl && isVertical ? -1 : 1;
  const rawValue = evaluate(options, state);

  // eslint-disable-next-line prefer-const
  let {
    mainAxis,
    crossAxis,
    alignmentAxis
  } = typeof rawValue === 'number' ? {
    mainAxis: rawValue,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: 0,
    crossAxis: 0,
    alignmentAxis: null,
    ...rawValue
  };
  if (alignment && typeof alignmentAxis === 'number') {
    crossAxis = alignment === 'end' ? alignmentAxis * -1 : alignmentAxis;
  }
  return isVertical ? {
    x: crossAxis * crossAxisMulti,
    y: mainAxis * mainAxisMulti
  } : {
    x: mainAxis * mainAxisMulti,
    y: crossAxis * crossAxisMulti
  };
}

/**
 * Modifies the placement by translating the floating element along the
 * specified axes.
 * A number (shorthand for `mainAxis` or distance), or an axes configuration
 * object may be passed.
 * @see https://floating-ui.com/docs/offset
 */
const offset = function (options) {
  if (options === void 0) {
    options = 0;
  }
  return {
    name: 'offset',
    options,
    async fn(state) {
      const {
        x,
        y
      } = state;
      const diffCoords = await convertValueToCoords(state, options);
      return {
        x: x + diffCoords.x,
        y: y + diffCoords.y,
        data: diffCoords
      };
    }
  };
};
exports.offset = offset;
function getCrossAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}

/**
 * Optimizes the visibility of the floating element by shifting it in order to
 * keep it in view when it will overflow the clipping boundary.
 * @see https://floating-ui.com/docs/shift
 */
const shift = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'shift',
    options,
    async fn(state) {
      const {
        x,
        y,
        placement
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = false,
        limiter = {
          fn: _ref => {
            let {
              x,
              y
            } = _ref;
            return {
              x,
              y
            };
          }
        },
        ...detectOverflowOptions
      } = evaluate(options, state);
      const coords = {
        x,
        y
      };
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const mainAxis = getMainAxisFromPlacement(getSide(placement));
      const crossAxis = getCrossAxis(mainAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      if (checkMainAxis) {
        const minSide = mainAxis === 'y' ? 'top' : 'left';
        const maxSide = mainAxis === 'y' ? 'bottom' : 'right';
        const min = mainAxisCoord + overflow[minSide];
        const max = mainAxisCoord - overflow[maxSide];
        mainAxisCoord = within(min, mainAxisCoord, max);
      }
      if (checkCrossAxis) {
        const minSide = crossAxis === 'y' ? 'top' : 'left';
        const maxSide = crossAxis === 'y' ? 'bottom' : 'right';
        const min = crossAxisCoord + overflow[minSide];
        const max = crossAxisCoord - overflow[maxSide];
        crossAxisCoord = within(min, crossAxisCoord, max);
      }
      const limitedCoords = limiter.fn({
        ...state,
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      });
      return {
        ...limitedCoords,
        data: {
          x: limitedCoords.x - x,
          y: limitedCoords.y - y
        }
      };
    }
  };
};
/**
 * Built-in `limiter` that will stop `shift()` at a certain point.
 */
exports.shift = shift;
const limitShift = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    options,
    fn(state) {
      const {
        x,
        y,
        placement,
        rects,
        middlewareData
      } = state;
      const {
        offset = 0,
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true
      } = evaluate(options, state);
      const coords = {
        x,
        y
      };
      const mainAxis = getMainAxisFromPlacement(placement);
      const crossAxis = getCrossAxis(mainAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      const rawOffset = evaluate(offset, state);
      const computedOffset = typeof rawOffset === 'number' ? {
        mainAxis: rawOffset,
        crossAxis: 0
      } : {
        mainAxis: 0,
        crossAxis: 0,
        ...rawOffset
      };
      if (checkMainAxis) {
        const len = mainAxis === 'y' ? 'height' : 'width';
        const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;
        const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;
        if (mainAxisCoord < limitMin) {
          mainAxisCoord = limitMin;
        } else if (mainAxisCoord > limitMax) {
          mainAxisCoord = limitMax;
        }
      }
      if (checkCrossAxis) {
        var _middlewareData$offse, _middlewareData$offse2;
        const len = mainAxis === 'y' ? 'width' : 'height';
        const isOriginSide = ['top', 'left'].includes(getSide(placement));
        const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);
        const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);
        if (crossAxisCoord < limitMin) {
          crossAxisCoord = limitMin;
        } else if (crossAxisCoord > limitMax) {
          crossAxisCoord = limitMax;
        }
      }
      return {
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      };
    }
  };
};

/**
 * Provides data that allows you to change the size of the floating element —
 * for instance, prevent it from overflowing the clipping boundary or match the
 * width of the reference element.
 * @see https://floating-ui.com/docs/size
 */
exports.limitShift = limitShift;
const size = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'size',
    options,
    async fn(state) {
      const {
        placement,
        rects,
        platform,
        elements
      } = state;
      const {
        apply = () => {},
        ...detectOverflowOptions
      } = evaluate(options, state);
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const side = getSide(placement);
      const alignment = getAlignment(placement);
      const axis = getMainAxisFromPlacement(placement);
      const isXAxis = axis === 'x';
      const {
        width,
        height
      } = rects.floating;
      let heightSide;
      let widthSide;
      if (side === 'top' || side === 'bottom') {
        heightSide = side;
        widthSide = alignment === ((await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating))) ? 'start' : 'end') ? 'left' : 'right';
      } else {
        widthSide = side;
        heightSide = alignment === 'end' ? 'top' : 'bottom';
      }
      const overflowAvailableHeight = height - overflow[heightSide];
      const overflowAvailableWidth = width - overflow[widthSide];
      const noShift = !state.middlewareData.shift;
      let availableHeight = overflowAvailableHeight;
      let availableWidth = overflowAvailableWidth;
      if (isXAxis) {
        const maximumClippingWidth = width - overflow.left - overflow.right;
        availableWidth = alignment || noShift ? min(overflowAvailableWidth, maximumClippingWidth) : maximumClippingWidth;
      } else {
        const maximumClippingHeight = height - overflow.top - overflow.bottom;
        availableHeight = alignment || noShift ? min(overflowAvailableHeight, maximumClippingHeight) : maximumClippingHeight;
      }
      if (noShift && !alignment) {
        const xMin = max(overflow.left, 0);
        const xMax = max(overflow.right, 0);
        const yMin = max(overflow.top, 0);
        const yMax = max(overflow.bottom, 0);
        if (isXAxis) {
          availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : max(overflow.left, overflow.right));
        } else {
          availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : max(overflow.top, overflow.bottom));
        }
      }
      await apply({
        ...state,
        availableWidth,
        availableHeight
      });
      const nextDimensions = await platform.getDimensions(elements.floating);
      if (width !== nextDimensions.width || height !== nextDimensions.height) {
        return {
          reset: {
            rects: true
          }
        };
      }
      return {};
    }
  };
};
exports.size = size;

/***/ }),

/***/ "../../../node_modules/@floating-ui/dom/dist/floating-ui.dom.esm.js":
/*!**************************************************************************!*\
  !*** ../../../node_modules/@floating-ui/dom/dist/floating-ui.dom.esm.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "arrow", ({
  enumerable: true,
  get: function () {
    return _core.arrow;
  }
}));
Object.defineProperty(exports, "autoPlacement", ({
  enumerable: true,
  get: function () {
    return _core.autoPlacement;
  }
}));
exports.autoUpdate = autoUpdate;
exports.computePosition = void 0;
Object.defineProperty(exports, "detectOverflow", ({
  enumerable: true,
  get: function () {
    return _core.detectOverflow;
  }
}));
Object.defineProperty(exports, "flip", ({
  enumerable: true,
  get: function () {
    return _core.flip;
  }
}));
exports.getOverflowAncestors = getOverflowAncestors;
Object.defineProperty(exports, "hide", ({
  enumerable: true,
  get: function () {
    return _core.hide;
  }
}));
Object.defineProperty(exports, "inline", ({
  enumerable: true,
  get: function () {
    return _core.inline;
  }
}));
Object.defineProperty(exports, "limitShift", ({
  enumerable: true,
  get: function () {
    return _core.limitShift;
  }
}));
Object.defineProperty(exports, "offset", ({
  enumerable: true,
  get: function () {
    return _core.offset;
  }
}));
exports.platform = void 0;
Object.defineProperty(exports, "shift", ({
  enumerable: true,
  get: function () {
    return _core.shift;
  }
}));
Object.defineProperty(exports, "size", ({
  enumerable: true,
  get: function () {
    return _core.size;
  }
}));
var _core = __webpack_require__(/*! @floating-ui/core */ "../../../node_modules/@floating-ui/core/dist/floating-ui.core.esm.js");
function getWindow(node) {
  var _node$ownerDocument;
  return ((_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}
function getComputedStyle$1(element) {
  return getWindow(element).getComputedStyle(element);
}
function isNode(value) {
  return value instanceof getWindow(value).Node;
}
function getNodeName(node) {
  return isNode(node) ? (node.nodeName || '').toLowerCase() : '';
}
function isHTMLElement(value) {
  return value instanceof getWindow(value).HTMLElement;
}
function isElement(value) {
  return value instanceof getWindow(value).Element;
}
function isShadowRoot(node) {
  // Browsers without `ShadowRoot` support.
  if (typeof ShadowRoot === 'undefined') {
    return false;
  }
  const OwnElement = getWindow(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}
function isOverflowElement(element) {
  const {
    overflow,
    overflowX,
    overflowY,
    display
  } = getComputedStyle$1(element);
  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !['inline', 'contents'].includes(display);
}
function isTableElement(element) {
  return ['table', 'td', 'th'].includes(getNodeName(element));
}
function isContainingBlock(element) {
  const safari = isSafari();
  const css = getComputedStyle$1(element);

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  return css.transform !== 'none' || css.perspective !== 'none' || !safari && (css.backdropFilter ? css.backdropFilter !== 'none' : false) || !safari && (css.filter ? css.filter !== 'none' : false) || ['transform', 'perspective', 'filter'].some(value => (css.willChange || '').includes(value)) || ['paint', 'layout', 'strict', 'content'].some(value => (css.contain || '').includes(value));
}
function isSafari() {
  if (typeof CSS === 'undefined' || !CSS.supports) return false;
  return CSS.supports('-webkit-backdrop-filter', 'none');
}
function isLastTraversableNode(node) {
  return ['html', 'body', '#document'].includes(getNodeName(node));
}
const min = Math.min;
const max = Math.max;
const round = Math.round;
function getCssDimensions(element) {
  const css = getComputedStyle$1(element);
  // In testing environments, the `width` and `height` properties are empty
  // strings for SVG elements, returning NaN. Fallback to `0` in this case.
  let width = parseFloat(css.width) || 0;
  let height = parseFloat(css.height) || 0;
  const hasOffset = isHTMLElement(element);
  const offsetWidth = hasOffset ? element.offsetWidth : width;
  const offsetHeight = hasOffset ? element.offsetHeight : height;
  const shouldFallback = round(width) !== offsetWidth || round(height) !== offsetHeight;
  if (shouldFallback) {
    width = offsetWidth;
    height = offsetHeight;
  }
  return {
    width,
    height,
    fallback: shouldFallback
  };
}
function unwrapElement(element) {
  return !isElement(element) ? element.contextElement : element;
}
const FALLBACK_SCALE = {
  x: 1,
  y: 1
};
function getScale(element) {
  const domElement = unwrapElement(element);
  if (!isHTMLElement(domElement)) {
    return FALLBACK_SCALE;
  }
  const rect = domElement.getBoundingClientRect();
  const {
    width,
    height,
    fallback
  } = getCssDimensions(domElement);
  let x = (fallback ? round(rect.width) : rect.width) / width;
  let y = (fallback ? round(rect.height) : rect.height) / height;

  // 0, NaN, or Infinity should always fallback to 1.

  if (!x || !Number.isFinite(x)) {
    x = 1;
  }
  if (!y || !Number.isFinite(y)) {
    y = 1;
  }
  return {
    x,
    y
  };
}
const noOffsets = {
  x: 0,
  y: 0
};
function getVisualOffsets(element, isFixed, floatingOffsetParent) {
  var _win$visualViewport, _win$visualViewport2;
  if (isFixed === void 0) {
    isFixed = true;
  }
  if (!isSafari()) {
    return noOffsets;
  }
  const win = element ? getWindow(element) : window;
  if (!floatingOffsetParent || isFixed && floatingOffsetParent !== win) {
    return noOffsets;
  }
  return {
    x: ((_win$visualViewport = win.visualViewport) == null ? void 0 : _win$visualViewport.offsetLeft) || 0,
    y: ((_win$visualViewport2 = win.visualViewport) == null ? void 0 : _win$visualViewport2.offsetTop) || 0
  };
}
function getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {
  if (includeScale === void 0) {
    includeScale = false;
  }
  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }
  const clientRect = element.getBoundingClientRect();
  const domElement = unwrapElement(element);
  let scale = FALLBACK_SCALE;
  if (includeScale) {
    if (offsetParent) {
      if (isElement(offsetParent)) {
        scale = getScale(offsetParent);
      }
    } else {
      scale = getScale(element);
    }
  }
  const visualOffsets = getVisualOffsets(domElement, isFixedStrategy, offsetParent);
  let x = (clientRect.left + visualOffsets.x) / scale.x;
  let y = (clientRect.top + visualOffsets.y) / scale.y;
  let width = clientRect.width / scale.x;
  let height = clientRect.height / scale.y;
  if (domElement) {
    const win = getWindow(domElement);
    const offsetWin = offsetParent && isElement(offsetParent) ? getWindow(offsetParent) : offsetParent;
    let currentIFrame = win.frameElement;
    while (currentIFrame && offsetParent && offsetWin !== win) {
      const iframeScale = getScale(currentIFrame);
      const iframeRect = currentIFrame.getBoundingClientRect();
      const css = getComputedStyle(currentIFrame);
      iframeRect.x += (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;
      iframeRect.y += (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;
      x *= iframeScale.x;
      y *= iframeScale.y;
      width *= iframeScale.x;
      height *= iframeScale.y;
      x += iframeRect.x;
      y += iframeRect.y;
      currentIFrame = getWindow(currentIFrame).frameElement;
    }
  }
  return (0, _core.rectToClientRect)({
    width,
    height,
    x,
    y
  });
}
function getDocumentElement(node) {
  return ((isNode(node) ? node.ownerDocument : node.document) || window.document).documentElement;
}
function getNodeScroll(element) {
  if (isElement(element)) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }
  return {
    scrollLeft: element.pageXOffset,
    scrollTop: element.pageYOffset
  };
}
function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
  let {
    rect,
    offsetParent,
    strategy
  } = _ref;
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  const documentElement = getDocumentElement(offsetParent);
  if (offsetParent === documentElement) {
    return rect;
  }
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  let scale = {
    x: 1,
    y: 1
  };
  const offsets = {
    x: 0,
    y: 0
  };
  if (isOffsetParentAnElement || !isOffsetParentAnElement && strategy !== 'fixed') {
    if (getNodeName(offsetParent) !== 'body' || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isHTMLElement(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent);
      scale = getScale(offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    }
  }
  return {
    width: rect.width * scale.x,
    height: rect.height * scale.y,
    x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x,
    y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y
  };
}
function getWindowScrollBarX(element) {
  // If <html> has a CSS width greater than the viewport, then this will be
  // incorrect for RTL.
  return getBoundingClientRect(getDocumentElement(element)).left + getNodeScroll(element).scrollLeft;
}

// Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable.
function getDocumentRect(element) {
  const html = getDocumentElement(element);
  const scroll = getNodeScroll(element);
  const body = element.ownerDocument.body;
  const width = max(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);
  const height = max(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);
  let x = -scroll.scrollLeft + getWindowScrollBarX(element);
  const y = -scroll.scrollTop;
  if (getComputedStyle$1(body).direction === 'rtl') {
    x += max(html.clientWidth, body.clientWidth) - width;
  }
  return {
    width,
    height,
    x,
    y
  };
}
function getParentNode(node) {
  if (getNodeName(node) === 'html') {
    return node;
  }
  const result =
  // Step into the shadow DOM of the parent of a slotted node.
  node.assignedSlot ||
  // DOM Element detected.
  node.parentNode ||
  // ShadowRoot detected.
  isShadowRoot(node) && node.host ||
  // Fallback.
  getDocumentElement(node);
  return isShadowRoot(result) ? result.host : result;
}
function getNearestOverflowAncestor(node) {
  const parentNode = getParentNode(node);
  if (isLastTraversableNode(parentNode)) {
    // `getParentNode` will never return a `Document` due to the fallback
    // check, so it's either the <html> or <body> element.
    return parentNode.ownerDocument.body;
  }
  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {
    return parentNode;
  }
  return getNearestOverflowAncestor(parentNode);
}
function getOverflowAncestors(node, list) {
  var _node$ownerDocument;
  if (list === void 0) {
    list = [];
  }
  const scrollableAncestor = getNearestOverflowAncestor(node);
  const isBody = scrollableAncestor === ((_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.body);
  const win = getWindow(scrollableAncestor);
  if (isBody) {
    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : []);
  }
  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor));
}
function getViewportRect(element, strategy) {
  const win = getWindow(element);
  const html = getDocumentElement(element);
  const visualViewport = win.visualViewport;
  let width = html.clientWidth;
  let height = html.clientHeight;
  let x = 0;
  let y = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    const visualViewportBased = isSafari();
    if (!visualViewportBased || visualViewportBased && strategy === 'fixed') {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }
  return {
    width,
    height,
    x,
    y
  };
}

// Returns the inner client rect, subtracting scrollbars if present.
function getInnerBoundingClientRect(element, strategy) {
  const clientRect = getBoundingClientRect(element, true, strategy === 'fixed');
  const top = clientRect.top + element.clientTop;
  const left = clientRect.left + element.clientLeft;
  const scale = isHTMLElement(element) ? getScale(element) : {
    x: 1,
    y: 1
  };
  const width = element.clientWidth * scale.x;
  const height = element.clientHeight * scale.y;
  const x = left * scale.x;
  const y = top * scale.y;
  return {
    width,
    height,
    x,
    y
  };
}
function getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {
  let rect;
  if (clippingAncestor === 'viewport') {
    rect = getViewportRect(element, strategy);
  } else if (clippingAncestor === 'document') {
    rect = getDocumentRect(getDocumentElement(element));
  } else if (isElement(clippingAncestor)) {
    rect = getInnerBoundingClientRect(clippingAncestor, strategy);
  } else {
    const visualOffsets = getVisualOffsets(element);
    rect = {
      ...clippingAncestor,
      x: clippingAncestor.x - visualOffsets.x,
      y: clippingAncestor.y - visualOffsets.y
    };
  }
  return (0, _core.rectToClientRect)(rect);
}
function hasFixedPositionAncestor(element, stopNode) {
  const parentNode = getParentNode(element);
  if (parentNode === stopNode || !isElement(parentNode) || isLastTraversableNode(parentNode)) {
    return false;
  }
  return getComputedStyle$1(parentNode).position === 'fixed' || hasFixedPositionAncestor(parentNode, stopNode);
}

// A "clipping ancestor" is an `overflow` element with the characteristic of
// clipping (or hiding) child elements. This returns all clipping ancestors
// of the given element up the tree.
function getClippingElementAncestors(element, cache) {
  const cachedResult = cache.get(element);
  if (cachedResult) {
    return cachedResult;
  }
  let result = getOverflowAncestors(element).filter(el => isElement(el) && getNodeName(el) !== 'body');
  let currentContainingBlockComputedStyle = null;
  const elementIsFixed = getComputedStyle$1(element).position === 'fixed';
  let currentNode = elementIsFixed ? getParentNode(element) : element;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  while (isElement(currentNode) && !isLastTraversableNode(currentNode)) {
    const computedStyle = getComputedStyle$1(currentNode);
    const currentNodeIsContaining = isContainingBlock(currentNode);
    if (!currentNodeIsContaining && computedStyle.position === 'fixed') {
      currentContainingBlockComputedStyle = null;
    }
    const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === 'static' && !!currentContainingBlockComputedStyle && ['absolute', 'fixed'].includes(currentContainingBlockComputedStyle.position) || isOverflowElement(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);
    if (shouldDropCurrentNode) {
      // Drop non-containing blocks.
      result = result.filter(ancestor => ancestor !== currentNode);
    } else {
      // Record last containing block for next iteration.
      currentContainingBlockComputedStyle = computedStyle;
    }
    currentNode = getParentNode(currentNode);
  }
  cache.set(element, result);
  return result;
}

// Gets the maximum area that the element is visible in due to any number of
// clipping ancestors.
function getClippingRect(_ref) {
  let {
    element,
    boundary,
    rootBoundary,
    strategy
  } = _ref;
  const elementClippingAncestors = boundary === 'clippingAncestors' ? getClippingElementAncestors(element, this._c) : [].concat(boundary);
  const clippingAncestors = [...elementClippingAncestors, rootBoundary];
  const firstClippingAncestor = clippingAncestors[0];
  const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
    const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);
    accRect.top = max(rect.top, accRect.top);
    accRect.right = min(rect.right, accRect.right);
    accRect.bottom = min(rect.bottom, accRect.bottom);
    accRect.left = max(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));
  return {
    width: clippingRect.right - clippingRect.left,
    height: clippingRect.bottom - clippingRect.top,
    x: clippingRect.left,
    y: clippingRect.top
  };
}
function getDimensions(element) {
  return getCssDimensions(element);
}
function getTrueOffsetParent(element, polyfill) {
  if (!isHTMLElement(element) || getComputedStyle$1(element).position === 'fixed') {
    return null;
  }
  if (polyfill) {
    return polyfill(element);
  }
  return element.offsetParent;
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {
    if (isContainingBlock(currentNode)) {
      return currentNode;
    } else {
      currentNode = getParentNode(currentNode);
    }
  }
  return null;
}

// Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.
function getOffsetParent(element, polyfill) {
  const window = getWindow(element);
  if (!isHTMLElement(element)) {
    return window;
  }
  let offsetParent = getTrueOffsetParent(element, polyfill);
  while (offsetParent && isTableElement(offsetParent) && getComputedStyle$1(offsetParent).position === 'static') {
    offsetParent = getTrueOffsetParent(offsetParent, polyfill);
  }
  if (offsetParent && (getNodeName(offsetParent) === 'html' || getNodeName(offsetParent) === 'body' && getComputedStyle$1(offsetParent).position === 'static' && !isContainingBlock(offsetParent))) {
    return window;
  }
  return offsetParent || getContainingBlock(element) || window;
}
function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  const documentElement = getDocumentElement(offsetParent);
  const isFixed = strategy === 'fixed';
  const rect = getBoundingClientRect(element, true, isFixed, offsetParent);
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = {
    x: 0,
    y: 0
  };
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== 'body' || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isHTMLElement(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = getWindowScrollBarX(documentElement);
    }
  }
  return {
    x: rect.left + scroll.scrollLeft - offsets.x,
    y: rect.top + scroll.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height
  };
}
const platform = exports.platform = {
  getClippingRect,
  convertOffsetParentRelativeRectToViewportRelativeRect,
  isElement,
  getDimensions,
  getOffsetParent,
  getDocumentElement,
  getScale,
  async getElementRects(_ref) {
    let {
      reference,
      floating,
      strategy
    } = _ref;
    const getOffsetParentFn = this.getOffsetParent || getOffsetParent;
    const getDimensionsFn = this.getDimensions;
    return {
      reference: getRectRelativeToOffsetParent(reference, await getOffsetParentFn(floating), strategy),
      floating: {
        x: 0,
        y: 0,
        ...(await getDimensionsFn(floating))
      }
    };
  },
  getClientRects: element => Array.from(element.getClientRects()),
  isRTL: element => getComputedStyle$1(element).direction === 'rtl'
};

/**
 * Automatically updates the position of the floating element when necessary.
 * Should only be called when the floating element is mounted on the DOM or
 * visible on the screen.
 * @returns cleanup function that should be invoked when the floating element is
 * removed from the DOM or hidden from the screen.
 * @see https://floating-ui.com/docs/autoUpdate
 */
function autoUpdate(reference, floating, update, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    ancestorScroll = true,
    ancestorResize = true,
    elementResize = true,
    animationFrame = false
  } = options;
  const ancestors = ancestorScroll || ancestorResize ? [...(isElement(reference) ? getOverflowAncestors(reference) : reference.contextElement ? getOverflowAncestors(reference.contextElement) : []), ...getOverflowAncestors(floating)] : [];
  ancestors.forEach(ancestor => {
    // ignores Window, checks for [object VisualViewport]
    const isVisualViewport = !isElement(ancestor) && ancestor.toString().includes('V');
    if (ancestorScroll && (animationFrame ? isVisualViewport : true)) {
      ancestor.addEventListener('scroll', update, {
        passive: true
      });
    }
    ancestorResize && ancestor.addEventListener('resize', update);
  });
  let observer = null;
  if (elementResize) {
    observer = new ResizeObserver(() => {
      update();
    });
    isElement(reference) && !animationFrame && observer.observe(reference);
    if (!isElement(reference) && reference.contextElement && !animationFrame) {
      observer.observe(reference.contextElement);
    }
    observer.observe(floating);
  }
  let frameId;
  let prevRefRect = animationFrame ? getBoundingClientRect(reference) : null;
  if (animationFrame) {
    frameLoop();
  }
  function frameLoop() {
    const nextRefRect = getBoundingClientRect(reference);
    if (prevRefRect && (nextRefRect.x !== prevRefRect.x || nextRefRect.y !== prevRefRect.y || nextRefRect.width !== prevRefRect.width || nextRefRect.height !== prevRefRect.height)) {
      update();
    }
    prevRefRect = nextRefRect;
    frameId = requestAnimationFrame(frameLoop);
  }
  update();
  return () => {
    var _observer;
    ancestors.forEach(ancestor => {
      ancestorScroll && ancestor.removeEventListener('scroll', update);
      ancestorResize && ancestor.removeEventListener('resize', update);
    });
    (_observer = observer) == null ? void 0 : _observer.disconnect();
    observer = null;
    if (animationFrame) {
      cancelAnimationFrame(frameId);
    }
  };
}

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a reference element when it is given a certain CSS positioning
 * strategy.
 */
const computePosition = (reference, floating, options) => {
  // This caches the expensive `getClippingElementAncestors` function so that
  // multiple lifecycle resets re-use the same result. It only lives for a
  // single call. If other functions become expensive, we can add them as well.
  const cache = new Map();
  const mergedOptions = {
    platform,
    ...options
  };
  const platformWithCache = {
    ...mergedOptions.platform,
    _c: cache
  };
  return (0, _core.computePosition)(reference, floating, {
    ...mergedOptions,
    platform: platformWithCache
  });
};
exports.computePosition = computePosition;

/***/ }),

/***/ "../../../node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.esm.js":
/*!**************************************************************************************!*\
  !*** ../../../node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.esm.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.arrow = void 0;
Object.defineProperty(exports, "autoPlacement", ({
  enumerable: true,
  get: function () {
    return _dom.autoPlacement;
  }
}));
Object.defineProperty(exports, "autoUpdate", ({
  enumerable: true,
  get: function () {
    return _dom.autoUpdate;
  }
}));
Object.defineProperty(exports, "computePosition", ({
  enumerable: true,
  get: function () {
    return _dom.computePosition;
  }
}));
Object.defineProperty(exports, "detectOverflow", ({
  enumerable: true,
  get: function () {
    return _dom.detectOverflow;
  }
}));
Object.defineProperty(exports, "flip", ({
  enumerable: true,
  get: function () {
    return _dom.flip;
  }
}));
Object.defineProperty(exports, "getOverflowAncestors", ({
  enumerable: true,
  get: function () {
    return _dom.getOverflowAncestors;
  }
}));
Object.defineProperty(exports, "hide", ({
  enumerable: true,
  get: function () {
    return _dom.hide;
  }
}));
Object.defineProperty(exports, "inline", ({
  enumerable: true,
  get: function () {
    return _dom.inline;
  }
}));
Object.defineProperty(exports, "limitShift", ({
  enumerable: true,
  get: function () {
    return _dom.limitShift;
  }
}));
Object.defineProperty(exports, "offset", ({
  enumerable: true,
  get: function () {
    return _dom.offset;
  }
}));
Object.defineProperty(exports, "platform", ({
  enumerable: true,
  get: function () {
    return _dom.platform;
  }
}));
Object.defineProperty(exports, "shift", ({
  enumerable: true,
  get: function () {
    return _dom.shift;
  }
}));
Object.defineProperty(exports, "size", ({
  enumerable: true,
  get: function () {
    return _dom.size;
  }
}));
exports.useFloating = useFloating;
var _dom = __webpack_require__(/*! @floating-ui/dom */ "../../../node_modules/@floating-ui/dom/dist/floating-ui.dom.esm.js");
var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "react"));
var React = _react;
var ReactDOM = _interopRequireWildcard(__webpack_require__(/*! react-dom */ "react-dom"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * This wraps the core `arrow` middleware to allow React refs as the element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow = options => {
  function isRef(value) {
    return {}.hasOwnProperty.call(value, 'current');
  }
  return {
    name: 'arrow',
    options,
    fn(state) {
      const {
        element,
        padding
      } = typeof options === 'function' ? options(state) : options;
      if (element && isRef(element)) {
        if (element.current != null) {
          return (0, _dom.arrow)({
            element: element.current,
            padding
          }).fn(state);
        }
        return {};
      } else if (element) {
        return (0, _dom.arrow)({
          element,
          padding
        }).fn(state);
      }
      return {};
    }
  };
};
exports.arrow = arrow;
var index = typeof document !== 'undefined' ? _react.useLayoutEffect : _react.useEffect;

// Fork of `fast-deep-equal` that only does the comparisons we need and compares
// functions
function deepEqual(a, b) {
  if (a === b) {
    return true;
  }
  if (typeof a !== typeof b) {
    return false;
  }
  if (typeof a === 'function' && a.toString() === b.toString()) {
    return true;
  }
  let length, i, keys;
  if (a && b && typeof a == 'object') {
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;) {
        if (!deepEqual(a[i], b[i])) {
          return false;
        }
      }
      return true;
    }
    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) {
      return false;
    }
    for (i = length; i-- !== 0;) {
      if (!{}.hasOwnProperty.call(b, keys[i])) {
        return false;
      }
    }
    for (i = length; i-- !== 0;) {
      const key = keys[i];
      if (key === '_owner' && a.$$typeof) {
        continue;
      }
      if (!deepEqual(a[key], b[key])) {
        return false;
      }
    }
    return true;
  }
  return a !== a && b !== b;
}
function getDPR(element) {
  if (typeof window === 'undefined') {
    return 1;
  }
  const win = element.ownerDocument.defaultView || window;
  return win.devicePixelRatio || 1;
}
function roundByDPR(element, value) {
  const dpr = getDPR(element);
  return Math.round(value * dpr) / dpr;
}
function useLatestRef(value) {
  const ref = React.useRef(value);
  index(() => {
    ref.current = value;
  });
  return ref;
}

/**
 * Provides data to position a floating element.
 * @see https://floating-ui.com/docs/react
 */
function useFloating(options) {
  if (options === void 0) {
    options = {};
  }
  const {
    placement = 'bottom',
    strategy = 'absolute',
    middleware = [],
    platform,
    elements: {
      reference: externalReference,
      floating: externalFloating
    } = {},
    transform = true,
    whileElementsMounted,
    open
  } = options;
  const [data, setData] = React.useState({
    x: 0,
    y: 0,
    strategy,
    placement,
    middlewareData: {},
    isPositioned: false
  });
  const [latestMiddleware, setLatestMiddleware] = React.useState(middleware);
  if (!deepEqual(latestMiddleware, middleware)) {
    setLatestMiddleware(middleware);
  }
  const [_reference, _setReference] = React.useState(null);
  const [_floating, _setFloating] = React.useState(null);
  const setReference = React.useCallback(node => {
    if (node != referenceRef.current) {
      referenceRef.current = node;
      _setReference(node);
    }
  }, [_setReference]);
  const setFloating = React.useCallback(node => {
    if (node !== floatingRef.current) {
      floatingRef.current = node;
      _setFloating(node);
    }
  }, [_setFloating]);
  const referenceEl = externalReference || _reference;
  const floatingEl = externalFloating || _floating;
  const referenceRef = React.useRef(null);
  const floatingRef = React.useRef(null);
  const dataRef = React.useRef(data);
  const whileElementsMountedRef = useLatestRef(whileElementsMounted);
  const platformRef = useLatestRef(platform);
  const update = React.useCallback(() => {
    if (!referenceRef.current || !floatingRef.current) {
      return;
    }
    const config = {
      placement,
      strategy,
      middleware: latestMiddleware
    };
    if (platformRef.current) {
      config.platform = platformRef.current;
    }
    (0, _dom.computePosition)(referenceRef.current, floatingRef.current, config).then(data => {
      const fullData = {
        ...data,
        isPositioned: true
      };
      if (isMountedRef.current && !deepEqual(dataRef.current, fullData)) {
        dataRef.current = fullData;
        ReactDOM.flushSync(() => {
          setData(fullData);
        });
      }
    });
  }, [latestMiddleware, placement, strategy, platformRef]);
  index(() => {
    if (open === false && dataRef.current.isPositioned) {
      dataRef.current.isPositioned = false;
      setData(data => ({
        ...data,
        isPositioned: false
      }));
    }
  }, [open]);
  const isMountedRef = React.useRef(false);
  index(() => {
    isMountedRef.current = true;
    return () => {
      isMountedRef.current = false;
    };
  }, []);
  index(() => {
    if (referenceEl) referenceRef.current = referenceEl;
    if (floatingEl) floatingRef.current = floatingEl;
    if (referenceEl && floatingEl) {
      if (whileElementsMountedRef.current) {
        return whileElementsMountedRef.current(referenceEl, floatingEl, update);
      } else {
        update();
      }
    }
  }, [referenceEl, floatingEl, update, whileElementsMountedRef]);
  const refs = React.useMemo(() => ({
    reference: referenceRef,
    floating: floatingRef,
    setReference,
    setFloating
  }), [setReference, setFloating]);
  const elements = React.useMemo(() => ({
    reference: referenceEl,
    floating: floatingEl
  }), [referenceEl, floatingEl]);
  const floatingStyles = React.useMemo(() => {
    const initialStyles = {
      position: strategy,
      left: 0,
      top: 0
    };
    if (!elements.floating) {
      return initialStyles;
    }
    const x = roundByDPR(elements.floating, data.x);
    const y = roundByDPR(elements.floating, data.y);
    if (transform) {
      return {
        ...initialStyles,
        transform: "translate(" + x + "px, " + y + "px)",
        ...(getDPR(elements.floating) >= 1.5 && {
          willChange: 'transform'
        })
      };
    }
    return {
      position: strategy,
      left: x,
      top: y
    };
  }, [strategy, transform, elements.floating, data.x, data.y]);
  return React.useMemo(() => ({
    ...data,
    update,
    refs,
    elements,
    floatingStyles
  }), [data, update, refs, elements, floatingStyles]);
}

/***/ }),

/***/ "../../../node_modules/@motionone/animation/dist/Animation.es.js":
/*!***********************************************************************!*\
  !*** ../../../node_modules/@motionone/animation/dist/Animation.es.js ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Animation = void 0;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _easingEs = __webpack_require__(/*! ./utils/easing.es.js */ "../../../node_modules/@motionone/animation/dist/utils/easing.es.js");
class Animation {
  constructor(output, keyframes = [0, 1], {
    easing,
    duration: initialDuration = _utils.defaults.duration,
    delay = _utils.defaults.delay,
    endDelay = _utils.defaults.endDelay,
    repeat = _utils.defaults.repeat,
    offset,
    direction = "normal"
  } = {}) {
    this.startTime = null;
    this.rate = 1;
    this.t = 0;
    this.cancelTimestamp = null;
    this.easing = _utils.noopReturn;
    this.duration = 0;
    this.totalDuration = 0;
    this.repeat = 0;
    this.playState = "idle";
    this.finished = new Promise((resolve, reject) => {
      this.resolve = resolve;
      this.reject = reject;
    });
    easing = easing || _utils.defaults.easing;
    if ((0, _utils.isEasingGenerator)(easing)) {
      const custom = easing.createAnimation(keyframes);
      easing = custom.easing;
      keyframes = custom.keyframes || keyframes;
      initialDuration = custom.duration || initialDuration;
    }
    this.repeat = repeat;
    this.easing = (0, _utils.isEasingList)(easing) ? _utils.noopReturn : (0, _easingEs.getEasingFunction)(easing);
    this.updateDuration(initialDuration);
    const interpolate$1 = (0, _utils.interpolate)(keyframes, offset, (0, _utils.isEasingList)(easing) ? easing.map(_easingEs.getEasingFunction) : _utils.noopReturn);
    this.tick = timestamp => {
      var _a;
      // TODO: Temporary fix for OptionsResolver typing
      delay = delay;
      let t = 0;
      if (this.pauseTime !== undefined) {
        t = this.pauseTime;
      } else {
        t = (timestamp - this.startTime) * this.rate;
      }
      this.t = t;
      // Convert to seconds
      t /= 1000;
      // Rebase on delay
      t = Math.max(t - delay, 0);
      /**
       * If this animation has finished, set the current time
       * to the total duration.
       */
      if (this.playState === "finished" && this.pauseTime === undefined) {
        t = this.totalDuration;
      }
      /**
       * Get the current progress (0-1) of the animation. If t is >
       * than duration we'll get values like 2.5 (midway through the
       * third iteration)
       */
      const progress = t / this.duration;
      // TODO progress += iterationStart
      /**
       * Get the current iteration (0 indexed). For instance the floor of
       * 2.5 is 2.
       */
      let currentIteration = Math.floor(progress);
      /**
       * Get the current progress of the iteration by taking the remainder
       * so 2.5 is 0.5 through iteration 2
       */
      let iterationProgress = progress % 1.0;
      if (!iterationProgress && progress >= 1) {
        iterationProgress = 1;
      }
      /**
       * If iteration progress is 1 we count that as the end
       * of the previous iteration.
       */
      iterationProgress === 1 && currentIteration--;
      /**
       * Reverse progress if we're not running in "normal" direction
       */
      const iterationIsOdd = currentIteration % 2;
      if (direction === "reverse" || direction === "alternate" && iterationIsOdd || direction === "alternate-reverse" && !iterationIsOdd) {
        iterationProgress = 1 - iterationProgress;
      }
      const p = t >= this.totalDuration ? 1 : Math.min(iterationProgress, 1);
      const latest = interpolate$1(this.easing(p));
      output(latest);
      const isAnimationFinished = this.pauseTime === undefined && (this.playState === "finished" || t >= this.totalDuration + endDelay);
      if (isAnimationFinished) {
        this.playState = "finished";
        (_a = this.resolve) === null || _a === void 0 ? void 0 : _a.call(this, latest);
      } else if (this.playState !== "idle") {
        this.frameRequestId = requestAnimationFrame(this.tick);
      }
    };
    this.play();
  }
  play() {
    const now = performance.now();
    this.playState = "running";
    if (this.pauseTime !== undefined) {
      this.startTime = now - this.pauseTime;
    } else if (!this.startTime) {
      this.startTime = now;
    }
    this.cancelTimestamp = this.startTime;
    this.pauseTime = undefined;
    this.frameRequestId = requestAnimationFrame(this.tick);
  }
  pause() {
    this.playState = "paused";
    this.pauseTime = this.t;
  }
  finish() {
    this.playState = "finished";
    this.tick(0);
  }
  stop() {
    var _a;
    this.playState = "idle";
    if (this.frameRequestId !== undefined) {
      cancelAnimationFrame(this.frameRequestId);
    }
    (_a = this.reject) === null || _a === void 0 ? void 0 : _a.call(this, false);
  }
  cancel() {
    this.stop();
    this.tick(this.cancelTimestamp);
  }
  reverse() {
    this.rate *= -1;
  }
  commitStyles() {}
  updateDuration(duration) {
    this.duration = duration;
    this.totalDuration = duration * (this.repeat + 1);
  }
  get currentTime() {
    return this.t;
  }
  set currentTime(t) {
    if (this.pauseTime !== undefined || this.rate === 0) {
      this.pauseTime = t;
    } else {
      this.startTime = performance.now() - t / this.rate;
    }
  }
  get playbackRate() {
    return this.rate;
  }
  set playbackRate(rate) {
    this.rate = rate;
  }
}
exports.Animation = Animation;

/***/ }),

/***/ "../../../node_modules/@motionone/animation/dist/index.es.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@motionone/animation/dist/index.es.js ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Animation", ({
  enumerable: true,
  get: function () {
    return _AnimationEs.Animation;
  }
}));
Object.defineProperty(exports, "getEasingFunction", ({
  enumerable: true,
  get: function () {
    return _easingEs.getEasingFunction;
  }
}));
var _AnimationEs = __webpack_require__(/*! ./Animation.es.js */ "../../../node_modules/@motionone/animation/dist/Animation.es.js");
var _easingEs = __webpack_require__(/*! ./utils/easing.es.js */ "../../../node_modules/@motionone/animation/dist/utils/easing.es.js");

/***/ }),

/***/ "../../../node_modules/@motionone/animation/dist/utils/easing.es.js":
/*!**************************************************************************!*\
  !*** ../../../node_modules/@motionone/animation/dist/utils/easing.es.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getEasingFunction = getEasingFunction;
var _easing = __webpack_require__(/*! @motionone/easing */ "../../../node_modules/@motionone/easing/dist/index.es.js");
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
const namedEasings = {
  ease: (0, _easing.cubicBezier)(0.25, 0.1, 0.25, 1.0),
  "ease-in": (0, _easing.cubicBezier)(0.42, 0.0, 1.0, 1.0),
  "ease-in-out": (0, _easing.cubicBezier)(0.42, 0.0, 0.58, 1.0),
  "ease-out": (0, _easing.cubicBezier)(0.0, 0.0, 0.58, 1.0)
};
const functionArgsRegex = /\((.*?)\)/;
function getEasingFunction(definition) {
  // If already an easing function, return
  if ((0, _utils.isFunction)(definition)) return definition;
  // If an easing curve definition, return bezier function
  if ((0, _utils.isCubicBezier)(definition)) return (0, _easing.cubicBezier)(...definition);
  // If we have a predefined easing function, return
  if (namedEasings[definition]) return namedEasings[definition];
  // If this is a steps function, attempt to create easing curve
  if (definition.startsWith("steps")) {
    const args = functionArgsRegex.exec(definition);
    if (args) {
      const argsArray = args[1].split(",");
      return (0, _easing.steps)(parseFloat(argsArray[0]), argsArray[1].trim());
    }
  }
  return _utils.noopReturn;
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/animate-style.es.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/animate-style.es.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.animateStyle = animateStyle;
var _dataEs = __webpack_require__(/*! ./data.es.js */ "../../../node_modules/@motionone/dom/dist/animate/data.es.js");
var _cssVarEs = __webpack_require__(/*! ./utils/css-var.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/css-var.es.js");
var _animation = __webpack_require__(/*! @motionone/animation */ "../../../node_modules/@motionone/animation/dist/index.es.js");
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _transformsEs = __webpack_require__(/*! ./utils/transforms.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/transforms.es.js");
var _easingEs = __webpack_require__(/*! ./utils/easing.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/easing.es.js");
var _featureDetectionEs = __webpack_require__(/*! ./utils/feature-detection.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/feature-detection.es.js");
var _keyframesEs = __webpack_require__(/*! ./utils/keyframes.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/keyframes.es.js");
var _styleEs = __webpack_require__(/*! ./style.es.js */ "../../../node_modules/@motionone/dom/dist/animate/style.es.js");
var _getStyleNameEs = __webpack_require__(/*! ./utils/get-style-name.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/get-style-name.es.js");
var _stopAnimationEs = __webpack_require__(/*! ./utils/stop-animation.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/stop-animation.es.js");
function getDevToolsRecord() {
  return window.__MOTION_DEV_TOOLS_RECORD;
}
function animateStyle(element, key, keyframesDefinition, options = {}) {
  const record = getDevToolsRecord();
  const isRecording = options.record !== false && record;
  let animation;
  let {
    duration = _utils.defaults.duration,
    delay = _utils.defaults.delay,
    endDelay = _utils.defaults.endDelay,
    repeat = _utils.defaults.repeat,
    easing = _utils.defaults.easing,
    direction,
    offset,
    allowWebkitAcceleration = false
  } = options;
  const data = (0, _dataEs.getAnimationData)(element);
  let canAnimateNatively = _featureDetectionEs.supports.waapi();
  const valueIsTransform = (0, _transformsEs.isTransform)(key);
  /**
   * If this is an individual transform, we need to map its
   * key to a CSS variable and update the element's transform style
   */
  valueIsTransform && (0, _transformsEs.addTransformToElement)(element, key);
  const name = (0, _getStyleNameEs.getStyleName)(key);
  const motionValue = (0, _dataEs.getMotionValue)(data.values, name);
  /**
   * Get definition of value, this will be used to convert numerical
   * keyframes into the default value type.
   */
  const definition = _transformsEs.transformDefinitions.get(name);
  /**
   * Stop the current animation, if any. Because this will trigger
   * commitStyles (DOM writes) and we might later trigger DOM reads,
   * this is fired now and we return a factory function to create
   * the actual animation that can get called in batch,
   */
  (0, _stopAnimationEs.stopAnimation)(motionValue.animation, !((0, _utils.isEasingGenerator)(easing) && motionValue.generator) && options.record !== false);
  /**
   * Batchable factory function containing all DOM reads.
   */
  return () => {
    const readInitialValue = () => {
      var _a, _b;
      return (_b = (_a = _styleEs.style.get(element, name)) !== null && _a !== void 0 ? _a : definition === null || definition === void 0 ? void 0 : definition.initialValue) !== null && _b !== void 0 ? _b : 0;
    };
    /**
     * Replace null values with the previous keyframe value, or read
     * it from the DOM if it's the first keyframe.
     */
    let keyframes = (0, _keyframesEs.hydrateKeyframes)((0, _keyframesEs.keyframesList)(keyframesDefinition), readInitialValue);
    if ((0, _utils.isEasingGenerator)(easing)) {
      const custom = easing.createAnimation(keyframes, readInitialValue, valueIsTransform, name, motionValue);
      easing = custom.easing;
      if (custom.keyframes !== undefined) keyframes = custom.keyframes;
      if (custom.duration !== undefined) duration = custom.duration;
    }
    /**
     * If this is a CSS variable we need to register it with the browser
     * before it can be animated natively. We also set it with setProperty
     * rather than directly onto the element.style object.
     */
    if ((0, _cssVarEs.isCssVar)(name)) {
      if (_featureDetectionEs.supports.cssRegisterProperty()) {
        (0, _cssVarEs.registerCssVariable)(name);
      } else {
        canAnimateNatively = false;
      }
    }
    /**
     * If we can animate this value with WAAPI, do so. Currently this only
     * feature detects CSS.registerProperty but could check WAAPI too.
     */
    if (canAnimateNatively) {
      /**
       * Convert numbers to default value types. Currently this only supports
       * transforms but it could also support other value types.
       */
      if (definition) {
        keyframes = keyframes.map(value => (0, _utils.isNumber)(value) ? definition.toDefaultUnit(value) : value);
      }
      /**
       * If this browser doesn't support partial/implicit keyframes we need to
       * explicitly provide one.
       */
      if (keyframes.length === 1 && (!_featureDetectionEs.supports.partialKeyframes() || isRecording)) {
        keyframes.unshift(readInitialValue());
      }
      const animationOptions = {
        delay: _utils.time.ms(delay),
        duration: _utils.time.ms(duration),
        endDelay: _utils.time.ms(endDelay),
        easing: !(0, _utils.isEasingList)(easing) ? (0, _easingEs.convertEasing)(easing) : undefined,
        direction,
        iterations: repeat + 1,
        fill: "both"
      };
      animation = element.animate({
        [name]: keyframes,
        offset,
        easing: (0, _utils.isEasingList)(easing) ? easing.map(_easingEs.convertEasing) : undefined
      }, animationOptions);
      /**
       * Polyfill finished Promise in browsers that don't support it
       */
      if (!animation.finished) {
        animation.finished = new Promise((resolve, reject) => {
          animation.onfinish = resolve;
          animation.oncancel = reject;
        });
      }
      const target = keyframes[keyframes.length - 1];
      animation.finished.then(() => {
        // Apply styles to target
        _styleEs.style.set(element, name, target);
        // Ensure fill modes don't persist
        animation.cancel();
      }).catch(_utils.noop);
      /**
       * This forces Webkit to run animations on the main thread by exploiting
       * this condition:
       * https://trac.webkit.org/browser/webkit/trunk/Source/WebCore/platform/graphics/ca/GraphicsLayerCA.cpp?rev=281238#L1099
       *
       * This fixes Webkit's timing bugs, like accelerated animations falling
       * out of sync with main thread animations and massive delays in starting
       * accelerated animations in WKWebView.
       */
      if (!allowWebkitAcceleration) animation.playbackRate = 1.000001;
      /**
       * If we can't animate the value natively then we can fallback to the numbers-only
       * polyfill for transforms.
       */
    } else if (valueIsTransform) {
      /**
       * If any keyframe is a string (because we measured it from the DOM), we need to convert
       * it into a number before passing to the Animation polyfill.
       */
      keyframes = keyframes.map(value => typeof value === "string" ? parseFloat(value) : value);
      /**
       * If we only have a single keyframe, we need to create an initial keyframe by reading
       * the current value from the DOM.
       */
      if (keyframes.length === 1) {
        keyframes.unshift(parseFloat(readInitialValue()));
      }
      const render = latest => {
        if (definition) latest = definition.toDefaultUnit(latest);
        _styleEs.style.set(element, name, latest);
      };
      animation = new _animation.Animation(render, keyframes, Object.assign(Object.assign({}, options), {
        duration,
        easing
      }));
    } else {
      const target = keyframes[keyframes.length - 1];
      _styleEs.style.set(element, name, definition && (0, _utils.isNumber)(target) ? definition.toDefaultUnit(target) : target);
    }
    if (isRecording) {
      record(element, key, keyframes, {
        duration,
        delay: delay,
        easing,
        repeat,
        offset
      }, "motion-one");
    }
    motionValue.setAnimation(animation);
    return animation;
  };
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/data.es.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/data.es.js ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getAnimationData = getAnimationData;
exports.getMotionValue = getMotionValue;
var _types = __webpack_require__(/*! @motionone/types */ "../../../node_modules/@motionone/types/dist/index.es.js");
const data = new WeakMap();
function getAnimationData(element) {
  if (!data.has(element)) {
    data.set(element, {
      transforms: [],
      values: new Map()
    });
  }
  return data.get(element);
}
function getMotionValue(motionValues, name) {
  if (!motionValues.has(name)) {
    motionValues.set(name, new _types.MotionValue());
  }
  return motionValues.get(name);
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/index.es.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/index.es.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.animate = animate;
var _animateStyleEs = __webpack_require__(/*! ./animate-style.es.js */ "../../../node_modules/@motionone/dom/dist/animate/animate-style.es.js");
var _optionsEs = __webpack_require__(/*! ./utils/options.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/options.es.js");
var _resolveElementsEs = __webpack_require__(/*! ../utils/resolve-elements.es.js */ "../../../node_modules/@motionone/dom/dist/utils/resolve-elements.es.js");
var _controlsEs = __webpack_require__(/*! ./utils/controls.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/controls.es.js");
var _staggerEs = __webpack_require__(/*! ../utils/stagger.es.js */ "../../../node_modules/@motionone/dom/dist/utils/stagger.es.js");
function animate(elements, keyframes, options = {}) {
  elements = (0, _resolveElementsEs.resolveElements)(elements);
  const numElements = elements.length;
  /**
   * Create and start new animations
   */
  const animationFactories = [];
  for (let i = 0; i < numElements; i++) {
    const element = elements[i];
    for (const key in keyframes) {
      const valueOptions = (0, _optionsEs.getOptions)(options, key);
      valueOptions.delay = (0, _staggerEs.resolveOption)(valueOptions.delay, i, numElements);
      const animation = (0, _animateStyleEs.animateStyle)(element, key, keyframes[key], valueOptions);
      animationFactories.push(animation);
    }
  }
  return (0, _controlsEs.withControls)(animationFactories, options,
  /**
   * TODO:
   * If easing is set to spring or glide, duration will be dynamically
   * generated. Ideally we would dynamically generate this from
   * animation.effect.getComputedTiming().duration but this isn't
   * supported in iOS13 or our number polyfill. Perhaps it's possible
   * to Proxy animations returned from animateStyle that has duration
   * as a getter.
   */
  options.duration);
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/style.es.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/style.es.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.style = void 0;
var _cssVarEs = __webpack_require__(/*! ./utils/css-var.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/css-var.es.js");
var _getStyleNameEs = __webpack_require__(/*! ./utils/get-style-name.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/get-style-name.es.js");
var _transformsEs = __webpack_require__(/*! ./utils/transforms.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/transforms.es.js");
const style = exports.style = {
  get: (element, name) => {
    name = (0, _getStyleNameEs.getStyleName)(name);
    let value = (0, _cssVarEs.isCssVar)(name) ? element.style.getPropertyValue(name) : getComputedStyle(element)[name];
    if (!value && value !== 0) {
      const definition = _transformsEs.transformDefinitions.get(name);
      if (definition) value = definition.initialValue;
    }
    return value;
  },
  set: (element, name, value) => {
    name = (0, _getStyleNameEs.getStyleName)(name);
    if ((0, _cssVarEs.isCssVar)(name)) {
      element.style.setProperty(name, value);
    } else {
      element.style[name] = value;
    }
  }
};

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/utils/controls.es.js":
/*!******************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/utils/controls.es.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.withControls = exports.controls = void 0;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _stopAnimationEs = __webpack_require__(/*! ./stop-animation.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/stop-animation.es.js");
const createAnimation = factory => factory();
const withControls = (animationFactory, options, duration = _utils.defaults.duration) => {
  return new Proxy({
    animations: animationFactory.map(createAnimation).filter(Boolean),
    duration,
    options
  }, controls);
};
/**
 * TODO:
 * Currently this returns the first animation, ideally it would return
 * the first active animation.
 */
exports.withControls = withControls;
const getActiveAnimation = state => state.animations[0];
const controls = exports.controls = {
  get: (target, key) => {
    const activeAnimation = getActiveAnimation(target);
    switch (key) {
      case "duration":
        return target.duration;
      case "currentTime":
        return _utils.time.s((activeAnimation === null || activeAnimation === void 0 ? void 0 : activeAnimation[key]) || 0);
      case "playbackRate":
      case "playState":
        return activeAnimation === null || activeAnimation === void 0 ? void 0 : activeAnimation[key];
      case "finished":
        if (!target.finished) {
          target.finished = Promise.all(target.animations.map(selectFinished)).catch(_utils.noop);
        }
        return target.finished;
      case "stop":
        return () => {
          target.animations.forEach(animation => (0, _stopAnimationEs.stopAnimation)(animation));
        };
      case "forEachNative":
        /**
         * This is for internal use only, fire a callback for each
         * underlying animation.
         */
        return callback => {
          target.animations.forEach(animation => callback(animation, target));
        };
      default:
        return typeof (activeAnimation === null || activeAnimation === void 0 ? void 0 : activeAnimation[key]) === "undefined" ? undefined : () => target.animations.forEach(animation => animation[key]());
    }
  },
  set: (target, key, value) => {
    switch (key) {
      case "currentTime":
        value = _utils.time.ms(value);
      case "currentTime":
      case "playbackRate":
        for (let i = 0; i < target.animations.length; i++) {
          target.animations[i][key] = value;
        }
        return true;
    }
    return false;
  }
};
const selectFinished = animation => animation.finished;

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/utils/css-var.es.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/utils/css-var.es.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isCssVar = void 0;
exports.registerCssVariable = registerCssVariable;
exports.registeredProperties = void 0;
var _transformsEs = __webpack_require__(/*! ./transforms.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/transforms.es.js");
const isCssVar = name => name.startsWith("--");
exports.isCssVar = isCssVar;
const registeredProperties = exports.registeredProperties = new Set();
function registerCssVariable(name) {
  if (registeredProperties.has(name)) return;
  registeredProperties.add(name);
  try {
    const {
      syntax,
      initialValue
    } = _transformsEs.transformDefinitions.has(name) ? _transformsEs.transformDefinitions.get(name) : {};
    CSS.registerProperty({
      name,
      inherits: false,
      syntax,
      initialValue
    });
  } catch (e) {}
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/utils/easing.es.js":
/*!****************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/utils/easing.es.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.cubicBezierAsString = exports.convertEasing = void 0;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
const convertEasing = easing => (0, _utils.isCubicBezier)(easing) ? cubicBezierAsString(easing) : easing;
exports.convertEasing = convertEasing;
const cubicBezierAsString = ([a, b, c, d]) => `cubic-bezier(${a}, ${b}, ${c}, ${d})`;
exports.cubicBezierAsString = cubicBezierAsString;

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/utils/feature-detection.es.js":
/*!***************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/utils/feature-detection.es.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.supports = void 0;
const testAnimation = keyframes => document.createElement("div").animate(keyframes, {
  duration: 0.001
});
const featureTests = {
  cssRegisterProperty: () => typeof CSS !== "undefined" && Object.hasOwnProperty.call(CSS, "registerProperty"),
  waapi: () => Object.hasOwnProperty.call(Element.prototype, "animate"),
  partialKeyframes: () => {
    try {
      testAnimation({
        opacity: [1]
      });
    } catch (e) {
      return false;
    }
    return true;
  },
  finished: () => Boolean(testAnimation({
    opacity: [0, 1]
  }).finished)
};
const results = {};
const supports = exports.supports = {};
for (const key in featureTests) {
  supports[key] = () => {
    if (results[key] === undefined) results[key] = featureTests[key]();
    return results[key];
  };
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/utils/get-style-name.es.js":
/*!************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/utils/get-style-name.es.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getStyleName = getStyleName;
var _transformsEs = __webpack_require__(/*! ./transforms.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/transforms.es.js");
function getStyleName(key) {
  if (_transformsEs.transformAlias[key]) key = _transformsEs.transformAlias[key];
  return (0, _transformsEs.isTransform)(key) ? (0, _transformsEs.asTransformCssVar)(key) : key;
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/utils/keyframes.es.js":
/*!*******************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/utils/keyframes.es.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.hydrateKeyframes = hydrateKeyframes;
exports.keyframesList = void 0;
function hydrateKeyframes(keyframes, readInitialValue) {
  for (let i = 0; i < keyframes.length; i++) {
    if (keyframes[i] === null) {
      keyframes[i] = i ? keyframes[i - 1] : readInitialValue();
    }
  }
  return keyframes;
}
const keyframesList = keyframes => Array.isArray(keyframes) ? keyframes : [keyframes];
exports.keyframesList = keyframesList;

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/utils/options.es.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/utils/options.es.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getOptions = void 0;
const getOptions = (options, key) =>
/**
 * TODO: Make test for this
 * Always return a new object otherwise delay is overwritten by results of stagger
 * and this results in no stagger
 */
options[key] ? Object.assign(Object.assign({}, options), options[key]) : Object.assign({}, options);
exports.getOptions = getOptions;

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/utils/stop-animation.es.js":
/*!************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/utils/stop-animation.es.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.stopAnimation = stopAnimation;
function stopAnimation(animation, needsCommit = true) {
  if (!animation || animation.playState === "finished") return;
  // Suppress error thrown by WAAPI
  try {
    if (animation.stop) {
      animation.stop();
    } else {
      needsCommit && animation.commitStyles();
      animation.cancel();
    }
  } catch (e) {}
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/utils/style-object.es.js":
/*!**********************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/utils/style-object.es.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createStyles = createStyles;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _transformsEs = __webpack_require__(/*! ./transforms.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/transforms.es.js");
function createStyles(keyframes) {
  const initialKeyframes = {};
  const transformKeys = [];
  for (let key in keyframes) {
    const value = keyframes[key];
    if ((0, _transformsEs.isTransform)(key)) {
      if (_transformsEs.transformAlias[key]) key = _transformsEs.transformAlias[key];
      transformKeys.push(key);
      key = (0, _transformsEs.asTransformCssVar)(key);
    }
    let initialKeyframe = Array.isArray(value) ? value[0] : value;
    /**
     * If this is a number and we have a default value type, convert the number
     * to this type.
     */
    const definition = _transformsEs.transformDefinitions.get(key);
    if (definition) {
      initialKeyframe = (0, _utils.isNumber)(value) ? definition.toDefaultUnit(value) : value;
    }
    initialKeyframes[key] = initialKeyframe;
  }
  if (transformKeys.length) {
    initialKeyframes.transform = (0, _transformsEs.buildTransformTemplate)(transformKeys);
  }
  return initialKeyframes;
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/utils/style-string.es.js":
/*!**********************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/utils/style-string.es.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createStyleString = createStyleString;
var _styleObjectEs = __webpack_require__(/*! ./style-object.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/style-object.es.js");
const camelLetterToPipeLetter = letter => `-${letter.toLowerCase()}`;
const camelToPipeCase = str => str.replace(/[A-Z]/g, camelLetterToPipeLetter);
function createStyleString(target = {}) {
  const styles = (0, _styleObjectEs.createStyles)(target);
  let style = "";
  for (const key in styles) {
    style += key.startsWith("--") ? key : camelToPipeCase(key);
    style += `: ${styles[key]}; `;
  }
  return style;
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/animate/utils/transforms.es.js":
/*!********************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/animate/utils/transforms.es.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.transformDefinitions = exports.transformAlias = exports.isTransform = exports.compareTransformOrder = exports.buildTransformTemplate = exports.axes = exports.asTransformCssVar = exports.addTransformToElement = void 0;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _dataEs = __webpack_require__(/*! ../data.es.js */ "../../../node_modules/@motionone/dom/dist/animate/data.es.js");
/**
 * A list of all transformable axes. We'll use this list to generated a version
 * of each axes for each transform.
 */
const axes = exports.axes = ["", "X", "Y", "Z"];
/**
 * An ordered array of each transformable value. By default, transform values
 * will be sorted to this order.
 */
const order = ["translate", "scale", "rotate", "skew"];
const transformAlias = exports.transformAlias = {
  x: "translateX",
  y: "translateY",
  z: "translateZ"
};
const rotation = {
  syntax: "<angle>",
  initialValue: "0deg",
  toDefaultUnit: v => v + "deg"
};
const baseTransformProperties = {
  translate: {
    syntax: "<length-percentage>",
    initialValue: "0px",
    toDefaultUnit: v => v + "px"
  },
  rotate: rotation,
  scale: {
    syntax: "<number>",
    initialValue: 1,
    toDefaultUnit: _utils.noopReturn
  },
  skew: rotation
};
const transformDefinitions = exports.transformDefinitions = new Map();
const asTransformCssVar = name => `--motion-${name}`;
/**
 * Generate a list of every possible transform key
 */
exports.asTransformCssVar = asTransformCssVar;
const transforms = ["x", "y", "z"];
order.forEach(name => {
  axes.forEach(axis => {
    transforms.push(name + axis);
    transformDefinitions.set(asTransformCssVar(name + axis), baseTransformProperties[name]);
  });
});
/**
 * A function to use with Array.sort to sort transform keys by their default order.
 */
const compareTransformOrder = (a, b) => transforms.indexOf(a) - transforms.indexOf(b);
/**
 * Provide a quick way to check if a string is the name of a transform
 */
exports.compareTransformOrder = compareTransformOrder;
const transformLookup = new Set(transforms);
const isTransform = name => transformLookup.has(name);
exports.isTransform = isTransform;
const addTransformToElement = (element, name) => {
  // Map x to translateX etc
  if (transformAlias[name]) name = transformAlias[name];
  const {
    transforms
  } = (0, _dataEs.getAnimationData)(element);
  (0, _utils.addUniqueItem)(transforms, name);
  /**
   * TODO: An optimisation here could be to cache the transform in element data
   * and only update if this has changed.
   */
  element.style.transform = buildTransformTemplate(transforms);
};
exports.addTransformToElement = addTransformToElement;
const buildTransformTemplate = transforms => transforms.sort(compareTransformOrder).reduce(transformListToString, "").trim();
exports.buildTransformTemplate = buildTransformTemplate;
const transformListToString = (template, name) => `${template} ${name}(var(${asTransformCssVar(name)}))`;

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/easing/create-generator-easing.es.js":
/*!**************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/easing/create-generator-easing.es.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createGeneratorEasing = createGeneratorEasing;
var _generators = __webpack_require__(/*! @motionone/generators */ "../../../node_modules/@motionone/generators/dist/index.es.js");
function createGeneratorEasing(createGenerator) {
  const keyframesCache = new WeakMap();
  return (options = {}) => {
    const generatorCache = new Map();
    const getGenerator = (from = 0, to = 100, velocity = 0, isScale = false) => {
      const key = `${from}-${to}-${velocity}-${isScale}`;
      if (!generatorCache.has(key)) {
        generatorCache.set(key, createGenerator(Object.assign({
          from,
          to,
          velocity,
          restSpeed: isScale ? 0.05 : 2,
          restDistance: isScale ? 0.01 : 0.5
        }, options)));
      }
      return generatorCache.get(key);
    };
    const getKeyframes = generator => {
      if (!keyframesCache.has(generator)) {
        keyframesCache.set(generator, (0, _generators.pregenerateKeyframes)(generator));
      }
      return keyframesCache.get(generator);
    };
    return {
      createAnimation: (keyframes, getOrigin, canUseGenerator, name, motionValue) => {
        var _a, _b;
        let settings;
        const numKeyframes = keyframes.length;
        let shouldUseGenerator = canUseGenerator && numKeyframes <= 2 && keyframes.every(isNumberOrNull);
        if (shouldUseGenerator) {
          const target = keyframes[numKeyframes - 1];
          const unresolvedOrigin = numKeyframes === 1 ? null : keyframes[0];
          let velocity = 0;
          let origin = 0;
          const prevGenerator = motionValue === null || motionValue === void 0 ? void 0 : motionValue.generator;
          if (prevGenerator) {
            /**
             * If we have a generator for this value we can use it to resolve
             * the animations's current value and velocity.
             */
            const {
              animation,
              generatorStartTime
            } = motionValue;
            const startTime = (animation === null || animation === void 0 ? void 0 : animation.startTime) || generatorStartTime || 0;
            const currentTime = (animation === null || animation === void 0 ? void 0 : animation.currentTime) || performance.now() - startTime;
            const prevGeneratorCurrent = prevGenerator(currentTime).current;
            origin = (_a = unresolvedOrigin) !== null && _a !== void 0 ? _a : prevGeneratorCurrent;
            if (numKeyframes === 1 || numKeyframes === 2 && keyframes[0] === null) {
              velocity = (0, _generators.calcGeneratorVelocity)(t => prevGenerator(t).current, currentTime, prevGeneratorCurrent);
            }
          } else {
            origin = (_b = unresolvedOrigin) !== null && _b !== void 0 ? _b : parseFloat(getOrigin());
          }
          const generator = getGenerator(origin, target, velocity, name === null || name === void 0 ? void 0 : name.includes("scale"));
          const keyframesMetadata = getKeyframes(generator);
          settings = Object.assign(Object.assign({}, keyframesMetadata), {
            easing: "linear"
          });
          // TODO Add test for this
          if (motionValue) {
            motionValue.generator = generator;
            motionValue.generatorStartTime = performance.now();
          }
        } else {
          const keyframesMetadata = getKeyframes(getGenerator(0, 100));
          settings = {
            easing: "ease",
            duration: keyframesMetadata.overshootDuration
          };
        }
        return settings;
      }
    };
  };
}
const isNumberOrNull = value => typeof value !== "string";

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/easing/glide/index.es.js":
/*!**************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/easing/glide/index.es.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.glide = void 0;
var _generators = __webpack_require__(/*! @motionone/generators */ "../../../node_modules/@motionone/generators/dist/index.es.js");
var _createGeneratorEasingEs = __webpack_require__(/*! ../create-generator-easing.es.js */ "../../../node_modules/@motionone/dom/dist/easing/create-generator-easing.es.js");
const glide = exports.glide = (0, _createGeneratorEasingEs.createGeneratorEasing)(_generators.glide);

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/easing/spring/index.es.js":
/*!***************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/easing/spring/index.es.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.spring = void 0;
var _generators = __webpack_require__(/*! @motionone/generators */ "../../../node_modules/@motionone/generators/dist/index.es.js");
var _createGeneratorEasingEs = __webpack_require__(/*! ../create-generator-easing.es.js */ "../../../node_modules/@motionone/dom/dist/easing/create-generator-easing.es.js");
const spring = exports.spring = (0, _createGeneratorEasingEs.createGeneratorEasing)(_generators.spring);

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/in-view.es.js":
/*!************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/in-view.es.js ***!
  \************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.inView = inView;
var _resolveElementsEs = __webpack_require__(/*! ../utils/resolve-elements.es.js */ "../../../node_modules/@motionone/dom/dist/utils/resolve-elements.es.js");
const thresholds = {
  any: 0,
  all: 1
};
function inView(elementOrSelector, onStart, {
  root,
  margin: rootMargin,
  amount = "any"
} = {}) {
  /**
   * If this browser doesn't support IntersectionObserver, return a dummy stop function.
   * Default triggering of onStart is tricky - it could be used for starting/stopping
   * videos, lazy loading content etc. We could provide an option to enable a fallback, or
   * provide a fallback callback option.
   */
  if (typeof IntersectionObserver === "undefined") {
    return () => {};
  }
  const elements = (0, _resolveElementsEs.resolveElements)(elementOrSelector);
  const activeIntersections = new WeakMap();
  const onIntersectionChange = entries => {
    entries.forEach(entry => {
      const onEnd = activeIntersections.get(entry.target);
      /**
       * If there's no change to the intersection, we don't need to
       * do anything here.
       */
      if (entry.isIntersecting === Boolean(onEnd)) return;
      if (entry.isIntersecting) {
        const newOnEnd = onStart(entry);
        if (typeof newOnEnd === "function") {
          activeIntersections.set(entry.target, newOnEnd);
        } else {
          observer.unobserve(entry.target);
        }
      } else if (onEnd) {
        onEnd(entry);
        activeIntersections.delete(entry.target);
      }
    });
  };
  const observer = new IntersectionObserver(onIntersectionChange, {
    root,
    rootMargin,
    threshold: typeof amount === "number" ? amount : thresholds[amount]
  });
  elements.forEach(element => observer.observe(element));
  return () => observer.disconnect();
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/resize/handle-element.es.js":
/*!**************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/resize/handle-element.es.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.resizeElement = resizeElement;
var _resolveElementsEs = __webpack_require__(/*! ../../utils/resolve-elements.es.js */ "../../../node_modules/@motionone/dom/dist/utils/resolve-elements.es.js");
const resizeHandlers = new WeakMap();
let observer;
function getElementSize(target, borderBoxSize) {
  if (borderBoxSize) {
    const {
      inlineSize,
      blockSize
    } = borderBoxSize[0];
    return {
      width: inlineSize,
      height: blockSize
    };
  } else if (target instanceof SVGElement && "getBBox" in target) {
    return target.getBBox();
  } else {
    return {
      width: target.offsetWidth,
      height: target.offsetHeight
    };
  }
}
function notifyTarget({
  target,
  contentRect,
  borderBoxSize
}) {
  var _a;
  (_a = resizeHandlers.get(target)) === null || _a === void 0 ? void 0 : _a.forEach(handler => {
    handler({
      target,
      contentSize: contentRect,
      get size() {
        return getElementSize(target, borderBoxSize);
      }
    });
  });
}
function notifyAll(entries) {
  entries.forEach(notifyTarget);
}
function createResizeObserver() {
  if (typeof ResizeObserver === "undefined") return;
  observer = new ResizeObserver(notifyAll);
}
function resizeElement(target, handler) {
  if (!observer) createResizeObserver();
  const elements = (0, _resolveElementsEs.resolveElements)(target);
  elements.forEach(element => {
    let elementHandlers = resizeHandlers.get(element);
    if (!elementHandlers) {
      elementHandlers = new Set();
      resizeHandlers.set(element, elementHandlers);
    }
    elementHandlers.add(handler);
    observer === null || observer === void 0 ? void 0 : observer.observe(element);
  });
  return () => {
    elements.forEach(element => {
      const elementHandlers = resizeHandlers.get(element);
      elementHandlers === null || elementHandlers === void 0 ? void 0 : elementHandlers.delete(handler);
      if (!(elementHandlers === null || elementHandlers === void 0 ? void 0 : elementHandlers.size)) {
        observer === null || observer === void 0 ? void 0 : observer.unobserve(element);
      }
    });
  };
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/resize/handle-window.es.js":
/*!*************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/resize/handle-window.es.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.resizeWindow = resizeWindow;
const windowCallbacks = new Set();
let windowResizeHandler;
function createWindowResizeHandler() {
  windowResizeHandler = () => {
    const size = {
      width: window.innerWidth,
      height: window.innerHeight
    };
    const info = {
      target: window,
      size,
      contentSize: size
    };
    windowCallbacks.forEach(callback => callback(info));
  };
  window.addEventListener("resize", windowResizeHandler);
}
function resizeWindow(callback) {
  windowCallbacks.add(callback);
  if (!windowResizeHandler) createWindowResizeHandler();
  return () => {
    windowCallbacks.delete(callback);
    if (!windowCallbacks.size && windowResizeHandler) {
      windowResizeHandler = undefined;
    }
  };
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/resize/index.es.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/resize/index.es.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.resize = resize;
var _handleElementEs = __webpack_require__(/*! ./handle-element.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/resize/handle-element.es.js");
var _handleWindowEs = __webpack_require__(/*! ./handle-window.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/resize/handle-window.es.js");
function resize(a, b) {
  return typeof a === "function" ? (0, _handleWindowEs.resizeWindow)(a) : (0, _handleElementEs.resizeElement)(a, b);
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/scroll/index.es.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/scroll/index.es.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.scroll = scroll;
var _tslib = __webpack_require__(/*! tslib */ "../../../node_modules/tslib/tslib.es6.mjs");
var _indexEs = __webpack_require__(/*! ../resize/index.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/resize/index.es.js");
var _infoEs = __webpack_require__(/*! ./info.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/scroll/info.es.js");
var _onScrollHandlerEs = __webpack_require__(/*! ./on-scroll-handler.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/scroll/on-scroll-handler.es.js");
const scrollListeners = new WeakMap();
const resizeListeners = new WeakMap();
const onScrollHandlers = new WeakMap();
const getEventTarget = element => element === document.documentElement ? window : element;
function scroll(onScroll, _a = {}) {
  var {
      container = document.documentElement
    } = _a,
    options = (0, _tslib.__rest)(_a, ["container"]);
  let containerHandlers = onScrollHandlers.get(container);
  /**
   * Get the onScroll handlers for this container.
   * If one isn't found, create a new one.
   */
  if (!containerHandlers) {
    containerHandlers = new Set();
    onScrollHandlers.set(container, containerHandlers);
  }
  /**
   * Create a new onScroll handler for the provided callback.
   */
  const info = (0, _infoEs.createScrollInfo)();
  const containerHandler = (0, _onScrollHandlerEs.createOnScrollHandler)(container, onScroll, info, options);
  containerHandlers.add(containerHandler);
  /**
   * Check if there's a scroll event listener for this container.
   * If not, create one.
   */
  if (!scrollListeners.has(container)) {
    const listener = () => {
      const time = performance.now();
      for (const handler of containerHandlers) handler.measure();
      for (const handler of containerHandlers) handler.update(time);
      for (const handler of containerHandlers) handler.notify();
    };
    scrollListeners.set(container, listener);
    const target = getEventTarget(container);
    window.addEventListener("resize", listener, {
      passive: true
    });
    if (container !== document.documentElement) {
      resizeListeners.set(container, (0, _indexEs.resize)(container, listener));
    }
    target.addEventListener("scroll", listener, {
      passive: true
    });
  }
  const listener = scrollListeners.get(container);
  const onLoadProcesss = requestAnimationFrame(listener);
  return () => {
    var _a;
    if (typeof onScroll !== "function") onScroll.stop();
    cancelAnimationFrame(onLoadProcesss);
    /**
     * Check if we even have any handlers for this container.
     */
    const containerHandlers = onScrollHandlers.get(container);
    if (!containerHandlers) return;
    containerHandlers.delete(containerHandler);
    if (containerHandlers.size) return;
    /**
     * If no more handlers, remove the scroll listener too.
     */
    const listener = scrollListeners.get(container);
    scrollListeners.delete(container);
    if (listener) {
      getEventTarget(container).removeEventListener("scroll", listener);
      (_a = resizeListeners.get(container)) === null || _a === void 0 ? void 0 : _a();
      window.removeEventListener("resize", listener);
    }
  };
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/scroll/info.es.js":
/*!****************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/scroll/info.es.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createScrollInfo = void 0;
exports.updateScrollInfo = updateScrollInfo;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
/**
 * A time in milliseconds, beyond which we consider the scroll velocity to be 0.
 */
const maxElapsed = 50;
const createAxisInfo = () => ({
  current: 0,
  offset: [],
  progress: 0,
  scrollLength: 0,
  targetOffset: 0,
  targetLength: 0,
  containerLength: 0,
  velocity: 0
});
const createScrollInfo = () => ({
  time: 0,
  x: createAxisInfo(),
  y: createAxisInfo()
});
exports.createScrollInfo = createScrollInfo;
const keys = {
  x: {
    length: "Width",
    position: "Left"
  },
  y: {
    length: "Height",
    position: "Top"
  }
};
function updateAxisInfo(element, axisName, info, time) {
  const axis = info[axisName];
  const {
    length,
    position
  } = keys[axisName];
  const prev = axis.current;
  const prevTime = info.time;
  axis.current = element["scroll" + position];
  axis.scrollLength = element["scroll" + length] - element["client" + length];
  axis.offset.length = 0;
  axis.offset[0] = 0;
  axis.offset[1] = axis.scrollLength;
  axis.progress = (0, _utils.progress)(0, axis.scrollLength, axis.current);
  const elapsed = time - prevTime;
  axis.velocity = elapsed > maxElapsed ? 0 : (0, _utils.velocityPerSecond)(axis.current - prev, elapsed);
}
function updateScrollInfo(element, info, time) {
  updateAxisInfo(element, "x", info, time);
  updateAxisInfo(element, "y", info, time);
  info.time = time;
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/edge.es.js":
/*!************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/edge.es.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.namedEdges = void 0;
exports.resolveEdge = resolveEdge;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
const namedEdges = exports.namedEdges = {
  start: 0,
  center: 0.5,
  end: 1
};
function resolveEdge(edge, length, inset = 0) {
  let delta = 0;
  /**
   * If we have this edge defined as a preset, replace the definition
   * with the numerical value.
   */
  if (namedEdges[edge] !== undefined) {
    edge = namedEdges[edge];
  }
  /**
   * Handle unit values
   */
  if ((0, _utils.isString)(edge)) {
    const asNumber = parseFloat(edge);
    if (edge.endsWith("px")) {
      delta = asNumber;
    } else if (edge.endsWith("%")) {
      edge = asNumber / 100;
    } else if (edge.endsWith("vw")) {
      delta = asNumber / 100 * document.documentElement.clientWidth;
    } else if (edge.endsWith("vh")) {
      delta = asNumber / 100 * document.documentElement.clientHeight;
    } else {
      edge = asNumber;
    }
  }
  /**
   * If the edge is defined as a number, handle as a progress value.
   */
  if ((0, _utils.isNumber)(edge)) {
    delta = length * edge;
  }
  return inset + delta;
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/index.es.js":
/*!*************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/index.es.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.resolveOffsets = resolveOffsets;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _insetEs = __webpack_require__(/*! ./inset.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/inset.es.js");
var _presetsEs = __webpack_require__(/*! ./presets.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/presets.es.js");
var _offsetEs = __webpack_require__(/*! ./offset.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/offset.es.js");
const point = {
  x: 0,
  y: 0
};
function resolveOffsets(container, info, options) {
  let {
    offset: offsetDefinition = _presetsEs.ScrollOffset.All
  } = options;
  const {
    target = container,
    axis = "y"
  } = options;
  const lengthLabel = axis === "y" ? "height" : "width";
  const inset = target !== container ? (0, _insetEs.calcInset)(target, container) : point;
  /**
   * Measure the target and container. If they're the same thing then we
   * use the container's scrollWidth/Height as the target, from there
   * all other calculations can remain the same.
   */
  const targetSize = target === container ? {
    width: container.scrollWidth,
    height: container.scrollHeight
  } : {
    width: target.clientWidth,
    height: target.clientHeight
  };
  const containerSize = {
    width: container.clientWidth,
    height: container.clientHeight
  };
  /**
   * Reset the length of the resolved offset array rather than creating a new one.
   * TODO: More reusable data structures for targetSize/containerSize would also be good.
   */
  info[axis].offset.length = 0;
  /**
   * Populate the offset array by resolving the user's offset definition into
   * a list of pixel scroll offets.
   */
  let hasChanged = !info[axis].interpolate;
  const numOffsets = offsetDefinition.length;
  for (let i = 0; i < numOffsets; i++) {
    const offset = (0, _offsetEs.resolveOffset)(offsetDefinition[i], containerSize[lengthLabel], targetSize[lengthLabel], inset[axis]);
    if (!hasChanged && offset !== info[axis].interpolatorOffsets[i]) {
      hasChanged = true;
    }
    info[axis].offset[i] = offset;
  }
  /**
   * If the pixel scroll offsets have changed, create a new interpolator function
   * to map scroll value into a progress.
   */
  if (hasChanged) {
    info[axis].interpolate = (0, _utils.interpolate)((0, _utils.defaultOffset)(numOffsets), info[axis].offset);
    info[axis].interpolatorOffsets = [...info[axis].offset];
  }
  info[axis].progress = info[axis].interpolate(info[axis].current);
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/inset.es.js":
/*!*************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/inset.es.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.calcInset = calcInset;
function calcInset(element, container) {
  let inset = {
    x: 0,
    y: 0
  };
  let current = element;
  while (current && current !== container) {
    if (current instanceof HTMLElement) {
      inset.x += current.offsetLeft;
      inset.y += current.offsetTop;
      current = current.offsetParent;
    } else if (current instanceof SVGGraphicsElement && "getBBox" in current) {
      const {
        top,
        left
      } = current.getBBox();
      inset.x += left;
      inset.y += top;
      /**
       * Assign the next parent element as the <svg /> tag.
       */
      while (current && current.tagName !== "svg") {
        current = current.parentNode;
      }
    }
  }
  return inset;
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/offset.es.js":
/*!**************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/offset.es.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.resolveOffset = resolveOffset;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _edgeEs = __webpack_require__(/*! ./edge.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/edge.es.js");
const defaultOffset = [0, 0];
function resolveOffset(offset, containerLength, targetLength, targetInset) {
  let offsetDefinition = Array.isArray(offset) ? offset : defaultOffset;
  let targetPoint = 0;
  let containerPoint = 0;
  if ((0, _utils.isNumber)(offset)) {
    /**
     * If we're provided offset: [0, 0.5, 1] then each number x should become
     * [x, x], so we default to the behaviour of mapping 0 => 0 of both target
     * and container etc.
     */
    offsetDefinition = [offset, offset];
  } else if ((0, _utils.isString)(offset)) {
    offset = offset.trim();
    if (offset.includes(" ")) {
      offsetDefinition = offset.split(" ");
    } else {
      /**
       * If we're provided a definition like "100px" then we want to apply
       * that only to the top of the target point, leaving the container at 0.
       * Whereas a named offset like "end" should be applied to both.
       */
      offsetDefinition = [offset, _edgeEs.namedEdges[offset] ? offset : `0`];
    }
  }
  targetPoint = (0, _edgeEs.resolveEdge)(offsetDefinition[0], targetLength, targetInset);
  containerPoint = (0, _edgeEs.resolveEdge)(offsetDefinition[1], containerLength);
  return targetPoint - containerPoint;
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/presets.es.js":
/*!***************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/presets.es.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ScrollOffset = void 0;
const ScrollOffset = exports.ScrollOffset = {
  Enter: [[0, 1], [1, 1]],
  Exit: [[0, 0], [1, 0]],
  Any: [[1, 0], [0, 1]],
  All: [[0, 0], [1, 1]]
};

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/gestures/scroll/on-scroll-handler.es.js":
/*!*****************************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/gestures/scroll/on-scroll-handler.es.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createOnScrollHandler = createOnScrollHandler;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _infoEs = __webpack_require__(/*! ./info.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/scroll/info.es.js");
var _indexEs = __webpack_require__(/*! ./offsets/index.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/index.es.js");
function measure(container, target = container, info) {
  /**
   * Find inset of target within scrollable container
   */
  info.x.targetOffset = 0;
  info.y.targetOffset = 0;
  if (target !== container) {
    let node = target;
    while (node && node != container) {
      info.x.targetOffset += node.offsetLeft;
      info.y.targetOffset += node.offsetTop;
      node = node.offsetParent;
    }
  }
  info.x.targetLength = target === container ? target.scrollWidth : target.clientWidth;
  info.y.targetLength = target === container ? target.scrollHeight : target.clientHeight;
  info.x.containerLength = container.clientWidth;
  info.y.containerLength = container.clientHeight;
}
function createOnScrollHandler(element, onScroll, info, options = {}) {
  const axis = options.axis || "y";
  return {
    measure: () => measure(element, options.target, info),
    update: time => {
      (0, _infoEs.updateScrollInfo)(element, info, time);
      if (options.offset || options.target) {
        (0, _indexEs.resolveOffsets)(element, info, options);
      }
    },
    notify: typeof onScroll === "function" ? () => onScroll(info) : scrubAnimation(onScroll, info[axis])
  };
}
function scrubAnimation(controls, axisInfo) {
  controls.pause();
  controls.forEachNative((animation, {
    easing
  }) => {
    var _a, _b;
    if (animation.updateDuration) {
      if (!easing) animation.easing = _utils.noopReturn;
      animation.updateDuration(1);
    } else {
      const timingOptions = {
        duration: 1000
      };
      if (!easing) timingOptions.easing = "linear";
      (_b = (_a = animation.effect) === null || _a === void 0 ? void 0 : _a.updateTiming) === null || _b === void 0 ? void 0 : _b.call(_a, timingOptions);
    }
  });
  return () => {
    controls.currentTime = axisInfo.progress;
  };
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/index.es.js":
/*!*************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/index.es.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "ScrollOffset", ({
  enumerable: true,
  get: function () {
    return _presetsEs.ScrollOffset;
  }
}));
Object.defineProperty(exports, "animate", ({
  enumerable: true,
  get: function () {
    return _indexEs.animate;
  }
}));
Object.defineProperty(exports, "animateStyle", ({
  enumerable: true,
  get: function () {
    return _animateStyleEs.animateStyle;
  }
}));
Object.defineProperty(exports, "createMotionState", ({
  enumerable: true,
  get: function () {
    return _indexEs7.createMotionState;
  }
}));
Object.defineProperty(exports, "createStyleString", ({
  enumerable: true,
  get: function () {
    return _styleStringEs.createStyleString;
  }
}));
Object.defineProperty(exports, "createStyles", ({
  enumerable: true,
  get: function () {
    return _styleObjectEs.createStyles;
  }
}));
Object.defineProperty(exports, "getAnimationData", ({
  enumerable: true,
  get: function () {
    return _dataEs.getAnimationData;
  }
}));
Object.defineProperty(exports, "getStyleName", ({
  enumerable: true,
  get: function () {
    return _getStyleNameEs.getStyleName;
  }
}));
Object.defineProperty(exports, "glide", ({
  enumerable: true,
  get: function () {
    return _indexEs4.glide;
  }
}));
Object.defineProperty(exports, "inView", ({
  enumerable: true,
  get: function () {
    return _inViewEs.inView;
  }
}));
Object.defineProperty(exports, "mountedStates", ({
  enumerable: true,
  get: function () {
    return _indexEs7.mountedStates;
  }
}));
Object.defineProperty(exports, "resize", ({
  enumerable: true,
  get: function () {
    return _indexEs5.resize;
  }
}));
Object.defineProperty(exports, "scroll", ({
  enumerable: true,
  get: function () {
    return _indexEs6.scroll;
  }
}));
Object.defineProperty(exports, "spring", ({
  enumerable: true,
  get: function () {
    return _indexEs3.spring;
  }
}));
Object.defineProperty(exports, "stagger", ({
  enumerable: true,
  get: function () {
    return _staggerEs.stagger;
  }
}));
Object.defineProperty(exports, "style", ({
  enumerable: true,
  get: function () {
    return _styleEs.style;
  }
}));
Object.defineProperty(exports, "timeline", ({
  enumerable: true,
  get: function () {
    return _indexEs2.timeline;
  }
}));
Object.defineProperty(exports, "withControls", ({
  enumerable: true,
  get: function () {
    return _controlsEs.withControls;
  }
}));
var _indexEs = __webpack_require__(/*! ./animate/index.es.js */ "../../../node_modules/@motionone/dom/dist/animate/index.es.js");
var _animateStyleEs = __webpack_require__(/*! ./animate/animate-style.es.js */ "../../../node_modules/@motionone/dom/dist/animate/animate-style.es.js");
var _indexEs2 = __webpack_require__(/*! ./timeline/index.es.js */ "../../../node_modules/@motionone/dom/dist/timeline/index.es.js");
var _staggerEs = __webpack_require__(/*! ./utils/stagger.es.js */ "../../../node_modules/@motionone/dom/dist/utils/stagger.es.js");
var _indexEs3 = __webpack_require__(/*! ./easing/spring/index.es.js */ "../../../node_modules/@motionone/dom/dist/easing/spring/index.es.js");
var _indexEs4 = __webpack_require__(/*! ./easing/glide/index.es.js */ "../../../node_modules/@motionone/dom/dist/easing/glide/index.es.js");
var _styleEs = __webpack_require__(/*! ./animate/style.es.js */ "../../../node_modules/@motionone/dom/dist/animate/style.es.js");
var _inViewEs = __webpack_require__(/*! ./gestures/in-view.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/in-view.es.js");
var _indexEs5 = __webpack_require__(/*! ./gestures/resize/index.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/resize/index.es.js");
var _indexEs6 = __webpack_require__(/*! ./gestures/scroll/index.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/scroll/index.es.js");
var _presetsEs = __webpack_require__(/*! ./gestures/scroll/offsets/presets.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/scroll/offsets/presets.es.js");
var _controlsEs = __webpack_require__(/*! ./animate/utils/controls.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/controls.es.js");
var _dataEs = __webpack_require__(/*! ./animate/data.es.js */ "../../../node_modules/@motionone/dom/dist/animate/data.es.js");
var _getStyleNameEs = __webpack_require__(/*! ./animate/utils/get-style-name.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/get-style-name.es.js");
var _indexEs7 = __webpack_require__(/*! ./state/index.es.js */ "../../../node_modules/@motionone/dom/dist/state/index.es.js");
var _styleObjectEs = __webpack_require__(/*! ./animate/utils/style-object.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/style-object.es.js");
var _styleStringEs = __webpack_require__(/*! ./animate/utils/style-string.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/style-string.es.js");

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/state/gestures/hover.es.js":
/*!****************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/state/gestures/hover.es.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.hover = void 0;
var _eventsEs = __webpack_require__(/*! ../utils/events.es.js */ "../../../node_modules/@motionone/dom/dist/state/utils/events.es.js");
const mouseEvent = (element, name, action) => event => {
  if (event.pointerType && event.pointerType !== "mouse") return;
  action();
  (0, _eventsEs.dispatchPointerEvent)(element, name, event);
};
const hover = exports.hover = {
  isActive: options => Boolean(options.hover),
  subscribe: (element, {
    enable,
    disable
  }) => {
    const onEnter = mouseEvent(element, "hoverstart", enable);
    const onLeave = mouseEvent(element, "hoverend", disable);
    element.addEventListener("pointerenter", onEnter);
    element.addEventListener("pointerleave", onLeave);
    return () => {
      element.removeEventListener("pointerenter", onEnter);
      element.removeEventListener("pointerleave", onLeave);
    };
  }
};

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/state/gestures/in-view.es.js":
/*!******************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/state/gestures/in-view.es.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.inView = void 0;
var _tslib = __webpack_require__(/*! tslib */ "../../../node_modules/tslib/tslib.es6.mjs");
var _eventsEs = __webpack_require__(/*! ../utils/events.es.js */ "../../../node_modules/@motionone/dom/dist/state/utils/events.es.js");
var _inViewEs = __webpack_require__(/*! ../../gestures/in-view.es.js */ "../../../node_modules/@motionone/dom/dist/gestures/in-view.es.js");
const inView = exports.inView = {
  isActive: options => Boolean(options.inView),
  subscribe: (element, {
    enable,
    disable
  }, {
    inViewOptions = {}
  }) => {
    const {
        once
      } = inViewOptions,
      viewOptions = (0, _tslib.__rest)(inViewOptions, ["once"]);
    return (0, _inViewEs.inView)(element, enterEntry => {
      enable();
      (0, _eventsEs.dispatchViewEvent)(element, "viewenter", enterEntry);
      if (!once) {
        return leaveEntry => {
          disable();
          (0, _eventsEs.dispatchViewEvent)(element, "viewleave", leaveEntry);
        };
      }
    }, viewOptions);
  }
};

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/state/gestures/press.es.js":
/*!****************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/state/gestures/press.es.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.press = void 0;
var _eventsEs = __webpack_require__(/*! ../utils/events.es.js */ "../../../node_modules/@motionone/dom/dist/state/utils/events.es.js");
const press = exports.press = {
  isActive: options => Boolean(options.press),
  subscribe: (element, {
    enable,
    disable
  }) => {
    const onPointerUp = event => {
      disable();
      (0, _eventsEs.dispatchPointerEvent)(element, "pressend", event);
      window.removeEventListener("pointerup", onPointerUp);
    };
    const onPointerDown = event => {
      enable();
      (0, _eventsEs.dispatchPointerEvent)(element, "pressstart", event);
      window.addEventListener("pointerup", onPointerUp);
    };
    element.addEventListener("pointerdown", onPointerDown);
    return () => {
      element.removeEventListener("pointerdown", onPointerDown);
      window.removeEventListener("pointerup", onPointerUp);
    };
  }
};

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/state/index.es.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/state/index.es.js ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createMotionState = createMotionState;
exports.mountedStates = void 0;
var _tslib = __webpack_require__(/*! tslib */ "../../../node_modules/tslib/tslib.es6.mjs");
var _heyListen = __webpack_require__(/*! hey-listen */ "../../../node_modules/hey-listen/dist/hey-listen.es.js");
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _animateStyleEs = __webpack_require__(/*! ../animate/animate-style.es.js */ "../../../node_modules/@motionone/dom/dist/animate/animate-style.es.js");
var _styleEs = __webpack_require__(/*! ../animate/style.es.js */ "../../../node_modules/@motionone/dom/dist/animate/style.es.js");
var _optionsEs = __webpack_require__(/*! ../animate/utils/options.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/options.es.js");
var _hasChangedEs = __webpack_require__(/*! ./utils/has-changed.es.js */ "../../../node_modules/@motionone/dom/dist/state/utils/has-changed.es.js");
var _resolveVariantEs = __webpack_require__(/*! ./utils/resolve-variant.es.js */ "../../../node_modules/@motionone/dom/dist/state/utils/resolve-variant.es.js");
var _scheduleEs = __webpack_require__(/*! ./utils/schedule.es.js */ "../../../node_modules/@motionone/dom/dist/state/utils/schedule.es.js");
var _inViewEs = __webpack_require__(/*! ./gestures/in-view.es.js */ "../../../node_modules/@motionone/dom/dist/state/gestures/in-view.es.js");
var _hoverEs = __webpack_require__(/*! ./gestures/hover.es.js */ "../../../node_modules/@motionone/dom/dist/state/gestures/hover.es.js");
var _pressEs = __webpack_require__(/*! ./gestures/press.es.js */ "../../../node_modules/@motionone/dom/dist/state/gestures/press.es.js");
var _eventsEs = __webpack_require__(/*! ./utils/events.es.js */ "../../../node_modules/@motionone/dom/dist/state/utils/events.es.js");
const gestures = {
  inView: _inViewEs.inView,
  hover: _hoverEs.hover,
  press: _pressEs.press
};
/**
 * A list of state types, in priority order. If a value is defined in
 * a righter-most type, it will override any definition in a lefter-most.
 */
const stateTypes = ["initial", "animate", ...Object.keys(gestures), "exit"];
/**
 * A global store of all generated motion states. This can be used to lookup
 * a motion state for a given Element.
 */
const mountedStates = exports.mountedStates = new WeakMap();
function createMotionState(options = {}, parent) {
  /**
   * The element represented by the motion state. This is an empty reference
   * when we create the state to support SSR and allow for later mounting
   * in view libraries.
   *
   * @ts-ignore
   */
  let element;
  /**
   * Calculate a depth that we can use to order motion states by tree depth.
   */
  let depth = parent ? parent.getDepth() + 1 : 0;
  /**
   * Track which states are currently active.
   */
  const activeStates = {
    initial: true,
    animate: true
  };
  /**
   * A map of functions that, when called, will remove event listeners for
   * a given gesture.
   */
  const gestureSubscriptions = {};
  /**
   * Initialise a context to share through motion states. This
   * will be populated by variant names (if any).
   */
  const context = {};
  for (const name of stateTypes) {
    context[name] = typeof options[name] === "string" ? options[name] : parent === null || parent === void 0 ? void 0 : parent.getContext()[name];
  }
  /**
   * If initial is set to false we use the animate prop as the initial
   * animation state.
   */
  const initialVariantSource = options.initial === false ? "animate" : "initial";
  /**
   * Destructure an initial target out from the resolved initial variant.
   */
  let _a = (0, _resolveVariantEs.resolveVariant)(options[initialVariantSource] || context[initialVariantSource], options.variants) || {},
    target = (0, _tslib.__rest)(_a, ["transition"]);
  /**
   * The base target is a cached map of values that we'll use to animate
   * back to if a value is removed from all active state types. This
   * is usually the initial value as read from the DOM, for instance if
   * it hasn't been defined in initial.
   */
  const baseTarget = Object.assign({}, target);
  /**
   * A generator that will be processed by the global animation scheduler.
   * This yeilds when it switches from reading the DOM to writing to it
   * to prevent layout thrashing.
   */
  function* animateUpdates() {
    var _a, _b;
    const prevTarget = target;
    target = {};
    const animationOptions = {};
    for (const name of stateTypes) {
      if (!activeStates[name]) continue;
      const variant = (0, _resolveVariantEs.resolveVariant)(options[name]);
      if (!variant) continue;
      for (const key in variant) {
        if (key === "transition") continue;
        target[key] = variant[key];
        animationOptions[key] = (0, _optionsEs.getOptions)((_b = (_a = variant.transition) !== null && _a !== void 0 ? _a : options.transition) !== null && _b !== void 0 ? _b : {}, key);
      }
    }
    const allTargetKeys = new Set([...Object.keys(target), ...Object.keys(prevTarget)]);
    const animationFactories = [];
    allTargetKeys.forEach(key => {
      var _a;
      if (target[key] === undefined) {
        target[key] = baseTarget[key];
      }
      if ((0, _hasChangedEs.hasChanged)(prevTarget[key], target[key])) {
        (_a = baseTarget[key]) !== null && _a !== void 0 ? _a : baseTarget[key] = _styleEs.style.get(element, key);
        animationFactories.push((0, _animateStyleEs.animateStyle)(element, key, target[key], animationOptions[key]));
      }
    });
    // Wait for all animation states to read from the DOM
    yield;
    const animations = animationFactories.map(factory => factory()).filter(Boolean);
    if (!animations.length) return;
    const animationTarget = target;
    element.dispatchEvent((0, _eventsEs.motionEvent)("motionstart", animationTarget));
    Promise.all(animations.map(animation => animation.finished)).then(() => {
      element.dispatchEvent((0, _eventsEs.motionEvent)("motioncomplete", animationTarget));
    }).catch(_utils.noop);
  }
  const setGesture = (name, isActive) => () => {
    activeStates[name] = isActive;
    (0, _scheduleEs.scheduleAnimation)(state);
  };
  const updateGestureSubscriptions = () => {
    for (const name in gestures) {
      const isGestureActive = gestures[name].isActive(options);
      const remove = gestureSubscriptions[name];
      if (isGestureActive && !remove) {
        gestureSubscriptions[name] = gestures[name].subscribe(element, {
          enable: setGesture(name, true),
          disable: setGesture(name, false)
        }, options);
      } else if (!isGestureActive && remove) {
        remove();
        delete gestureSubscriptions[name];
      }
    }
  };
  const state = {
    update: newOptions => {
      if (!element) return;
      options = newOptions;
      updateGestureSubscriptions();
      (0, _scheduleEs.scheduleAnimation)(state);
    },
    setActive: (name, isActive) => {
      if (!element) return;
      activeStates[name] = isActive;
      (0, _scheduleEs.scheduleAnimation)(state);
    },
    animateUpdates,
    getDepth: () => depth,
    getTarget: () => target,
    getOptions: () => options,
    getContext: () => context,
    mount: newElement => {
      (0, _heyListen.invariant)(Boolean(newElement), "Animation state must be mounted with valid Element");
      element = newElement;
      mountedStates.set(element, state);
      updateGestureSubscriptions();
      return () => {
        mountedStates.delete(element);
        (0, _scheduleEs.unscheduleAnimation)(state);
        for (const key in gestureSubscriptions) {
          gestureSubscriptions[key]();
        }
      };
    },
    isMounted: () => Boolean(element)
  };
  return state;
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/state/utils/events.es.js":
/*!**************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/state/utils/events.es.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.dispatchPointerEvent = dispatchPointerEvent;
exports.dispatchViewEvent = dispatchViewEvent;
exports.motionEvent = void 0;
const motionEvent = (name, target) => new CustomEvent(name, {
  detail: {
    target
  }
});
exports.motionEvent = motionEvent;
function dispatchPointerEvent(element, name, event) {
  element.dispatchEvent(new CustomEvent(name, {
    detail: {
      originalEvent: event
    }
  }));
}
function dispatchViewEvent(element, name, entry) {
  element.dispatchEvent(new CustomEvent(name, {
    detail: {
      originalEntry: entry
    }
  }));
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/state/utils/has-changed.es.js":
/*!*******************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/state/utils/has-changed.es.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.hasChanged = hasChanged;
exports.shallowCompare = shallowCompare;
function hasChanged(a, b) {
  if (typeof a !== typeof b) return true;
  if (Array.isArray(a) && Array.isArray(b)) return !shallowCompare(a, b);
  return a !== b;
}
function shallowCompare(next, prev) {
  const prevLength = prev.length;
  if (prevLength !== next.length) return false;
  for (let i = 0; i < prevLength; i++) {
    if (prev[i] !== next[i]) return false;
  }
  return true;
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/state/utils/is-variant.es.js":
/*!******************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/state/utils/is-variant.es.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isVariant = isVariant;
function isVariant(definition) {
  return typeof definition === "object";
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/state/utils/resolve-variant.es.js":
/*!***********************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/state/utils/resolve-variant.es.js ***!
  \***********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.resolveVariant = resolveVariant;
var _isVariantEs = __webpack_require__(/*! ./is-variant.es.js */ "../../../node_modules/@motionone/dom/dist/state/utils/is-variant.es.js");
function resolveVariant(definition, variants) {
  if ((0, _isVariantEs.isVariant)(definition)) {
    return definition;
  } else if (definition && variants) {
    return variants[definition];
  }
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/state/utils/schedule.es.js":
/*!****************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/state/utils/schedule.es.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.scheduleAnimation = scheduleAnimation;
exports.unscheduleAnimation = unscheduleAnimation;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
let scheduled = undefined;
function processScheduledAnimations() {
  if (!scheduled) return;
  const generators = scheduled.sort(compareByDepth).map(fireAnimateUpdates);
  generators.forEach(fireNext);
  generators.forEach(fireNext);
  scheduled = undefined;
}
function scheduleAnimation(state) {
  if (!scheduled) {
    scheduled = [state];
    requestAnimationFrame(processScheduledAnimations);
  } else {
    (0, _utils.addUniqueItem)(scheduled, state);
  }
}
function unscheduleAnimation(state) {
  scheduled && (0, _utils.removeItem)(scheduled, state);
}
const compareByDepth = (a, b) => a.getDepth() - b.getDepth();
const fireAnimateUpdates = state => state.animateUpdates();
const fireNext = iterator => iterator.next();

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/timeline/index.es.js":
/*!**********************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/timeline/index.es.js ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createAnimationsFromTimeline = createAnimationsFromTimeline;
exports.timeline = timeline;
var _tslib = __webpack_require__(/*! tslib */ "../../../node_modules/tslib/tslib.es6.mjs");
var _heyListen = __webpack_require__(/*! hey-listen */ "../../../node_modules/hey-listen/dist/hey-listen.es.js");
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _staggerEs = __webpack_require__(/*! ../utils/stagger.es.js */ "../../../node_modules/@motionone/dom/dist/utils/stagger.es.js");
var _animateStyleEs = __webpack_require__(/*! ../animate/animate-style.es.js */ "../../../node_modules/@motionone/dom/dist/animate/animate-style.es.js");
var _controlsEs = __webpack_require__(/*! ../animate/utils/controls.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/controls.es.js");
var _keyframesEs = __webpack_require__(/*! ../animate/utils/keyframes.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/keyframes.es.js");
var _optionsEs = __webpack_require__(/*! ../animate/utils/options.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/options.es.js");
var _resolveElementsEs = __webpack_require__(/*! ../utils/resolve-elements.es.js */ "../../../node_modules/@motionone/dom/dist/utils/resolve-elements.es.js");
var _transformsEs = __webpack_require__(/*! ../animate/utils/transforms.es.js */ "../../../node_modules/@motionone/dom/dist/animate/utils/transforms.es.js");
var _calcTimeEs = __webpack_require__(/*! ./utils/calc-time.es.js */ "../../../node_modules/@motionone/dom/dist/timeline/utils/calc-time.es.js");
var _editEs = __webpack_require__(/*! ./utils/edit.es.js */ "../../../node_modules/@motionone/dom/dist/timeline/utils/edit.es.js");
var _sortEs = __webpack_require__(/*! ./utils/sort.es.js */ "../../../node_modules/@motionone/dom/dist/timeline/utils/sort.es.js");
function timeline(definition, options = {}) {
  var _a;
  const animationDefinitions = createAnimationsFromTimeline(definition, options);
  /**
   * Create and start animations
   */
  const animationFactories = animationDefinitions.map(definition => (0, _animateStyleEs.animateStyle)(...definition)).filter(Boolean);
  return (0, _controlsEs.withControls)(animationFactories, options,
  // Get the duration from the first animation definition
  (_a = animationDefinitions[0]) === null || _a === void 0 ? void 0 : _a[3].duration);
}
function createAnimationsFromTimeline(definition, _a = {}) {
  var {
      defaultOptions = {}
    } = _a,
    timelineOptions = (0, _tslib.__rest)(_a, ["defaultOptions"]);
  const animationDefinitions = [];
  const elementSequences = new Map();
  const elementCache = {};
  const timeLabels = new Map();
  let prevTime = 0;
  let currentTime = 0;
  let totalDuration = 0;
  /**
   * Build the timeline by mapping over the definition array and converting
   * the definitions into keyframes and offsets with absolute time values.
   * These will later get converted into relative offsets in a second pass.
   */
  for (let i = 0; i < definition.length; i++) {
    const segment = definition[i];
    /**
     * If this is a timeline label, mark it and skip the rest of this iteration.
     */
    if ((0, _utils.isString)(segment)) {
      timeLabels.set(segment, currentTime);
      continue;
    } else if (!Array.isArray(segment)) {
      timeLabels.set(segment.name, (0, _calcTimeEs.calcNextTime)(currentTime, segment.at, prevTime, timeLabels));
      continue;
    }
    const [elementDefinition, keyframes, options = {}] = segment;
    /**
     * If a relative or absolute time value has been specified we need to resolve
     * it in relation to the currentTime.
     */
    if (options.at !== undefined) {
      currentTime = (0, _calcTimeEs.calcNextTime)(currentTime, options.at, prevTime, timeLabels);
    }
    /**
     * Keep track of the maximum duration in this definition. This will be
     * applied to currentTime once the definition has been parsed.
     */
    let maxDuration = 0;
    /**
     * Find all the elements specified in the definition and parse value
     * keyframes from their timeline definitions.
     */
    const elements = (0, _resolveElementsEs.resolveElements)(elementDefinition, elementCache);
    const numElements = elements.length;
    for (let elementIndex = 0; elementIndex < numElements; elementIndex++) {
      const element = elements[elementIndex];
      const elementSequence = getElementSequence(element, elementSequences);
      for (const key in keyframes) {
        const valueSequence = getValueSequence(key, elementSequence);
        let valueKeyframes = (0, _keyframesEs.keyframesList)(keyframes[key]);
        const valueOptions = (0, _optionsEs.getOptions)(options, key);
        let {
          duration = defaultOptions.duration || _utils.defaults.duration,
          easing = defaultOptions.easing || _utils.defaults.easing
        } = valueOptions;
        if ((0, _utils.isEasingGenerator)(easing)) {
          const valueIsTransform = (0, _transformsEs.isTransform)(key);
          (0, _heyListen.invariant)(valueKeyframes.length === 2 || !valueIsTransform, "spring must be provided 2 keyframes within timeline");
          const custom = easing.createAnimation(valueKeyframes,
          // TODO We currently only support explicit keyframes
          // so this doesn't currently read from the DOM
          () => "0", valueIsTransform);
          easing = custom.easing;
          if (custom.keyframes !== undefined) valueKeyframes = custom.keyframes;
          if (custom.duration !== undefined) duration = custom.duration;
        }
        const delay = (0, _staggerEs.resolveOption)(options.delay, elementIndex, numElements) || 0;
        const startTime = currentTime + delay;
        const targetTime = startTime + duration;
        /**
         *
         */
        let {
          offset = (0, _utils.defaultOffset)(valueKeyframes.length)
        } = valueOptions;
        /**
         * If there's only one offset of 0, fill in a second with length 1
         *
         * TODO: Ensure there's a test that covers this removal
         */
        if (offset.length === 1 && offset[0] === 0) {
          offset[1] = 1;
        }
        /**
         * Fill out if offset if fewer offsets than keyframes
         */
        const remainder = length - valueKeyframes.length;
        remainder > 0 && (0, _utils.fillOffset)(offset, remainder);
        /**
         * If only one value has been set, ie [1], push a null to the start of
         * the keyframe array. This will let us mark a keyframe at this point
         * that will later be hydrated with the previous value.
         */
        valueKeyframes.length === 1 && valueKeyframes.unshift(null);
        /**
         * Add keyframes, mapping offsets to absolute time.
         */
        (0, _editEs.addKeyframes)(valueSequence, valueKeyframes, easing, offset, startTime, targetTime);
        maxDuration = Math.max(delay + duration, maxDuration);
        totalDuration = Math.max(targetTime, totalDuration);
      }
    }
    prevTime = currentTime;
    currentTime += maxDuration;
  }
  /**
   * For every element and value combination create a new animation.
   */
  elementSequences.forEach((valueSequences, element) => {
    for (const key in valueSequences) {
      const valueSequence = valueSequences[key];
      /**
       * Arrange all the keyframes in ascending time order.
       */
      valueSequence.sort(_sortEs.compareByTime);
      const keyframes = [];
      const valueOffset = [];
      const valueEasing = [];
      /**
       * For each keyframe, translate absolute times into
       * relative offsets based on the total duration of the timeline.
       */
      for (let i = 0; i < valueSequence.length; i++) {
        const {
          at,
          value,
          easing
        } = valueSequence[i];
        keyframes.push(value);
        valueOffset.push((0, _utils.progress)(0, totalDuration, at));
        valueEasing.push(easing || _utils.defaults.easing);
      }
      /**
       * If the first keyframe doesn't land on offset: 0
       * provide one by duplicating the initial keyframe. This ensures
       * it snaps to the first keyframe when the animation starts.
       */
      if (valueOffset[0] !== 0) {
        valueOffset.unshift(0);
        keyframes.unshift(keyframes[0]);
        valueEasing.unshift("linear");
      }
      /**
       * If the last keyframe doesn't land on offset: 1
       * provide one with a null wildcard value. This will ensure it
       * stays static until the end of the animation.
       */
      if (valueOffset[valueOffset.length - 1] !== 1) {
        valueOffset.push(1);
        keyframes.push(null);
      }
      animationDefinitions.push([element, key, keyframes, Object.assign(Object.assign(Object.assign({}, defaultOptions), {
        duration: totalDuration,
        easing: valueEasing,
        offset: valueOffset
      }), timelineOptions)]);
    }
  });
  return animationDefinitions;
}
function getElementSequence(element, sequences) {
  !sequences.has(element) && sequences.set(element, {});
  return sequences.get(element);
}
function getValueSequence(name, sequences) {
  if (!sequences[name]) sequences[name] = [];
  return sequences[name];
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/timeline/utils/calc-time.es.js":
/*!********************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/timeline/utils/calc-time.es.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.calcNextTime = calcNextTime;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
function calcNextTime(current, next, prev, labels) {
  var _a;
  if ((0, _utils.isNumber)(next)) {
    return next;
  } else if (next.startsWith("-") || next.startsWith("+")) {
    return Math.max(0, current + parseFloat(next));
  } else if (next === "<") {
    return prev;
  } else {
    return (_a = labels.get(next)) !== null && _a !== void 0 ? _a : current;
  }
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/timeline/utils/edit.es.js":
/*!***************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/timeline/utils/edit.es.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.addKeyframes = addKeyframes;
exports.eraseKeyframes = eraseKeyframes;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
function eraseKeyframes(sequence, startTime, endTime) {
  for (let i = 0; i < sequence.length; i++) {
    const keyframe = sequence[i];
    if (keyframe.at > startTime && keyframe.at < endTime) {
      (0, _utils.removeItem)(sequence, keyframe);
      // If we remove this item we have to push the pointer back one
      i--;
    }
  }
}
function addKeyframes(sequence, keyframes, easing, offset, startTime, endTime) {
  /**
   * Erase every existing value between currentTime and targetTime,
   * this will essentially splice this timeline into any currently
   * defined ones.
   */
  eraseKeyframes(sequence, startTime, endTime);
  for (let i = 0; i < keyframes.length; i++) {
    sequence.push({
      value: keyframes[i],
      at: (0, _utils.mix)(startTime, endTime, offset[i]),
      easing: (0, _utils.getEasingForSegment)(easing, i)
    });
  }
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/timeline/utils/sort.es.js":
/*!***************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/timeline/utils/sort.es.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.compareByTime = compareByTime;
function compareByTime(a, b) {
  if (a.at === b.at) {
    return a.value === null ? 1 : -1;
  } else {
    return a.at - b.at;
  }
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/utils/resolve-elements.es.js":
/*!******************************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/utils/resolve-elements.es.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.resolveElements = resolveElements;
function resolveElements(elements, selectorCache) {
  var _a;
  if (typeof elements === "string") {
    if (selectorCache) {
      (_a = selectorCache[elements]) !== null && _a !== void 0 ? _a : selectorCache[elements] = document.querySelectorAll(elements);
      elements = selectorCache[elements];
    } else {
      elements = document.querySelectorAll(elements);
    }
  } else if (elements instanceof Element) {
    elements = [elements];
  }
  /**
   * Return an empty array
   */
  return Array.from(elements || []);
}

/***/ }),

/***/ "../../../node_modules/@motionone/dom/dist/utils/stagger.es.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/@motionone/dom/dist/utils/stagger.es.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getFromIndex = getFromIndex;
exports.resolveOption = resolveOption;
exports.stagger = stagger;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _animation = __webpack_require__(/*! @motionone/animation */ "../../../node_modules/@motionone/animation/dist/index.es.js");
function stagger(duration = 0.1, {
  start = 0,
  from = 0,
  easing
} = {}) {
  return (i, total) => {
    const fromIndex = (0, _utils.isNumber)(from) ? from : getFromIndex(from, total);
    const distance = Math.abs(fromIndex - i);
    let delay = duration * distance;
    if (easing) {
      const maxDelay = total * duration;
      const easingFunction = (0, _animation.getEasingFunction)(easing);
      delay = easingFunction(delay / maxDelay) * maxDelay;
    }
    return start + delay;
  };
}
function getFromIndex(from, total) {
  if (from === "first") {
    return 0;
  } else {
    const lastIndex = total - 1;
    return from === "last" ? lastIndex : lastIndex / 2;
  }
}
function resolveOption(option, i, total) {
  return typeof option === "function" ? option(i, total) : option;
}

/***/ }),

/***/ "../../../node_modules/@motionone/easing/dist/cubic-bezier.es.js":
/*!***********************************************************************!*\
  !*** ../../../node_modules/@motionone/easing/dist/cubic-bezier.es.js ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.cubicBezier = cubicBezier;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
/*
  Bezier function generator

  This has been modified from Gaëtan Renaudeau's BezierEasing
  https://github.com/gre/bezier-easing/blob/master/src/index.js
  https://github.com/gre/bezier-easing/blob/master/LICENSE
  
  I've removed the newtonRaphsonIterate algo because in benchmarking it
  wasn't noticiably faster than binarySubdivision, indeed removing it
  usually improved times, depending on the curve.

  I also removed the lookup table, as for the added bundle size and loop we're
  only cutting ~4 or so subdivision iterations. I bumped the max iterations up
  to 12 to compensate and this still tended to be faster for no perceivable
  loss in accuracy.

  Usage
    const easeOut = cubicBezier(.17,.67,.83,.67);
    const x = easeOut(0.5); // returns 0.627...
*/
// Returns x(t) given t, x1, and x2, or y(t) given t, y1, and y2.
const calcBezier = (t, a1, a2) => (((1.0 - 3.0 * a2 + 3.0 * a1) * t + (3.0 * a2 - 6.0 * a1)) * t + 3.0 * a1) * t;
const subdivisionPrecision = 0.0000001;
const subdivisionMaxIterations = 12;
function binarySubdivide(x, lowerBound, upperBound, mX1, mX2) {
  let currentX;
  let currentT;
  let i = 0;
  do {
    currentT = lowerBound + (upperBound - lowerBound) / 2.0;
    currentX = calcBezier(currentT, mX1, mX2) - x;
    if (currentX > 0.0) {
      upperBound = currentT;
    } else {
      lowerBound = currentT;
    }
  } while (Math.abs(currentX) > subdivisionPrecision && ++i < subdivisionMaxIterations);
  return currentT;
}
function cubicBezier(mX1, mY1, mX2, mY2) {
  // If this is a linear gradient, return linear easing
  if (mX1 === mY1 && mX2 === mY2) return _utils.noopReturn;
  const getTForX = aX => binarySubdivide(aX, 0, 1, mX1, mX2);
  // If animation is at start/end, return t without easing
  return t => t === 0 || t === 1 ? t : calcBezier(getTForX(t), mY1, mY2);
}

/***/ }),

/***/ "../../../node_modules/@motionone/easing/dist/index.es.js":
/*!****************************************************************!*\
  !*** ../../../node_modules/@motionone/easing/dist/index.es.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "cubicBezier", ({
  enumerable: true,
  get: function () {
    return _cubicBezierEs.cubicBezier;
  }
}));
Object.defineProperty(exports, "steps", ({
  enumerable: true,
  get: function () {
    return _stepsEs.steps;
  }
}));
var _cubicBezierEs = __webpack_require__(/*! ./cubic-bezier.es.js */ "../../../node_modules/@motionone/easing/dist/cubic-bezier.es.js");
var _stepsEs = __webpack_require__(/*! ./steps.es.js */ "../../../node_modules/@motionone/easing/dist/steps.es.js");

/***/ }),

/***/ "../../../node_modules/@motionone/easing/dist/steps.es.js":
/*!****************************************************************!*\
  !*** ../../../node_modules/@motionone/easing/dist/steps.es.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.steps = void 0;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
const steps = (steps, direction = "end") => progress => {
  progress = direction === "end" ? Math.min(progress, 0.999) : Math.max(progress, 0.001);
  const expanded = progress * steps;
  const rounded = direction === "end" ? Math.floor(expanded) : Math.ceil(expanded);
  return (0, _utils.clamp)(0, 1, rounded / steps);
};
exports.steps = steps;

/***/ }),

/***/ "../../../node_modules/@motionone/generators/dist/glide/index.es.js":
/*!**************************************************************************!*\
  !*** ../../../node_modules/@motionone/generators/dist/glide/index.es.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.glide = void 0;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _velocityEs = __webpack_require__(/*! ../utils/velocity.es.js */ "../../../node_modules/@motionone/generators/dist/utils/velocity.es.js");
var _indexEs = __webpack_require__(/*! ../spring/index.es.js */ "../../../node_modules/@motionone/generators/dist/spring/index.es.js");
const glide = ({
  from = 0,
  velocity = 0.0,
  power = 0.8,
  decay = 0.325,
  bounceDamping,
  bounceStiffness,
  changeTarget,
  min,
  max,
  restDistance = 0.5,
  restSpeed
}) => {
  decay = _utils.time.ms(decay);
  const state = {
    hasReachedTarget: false,
    done: false,
    current: from,
    target: from
  };
  const isOutOfBounds = v => min !== undefined && v < min || max !== undefined && v > max;
  const nearestBoundary = v => {
    if (min === undefined) return max;
    if (max === undefined) return min;
    return Math.abs(min - v) < Math.abs(max - v) ? min : max;
  };
  let amplitude = power * velocity;
  const ideal = from + amplitude;
  const target = changeTarget === undefined ? ideal : changeTarget(ideal);
  state.target = target;
  /**
   * If the target has changed we need to re-calculate the amplitude, otherwise
   * the animation will start from the wrong position.
   */
  if (target !== ideal) amplitude = target - from;
  const calcDelta = t => -amplitude * Math.exp(-t / decay);
  const calcLatest = t => target + calcDelta(t);
  const applyFriction = t => {
    const delta = calcDelta(t);
    const latest = calcLatest(t);
    state.done = Math.abs(delta) <= restDistance;
    state.current = state.done ? target : latest;
  };
  /**
   * Ideally this would resolve for t in a stateless way, we could
   * do that by always precalculating the animation but as we know
   * this will be done anyway we can assume that spring will
   * be discovered during that.
   */
  let timeReachedBoundary;
  let spring$1;
  const checkCatchBoundary = t => {
    if (!isOutOfBounds(state.current)) return;
    timeReachedBoundary = t;
    spring$1 = (0, _indexEs.spring)({
      from: state.current,
      to: nearestBoundary(state.current),
      velocity: (0, _velocityEs.calcGeneratorVelocity)(calcLatest, t, state.current),
      damping: bounceDamping,
      stiffness: bounceStiffness,
      restDistance,
      restSpeed
    });
  };
  checkCatchBoundary(0);
  return t => {
    /**
     * We need to resolve the friction to figure out if we need a
     * spring but we don't want to do this twice per frame. So here
     * we flag if we updated for this frame and later if we did
     * we can skip doing it again.
     */
    let hasUpdatedFrame = false;
    if (!spring$1 && timeReachedBoundary === undefined) {
      hasUpdatedFrame = true;
      applyFriction(t);
      checkCatchBoundary(t);
    }
    /**
     * If we have a spring and the provided t is beyond the moment the friction
     * animation crossed the min/max boundary, use the spring.
     */
    if (timeReachedBoundary !== undefined && t > timeReachedBoundary) {
      state.hasReachedTarget = true;
      return spring$1(t - timeReachedBoundary);
    } else {
      state.hasReachedTarget = false;
      !hasUpdatedFrame && applyFriction(t);
      return state;
    }
  };
};
exports.glide = glide;

/***/ }),

/***/ "../../../node_modules/@motionone/generators/dist/index.es.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@motionone/generators/dist/index.es.js ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "calcGeneratorVelocity", ({
  enumerable: true,
  get: function () {
    return _velocityEs.calcGeneratorVelocity;
  }
}));
Object.defineProperty(exports, "glide", ({
  enumerable: true,
  get: function () {
    return _indexEs.glide;
  }
}));
Object.defineProperty(exports, "pregenerateKeyframes", ({
  enumerable: true,
  get: function () {
    return _pregenerateKeyframesEs.pregenerateKeyframes;
  }
}));
Object.defineProperty(exports, "spring", ({
  enumerable: true,
  get: function () {
    return _indexEs2.spring;
  }
}));
var _indexEs = __webpack_require__(/*! ./glide/index.es.js */ "../../../node_modules/@motionone/generators/dist/glide/index.es.js");
var _indexEs2 = __webpack_require__(/*! ./spring/index.es.js */ "../../../node_modules/@motionone/generators/dist/spring/index.es.js");
var _pregenerateKeyframesEs = __webpack_require__(/*! ./utils/pregenerate-keyframes.es.js */ "../../../node_modules/@motionone/generators/dist/utils/pregenerate-keyframes.es.js");
var _velocityEs = __webpack_require__(/*! ./utils/velocity.es.js */ "../../../node_modules/@motionone/generators/dist/utils/velocity.es.js");

/***/ }),

/***/ "../../../node_modules/@motionone/generators/dist/spring/defaults.es.js":
/*!******************************************************************************!*\
  !*** ../../../node_modules/@motionone/generators/dist/spring/defaults.es.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.defaults = void 0;
const defaults = exports.defaults = {
  stiffness: 100.0,
  damping: 10.0,
  mass: 1.0
};

/***/ }),

/***/ "../../../node_modules/@motionone/generators/dist/spring/index.es.js":
/*!***************************************************************************!*\
  !*** ../../../node_modules/@motionone/generators/dist/spring/index.es.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.spring = void 0;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
var _defaultsEs = __webpack_require__(/*! ./defaults.es.js */ "../../../node_modules/@motionone/generators/dist/spring/defaults.es.js");
var _utilsEs = __webpack_require__(/*! ./utils.es.js */ "../../../node_modules/@motionone/generators/dist/spring/utils.es.js");
var _hasReachedTargetEs = __webpack_require__(/*! ../utils/has-reached-target.es.js */ "../../../node_modules/@motionone/generators/dist/utils/has-reached-target.es.js");
var _velocityEs = __webpack_require__(/*! ../utils/velocity.es.js */ "../../../node_modules/@motionone/generators/dist/utils/velocity.es.js");
const spring = ({
  stiffness = _defaultsEs.defaults.stiffness,
  damping = _defaultsEs.defaults.damping,
  mass = _defaultsEs.defaults.mass,
  from = 0,
  to = 1,
  velocity = 0.0,
  restSpeed = 2,
  restDistance = 0.5
} = {}) => {
  velocity = velocity ? _utils.time.s(velocity) : 0.0;
  const state = {
    done: false,
    hasReachedTarget: false,
    current: from,
    target: to
  };
  const initialDelta = to - from;
  const undampedAngularFreq = Math.sqrt(stiffness / mass) / 1000;
  const dampingRatio = (0, _utilsEs.calcDampingRatio)(stiffness, damping, mass);
  let resolveSpring;
  if (dampingRatio < 1) {
    const angularFreq = undampedAngularFreq * Math.sqrt(1 - dampingRatio * dampingRatio);
    // Underdamped spring (bouncy)
    resolveSpring = t => to - Math.exp(-dampingRatio * undampedAngularFreq * t) * ((-velocity + dampingRatio * undampedAngularFreq * initialDelta) / angularFreq * Math.sin(angularFreq * t) + initialDelta * Math.cos(angularFreq * t));
  } else {
    // Critically damped spring
    resolveSpring = t => {
      return to - Math.exp(-undampedAngularFreq * t) * (initialDelta + (-velocity + undampedAngularFreq * initialDelta) * t);
    };
  }
  return t => {
    state.current = resolveSpring(t);
    const currentVelocity = t === 0 ? velocity : (0, _velocityEs.calcGeneratorVelocity)(resolveSpring, t, state.current);
    const isBelowVelocityThreshold = Math.abs(currentVelocity) <= restSpeed;
    const isBelowDisplacementThreshold = Math.abs(to - state.current) <= restDistance;
    state.done = isBelowVelocityThreshold && isBelowDisplacementThreshold;
    state.hasReachedTarget = (0, _hasReachedTargetEs.hasReachedTarget)(from, to, state.current);
    return state;
  };
};
exports.spring = spring;

/***/ }),

/***/ "../../../node_modules/@motionone/generators/dist/spring/utils.es.js":
/*!***************************************************************************!*\
  !*** ../../../node_modules/@motionone/generators/dist/spring/utils.es.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.calcDampingRatio = void 0;
var _defaultsEs = __webpack_require__(/*! ./defaults.es.js */ "../../../node_modules/@motionone/generators/dist/spring/defaults.es.js");
const calcDampingRatio = (stiffness = _defaultsEs.defaults.stiffness, damping = _defaultsEs.defaults.damping, mass = _defaultsEs.defaults.mass) => damping / (2 * Math.sqrt(stiffness * mass));
exports.calcDampingRatio = calcDampingRatio;

/***/ }),

/***/ "../../../node_modules/@motionone/generators/dist/utils/has-reached-target.es.js":
/*!***************************************************************************************!*\
  !*** ../../../node_modules/@motionone/generators/dist/utils/has-reached-target.es.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.hasReachedTarget = hasReachedTarget;
function hasReachedTarget(origin, target, current) {
  return origin < target && current >= target || origin > target && current <= target;
}

/***/ }),

/***/ "../../../node_modules/@motionone/generators/dist/utils/pregenerate-keyframes.es.js":
/*!******************************************************************************************!*\
  !*** ../../../node_modules/@motionone/generators/dist/utils/pregenerate-keyframes.es.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.pregenerateKeyframes = pregenerateKeyframes;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
const timeStep = 10;
const maxDuration = 10000;
function pregenerateKeyframes(generator, toUnit = _utils.noopReturn) {
  let overshootDuration = undefined;
  let timestamp = timeStep;
  let state = generator(0);
  const keyframes = [toUnit(state.current)];
  while (!state.done && timestamp < maxDuration) {
    state = generator(timestamp);
    keyframes.push(toUnit(state.done ? state.target : state.current));
    if (overshootDuration === undefined && state.hasReachedTarget) {
      overshootDuration = timestamp;
    }
    timestamp += timeStep;
  }
  const duration = timestamp - timeStep;
  /**
   * If generating an animation that didn't actually move,
   * generate a second keyframe so we have an origin and target.
   */
  if (keyframes.length === 1) keyframes.push(state.current);
  return {
    keyframes,
    duration: duration / 1000,
    overshootDuration: (overshootDuration !== null && overshootDuration !== void 0 ? overshootDuration : duration) / 1000
  };
}

/***/ }),

/***/ "../../../node_modules/@motionone/generators/dist/utils/velocity.es.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@motionone/generators/dist/utils/velocity.es.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.calcGeneratorVelocity = calcGeneratorVelocity;
var _utils = __webpack_require__(/*! @motionone/utils */ "../../../node_modules/@motionone/utils/dist/index.es.js");
const sampleT = 5; // ms
function calcGeneratorVelocity(resolveValue, t, current) {
  const prevT = Math.max(t - sampleT, 0);
  return (0, _utils.velocityPerSecond)(current - resolveValue(prevT), t - prevT);
}

/***/ }),

/***/ "../../../node_modules/@motionone/types/dist/MotionValue.es.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/@motionone/types/dist/MotionValue.es.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.MotionValue = void 0;
/**
 * The MotionValue tracks the state of a single animatable
 * value. Currently, updatedAt and current are unused. The
 * long term idea is to use this to minimise the number
 * of DOM reads, and to abstract the DOM interactions here.
 */
class MotionValue {
  setAnimation(animation) {
    this.animation = animation;
    animation === null || animation === void 0 ? void 0 : animation.finished.then(() => this.clearAnimation()).catch(() => {});
  }
  clearAnimation() {
    this.animation = this.generator = undefined;
  }
}
exports.MotionValue = MotionValue;

/***/ }),

/***/ "../../../node_modules/@motionone/types/dist/index.es.js":
/*!***************************************************************!*\
  !*** ../../../node_modules/@motionone/types/dist/index.es.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "MotionValue", ({
  enumerable: true,
  get: function () {
    return _MotionValueEs.MotionValue;
  }
}));
var _MotionValueEs = __webpack_require__(/*! ./MotionValue.es.js */ "../../../node_modules/@motionone/types/dist/MotionValue.es.js");

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/array.es.js":
/*!***************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/array.es.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.addUniqueItem = addUniqueItem;
exports.removeItem = removeItem;
function addUniqueItem(array, item) {
  array.indexOf(item) === -1 && array.push(item);
}
function removeItem(arr, item) {
  const index = arr.indexOf(item);
  index > -1 && arr.splice(index, 1);
}

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/clamp.es.js":
/*!***************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/clamp.es.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.clamp = void 0;
const clamp = (min, max, v) => Math.min(Math.max(v, min), max);
exports.clamp = clamp;

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/defaults.es.js":
/*!******************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/defaults.es.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.defaults = void 0;
const defaults = exports.defaults = {
  duration: 0.3,
  delay: 0,
  endDelay: 0,
  repeat: 0,
  easing: "ease"
};

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/easing.es.js":
/*!****************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/easing.es.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getEasingForSegment = getEasingForSegment;
var _isEasingListEs = __webpack_require__(/*! ./is-easing-list.es.js */ "../../../node_modules/@motionone/utils/dist/is-easing-list.es.js");
var _wrapEs = __webpack_require__(/*! ./wrap.es.js */ "../../../node_modules/@motionone/utils/dist/wrap.es.js");
function getEasingForSegment(easing, i) {
  return (0, _isEasingListEs.isEasingList)(easing) ? easing[(0, _wrapEs.wrap)(0, easing.length, i)] : easing;
}

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/index.es.js":
/*!***************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/index.es.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "addUniqueItem", ({
  enumerable: true,
  get: function () {
    return _arrayEs.addUniqueItem;
  }
}));
Object.defineProperty(exports, "clamp", ({
  enumerable: true,
  get: function () {
    return _clampEs.clamp;
  }
}));
Object.defineProperty(exports, "defaultOffset", ({
  enumerable: true,
  get: function () {
    return _offsetEs.defaultOffset;
  }
}));
Object.defineProperty(exports, "defaults", ({
  enumerable: true,
  get: function () {
    return _defaultsEs.defaults;
  }
}));
Object.defineProperty(exports, "fillOffset", ({
  enumerable: true,
  get: function () {
    return _offsetEs.fillOffset;
  }
}));
Object.defineProperty(exports, "getEasingForSegment", ({
  enumerable: true,
  get: function () {
    return _easingEs.getEasingForSegment;
  }
}));
Object.defineProperty(exports, "interpolate", ({
  enumerable: true,
  get: function () {
    return _interpolateEs.interpolate;
  }
}));
Object.defineProperty(exports, "isCubicBezier", ({
  enumerable: true,
  get: function () {
    return _isCubicBezierEs.isCubicBezier;
  }
}));
Object.defineProperty(exports, "isEasingGenerator", ({
  enumerable: true,
  get: function () {
    return _isEasingGeneratorEs.isEasingGenerator;
  }
}));
Object.defineProperty(exports, "isEasingList", ({
  enumerable: true,
  get: function () {
    return _isEasingListEs.isEasingList;
  }
}));
Object.defineProperty(exports, "isFunction", ({
  enumerable: true,
  get: function () {
    return _isFunctionEs.isFunction;
  }
}));
Object.defineProperty(exports, "isNumber", ({
  enumerable: true,
  get: function () {
    return _isNumberEs.isNumber;
  }
}));
Object.defineProperty(exports, "isString", ({
  enumerable: true,
  get: function () {
    return _isStringEs.isString;
  }
}));
Object.defineProperty(exports, "mix", ({
  enumerable: true,
  get: function () {
    return _mixEs.mix;
  }
}));
Object.defineProperty(exports, "noop", ({
  enumerable: true,
  get: function () {
    return _noopEs.noop;
  }
}));
Object.defineProperty(exports, "noopReturn", ({
  enumerable: true,
  get: function () {
    return _noopEs.noopReturn;
  }
}));
Object.defineProperty(exports, "progress", ({
  enumerable: true,
  get: function () {
    return _progressEs.progress;
  }
}));
Object.defineProperty(exports, "removeItem", ({
  enumerable: true,
  get: function () {
    return _arrayEs.removeItem;
  }
}));
Object.defineProperty(exports, "time", ({
  enumerable: true,
  get: function () {
    return _timeEs.time;
  }
}));
Object.defineProperty(exports, "velocityPerSecond", ({
  enumerable: true,
  get: function () {
    return _velocityEs.velocityPerSecond;
  }
}));
Object.defineProperty(exports, "wrap", ({
  enumerable: true,
  get: function () {
    return _wrapEs.wrap;
  }
}));
var _arrayEs = __webpack_require__(/*! ./array.es.js */ "../../../node_modules/@motionone/utils/dist/array.es.js");
var _clampEs = __webpack_require__(/*! ./clamp.es.js */ "../../../node_modules/@motionone/utils/dist/clamp.es.js");
var _defaultsEs = __webpack_require__(/*! ./defaults.es.js */ "../../../node_modules/@motionone/utils/dist/defaults.es.js");
var _easingEs = __webpack_require__(/*! ./easing.es.js */ "../../../node_modules/@motionone/utils/dist/easing.es.js");
var _interpolateEs = __webpack_require__(/*! ./interpolate.es.js */ "../../../node_modules/@motionone/utils/dist/interpolate.es.js");
var _isCubicBezierEs = __webpack_require__(/*! ./is-cubic-bezier.es.js */ "../../../node_modules/@motionone/utils/dist/is-cubic-bezier.es.js");
var _isEasingGeneratorEs = __webpack_require__(/*! ./is-easing-generator.es.js */ "../../../node_modules/@motionone/utils/dist/is-easing-generator.es.js");
var _isEasingListEs = __webpack_require__(/*! ./is-easing-list.es.js */ "../../../node_modules/@motionone/utils/dist/is-easing-list.es.js");
var _isFunctionEs = __webpack_require__(/*! ./is-function.es.js */ "../../../node_modules/@motionone/utils/dist/is-function.es.js");
var _isNumberEs = __webpack_require__(/*! ./is-number.es.js */ "../../../node_modules/@motionone/utils/dist/is-number.es.js");
var _isStringEs = __webpack_require__(/*! ./is-string.es.js */ "../../../node_modules/@motionone/utils/dist/is-string.es.js");
var _mixEs = __webpack_require__(/*! ./mix.es.js */ "../../../node_modules/@motionone/utils/dist/mix.es.js");
var _noopEs = __webpack_require__(/*! ./noop.es.js */ "../../../node_modules/@motionone/utils/dist/noop.es.js");
var _offsetEs = __webpack_require__(/*! ./offset.es.js */ "../../../node_modules/@motionone/utils/dist/offset.es.js");
var _progressEs = __webpack_require__(/*! ./progress.es.js */ "../../../node_modules/@motionone/utils/dist/progress.es.js");
var _timeEs = __webpack_require__(/*! ./time.es.js */ "../../../node_modules/@motionone/utils/dist/time.es.js");
var _velocityEs = __webpack_require__(/*! ./velocity.es.js */ "../../../node_modules/@motionone/utils/dist/velocity.es.js");
var _wrapEs = __webpack_require__(/*! ./wrap.es.js */ "../../../node_modules/@motionone/utils/dist/wrap.es.js");

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/interpolate.es.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/interpolate.es.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.interpolate = interpolate;
var _mixEs = __webpack_require__(/*! ./mix.es.js */ "../../../node_modules/@motionone/utils/dist/mix.es.js");
var _noopEs = __webpack_require__(/*! ./noop.es.js */ "../../../node_modules/@motionone/utils/dist/noop.es.js");
var _offsetEs = __webpack_require__(/*! ./offset.es.js */ "../../../node_modules/@motionone/utils/dist/offset.es.js");
var _progressEs = __webpack_require__(/*! ./progress.es.js */ "../../../node_modules/@motionone/utils/dist/progress.es.js");
var _easingEs = __webpack_require__(/*! ./easing.es.js */ "../../../node_modules/@motionone/utils/dist/easing.es.js");
var _clampEs = __webpack_require__(/*! ./clamp.es.js */ "../../../node_modules/@motionone/utils/dist/clamp.es.js");
function interpolate(output, input = (0, _offsetEs.defaultOffset)(output.length), easing = _noopEs.noopReturn) {
  const length = output.length;
  /**
   * If the input length is lower than the output we
   * fill the input to match. This currently assumes the input
   * is an animation progress value so is a good candidate for
   * moving outside the function.
   */
  const remainder = length - input.length;
  remainder > 0 && (0, _offsetEs.fillOffset)(input, remainder);
  return t => {
    let i = 0;
    for (; i < length - 2; i++) {
      if (t < input[i + 1]) break;
    }
    let progressInRange = (0, _clampEs.clamp)(0, 1, (0, _progressEs.progress)(input[i], input[i + 1], t));
    const segmentEasing = (0, _easingEs.getEasingForSegment)(easing, i);
    progressInRange = segmentEasing(progressInRange);
    return (0, _mixEs.mix)(output[i], output[i + 1], progressInRange);
  };
}

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/is-cubic-bezier.es.js":
/*!*************************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/is-cubic-bezier.es.js ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isCubicBezier = void 0;
var _isNumberEs = __webpack_require__(/*! ./is-number.es.js */ "../../../node_modules/@motionone/utils/dist/is-number.es.js");
const isCubicBezier = easing => Array.isArray(easing) && (0, _isNumberEs.isNumber)(easing[0]);
exports.isCubicBezier = isCubicBezier;

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/is-easing-generator.es.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/is-easing-generator.es.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isEasingGenerator = void 0;
const isEasingGenerator = easing => typeof easing === "object" && Boolean(easing.createAnimation);
exports.isEasingGenerator = isEasingGenerator;

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/is-easing-list.es.js":
/*!************************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/is-easing-list.es.js ***!
  \************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isEasingList = void 0;
var _isNumberEs = __webpack_require__(/*! ./is-number.es.js */ "../../../node_modules/@motionone/utils/dist/is-number.es.js");
const isEasingList = easing => Array.isArray(easing) && !(0, _isNumberEs.isNumber)(easing[0]);
exports.isEasingList = isEasingList;

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/is-function.es.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/is-function.es.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isFunction = void 0;
const isFunction = value => typeof value === "function";
exports.isFunction = isFunction;

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/is-number.es.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/is-number.es.js ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isNumber = void 0;
const isNumber = value => typeof value === "number";
exports.isNumber = isNumber;

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/is-string.es.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/is-string.es.js ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isString = void 0;
const isString = value => typeof value === "string";
exports.isString = isString;

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/mix.es.js":
/*!*************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/mix.es.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.mix = void 0;
const mix = (min, max, progress) => -progress * min + progress * max + min;
exports.mix = mix;

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/noop.es.js":
/*!**************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/noop.es.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.noopReturn = exports.noop = void 0;
const noop = () => {};
exports.noop = noop;
const noopReturn = v => v;
exports.noopReturn = noopReturn;

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/offset.es.js":
/*!****************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/offset.es.js ***!
  \****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.defaultOffset = defaultOffset;
exports.fillOffset = fillOffset;
var _mixEs = __webpack_require__(/*! ./mix.es.js */ "../../../node_modules/@motionone/utils/dist/mix.es.js");
var _progressEs = __webpack_require__(/*! ./progress.es.js */ "../../../node_modules/@motionone/utils/dist/progress.es.js");
function fillOffset(offset, remaining) {
  const min = offset[offset.length - 1];
  for (let i = 1; i <= remaining; i++) {
    const offsetProgress = (0, _progressEs.progress)(0, remaining, i);
    offset.push((0, _mixEs.mix)(min, 1, offsetProgress));
  }
}
function defaultOffset(length) {
  const offset = [0];
  fillOffset(offset, length - 1);
  return offset;
}

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/progress.es.js":
/*!******************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/progress.es.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.progress = void 0;
const progress = (min, max, value) => max - min === 0 ? 1 : (value - min) / (max - min);
exports.progress = progress;

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/time.es.js":
/*!**************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/time.es.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.time = void 0;
const time = exports.time = {
  ms: seconds => seconds * 1000,
  s: milliseconds => milliseconds / 1000
};

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/velocity.es.js":
/*!******************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/velocity.es.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.velocityPerSecond = velocityPerSecond;
/*
  Convert velocity into velocity per second

  @param [number]: Unit per frame
  @param [number]: Frame duration in ms
*/
function velocityPerSecond(velocity, frameDuration) {
  return frameDuration ? velocity * (1000 / frameDuration) : 0;
}

/***/ }),

/***/ "../../../node_modules/@motionone/utils/dist/wrap.es.js":
/*!**************************************************************!*\
  !*** ../../../node_modules/@motionone/utils/dist/wrap.es.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.wrap = void 0;
const wrap = (min, max, v) => {
  const rangeSize = max - min;
  return ((v - min) % rangeSize + rangeSize) % rangeSize + min;
};
exports.wrap = wrap;

/***/ }),

/***/ "../../../node_modules/@n1ru4l/push-pull-async-iterable-iterator/index.js":
/*!********************************************************************************!*\
  !*** ../../../node_modules/@n1ru4l/push-pull-async-iterable-iterator/index.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
function createDeferred() {
  const d = {};
  d.promise = new Promise((resolve, reject) => {
    d.resolve = resolve;
    d.reject = reject;
  });
  return d;
}
const SYMBOL_FINISHED = Symbol();
const SYMBOL_NEW_VALUE = Symbol();
/**
 * makePushPullAsyncIterableIterator
 *
 * The iterable will publish values until return or throw is called.
 * Afterwards it is in the completed state and cannot be used for publishing any further values.
 * It will handle back-pressure and keep pushed values until they are consumed by a source.
 */
function makePushPullAsyncIterableIterator() {
  let isRunning = true;
  const values = [];
  let newValueD = createDeferred();
  const finishedD = createDeferred();
  const asyncIterableIterator = async function* PushPullAsyncIterableIterator() {
    while (true) {
      if (values.length > 0) {
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        yield values.shift();
      } else {
        const result = await Promise.race([newValueD.promise, finishedD.promise]);
        if (result === SYMBOL_FINISHED) {
          break;
        }
        if (result !== SYMBOL_NEW_VALUE) {
          throw result;
        }
      }
    }
  }();
  function pushValue(value) {
    if (isRunning === false) {
      // TODO: Should this throw?
      return;
    }
    values.push(value);
    newValueD.resolve(SYMBOL_NEW_VALUE);
    newValueD = createDeferred();
  }
  // We monkey patch the original generator for clean-up
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  const originalReturn = asyncIterableIterator.return.bind(asyncIterableIterator);
  asyncIterableIterator.return = (
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  ...args) => {
    isRunning = false;
    finishedD.resolve(SYMBOL_FINISHED);
    return originalReturn(...args);
  };
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  const originalThrow = asyncIterableIterator.throw.bind(asyncIterableIterator);
  asyncIterableIterator.throw = err => {
    isRunning = false;
    finishedD.resolve(err);
    return originalThrow(err);
  };
  return {
    pushValue,
    asyncIterableIterator
  };
}
const makeAsyncIterableIteratorFromSink = make => {
  const {
    pushValue,
    asyncIterableIterator
  } = makePushPullAsyncIterableIterator();
  const dispose = make({
    next: value => {
      pushValue(value);
    },
    complete: () => {
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      asyncIterableIterator.return();
    },
    error: err => {
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      asyncIterableIterator.throw(err);
    }
  });
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  const originalReturn = asyncIterableIterator.return;
  let returnValue = undefined;
  asyncIterableIterator.return = () => {
    if (returnValue === undefined) {
      dispose();
      returnValue = originalReturn();
    }
    return returnValue;
  };
  return asyncIterableIterator;
};
function applyAsyncIterableIteratorToSink(asyncIterableIterator, sink) {
  const run = async () => {
    try {
      for await (const value of asyncIterableIterator) {
        sink.next(value);
      }
      sink.complete();
    } catch (err) {
      sink.error(err);
    }
  };
  run();
  return () => {
    var _a;
    (_a = asyncIterableIterator.return) === null || _a === void 0 ? void 0 : _a.call(asyncIterableIterator);
  };
}
function isAsyncIterable(input) {
  return typeof input === "object" && input !== null && (
  // The AsyncGenerator check is for Safari on iOS which currently does not have
  // Symbol.asyncIterator implemented
  // That means every custom AsyncIterable must be built using a AsyncGeneratorFunction (async function * () {})
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  input[Symbol.toStringTag] === "AsyncGenerator" || Symbol.asyncIterator && Symbol.asyncIterator in input);
}
exports.applyAsyncIterableIteratorToSink = applyAsyncIterableIteratorToSink;
exports.isAsyncIterable = isAsyncIterable;
exports.makeAsyncIterableIteratorFromSink = makeAsyncIterableIteratorFromSink;
exports.makePushPullAsyncIterableIterator = makePushPullAsyncIterableIterator;

/***/ }),

/***/ "../../../node_modules/@radix-ui/primitive/dist/index.js":
/*!***************************************************************!*\
  !*** ../../../node_modules/@radix-ui/primitive/dist/index.js ***!
  \***************************************************************/
/***/ (function(module) {



function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "composeEventHandlers", () => $1a6a90a521dcd173$export$b9ecd428b558ff10);
function $1a6a90a521dcd173$export$b9ecd428b558ff10(originalEventHandler, ourEventHandler, {
  checkForDefaultPrevented = true
} = {}) {
  return function handleEvent(event) {
    originalEventHandler === null || originalEventHandler === void 0 || originalEventHandler(event);
    if (checkForDefaultPrevented === false || !event.defaultPrevented) return ourEventHandler === null || ourEventHandler === void 0 ? void 0 : ourEventHandler(event);
  };
}

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-arrow/dist/index.js":
/*!*****************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-arrow/dist/index.js ***!
  \*****************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $eQpDd$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $eQpDd$react = __webpack_require__(/*! react */ "react");
var $eQpDd$radixuireactprimitive = __webpack_require__(/*! @radix-ui/react-primitive */ "../../../node_modules/@radix-ui/react-primitive/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "Arrow", () => $09f4ad68a9251bc3$export$21b07c8f274aebd5);
$parcel$export(module.exports, "Root", () => $09f4ad68a9251bc3$export$be92b6f5f03c0fe9);

/* -------------------------------------------------------------------------------------------------
 * Arrow
 * -----------------------------------------------------------------------------------------------*/
const $09f4ad68a9251bc3$var$NAME = 'Arrow';
const $09f4ad68a9251bc3$export$21b07c8f274aebd5 = /*#__PURE__*/$eQpDd$react.forwardRef((props, forwardedRef) => {
  const {
    children: children,
    width = 10,
    height = 5,
    ...arrowProps
  } = props;
  return /*#__PURE__*/$eQpDd$react.createElement($eQpDd$radixuireactprimitive.Primitive.svg, $parcel$interopDefault($eQpDd$babelruntimehelpersextends)({}, arrowProps, {
    ref: forwardedRef,
    width: width,
    height: height,
    viewBox: "0 0 30 10",
    preserveAspectRatio: "none"
  }), props.asChild ? children : /*#__PURE__*/$eQpDd$react.createElement("polygon", {
    points: "0,0 30,0 15,10"
  }));
});
/*#__PURE__*/
Object.assign($09f4ad68a9251bc3$export$21b07c8f274aebd5, {
  displayName: $09f4ad68a9251bc3$var$NAME
});
/* -----------------------------------------------------------------------------------------------*/
const $09f4ad68a9251bc3$export$be92b6f5f03c0fe9 = $09f4ad68a9251bc3$export$21b07c8f274aebd5;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-collection/dist/index.js":
/*!**********************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-collection/dist/index.js ***!
  \**********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $hnlpS$react = __webpack_require__(/*! react */ "react");
var $hnlpS$radixuireactcontext = __webpack_require__(/*! @radix-ui/react-context */ "../../../node_modules/@radix-ui/react-context/dist/index.js");
var $hnlpS$radixuireactcomposerefs = __webpack_require__(/*! @radix-ui/react-compose-refs */ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js");
var $hnlpS$radixuireactslot = __webpack_require__(/*! @radix-ui/react-slot */ "../../../node_modules/@radix-ui/react-slot/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "createCollection", () => $1a96635ec239608b$export$c74125a8e3af6bb2);

// We have resorted to returning slots directly rather than exposing primitives that can then
// be slotted like `<CollectionItem as={Slot}>…</CollectionItem>`.
// This is because we encountered issues with generic types that cannot be statically analysed
// due to creating them dynamically via createCollection.
function $1a96635ec239608b$export$c74125a8e3af6bb2(name) {
  /* -----------------------------------------------------------------------------------------------
  * CollectionProvider
  * ---------------------------------------------------------------------------------------------*/
  const PROVIDER_NAME = name + 'CollectionProvider';
  const [createCollectionContext, createCollectionScope] = $hnlpS$radixuireactcontext.createContextScope(PROVIDER_NAME);
  const [CollectionProviderImpl, useCollectionContext] = createCollectionContext(PROVIDER_NAME, {
    collectionRef: {
      current: null
    },
    itemMap: new Map()
  });
  const CollectionProvider = props => {
    const {
      scope: scope,
      children: children
    } = props;
    const ref = $parcel$interopDefault($hnlpS$react).useRef(null);
    const itemMap = $parcel$interopDefault($hnlpS$react).useRef(new Map()).current;
    return /*#__PURE__*/$parcel$interopDefault($hnlpS$react).createElement(CollectionProviderImpl, {
      scope: scope,
      itemMap: itemMap,
      collectionRef: ref
    }, children);
  };
  /*#__PURE__*/
  Object.assign(CollectionProvider, {
    displayName: PROVIDER_NAME
  });
  /* -----------------------------------------------------------------------------------------------
  * CollectionSlot
  * ---------------------------------------------------------------------------------------------*/
  const COLLECTION_SLOT_NAME = name + 'CollectionSlot';
  const CollectionSlot = /*#__PURE__*/$parcel$interopDefault($hnlpS$react).forwardRef((props, forwardedRef) => {
    const {
      scope: scope,
      children: children
    } = props;
    const context = useCollectionContext(COLLECTION_SLOT_NAME, scope);
    const composedRefs = $hnlpS$radixuireactcomposerefs.useComposedRefs(forwardedRef, context.collectionRef);
    return /*#__PURE__*/$parcel$interopDefault($hnlpS$react).createElement($hnlpS$radixuireactslot.Slot, {
      ref: composedRefs
    }, children);
  });
  /*#__PURE__*/
  Object.assign(CollectionSlot, {
    displayName: COLLECTION_SLOT_NAME
  });
  /* -----------------------------------------------------------------------------------------------
  * CollectionItem
  * ---------------------------------------------------------------------------------------------*/
  const ITEM_SLOT_NAME = name + 'CollectionItemSlot';
  const ITEM_DATA_ATTR = 'data-radix-collection-item';
  const CollectionItemSlot = /*#__PURE__*/$parcel$interopDefault($hnlpS$react).forwardRef((props, forwardedRef) => {
    const {
      scope: scope,
      children: children,
      ...itemData
    } = props;
    const ref = $parcel$interopDefault($hnlpS$react).useRef(null);
    const composedRefs = $hnlpS$radixuireactcomposerefs.useComposedRefs(forwardedRef, ref);
    const context = useCollectionContext(ITEM_SLOT_NAME, scope);
    $parcel$interopDefault($hnlpS$react).useEffect(() => {
      context.itemMap.set(ref, {
        ref: ref,
        ...itemData
      });
      return () => void context.itemMap.delete(ref);
    });
    return /*#__PURE__*/$parcel$interopDefault($hnlpS$react).createElement($hnlpS$radixuireactslot.Slot, {
      [ITEM_DATA_ATTR]: '',
      ref: composedRefs
    }, children);
  });
  /*#__PURE__*/
  Object.assign(CollectionItemSlot, {
    displayName: ITEM_SLOT_NAME
  });
  /* -----------------------------------------------------------------------------------------------
  * useCollection
  * ---------------------------------------------------------------------------------------------*/
  function useCollection(scope) {
    const context = useCollectionContext(name + 'CollectionConsumer', scope);
    const getItems = $parcel$interopDefault($hnlpS$react).useCallback(() => {
      const collectionNode = context.collectionRef.current;
      if (!collectionNode) return [];
      const orderedNodes = Array.from(collectionNode.querySelectorAll(`[${ITEM_DATA_ATTR}]`));
      const items = Array.from(context.itemMap.values());
      const orderedItems = items.sort((a, b) => orderedNodes.indexOf(a.ref.current) - orderedNodes.indexOf(b.ref.current));
      return orderedItems;
    }, [context.collectionRef, context.itemMap]);
    return getItems;
  }
  return [{
    Provider: CollectionProvider,
    Slot: CollectionSlot,
    ItemSlot: CollectionItemSlot
  }, useCollection, createCollectionScope];
}

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js":
/*!************************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-compose-refs/dist/index.js ***!
  \************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $dJwbH$react = __webpack_require__(/*! react */ "react");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "composeRefs", () => $9c2aaba23466b352$export$43e446d32b3d21af);
$parcel$export(module.exports, "useComposedRefs", () => $9c2aaba23466b352$export$c7b2cbe3552a0d05);

/**
 * Set a given ref to a given value
 * This utility takes care of different types of refs: callback refs and RefObject(s)
 */
function $9c2aaba23466b352$var$setRef(ref, value) {
  if (typeof ref === 'function') ref(value);else if (ref !== null && ref !== undefined) ref.current = value;
}
/**
 * A utility to compose multiple refs together
 * Accepts callback refs and RefObject(s)
 */
function $9c2aaba23466b352$export$43e446d32b3d21af(...refs) {
  return node => refs.forEach(ref => $9c2aaba23466b352$var$setRef(ref, node));
}
/**
 * A custom hook that composes multiple refs
 * Accepts callback refs and RefObject(s)
 */
function $9c2aaba23466b352$export$c7b2cbe3552a0d05(...refs) {
  // eslint-disable-next-line react-hooks/exhaustive-deps
  return $dJwbH$react.useCallback($9c2aaba23466b352$export$43e446d32b3d21af(...refs), refs);
}

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-context/dist/index.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-context/dist/index.js ***!
  \*******************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $4O1Ne$react = __webpack_require__(/*! react */ "react");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "createContext", () => $dec3cc0142d4f286$export$fd42f52fd3ae1109);
$parcel$export(module.exports, "createContextScope", () => $dec3cc0142d4f286$export$50c7b4e9d9f19c1);
function $dec3cc0142d4f286$export$fd42f52fd3ae1109(rootComponentName, defaultContext) {
  const Context = /*#__PURE__*/$4O1Ne$react.createContext(defaultContext);
  function Provider(props) {
    const {
      children: children,
      ...context
    } = props; // Only re-memoize when prop values change
    // eslint-disable-next-line react-hooks/exhaustive-deps
    const value = $4O1Ne$react.useMemo(() => context, Object.values(context));
    return /*#__PURE__*/$4O1Ne$react.createElement(Context.Provider, {
      value: value
    }, children);
  }
  function useContext(consumerName) {
    const context = $4O1Ne$react.useContext(Context);
    if (context) return context;
    if (defaultContext !== undefined) return defaultContext; // if a defaultContext wasn't specified, it's a required context.
    throw new Error(`\`${consumerName}\` must be used within \`${rootComponentName}\``);
  }
  Provider.displayName = rootComponentName + 'Provider';
  return [Provider, useContext];
}
/* -------------------------------------------------------------------------------------------------
 * createContextScope
 * -----------------------------------------------------------------------------------------------*/
function $dec3cc0142d4f286$export$50c7b4e9d9f19c1(scopeName, createContextScopeDeps = []) {
  let defaultContexts = [];
  /* -----------------------------------------------------------------------------------------------
  * createContext
  * ---------------------------------------------------------------------------------------------*/
  function $dec3cc0142d4f286$export$fd42f52fd3ae1109(rootComponentName, defaultContext) {
    const BaseContext = /*#__PURE__*/$4O1Ne$react.createContext(defaultContext);
    const index = defaultContexts.length;
    defaultContexts = [...defaultContexts, defaultContext];
    function Provider(props) {
      const {
        scope: scope,
        children: children,
        ...context
      } = props;
      const Context = (scope === null || scope === void 0 ? void 0 : scope[scopeName][index]) || BaseContext; // Only re-memoize when prop values change
      // eslint-disable-next-line react-hooks/exhaustive-deps
      const value = $4O1Ne$react.useMemo(() => context, Object.values(context));
      return /*#__PURE__*/$4O1Ne$react.createElement(Context.Provider, {
        value: value
      }, children);
    }
    function useContext(consumerName, scope) {
      const Context = (scope === null || scope === void 0 ? void 0 : scope[scopeName][index]) || BaseContext;
      const context = $4O1Ne$react.useContext(Context);
      if (context) return context;
      if (defaultContext !== undefined) return defaultContext; // if a defaultContext wasn't specified, it's a required context.
      throw new Error(`\`${consumerName}\` must be used within \`${rootComponentName}\``);
    }
    Provider.displayName = rootComponentName + 'Provider';
    return [Provider, useContext];
  }
  /* -----------------------------------------------------------------------------------------------
  * createScope
  * ---------------------------------------------------------------------------------------------*/
  const createScope = () => {
    const scopeContexts = defaultContexts.map(defaultContext => {
      return /*#__PURE__*/$4O1Ne$react.createContext(defaultContext);
    });
    return function useScope(scope) {
      const contexts = (scope === null || scope === void 0 ? void 0 : scope[scopeName]) || scopeContexts;
      return $4O1Ne$react.useMemo(() => ({
        [`__scope${scopeName}`]: {
          ...scope,
          [scopeName]: contexts
        }
      }), [scope, contexts]);
    };
  };
  createScope.scopeName = scopeName;
  return [$dec3cc0142d4f286$export$fd42f52fd3ae1109, $dec3cc0142d4f286$var$composeContextScopes(createScope, ...createContextScopeDeps)];
}
/* -------------------------------------------------------------------------------------------------
 * composeContextScopes
 * -----------------------------------------------------------------------------------------------*/
function $dec3cc0142d4f286$var$composeContextScopes(...scopes) {
  const baseScope = scopes[0];
  if (scopes.length === 1) return baseScope;
  const createScope1 = () => {
    const scopeHooks = scopes.map(createScope => ({
      useScope: createScope(),
      scopeName: createScope.scopeName
    }));
    return function useComposedScopes(overrideScopes) {
      const nextScopes1 = scopeHooks.reduce((nextScopes, {
        useScope: useScope,
        scopeName: scopeName
      }) => {
        // We are calling a hook inside a callback which React warns against to avoid inconsistent
        // renders, however, scoping doesn't have render side effects so we ignore the rule.
        // eslint-disable-next-line react-hooks/rules-of-hooks
        const scopeProps = useScope(overrideScopes);
        const currentScope = scopeProps[`__scope${scopeName}`];
        return {
          ...nextScopes,
          ...currentScope
        };
      }, {});
      return $4O1Ne$react.useMemo(() => ({
        [`__scope${baseScope.scopeName}`]: nextScopes1
      }), [nextScopes1]);
    };
  };
  createScope1.scopeName = baseScope.scopeName;
  return createScope1;
}

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-dialog/dist/index.js":
/*!******************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-dialog/dist/index.js ***!
  \******************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $aJCrN$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $aJCrN$react = __webpack_require__(/*! react */ "react");
var $aJCrN$radixuiprimitive = __webpack_require__(/*! @radix-ui/primitive */ "../../../node_modules/@radix-ui/primitive/dist/index.js");
var $aJCrN$radixuireactcomposerefs = __webpack_require__(/*! @radix-ui/react-compose-refs */ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js");
var $aJCrN$radixuireactcontext = __webpack_require__(/*! @radix-ui/react-context */ "../../../node_modules/@radix-ui/react-context/dist/index.js");
var $aJCrN$radixuireactid = __webpack_require__(/*! @radix-ui/react-id */ "../../../node_modules/@radix-ui/react-id/dist/index.js");
var $aJCrN$radixuireactusecontrollablestate = __webpack_require__(/*! @radix-ui/react-use-controllable-state */ "../../../node_modules/@radix-ui/react-use-controllable-state/dist/index.js");
var $aJCrN$radixuireactdismissablelayer = __webpack_require__(/*! @radix-ui/react-dismissable-layer */ "../../../node_modules/@radix-ui/react-dismissable-layer/dist/index.js");
var $aJCrN$radixuireactfocusscope = __webpack_require__(/*! @radix-ui/react-focus-scope */ "../../../node_modules/@radix-ui/react-focus-scope/dist/index.js");
var $aJCrN$radixuireactportal = __webpack_require__(/*! @radix-ui/react-portal */ "../../../node_modules/@radix-ui/react-portal/dist/index.js");
var $aJCrN$radixuireactpresence = __webpack_require__(/*! @radix-ui/react-presence */ "../../../node_modules/@radix-ui/react-presence/dist/index.js");
var $aJCrN$radixuireactprimitive = __webpack_require__(/*! @radix-ui/react-primitive */ "../../../node_modules/@radix-ui/react-primitive/dist/index.js");
var $aJCrN$radixuireactfocusguards = __webpack_require__(/*! @radix-ui/react-focus-guards */ "../../../node_modules/@radix-ui/react-focus-guards/dist/index.js");
var $aJCrN$reactremovescroll = __webpack_require__(/*! react-remove-scroll */ "../../../node_modules/react-remove-scroll/dist/es2015/index.js");
var $aJCrN$ariahidden = __webpack_require__(/*! aria-hidden */ "../../../node_modules/aria-hidden/dist/es2015/index.js");
var $aJCrN$radixuireactslot = __webpack_require__(/*! @radix-ui/react-slot */ "../../../node_modules/@radix-ui/react-slot/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "createDialogScope", () => $f4833395aa1bca1a$export$cc702773b8ea3e41);
$parcel$export(module.exports, "Dialog", () => $f4833395aa1bca1a$export$3ddf2d174ce01153);
$parcel$export(module.exports, "DialogTrigger", () => $f4833395aa1bca1a$export$2e1e1122cf0cba88);
$parcel$export(module.exports, "DialogPortal", () => $f4833395aa1bca1a$export$dad7c95542bacce0);
$parcel$export(module.exports, "DialogOverlay", () => $f4833395aa1bca1a$export$bd1d06c79be19e17);
$parcel$export(module.exports, "DialogContent", () => $f4833395aa1bca1a$export$b6d9565de1e068cf);
$parcel$export(module.exports, "DialogTitle", () => $f4833395aa1bca1a$export$16f7638e4a34b909);
$parcel$export(module.exports, "DialogDescription", () => $f4833395aa1bca1a$export$94e94c2ec2c954d5);
$parcel$export(module.exports, "DialogClose", () => $f4833395aa1bca1a$export$fba2fb7cd781b7ac);
$parcel$export(module.exports, "Root", () => $f4833395aa1bca1a$export$be92b6f5f03c0fe9);
$parcel$export(module.exports, "Trigger", () => $f4833395aa1bca1a$export$41fb9f06171c75f4);
$parcel$export(module.exports, "Portal", () => $f4833395aa1bca1a$export$602eac185826482c);
$parcel$export(module.exports, "Overlay", () => $f4833395aa1bca1a$export$c6fdb837b070b4ff);
$parcel$export(module.exports, "Content", () => $f4833395aa1bca1a$export$7c6e2c02157bb7d2);
$parcel$export(module.exports, "Title", () => $f4833395aa1bca1a$export$f99233281efd08a0);
$parcel$export(module.exports, "Description", () => $f4833395aa1bca1a$export$393edc798c47379d);
$parcel$export(module.exports, "Close", () => $f4833395aa1bca1a$export$f39c2d165cd861fe);
$parcel$export(module.exports, "WarningProvider", () => $f4833395aa1bca1a$export$69b62a49393917d6);

/* -------------------------------------------------------------------------------------------------
 * Dialog
 * -----------------------------------------------------------------------------------------------*/
const $f4833395aa1bca1a$var$DIALOG_NAME = 'Dialog';
const [$f4833395aa1bca1a$var$createDialogContext, $f4833395aa1bca1a$export$cc702773b8ea3e41] = $aJCrN$radixuireactcontext.createContextScope($f4833395aa1bca1a$var$DIALOG_NAME);
const [$f4833395aa1bca1a$var$DialogProvider, $f4833395aa1bca1a$var$useDialogContext] = $f4833395aa1bca1a$var$createDialogContext($f4833395aa1bca1a$var$DIALOG_NAME);
const $f4833395aa1bca1a$export$3ddf2d174ce01153 = props => {
  const {
    __scopeDialog: __scopeDialog,
    children: children,
    open: openProp,
    defaultOpen: defaultOpen,
    onOpenChange: onOpenChange,
    modal = true
  } = props;
  const triggerRef = $aJCrN$react.useRef(null);
  const contentRef = $aJCrN$react.useRef(null);
  const [open = false, setOpen] = $aJCrN$radixuireactusecontrollablestate.useControllableState({
    prop: openProp,
    defaultProp: defaultOpen,
    onChange: onOpenChange
  });
  return /*#__PURE__*/$aJCrN$react.createElement($f4833395aa1bca1a$var$DialogProvider, {
    scope: __scopeDialog,
    triggerRef: triggerRef,
    contentRef: contentRef,
    contentId: $aJCrN$radixuireactid.useId(),
    titleId: $aJCrN$radixuireactid.useId(),
    descriptionId: $aJCrN$radixuireactid.useId(),
    open: open,
    onOpenChange: setOpen,
    onOpenToggle: $aJCrN$react.useCallback(() => setOpen(prevOpen => !prevOpen), [setOpen]),
    modal: modal
  }, children);
};
/*#__PURE__*/
Object.assign($f4833395aa1bca1a$export$3ddf2d174ce01153, {
  displayName: $f4833395aa1bca1a$var$DIALOG_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DialogTrigger
 * -----------------------------------------------------------------------------------------------*/
const $f4833395aa1bca1a$var$TRIGGER_NAME = 'DialogTrigger';
const $f4833395aa1bca1a$export$2e1e1122cf0cba88 = /*#__PURE__*/$aJCrN$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDialog: __scopeDialog,
    ...triggerProps
  } = props;
  const context = $f4833395aa1bca1a$var$useDialogContext($f4833395aa1bca1a$var$TRIGGER_NAME, __scopeDialog);
  const composedTriggerRef = $aJCrN$radixuireactcomposerefs.useComposedRefs(forwardedRef, context.triggerRef);
  return /*#__PURE__*/$aJCrN$react.createElement($aJCrN$radixuireactprimitive.Primitive.button, $parcel$interopDefault($aJCrN$babelruntimehelpersextends)({
    type: "button",
    "aria-haspopup": "dialog",
    "aria-expanded": context.open,
    "aria-controls": context.contentId,
    "data-state": $f4833395aa1bca1a$var$getState(context.open)
  }, triggerProps, {
    ref: composedTriggerRef,
    onClick: $aJCrN$radixuiprimitive.composeEventHandlers(props.onClick, context.onOpenToggle)
  }));
});
/*#__PURE__*/
Object.assign($f4833395aa1bca1a$export$2e1e1122cf0cba88, {
  displayName: $f4833395aa1bca1a$var$TRIGGER_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DialogPortal
 * -----------------------------------------------------------------------------------------------*/
const $f4833395aa1bca1a$var$PORTAL_NAME = 'DialogPortal';
const [$f4833395aa1bca1a$var$PortalProvider, $f4833395aa1bca1a$var$usePortalContext] = $f4833395aa1bca1a$var$createDialogContext($f4833395aa1bca1a$var$PORTAL_NAME, {
  forceMount: undefined
});
const $f4833395aa1bca1a$export$dad7c95542bacce0 = props => {
  const {
    __scopeDialog: __scopeDialog,
    forceMount: forceMount,
    children: children,
    container: container
  } = props;
  const context = $f4833395aa1bca1a$var$useDialogContext($f4833395aa1bca1a$var$PORTAL_NAME, __scopeDialog);
  return /*#__PURE__*/$aJCrN$react.createElement($f4833395aa1bca1a$var$PortalProvider, {
    scope: __scopeDialog,
    forceMount: forceMount
  }, $aJCrN$react.Children.map(children, child => /*#__PURE__*/$aJCrN$react.createElement($aJCrN$radixuireactpresence.Presence, {
    present: forceMount || context.open
  }, /*#__PURE__*/$aJCrN$react.createElement($aJCrN$radixuireactportal.Portal, {
    asChild: true,
    container: container
  }, child))));
};
/*#__PURE__*/
Object.assign($f4833395aa1bca1a$export$dad7c95542bacce0, {
  displayName: $f4833395aa1bca1a$var$PORTAL_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DialogOverlay
 * -----------------------------------------------------------------------------------------------*/
const $f4833395aa1bca1a$var$OVERLAY_NAME = 'DialogOverlay';
const $f4833395aa1bca1a$export$bd1d06c79be19e17 = /*#__PURE__*/$aJCrN$react.forwardRef((props, forwardedRef) => {
  const portalContext = $f4833395aa1bca1a$var$usePortalContext($f4833395aa1bca1a$var$OVERLAY_NAME, props.__scopeDialog);
  const {
    forceMount = portalContext.forceMount,
    ...overlayProps
  } = props;
  const context = $f4833395aa1bca1a$var$useDialogContext($f4833395aa1bca1a$var$OVERLAY_NAME, props.__scopeDialog);
  return context.modal ? /*#__PURE__*/$aJCrN$react.createElement($aJCrN$radixuireactpresence.Presence, {
    present: forceMount || context.open
  }, /*#__PURE__*/$aJCrN$react.createElement($f4833395aa1bca1a$var$DialogOverlayImpl, $parcel$interopDefault($aJCrN$babelruntimehelpersextends)({}, overlayProps, {
    ref: forwardedRef
  }))) : null;
});
/*#__PURE__*/
Object.assign($f4833395aa1bca1a$export$bd1d06c79be19e17, {
  displayName: $f4833395aa1bca1a$var$OVERLAY_NAME
});
const $f4833395aa1bca1a$var$DialogOverlayImpl = /*#__PURE__*/$aJCrN$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDialog: __scopeDialog,
    ...overlayProps
  } = props;
  const context = $f4833395aa1bca1a$var$useDialogContext($f4833395aa1bca1a$var$OVERLAY_NAME, __scopeDialog);
  return /*#__PURE__*/ (// Make sure `Content` is scrollable even when it doesn't live inside `RemoveScroll`
    // ie. when `Overlay` and `Content` are siblings
    $aJCrN$react.createElement($aJCrN$reactremovescroll.RemoveScroll, {
      as: $aJCrN$radixuireactslot.Slot,
      allowPinchZoom: true,
      shards: [context.contentRef]
    }, /*#__PURE__*/$aJCrN$react.createElement($aJCrN$radixuireactprimitive.Primitive.div, $parcel$interopDefault($aJCrN$babelruntimehelpersextends)({
      "data-state": $f4833395aa1bca1a$var$getState(context.open)
    }, overlayProps, {
      ref: forwardedRef // We re-enable pointer-events prevented by `Dialog.Content` to allow scrolling the overlay.
      ,

      style: {
        pointerEvents: 'auto',
        ...overlayProps.style
      }
    })))
  );
});
/* -------------------------------------------------------------------------------------------------
 * DialogContent
 * -----------------------------------------------------------------------------------------------*/
const $f4833395aa1bca1a$var$CONTENT_NAME = 'DialogContent';
const $f4833395aa1bca1a$export$b6d9565de1e068cf = /*#__PURE__*/$aJCrN$react.forwardRef((props, forwardedRef) => {
  const portalContext = $f4833395aa1bca1a$var$usePortalContext($f4833395aa1bca1a$var$CONTENT_NAME, props.__scopeDialog);
  const {
    forceMount = portalContext.forceMount,
    ...contentProps
  } = props;
  const context = $f4833395aa1bca1a$var$useDialogContext($f4833395aa1bca1a$var$CONTENT_NAME, props.__scopeDialog);
  return /*#__PURE__*/$aJCrN$react.createElement($aJCrN$radixuireactpresence.Presence, {
    present: forceMount || context.open
  }, context.modal ? /*#__PURE__*/$aJCrN$react.createElement($f4833395aa1bca1a$var$DialogContentModal, $parcel$interopDefault($aJCrN$babelruntimehelpersextends)({}, contentProps, {
    ref: forwardedRef
  })) : /*#__PURE__*/$aJCrN$react.createElement($f4833395aa1bca1a$var$DialogContentNonModal, $parcel$interopDefault($aJCrN$babelruntimehelpersextends)({}, contentProps, {
    ref: forwardedRef
  })));
});
/*#__PURE__*/
Object.assign($f4833395aa1bca1a$export$b6d9565de1e068cf, {
  displayName: $f4833395aa1bca1a$var$CONTENT_NAME
});
/* -----------------------------------------------------------------------------------------------*/
const $f4833395aa1bca1a$var$DialogContentModal = /*#__PURE__*/$aJCrN$react.forwardRef((props, forwardedRef) => {
  const context = $f4833395aa1bca1a$var$useDialogContext($f4833395aa1bca1a$var$CONTENT_NAME, props.__scopeDialog);
  const contentRef = $aJCrN$react.useRef(null);
  const composedRefs = $aJCrN$radixuireactcomposerefs.useComposedRefs(forwardedRef, context.contentRef, contentRef); // aria-hide everything except the content (better supported equivalent to setting aria-modal)
  $aJCrN$react.useEffect(() => {
    const content = contentRef.current;
    if (content) return $aJCrN$ariahidden.hideOthers(content);
  }, []);
  return /*#__PURE__*/$aJCrN$react.createElement($f4833395aa1bca1a$var$DialogContentImpl, $parcel$interopDefault($aJCrN$babelruntimehelpersextends)({}, props, {
    ref: composedRefs // we make sure focus isn't trapped once `DialogContent` has been closed
    ,

    trapFocus: context.open,
    disableOutsidePointerEvents: true,
    onCloseAutoFocus: $aJCrN$radixuiprimitive.composeEventHandlers(props.onCloseAutoFocus, event => {
      var _context$triggerRef$c;
      event.preventDefault();
      (_context$triggerRef$c = context.triggerRef.current) === null || _context$triggerRef$c === void 0 || _context$triggerRef$c.focus();
    }),
    onPointerDownOutside: $aJCrN$radixuiprimitive.composeEventHandlers(props.onPointerDownOutside, event => {
      const originalEvent = event.detail.originalEvent;
      const ctrlLeftClick = originalEvent.button === 0 && originalEvent.ctrlKey === true;
      const isRightClick = originalEvent.button === 2 || ctrlLeftClick; // If the event is a right-click, we shouldn't close because
      // it is effectively as if we right-clicked the `Overlay`.
      if (isRightClick) event.preventDefault();
    }) // When focus is trapped, a `focusout` event may still happen.
    ,

    onFocusOutside: $aJCrN$radixuiprimitive.composeEventHandlers(props.onFocusOutside, event => event.preventDefault())
  }));
});
/* -----------------------------------------------------------------------------------------------*/
const $f4833395aa1bca1a$var$DialogContentNonModal = /*#__PURE__*/$aJCrN$react.forwardRef((props, forwardedRef) => {
  const context = $f4833395aa1bca1a$var$useDialogContext($f4833395aa1bca1a$var$CONTENT_NAME, props.__scopeDialog);
  const hasInteractedOutsideRef = $aJCrN$react.useRef(false);
  const hasPointerDownOutsideRef = $aJCrN$react.useRef(false);
  return /*#__PURE__*/$aJCrN$react.createElement($f4833395aa1bca1a$var$DialogContentImpl, $parcel$interopDefault($aJCrN$babelruntimehelpersextends)({}, props, {
    ref: forwardedRef,
    trapFocus: false,
    disableOutsidePointerEvents: false,
    onCloseAutoFocus: event => {
      var _props$onCloseAutoFoc;
      (_props$onCloseAutoFoc = props.onCloseAutoFocus) === null || _props$onCloseAutoFoc === void 0 || _props$onCloseAutoFoc.call(props, event);
      if (!event.defaultPrevented) {
        var _context$triggerRef$c2;
        if (!hasInteractedOutsideRef.current) (_context$triggerRef$c2 = context.triggerRef.current) === null || _context$triggerRef$c2 === void 0 || _context$triggerRef$c2.focus(); // Always prevent auto focus because we either focus manually or want user agent focus
        event.preventDefault();
      }
      hasInteractedOutsideRef.current = false;
      hasPointerDownOutsideRef.current = false;
    },
    onInteractOutside: event => {
      var _props$onInteractOuts, _context$triggerRef$c3;
      (_props$onInteractOuts = props.onInteractOutside) === null || _props$onInteractOuts === void 0 || _props$onInteractOuts.call(props, event);
      if (!event.defaultPrevented) {
        hasInteractedOutsideRef.current = true;
        if (event.detail.originalEvent.type === 'pointerdown') hasPointerDownOutsideRef.current = true;
      } // Prevent dismissing when clicking the trigger.
      // As the trigger is already setup to close, without doing so would
      // cause it to close and immediately open.
      const target = event.target;
      const targetIsTrigger = (_context$triggerRef$c3 = context.triggerRef.current) === null || _context$triggerRef$c3 === void 0 ? void 0 : _context$triggerRef$c3.contains(target);
      if (targetIsTrigger) event.preventDefault(); // On Safari if the trigger is inside a container with tabIndex={0}, when clicked
      // we will get the pointer down outside event on the trigger, but then a subsequent
      // focus outside event on the container, we ignore any focus outside event when we've
      // already had a pointer down outside event.
      if (event.detail.originalEvent.type === 'focusin' && hasPointerDownOutsideRef.current) event.preventDefault();
    }
  }));
});
/* -----------------------------------------------------------------------------------------------*/
const $f4833395aa1bca1a$var$DialogContentImpl = /*#__PURE__*/$aJCrN$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDialog: __scopeDialog,
    trapFocus: trapFocus,
    onOpenAutoFocus: onOpenAutoFocus,
    onCloseAutoFocus: onCloseAutoFocus,
    ...contentProps
  } = props;
  const context = $f4833395aa1bca1a$var$useDialogContext($f4833395aa1bca1a$var$CONTENT_NAME, __scopeDialog);
  const contentRef = $aJCrN$react.useRef(null);
  const composedRefs = $aJCrN$radixuireactcomposerefs.useComposedRefs(forwardedRef, contentRef); // Make sure the whole tree has focus guards as our `Dialog` will be
  // the last element in the DOM (beacuse of the `Portal`)
  $aJCrN$radixuireactfocusguards.useFocusGuards();
  return /*#__PURE__*/$aJCrN$react.createElement($aJCrN$react.Fragment, null, /*#__PURE__*/$aJCrN$react.createElement($aJCrN$radixuireactfocusscope.FocusScope, {
    asChild: true,
    loop: true,
    trapped: trapFocus,
    onMountAutoFocus: onOpenAutoFocus,
    onUnmountAutoFocus: onCloseAutoFocus
  }, /*#__PURE__*/$aJCrN$react.createElement($aJCrN$radixuireactdismissablelayer.DismissableLayer, $parcel$interopDefault($aJCrN$babelruntimehelpersextends)({
    role: "dialog",
    id: context.contentId,
    "aria-describedby": context.descriptionId,
    "aria-labelledby": context.titleId,
    "data-state": $f4833395aa1bca1a$var$getState(context.open)
  }, contentProps, {
    ref: composedRefs,
    onDismiss: () => context.onOpenChange(false)
  }))), false);
});
/* -------------------------------------------------------------------------------------------------
 * DialogTitle
 * -----------------------------------------------------------------------------------------------*/
const $f4833395aa1bca1a$var$TITLE_NAME = 'DialogTitle';
const $f4833395aa1bca1a$export$16f7638e4a34b909 = /*#__PURE__*/$aJCrN$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDialog: __scopeDialog,
    ...titleProps
  } = props;
  const context = $f4833395aa1bca1a$var$useDialogContext($f4833395aa1bca1a$var$TITLE_NAME, __scopeDialog);
  return /*#__PURE__*/$aJCrN$react.createElement($aJCrN$radixuireactprimitive.Primitive.h2, $parcel$interopDefault($aJCrN$babelruntimehelpersextends)({
    id: context.titleId
  }, titleProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($f4833395aa1bca1a$export$16f7638e4a34b909, {
  displayName: $f4833395aa1bca1a$var$TITLE_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DialogDescription
 * -----------------------------------------------------------------------------------------------*/
const $f4833395aa1bca1a$var$DESCRIPTION_NAME = 'DialogDescription';
const $f4833395aa1bca1a$export$94e94c2ec2c954d5 = /*#__PURE__*/$aJCrN$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDialog: __scopeDialog,
    ...descriptionProps
  } = props;
  const context = $f4833395aa1bca1a$var$useDialogContext($f4833395aa1bca1a$var$DESCRIPTION_NAME, __scopeDialog);
  return /*#__PURE__*/$aJCrN$react.createElement($aJCrN$radixuireactprimitive.Primitive.p, $parcel$interopDefault($aJCrN$babelruntimehelpersextends)({
    id: context.descriptionId
  }, descriptionProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($f4833395aa1bca1a$export$94e94c2ec2c954d5, {
  displayName: $f4833395aa1bca1a$var$DESCRIPTION_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DialogClose
 * -----------------------------------------------------------------------------------------------*/
const $f4833395aa1bca1a$var$CLOSE_NAME = 'DialogClose';
const $f4833395aa1bca1a$export$fba2fb7cd781b7ac = /*#__PURE__*/$aJCrN$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDialog: __scopeDialog,
    ...closeProps
  } = props;
  const context = $f4833395aa1bca1a$var$useDialogContext($f4833395aa1bca1a$var$CLOSE_NAME, __scopeDialog);
  return /*#__PURE__*/$aJCrN$react.createElement($aJCrN$radixuireactprimitive.Primitive.button, $parcel$interopDefault($aJCrN$babelruntimehelpersextends)({
    type: "button"
  }, closeProps, {
    ref: forwardedRef,
    onClick: $aJCrN$radixuiprimitive.composeEventHandlers(props.onClick, () => context.onOpenChange(false))
  }));
});
/*#__PURE__*/
Object.assign($f4833395aa1bca1a$export$fba2fb7cd781b7ac, {
  displayName: $f4833395aa1bca1a$var$CLOSE_NAME
});
/* -----------------------------------------------------------------------------------------------*/
function $f4833395aa1bca1a$var$getState(open) {
  return open ? 'open' : 'closed';
}
const $f4833395aa1bca1a$var$TITLE_WARNING_NAME = 'DialogTitleWarning';
const [$f4833395aa1bca1a$export$69b62a49393917d6, $f4833395aa1bca1a$var$useWarningContext] = $aJCrN$radixuireactcontext.createContext($f4833395aa1bca1a$var$TITLE_WARNING_NAME, {
  contentName: $f4833395aa1bca1a$var$CONTENT_NAME,
  titleName: $f4833395aa1bca1a$var$TITLE_NAME,
  docsSlug: 'dialog'
});
const $f4833395aa1bca1a$var$TitleWarning = ({
  titleId: titleId
}) => {
  const titleWarningContext = $f4833395aa1bca1a$var$useWarningContext($f4833395aa1bca1a$var$TITLE_WARNING_NAME);
  const MESSAGE = `\`${titleWarningContext.contentName}\` requires a \`${titleWarningContext.titleName}\` for the component to be accessible for screen reader users.

If you want to hide the \`${titleWarningContext.titleName}\`, you can wrap it with our VisuallyHidden component.

For more information, see https://radix-ui.com/primitives/docs/components/${titleWarningContext.docsSlug}`;
  $aJCrN$react.useEffect(() => {
    if (titleId) {
      const hasTitle = document.getElementById(titleId);
      if (!hasTitle) throw new Error(MESSAGE);
    }
  }, [MESSAGE, titleId]);
  return null;
};
const $f4833395aa1bca1a$var$DESCRIPTION_WARNING_NAME = 'DialogDescriptionWarning';
const $f4833395aa1bca1a$var$DescriptionWarning = ({
  contentRef: contentRef,
  descriptionId: descriptionId
}) => {
  const descriptionWarningContext = $f4833395aa1bca1a$var$useWarningContext($f4833395aa1bca1a$var$DESCRIPTION_WARNING_NAME);
  const MESSAGE = `Warning: Missing \`Description\` or \`aria-describedby={undefined}\` for {${descriptionWarningContext.contentName}}.`;
  $aJCrN$react.useEffect(() => {
    var _contentRef$current;
    const describedById = (_contentRef$current = contentRef.current) === null || _contentRef$current === void 0 ? void 0 : _contentRef$current.getAttribute('aria-describedby'); // if we have an id and the user hasn't set aria-describedby={undefined}
    if (descriptionId && describedById) {
      const hasDescription = document.getElementById(descriptionId);
      if (!hasDescription) console.warn(MESSAGE);
    }
  }, [MESSAGE, contentRef, descriptionId]);
  return null;
};
const $f4833395aa1bca1a$export$be92b6f5f03c0fe9 = $f4833395aa1bca1a$export$3ddf2d174ce01153;
const $f4833395aa1bca1a$export$41fb9f06171c75f4 = $f4833395aa1bca1a$export$2e1e1122cf0cba88;
const $f4833395aa1bca1a$export$602eac185826482c = $f4833395aa1bca1a$export$dad7c95542bacce0;
const $f4833395aa1bca1a$export$c6fdb837b070b4ff = $f4833395aa1bca1a$export$bd1d06c79be19e17;
const $f4833395aa1bca1a$export$7c6e2c02157bb7d2 = $f4833395aa1bca1a$export$b6d9565de1e068cf;
const $f4833395aa1bca1a$export$f99233281efd08a0 = $f4833395aa1bca1a$export$16f7638e4a34b909;
const $f4833395aa1bca1a$export$393edc798c47379d = $f4833395aa1bca1a$export$94e94c2ec2c954d5;
const $f4833395aa1bca1a$export$f39c2d165cd861fe = $f4833395aa1bca1a$export$fba2fb7cd781b7ac;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-direction/dist/index.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-direction/dist/index.js ***!
  \*********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $9g4ps$react = __webpack_require__(/*! react */ "react");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "useDirection", () => $cc45c1b701a63adc$export$b39126d51d94e6f3);
$parcel$export(module.exports, "Provider", () => $cc45c1b701a63adc$export$2881499e37b75b9a);
$parcel$export(module.exports, "DirectionProvider", () => $cc45c1b701a63adc$export$c760c09fdd558351);
const $cc45c1b701a63adc$var$DirectionContext = /*#__PURE__*/$9g4ps$react.createContext(undefined);
/* -------------------------------------------------------------------------------------------------
 * Direction
 * -----------------------------------------------------------------------------------------------*/
const $cc45c1b701a63adc$export$c760c09fdd558351 = props => {
  const {
    dir: dir,
    children: children
  } = props;
  return /*#__PURE__*/$9g4ps$react.createElement($cc45c1b701a63adc$var$DirectionContext.Provider, {
    value: dir
  }, children);
};
/* -----------------------------------------------------------------------------------------------*/
function $cc45c1b701a63adc$export$b39126d51d94e6f3(localDir) {
  const globalDir = $9g4ps$react.useContext($cc45c1b701a63adc$var$DirectionContext);
  return localDir || globalDir || 'ltr';
}
const $cc45c1b701a63adc$export$2881499e37b75b9a = $cc45c1b701a63adc$export$c760c09fdd558351;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-dismissable-layer/dist/index.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-dismissable-layer/dist/index.js ***!
  \*****************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $g2vWm$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $g2vWm$react = __webpack_require__(/*! react */ "react");
var $g2vWm$radixuiprimitive = __webpack_require__(/*! @radix-ui/primitive */ "../../../node_modules/@radix-ui/primitive/dist/index.js");
var $g2vWm$radixuireactprimitive = __webpack_require__(/*! @radix-ui/react-primitive */ "../../../node_modules/@radix-ui/react-primitive/dist/index.js");
var $g2vWm$radixuireactcomposerefs = __webpack_require__(/*! @radix-ui/react-compose-refs */ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js");
var $g2vWm$radixuireactusecallbackref = __webpack_require__(/*! @radix-ui/react-use-callback-ref */ "../../../node_modules/@radix-ui/react-use-callback-ref/dist/index.js");
var $g2vWm$radixuireactuseescapekeydown = __webpack_require__(/*! @radix-ui/react-use-escape-keydown */ "../../../node_modules/@radix-ui/react-use-escape-keydown/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "DismissableLayer", () => $d715e0554b679f1f$export$177fb62ff3ec1f22);
$parcel$export(module.exports, "DismissableLayerBranch", () => $d715e0554b679f1f$export$4d5eb2109db14228);
$parcel$export(module.exports, "Root", () => $d715e0554b679f1f$export$be92b6f5f03c0fe9);
$parcel$export(module.exports, "Branch", () => $d715e0554b679f1f$export$aecb2ddcb55c95be);

/* -------------------------------------------------------------------------------------------------
 * DismissableLayer
 * -----------------------------------------------------------------------------------------------*/
const $d715e0554b679f1f$var$DISMISSABLE_LAYER_NAME = 'DismissableLayer';
const $d715e0554b679f1f$var$CONTEXT_UPDATE = 'dismissableLayer.update';
const $d715e0554b679f1f$var$POINTER_DOWN_OUTSIDE = 'dismissableLayer.pointerDownOutside';
const $d715e0554b679f1f$var$FOCUS_OUTSIDE = 'dismissableLayer.focusOutside';
let $d715e0554b679f1f$var$originalBodyPointerEvents;
const $d715e0554b679f1f$var$DismissableLayerContext = /*#__PURE__*/$g2vWm$react.createContext({
  layers: new Set(),
  layersWithOutsidePointerEventsDisabled: new Set(),
  branches: new Set()
});
const $d715e0554b679f1f$export$177fb62ff3ec1f22 = /*#__PURE__*/$g2vWm$react.forwardRef((props, forwardedRef) => {
  var _node$ownerDocument;
  const {
    disableOutsidePointerEvents = false,
    onEscapeKeyDown: onEscapeKeyDown,
    onPointerDownOutside: onPointerDownOutside,
    onFocusOutside: onFocusOutside,
    onInteractOutside: onInteractOutside,
    onDismiss: onDismiss,
    ...layerProps
  } = props;
  const context = $g2vWm$react.useContext($d715e0554b679f1f$var$DismissableLayerContext);
  const [node1, setNode] = $g2vWm$react.useState(null);
  const ownerDocument = (_node$ownerDocument = node1 === null || node1 === void 0 ? void 0 : node1.ownerDocument) !== null && _node$ownerDocument !== void 0 ? _node$ownerDocument : globalThis === null || globalThis === void 0 ? void 0 : globalThis.document;
  const [, force] = $g2vWm$react.useState({});
  const composedRefs = $g2vWm$radixuireactcomposerefs.useComposedRefs(forwardedRef, node => setNode(node));
  const layers = Array.from(context.layers);
  const [highestLayerWithOutsidePointerEventsDisabled] = [...context.layersWithOutsidePointerEventsDisabled].slice(-1); // prettier-ignore
  const highestLayerWithOutsidePointerEventsDisabledIndex = layers.indexOf(highestLayerWithOutsidePointerEventsDisabled); // prettier-ignore
  const index = node1 ? layers.indexOf(node1) : -1;
  const isBodyPointerEventsDisabled = context.layersWithOutsidePointerEventsDisabled.size > 0;
  const isPointerEventsEnabled = index >= highestLayerWithOutsidePointerEventsDisabledIndex;
  const pointerDownOutside = $d715e0554b679f1f$var$usePointerDownOutside(event => {
    const target = event.target;
    const isPointerDownOnBranch = [...context.branches].some(branch => branch.contains(target));
    if (!isPointerEventsEnabled || isPointerDownOnBranch) return;
    onPointerDownOutside === null || onPointerDownOutside === void 0 || onPointerDownOutside(event);
    onInteractOutside === null || onInteractOutside === void 0 || onInteractOutside(event);
    if (!event.defaultPrevented) onDismiss === null || onDismiss === void 0 || onDismiss();
  }, ownerDocument);
  const focusOutside = $d715e0554b679f1f$var$useFocusOutside(event => {
    const target = event.target;
    const isFocusInBranch = [...context.branches].some(branch => branch.contains(target));
    if (isFocusInBranch) return;
    onFocusOutside === null || onFocusOutside === void 0 || onFocusOutside(event);
    onInteractOutside === null || onInteractOutside === void 0 || onInteractOutside(event);
    if (!event.defaultPrevented) onDismiss === null || onDismiss === void 0 || onDismiss();
  }, ownerDocument);
  $g2vWm$radixuireactuseescapekeydown.useEscapeKeydown(event => {
    const isHighestLayer = index === context.layers.size - 1;
    if (!isHighestLayer) return;
    onEscapeKeyDown === null || onEscapeKeyDown === void 0 || onEscapeKeyDown(event);
    if (!event.defaultPrevented && onDismiss) {
      event.preventDefault();
      onDismiss();
    }
  }, ownerDocument);
  $g2vWm$react.useEffect(() => {
    if (!node1) return;
    if (disableOutsidePointerEvents) {
      if (context.layersWithOutsidePointerEventsDisabled.size === 0) {
        $d715e0554b679f1f$var$originalBodyPointerEvents = ownerDocument.body.style.pointerEvents;
        ownerDocument.body.style.pointerEvents = 'none';
      }
      context.layersWithOutsidePointerEventsDisabled.add(node1);
    }
    context.layers.add(node1);
    $d715e0554b679f1f$var$dispatchUpdate();
    return () => {
      if (disableOutsidePointerEvents && context.layersWithOutsidePointerEventsDisabled.size === 1) ownerDocument.body.style.pointerEvents = $d715e0554b679f1f$var$originalBodyPointerEvents;
    };
  }, [node1, ownerDocument, disableOutsidePointerEvents, context]);
  /**
  * We purposefully prevent combining this effect with the `disableOutsidePointerEvents` effect
  * because a change to `disableOutsidePointerEvents` would remove this layer from the stack
  * and add it to the end again so the layering order wouldn't be _creation order_.
  * We only want them to be removed from context stacks when unmounted.
  */
  $g2vWm$react.useEffect(() => {
    return () => {
      if (!node1) return;
      context.layers.delete(node1);
      context.layersWithOutsidePointerEventsDisabled.delete(node1);
      $d715e0554b679f1f$var$dispatchUpdate();
    };
  }, [node1, context]);
  $g2vWm$react.useEffect(() => {
    const handleUpdate = () => force({});
    document.addEventListener($d715e0554b679f1f$var$CONTEXT_UPDATE, handleUpdate);
    return () => document.removeEventListener($d715e0554b679f1f$var$CONTEXT_UPDATE, handleUpdate);
  }, []);
  return /*#__PURE__*/$g2vWm$react.createElement($g2vWm$radixuireactprimitive.Primitive.div, $parcel$interopDefault($g2vWm$babelruntimehelpersextends)({}, layerProps, {
    ref: composedRefs,
    style: {
      pointerEvents: isBodyPointerEventsDisabled ? isPointerEventsEnabled ? 'auto' : 'none' : undefined,
      ...props.style
    },
    onFocusCapture: $g2vWm$radixuiprimitive.composeEventHandlers(props.onFocusCapture, focusOutside.onFocusCapture),
    onBlurCapture: $g2vWm$radixuiprimitive.composeEventHandlers(props.onBlurCapture, focusOutside.onBlurCapture),
    onPointerDownCapture: $g2vWm$radixuiprimitive.composeEventHandlers(props.onPointerDownCapture, pointerDownOutside.onPointerDownCapture)
  }));
});
/*#__PURE__*/
Object.assign($d715e0554b679f1f$export$177fb62ff3ec1f22, {
  displayName: $d715e0554b679f1f$var$DISMISSABLE_LAYER_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DismissableLayerBranch
 * -----------------------------------------------------------------------------------------------*/
const $d715e0554b679f1f$var$BRANCH_NAME = 'DismissableLayerBranch';
const $d715e0554b679f1f$export$4d5eb2109db14228 = /*#__PURE__*/$g2vWm$react.forwardRef((props, forwardedRef) => {
  const context = $g2vWm$react.useContext($d715e0554b679f1f$var$DismissableLayerContext);
  const ref = $g2vWm$react.useRef(null);
  const composedRefs = $g2vWm$radixuireactcomposerefs.useComposedRefs(forwardedRef, ref);
  $g2vWm$react.useEffect(() => {
    const node = ref.current;
    if (node) {
      context.branches.add(node);
      return () => {
        context.branches.delete(node);
      };
    }
  }, [context.branches]);
  return /*#__PURE__*/$g2vWm$react.createElement($g2vWm$radixuireactprimitive.Primitive.div, $parcel$interopDefault($g2vWm$babelruntimehelpersextends)({}, props, {
    ref: composedRefs
  }));
});
/*#__PURE__*/
Object.assign($d715e0554b679f1f$export$4d5eb2109db14228, {
  displayName: $d715e0554b679f1f$var$BRANCH_NAME
});
/* -----------------------------------------------------------------------------------------------*/ /**
                                                                                                     * Listens for `pointerdown` outside a react subtree. We use `pointerdown` rather than `pointerup`
                                                                                                     * to mimic layer dismissing behaviour present in OS.
                                                                                                     * Returns props to pass to the node we want to check for outside events.
                                                                                                     */
function $d715e0554b679f1f$var$usePointerDownOutside(onPointerDownOutside, ownerDocument = globalThis === null || globalThis === void 0 ? void 0 : globalThis.document) {
  const handlePointerDownOutside = $g2vWm$radixuireactusecallbackref.useCallbackRef(onPointerDownOutside);
  const isPointerInsideReactTreeRef = $g2vWm$react.useRef(false);
  const handleClickRef = $g2vWm$react.useRef(() => {});
  $g2vWm$react.useEffect(() => {
    const handlePointerDown = event => {
      if (event.target && !isPointerInsideReactTreeRef.current) {
        const eventDetail = {
          originalEvent: event
        };
        function handleAndDispatchPointerDownOutsideEvent() {
          $d715e0554b679f1f$var$handleAndDispatchCustomEvent($d715e0554b679f1f$var$POINTER_DOWN_OUTSIDE, handlePointerDownOutside, eventDetail, {
            discrete: true
          });
        }
        /**
        * On touch devices, we need to wait for a click event because browsers implement
        * a ~350ms delay between the time the user stops touching the display and when the
        * browser executres events. We need to ensure we don't reactivate pointer-events within
        * this timeframe otherwise the browser may execute events that should have been prevented.
        *
        * Additionally, this also lets us deal automatically with cancellations when a click event
        * isn't raised because the page was considered scrolled/drag-scrolled, long-pressed, etc.
        *
        * This is why we also continuously remove the previous listener, because we cannot be
        * certain that it was raised, and therefore cleaned-up.
        */
        if (event.pointerType === 'touch') {
          ownerDocument.removeEventListener('click', handleClickRef.current);
          handleClickRef.current = handleAndDispatchPointerDownOutsideEvent;
          ownerDocument.addEventListener('click', handleClickRef.current, {
            once: true
          });
        } else handleAndDispatchPointerDownOutsideEvent();
      }
      isPointerInsideReactTreeRef.current = false;
    };
    /**
    * if this hook executes in a component that mounts via a `pointerdown` event, the event
    * would bubble up to the document and trigger a `pointerDownOutside` event. We avoid
    * this by delaying the event listener registration on the document.
    * This is not React specific, but rather how the DOM works, ie:
    * ```
    * button.addEventListener('pointerdown', () => {
    *   console.log('I will log');
    *   document.addEventListener('pointerdown', () => {
    *     console.log('I will also log');
    *   })
    * });
    */
    const timerId = window.setTimeout(() => {
      ownerDocument.addEventListener('pointerdown', handlePointerDown);
    }, 0);
    return () => {
      window.clearTimeout(timerId);
      ownerDocument.removeEventListener('pointerdown', handlePointerDown);
      ownerDocument.removeEventListener('click', handleClickRef.current);
    };
  }, [ownerDocument, handlePointerDownOutside]);
  return {
    // ensures we check React component tree (not just DOM tree)
    onPointerDownCapture: () => isPointerInsideReactTreeRef.current = true
  };
}
/**
 * Listens for when focus happens outside a react subtree.
 * Returns props to pass to the root (node) of the subtree we want to check.
 */
function $d715e0554b679f1f$var$useFocusOutside(onFocusOutside, ownerDocument = globalThis === null || globalThis === void 0 ? void 0 : globalThis.document) {
  const handleFocusOutside = $g2vWm$radixuireactusecallbackref.useCallbackRef(onFocusOutside);
  const isFocusInsideReactTreeRef = $g2vWm$react.useRef(false);
  $g2vWm$react.useEffect(() => {
    const handleFocus = event => {
      if (event.target && !isFocusInsideReactTreeRef.current) {
        const eventDetail = {
          originalEvent: event
        };
        $d715e0554b679f1f$var$handleAndDispatchCustomEvent($d715e0554b679f1f$var$FOCUS_OUTSIDE, handleFocusOutside, eventDetail, {
          discrete: false
        });
      }
    };
    ownerDocument.addEventListener('focusin', handleFocus);
    return () => ownerDocument.removeEventListener('focusin', handleFocus);
  }, [ownerDocument, handleFocusOutside]);
  return {
    onFocusCapture: () => isFocusInsideReactTreeRef.current = true,
    onBlurCapture: () => isFocusInsideReactTreeRef.current = false
  };
}
function $d715e0554b679f1f$var$dispatchUpdate() {
  const event = new CustomEvent($d715e0554b679f1f$var$CONTEXT_UPDATE);
  document.dispatchEvent(event);
}
function $d715e0554b679f1f$var$handleAndDispatchCustomEvent(name, handler, detail, {
  discrete: discrete
}) {
  const target = detail.originalEvent.target;
  const event = new CustomEvent(name, {
    bubbles: false,
    cancelable: true,
    detail: detail
  });
  if (handler) target.addEventListener(name, handler, {
    once: true
  });
  if (discrete) $g2vWm$radixuireactprimitive.dispatchDiscreteCustomEvent(target, event);else target.dispatchEvent(event);
}
const $d715e0554b679f1f$export$be92b6f5f03c0fe9 = $d715e0554b679f1f$export$177fb62ff3ec1f22;
const $d715e0554b679f1f$export$aecb2ddcb55c95be = $d715e0554b679f1f$export$4d5eb2109db14228;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-dropdown-menu/dist/index.js":
/*!*************************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-dropdown-menu/dist/index.js ***!
  \*************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $7dQ7Q$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $7dQ7Q$react = __webpack_require__(/*! react */ "react");
var $7dQ7Q$radixuiprimitive = __webpack_require__(/*! @radix-ui/primitive */ "../../../node_modules/@radix-ui/primitive/dist/index.js");
var $7dQ7Q$radixuireactcomposerefs = __webpack_require__(/*! @radix-ui/react-compose-refs */ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js");
var $7dQ7Q$radixuireactcontext = __webpack_require__(/*! @radix-ui/react-context */ "../../../node_modules/@radix-ui/react-context/dist/index.js");
var $7dQ7Q$radixuireactusecontrollablestate = __webpack_require__(/*! @radix-ui/react-use-controllable-state */ "../../../node_modules/@radix-ui/react-use-controllable-state/dist/index.js");
var $7dQ7Q$radixuireactprimitive = __webpack_require__(/*! @radix-ui/react-primitive */ "../../../node_modules/@radix-ui/react-primitive/dist/index.js");
var $7dQ7Q$radixuireactmenu = __webpack_require__(/*! @radix-ui/react-menu */ "../../../node_modules/@radix-ui/react-menu/dist/index.js");
var $7dQ7Q$radixuireactid = __webpack_require__(/*! @radix-ui/react-id */ "../../../node_modules/@radix-ui/react-id/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "createDropdownMenuScope", () => $d1bf075a6b218014$export$c0623cd925aeb687);
$parcel$export(module.exports, "DropdownMenu", () => $d1bf075a6b218014$export$e44a253a59704894);
$parcel$export(module.exports, "DropdownMenuTrigger", () => $d1bf075a6b218014$export$d2469213b3befba9);
$parcel$export(module.exports, "DropdownMenuPortal", () => $d1bf075a6b218014$export$cd369b4d4d54efc9);
$parcel$export(module.exports, "DropdownMenuContent", () => $d1bf075a6b218014$export$6e76d93a37c01248);
$parcel$export(module.exports, "DropdownMenuGroup", () => $d1bf075a6b218014$export$246bebaba3a2f70e);
$parcel$export(module.exports, "DropdownMenuLabel", () => $d1bf075a6b218014$export$76e48c5b57f24495);
$parcel$export(module.exports, "DropdownMenuItem", () => $d1bf075a6b218014$export$ed97964d1871885d);
$parcel$export(module.exports, "DropdownMenuCheckboxItem", () => $d1bf075a6b218014$export$53a69729da201fa9);
$parcel$export(module.exports, "DropdownMenuRadioGroup", () => $d1bf075a6b218014$export$3323ad73d55f587e);
$parcel$export(module.exports, "DropdownMenuRadioItem", () => $d1bf075a6b218014$export$e4f69b41b1637536);
$parcel$export(module.exports, "DropdownMenuItemIndicator", () => $d1bf075a6b218014$export$42355ae145153fb6);
$parcel$export(module.exports, "DropdownMenuSeparator", () => $d1bf075a6b218014$export$da160178fd3bc7e9);
$parcel$export(module.exports, "DropdownMenuArrow", () => $d1bf075a6b218014$export$34b8980744021ec5);
$parcel$export(module.exports, "DropdownMenuSub", () => $d1bf075a6b218014$export$2f307d81a64f5442);
$parcel$export(module.exports, "DropdownMenuSubTrigger", () => $d1bf075a6b218014$export$21dcb7ec56f874cf);
$parcel$export(module.exports, "DropdownMenuSubContent", () => $d1bf075a6b218014$export$f34ec8bc2482cc5f);
$parcel$export(module.exports, "Root", () => $d1bf075a6b218014$export$be92b6f5f03c0fe9);
$parcel$export(module.exports, "Trigger", () => $d1bf075a6b218014$export$41fb9f06171c75f4);
$parcel$export(module.exports, "Portal", () => $d1bf075a6b218014$export$602eac185826482c);
$parcel$export(module.exports, "Content", () => $d1bf075a6b218014$export$7c6e2c02157bb7d2);
$parcel$export(module.exports, "Group", () => $d1bf075a6b218014$export$eb2fcfdbd7ba97d4);
$parcel$export(module.exports, "Label", () => $d1bf075a6b218014$export$b04be29aa201d4f5);
$parcel$export(module.exports, "Item", () => $d1bf075a6b218014$export$6d08773d2e66f8f2);
$parcel$export(module.exports, "CheckboxItem", () => $d1bf075a6b218014$export$16ce288f89fa631c);
$parcel$export(module.exports, "RadioGroup", () => $d1bf075a6b218014$export$a98f0dcb43a68a25);
$parcel$export(module.exports, "RadioItem", () => $d1bf075a6b218014$export$371ab307eab489c0);
$parcel$export(module.exports, "ItemIndicator", () => $d1bf075a6b218014$export$c3468e2714d175fa);
$parcel$export(module.exports, "Separator", () => $d1bf075a6b218014$export$1ff3c3f08ae963c0);
$parcel$export(module.exports, "Arrow", () => $d1bf075a6b218014$export$21b07c8f274aebd5);
$parcel$export(module.exports, "Sub", () => $d1bf075a6b218014$export$d7a01e11500dfb6f);
$parcel$export(module.exports, "SubTrigger", () => $d1bf075a6b218014$export$2ea8a7a591ac5eac);
$parcel$export(module.exports, "SubContent", () => $d1bf075a6b218014$export$6d4de93b380beddf);

/* -------------------------------------------------------------------------------------------------
 * DropdownMenu
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$DROPDOWN_MENU_NAME = 'DropdownMenu';
const [$d1bf075a6b218014$var$createDropdownMenuContext, $d1bf075a6b218014$export$c0623cd925aeb687] = $7dQ7Q$radixuireactcontext.createContextScope($d1bf075a6b218014$var$DROPDOWN_MENU_NAME, [$7dQ7Q$radixuireactmenu.createMenuScope]);
const $d1bf075a6b218014$var$useMenuScope = $7dQ7Q$radixuireactmenu.createMenuScope();
const [$d1bf075a6b218014$var$DropdownMenuProvider, $d1bf075a6b218014$var$useDropdownMenuContext] = $d1bf075a6b218014$var$createDropdownMenuContext($d1bf075a6b218014$var$DROPDOWN_MENU_NAME);
const $d1bf075a6b218014$export$e44a253a59704894 = props => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    children: children,
    dir: dir,
    open: openProp,
    defaultOpen: defaultOpen,
    onOpenChange: onOpenChange,
    modal = true
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  const triggerRef = $7dQ7Q$react.useRef(null);
  const [open = false, setOpen] = $7dQ7Q$radixuireactusecontrollablestate.useControllableState({
    prop: openProp,
    defaultProp: defaultOpen,
    onChange: onOpenChange
  });
  return /*#__PURE__*/$7dQ7Q$react.createElement($d1bf075a6b218014$var$DropdownMenuProvider, {
    scope: __scopeDropdownMenu,
    triggerId: $7dQ7Q$radixuireactid.useId(),
    triggerRef: triggerRef,
    contentId: $7dQ7Q$radixuireactid.useId(),
    open: open,
    onOpenChange: setOpen,
    onOpenToggle: $7dQ7Q$react.useCallback(() => setOpen(prevOpen => !prevOpen), [setOpen]),
    modal: modal
  }, /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.Root, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, {
    open: open,
    onOpenChange: setOpen,
    dir: dir,
    modal: modal
  }), children));
};
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$e44a253a59704894, {
  displayName: $d1bf075a6b218014$var$DROPDOWN_MENU_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuTrigger
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$TRIGGER_NAME = 'DropdownMenuTrigger';
const $d1bf075a6b218014$export$d2469213b3befba9 = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    disabled = false,
    ...triggerProps
  } = props;
  const context = $d1bf075a6b218014$var$useDropdownMenuContext($d1bf075a6b218014$var$TRIGGER_NAME, __scopeDropdownMenu);
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.Anchor, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({
    asChild: true
  }, menuScope), /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactprimitive.Primitive.button, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({
    type: "button",
    id: context.triggerId,
    "aria-haspopup": "menu",
    "aria-expanded": context.open,
    "aria-controls": context.open ? context.contentId : undefined,
    "data-state": context.open ? 'open' : 'closed',
    "data-disabled": disabled ? '' : undefined,
    disabled: disabled
  }, triggerProps, {
    ref: $7dQ7Q$radixuireactcomposerefs.composeRefs(forwardedRef, context.triggerRef),
    onPointerDown: $7dQ7Q$radixuiprimitive.composeEventHandlers(props.onPointerDown, event => {
      // only call handler if it's the left button (mousedown gets triggered by all mouse buttons)
      // but not when the control key is pressed (avoiding MacOS right click)
      if (!disabled && event.button === 0 && event.ctrlKey === false) {
        context.onOpenToggle(); // prevent trigger focusing when opening
        // this allows the content to be given focus without competition
        if (!context.open) event.preventDefault();
      }
    }),
    onKeyDown: $7dQ7Q$radixuiprimitive.composeEventHandlers(props.onKeyDown, event => {
      if (disabled) return;
      if (['Enter', ' '].includes(event.key)) context.onOpenToggle();
      if (event.key === 'ArrowDown') context.onOpenChange(true); // prevent keydown from scrolling window / first focused item to execute
      // that keydown (inadvertently closing the menu)
      if (['Enter', ' ', 'ArrowDown'].includes(event.key)) event.preventDefault();
    })
  })));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$d2469213b3befba9, {
  displayName: $d1bf075a6b218014$var$TRIGGER_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuPortal
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$PORTAL_NAME = 'DropdownMenuPortal';
const $d1bf075a6b218014$export$cd369b4d4d54efc9 = props => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...portalProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.Portal, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, portalProps));
};
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$cd369b4d4d54efc9, {
  displayName: $d1bf075a6b218014$var$PORTAL_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuContent
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$CONTENT_NAME = 'DropdownMenuContent';
const $d1bf075a6b218014$export$6e76d93a37c01248 = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...contentProps
  } = props;
  const context = $d1bf075a6b218014$var$useDropdownMenuContext($d1bf075a6b218014$var$CONTENT_NAME, __scopeDropdownMenu);
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  const hasInteractedOutsideRef = $7dQ7Q$react.useRef(false);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.Content, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({
    id: context.contentId,
    "aria-labelledby": context.triggerId
  }, menuScope, contentProps, {
    ref: forwardedRef,
    onCloseAutoFocus: $7dQ7Q$radixuiprimitive.composeEventHandlers(props.onCloseAutoFocus, event => {
      var _context$triggerRef$c;
      if (!hasInteractedOutsideRef.current) (_context$triggerRef$c = context.triggerRef.current) === null || _context$triggerRef$c === void 0 || _context$triggerRef$c.focus();
      hasInteractedOutsideRef.current = false; // Always prevent auto focus because we either focus manually or want user agent focus
      event.preventDefault();
    }),
    onInteractOutside: $7dQ7Q$radixuiprimitive.composeEventHandlers(props.onInteractOutside, event => {
      const originalEvent = event.detail.originalEvent;
      const ctrlLeftClick = originalEvent.button === 0 && originalEvent.ctrlKey === true;
      const isRightClick = originalEvent.button === 2 || ctrlLeftClick;
      if (!context.modal || isRightClick) hasInteractedOutsideRef.current = true;
    }),
    style: {
      ...props.style,
      '--radix-dropdown-menu-content-transform-origin': 'var(--radix-popper-transform-origin)',
      '--radix-dropdown-menu-content-available-width': 'var(--radix-popper-available-width)',
      '--radix-dropdown-menu-content-available-height': 'var(--radix-popper-available-height)',
      '--radix-dropdown-menu-trigger-width': 'var(--radix-popper-anchor-width)',
      '--radix-dropdown-menu-trigger-height': 'var(--radix-popper-anchor-height)'
    }
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$6e76d93a37c01248, {
  displayName: $d1bf075a6b218014$var$CONTENT_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuGroup
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$GROUP_NAME = 'DropdownMenuGroup';
const $d1bf075a6b218014$export$246bebaba3a2f70e = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...groupProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.Group, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, groupProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$246bebaba3a2f70e, {
  displayName: $d1bf075a6b218014$var$GROUP_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuLabel
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$LABEL_NAME = 'DropdownMenuLabel';
const $d1bf075a6b218014$export$76e48c5b57f24495 = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...labelProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.Label, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, labelProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$76e48c5b57f24495, {
  displayName: $d1bf075a6b218014$var$LABEL_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuItem
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$ITEM_NAME = 'DropdownMenuItem';
const $d1bf075a6b218014$export$ed97964d1871885d = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...itemProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.Item, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, itemProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$ed97964d1871885d, {
  displayName: $d1bf075a6b218014$var$ITEM_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuCheckboxItem
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$CHECKBOX_ITEM_NAME = 'DropdownMenuCheckboxItem';
const $d1bf075a6b218014$export$53a69729da201fa9 = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...checkboxItemProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.CheckboxItem, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, checkboxItemProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$53a69729da201fa9, {
  displayName: $d1bf075a6b218014$var$CHECKBOX_ITEM_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuRadioGroup
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$RADIO_GROUP_NAME = 'DropdownMenuRadioGroup';
const $d1bf075a6b218014$export$3323ad73d55f587e = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...radioGroupProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.RadioGroup, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, radioGroupProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$3323ad73d55f587e, {
  displayName: $d1bf075a6b218014$var$RADIO_GROUP_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuRadioItem
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$RADIO_ITEM_NAME = 'DropdownMenuRadioItem';
const $d1bf075a6b218014$export$e4f69b41b1637536 = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...radioItemProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.RadioItem, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, radioItemProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$e4f69b41b1637536, {
  displayName: $d1bf075a6b218014$var$RADIO_ITEM_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuItemIndicator
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$INDICATOR_NAME = 'DropdownMenuItemIndicator';
const $d1bf075a6b218014$export$42355ae145153fb6 = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...itemIndicatorProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.ItemIndicator, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, itemIndicatorProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$42355ae145153fb6, {
  displayName: $d1bf075a6b218014$var$INDICATOR_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuSeparator
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$SEPARATOR_NAME = 'DropdownMenuSeparator';
const $d1bf075a6b218014$export$da160178fd3bc7e9 = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...separatorProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.Separator, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, separatorProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$da160178fd3bc7e9, {
  displayName: $d1bf075a6b218014$var$SEPARATOR_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuArrow
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$ARROW_NAME = 'DropdownMenuArrow';
const $d1bf075a6b218014$export$34b8980744021ec5 = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...arrowProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.Arrow, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, arrowProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$34b8980744021ec5, {
  displayName: $d1bf075a6b218014$var$ARROW_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuSub
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$export$2f307d81a64f5442 = props => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    children: children,
    open: openProp,
    onOpenChange: onOpenChange,
    defaultOpen: defaultOpen
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  const [open = false, setOpen] = $7dQ7Q$radixuireactusecontrollablestate.useControllableState({
    prop: openProp,
    defaultProp: defaultOpen,
    onChange: onOpenChange
  });
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.Sub, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, {
    open: open,
    onOpenChange: setOpen
  }), children);
};
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuSubTrigger
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$SUB_TRIGGER_NAME = 'DropdownMenuSubTrigger';
const $d1bf075a6b218014$export$21dcb7ec56f874cf = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...subTriggerProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.SubTrigger, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, subTriggerProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$21dcb7ec56f874cf, {
  displayName: $d1bf075a6b218014$var$SUB_TRIGGER_NAME
});
/* -------------------------------------------------------------------------------------------------
 * DropdownMenuSubContent
 * -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$var$SUB_CONTENT_NAME = 'DropdownMenuSubContent';
const $d1bf075a6b218014$export$f34ec8bc2482cc5f = /*#__PURE__*/$7dQ7Q$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeDropdownMenu: __scopeDropdownMenu,
    ...subContentProps
  } = props;
  const menuScope = $d1bf075a6b218014$var$useMenuScope(__scopeDropdownMenu);
  return /*#__PURE__*/$7dQ7Q$react.createElement($7dQ7Q$radixuireactmenu.SubContent, $parcel$interopDefault($7dQ7Q$babelruntimehelpersextends)({}, menuScope, subContentProps, {
    ref: forwardedRef,
    style: {
      ...props.style,
      '--radix-dropdown-menu-content-transform-origin': 'var(--radix-popper-transform-origin)',
      '--radix-dropdown-menu-content-available-width': 'var(--radix-popper-available-width)',
      '--radix-dropdown-menu-content-available-height': 'var(--radix-popper-available-height)',
      '--radix-dropdown-menu-trigger-width': 'var(--radix-popper-anchor-width)',
      '--radix-dropdown-menu-trigger-height': 'var(--radix-popper-anchor-height)'
    }
  }));
});
/*#__PURE__*/
Object.assign($d1bf075a6b218014$export$f34ec8bc2482cc5f, {
  displayName: $d1bf075a6b218014$var$SUB_CONTENT_NAME
});
/* -----------------------------------------------------------------------------------------------*/
const $d1bf075a6b218014$export$be92b6f5f03c0fe9 = $d1bf075a6b218014$export$e44a253a59704894;
const $d1bf075a6b218014$export$41fb9f06171c75f4 = $d1bf075a6b218014$export$d2469213b3befba9;
const $d1bf075a6b218014$export$602eac185826482c = $d1bf075a6b218014$export$cd369b4d4d54efc9;
const $d1bf075a6b218014$export$7c6e2c02157bb7d2 = $d1bf075a6b218014$export$6e76d93a37c01248;
const $d1bf075a6b218014$export$eb2fcfdbd7ba97d4 = $d1bf075a6b218014$export$246bebaba3a2f70e;
const $d1bf075a6b218014$export$b04be29aa201d4f5 = $d1bf075a6b218014$export$76e48c5b57f24495;
const $d1bf075a6b218014$export$6d08773d2e66f8f2 = $d1bf075a6b218014$export$ed97964d1871885d;
const $d1bf075a6b218014$export$16ce288f89fa631c = $d1bf075a6b218014$export$53a69729da201fa9;
const $d1bf075a6b218014$export$a98f0dcb43a68a25 = $d1bf075a6b218014$export$3323ad73d55f587e;
const $d1bf075a6b218014$export$371ab307eab489c0 = $d1bf075a6b218014$export$e4f69b41b1637536;
const $d1bf075a6b218014$export$c3468e2714d175fa = $d1bf075a6b218014$export$42355ae145153fb6;
const $d1bf075a6b218014$export$1ff3c3f08ae963c0 = $d1bf075a6b218014$export$da160178fd3bc7e9;
const $d1bf075a6b218014$export$21b07c8f274aebd5 = $d1bf075a6b218014$export$34b8980744021ec5;
const $d1bf075a6b218014$export$d7a01e11500dfb6f = $d1bf075a6b218014$export$2f307d81a64f5442;
const $d1bf075a6b218014$export$2ea8a7a591ac5eac = $d1bf075a6b218014$export$21dcb7ec56f874cf;
const $d1bf075a6b218014$export$6d4de93b380beddf = $d1bf075a6b218014$export$f34ec8bc2482cc5f;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-focus-guards/dist/index.js":
/*!************************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-focus-guards/dist/index.js ***!
  \************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $cnctE$react = __webpack_require__(/*! react */ "react");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "FocusGuards", () => $71476a6ed7dbbaf3$export$ac5b58043b79449b);
$parcel$export(module.exports, "Root", () => $71476a6ed7dbbaf3$export$be92b6f5f03c0fe9);
$parcel$export(module.exports, "useFocusGuards", () => $71476a6ed7dbbaf3$export$b7ece24a22aeda8c);

/** Number of components which have requested interest to have focus guards */
let $71476a6ed7dbbaf3$var$count = 0;
function $71476a6ed7dbbaf3$export$ac5b58043b79449b(props) {
  $71476a6ed7dbbaf3$export$b7ece24a22aeda8c();
  return props.children;
}
/**
 * Injects a pair of focus guards at the edges of the whole DOM tree
 * to ensure `focusin` & `focusout` events can be caught consistently.
 */
function $71476a6ed7dbbaf3$export$b7ece24a22aeda8c() {
  $cnctE$react.useEffect(() => {
    var _edgeGuards$, _edgeGuards$2;
    const edgeGuards = document.querySelectorAll('[data-radix-focus-guard]');
    document.body.insertAdjacentElement('afterbegin', (_edgeGuards$ = edgeGuards[0]) !== null && _edgeGuards$ !== void 0 ? _edgeGuards$ : $71476a6ed7dbbaf3$var$createFocusGuard());
    document.body.insertAdjacentElement('beforeend', (_edgeGuards$2 = edgeGuards[1]) !== null && _edgeGuards$2 !== void 0 ? _edgeGuards$2 : $71476a6ed7dbbaf3$var$createFocusGuard());
    $71476a6ed7dbbaf3$var$count++;
    return () => {
      if ($71476a6ed7dbbaf3$var$count === 1) document.querySelectorAll('[data-radix-focus-guard]').forEach(node => node.remove());
      $71476a6ed7dbbaf3$var$count--;
    };
  }, []);
}
function $71476a6ed7dbbaf3$var$createFocusGuard() {
  const element = document.createElement('span');
  element.setAttribute('data-radix-focus-guard', '');
  element.tabIndex = 0;
  element.style.cssText = 'outline: none; opacity: 0; position: fixed; pointer-events: none';
  return element;
}
const $71476a6ed7dbbaf3$export$be92b6f5f03c0fe9 = $71476a6ed7dbbaf3$export$ac5b58043b79449b;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-focus-scope/dist/index.js":
/*!***********************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-focus-scope/dist/index.js ***!
  \***********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $buum9$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $buum9$react = __webpack_require__(/*! react */ "react");
var $buum9$radixuireactcomposerefs = __webpack_require__(/*! @radix-ui/react-compose-refs */ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js");
var $buum9$radixuireactprimitive = __webpack_require__(/*! @radix-ui/react-primitive */ "../../../node_modules/@radix-ui/react-primitive/dist/index.js");
var $buum9$radixuireactusecallbackref = __webpack_require__(/*! @radix-ui/react-use-callback-ref */ "../../../node_modules/@radix-ui/react-use-callback-ref/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "FocusScope", () => $2bc01e66e04aa9ed$export$20e40289641fbbb6);
$parcel$export(module.exports, "Root", () => $2bc01e66e04aa9ed$export$be92b6f5f03c0fe9);
const $2bc01e66e04aa9ed$var$AUTOFOCUS_ON_MOUNT = 'focusScope.autoFocusOnMount';
const $2bc01e66e04aa9ed$var$AUTOFOCUS_ON_UNMOUNT = 'focusScope.autoFocusOnUnmount';
const $2bc01e66e04aa9ed$var$EVENT_OPTIONS = {
  bubbles: false,
  cancelable: true
};
/* -------------------------------------------------------------------------------------------------
 * FocusScope
 * -----------------------------------------------------------------------------------------------*/
const $2bc01e66e04aa9ed$var$FOCUS_SCOPE_NAME = 'FocusScope';
const $2bc01e66e04aa9ed$export$20e40289641fbbb6 = /*#__PURE__*/$buum9$react.forwardRef((props, forwardedRef) => {
  const {
    loop = false,
    trapped = false,
    onMountAutoFocus: onMountAutoFocusProp,
    onUnmountAutoFocus: onUnmountAutoFocusProp,
    ...scopeProps
  } = props;
  const [container1, setContainer] = $buum9$react.useState(null);
  const onMountAutoFocus = $buum9$radixuireactusecallbackref.useCallbackRef(onMountAutoFocusProp);
  const onUnmountAutoFocus = $buum9$radixuireactusecallbackref.useCallbackRef(onUnmountAutoFocusProp);
  const lastFocusedElementRef = $buum9$react.useRef(null);
  const composedRefs = $buum9$radixuireactcomposerefs.useComposedRefs(forwardedRef, node => setContainer(node));
  const focusScope = $buum9$react.useRef({
    paused: false,
    pause() {
      this.paused = true;
    },
    resume() {
      this.paused = false;
    }
  }).current; // Takes care of trapping focus if focus is moved outside programmatically for example
  $buum9$react.useEffect(() => {
    if (trapped) {
      function handleFocusIn(event) {
        if (focusScope.paused || !container1) return;
        const target = event.target;
        if (container1.contains(target)) lastFocusedElementRef.current = target;else $2bc01e66e04aa9ed$var$focus(lastFocusedElementRef.current, {
          select: true
        });
      }
      function handleFocusOut(event) {
        if (focusScope.paused || !container1) return;
        const relatedTarget = event.relatedTarget; // A `focusout` event with a `null` `relatedTarget` will happen in at least two cases:
        //
        // 1. When the user switches app/tabs/windows/the browser itself loses focus.
        // 2. In Google Chrome, when the focused element is removed from the DOM.
        //
        // We let the browser do its thing here because:
        //
        // 1. The browser already keeps a memory of what's focused for when the page gets refocused.
        // 2. In Google Chrome, if we try to focus the deleted focused element (as per below), it
        //    throws the CPU to 100%, so we avoid doing anything for this reason here too.
        if (relatedTarget === null) return; // If the focus has moved to an actual legitimate element (`relatedTarget !== null`)
        // that is outside the container, we move focus to the last valid focused element inside.
        if (!container1.contains(relatedTarget)) $2bc01e66e04aa9ed$var$focus(lastFocusedElementRef.current, {
          select: true
        });
      } // When the focused element gets removed from the DOM, browsers move focus
      // back to the document.body. In this case, we move focus to the container
      // to keep focus trapped correctly.
      function handleMutations(mutations) {
        const focusedElement = document.activeElement;
        for (const mutation of mutations) {
          if (mutation.removedNodes.length > 0) {
            if (!(container1 !== null && container1 !== void 0 && container1.contains(focusedElement))) $2bc01e66e04aa9ed$var$focus(container1);
          }
        }
      }
      document.addEventListener('focusin', handleFocusIn);
      document.addEventListener('focusout', handleFocusOut);
      const mutationObserver = new MutationObserver(handleMutations);
      if (container1) mutationObserver.observe(container1, {
        childList: true,
        subtree: true
      });
      return () => {
        document.removeEventListener('focusin', handleFocusIn);
        document.removeEventListener('focusout', handleFocusOut);
        mutationObserver.disconnect();
      };
    }
  }, [trapped, container1, focusScope.paused]);
  $buum9$react.useEffect(() => {
    if (container1) {
      $2bc01e66e04aa9ed$var$focusScopesStack.add(focusScope);
      const previouslyFocusedElement = document.activeElement;
      const hasFocusedCandidate = container1.contains(previouslyFocusedElement);
      if (!hasFocusedCandidate) {
        const mountEvent = new CustomEvent($2bc01e66e04aa9ed$var$AUTOFOCUS_ON_MOUNT, $2bc01e66e04aa9ed$var$EVENT_OPTIONS);
        container1.addEventListener($2bc01e66e04aa9ed$var$AUTOFOCUS_ON_MOUNT, onMountAutoFocus);
        container1.dispatchEvent(mountEvent);
        if (!mountEvent.defaultPrevented) {
          $2bc01e66e04aa9ed$var$focusFirst($2bc01e66e04aa9ed$var$removeLinks($2bc01e66e04aa9ed$var$getTabbableCandidates(container1)), {
            select: true
          });
          if (document.activeElement === previouslyFocusedElement) $2bc01e66e04aa9ed$var$focus(container1);
        }
      }
      return () => {
        container1.removeEventListener($2bc01e66e04aa9ed$var$AUTOFOCUS_ON_MOUNT, onMountAutoFocus); // We hit a react bug (fixed in v17) with focusing in unmount.
        // We need to delay the focus a little to get around it for now.
        // See: https://github.com/facebook/react/issues/17894
        setTimeout(() => {
          const unmountEvent = new CustomEvent($2bc01e66e04aa9ed$var$AUTOFOCUS_ON_UNMOUNT, $2bc01e66e04aa9ed$var$EVENT_OPTIONS);
          container1.addEventListener($2bc01e66e04aa9ed$var$AUTOFOCUS_ON_UNMOUNT, onUnmountAutoFocus);
          container1.dispatchEvent(unmountEvent);
          if (!unmountEvent.defaultPrevented) $2bc01e66e04aa9ed$var$focus(previouslyFocusedElement !== null && previouslyFocusedElement !== void 0 ? previouslyFocusedElement : document.body, {
            select: true
          });
          // we need to remove the listener after we `dispatchEvent`
          container1.removeEventListener($2bc01e66e04aa9ed$var$AUTOFOCUS_ON_UNMOUNT, onUnmountAutoFocus);
          $2bc01e66e04aa9ed$var$focusScopesStack.remove(focusScope);
        }, 0);
      };
    }
  }, [container1, onMountAutoFocus, onUnmountAutoFocus, focusScope]); // Takes care of looping focus (when tabbing whilst at the edges)
  const handleKeyDown = $buum9$react.useCallback(event => {
    if (!loop && !trapped) return;
    if (focusScope.paused) return;
    const isTabKey = event.key === 'Tab' && !event.altKey && !event.ctrlKey && !event.metaKey;
    const focusedElement = document.activeElement;
    if (isTabKey && focusedElement) {
      const container = event.currentTarget;
      const [first, last] = $2bc01e66e04aa9ed$var$getTabbableEdges(container);
      const hasTabbableElementsInside = first && last; // we can only wrap focus if we have tabbable edges
      if (!hasTabbableElementsInside) {
        if (focusedElement === container) event.preventDefault();
      } else {
        if (!event.shiftKey && focusedElement === last) {
          event.preventDefault();
          if (loop) $2bc01e66e04aa9ed$var$focus(first, {
            select: true
          });
        } else if (event.shiftKey && focusedElement === first) {
          event.preventDefault();
          if (loop) $2bc01e66e04aa9ed$var$focus(last, {
            select: true
          });
        }
      }
    }
  }, [loop, trapped, focusScope.paused]);
  return /*#__PURE__*/$buum9$react.createElement($buum9$radixuireactprimitive.Primitive.div, $parcel$interopDefault($buum9$babelruntimehelpersextends)({
    tabIndex: -1
  }, scopeProps, {
    ref: composedRefs,
    onKeyDown: handleKeyDown
  }));
});
/*#__PURE__*/
Object.assign($2bc01e66e04aa9ed$export$20e40289641fbbb6, {
  displayName: $2bc01e66e04aa9ed$var$FOCUS_SCOPE_NAME
});
/* -------------------------------------------------------------------------------------------------
 * Utils
 * -----------------------------------------------------------------------------------------------*/ /**
                                                                                                     * Attempts focusing the first element in a list of candidates.
                                                                                                     * Stops when focus has actually moved.
                                                                                                     */
function $2bc01e66e04aa9ed$var$focusFirst(candidates, {
  select = false
} = {}) {
  const previouslyFocusedElement = document.activeElement;
  for (const candidate of candidates) {
    $2bc01e66e04aa9ed$var$focus(candidate, {
      select: select
    });
    if (document.activeElement !== previouslyFocusedElement) return;
  }
}
/**
 * Returns the first and last tabbable elements inside a container.
 */
function $2bc01e66e04aa9ed$var$getTabbableEdges(container) {
  const candidates = $2bc01e66e04aa9ed$var$getTabbableCandidates(container);
  const first = $2bc01e66e04aa9ed$var$findVisible(candidates, container);
  const last = $2bc01e66e04aa9ed$var$findVisible(candidates.reverse(), container);
  return [first, last];
}
/**
 * Returns a list of potential tabbable candidates.
 *
 * NOTE: This is only a close approximation. For example it doesn't take into account cases like when
 * elements are not visible. This cannot be worked out easily by just reading a property, but rather
 * necessitate runtime knowledge (computed styles, etc). We deal with these cases separately.
 *
 * See: https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker
 * Credit: https://github.com/discord/focus-layers/blob/master/src/util/wrapFocus.tsx#L1
 */
function $2bc01e66e04aa9ed$var$getTabbableCandidates(container) {
  const nodes = [];
  const walker = document.createTreeWalker(container, NodeFilter.SHOW_ELEMENT, {
    acceptNode: node => {
      const isHiddenInput = node.tagName === 'INPUT' && node.type === 'hidden';
      if (node.disabled || node.hidden || isHiddenInput) return NodeFilter.FILTER_SKIP; // `.tabIndex` is not the same as the `tabindex` attribute. It works on the
      // runtime's understanding of tabbability, so this automatically accounts
      // for any kind of element that could be tabbed to.
      return node.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
    }
  });
  while (walker.nextNode()) nodes.push(walker.currentNode); // we do not take into account the order of nodes with positive `tabIndex` as it
  // hinders accessibility to have tab order different from visual order.
  return nodes;
}
/**
 * Returns the first visible element in a list.
 * NOTE: Only checks visibility up to the `container`.
 */
function $2bc01e66e04aa9ed$var$findVisible(elements, container) {
  for (const element of elements) {
    // we stop checking if it's hidden at the `container` level (excluding)
    if (!$2bc01e66e04aa9ed$var$isHidden(element, {
      upTo: container
    })) return element;
  }
}
function $2bc01e66e04aa9ed$var$isHidden(node, {
  upTo: upTo
}) {
  if (getComputedStyle(node).visibility === 'hidden') return true;
  while (node) {
    // we stop at `upTo` (excluding it)
    if (upTo !== undefined && node === upTo) return false;
    if (getComputedStyle(node).display === 'none') return true;
    node = node.parentElement;
  }
  return false;
}
function $2bc01e66e04aa9ed$var$isSelectableInput(element) {
  return element instanceof HTMLInputElement && 'select' in element;
}
function $2bc01e66e04aa9ed$var$focus(element, {
  select = false
} = {}) {
  // only focus if that element is focusable
  if (element && element.focus) {
    const previouslyFocusedElement = document.activeElement; // NOTE: we prevent scrolling on focus, to minimize jarring transitions for users
    element.focus({
      preventScroll: true
    }); // only select if its not the same element, it supports selection and we need to select
    if (element !== previouslyFocusedElement && $2bc01e66e04aa9ed$var$isSelectableInput(element) && select) element.select();
  }
}
/* -------------------------------------------------------------------------------------------------
 * FocusScope stack
 * -----------------------------------------------------------------------------------------------*/
const $2bc01e66e04aa9ed$var$focusScopesStack = $2bc01e66e04aa9ed$var$createFocusScopesStack();
function $2bc01e66e04aa9ed$var$createFocusScopesStack() {
  /** A stack of focus scopes, with the active one at the top */let stack = [];
  return {
    add(focusScope) {
      // pause the currently active focus scope (at the top of the stack)
      const activeFocusScope = stack[0];
      if (focusScope !== activeFocusScope) activeFocusScope === null || activeFocusScope === void 0 || activeFocusScope.pause();
      // remove in case it already exists (because we'll re-add it at the top of the stack)
      stack = $2bc01e66e04aa9ed$var$arrayRemove(stack, focusScope);
      stack.unshift(focusScope);
    },
    remove(focusScope) {
      var _stack$;
      stack = $2bc01e66e04aa9ed$var$arrayRemove(stack, focusScope);
      (_stack$ = stack[0]) === null || _stack$ === void 0 || _stack$.resume();
    }
  };
}
function $2bc01e66e04aa9ed$var$arrayRemove(array, item) {
  const updatedArray = [...array];
  const index = updatedArray.indexOf(item);
  if (index !== -1) updatedArray.splice(index, 1);
  return updatedArray;
}
function $2bc01e66e04aa9ed$var$removeLinks(items) {
  return items.filter(item => item.tagName !== 'A');
}
const $2bc01e66e04aa9ed$export$be92b6f5f03c0fe9 = $2bc01e66e04aa9ed$export$20e40289641fbbb6;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-id/dist/index.js":
/*!**************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-id/dist/index.js ***!
  \**************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $47woD$react = __webpack_require__(/*! react */ "react");
var $47woD$radixuireactuselayouteffect = __webpack_require__(/*! @radix-ui/react-use-layout-effect */ "../../../node_modules/@radix-ui/react-use-layout-effect/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "useId", () => $dc478e4659f630c5$export$f680877a34711e37);
const $dc478e4659f630c5$var$useReactId = $47woD$react['useId'.toString()] || (() => undefined);
let $dc478e4659f630c5$var$count = 0;
function $dc478e4659f630c5$export$f680877a34711e37(deterministicId) {
  const [id, setId] = $47woD$react.useState($dc478e4659f630c5$var$useReactId()); // React versions older than 18 will have client-side ids only.
  $47woD$radixuireactuselayouteffect.useLayoutEffect(() => {
    if (!deterministicId) setId(reactId => reactId !== null && reactId !== void 0 ? reactId : String($dc478e4659f630c5$var$count++));
  }, [deterministicId]);
  return deterministicId || (id ? `radix-${id}` : '');
}

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-menu/dist/index.js":
/*!****************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-menu/dist/index.js ***!
  \****************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $cnSS2$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $cnSS2$react = __webpack_require__(/*! react */ "react");
var $cnSS2$radixuiprimitive = __webpack_require__(/*! @radix-ui/primitive */ "../../../node_modules/@radix-ui/primitive/dist/index.js");
var $cnSS2$radixuireactcollection = __webpack_require__(/*! @radix-ui/react-collection */ "../../../node_modules/@radix-ui/react-collection/dist/index.js");
var $cnSS2$radixuireactcomposerefs = __webpack_require__(/*! @radix-ui/react-compose-refs */ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js");
var $cnSS2$radixuireactcontext = __webpack_require__(/*! @radix-ui/react-context */ "../../../node_modules/@radix-ui/react-context/dist/index.js");
var $cnSS2$radixuireactdirection = __webpack_require__(/*! @radix-ui/react-direction */ "../../../node_modules/@radix-ui/react-direction/dist/index.js");
var $cnSS2$radixuireactdismissablelayer = __webpack_require__(/*! @radix-ui/react-dismissable-layer */ "../../../node_modules/@radix-ui/react-dismissable-layer/dist/index.js");
var $cnSS2$radixuireactfocusguards = __webpack_require__(/*! @radix-ui/react-focus-guards */ "../../../node_modules/@radix-ui/react-focus-guards/dist/index.js");
var $cnSS2$radixuireactfocusscope = __webpack_require__(/*! @radix-ui/react-focus-scope */ "../../../node_modules/@radix-ui/react-focus-scope/dist/index.js");
var $cnSS2$radixuireactid = __webpack_require__(/*! @radix-ui/react-id */ "../../../node_modules/@radix-ui/react-id/dist/index.js");
var $cnSS2$radixuireactpopper = __webpack_require__(/*! @radix-ui/react-popper */ "../../../node_modules/@radix-ui/react-popper/dist/index.js");
var $cnSS2$radixuireactportal = __webpack_require__(/*! @radix-ui/react-portal */ "../../../node_modules/@radix-ui/react-portal/dist/index.js");
var $cnSS2$radixuireactpresence = __webpack_require__(/*! @radix-ui/react-presence */ "../../../node_modules/@radix-ui/react-presence/dist/index.js");
var $cnSS2$radixuireactprimitive = __webpack_require__(/*! @radix-ui/react-primitive */ "../../../node_modules/@radix-ui/react-primitive/dist/index.js");
var $cnSS2$radixuireactrovingfocus = __webpack_require__(/*! @radix-ui/react-roving-focus */ "../../../node_modules/@radix-ui/react-roving-focus/dist/index.js");
var $cnSS2$radixuireactslot = __webpack_require__(/*! @radix-ui/react-slot */ "../../../node_modules/@radix-ui/react-slot/dist/index.js");
var $cnSS2$radixuireactusecallbackref = __webpack_require__(/*! @radix-ui/react-use-callback-ref */ "../../../node_modules/@radix-ui/react-use-callback-ref/dist/index.js");
var $cnSS2$ariahidden = __webpack_require__(/*! aria-hidden */ "../../../node_modules/aria-hidden/dist/es2015/index.js");
var $cnSS2$reactremovescroll = __webpack_require__(/*! react-remove-scroll */ "../../../node_modules/react-remove-scroll/dist/es2015/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "createMenuScope", () => $213e4d2df823067d$export$4027731b685e72eb);
$parcel$export(module.exports, "Menu", () => $213e4d2df823067d$export$d9b273488cd8ce6f);
$parcel$export(module.exports, "MenuAnchor", () => $213e4d2df823067d$export$9fa5ebd18bee4d43);
$parcel$export(module.exports, "MenuPortal", () => $213e4d2df823067d$export$793392f970497feb);
$parcel$export(module.exports, "MenuContent", () => $213e4d2df823067d$export$479f0f2f71193efe);
$parcel$export(module.exports, "MenuGroup", () => $213e4d2df823067d$export$22a631d1f72787bb);
$parcel$export(module.exports, "MenuLabel", () => $213e4d2df823067d$export$dd37bec0e8a99143);
$parcel$export(module.exports, "MenuItem", () => $213e4d2df823067d$export$2ce376c2cc3355c8);
$parcel$export(module.exports, "MenuCheckboxItem", () => $213e4d2df823067d$export$f6f243521332502d);
$parcel$export(module.exports, "MenuRadioGroup", () => $213e4d2df823067d$export$ea2200c9eee416b3);
$parcel$export(module.exports, "MenuRadioItem", () => $213e4d2df823067d$export$69bd225e9817f6d0);
$parcel$export(module.exports, "MenuItemIndicator", () => $213e4d2df823067d$export$a2593e23056970a3);
$parcel$export(module.exports, "MenuSeparator", () => $213e4d2df823067d$export$1cec7dcdd713e220);
$parcel$export(module.exports, "MenuArrow", () => $213e4d2df823067d$export$bcdda4773debf5fa);
$parcel$export(module.exports, "MenuSub", () => $213e4d2df823067d$export$71bdb9d1e2909932);
$parcel$export(module.exports, "MenuSubTrigger", () => $213e4d2df823067d$export$5fbbb3ba7297405f);
$parcel$export(module.exports, "MenuSubContent", () => $213e4d2df823067d$export$e7142ab31822bde6);
$parcel$export(module.exports, "Root", () => $213e4d2df823067d$export$be92b6f5f03c0fe9);
$parcel$export(module.exports, "Anchor", () => $213e4d2df823067d$export$b688253958b8dfe7);
$parcel$export(module.exports, "Portal", () => $213e4d2df823067d$export$602eac185826482c);
$parcel$export(module.exports, "Content", () => $213e4d2df823067d$export$7c6e2c02157bb7d2);
$parcel$export(module.exports, "Group", () => $213e4d2df823067d$export$eb2fcfdbd7ba97d4);
$parcel$export(module.exports, "Label", () => $213e4d2df823067d$export$b04be29aa201d4f5);
$parcel$export(module.exports, "Item", () => $213e4d2df823067d$export$6d08773d2e66f8f2);
$parcel$export(module.exports, "CheckboxItem", () => $213e4d2df823067d$export$16ce288f89fa631c);
$parcel$export(module.exports, "RadioGroup", () => $213e4d2df823067d$export$a98f0dcb43a68a25);
$parcel$export(module.exports, "RadioItem", () => $213e4d2df823067d$export$371ab307eab489c0);
$parcel$export(module.exports, "ItemIndicator", () => $213e4d2df823067d$export$c3468e2714d175fa);
$parcel$export(module.exports, "Separator", () => $213e4d2df823067d$export$1ff3c3f08ae963c0);
$parcel$export(module.exports, "Arrow", () => $213e4d2df823067d$export$21b07c8f274aebd5);
$parcel$export(module.exports, "Sub", () => $213e4d2df823067d$export$d7a01e11500dfb6f);
$parcel$export(module.exports, "SubTrigger", () => $213e4d2df823067d$export$2ea8a7a591ac5eac);
$parcel$export(module.exports, "SubContent", () => $213e4d2df823067d$export$6d4de93b380beddf);
const $213e4d2df823067d$var$SELECTION_KEYS = ['Enter', ' '];
const $213e4d2df823067d$var$FIRST_KEYS = ['ArrowDown', 'PageUp', 'Home'];
const $213e4d2df823067d$var$LAST_KEYS = ['ArrowUp', 'PageDown', 'End'];
const $213e4d2df823067d$var$FIRST_LAST_KEYS = [...$213e4d2df823067d$var$FIRST_KEYS, ...$213e4d2df823067d$var$LAST_KEYS];
const $213e4d2df823067d$var$SUB_OPEN_KEYS = {
  ltr: [...$213e4d2df823067d$var$SELECTION_KEYS, 'ArrowRight'],
  rtl: [...$213e4d2df823067d$var$SELECTION_KEYS, 'ArrowLeft']
};
const $213e4d2df823067d$var$SUB_CLOSE_KEYS = {
  ltr: ['ArrowLeft'],
  rtl: ['ArrowRight']
};
/* -------------------------------------------------------------------------------------------------
 * Menu
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$MENU_NAME = 'Menu';
const [$213e4d2df823067d$var$Collection, $213e4d2df823067d$var$useCollection, $213e4d2df823067d$var$createCollectionScope] = $cnSS2$radixuireactcollection.createCollection($213e4d2df823067d$var$MENU_NAME);
const [$213e4d2df823067d$var$createMenuContext, $213e4d2df823067d$export$4027731b685e72eb] = $cnSS2$radixuireactcontext.createContextScope($213e4d2df823067d$var$MENU_NAME, [$213e4d2df823067d$var$createCollectionScope, $cnSS2$radixuireactpopper.createPopperScope, $cnSS2$radixuireactrovingfocus.createRovingFocusGroupScope]);
const $213e4d2df823067d$var$usePopperScope = $cnSS2$radixuireactpopper.createPopperScope();
const $213e4d2df823067d$var$useRovingFocusGroupScope = $cnSS2$radixuireactrovingfocus.createRovingFocusGroupScope();
const [$213e4d2df823067d$var$MenuProvider, $213e4d2df823067d$var$useMenuContext] = $213e4d2df823067d$var$createMenuContext($213e4d2df823067d$var$MENU_NAME);
const [$213e4d2df823067d$var$MenuRootProvider, $213e4d2df823067d$var$useMenuRootContext] = $213e4d2df823067d$var$createMenuContext($213e4d2df823067d$var$MENU_NAME);
const $213e4d2df823067d$export$d9b273488cd8ce6f = props => {
  const {
    __scopeMenu: __scopeMenu,
    open = false,
    children: children,
    dir: dir,
    onOpenChange: onOpenChange,
    modal = true
  } = props;
  const popperScope = $213e4d2df823067d$var$usePopperScope(__scopeMenu);
  const [content, setContent] = $cnSS2$react.useState(null);
  const isUsingKeyboardRef = $cnSS2$react.useRef(false);
  const handleOpenChange = $cnSS2$radixuireactusecallbackref.useCallbackRef(onOpenChange);
  const direction = $cnSS2$radixuireactdirection.useDirection(dir);
  $cnSS2$react.useEffect(() => {
    // Capture phase ensures we set the boolean before any side effects execute
    // in response to the key or pointer event as they might depend on this value.
    const handleKeyDown = () => {
      isUsingKeyboardRef.current = true;
      document.addEventListener('pointerdown', handlePointer, {
        capture: true,
        once: true
      });
      document.addEventListener('pointermove', handlePointer, {
        capture: true,
        once: true
      });
    };
    const handlePointer = () => isUsingKeyboardRef.current = false;
    document.addEventListener('keydown', handleKeyDown, {
      capture: true
    });
    return () => {
      document.removeEventListener('keydown', handleKeyDown, {
        capture: true
      });
      document.removeEventListener('pointerdown', handlePointer, {
        capture: true
      });
      document.removeEventListener('pointermove', handlePointer, {
        capture: true
      });
    };
  }, []);
  return /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactpopper.Root, popperScope, /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuProvider, {
    scope: __scopeMenu,
    open: open,
    onOpenChange: handleOpenChange,
    content: content,
    onContentChange: setContent
  }, /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuRootProvider, {
    scope: __scopeMenu,
    onClose: $cnSS2$react.useCallback(() => handleOpenChange(false), [handleOpenChange]),
    isUsingKeyboardRef: isUsingKeyboardRef,
    dir: direction,
    modal: modal
  }, children)));
};
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$d9b273488cd8ce6f, {
  displayName: $213e4d2df823067d$var$MENU_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuAnchor
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$ANCHOR_NAME = 'MenuAnchor';
const $213e4d2df823067d$export$9fa5ebd18bee4d43 = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeMenu: __scopeMenu,
    ...anchorProps
  } = props;
  const popperScope = $213e4d2df823067d$var$usePopperScope(__scopeMenu);
  return /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactpopper.Anchor, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({}, popperScope, anchorProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$9fa5ebd18bee4d43, {
  displayName: $213e4d2df823067d$var$ANCHOR_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuPortal
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$PORTAL_NAME = 'MenuPortal';
const [$213e4d2df823067d$var$PortalProvider, $213e4d2df823067d$var$usePortalContext] = $213e4d2df823067d$var$createMenuContext($213e4d2df823067d$var$PORTAL_NAME, {
  forceMount: undefined
});
const $213e4d2df823067d$export$793392f970497feb = props => {
  const {
    __scopeMenu: __scopeMenu,
    forceMount: forceMount,
    children: children,
    container: container
  } = props;
  const context = $213e4d2df823067d$var$useMenuContext($213e4d2df823067d$var$PORTAL_NAME, __scopeMenu);
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$PortalProvider, {
    scope: __scopeMenu,
    forceMount: forceMount
  }, /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactpresence.Presence, {
    present: forceMount || context.open
  }, /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactportal.Portal, {
    asChild: true,
    container: container
  }, children)));
};
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$793392f970497feb, {
  displayName: $213e4d2df823067d$var$PORTAL_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuContent
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$CONTENT_NAME = 'MenuContent';
const [$213e4d2df823067d$var$MenuContentProvider, $213e4d2df823067d$var$useMenuContentContext] = $213e4d2df823067d$var$createMenuContext($213e4d2df823067d$var$CONTENT_NAME);
const $213e4d2df823067d$export$479f0f2f71193efe = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const portalContext = $213e4d2df823067d$var$usePortalContext($213e4d2df823067d$var$CONTENT_NAME, props.__scopeMenu);
  const {
    forceMount = portalContext.forceMount,
    ...contentProps
  } = props;
  const context = $213e4d2df823067d$var$useMenuContext($213e4d2df823067d$var$CONTENT_NAME, props.__scopeMenu);
  const rootContext = $213e4d2df823067d$var$useMenuRootContext($213e4d2df823067d$var$CONTENT_NAME, props.__scopeMenu);
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$Collection.Provider, {
    scope: props.__scopeMenu
  }, /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactpresence.Presence, {
    present: forceMount || context.open
  }, /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$Collection.Slot, {
    scope: props.__scopeMenu
  }, rootContext.modal ? /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuRootContentModal, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({}, contentProps, {
    ref: forwardedRef
  })) : /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuRootContentNonModal, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({}, contentProps, {
    ref: forwardedRef
  })))));
});
/* ---------------------------------------------------------------------------------------------- */
const $213e4d2df823067d$var$MenuRootContentModal = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const context = $213e4d2df823067d$var$useMenuContext($213e4d2df823067d$var$CONTENT_NAME, props.__scopeMenu);
  const ref = $cnSS2$react.useRef(null);
  const composedRefs = $cnSS2$radixuireactcomposerefs.useComposedRefs(forwardedRef, ref); // Hide everything from ARIA except the `MenuContent`
  $cnSS2$react.useEffect(() => {
    const content = ref.current;
    if (content) return $cnSS2$ariahidden.hideOthers(content);
  }, []);
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuContentImpl, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({}, props, {
    ref: composedRefs // we make sure we're not trapping once it's been closed
    ,

    trapFocus: context.open // make sure to only disable pointer events when open
    ,

    disableOutsidePointerEvents: context.open,
    disableOutsideScroll: true // When focus is trapped, a `focusout` event may still happen.
    ,

    onFocusOutside: $cnSS2$radixuiprimitive.composeEventHandlers(props.onFocusOutside, event => event.preventDefault(), {
      checkForDefaultPrevented: false
    }),
    onDismiss: () => context.onOpenChange(false)
  }));
});
const $213e4d2df823067d$var$MenuRootContentNonModal = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const context = $213e4d2df823067d$var$useMenuContext($213e4d2df823067d$var$CONTENT_NAME, props.__scopeMenu);
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuContentImpl, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({}, props, {
    ref: forwardedRef,
    trapFocus: false,
    disableOutsidePointerEvents: false,
    disableOutsideScroll: false,
    onDismiss: () => context.onOpenChange(false)
  }));
});
/* ---------------------------------------------------------------------------------------------- */
const $213e4d2df823067d$var$MenuContentImpl = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeMenu: __scopeMenu,
    loop = false,
    trapFocus: trapFocus,
    onOpenAutoFocus: onOpenAutoFocus,
    onCloseAutoFocus: onCloseAutoFocus,
    disableOutsidePointerEvents: disableOutsidePointerEvents,
    onEntryFocus: onEntryFocus,
    onEscapeKeyDown: onEscapeKeyDown,
    onPointerDownOutside: onPointerDownOutside,
    onFocusOutside: onFocusOutside,
    onInteractOutside: onInteractOutside,
    onDismiss: onDismiss,
    disableOutsideScroll: disableOutsideScroll,
    ...contentProps
  } = props;
  const context = $213e4d2df823067d$var$useMenuContext($213e4d2df823067d$var$CONTENT_NAME, __scopeMenu);
  const rootContext = $213e4d2df823067d$var$useMenuRootContext($213e4d2df823067d$var$CONTENT_NAME, __scopeMenu);
  const popperScope = $213e4d2df823067d$var$usePopperScope(__scopeMenu);
  const rovingFocusGroupScope = $213e4d2df823067d$var$useRovingFocusGroupScope(__scopeMenu);
  const getItems = $213e4d2df823067d$var$useCollection(__scopeMenu);
  const [currentItemId, setCurrentItemId] = $cnSS2$react.useState(null);
  const contentRef = $cnSS2$react.useRef(null);
  const composedRefs = $cnSS2$radixuireactcomposerefs.useComposedRefs(forwardedRef, contentRef, context.onContentChange);
  const timerRef = $cnSS2$react.useRef(0);
  const searchRef = $cnSS2$react.useRef('');
  const pointerGraceTimerRef = $cnSS2$react.useRef(0);
  const pointerGraceIntentRef = $cnSS2$react.useRef(null);
  const pointerDirRef = $cnSS2$react.useRef('right');
  const lastPointerXRef = $cnSS2$react.useRef(0);
  const ScrollLockWrapper = disableOutsideScroll ? $cnSS2$reactremovescroll.RemoveScroll : $cnSS2$react.Fragment;
  const scrollLockWrapperProps = disableOutsideScroll ? {
    as: $cnSS2$radixuireactslot.Slot,
    allowPinchZoom: true
  } : undefined;
  const handleTypeaheadSearch = key => {
    var _items$find, _items$find2;
    const search = searchRef.current + key;
    const items = getItems().filter(item => !item.disabled);
    const currentItem = document.activeElement;
    const currentMatch = (_items$find = items.find(item => item.ref.current === currentItem)) === null || _items$find === void 0 ? void 0 : _items$find.textValue;
    const values = items.map(item => item.textValue);
    const nextMatch = $213e4d2df823067d$var$getNextMatch(values, search, currentMatch);
    const newItem = (_items$find2 = items.find(item => item.textValue === nextMatch)) === null || _items$find2 === void 0 ? void 0 : _items$find2.ref.current; // Reset `searchRef` 1 second after it was last updated
    (function updateSearch(value) {
      searchRef.current = value;
      window.clearTimeout(timerRef.current);
      if (value !== '') timerRef.current = window.setTimeout(() => updateSearch(''), 1000);
    })(search);
    if (newItem)
      /**
      * Imperative focus during keydown is risky so we prevent React's batching updates
      * to avoid potential bugs. See: https://github.com/facebook/react/issues/20332
      */
      setTimeout(() => newItem.focus());
  };
  $cnSS2$react.useEffect(() => {
    return () => window.clearTimeout(timerRef.current);
  }, []); // Make sure the whole tree has focus guards as our `MenuContent` may be
  // the last element in the DOM (beacuse of the `Portal`)
  $cnSS2$radixuireactfocusguards.useFocusGuards();
  const isPointerMovingToSubmenu = $cnSS2$react.useCallback(event => {
    var _pointerGraceIntentRe, _pointerGraceIntentRe2;
    const isMovingTowards = pointerDirRef.current === ((_pointerGraceIntentRe = pointerGraceIntentRef.current) === null || _pointerGraceIntentRe === void 0 ? void 0 : _pointerGraceIntentRe.side);
    return isMovingTowards && $213e4d2df823067d$var$isPointerInGraceArea(event, (_pointerGraceIntentRe2 = pointerGraceIntentRef.current) === null || _pointerGraceIntentRe2 === void 0 ? void 0 : _pointerGraceIntentRe2.area);
  }, []);
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuContentProvider, {
    scope: __scopeMenu,
    searchRef: searchRef,
    onItemEnter: $cnSS2$react.useCallback(event => {
      if (isPointerMovingToSubmenu(event)) event.preventDefault();
    }, [isPointerMovingToSubmenu]),
    onItemLeave: $cnSS2$react.useCallback(event => {
      var _contentRef$current;
      if (isPointerMovingToSubmenu(event)) return;
      (_contentRef$current = contentRef.current) === null || _contentRef$current === void 0 || _contentRef$current.focus();
      setCurrentItemId(null);
    }, [isPointerMovingToSubmenu]),
    onTriggerLeave: $cnSS2$react.useCallback(event => {
      if (isPointerMovingToSubmenu(event)) event.preventDefault();
    }, [isPointerMovingToSubmenu]),
    pointerGraceTimerRef: pointerGraceTimerRef,
    onPointerGraceIntentChange: $cnSS2$react.useCallback(intent => {
      pointerGraceIntentRef.current = intent;
    }, [])
  }, /*#__PURE__*/$cnSS2$react.createElement(ScrollLockWrapper, scrollLockWrapperProps, /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactfocusscope.FocusScope, {
    asChild: true,
    trapped: trapFocus,
    onMountAutoFocus: $cnSS2$radixuiprimitive.composeEventHandlers(onOpenAutoFocus, event => {
      var _contentRef$current2;
      // when opening, explicitly focus the content area only and leave
      // `onEntryFocus` in  control of focusing first item
      event.preventDefault();
      (_contentRef$current2 = contentRef.current) === null || _contentRef$current2 === void 0 || _contentRef$current2.focus();
    }),
    onUnmountAutoFocus: onCloseAutoFocus
  }, /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactdismissablelayer.DismissableLayer, {
    asChild: true,
    disableOutsidePointerEvents: disableOutsidePointerEvents,
    onEscapeKeyDown: onEscapeKeyDown,
    onPointerDownOutside: onPointerDownOutside,
    onFocusOutside: onFocusOutside,
    onInteractOutside: onInteractOutside,
    onDismiss: onDismiss
  }, /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactrovingfocus.Root, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({
    asChild: true
  }, rovingFocusGroupScope, {
    dir: rootContext.dir,
    orientation: "vertical",
    loop: loop,
    currentTabStopId: currentItemId,
    onCurrentTabStopIdChange: setCurrentItemId,
    onEntryFocus: $cnSS2$radixuiprimitive.composeEventHandlers(onEntryFocus, event => {
      // only focus first item when using keyboard
      if (!rootContext.isUsingKeyboardRef.current) event.preventDefault();
    })
  }), /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactpopper.Content, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({
    role: "menu",
    "aria-orientation": "vertical",
    "data-state": $213e4d2df823067d$var$getOpenState(context.open),
    "data-radix-menu-content": "",
    dir: rootContext.dir
  }, popperScope, contentProps, {
    ref: composedRefs,
    style: {
      outline: 'none',
      ...contentProps.style
    },
    onKeyDown: $cnSS2$radixuiprimitive.composeEventHandlers(contentProps.onKeyDown, event => {
      // submenu key events bubble through portals. We only care about keys in this menu.
      const target = event.target;
      const isKeyDownInside = target.closest('[data-radix-menu-content]') === event.currentTarget;
      const isModifierKey = event.ctrlKey || event.altKey || event.metaKey;
      const isCharacterKey = event.key.length === 1;
      if (isKeyDownInside) {
        // menus should not be navigated using tab key so we prevent it
        if (event.key === 'Tab') event.preventDefault();
        if (!isModifierKey && isCharacterKey) handleTypeaheadSearch(event.key);
      } // focus first/last item based on key pressed
      const content = contentRef.current;
      if (event.target !== content) return;
      if (!$213e4d2df823067d$var$FIRST_LAST_KEYS.includes(event.key)) return;
      event.preventDefault();
      const items = getItems().filter(item => !item.disabled);
      const candidateNodes = items.map(item => item.ref.current);
      if ($213e4d2df823067d$var$LAST_KEYS.includes(event.key)) candidateNodes.reverse();
      $213e4d2df823067d$var$focusFirst(candidateNodes);
    }),
    onBlur: $cnSS2$radixuiprimitive.composeEventHandlers(props.onBlur, event => {
      // clear search buffer when leaving the menu
      if (!event.currentTarget.contains(event.target)) {
        window.clearTimeout(timerRef.current);
        searchRef.current = '';
      }
    }),
    onPointerMove: $cnSS2$radixuiprimitive.composeEventHandlers(props.onPointerMove, $213e4d2df823067d$var$whenMouse(event => {
      const target = event.target;
      const pointerXHasChanged = lastPointerXRef.current !== event.clientX; // We don't use `event.movementX` for this check because Safari will
      // always return `0` on a pointer event.
      if (event.currentTarget.contains(target) && pointerXHasChanged) {
        const newDir = event.clientX > lastPointerXRef.current ? 'right' : 'left';
        pointerDirRef.current = newDir;
        lastPointerXRef.current = event.clientX;
      }
    }))
  })))))));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$479f0f2f71193efe, {
  displayName: $213e4d2df823067d$var$CONTENT_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuGroup
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$GROUP_NAME = 'MenuGroup';
const $213e4d2df823067d$export$22a631d1f72787bb = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeMenu: __scopeMenu,
    ...groupProps
  } = props;
  return /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactprimitive.Primitive.div, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({
    role: "group"
  }, groupProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$22a631d1f72787bb, {
  displayName: $213e4d2df823067d$var$GROUP_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuLabel
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$LABEL_NAME = 'MenuLabel';
const $213e4d2df823067d$export$dd37bec0e8a99143 = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeMenu: __scopeMenu,
    ...labelProps
  } = props;
  return /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactprimitive.Primitive.div, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({}, labelProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$dd37bec0e8a99143, {
  displayName: $213e4d2df823067d$var$LABEL_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuItem
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$ITEM_NAME = 'MenuItem';
const $213e4d2df823067d$var$ITEM_SELECT = 'menu.itemSelect';
const $213e4d2df823067d$export$2ce376c2cc3355c8 = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    disabled = false,
    onSelect: onSelect,
    ...itemProps
  } = props;
  const ref = $cnSS2$react.useRef(null);
  const rootContext = $213e4d2df823067d$var$useMenuRootContext($213e4d2df823067d$var$ITEM_NAME, props.__scopeMenu);
  const contentContext = $213e4d2df823067d$var$useMenuContentContext($213e4d2df823067d$var$ITEM_NAME, props.__scopeMenu);
  const composedRefs = $cnSS2$radixuireactcomposerefs.useComposedRefs(forwardedRef, ref);
  const isPointerDownRef = $cnSS2$react.useRef(false);
  const handleSelect = () => {
    const menuItem = ref.current;
    if (!disabled && menuItem) {
      const itemSelectEvent = new CustomEvent($213e4d2df823067d$var$ITEM_SELECT, {
        bubbles: true,
        cancelable: true
      });
      menuItem.addEventListener($213e4d2df823067d$var$ITEM_SELECT, event => onSelect === null || onSelect === void 0 ? void 0 : onSelect(event), {
        once: true
      });
      $cnSS2$radixuireactprimitive.dispatchDiscreteCustomEvent(menuItem, itemSelectEvent);
      if (itemSelectEvent.defaultPrevented) isPointerDownRef.current = false;else rootContext.onClose();
    }
  };
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuItemImpl, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({}, itemProps, {
    ref: composedRefs,
    disabled: disabled,
    onClick: $cnSS2$radixuiprimitive.composeEventHandlers(props.onClick, handleSelect),
    onPointerDown: event => {
      var _props$onPointerDown;
      (_props$onPointerDown = props.onPointerDown) === null || _props$onPointerDown === void 0 || _props$onPointerDown.call(props, event);
      isPointerDownRef.current = true;
    },
    onPointerUp: $cnSS2$radixuiprimitive.composeEventHandlers(props.onPointerUp, event => {
      var _event$currentTarget;
      // Pointer down can move to a different menu item which should activate it on pointer up.
      // We dispatch a click for selection to allow composition with click based triggers and to
      // prevent Firefox from getting stuck in text selection mode when the menu closes.
      if (!isPointerDownRef.current) (_event$currentTarget = event.currentTarget) === null || _event$currentTarget === void 0 || _event$currentTarget.click();
    }),
    onKeyDown: $cnSS2$radixuiprimitive.composeEventHandlers(props.onKeyDown, event => {
      const isTypingAhead = contentContext.searchRef.current !== '';
      if (disabled || isTypingAhead && event.key === ' ') return;
      if ($213e4d2df823067d$var$SELECTION_KEYS.includes(event.key)) {
        event.currentTarget.click();
        /**
        * We prevent default browser behaviour for selection keys as they should trigger
        * a selection only:
        * - prevents space from scrolling the page.
        * - if keydown causes focus to move, prevents keydown from firing on the new target.
        */
        event.preventDefault();
      }
    })
  }));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$2ce376c2cc3355c8, {
  displayName: $213e4d2df823067d$var$ITEM_NAME
});
/* ---------------------------------------------------------------------------------------------- */
const $213e4d2df823067d$var$MenuItemImpl = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeMenu: __scopeMenu,
    disabled = false,
    textValue: textValue,
    ...itemProps
  } = props;
  const contentContext = $213e4d2df823067d$var$useMenuContentContext($213e4d2df823067d$var$ITEM_NAME, __scopeMenu);
  const rovingFocusGroupScope = $213e4d2df823067d$var$useRovingFocusGroupScope(__scopeMenu);
  const ref = $cnSS2$react.useRef(null);
  const composedRefs = $cnSS2$radixuireactcomposerefs.useComposedRefs(forwardedRef, ref);
  const [isFocused, setIsFocused] = $cnSS2$react.useState(false); // get the item's `.textContent` as default strategy for typeahead `textValue`
  const [textContent, setTextContent] = $cnSS2$react.useState('');
  $cnSS2$react.useEffect(() => {
    const menuItem = ref.current;
    if (menuItem) {
      var _menuItem$textContent;
      setTextContent(((_menuItem$textContent = menuItem.textContent) !== null && _menuItem$textContent !== void 0 ? _menuItem$textContent : '').trim());
    }
  }, [itemProps.children]);
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$Collection.ItemSlot, {
    scope: __scopeMenu,
    disabled: disabled,
    textValue: textValue !== null && textValue !== void 0 ? textValue : textContent
  }, /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactrovingfocus.Item, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({
    asChild: true
  }, rovingFocusGroupScope, {
    focusable: !disabled
  }), /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactprimitive.Primitive.div, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({
    role: "menuitem",
    "data-highlighted": isFocused ? '' : undefined,
    "aria-disabled": disabled || undefined,
    "data-disabled": disabled ? '' : undefined
  }, itemProps, {
    ref: composedRefs,
    onPointerMove: $cnSS2$radixuiprimitive.composeEventHandlers(props.onPointerMove, $213e4d2df823067d$var$whenMouse(event => {
      if (disabled) contentContext.onItemLeave(event);else {
        contentContext.onItemEnter(event);
        if (!event.defaultPrevented) {
          const item = event.currentTarget;
          item.focus();
        }
      }
    })),
    onPointerLeave: $cnSS2$radixuiprimitive.composeEventHandlers(props.onPointerLeave, $213e4d2df823067d$var$whenMouse(event => contentContext.onItemLeave(event))),
    onFocus: $cnSS2$radixuiprimitive.composeEventHandlers(props.onFocus, () => setIsFocused(true)),
    onBlur: $cnSS2$radixuiprimitive.composeEventHandlers(props.onBlur, () => setIsFocused(false))
  }))));
});
/* -------------------------------------------------------------------------------------------------
 * MenuCheckboxItem
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$CHECKBOX_ITEM_NAME = 'MenuCheckboxItem';
const $213e4d2df823067d$export$f6f243521332502d = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    checked = false,
    onCheckedChange: onCheckedChange,
    ...checkboxItemProps
  } = props;
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$ItemIndicatorProvider, {
    scope: props.__scopeMenu,
    checked: checked
  }, /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$export$2ce376c2cc3355c8, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({
    role: "menuitemcheckbox",
    "aria-checked": $213e4d2df823067d$var$isIndeterminate(checked) ? 'mixed' : checked
  }, checkboxItemProps, {
    ref: forwardedRef,
    "data-state": $213e4d2df823067d$var$getCheckedState(checked),
    onSelect: $cnSS2$radixuiprimitive.composeEventHandlers(checkboxItemProps.onSelect, () => onCheckedChange === null || onCheckedChange === void 0 ? void 0 : onCheckedChange($213e4d2df823067d$var$isIndeterminate(checked) ? true : !checked), {
      checkForDefaultPrevented: false
    })
  })));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$f6f243521332502d, {
  displayName: $213e4d2df823067d$var$CHECKBOX_ITEM_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuRadioGroup
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$RADIO_GROUP_NAME = 'MenuRadioGroup';
const [$213e4d2df823067d$var$RadioGroupProvider, $213e4d2df823067d$var$useRadioGroupContext] = $213e4d2df823067d$var$createMenuContext($213e4d2df823067d$var$RADIO_GROUP_NAME, {
  value: undefined,
  onValueChange: () => {}
});
const $213e4d2df823067d$export$ea2200c9eee416b3 = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    value: value,
    onValueChange: onValueChange,
    ...groupProps
  } = props;
  const handleValueChange = $cnSS2$radixuireactusecallbackref.useCallbackRef(onValueChange);
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$RadioGroupProvider, {
    scope: props.__scopeMenu,
    value: value,
    onValueChange: handleValueChange
  }, /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$export$22a631d1f72787bb, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({}, groupProps, {
    ref: forwardedRef
  })));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$ea2200c9eee416b3, {
  displayName: $213e4d2df823067d$var$RADIO_GROUP_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuRadioItem
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$RADIO_ITEM_NAME = 'MenuRadioItem';
const $213e4d2df823067d$export$69bd225e9817f6d0 = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    value: value,
    ...radioItemProps
  } = props;
  const context = $213e4d2df823067d$var$useRadioGroupContext($213e4d2df823067d$var$RADIO_ITEM_NAME, props.__scopeMenu);
  const checked = value === context.value;
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$ItemIndicatorProvider, {
    scope: props.__scopeMenu,
    checked: checked
  }, /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$export$2ce376c2cc3355c8, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({
    role: "menuitemradio",
    "aria-checked": checked
  }, radioItemProps, {
    ref: forwardedRef,
    "data-state": $213e4d2df823067d$var$getCheckedState(checked),
    onSelect: $cnSS2$radixuiprimitive.composeEventHandlers(radioItemProps.onSelect, () => {
      var _context$onValueChang;
      return (_context$onValueChang = context.onValueChange) === null || _context$onValueChang === void 0 ? void 0 : _context$onValueChang.call(context, value);
    }, {
      checkForDefaultPrevented: false
    })
  })));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$69bd225e9817f6d0, {
  displayName: $213e4d2df823067d$var$RADIO_ITEM_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuItemIndicator
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$ITEM_INDICATOR_NAME = 'MenuItemIndicator';
const [$213e4d2df823067d$var$ItemIndicatorProvider, $213e4d2df823067d$var$useItemIndicatorContext] = $213e4d2df823067d$var$createMenuContext($213e4d2df823067d$var$ITEM_INDICATOR_NAME, {
  checked: false
});
const $213e4d2df823067d$export$a2593e23056970a3 = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeMenu: __scopeMenu,
    forceMount: forceMount,
    ...itemIndicatorProps
  } = props;
  const indicatorContext = $213e4d2df823067d$var$useItemIndicatorContext($213e4d2df823067d$var$ITEM_INDICATOR_NAME, __scopeMenu);
  return /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactpresence.Presence, {
    present: forceMount || $213e4d2df823067d$var$isIndeterminate(indicatorContext.checked) || indicatorContext.checked === true
  }, /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactprimitive.Primitive.span, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({}, itemIndicatorProps, {
    ref: forwardedRef,
    "data-state": $213e4d2df823067d$var$getCheckedState(indicatorContext.checked)
  })));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$a2593e23056970a3, {
  displayName: $213e4d2df823067d$var$ITEM_INDICATOR_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuSeparator
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$SEPARATOR_NAME = 'MenuSeparator';
const $213e4d2df823067d$export$1cec7dcdd713e220 = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeMenu: __scopeMenu,
    ...separatorProps
  } = props;
  return /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactprimitive.Primitive.div, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({
    role: "separator",
    "aria-orientation": "horizontal"
  }, separatorProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$1cec7dcdd713e220, {
  displayName: $213e4d2df823067d$var$SEPARATOR_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuArrow
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$ARROW_NAME = 'MenuArrow';
const $213e4d2df823067d$export$bcdda4773debf5fa = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeMenu: __scopeMenu,
    ...arrowProps
  } = props;
  const popperScope = $213e4d2df823067d$var$usePopperScope(__scopeMenu);
  return /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactpopper.Arrow, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({}, popperScope, arrowProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$bcdda4773debf5fa, {
  displayName: $213e4d2df823067d$var$ARROW_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuSub
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$SUB_NAME = 'MenuSub';
const [$213e4d2df823067d$var$MenuSubProvider, $213e4d2df823067d$var$useMenuSubContext] = $213e4d2df823067d$var$createMenuContext($213e4d2df823067d$var$SUB_NAME);
const $213e4d2df823067d$export$71bdb9d1e2909932 = props => {
  const {
    __scopeMenu: __scopeMenu,
    children: children,
    open = false,
    onOpenChange: onOpenChange
  } = props;
  const parentMenuContext = $213e4d2df823067d$var$useMenuContext($213e4d2df823067d$var$SUB_NAME, __scopeMenu);
  const popperScope = $213e4d2df823067d$var$usePopperScope(__scopeMenu);
  const [trigger, setTrigger] = $cnSS2$react.useState(null);
  const [content, setContent] = $cnSS2$react.useState(null);
  const handleOpenChange = $cnSS2$radixuireactusecallbackref.useCallbackRef(onOpenChange); // Prevent the parent menu from reopening with open submenus.
  $cnSS2$react.useEffect(() => {
    if (parentMenuContext.open === false) handleOpenChange(false);
    return () => handleOpenChange(false);
  }, [parentMenuContext.open, handleOpenChange]);
  return /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactpopper.Root, popperScope, /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuProvider, {
    scope: __scopeMenu,
    open: open,
    onOpenChange: handleOpenChange,
    content: content,
    onContentChange: setContent
  }, /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuSubProvider, {
    scope: __scopeMenu,
    contentId: $cnSS2$radixuireactid.useId(),
    triggerId: $cnSS2$radixuireactid.useId(),
    trigger: trigger,
    onTriggerChange: setTrigger
  }, children)));
};
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$71bdb9d1e2909932, {
  displayName: $213e4d2df823067d$var$SUB_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuSubTrigger
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$SUB_TRIGGER_NAME = 'MenuSubTrigger';
const $213e4d2df823067d$export$5fbbb3ba7297405f = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const context = $213e4d2df823067d$var$useMenuContext($213e4d2df823067d$var$SUB_TRIGGER_NAME, props.__scopeMenu);
  const rootContext = $213e4d2df823067d$var$useMenuRootContext($213e4d2df823067d$var$SUB_TRIGGER_NAME, props.__scopeMenu);
  const subContext = $213e4d2df823067d$var$useMenuSubContext($213e4d2df823067d$var$SUB_TRIGGER_NAME, props.__scopeMenu);
  const contentContext = $213e4d2df823067d$var$useMenuContentContext($213e4d2df823067d$var$SUB_TRIGGER_NAME, props.__scopeMenu);
  const openTimerRef = $cnSS2$react.useRef(null);
  const {
    pointerGraceTimerRef: pointerGraceTimerRef,
    onPointerGraceIntentChange: onPointerGraceIntentChange
  } = contentContext;
  const scope = {
    __scopeMenu: props.__scopeMenu
  };
  const clearOpenTimer = $cnSS2$react.useCallback(() => {
    if (openTimerRef.current) window.clearTimeout(openTimerRef.current);
    openTimerRef.current = null;
  }, []);
  $cnSS2$react.useEffect(() => clearOpenTimer, [clearOpenTimer]);
  $cnSS2$react.useEffect(() => {
    const pointerGraceTimer = pointerGraceTimerRef.current;
    return () => {
      window.clearTimeout(pointerGraceTimer);
      onPointerGraceIntentChange(null);
    };
  }, [pointerGraceTimerRef, onPointerGraceIntentChange]);
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$export$9fa5ebd18bee4d43, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({
    asChild: true
  }, scope), /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuItemImpl, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({
    id: subContext.triggerId,
    "aria-haspopup": "menu",
    "aria-expanded": context.open,
    "aria-controls": subContext.contentId,
    "data-state": $213e4d2df823067d$var$getOpenState(context.open)
  }, props, {
    ref: $cnSS2$radixuireactcomposerefs.composeRefs(forwardedRef, subContext.onTriggerChange) // This is redundant for mouse users but we cannot determine pointer type from
    ,

    onClick: event => {
      var _props$onClick;
      (_props$onClick = props.onClick) === null || _props$onClick === void 0 || _props$onClick.call(props, event);
      if (props.disabled || event.defaultPrevented) return;
      /**
      * We manually focus because iOS Safari doesn't always focus on click (e.g. buttons)
      * and we rely heavily on `onFocusOutside` for submenus to close when switching
      * between separate submenus.
      */
      event.currentTarget.focus();
      if (!context.open) context.onOpenChange(true);
    },
    onPointerMove: $cnSS2$radixuiprimitive.composeEventHandlers(props.onPointerMove, $213e4d2df823067d$var$whenMouse(event => {
      contentContext.onItemEnter(event);
      if (event.defaultPrevented) return;
      if (!props.disabled && !context.open && !openTimerRef.current) {
        contentContext.onPointerGraceIntentChange(null);
        openTimerRef.current = window.setTimeout(() => {
          context.onOpenChange(true);
          clearOpenTimer();
        }, 100);
      }
    })),
    onPointerLeave: $cnSS2$radixuiprimitive.composeEventHandlers(props.onPointerLeave, $213e4d2df823067d$var$whenMouse(event => {
      var _context$content;
      clearOpenTimer();
      const contentRect = (_context$content = context.content) === null || _context$content === void 0 ? void 0 : _context$content.getBoundingClientRect();
      if (contentRect) {
        var _context$content2;
        // TODO: make sure to update this when we change positioning logic
        const side = (_context$content2 = context.content) === null || _context$content2 === void 0 ? void 0 : _context$content2.dataset.side;
        const rightSide = side === 'right';
        const bleed = rightSide ? -5 : 5;
        const contentNearEdge = contentRect[rightSide ? 'left' : 'right'];
        const contentFarEdge = contentRect[rightSide ? 'right' : 'left'];
        contentContext.onPointerGraceIntentChange({
          area: [
          // consistently within polygon bounds
          {
            x: event.clientX + bleed,
            y: event.clientY
          }, {
            x: contentNearEdge,
            y: contentRect.top
          }, {
            x: contentFarEdge,
            y: contentRect.top
          }, {
            x: contentFarEdge,
            y: contentRect.bottom
          }, {
            x: contentNearEdge,
            y: contentRect.bottom
          }],
          side: side
        });
        window.clearTimeout(pointerGraceTimerRef.current);
        pointerGraceTimerRef.current = window.setTimeout(() => contentContext.onPointerGraceIntentChange(null), 300);
      } else {
        contentContext.onTriggerLeave(event);
        if (event.defaultPrevented) return; // There's 100ms where the user may leave an item before the submenu was opened.
        contentContext.onPointerGraceIntentChange(null);
      }
    })),
    onKeyDown: $cnSS2$radixuiprimitive.composeEventHandlers(props.onKeyDown, event => {
      const isTypingAhead = contentContext.searchRef.current !== '';
      if (props.disabled || isTypingAhead && event.key === ' ') return;
      if ($213e4d2df823067d$var$SUB_OPEN_KEYS[rootContext.dir].includes(event.key)) {
        var _context$content3;
        context.onOpenChange(true); // The trigger may hold focus if opened via pointer interaction
        // so we ensure content is given focus again when switching to keyboard.
        (_context$content3 = context.content) === null || _context$content3 === void 0 || _context$content3.focus(); // prevent window from scrolling
        event.preventDefault();
      }
    })
  })));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$5fbbb3ba7297405f, {
  displayName: $213e4d2df823067d$var$SUB_TRIGGER_NAME
});
/* -------------------------------------------------------------------------------------------------
 * MenuSubContent
 * -----------------------------------------------------------------------------------------------*/
const $213e4d2df823067d$var$SUB_CONTENT_NAME = 'MenuSubContent';
const $213e4d2df823067d$export$e7142ab31822bde6 = /*#__PURE__*/$cnSS2$react.forwardRef((props, forwardedRef) => {
  const portalContext = $213e4d2df823067d$var$usePortalContext($213e4d2df823067d$var$CONTENT_NAME, props.__scopeMenu);
  const {
    forceMount = portalContext.forceMount,
    ...subContentProps
  } = props;
  const context = $213e4d2df823067d$var$useMenuContext($213e4d2df823067d$var$CONTENT_NAME, props.__scopeMenu);
  const rootContext = $213e4d2df823067d$var$useMenuRootContext($213e4d2df823067d$var$CONTENT_NAME, props.__scopeMenu);
  const subContext = $213e4d2df823067d$var$useMenuSubContext($213e4d2df823067d$var$SUB_CONTENT_NAME, props.__scopeMenu);
  const ref = $cnSS2$react.useRef(null);
  const composedRefs = $cnSS2$radixuireactcomposerefs.useComposedRefs(forwardedRef, ref);
  return /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$Collection.Provider, {
    scope: props.__scopeMenu
  }, /*#__PURE__*/$cnSS2$react.createElement($cnSS2$radixuireactpresence.Presence, {
    present: forceMount || context.open
  }, /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$Collection.Slot, {
    scope: props.__scopeMenu
  }, /*#__PURE__*/$cnSS2$react.createElement($213e4d2df823067d$var$MenuContentImpl, $parcel$interopDefault($cnSS2$babelruntimehelpersextends)({
    id: subContext.contentId,
    "aria-labelledby": subContext.triggerId
  }, subContentProps, {
    ref: composedRefs,
    align: "start",
    side: rootContext.dir === 'rtl' ? 'left' : 'right',
    disableOutsidePointerEvents: false,
    disableOutsideScroll: false,
    trapFocus: false,
    onOpenAutoFocus: event => {
      var _ref$current;
      // when opening a submenu, focus content for keyboard users only
      if (rootContext.isUsingKeyboardRef.current) (_ref$current = ref.current) === null || _ref$current === void 0 || _ref$current.focus();
      event.preventDefault();
    } // The menu might close because of focusing another menu item in the parent menu. We
    ,

    onCloseAutoFocus: event => event.preventDefault(),
    onFocusOutside: $cnSS2$radixuiprimitive.composeEventHandlers(props.onFocusOutside, event => {
      // We prevent closing when the trigger is focused to avoid triggering a re-open animation
      // on pointer interaction.
      if (event.target !== subContext.trigger) context.onOpenChange(false);
    }),
    onEscapeKeyDown: $cnSS2$radixuiprimitive.composeEventHandlers(props.onEscapeKeyDown, event => {
      rootContext.onClose(); // ensure pressing escape in submenu doesn't escape full screen mode
      event.preventDefault();
    }),
    onKeyDown: $cnSS2$radixuiprimitive.composeEventHandlers(props.onKeyDown, event => {
      // Submenu key events bubble through portals. We only care about keys in this menu.
      const isKeyDownInside = event.currentTarget.contains(event.target);
      const isCloseKey = $213e4d2df823067d$var$SUB_CLOSE_KEYS[rootContext.dir].includes(event.key);
      if (isKeyDownInside && isCloseKey) {
        var _subContext$trigger;
        context.onOpenChange(false); // We focus manually because we prevented it in `onCloseAutoFocus`
        (_subContext$trigger = subContext.trigger) === null || _subContext$trigger === void 0 || _subContext$trigger.focus(); // prevent window from scrolling
        event.preventDefault();
      }
    })
  })))));
});
/*#__PURE__*/
Object.assign($213e4d2df823067d$export$e7142ab31822bde6, {
  displayName: $213e4d2df823067d$var$SUB_CONTENT_NAME
});
/* -----------------------------------------------------------------------------------------------*/
function $213e4d2df823067d$var$getOpenState(open) {
  return open ? 'open' : 'closed';
}
function $213e4d2df823067d$var$isIndeterminate(checked) {
  return checked === 'indeterminate';
}
function $213e4d2df823067d$var$getCheckedState(checked) {
  return $213e4d2df823067d$var$isIndeterminate(checked) ? 'indeterminate' : checked ? 'checked' : 'unchecked';
}
function $213e4d2df823067d$var$focusFirst(candidates) {
  const PREVIOUSLY_FOCUSED_ELEMENT = document.activeElement;
  for (const candidate of candidates) {
    // if focus is already where we want to go, we don't want to keep going through the candidates
    if (candidate === PREVIOUSLY_FOCUSED_ELEMENT) return;
    candidate.focus();
    if (document.activeElement !== PREVIOUSLY_FOCUSED_ELEMENT) return;
  }
}
/**
 * Wraps an array around itself at a given start index
 * Example: `wrapArray(['a', 'b', 'c', 'd'], 2) === ['c', 'd', 'a', 'b']`
 */
function $213e4d2df823067d$var$wrapArray(array, startIndex) {
  return array.map((_, index) => array[(startIndex + index) % array.length]);
}
/**
 * This is the "meat" of the typeahead matching logic. It takes in all the values,
 * the search and the current match, and returns the next match (or `undefined`).
 *
 * We normalize the search because if a user has repeatedly pressed a character,
 * we want the exact same behavior as if we only had that one character
 * (ie. cycle through options starting with that character)
 *
 * We also reorder the values by wrapping the array around the current match.
 * This is so we always look forward from the current match, and picking the first
 * match will always be the correct one.
 *
 * Finally, if the normalized search is exactly one character, we exclude the
 * current match from the values because otherwise it would be the first to match always
 * and focus would never move. This is as opposed to the regular case, where we
 * don't want focus to move if the current match still matches.
 */
function $213e4d2df823067d$var$getNextMatch(values, search, currentMatch) {
  const isRepeated = search.length > 1 && Array.from(search).every(char => char === search[0]);
  const normalizedSearch = isRepeated ? search[0] : search;
  const currentMatchIndex = currentMatch ? values.indexOf(currentMatch) : -1;
  let wrappedValues = $213e4d2df823067d$var$wrapArray(values, Math.max(currentMatchIndex, 0));
  const excludeCurrentMatch = normalizedSearch.length === 1;
  if (excludeCurrentMatch) wrappedValues = wrappedValues.filter(v => v !== currentMatch);
  const nextMatch = wrappedValues.find(value => value.toLowerCase().startsWith(normalizedSearch.toLowerCase()));
  return nextMatch !== currentMatch ? nextMatch : undefined;
}
// Determine if a point is inside of a polygon.
// Based on https://github.com/substack/point-in-polygon
function $213e4d2df823067d$var$isPointInPolygon(point, polygon) {
  const {
    x: x,
    y: y
  } = point;
  let inside = false;
  for (let i = 0, j = polygon.length - 1; i < polygon.length; j = i++) {
    const xi = polygon[i].x;
    const yi = polygon[i].y;
    const xj = polygon[j].x;
    const yj = polygon[j].y; // prettier-ignore
    const intersect = yi > y !== yj > y && x < (xj - xi) * (y - yi) / (yj - yi) + xi;
    if (intersect) inside = !inside;
  }
  return inside;
}
function $213e4d2df823067d$var$isPointerInGraceArea(event, area) {
  if (!area) return false;
  const cursorPos = {
    x: event.clientX,
    y: event.clientY
  };
  return $213e4d2df823067d$var$isPointInPolygon(cursorPos, area);
}
function $213e4d2df823067d$var$whenMouse(handler) {
  return event => event.pointerType === 'mouse' ? handler(event) : undefined;
}
const $213e4d2df823067d$export$be92b6f5f03c0fe9 = $213e4d2df823067d$export$d9b273488cd8ce6f;
const $213e4d2df823067d$export$b688253958b8dfe7 = $213e4d2df823067d$export$9fa5ebd18bee4d43;
const $213e4d2df823067d$export$602eac185826482c = $213e4d2df823067d$export$793392f970497feb;
const $213e4d2df823067d$export$7c6e2c02157bb7d2 = $213e4d2df823067d$export$479f0f2f71193efe;
const $213e4d2df823067d$export$eb2fcfdbd7ba97d4 = $213e4d2df823067d$export$22a631d1f72787bb;
const $213e4d2df823067d$export$b04be29aa201d4f5 = $213e4d2df823067d$export$dd37bec0e8a99143;
const $213e4d2df823067d$export$6d08773d2e66f8f2 = $213e4d2df823067d$export$2ce376c2cc3355c8;
const $213e4d2df823067d$export$16ce288f89fa631c = $213e4d2df823067d$export$f6f243521332502d;
const $213e4d2df823067d$export$a98f0dcb43a68a25 = $213e4d2df823067d$export$ea2200c9eee416b3;
const $213e4d2df823067d$export$371ab307eab489c0 = $213e4d2df823067d$export$69bd225e9817f6d0;
const $213e4d2df823067d$export$c3468e2714d175fa = $213e4d2df823067d$export$a2593e23056970a3;
const $213e4d2df823067d$export$1ff3c3f08ae963c0 = $213e4d2df823067d$export$1cec7dcdd713e220;
const $213e4d2df823067d$export$21b07c8f274aebd5 = $213e4d2df823067d$export$bcdda4773debf5fa;
const $213e4d2df823067d$export$d7a01e11500dfb6f = $213e4d2df823067d$export$71bdb9d1e2909932;
const $213e4d2df823067d$export$2ea8a7a591ac5eac = $213e4d2df823067d$export$5fbbb3ba7297405f;
const $213e4d2df823067d$export$6d4de93b380beddf = $213e4d2df823067d$export$e7142ab31822bde6;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-popper/dist/index.js":
/*!******************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-popper/dist/index.js ***!
  \******************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $50Iv9$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $50Iv9$react = __webpack_require__(/*! react */ "react");
var $50Iv9$floatinguireactdom = __webpack_require__(/*! @floating-ui/react-dom */ "../../../node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.esm.js");
var $50Iv9$radixuireactarrow = __webpack_require__(/*! @radix-ui/react-arrow */ "../../../node_modules/@radix-ui/react-arrow/dist/index.js");
var $50Iv9$radixuireactcomposerefs = __webpack_require__(/*! @radix-ui/react-compose-refs */ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js");
var $50Iv9$radixuireactcontext = __webpack_require__(/*! @radix-ui/react-context */ "../../../node_modules/@radix-ui/react-context/dist/index.js");
var $50Iv9$radixuireactprimitive = __webpack_require__(/*! @radix-ui/react-primitive */ "../../../node_modules/@radix-ui/react-primitive/dist/index.js");
var $50Iv9$radixuireactusecallbackref = __webpack_require__(/*! @radix-ui/react-use-callback-ref */ "../../../node_modules/@radix-ui/react-use-callback-ref/dist/index.js");
var $50Iv9$radixuireactuselayouteffect = __webpack_require__(/*! @radix-ui/react-use-layout-effect */ "../../../node_modules/@radix-ui/react-use-layout-effect/dist/index.js");
var $50Iv9$radixuireactusesize = __webpack_require__(/*! @radix-ui/react-use-size */ "../../../node_modules/@radix-ui/react-use-size/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "createPopperScope", () => $34310caa050a8d63$export$722aac194ae923);
$parcel$export(module.exports, "Popper", () => $34310caa050a8d63$export$badac9ada3a0bdf9);
$parcel$export(module.exports, "PopperAnchor", () => $34310caa050a8d63$export$ecd4e1ccab6ed6d);
$parcel$export(module.exports, "PopperContent", () => $34310caa050a8d63$export$bc4ae5855d3c4fc);
$parcel$export(module.exports, "PopperArrow", () => $34310caa050a8d63$export$79d62cd4e10a3fd0);
$parcel$export(module.exports, "Root", () => $34310caa050a8d63$export$be92b6f5f03c0fe9);
$parcel$export(module.exports, "Anchor", () => $34310caa050a8d63$export$b688253958b8dfe7);
$parcel$export(module.exports, "Content", () => $34310caa050a8d63$export$7c6e2c02157bb7d2);
$parcel$export(module.exports, "Arrow", () => $34310caa050a8d63$export$21b07c8f274aebd5);
$parcel$export(module.exports, "SIDE_OPTIONS", () => $34310caa050a8d63$export$36f0086da09c4b9f);
$parcel$export(module.exports, "ALIGN_OPTIONS", () => $34310caa050a8d63$export$3671ffab7b302fc9);
const $34310caa050a8d63$export$36f0086da09c4b9f = ['top', 'right', 'bottom', 'left'];
const $34310caa050a8d63$export$3671ffab7b302fc9 = ['start', 'center', 'end'];
/* -------------------------------------------------------------------------------------------------
 * Popper
 * -----------------------------------------------------------------------------------------------*/
const $34310caa050a8d63$var$POPPER_NAME = 'Popper';
const [$34310caa050a8d63$var$createPopperContext, $34310caa050a8d63$export$722aac194ae923] = $50Iv9$radixuireactcontext.createContextScope($34310caa050a8d63$var$POPPER_NAME);
const [$34310caa050a8d63$var$PopperProvider, $34310caa050a8d63$var$usePopperContext] = $34310caa050a8d63$var$createPopperContext($34310caa050a8d63$var$POPPER_NAME);
const $34310caa050a8d63$export$badac9ada3a0bdf9 = props => {
  const {
    __scopePopper: __scopePopper,
    children: children
  } = props;
  const [anchor, setAnchor] = $50Iv9$react.useState(null);
  return /*#__PURE__*/$50Iv9$react.createElement($34310caa050a8d63$var$PopperProvider, {
    scope: __scopePopper,
    anchor: anchor,
    onAnchorChange: setAnchor
  }, children);
};
/*#__PURE__*/
Object.assign($34310caa050a8d63$export$badac9ada3a0bdf9, {
  displayName: $34310caa050a8d63$var$POPPER_NAME
});
/* -------------------------------------------------------------------------------------------------
 * PopperAnchor
 * -----------------------------------------------------------------------------------------------*/
const $34310caa050a8d63$var$ANCHOR_NAME = 'PopperAnchor';
const $34310caa050a8d63$export$ecd4e1ccab6ed6d = /*#__PURE__*/$50Iv9$react.forwardRef((props, forwardedRef) => {
  const {
    __scopePopper: __scopePopper,
    virtualRef: virtualRef,
    ...anchorProps
  } = props;
  const context = $34310caa050a8d63$var$usePopperContext($34310caa050a8d63$var$ANCHOR_NAME, __scopePopper);
  const ref = $50Iv9$react.useRef(null);
  const composedRefs = $50Iv9$radixuireactcomposerefs.useComposedRefs(forwardedRef, ref);
  $50Iv9$react.useEffect(() => {
    // Consumer can anchor the popper to something that isn't
    // a DOM node e.g. pointer position, so we override the
    // `anchorRef` with their virtual ref in this case.
    context.onAnchorChange((virtualRef === null || virtualRef === void 0 ? void 0 : virtualRef.current) || ref.current);
  });
  return virtualRef ? null : /*#__PURE__*/$50Iv9$react.createElement($50Iv9$radixuireactprimitive.Primitive.div, $parcel$interopDefault($50Iv9$babelruntimehelpersextends)({}, anchorProps, {
    ref: composedRefs
  }));
});
/*#__PURE__*/
Object.assign($34310caa050a8d63$export$ecd4e1ccab6ed6d, {
  displayName: $34310caa050a8d63$var$ANCHOR_NAME
});
/* -------------------------------------------------------------------------------------------------
 * PopperContent
 * -----------------------------------------------------------------------------------------------*/
const $34310caa050a8d63$var$CONTENT_NAME = 'PopperContent';
const [$34310caa050a8d63$var$PopperContentProvider, $34310caa050a8d63$var$useContentContext] = $34310caa050a8d63$var$createPopperContext($34310caa050a8d63$var$CONTENT_NAME);
const $34310caa050a8d63$export$bc4ae5855d3c4fc = /*#__PURE__*/$50Iv9$react.forwardRef((props, forwardedRef) => {
  var _arrowSize$width, _arrowSize$height, _middlewareData$arrow, _middlewareData$arrow2, _middlewareData$arrow3, _middlewareData$trans, _middlewareData$trans2, _middlewareData$hide;
  const {
    __scopePopper: __scopePopper,
    side = 'bottom',
    sideOffset = 0,
    align = 'center',
    alignOffset = 0,
    arrowPadding = 0,
    collisionBoundary = [],
    collisionPadding: collisionPaddingProp = 0,
    sticky = 'partial',
    hideWhenDetached = false,
    avoidCollisions = true,
    onPlaced: onPlaced,
    ...contentProps
  } = props;
  const context = $34310caa050a8d63$var$usePopperContext($34310caa050a8d63$var$CONTENT_NAME, __scopePopper);
  const [content, setContent] = $50Iv9$react.useState(null);
  const composedRefs = $50Iv9$radixuireactcomposerefs.useComposedRefs(forwardedRef, node => setContent(node));
  const [arrow, setArrow] = $50Iv9$react.useState(null);
  const arrowSize = $50Iv9$radixuireactusesize.useSize(arrow);
  const arrowWidth = (_arrowSize$width = arrowSize === null || arrowSize === void 0 ? void 0 : arrowSize.width) !== null && _arrowSize$width !== void 0 ? _arrowSize$width : 0;
  const arrowHeight = (_arrowSize$height = arrowSize === null || arrowSize === void 0 ? void 0 : arrowSize.height) !== null && _arrowSize$height !== void 0 ? _arrowSize$height : 0;
  const desiredPlacement = side + (align !== 'center' ? '-' + align : '');
  const collisionPadding = typeof collisionPaddingProp === 'number' ? collisionPaddingProp : {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...collisionPaddingProp
  };
  const boundary = Array.isArray(collisionBoundary) ? collisionBoundary : [collisionBoundary];
  const hasExplicitBoundaries = boundary.length > 0;
  const detectOverflowOptions = {
    padding: collisionPadding,
    boundary: boundary.filter($34310caa050a8d63$var$isNotNull),
    // with `strategy: 'fixed'`, this is the only way to get it to respect boundaries
    altBoundary: hasExplicitBoundaries
  };
  const {
    refs: refs,
    floatingStyles: floatingStyles,
    placement: placement,
    isPositioned: isPositioned,
    middlewareData: middlewareData
  } = $50Iv9$floatinguireactdom.useFloating({
    // default to `fixed` strategy so users don't have to pick and we also avoid focus scroll issues
    strategy: 'fixed',
    placement: desiredPlacement,
    whileElementsMounted: $50Iv9$floatinguireactdom.autoUpdate,
    elements: {
      reference: context.anchor
    },
    middleware: [$50Iv9$floatinguireactdom.offset({
      mainAxis: sideOffset + arrowHeight,
      alignmentAxis: alignOffset
    }), avoidCollisions && $50Iv9$floatinguireactdom.shift({
      mainAxis: true,
      crossAxis: false,
      limiter: sticky === 'partial' ? $50Iv9$floatinguireactdom.limitShift() : undefined,
      ...detectOverflowOptions
    }), avoidCollisions && $50Iv9$floatinguireactdom.flip({
      ...detectOverflowOptions
    }), $50Iv9$floatinguireactdom.size({
      ...detectOverflowOptions,
      apply: ({
        elements: elements,
        rects: rects,
        availableWidth: availableWidth,
        availableHeight: availableHeight
      }) => {
        const {
          width: anchorWidth,
          height: anchorHeight
        } = rects.reference;
        const contentStyle = elements.floating.style;
        contentStyle.setProperty('--radix-popper-available-width', `${availableWidth}px`);
        contentStyle.setProperty('--radix-popper-available-height', `${availableHeight}px`);
        contentStyle.setProperty('--radix-popper-anchor-width', `${anchorWidth}px`);
        contentStyle.setProperty('--radix-popper-anchor-height', `${anchorHeight}px`);
      }
    }), arrow && $50Iv9$floatinguireactdom.arrow({
      element: arrow,
      padding: arrowPadding
    }), $34310caa050a8d63$var$transformOrigin({
      arrowWidth: arrowWidth,
      arrowHeight: arrowHeight
    }), hideWhenDetached && $50Iv9$floatinguireactdom.hide({
      strategy: 'referenceHidden'
    })]
  });
  const [placedSide, placedAlign] = $34310caa050a8d63$var$getSideAndAlignFromPlacement(placement);
  const handlePlaced = $50Iv9$radixuireactusecallbackref.useCallbackRef(onPlaced);
  $50Iv9$radixuireactuselayouteffect.useLayoutEffect(() => {
    if (isPositioned) handlePlaced === null || handlePlaced === void 0 || handlePlaced();
  }, [isPositioned, handlePlaced]);
  const arrowX = (_middlewareData$arrow = middlewareData.arrow) === null || _middlewareData$arrow === void 0 ? void 0 : _middlewareData$arrow.x;
  const arrowY = (_middlewareData$arrow2 = middlewareData.arrow) === null || _middlewareData$arrow2 === void 0 ? void 0 : _middlewareData$arrow2.y;
  const cannotCenterArrow = ((_middlewareData$arrow3 = middlewareData.arrow) === null || _middlewareData$arrow3 === void 0 ? void 0 : _middlewareData$arrow3.centerOffset) !== 0;
  const [contentZIndex, setContentZIndex] = $50Iv9$react.useState();
  $50Iv9$radixuireactuselayouteffect.useLayoutEffect(() => {
    if (content) setContentZIndex(window.getComputedStyle(content).zIndex);
  }, [content]);
  return /*#__PURE__*/$50Iv9$react.createElement("div", {
    ref: refs.setFloating,
    "data-radix-popper-content-wrapper": "",
    style: {
      ...floatingStyles,
      transform: isPositioned ? floatingStyles.transform : 'translate(0, -200%)',
      // keep off the page when measuring
      minWidth: 'max-content',
      zIndex: contentZIndex,
      ['--radix-popper-transform-origin']: [(_middlewareData$trans = middlewareData.transformOrigin) === null || _middlewareData$trans === void 0 ? void 0 : _middlewareData$trans.x, (_middlewareData$trans2 = middlewareData.transformOrigin) === null || _middlewareData$trans2 === void 0 ? void 0 : _middlewareData$trans2.y].join(' ')
    } // Floating UI interally calculates logical alignment based the `dir` attribute on
    ,

    dir: props.dir
  }, /*#__PURE__*/$50Iv9$react.createElement($34310caa050a8d63$var$PopperContentProvider, {
    scope: __scopePopper,
    placedSide: placedSide,
    onArrowChange: setArrow,
    arrowX: arrowX,
    arrowY: arrowY,
    shouldHideArrow: cannotCenterArrow
  }, /*#__PURE__*/$50Iv9$react.createElement($50Iv9$radixuireactprimitive.Primitive.div, $parcel$interopDefault($50Iv9$babelruntimehelpersextends)({
    "data-side": placedSide,
    "data-align": placedAlign
  }, contentProps, {
    ref: composedRefs,
    style: {
      ...contentProps.style,
      // if the PopperContent hasn't been placed yet (not all measurements done)
      // we prevent animations so that users's animation don't kick in too early referring wrong sides
      animation: !isPositioned ? 'none' : undefined,
      // hide the content if using the hide middleware and should be hidden
      opacity: (_middlewareData$hide = middlewareData.hide) !== null && _middlewareData$hide !== void 0 && _middlewareData$hide.referenceHidden ? 0 : undefined
    }
  }))));
});
/*#__PURE__*/
Object.assign($34310caa050a8d63$export$bc4ae5855d3c4fc, {
  displayName: $34310caa050a8d63$var$CONTENT_NAME
});
/* -------------------------------------------------------------------------------------------------
 * PopperArrow
 * -----------------------------------------------------------------------------------------------*/
const $34310caa050a8d63$var$ARROW_NAME = 'PopperArrow';
const $34310caa050a8d63$var$OPPOSITE_SIDE = {
  top: 'bottom',
  right: 'left',
  bottom: 'top',
  left: 'right'
};
const $34310caa050a8d63$export$79d62cd4e10a3fd0 = /*#__PURE__*/$50Iv9$react.forwardRef(function $34310caa050a8d63$export$79d62cd4e10a3fd0(props, forwardedRef) {
  const {
    __scopePopper: __scopePopper,
    ...arrowProps
  } = props;
  const contentContext = $34310caa050a8d63$var$useContentContext($34310caa050a8d63$var$ARROW_NAME, __scopePopper);
  const baseSide = $34310caa050a8d63$var$OPPOSITE_SIDE[contentContext.placedSide];
  return /*#__PURE__*/ (// we have to use an extra wrapper because `ResizeObserver` (used by `useSize`)
    // doesn't report size as we'd expect on SVG elements.
    // it reports their bounding box which is effectively the largest path inside the SVG.
    $50Iv9$react.createElement("span", {
      ref: contentContext.onArrowChange,
      style: {
        position: 'absolute',
        left: contentContext.arrowX,
        top: contentContext.arrowY,
        [baseSide]: 0,
        transformOrigin: {
          top: '',
          right: '0 0',
          bottom: 'center 0',
          left: '100% 0'
        }[contentContext.placedSide],
        transform: {
          top: 'translateY(100%)',
          right: 'translateY(50%) rotate(90deg) translateX(-50%)',
          bottom: `rotate(180deg)`,
          left: 'translateY(50%) rotate(-90deg) translateX(50%)'
        }[contentContext.placedSide],
        visibility: contentContext.shouldHideArrow ? 'hidden' : undefined
      }
    }, /*#__PURE__*/$50Iv9$react.createElement($50Iv9$radixuireactarrow.Root, $parcel$interopDefault($50Iv9$babelruntimehelpersextends)({}, arrowProps, {
      ref: forwardedRef,
      style: {
        ...arrowProps.style,
        // ensures the element can be measured correctly (mostly for if SVG)
        display: 'block'
      }
    })))
  );
});
/*#__PURE__*/
Object.assign($34310caa050a8d63$export$79d62cd4e10a3fd0, {
  displayName: $34310caa050a8d63$var$ARROW_NAME
});
/* -----------------------------------------------------------------------------------------------*/
function $34310caa050a8d63$var$isNotNull(value) {
  return value !== null;
}
const $34310caa050a8d63$var$transformOrigin = options => ({
  name: 'transformOrigin',
  options: options,
  fn(data) {
    var _middlewareData$arrow4, _middlewareData$arrow5, _middlewareData$arrow6, _middlewareData$arrow7, _middlewareData$arrow8;
    const {
      placement: placement,
      rects: rects,
      middlewareData: middlewareData
    } = data;
    const cannotCenterArrow = ((_middlewareData$arrow4 = middlewareData.arrow) === null || _middlewareData$arrow4 === void 0 ? void 0 : _middlewareData$arrow4.centerOffset) !== 0;
    const isArrowHidden = cannotCenterArrow;
    const arrowWidth = isArrowHidden ? 0 : options.arrowWidth;
    const arrowHeight = isArrowHidden ? 0 : options.arrowHeight;
    const [placedSide, placedAlign] = $34310caa050a8d63$var$getSideAndAlignFromPlacement(placement);
    const noArrowAlign = {
      start: '0%',
      center: '50%',
      end: '100%'
    }[placedAlign];
    const arrowXCenter = ((_middlewareData$arrow5 = (_middlewareData$arrow6 = middlewareData.arrow) === null || _middlewareData$arrow6 === void 0 ? void 0 : _middlewareData$arrow6.x) !== null && _middlewareData$arrow5 !== void 0 ? _middlewareData$arrow5 : 0) + arrowWidth / 2;
    const arrowYCenter = ((_middlewareData$arrow7 = (_middlewareData$arrow8 = middlewareData.arrow) === null || _middlewareData$arrow8 === void 0 ? void 0 : _middlewareData$arrow8.y) !== null && _middlewareData$arrow7 !== void 0 ? _middlewareData$arrow7 : 0) + arrowHeight / 2;
    let x = '';
    let y = '';
    if (placedSide === 'bottom') {
      x = isArrowHidden ? noArrowAlign : `${arrowXCenter}px`;
      y = `${-arrowHeight}px`;
    } else if (placedSide === 'top') {
      x = isArrowHidden ? noArrowAlign : `${arrowXCenter}px`;
      y = `${rects.floating.height + arrowHeight}px`;
    } else if (placedSide === 'right') {
      x = `${-arrowHeight}px`;
      y = isArrowHidden ? noArrowAlign : `${arrowYCenter}px`;
    } else if (placedSide === 'left') {
      x = `${rects.floating.width + arrowHeight}px`;
      y = isArrowHidden ? noArrowAlign : `${arrowYCenter}px`;
    }
    return {
      data: {
        x: x,
        y: y
      }
    };
  }
});
function $34310caa050a8d63$var$getSideAndAlignFromPlacement(placement) {
  const [side, align = 'center'] = placement.split('-');
  return [side, align];
}
const $34310caa050a8d63$export$be92b6f5f03c0fe9 = $34310caa050a8d63$export$badac9ada3a0bdf9;
const $34310caa050a8d63$export$b688253958b8dfe7 = $34310caa050a8d63$export$ecd4e1ccab6ed6d;
const $34310caa050a8d63$export$7c6e2c02157bb7d2 = $34310caa050a8d63$export$bc4ae5855d3c4fc;
const $34310caa050a8d63$export$21b07c8f274aebd5 = $34310caa050a8d63$export$79d62cd4e10a3fd0;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-portal/dist/index.js":
/*!******************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-portal/dist/index.js ***!
  \******************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $amzHf$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $amzHf$react = __webpack_require__(/*! react */ "react");
var $amzHf$reactdom = __webpack_require__(/*! react-dom */ "react-dom");
var $amzHf$radixuireactprimitive = __webpack_require__(/*! @radix-ui/react-primitive */ "../../../node_modules/@radix-ui/react-primitive/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "Portal", () => $913a70b877676c16$export$602eac185826482c);
$parcel$export(module.exports, "Root", () => $913a70b877676c16$export$be92b6f5f03c0fe9);

/* -------------------------------------------------------------------------------------------------
 * Portal
 * -----------------------------------------------------------------------------------------------*/
const $913a70b877676c16$var$PORTAL_NAME = 'Portal';
const $913a70b877676c16$export$602eac185826482c = /*#__PURE__*/$amzHf$react.forwardRef((props, forwardedRef) => {
  var _globalThis$document;
  const {
    container = globalThis === null || globalThis === void 0 ? void 0 : (_globalThis$document = globalThis.document) === null || _globalThis$document === void 0 ? void 0 : _globalThis$document.body,
    ...portalProps
  } = props;
  return container ? /*#__PURE__*/$parcel$interopDefault($amzHf$reactdom).createPortal( /*#__PURE__*/$amzHf$react.createElement($amzHf$radixuireactprimitive.Primitive.div, $parcel$interopDefault($amzHf$babelruntimehelpersextends)({}, portalProps, {
    ref: forwardedRef
  })), container) : null;
});
/*#__PURE__*/
Object.assign($913a70b877676c16$export$602eac185826482c, {
  displayName: $913a70b877676c16$var$PORTAL_NAME
});
/* -----------------------------------------------------------------------------------------------*/
const $913a70b877676c16$export$be92b6f5f03c0fe9 = $913a70b877676c16$export$602eac185826482c;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-presence/dist/index.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-presence/dist/index.js ***!
  \********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $fnLeV$react = __webpack_require__(/*! react */ "react");
var $fnLeV$reactdom = __webpack_require__(/*! react-dom */ "react-dom");
var $fnLeV$radixuireactcomposerefs = __webpack_require__(/*! @radix-ui/react-compose-refs */ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js");
var $fnLeV$radixuireactuselayouteffect = __webpack_require__(/*! @radix-ui/react-use-layout-effect */ "../../../node_modules/@radix-ui/react-use-layout-effect/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "Presence", () => $a2fa0214bb2735a1$export$99c2b779aa4e8b8b);
function $8f63844556d0d3cd$export$3e6543de14f8614f(initialState, machine) {
  return $fnLeV$react.useReducer((state, event) => {
    const nextState = machine[state][event];
    return nextState !== null && nextState !== void 0 ? nextState : state;
  }, initialState);
}
const $a2fa0214bb2735a1$export$99c2b779aa4e8b8b = props => {
  const {
    present: present,
    children: children
  } = props;
  const presence = $a2fa0214bb2735a1$var$usePresence(present);
  const child = typeof children === 'function' ? children({
    present: presence.isPresent
  }) : $fnLeV$react.Children.only(children);
  const ref = $fnLeV$radixuireactcomposerefs.useComposedRefs(presence.ref, child.ref);
  const forceMount = typeof children === 'function';
  return forceMount || presence.isPresent ? /*#__PURE__*/$fnLeV$react.cloneElement(child, {
    ref: ref
  }) : null;
};
$a2fa0214bb2735a1$export$99c2b779aa4e8b8b.displayName = 'Presence';
/* -------------------------------------------------------------------------------------------------
 * usePresence
 * -----------------------------------------------------------------------------------------------*/
function $a2fa0214bb2735a1$var$usePresence(present) {
  const [node1, setNode] = $fnLeV$react.useState();
  const stylesRef = $fnLeV$react.useRef({});
  const prevPresentRef = $fnLeV$react.useRef(present);
  const prevAnimationNameRef = $fnLeV$react.useRef('none');
  const initialState = present ? 'mounted' : 'unmounted';
  const [state, send] = $8f63844556d0d3cd$export$3e6543de14f8614f(initialState, {
    mounted: {
      UNMOUNT: 'unmounted',
      ANIMATION_OUT: 'unmountSuspended'
    },
    unmountSuspended: {
      MOUNT: 'mounted',
      ANIMATION_END: 'unmounted'
    },
    unmounted: {
      MOUNT: 'mounted'
    }
  });
  $fnLeV$react.useEffect(() => {
    const currentAnimationName = $a2fa0214bb2735a1$var$getAnimationName(stylesRef.current);
    prevAnimationNameRef.current = state === 'mounted' ? currentAnimationName : 'none';
  }, [state]);
  $fnLeV$radixuireactuselayouteffect.useLayoutEffect(() => {
    const styles = stylesRef.current;
    const wasPresent = prevPresentRef.current;
    const hasPresentChanged = wasPresent !== present;
    if (hasPresentChanged) {
      const prevAnimationName = prevAnimationNameRef.current;
      const currentAnimationName = $a2fa0214bb2735a1$var$getAnimationName(styles);
      if (present) send('MOUNT');else if (currentAnimationName === 'none' || (styles === null || styles === void 0 ? void 0 : styles.display) === 'none')
        // If there is no exit animation or the element is hidden, animations won't run
        // so we unmount instantly
        send('UNMOUNT');else {
        /**
        * When `present` changes to `false`, we check changes to animation-name to
        * determine whether an animation has started. We chose this approach (reading
        * computed styles) because there is no `animationrun` event and `animationstart`
        * fires after `animation-delay` has expired which would be too late.
        */
        const isAnimating = prevAnimationName !== currentAnimationName;
        if (wasPresent && isAnimating) send('ANIMATION_OUT');else send('UNMOUNT');
      }
      prevPresentRef.current = present;
    }
  }, [present, send]);
  $fnLeV$radixuireactuselayouteffect.useLayoutEffect(() => {
    if (node1) {
      /**
      * Triggering an ANIMATION_OUT during an ANIMATION_IN will fire an `animationcancel`
      * event for ANIMATION_IN after we have entered `unmountSuspended` state. So, we
      * make sure we only trigger ANIMATION_END for the currently active animation.
      */
      const handleAnimationEnd = event => {
        const currentAnimationName = $a2fa0214bb2735a1$var$getAnimationName(stylesRef.current);
        const isCurrentAnimation = currentAnimationName.includes(event.animationName);
        if (event.target === node1 && isCurrentAnimation)
          // With React 18 concurrency this update is applied
          // a frame after the animation ends, creating a flash of visible content.
          // By manually flushing we ensure they sync within a frame, removing the flash.
          $fnLeV$reactdom.flushSync(() => send('ANIMATION_END'));
      };
      const handleAnimationStart = event => {
        if (event.target === node1)
          // if animation occurred, store its name as the previous animation.
          prevAnimationNameRef.current = $a2fa0214bb2735a1$var$getAnimationName(stylesRef.current);
      };
      node1.addEventListener('animationstart', handleAnimationStart);
      node1.addEventListener('animationcancel', handleAnimationEnd);
      node1.addEventListener('animationend', handleAnimationEnd);
      return () => {
        node1.removeEventListener('animationstart', handleAnimationStart);
        node1.removeEventListener('animationcancel', handleAnimationEnd);
        node1.removeEventListener('animationend', handleAnimationEnd);
      };
    } else
      // Transition to the unmounted state if the node is removed prematurely.
      // We avoid doing so during cleanup as the node may change but still exist.
      send('ANIMATION_END');
  }, [node1, send]);
  return {
    isPresent: ['mounted', 'unmountSuspended'].includes(state),
    ref: $fnLeV$react.useCallback(node => {
      if (node) stylesRef.current = getComputedStyle(node);
      setNode(node);
    }, [])
  };
}
/* -----------------------------------------------------------------------------------------------*/
function $a2fa0214bb2735a1$var$getAnimationName(styles) {
  return (styles === null || styles === void 0 ? void 0 : styles.animationName) || 'none';
}

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-primitive/dist/index.js":
/*!*********************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-primitive/dist/index.js ***!
  \*********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $iMixA$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $iMixA$react = __webpack_require__(/*! react */ "react");
var $iMixA$reactdom = __webpack_require__(/*! react-dom */ "react-dom");
var $iMixA$radixuireactslot = __webpack_require__(/*! @radix-ui/react-slot */ "../../../node_modules/@radix-ui/react-slot/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "Primitive", () => $c3def6332c2749a6$export$250ffa63cdc0d034);
$parcel$export(module.exports, "Root", () => $c3def6332c2749a6$export$be92b6f5f03c0fe9);
$parcel$export(module.exports, "dispatchDiscreteCustomEvent", () => $c3def6332c2749a6$export$6d1a0317bde7de7f);
const $c3def6332c2749a6$var$NODES = ['a', 'button', 'div', 'form', 'h2', 'h3', 'img', 'input', 'label', 'li', 'nav', 'ol', 'p', 'span', 'svg', 'ul']; // Temporary while we await merge of this fix:
// https://github.com/DefinitelyTyped/DefinitelyTyped/pull/55396
// prettier-ignore
/* -------------------------------------------------------------------------------------------------
 * Primitive
 * -----------------------------------------------------------------------------------------------*/
const $c3def6332c2749a6$export$250ffa63cdc0d034 = $c3def6332c2749a6$var$NODES.reduce((primitive, node) => {
  const Node = /*#__PURE__*/$iMixA$react.forwardRef((props, forwardedRef) => {
    const {
      asChild: asChild,
      ...primitiveProps
    } = props;
    const Comp = asChild ? $iMixA$radixuireactslot.Slot : node;
    $iMixA$react.useEffect(() => {
      window[Symbol.for('radix-ui')] = true;
    }, []);
    return /*#__PURE__*/$iMixA$react.createElement(Comp, $parcel$interopDefault($iMixA$babelruntimehelpersextends)({}, primitiveProps, {
      ref: forwardedRef
    }));
  });
  Node.displayName = `Primitive.${node}`;
  return {
    ...primitive,
    [node]: Node
  };
}, {});
/* -------------------------------------------------------------------------------------------------
 * Utils
 * -----------------------------------------------------------------------------------------------*/ /**
                                                                                                     * Flush custom event dispatch
                                                                                                     * https://github.com/radix-ui/primitives/pull/1378
                                                                                                     *
                                                                                                     * React batches *all* event handlers since version 18, this introduces certain considerations when using custom event types.
                                                                                                     *
                                                                                                     * Internally, React prioritises events in the following order:
                                                                                                     *  - discrete
                                                                                                     *  - continuous
                                                                                                     *  - default
                                                                                                     *
                                                                                                     * https://github.com/facebook/react/blob/a8a4742f1c54493df00da648a3f9d26e3db9c8b5/packages/react-dom/src/events/ReactDOMEventListener.js#L294-L350
                                                                                                     *
                                                                                                     * `discrete` is an  important distinction as updates within these events are applied immediately.
                                                                                                     * React however, is not able to infer the priority of custom event types due to how they are detected internally.
                                                                                                     * Because of this, it's possible for updates from custom events to be unexpectedly batched when
                                                                                                     * dispatched by another `discrete` event.
                                                                                                     *
                                                                                                     * In order to ensure that updates from custom events are applied predictably, we need to manually flush the batch.
                                                                                                     * This utility should be used when dispatching a custom event from within another `discrete` event, this utility
                                                                                                     * is not nessesary when dispatching known event types, or if dispatching a custom type inside a non-discrete event.
                                                                                                     * For example:
                                                                                                     *
                                                                                                     * dispatching a known click 👎
                                                                                                     * target.dispatchEvent(new Event(‘click’))
                                                                                                     *
                                                                                                     * dispatching a custom type within a non-discrete event 👎
                                                                                                     * onScroll={(event) => event.target.dispatchEvent(new CustomEvent(‘customType’))}
                                                                                                     *
                                                                                                     * dispatching a custom type within a `discrete` event 👍
                                                                                                     * onPointerDown={(event) => dispatchDiscreteCustomEvent(event.target, new CustomEvent(‘customType’))}
                                                                                                     *
                                                                                                     * Note: though React classifies `focus`, `focusin` and `focusout` events as `discrete`, it's  not recommended to use
                                                                                                     * this utility with them. This is because it's possible for those handlers to be called implicitly during render
                                                                                                     * e.g. when focus is within a component as it is unmounted, or when managing focus on mount.
                                                                                                     */
function $c3def6332c2749a6$export$6d1a0317bde7de7f(target, event) {
  if (target) $iMixA$reactdom.flushSync(() => target.dispatchEvent(event));
}
/* -----------------------------------------------------------------------------------------------*/
const $c3def6332c2749a6$export$be92b6f5f03c0fe9 = $c3def6332c2749a6$export$250ffa63cdc0d034;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-roving-focus/dist/index.js":
/*!************************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-roving-focus/dist/index.js ***!
  \************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $9QJ9Y$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $9QJ9Y$react = __webpack_require__(/*! react */ "react");
var $9QJ9Y$radixuiprimitive = __webpack_require__(/*! @radix-ui/primitive */ "../../../node_modules/@radix-ui/primitive/dist/index.js");
var $9QJ9Y$radixuireactcollection = __webpack_require__(/*! @radix-ui/react-collection */ "../../../node_modules/@radix-ui/react-collection/dist/index.js");
var $9QJ9Y$radixuireactcomposerefs = __webpack_require__(/*! @radix-ui/react-compose-refs */ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js");
var $9QJ9Y$radixuireactcontext = __webpack_require__(/*! @radix-ui/react-context */ "../../../node_modules/@radix-ui/react-context/dist/index.js");
var $9QJ9Y$radixuireactid = __webpack_require__(/*! @radix-ui/react-id */ "../../../node_modules/@radix-ui/react-id/dist/index.js");
var $9QJ9Y$radixuireactprimitive = __webpack_require__(/*! @radix-ui/react-primitive */ "../../../node_modules/@radix-ui/react-primitive/dist/index.js");
var $9QJ9Y$radixuireactusecallbackref = __webpack_require__(/*! @radix-ui/react-use-callback-ref */ "../../../node_modules/@radix-ui/react-use-callback-ref/dist/index.js");
var $9QJ9Y$radixuireactusecontrollablestate = __webpack_require__(/*! @radix-ui/react-use-controllable-state */ "../../../node_modules/@radix-ui/react-use-controllable-state/dist/index.js");
var $9QJ9Y$radixuireactdirection = __webpack_require__(/*! @radix-ui/react-direction */ "../../../node_modules/@radix-ui/react-direction/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "createRovingFocusGroupScope", () => $0063afae63b3fa70$export$c7109489551a4f4);
$parcel$export(module.exports, "RovingFocusGroup", () => $0063afae63b3fa70$export$8699f7c8af148338);
$parcel$export(module.exports, "RovingFocusGroupItem", () => $0063afae63b3fa70$export$ab9df7c53fe8454);
$parcel$export(module.exports, "Root", () => $0063afae63b3fa70$export$be92b6f5f03c0fe9);
$parcel$export(module.exports, "Item", () => $0063afae63b3fa70$export$6d08773d2e66f8f2);
const $0063afae63b3fa70$var$ENTRY_FOCUS = 'rovingFocusGroup.onEntryFocus';
const $0063afae63b3fa70$var$EVENT_OPTIONS = {
  bubbles: false,
  cancelable: true
};
/* -------------------------------------------------------------------------------------------------
 * RovingFocusGroup
 * -----------------------------------------------------------------------------------------------*/
const $0063afae63b3fa70$var$GROUP_NAME = 'RovingFocusGroup';
const [$0063afae63b3fa70$var$Collection, $0063afae63b3fa70$var$useCollection, $0063afae63b3fa70$var$createCollectionScope] = $9QJ9Y$radixuireactcollection.createCollection($0063afae63b3fa70$var$GROUP_NAME);
const [$0063afae63b3fa70$var$createRovingFocusGroupContext, $0063afae63b3fa70$export$c7109489551a4f4] = $9QJ9Y$radixuireactcontext.createContextScope($0063afae63b3fa70$var$GROUP_NAME, [$0063afae63b3fa70$var$createCollectionScope]);
const [$0063afae63b3fa70$var$RovingFocusProvider, $0063afae63b3fa70$var$useRovingFocusContext] = $0063afae63b3fa70$var$createRovingFocusGroupContext($0063afae63b3fa70$var$GROUP_NAME);
const $0063afae63b3fa70$export$8699f7c8af148338 = /*#__PURE__*/$9QJ9Y$react.forwardRef((props, forwardedRef) => {
  return /*#__PURE__*/$9QJ9Y$react.createElement($0063afae63b3fa70$var$Collection.Provider, {
    scope: props.__scopeRovingFocusGroup
  }, /*#__PURE__*/$9QJ9Y$react.createElement($0063afae63b3fa70$var$Collection.Slot, {
    scope: props.__scopeRovingFocusGroup
  }, /*#__PURE__*/$9QJ9Y$react.createElement($0063afae63b3fa70$var$RovingFocusGroupImpl, $parcel$interopDefault($9QJ9Y$babelruntimehelpersextends)({}, props, {
    ref: forwardedRef
  }))));
});
/*#__PURE__*/
Object.assign($0063afae63b3fa70$export$8699f7c8af148338, {
  displayName: $0063afae63b3fa70$var$GROUP_NAME
});
/* -----------------------------------------------------------------------------------------------*/
const $0063afae63b3fa70$var$RovingFocusGroupImpl = /*#__PURE__*/$9QJ9Y$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeRovingFocusGroup: __scopeRovingFocusGroup,
    orientation: orientation,
    loop = false,
    dir: dir,
    currentTabStopId: currentTabStopIdProp,
    defaultCurrentTabStopId: defaultCurrentTabStopId,
    onCurrentTabStopIdChange: onCurrentTabStopIdChange,
    onEntryFocus: onEntryFocus,
    ...groupProps
  } = props;
  const ref = $9QJ9Y$react.useRef(null);
  const composedRefs = $9QJ9Y$radixuireactcomposerefs.useComposedRefs(forwardedRef, ref);
  const direction = $9QJ9Y$radixuireactdirection.useDirection(dir);
  const [currentTabStopId = null, setCurrentTabStopId] = $9QJ9Y$radixuireactusecontrollablestate.useControllableState({
    prop: currentTabStopIdProp,
    defaultProp: defaultCurrentTabStopId,
    onChange: onCurrentTabStopIdChange
  });
  const [isTabbingBackOut, setIsTabbingBackOut] = $9QJ9Y$react.useState(false);
  const handleEntryFocus = $9QJ9Y$radixuireactusecallbackref.useCallbackRef(onEntryFocus);
  const getItems = $0063afae63b3fa70$var$useCollection(__scopeRovingFocusGroup);
  const isClickFocusRef = $9QJ9Y$react.useRef(false);
  const [focusableItemsCount, setFocusableItemsCount] = $9QJ9Y$react.useState(0);
  $9QJ9Y$react.useEffect(() => {
    const node = ref.current;
    if (node) {
      node.addEventListener($0063afae63b3fa70$var$ENTRY_FOCUS, handleEntryFocus);
      return () => node.removeEventListener($0063afae63b3fa70$var$ENTRY_FOCUS, handleEntryFocus);
    }
  }, [handleEntryFocus]);
  return /*#__PURE__*/$9QJ9Y$react.createElement($0063afae63b3fa70$var$RovingFocusProvider, {
    scope: __scopeRovingFocusGroup,
    orientation: orientation,
    dir: direction,
    loop: loop,
    currentTabStopId: currentTabStopId,
    onItemFocus: $9QJ9Y$react.useCallback(tabStopId => setCurrentTabStopId(tabStopId), [setCurrentTabStopId]),
    onItemShiftTab: $9QJ9Y$react.useCallback(() => setIsTabbingBackOut(true), []),
    onFocusableItemAdd: $9QJ9Y$react.useCallback(() => setFocusableItemsCount(prevCount => prevCount + 1), []),
    onFocusableItemRemove: $9QJ9Y$react.useCallback(() => setFocusableItemsCount(prevCount => prevCount - 1), [])
  }, /*#__PURE__*/$9QJ9Y$react.createElement($9QJ9Y$radixuireactprimitive.Primitive.div, $parcel$interopDefault($9QJ9Y$babelruntimehelpersextends)({
    tabIndex: isTabbingBackOut || focusableItemsCount === 0 ? -1 : 0,
    "data-orientation": orientation
  }, groupProps, {
    ref: composedRefs,
    style: {
      outline: 'none',
      ...props.style
    },
    onMouseDown: $9QJ9Y$radixuiprimitive.composeEventHandlers(props.onMouseDown, () => {
      isClickFocusRef.current = true;
    }),
    onFocus: $9QJ9Y$radixuiprimitive.composeEventHandlers(props.onFocus, event => {
      // We normally wouldn't need this check, because we already check
      // that the focus is on the current target and not bubbling to it.
      // We do this because Safari doesn't focus buttons when clicked, and
      // instead, the wrapper will get focused and not through a bubbling event.
      const isKeyboardFocus = !isClickFocusRef.current;
      if (event.target === event.currentTarget && isKeyboardFocus && !isTabbingBackOut) {
        const entryFocusEvent = new CustomEvent($0063afae63b3fa70$var$ENTRY_FOCUS, $0063afae63b3fa70$var$EVENT_OPTIONS);
        event.currentTarget.dispatchEvent(entryFocusEvent);
        if (!entryFocusEvent.defaultPrevented) {
          const items = getItems().filter(item => item.focusable);
          const activeItem = items.find(item => item.active);
          const currentItem = items.find(item => item.id === currentTabStopId);
          const candidateItems = [activeItem, currentItem, ...items].filter(Boolean);
          const candidateNodes = candidateItems.map(item => item.ref.current);
          $0063afae63b3fa70$var$focusFirst(candidateNodes);
        }
      }
      isClickFocusRef.current = false;
    }),
    onBlur: $9QJ9Y$radixuiprimitive.composeEventHandlers(props.onBlur, () => setIsTabbingBackOut(false))
  })));
});
/* -------------------------------------------------------------------------------------------------
 * RovingFocusGroupItem
 * -----------------------------------------------------------------------------------------------*/
const $0063afae63b3fa70$var$ITEM_NAME = 'RovingFocusGroupItem';
const $0063afae63b3fa70$export$ab9df7c53fe8454 = /*#__PURE__*/$9QJ9Y$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeRovingFocusGroup: __scopeRovingFocusGroup,
    focusable = true,
    active = false,
    tabStopId: tabStopId,
    ...itemProps
  } = props;
  const autoId = $9QJ9Y$radixuireactid.useId();
  const id = tabStopId || autoId;
  const context = $0063afae63b3fa70$var$useRovingFocusContext($0063afae63b3fa70$var$ITEM_NAME, __scopeRovingFocusGroup);
  const isCurrentTabStop = context.currentTabStopId === id;
  const getItems = $0063afae63b3fa70$var$useCollection(__scopeRovingFocusGroup);
  const {
    onFocusableItemAdd: onFocusableItemAdd,
    onFocusableItemRemove: onFocusableItemRemove
  } = context;
  $9QJ9Y$react.useEffect(() => {
    if (focusable) {
      onFocusableItemAdd();
      return () => onFocusableItemRemove();
    }
  }, [focusable, onFocusableItemAdd, onFocusableItemRemove]);
  return /*#__PURE__*/$9QJ9Y$react.createElement($0063afae63b3fa70$var$Collection.ItemSlot, {
    scope: __scopeRovingFocusGroup,
    id: id,
    focusable: focusable,
    active: active
  }, /*#__PURE__*/$9QJ9Y$react.createElement($9QJ9Y$radixuireactprimitive.Primitive.span, $parcel$interopDefault($9QJ9Y$babelruntimehelpersextends)({
    tabIndex: isCurrentTabStop ? 0 : -1,
    "data-orientation": context.orientation
  }, itemProps, {
    ref: forwardedRef,
    onMouseDown: $9QJ9Y$radixuiprimitive.composeEventHandlers(props.onMouseDown, event => {
      // We prevent focusing non-focusable items on `mousedown`.
      // Even though the item has tabIndex={-1}, that only means take it out of the tab order.
      if (!focusable) event.preventDefault(); // Safari doesn't focus a button when clicked so we run our logic on mousedown also
      else context.onItemFocus(id);
    }),
    onFocus: $9QJ9Y$radixuiprimitive.composeEventHandlers(props.onFocus, () => context.onItemFocus(id)),
    onKeyDown: $9QJ9Y$radixuiprimitive.composeEventHandlers(props.onKeyDown, event => {
      if (event.key === 'Tab' && event.shiftKey) {
        context.onItemShiftTab();
        return;
      }
      if (event.target !== event.currentTarget) return;
      const focusIntent = $0063afae63b3fa70$var$getFocusIntent(event, context.orientation, context.dir);
      if (focusIntent !== undefined) {
        event.preventDefault();
        const items = getItems().filter(item => item.focusable);
        let candidateNodes = items.map(item => item.ref.current);
        if (focusIntent === 'last') candidateNodes.reverse();else if (focusIntent === 'prev' || focusIntent === 'next') {
          if (focusIntent === 'prev') candidateNodes.reverse();
          const currentIndex = candidateNodes.indexOf(event.currentTarget);
          candidateNodes = context.loop ? $0063afae63b3fa70$var$wrapArray(candidateNodes, currentIndex + 1) : candidateNodes.slice(currentIndex + 1);
        }
        /**
        * Imperative focus during keydown is risky so we prevent React's batching updates
        * to avoid potential bugs. See: https://github.com/facebook/react/issues/20332
        */
        setTimeout(() => $0063afae63b3fa70$var$focusFirst(candidateNodes));
      }
    })
  })));
});
/*#__PURE__*/
Object.assign($0063afae63b3fa70$export$ab9df7c53fe8454, {
  displayName: $0063afae63b3fa70$var$ITEM_NAME
});
/* -----------------------------------------------------------------------------------------------*/ // prettier-ignore
const $0063afae63b3fa70$var$MAP_KEY_TO_FOCUS_INTENT = {
  ArrowLeft: 'prev',
  ArrowUp: 'prev',
  ArrowRight: 'next',
  ArrowDown: 'next',
  PageUp: 'first',
  Home: 'first',
  PageDown: 'last',
  End: 'last'
};
function $0063afae63b3fa70$var$getDirectionAwareKey(key, dir) {
  if (dir !== 'rtl') return key;
  return key === 'ArrowLeft' ? 'ArrowRight' : key === 'ArrowRight' ? 'ArrowLeft' : key;
}
function $0063afae63b3fa70$var$getFocusIntent(event, orientation, dir) {
  const key = $0063afae63b3fa70$var$getDirectionAwareKey(event.key, dir);
  if (orientation === 'vertical' && ['ArrowLeft', 'ArrowRight'].includes(key)) return undefined;
  if (orientation === 'horizontal' && ['ArrowUp', 'ArrowDown'].includes(key)) return undefined;
  return $0063afae63b3fa70$var$MAP_KEY_TO_FOCUS_INTENT[key];
}
function $0063afae63b3fa70$var$focusFirst(candidates) {
  const PREVIOUSLY_FOCUSED_ELEMENT = document.activeElement;
  for (const candidate of candidates) {
    // if focus is already where we want to go, we don't want to keep going through the candidates
    if (candidate === PREVIOUSLY_FOCUSED_ELEMENT) return;
    candidate.focus();
    if (document.activeElement !== PREVIOUSLY_FOCUSED_ELEMENT) return;
  }
}
/**
 * Wraps an array around itself at a given start index
 * Example: `wrapArray(['a', 'b', 'c', 'd'], 2) === ['c', 'd', 'a', 'b']`
 */
function $0063afae63b3fa70$var$wrapArray(array, startIndex) {
  return array.map((_, index) => array[(startIndex + index) % array.length]);
}
const $0063afae63b3fa70$export$be92b6f5f03c0fe9 = $0063afae63b3fa70$export$8699f7c8af148338;
const $0063afae63b3fa70$export$6d08773d2e66f8f2 = $0063afae63b3fa70$export$ab9df7c53fe8454;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-slot/dist/index.js":
/*!****************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-slot/dist/index.js ***!
  \****************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $dAvBt$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $dAvBt$react = __webpack_require__(/*! react */ "react");
var $dAvBt$radixuireactcomposerefs = __webpack_require__(/*! @radix-ui/react-compose-refs */ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "Slot", () => $82dc8d030dec7549$export$8c6ed5c666ac1360);
$parcel$export(module.exports, "Slottable", () => $82dc8d030dec7549$export$d9f1ccf0bdb05d45);
$parcel$export(module.exports, "Root", () => $82dc8d030dec7549$export$be92b6f5f03c0fe9);

/* -------------------------------------------------------------------------------------------------
 * Slot
 * -----------------------------------------------------------------------------------------------*/
const $82dc8d030dec7549$export$8c6ed5c666ac1360 = /*#__PURE__*/$dAvBt$react.forwardRef((props, forwardedRef) => {
  const {
    children: children,
    ...slotProps
  } = props;
  const childrenArray = $dAvBt$react.Children.toArray(children);
  const slottable = childrenArray.find($82dc8d030dec7549$var$isSlottable);
  if (slottable) {
    // the new element to render is the one passed as a child of `Slottable`
    const newElement = slottable.props.children;
    const newChildren = childrenArray.map(child => {
      if (child === slottable) {
        // because the new element will be the one rendered, we are only interested
        // in grabbing its children (`newElement.props.children`)
        if ($dAvBt$react.Children.count(newElement) > 1) return $dAvBt$react.Children.only(null);
        return /*#__PURE__*/$dAvBt$react.isValidElement(newElement) ? newElement.props.children : null;
      } else return child;
    });
    return /*#__PURE__*/$dAvBt$react.createElement($82dc8d030dec7549$var$SlotClone, $parcel$interopDefault($dAvBt$babelruntimehelpersextends)({}, slotProps, {
      ref: forwardedRef
    }), /*#__PURE__*/$dAvBt$react.isValidElement(newElement) ? /*#__PURE__*/$dAvBt$react.cloneElement(newElement, undefined, newChildren) : null);
  }
  return /*#__PURE__*/$dAvBt$react.createElement($82dc8d030dec7549$var$SlotClone, $parcel$interopDefault($dAvBt$babelruntimehelpersextends)({}, slotProps, {
    ref: forwardedRef
  }), children);
});
$82dc8d030dec7549$export$8c6ed5c666ac1360.displayName = 'Slot';
/* -------------------------------------------------------------------------------------------------
 * SlotClone
 * -----------------------------------------------------------------------------------------------*/
const $82dc8d030dec7549$var$SlotClone = /*#__PURE__*/$dAvBt$react.forwardRef((props, forwardedRef) => {
  const {
    children: children,
    ...slotProps
  } = props;
  if ( /*#__PURE__*/$dAvBt$react.isValidElement(children)) return /*#__PURE__*/$dAvBt$react.cloneElement(children, {
    ...$82dc8d030dec7549$var$mergeProps(slotProps, children.props),
    ref: forwardedRef ? $dAvBt$radixuireactcomposerefs.composeRefs(forwardedRef, children.ref) : children.ref
  });
  return $dAvBt$react.Children.count(children) > 1 ? $dAvBt$react.Children.only(null) : null;
});
$82dc8d030dec7549$var$SlotClone.displayName = 'SlotClone';
/* -------------------------------------------------------------------------------------------------
 * Slottable
 * -----------------------------------------------------------------------------------------------*/
const $82dc8d030dec7549$export$d9f1ccf0bdb05d45 = ({
  children: children
}) => {
  return /*#__PURE__*/$dAvBt$react.createElement($dAvBt$react.Fragment, null, children);
};
/* ---------------------------------------------------------------------------------------------- */
function $82dc8d030dec7549$var$isSlottable(child) {
  return /*#__PURE__*/$dAvBt$react.isValidElement(child) && child.type === $82dc8d030dec7549$export$d9f1ccf0bdb05d45;
}
function $82dc8d030dec7549$var$mergeProps(slotProps, childProps) {
  // all child props should override
  const overrideProps = {
    ...childProps
  };
  for (const propName in childProps) {
    const slotPropValue = slotProps[propName];
    const childPropValue = childProps[propName];
    const isHandler = /^on[A-Z]/.test(propName);
    if (isHandler) {
      // if the handler exists on both, we compose them
      if (slotPropValue && childPropValue) overrideProps[propName] = (...args) => {
        childPropValue(...args);
        slotPropValue(...args);
      };else if (slotPropValue) overrideProps[propName] = slotPropValue;
    } else if (propName === 'style') overrideProps[propName] = {
      ...slotPropValue,
      ...childPropValue
    };else if (propName === 'className') overrideProps[propName] = [slotPropValue, childPropValue].filter(Boolean).join(' ');
  }
  return {
    ...slotProps,
    ...overrideProps
  };
}
const $82dc8d030dec7549$export$be92b6f5f03c0fe9 = $82dc8d030dec7549$export$8c6ed5c666ac1360;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-tooltip/dist/index.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-tooltip/dist/index.js ***!
  \*******************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $iVrL9$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $iVrL9$react = __webpack_require__(/*! react */ "react");
var $iVrL9$radixuiprimitive = __webpack_require__(/*! @radix-ui/primitive */ "../../../node_modules/@radix-ui/primitive/dist/index.js");
var $iVrL9$radixuireactcomposerefs = __webpack_require__(/*! @radix-ui/react-compose-refs */ "../../../node_modules/@radix-ui/react-compose-refs/dist/index.js");
var $iVrL9$radixuireactcontext = __webpack_require__(/*! @radix-ui/react-context */ "../../../node_modules/@radix-ui/react-context/dist/index.js");
var $iVrL9$radixuireactdismissablelayer = __webpack_require__(/*! @radix-ui/react-dismissable-layer */ "../../../node_modules/@radix-ui/react-dismissable-layer/dist/index.js");
var $iVrL9$radixuireactid = __webpack_require__(/*! @radix-ui/react-id */ "../../../node_modules/@radix-ui/react-id/dist/index.js");
var $iVrL9$radixuireactpopper = __webpack_require__(/*! @radix-ui/react-popper */ "../../../node_modules/@radix-ui/react-popper/dist/index.js");
var $iVrL9$radixuireactportal = __webpack_require__(/*! @radix-ui/react-portal */ "../../../node_modules/@radix-ui/react-portal/dist/index.js");
var $iVrL9$radixuireactpresence = __webpack_require__(/*! @radix-ui/react-presence */ "../../../node_modules/@radix-ui/react-presence/dist/index.js");
var $iVrL9$radixuireactprimitive = __webpack_require__(/*! @radix-ui/react-primitive */ "../../../node_modules/@radix-ui/react-primitive/dist/index.js");
var $iVrL9$radixuireactslot = __webpack_require__(/*! @radix-ui/react-slot */ "../../../node_modules/@radix-ui/react-slot/dist/index.js");
var $iVrL9$radixuireactusecontrollablestate = __webpack_require__(/*! @radix-ui/react-use-controllable-state */ "../../../node_modules/@radix-ui/react-use-controllable-state/dist/index.js");
var $iVrL9$radixuireactvisuallyhidden = __webpack_require__(/*! @radix-ui/react-visually-hidden */ "../../../node_modules/@radix-ui/react-visually-hidden/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "createTooltipScope", () => $c34afbc43c90cc6f$export$1c540a2224f0d865);
$parcel$export(module.exports, "TooltipProvider", () => $c34afbc43c90cc6f$export$f78649fb9ca566b8);
$parcel$export(module.exports, "Tooltip", () => $c34afbc43c90cc6f$export$28c660c63b792dea);
$parcel$export(module.exports, "TooltipTrigger", () => $c34afbc43c90cc6f$export$8c610744efcf8a1d);
$parcel$export(module.exports, "TooltipPortal", () => $c34afbc43c90cc6f$export$7b36b8f925ab7497);
$parcel$export(module.exports, "TooltipContent", () => $c34afbc43c90cc6f$export$e9003e2be37ec060);
$parcel$export(module.exports, "TooltipArrow", () => $c34afbc43c90cc6f$export$c27ee0ad710f7559);
$parcel$export(module.exports, "Provider", () => $c34afbc43c90cc6f$export$2881499e37b75b9a);
$parcel$export(module.exports, "Root", () => $c34afbc43c90cc6f$export$be92b6f5f03c0fe9);
$parcel$export(module.exports, "Trigger", () => $c34afbc43c90cc6f$export$41fb9f06171c75f4);
$parcel$export(module.exports, "Portal", () => $c34afbc43c90cc6f$export$602eac185826482c);
$parcel$export(module.exports, "Content", () => $c34afbc43c90cc6f$export$7c6e2c02157bb7d2);
$parcel$export(module.exports, "Arrow", () => $c34afbc43c90cc6f$export$21b07c8f274aebd5);
const [$c34afbc43c90cc6f$var$createTooltipContext, $c34afbc43c90cc6f$export$1c540a2224f0d865] = $iVrL9$radixuireactcontext.createContextScope('Tooltip', [$iVrL9$radixuireactpopper.createPopperScope]);
const $c34afbc43c90cc6f$var$usePopperScope = $iVrL9$radixuireactpopper.createPopperScope();
/* -------------------------------------------------------------------------------------------------
 * TooltipProvider
 * -----------------------------------------------------------------------------------------------*/
const $c34afbc43c90cc6f$var$PROVIDER_NAME = 'TooltipProvider';
const $c34afbc43c90cc6f$var$DEFAULT_DELAY_DURATION = 700;
const $c34afbc43c90cc6f$var$TOOLTIP_OPEN = 'tooltip.open';
const [$c34afbc43c90cc6f$var$TooltipProviderContextProvider, $c34afbc43c90cc6f$var$useTooltipProviderContext] = $c34afbc43c90cc6f$var$createTooltipContext($c34afbc43c90cc6f$var$PROVIDER_NAME);
const $c34afbc43c90cc6f$export$f78649fb9ca566b8 = props => {
  const {
    __scopeTooltip: __scopeTooltip,
    delayDuration = $c34afbc43c90cc6f$var$DEFAULT_DELAY_DURATION,
    skipDelayDuration = 300,
    disableHoverableContent = false,
    children: children
  } = props;
  const [isOpenDelayed, setIsOpenDelayed] = $iVrL9$react.useState(true);
  const isPointerInTransitRef = $iVrL9$react.useRef(false);
  const skipDelayTimerRef = $iVrL9$react.useRef(0);
  $iVrL9$react.useEffect(() => {
    const skipDelayTimer = skipDelayTimerRef.current;
    return () => window.clearTimeout(skipDelayTimer);
  }, []);
  return /*#__PURE__*/$iVrL9$react.createElement($c34afbc43c90cc6f$var$TooltipProviderContextProvider, {
    scope: __scopeTooltip,
    isOpenDelayed: isOpenDelayed,
    delayDuration: delayDuration,
    onOpen: $iVrL9$react.useCallback(() => {
      window.clearTimeout(skipDelayTimerRef.current);
      setIsOpenDelayed(false);
    }, []),
    onClose: $iVrL9$react.useCallback(() => {
      window.clearTimeout(skipDelayTimerRef.current);
      skipDelayTimerRef.current = window.setTimeout(() => setIsOpenDelayed(true), skipDelayDuration);
    }, [skipDelayDuration]),
    isPointerInTransitRef: isPointerInTransitRef,
    onPointerInTransitChange: $iVrL9$react.useCallback(inTransit => {
      isPointerInTransitRef.current = inTransit;
    }, []),
    disableHoverableContent: disableHoverableContent
  }, children);
};
/*#__PURE__*/
Object.assign($c34afbc43c90cc6f$export$f78649fb9ca566b8, {
  displayName: $c34afbc43c90cc6f$var$PROVIDER_NAME
});
/* -------------------------------------------------------------------------------------------------
 * Tooltip
 * -----------------------------------------------------------------------------------------------*/
const $c34afbc43c90cc6f$var$TOOLTIP_NAME = 'Tooltip';
const [$c34afbc43c90cc6f$var$TooltipContextProvider, $c34afbc43c90cc6f$var$useTooltipContext] = $c34afbc43c90cc6f$var$createTooltipContext($c34afbc43c90cc6f$var$TOOLTIP_NAME);
const $c34afbc43c90cc6f$export$28c660c63b792dea = props => {
  const {
    __scopeTooltip: __scopeTooltip,
    children: children,
    open: openProp,
    defaultOpen = false,
    onOpenChange: onOpenChange,
    disableHoverableContent: disableHoverableContentProp,
    delayDuration: delayDurationProp
  } = props;
  const providerContext = $c34afbc43c90cc6f$var$useTooltipProviderContext($c34afbc43c90cc6f$var$TOOLTIP_NAME, props.__scopeTooltip);
  const popperScope = $c34afbc43c90cc6f$var$usePopperScope(__scopeTooltip);
  const [trigger, setTrigger] = $iVrL9$react.useState(null);
  const contentId = $iVrL9$radixuireactid.useId();
  const openTimerRef = $iVrL9$react.useRef(0);
  const disableHoverableContent = disableHoverableContentProp !== null && disableHoverableContentProp !== void 0 ? disableHoverableContentProp : providerContext.disableHoverableContent;
  const delayDuration = delayDurationProp !== null && delayDurationProp !== void 0 ? delayDurationProp : providerContext.delayDuration;
  const wasOpenDelayedRef = $iVrL9$react.useRef(false);
  const [open1 = false, setOpen] = $iVrL9$radixuireactusecontrollablestate.useControllableState({
    prop: openProp,
    defaultProp: defaultOpen,
    onChange: open => {
      if (open) {
        providerContext.onOpen(); // as `onChange` is called within a lifecycle method we
        // avoid dispatching via `dispatchDiscreteCustomEvent`.
        document.dispatchEvent(new CustomEvent($c34afbc43c90cc6f$var$TOOLTIP_OPEN));
      } else providerContext.onClose();
      onOpenChange === null || onOpenChange === void 0 || onOpenChange(open);
    }
  });
  const stateAttribute = $iVrL9$react.useMemo(() => {
    return open1 ? wasOpenDelayedRef.current ? 'delayed-open' : 'instant-open' : 'closed';
  }, [open1]);
  const handleOpen = $iVrL9$react.useCallback(() => {
    window.clearTimeout(openTimerRef.current);
    wasOpenDelayedRef.current = false;
    setOpen(true);
  }, [setOpen]);
  const handleClose = $iVrL9$react.useCallback(() => {
    window.clearTimeout(openTimerRef.current);
    setOpen(false);
  }, [setOpen]);
  const handleDelayedOpen = $iVrL9$react.useCallback(() => {
    window.clearTimeout(openTimerRef.current);
    openTimerRef.current = window.setTimeout(() => {
      wasOpenDelayedRef.current = true;
      setOpen(true);
    }, delayDuration);
  }, [delayDuration, setOpen]);
  $iVrL9$react.useEffect(() => {
    return () => window.clearTimeout(openTimerRef.current);
  }, []);
  return /*#__PURE__*/$iVrL9$react.createElement($iVrL9$radixuireactpopper.Root, popperScope, /*#__PURE__*/$iVrL9$react.createElement($c34afbc43c90cc6f$var$TooltipContextProvider, {
    scope: __scopeTooltip,
    contentId: contentId,
    open: open1,
    stateAttribute: stateAttribute,
    trigger: trigger,
    onTriggerChange: setTrigger,
    onTriggerEnter: $iVrL9$react.useCallback(() => {
      if (providerContext.isOpenDelayed) handleDelayedOpen();else handleOpen();
    }, [providerContext.isOpenDelayed, handleDelayedOpen, handleOpen]),
    onTriggerLeave: $iVrL9$react.useCallback(() => {
      if (disableHoverableContent) handleClose();else
        // Clear the timer in case the pointer leaves the trigger before the tooltip is opened.
        window.clearTimeout(openTimerRef.current);
    }, [handleClose, disableHoverableContent]),
    onOpen: handleOpen,
    onClose: handleClose,
    disableHoverableContent: disableHoverableContent
  }, children));
};
/*#__PURE__*/
Object.assign($c34afbc43c90cc6f$export$28c660c63b792dea, {
  displayName: $c34afbc43c90cc6f$var$TOOLTIP_NAME
});
/* -------------------------------------------------------------------------------------------------
 * TooltipTrigger
 * -----------------------------------------------------------------------------------------------*/
const $c34afbc43c90cc6f$var$TRIGGER_NAME = 'TooltipTrigger';
const $c34afbc43c90cc6f$export$8c610744efcf8a1d = /*#__PURE__*/$iVrL9$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeTooltip: __scopeTooltip,
    ...triggerProps
  } = props;
  const context = $c34afbc43c90cc6f$var$useTooltipContext($c34afbc43c90cc6f$var$TRIGGER_NAME, __scopeTooltip);
  const providerContext = $c34afbc43c90cc6f$var$useTooltipProviderContext($c34afbc43c90cc6f$var$TRIGGER_NAME, __scopeTooltip);
  const popperScope = $c34afbc43c90cc6f$var$usePopperScope(__scopeTooltip);
  const ref = $iVrL9$react.useRef(null);
  const composedRefs = $iVrL9$radixuireactcomposerefs.useComposedRefs(forwardedRef, ref, context.onTriggerChange);
  const isPointerDownRef = $iVrL9$react.useRef(false);
  const hasPointerMoveOpenedRef = $iVrL9$react.useRef(false);
  const handlePointerUp = $iVrL9$react.useCallback(() => isPointerDownRef.current = false, []);
  $iVrL9$react.useEffect(() => {
    return () => document.removeEventListener('pointerup', handlePointerUp);
  }, [handlePointerUp]);
  return /*#__PURE__*/$iVrL9$react.createElement($iVrL9$radixuireactpopper.Anchor, $parcel$interopDefault($iVrL9$babelruntimehelpersextends)({
    asChild: true
  }, popperScope), /*#__PURE__*/$iVrL9$react.createElement($iVrL9$radixuireactprimitive.Primitive.button, $parcel$interopDefault($iVrL9$babelruntimehelpersextends)({
    // We purposefully avoid adding `type=button` here because tooltip triggers are also
    // commonly anchors and the anchor `type` attribute signifies MIME type.
    "aria-describedby": context.open ? context.contentId : undefined,
    "data-state": context.stateAttribute
  }, triggerProps, {
    ref: composedRefs,
    onPointerMove: $iVrL9$radixuiprimitive.composeEventHandlers(props.onPointerMove, event => {
      if (event.pointerType === 'touch') return;
      if (!hasPointerMoveOpenedRef.current && !providerContext.isPointerInTransitRef.current) {
        context.onTriggerEnter();
        hasPointerMoveOpenedRef.current = true;
      }
    }),
    onPointerLeave: $iVrL9$radixuiprimitive.composeEventHandlers(props.onPointerLeave, () => {
      context.onTriggerLeave();
      hasPointerMoveOpenedRef.current = false;
    }),
    onPointerDown: $iVrL9$radixuiprimitive.composeEventHandlers(props.onPointerDown, () => {
      isPointerDownRef.current = true;
      document.addEventListener('pointerup', handlePointerUp, {
        once: true
      });
    }),
    onFocus: $iVrL9$radixuiprimitive.composeEventHandlers(props.onFocus, () => {
      if (!isPointerDownRef.current) context.onOpen();
    }),
    onBlur: $iVrL9$radixuiprimitive.composeEventHandlers(props.onBlur, context.onClose),
    onClick: $iVrL9$radixuiprimitive.composeEventHandlers(props.onClick, context.onClose)
  })));
});
/*#__PURE__*/
Object.assign($c34afbc43c90cc6f$export$8c610744efcf8a1d, {
  displayName: $c34afbc43c90cc6f$var$TRIGGER_NAME
});
/* -------------------------------------------------------------------------------------------------
 * TooltipPortal
 * -----------------------------------------------------------------------------------------------*/
const $c34afbc43c90cc6f$var$PORTAL_NAME = 'TooltipPortal';
const [$c34afbc43c90cc6f$var$PortalProvider, $c34afbc43c90cc6f$var$usePortalContext] = $c34afbc43c90cc6f$var$createTooltipContext($c34afbc43c90cc6f$var$PORTAL_NAME, {
  forceMount: undefined
});
const $c34afbc43c90cc6f$export$7b36b8f925ab7497 = props => {
  const {
    __scopeTooltip: __scopeTooltip,
    forceMount: forceMount,
    children: children,
    container: container
  } = props;
  const context = $c34afbc43c90cc6f$var$useTooltipContext($c34afbc43c90cc6f$var$PORTAL_NAME, __scopeTooltip);
  return /*#__PURE__*/$iVrL9$react.createElement($c34afbc43c90cc6f$var$PortalProvider, {
    scope: __scopeTooltip,
    forceMount: forceMount
  }, /*#__PURE__*/$iVrL9$react.createElement($iVrL9$radixuireactpresence.Presence, {
    present: forceMount || context.open
  }, /*#__PURE__*/$iVrL9$react.createElement($iVrL9$radixuireactportal.Portal, {
    asChild: true,
    container: container
  }, children)));
};
/*#__PURE__*/
Object.assign($c34afbc43c90cc6f$export$7b36b8f925ab7497, {
  displayName: $c34afbc43c90cc6f$var$PORTAL_NAME
});
/* -------------------------------------------------------------------------------------------------
 * TooltipContent
 * -----------------------------------------------------------------------------------------------*/
const $c34afbc43c90cc6f$var$CONTENT_NAME = 'TooltipContent';
const $c34afbc43c90cc6f$export$e9003e2be37ec060 = /*#__PURE__*/$iVrL9$react.forwardRef((props, forwardedRef) => {
  const portalContext = $c34afbc43c90cc6f$var$usePortalContext($c34afbc43c90cc6f$var$CONTENT_NAME, props.__scopeTooltip);
  const {
    forceMount = portalContext.forceMount,
    side = 'top',
    ...contentProps
  } = props;
  const context = $c34afbc43c90cc6f$var$useTooltipContext($c34afbc43c90cc6f$var$CONTENT_NAME, props.__scopeTooltip);
  return /*#__PURE__*/$iVrL9$react.createElement($iVrL9$radixuireactpresence.Presence, {
    present: forceMount || context.open
  }, context.disableHoverableContent ? /*#__PURE__*/$iVrL9$react.createElement($c34afbc43c90cc6f$var$TooltipContentImpl, $parcel$interopDefault($iVrL9$babelruntimehelpersextends)({
    side: side
  }, contentProps, {
    ref: forwardedRef
  })) : /*#__PURE__*/$iVrL9$react.createElement($c34afbc43c90cc6f$var$TooltipContentHoverable, $parcel$interopDefault($iVrL9$babelruntimehelpersextends)({
    side: side
  }, contentProps, {
    ref: forwardedRef
  })));
});
const $c34afbc43c90cc6f$var$TooltipContentHoverable = /*#__PURE__*/$iVrL9$react.forwardRef((props, forwardedRef) => {
  const context = $c34afbc43c90cc6f$var$useTooltipContext($c34afbc43c90cc6f$var$CONTENT_NAME, props.__scopeTooltip);
  const providerContext = $c34afbc43c90cc6f$var$useTooltipProviderContext($c34afbc43c90cc6f$var$CONTENT_NAME, props.__scopeTooltip);
  const ref = $iVrL9$react.useRef(null);
  const composedRefs = $iVrL9$radixuireactcomposerefs.useComposedRefs(forwardedRef, ref);
  const [pointerGraceArea, setPointerGraceArea] = $iVrL9$react.useState(null);
  const {
    trigger: trigger,
    onClose: onClose
  } = context;
  const content = ref.current;
  const {
    onPointerInTransitChange: onPointerInTransitChange
  } = providerContext;
  const handleRemoveGraceArea = $iVrL9$react.useCallback(() => {
    setPointerGraceArea(null);
    onPointerInTransitChange(false);
  }, [onPointerInTransitChange]);
  const handleCreateGraceArea = $iVrL9$react.useCallback((event, hoverTarget) => {
    const currentTarget = event.currentTarget;
    const exitPoint = {
      x: event.clientX,
      y: event.clientY
    };
    const exitSide = $c34afbc43c90cc6f$var$getExitSideFromRect(exitPoint, currentTarget.getBoundingClientRect());
    const paddedExitPoints = $c34afbc43c90cc6f$var$getPaddedExitPoints(exitPoint, exitSide);
    const hoverTargetPoints = $c34afbc43c90cc6f$var$getPointsFromRect(hoverTarget.getBoundingClientRect());
    const graceArea = $c34afbc43c90cc6f$var$getHull([...paddedExitPoints, ...hoverTargetPoints]);
    setPointerGraceArea(graceArea);
    onPointerInTransitChange(true);
  }, [onPointerInTransitChange]);
  $iVrL9$react.useEffect(() => {
    return () => handleRemoveGraceArea();
  }, [handleRemoveGraceArea]);
  $iVrL9$react.useEffect(() => {
    if (trigger && content) {
      const handleTriggerLeave = event => handleCreateGraceArea(event, content);
      const handleContentLeave = event => handleCreateGraceArea(event, trigger);
      trigger.addEventListener('pointerleave', handleTriggerLeave);
      content.addEventListener('pointerleave', handleContentLeave);
      return () => {
        trigger.removeEventListener('pointerleave', handleTriggerLeave);
        content.removeEventListener('pointerleave', handleContentLeave);
      };
    }
  }, [trigger, content, handleCreateGraceArea, handleRemoveGraceArea]);
  $iVrL9$react.useEffect(() => {
    if (pointerGraceArea) {
      const handleTrackPointerGrace = event => {
        const target = event.target;
        const pointerPosition = {
          x: event.clientX,
          y: event.clientY
        };
        const hasEnteredTarget = (trigger === null || trigger === void 0 ? void 0 : trigger.contains(target)) || (content === null || content === void 0 ? void 0 : content.contains(target));
        const isPointerOutsideGraceArea = !$c34afbc43c90cc6f$var$isPointInPolygon(pointerPosition, pointerGraceArea);
        if (hasEnteredTarget) handleRemoveGraceArea();else if (isPointerOutsideGraceArea) {
          handleRemoveGraceArea();
          onClose();
        }
      };
      document.addEventListener('pointermove', handleTrackPointerGrace);
      return () => document.removeEventListener('pointermove', handleTrackPointerGrace);
    }
  }, [trigger, content, pointerGraceArea, onClose, handleRemoveGraceArea]);
  return /*#__PURE__*/$iVrL9$react.createElement($c34afbc43c90cc6f$var$TooltipContentImpl, $parcel$interopDefault($iVrL9$babelruntimehelpersextends)({}, props, {
    ref: composedRefs
  }));
});
const [$c34afbc43c90cc6f$var$VisuallyHiddenContentContextProvider, $c34afbc43c90cc6f$var$useVisuallyHiddenContentContext] = $c34afbc43c90cc6f$var$createTooltipContext($c34afbc43c90cc6f$var$TOOLTIP_NAME, {
  isInside: false
});
const $c34afbc43c90cc6f$var$TooltipContentImpl = /*#__PURE__*/$iVrL9$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeTooltip: __scopeTooltip,
    children: children,
    'aria-label': ariaLabel,
    onEscapeKeyDown: onEscapeKeyDown,
    onPointerDownOutside: onPointerDownOutside,
    ...contentProps
  } = props;
  const context = $c34afbc43c90cc6f$var$useTooltipContext($c34afbc43c90cc6f$var$CONTENT_NAME, __scopeTooltip);
  const popperScope = $c34afbc43c90cc6f$var$usePopperScope(__scopeTooltip);
  const {
    onClose: onClose
  } = context; // Close this tooltip if another one opens
  $iVrL9$react.useEffect(() => {
    document.addEventListener($c34afbc43c90cc6f$var$TOOLTIP_OPEN, onClose);
    return () => document.removeEventListener($c34afbc43c90cc6f$var$TOOLTIP_OPEN, onClose);
  }, [onClose]); // Close the tooltip if the trigger is scrolled
  $iVrL9$react.useEffect(() => {
    if (context.trigger) {
      const handleScroll = event => {
        const target = event.target;
        if (target !== null && target !== void 0 && target.contains(context.trigger)) onClose();
      };
      window.addEventListener('scroll', handleScroll, {
        capture: true
      });
      return () => window.removeEventListener('scroll', handleScroll, {
        capture: true
      });
    }
  }, [context.trigger, onClose]);
  return /*#__PURE__*/$iVrL9$react.createElement($iVrL9$radixuireactdismissablelayer.DismissableLayer, {
    asChild: true,
    disableOutsidePointerEvents: false,
    onEscapeKeyDown: onEscapeKeyDown,
    onPointerDownOutside: onPointerDownOutside,
    onFocusOutside: event => event.preventDefault(),
    onDismiss: onClose
  }, /*#__PURE__*/$iVrL9$react.createElement($iVrL9$radixuireactpopper.Content, $parcel$interopDefault($iVrL9$babelruntimehelpersextends)({
    "data-state": context.stateAttribute
  }, popperScope, contentProps, {
    ref: forwardedRef,
    style: {
      ...contentProps.style,
      '--radix-tooltip-content-transform-origin': 'var(--radix-popper-transform-origin)',
      '--radix-tooltip-content-available-width': 'var(--radix-popper-available-width)',
      '--radix-tooltip-content-available-height': 'var(--radix-popper-available-height)',
      '--radix-tooltip-trigger-width': 'var(--radix-popper-anchor-width)',
      '--radix-tooltip-trigger-height': 'var(--radix-popper-anchor-height)'
    }
  }), /*#__PURE__*/$iVrL9$react.createElement($iVrL9$radixuireactslot.Slottable, null, children), /*#__PURE__*/$iVrL9$react.createElement($c34afbc43c90cc6f$var$VisuallyHiddenContentContextProvider, {
    scope: __scopeTooltip,
    isInside: true
  }, /*#__PURE__*/$iVrL9$react.createElement($iVrL9$radixuireactvisuallyhidden.Root, {
    id: context.contentId,
    role: "tooltip"
  }, ariaLabel || children))));
});
/*#__PURE__*/
Object.assign($c34afbc43c90cc6f$export$e9003e2be37ec060, {
  displayName: $c34afbc43c90cc6f$var$CONTENT_NAME
});
/* -------------------------------------------------------------------------------------------------
 * TooltipArrow
 * -----------------------------------------------------------------------------------------------*/
const $c34afbc43c90cc6f$var$ARROW_NAME = 'TooltipArrow';
const $c34afbc43c90cc6f$export$c27ee0ad710f7559 = /*#__PURE__*/$iVrL9$react.forwardRef((props, forwardedRef) => {
  const {
    __scopeTooltip: __scopeTooltip,
    ...arrowProps
  } = props;
  const popperScope = $c34afbc43c90cc6f$var$usePopperScope(__scopeTooltip);
  const visuallyHiddenContentContext = $c34afbc43c90cc6f$var$useVisuallyHiddenContentContext($c34afbc43c90cc6f$var$ARROW_NAME, __scopeTooltip); // if the arrow is inside the `VisuallyHidden`, we don't want to render it all to
  // prevent issues in positioning the arrow due to the duplicate
  return visuallyHiddenContentContext.isInside ? null : /*#__PURE__*/$iVrL9$react.createElement($iVrL9$radixuireactpopper.Arrow, $parcel$interopDefault($iVrL9$babelruntimehelpersextends)({}, popperScope, arrowProps, {
    ref: forwardedRef
  }));
});
/*#__PURE__*/
Object.assign($c34afbc43c90cc6f$export$c27ee0ad710f7559, {
  displayName: $c34afbc43c90cc6f$var$ARROW_NAME
});
/* -----------------------------------------------------------------------------------------------*/
function $c34afbc43c90cc6f$var$getExitSideFromRect(point, rect) {
  const top = Math.abs(rect.top - point.y);
  const bottom = Math.abs(rect.bottom - point.y);
  const right = Math.abs(rect.right - point.x);
  const left = Math.abs(rect.left - point.x);
  switch (Math.min(top, bottom, right, left)) {
    case left:
      return 'left';
    case right:
      return 'right';
    case top:
      return 'top';
    case bottom:
      return 'bottom';
    default:
      throw new Error('unreachable');
  }
}
function $c34afbc43c90cc6f$var$getPaddedExitPoints(exitPoint, exitSide, padding = 5) {
  const paddedExitPoints = [];
  switch (exitSide) {
    case 'top':
      paddedExitPoints.push({
        x: exitPoint.x - padding,
        y: exitPoint.y + padding
      }, {
        x: exitPoint.x + padding,
        y: exitPoint.y + padding
      });
      break;
    case 'bottom':
      paddedExitPoints.push({
        x: exitPoint.x - padding,
        y: exitPoint.y - padding
      }, {
        x: exitPoint.x + padding,
        y: exitPoint.y - padding
      });
      break;
    case 'left':
      paddedExitPoints.push({
        x: exitPoint.x + padding,
        y: exitPoint.y - padding
      }, {
        x: exitPoint.x + padding,
        y: exitPoint.y + padding
      });
      break;
    case 'right':
      paddedExitPoints.push({
        x: exitPoint.x - padding,
        y: exitPoint.y - padding
      }, {
        x: exitPoint.x - padding,
        y: exitPoint.y + padding
      });
      break;
  }
  return paddedExitPoints;
}
function $c34afbc43c90cc6f$var$getPointsFromRect(rect) {
  const {
    top: top,
    right: right,
    bottom: bottom,
    left: left
  } = rect;
  return [{
    x: left,
    y: top
  }, {
    x: right,
    y: top
  }, {
    x: right,
    y: bottom
  }, {
    x: left,
    y: bottom
  }];
} // Determine if a point is inside of a polygon.
// Based on https://github.com/substack/point-in-polygon
function $c34afbc43c90cc6f$var$isPointInPolygon(point, polygon) {
  const {
    x: x,
    y: y
  } = point;
  let inside = false;
  for (let i = 0, j = polygon.length - 1; i < polygon.length; j = i++) {
    const xi = polygon[i].x;
    const yi = polygon[i].y;
    const xj = polygon[j].x;
    const yj = polygon[j].y; // prettier-ignore
    const intersect = yi > y !== yj > y && x < (xj - xi) * (y - yi) / (yj - yi) + xi;
    if (intersect) inside = !inside;
  }
  return inside;
} // Returns a new array of points representing the convex hull of the given set of points.
// https://www.nayuki.io/page/convex-hull-algorithm
function $c34afbc43c90cc6f$var$getHull(points) {
  const newPoints = points.slice();
  newPoints.sort((a, b) => {
    if (a.x < b.x) return -1;else if (a.x > b.x) return 1;else if (a.y < b.y) return -1;else if (a.y > b.y) return 1;else return 0;
  });
  return $c34afbc43c90cc6f$var$getHullPresorted(newPoints);
} // Returns the convex hull, assuming that each points[i] <= points[i + 1]. Runs in O(n) time.
function $c34afbc43c90cc6f$var$getHullPresorted(points) {
  if (points.length <= 1) return points.slice();
  const upperHull = [];
  for (let i = 0; i < points.length; i++) {
    const p = points[i];
    while (upperHull.length >= 2) {
      const q = upperHull[upperHull.length - 1];
      const r = upperHull[upperHull.length - 2];
      if ((q.x - r.x) * (p.y - r.y) >= (q.y - r.y) * (p.x - r.x)) upperHull.pop();else break;
    }
    upperHull.push(p);
  }
  upperHull.pop();
  const lowerHull = [];
  for (let i1 = points.length - 1; i1 >= 0; i1--) {
    const p = points[i1];
    while (lowerHull.length >= 2) {
      const q = lowerHull[lowerHull.length - 1];
      const r = lowerHull[lowerHull.length - 2];
      if ((q.x - r.x) * (p.y - r.y) >= (q.y - r.y) * (p.x - r.x)) lowerHull.pop();else break;
    }
    lowerHull.push(p);
  }
  lowerHull.pop();
  if (upperHull.length === 1 && lowerHull.length === 1 && upperHull[0].x === lowerHull[0].x && upperHull[0].y === lowerHull[0].y) return upperHull;else return upperHull.concat(lowerHull);
}
const $c34afbc43c90cc6f$export$2881499e37b75b9a = $c34afbc43c90cc6f$export$f78649fb9ca566b8;
const $c34afbc43c90cc6f$export$be92b6f5f03c0fe9 = $c34afbc43c90cc6f$export$28c660c63b792dea;
const $c34afbc43c90cc6f$export$41fb9f06171c75f4 = $c34afbc43c90cc6f$export$8c610744efcf8a1d;
const $c34afbc43c90cc6f$export$602eac185826482c = $c34afbc43c90cc6f$export$7b36b8f925ab7497;
const $c34afbc43c90cc6f$export$7c6e2c02157bb7d2 = $c34afbc43c90cc6f$export$e9003e2be37ec060;
const $c34afbc43c90cc6f$export$21b07c8f274aebd5 = $c34afbc43c90cc6f$export$c27ee0ad710f7559;

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-use-callback-ref/dist/index.js":
/*!****************************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-use-callback-ref/dist/index.js ***!
  \****************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $92muK$react = __webpack_require__(/*! react */ "react");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "useCallbackRef", () => $28e03942f763e819$export$25bec8c6f54ee79a);

/**
 * A custom hook that converts a callback to a ref to avoid triggering re-renders when passed as a
 * prop or avoid re-executing effects when passed as a dependency
 */
function $28e03942f763e819$export$25bec8c6f54ee79a(callback) {
  const callbackRef = $92muK$react.useRef(callback);
  $92muK$react.useEffect(() => {
    callbackRef.current = callback;
  }); // https://github.com/facebook/react/issues/19240
  return $92muK$react.useMemo(() => (...args) => {
    var _callbackRef$current;
    return (_callbackRef$current = callbackRef.current) === null || _callbackRef$current === void 0 ? void 0 : _callbackRef$current.call(callbackRef, ...args);
  }, []);
}

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-use-controllable-state/dist/index.js":
/*!**********************************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-use-controllable-state/dist/index.js ***!
  \**********************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $ijazI$react = __webpack_require__(/*! react */ "react");
var $ijazI$radixuireactusecallbackref = __webpack_require__(/*! @radix-ui/react-use-callback-ref */ "../../../node_modules/@radix-ui/react-use-callback-ref/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "useControllableState", () => $b84d42d44371bff7$export$6f32135080cb4c3);
function $b84d42d44371bff7$export$6f32135080cb4c3({
  prop: prop,
  defaultProp: defaultProp,
  onChange = () => {}
}) {
  const [uncontrolledProp, setUncontrolledProp] = $b84d42d44371bff7$var$useUncontrolledState({
    defaultProp: defaultProp,
    onChange: onChange
  });
  const isControlled = prop !== undefined;
  const value1 = isControlled ? prop : uncontrolledProp;
  const handleChange = $ijazI$radixuireactusecallbackref.useCallbackRef(onChange);
  const setValue = $ijazI$react.useCallback(nextValue => {
    if (isControlled) {
      const setter = nextValue;
      const value = typeof nextValue === 'function' ? setter(prop) : nextValue;
      if (value !== prop) handleChange(value);
    } else setUncontrolledProp(nextValue);
  }, [isControlled, prop, setUncontrolledProp, handleChange]);
  return [value1, setValue];
}
function $b84d42d44371bff7$var$useUncontrolledState({
  defaultProp: defaultProp,
  onChange: onChange
}) {
  const uncontrolledState = $ijazI$react.useState(defaultProp);
  const [value] = uncontrolledState;
  const prevValueRef = $ijazI$react.useRef(value);
  const handleChange = $ijazI$radixuireactusecallbackref.useCallbackRef(onChange);
  $ijazI$react.useEffect(() => {
    if (prevValueRef.current !== value) {
      handleChange(value);
      prevValueRef.current = value;
    }
  }, [value, prevValueRef, handleChange]);
  return uncontrolledState;
}

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-use-escape-keydown/dist/index.js":
/*!******************************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-use-escape-keydown/dist/index.js ***!
  \******************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $b0gz3$react = __webpack_require__(/*! react */ "react");
var $b0gz3$radixuireactusecallbackref = __webpack_require__(/*! @radix-ui/react-use-callback-ref */ "../../../node_modules/@radix-ui/react-use-callback-ref/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "useEscapeKeydown", () => $24c84e9f83c4454f$export$3a72a57244d6e765);

/**
 * Listens for when the escape key is down
 */
function $24c84e9f83c4454f$export$3a72a57244d6e765(onEscapeKeyDownProp, ownerDocument = globalThis === null || globalThis === void 0 ? void 0 : globalThis.document) {
  const onEscapeKeyDown = $b0gz3$radixuireactusecallbackref.useCallbackRef(onEscapeKeyDownProp);
  $b0gz3$react.useEffect(() => {
    const handleKeyDown = event => {
      if (event.key === 'Escape') onEscapeKeyDown(event);
    };
    ownerDocument.addEventListener('keydown', handleKeyDown);
    return () => ownerDocument.removeEventListener('keydown', handleKeyDown);
  }, [onEscapeKeyDown, ownerDocument]);
}

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-use-layout-effect/dist/index.js":
/*!*****************************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-use-layout-effect/dist/index.js ***!
  \*****************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $caHyQ$react = __webpack_require__(/*! react */ "react");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "useLayoutEffect", () => $ca21affb0542a8a4$export$e5c5a5f917a5871c);

/**
 * On the server, React emits a warning when calling `useLayoutEffect`.
 * This is because neither `useLayoutEffect` nor `useEffect` run on the server.
 * We use this safe version which suppresses the warning by replacing it with a noop on the server.
 *
 * See: https://reactjs.org/docs/hooks-reference.html#uselayouteffect
 */
const $ca21affb0542a8a4$export$e5c5a5f917a5871c = Boolean(globalThis === null || globalThis === void 0 ? void 0 : globalThis.document) ? $caHyQ$react.useLayoutEffect : () => {};

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-use-size/dist/index.js":
/*!********************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-use-size/dist/index.js ***!
  \********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $ksDzM$react = __webpack_require__(/*! react */ "react");
var $ksDzM$radixuireactuselayouteffect = __webpack_require__(/*! @radix-ui/react-use-layout-effect */ "../../../node_modules/@radix-ui/react-use-layout-effect/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
$parcel$export(module.exports, "useSize", () => $d2c1d285af17635b$export$1ab7ae714698c4b8);
function $d2c1d285af17635b$export$1ab7ae714698c4b8(element) {
  const [size, setSize] = $ksDzM$react.useState(undefined);
  $ksDzM$radixuireactuselayouteffect.useLayoutEffect(() => {
    if (element) {
      // provide size as early as possible
      setSize({
        width: element.offsetWidth,
        height: element.offsetHeight
      });
      const resizeObserver = new ResizeObserver(entries => {
        if (!Array.isArray(entries)) return;
        // Since we only observe the one element, we don't need to loop over the
        // array
        if (!entries.length) return;
        const entry = entries[0];
        let width;
        let height;
        if ('borderBoxSize' in entry) {
          const borderSizeEntry = entry['borderBoxSize']; // iron out differences between browsers
          const borderSize = Array.isArray(borderSizeEntry) ? borderSizeEntry[0] : borderSizeEntry;
          width = borderSize['inlineSize'];
          height = borderSize['blockSize'];
        } else {
          // for browsers that don't support `borderBoxSize`
          // we calculate it ourselves to get the correct border box.
          width = element.offsetWidth;
          height = element.offsetHeight;
        }
        setSize({
          width: width,
          height: height
        });
      });
      resizeObserver.observe(element, {
        box: 'border-box'
      });
      return () => resizeObserver.unobserve(element);
    } else
      // We only want to reset to `undefined` when the element becomes `null`,
      // not if it changes to another element.
      setSize(undefined);
  }, [element]);
  return size;
}

/***/ }),

/***/ "../../../node_modules/@radix-ui/react-visually-hidden/dist/index.js":
/*!***************************************************************************!*\
  !*** ../../../node_modules/@radix-ui/react-visually-hidden/dist/index.js ***!
  \***************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var $awrN2$babelruntimehelpersextends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "../../../node_modules/@babel/runtime/helpers/extends.js");
var $awrN2$react = __webpack_require__(/*! react */ "react");
var $awrN2$radixuireactprimitive = __webpack_require__(/*! @radix-ui/react-primitive */ "../../../node_modules/@radix-ui/react-primitive/dist/index.js");
function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {
    get: v,
    set: s,
    enumerable: true,
    configurable: true
  });
}
function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
$parcel$export(module.exports, "VisuallyHidden", () => $685371e9c20848e2$export$439d29a4e110a164);
$parcel$export(module.exports, "Root", () => $685371e9c20848e2$export$be92b6f5f03c0fe9);

/* -------------------------------------------------------------------------------------------------
 * VisuallyHidden
 * -----------------------------------------------------------------------------------------------*/
const $685371e9c20848e2$var$NAME = 'VisuallyHidden';
const $685371e9c20848e2$export$439d29a4e110a164 = /*#__PURE__*/$awrN2$react.forwardRef((props, forwardedRef) => {
  return /*#__PURE__*/$awrN2$react.createElement($awrN2$radixuireactprimitive.Primitive.span, $parcel$interopDefault($awrN2$babelruntimehelpersextends)({}, props, {
    ref: forwardedRef,
    style: {
      // See: https://github.com/twbs/bootstrap/blob/master/scss/mixins/_screen-reader.scss
      position: 'absolute',
      border: 0,
      width: 1,
      height: 1,
      padding: 0,
      margin: -1,
      overflow: 'hidden',
      clip: 'rect(0, 0, 0, 0)',
      whiteSpace: 'nowrap',
      wordWrap: 'normal',
      ...props.style
    }
  }));
});
/*#__PURE__*/
Object.assign($685371e9c20848e2$export$439d29a4e110a164, {
  displayName: $685371e9c20848e2$var$NAME
});
/* -----------------------------------------------------------------------------------------------*/
const $685371e9c20848e2$export$be92b6f5f03c0fe9 = $685371e9c20848e2$export$439d29a4e110a164;

/***/ }),

/***/ "../../../node_modules/aria-hidden/dist/es2015/index.js":
/*!**************************************************************!*\
  !*** ../../../node_modules/aria-hidden/dist/es2015/index.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.suppressOthers = exports.supportsInert = exports.inertOthers = exports.hideOthers = void 0;
var getDefaultParent = function (originalTarget) {
  if (typeof document === 'undefined') {
    return null;
  }
  var sampleTarget = Array.isArray(originalTarget) ? originalTarget[0] : originalTarget;
  return sampleTarget.ownerDocument.body;
};
var counterMap = new WeakMap();
var uncontrolledNodes = new WeakMap();
var markerMap = {};
var lockCount = 0;
var unwrapHost = function (node) {
  return node && (node.host || unwrapHost(node.parentNode));
};
var correctTargets = function (parent, targets) {
  return targets.map(function (target) {
    if (parent.contains(target)) {
      return target;
    }
    var correctedTarget = unwrapHost(target);
    if (correctedTarget && parent.contains(correctedTarget)) {
      return correctedTarget;
    }
    console.error('aria-hidden', target, 'in not contained inside', parent, '. Doing nothing');
    return null;
  }).filter(function (x) {
    return Boolean(x);
  });
};
/**
 * Marks everything except given node(or nodes) as aria-hidden
 * @param {Element | Element[]} originalTarget - elements to keep on the page
 * @param [parentNode] - top element, defaults to document.body
 * @param {String} [markerName] - a special attribute to mark every node
 * @param {String} [controlAttribute] - html Attribute to control
 * @return {Undo} undo command
 */
var applyAttributeToOthers = function (originalTarget, parentNode, markerName, controlAttribute) {
  var targets = correctTargets(parentNode, Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
  if (!markerMap[markerName]) {
    markerMap[markerName] = new WeakMap();
  }
  var markerCounter = markerMap[markerName];
  var hiddenNodes = [];
  var elementsToKeep = new Set();
  var elementsToStop = new Set(targets);
  var keep = function (el) {
    if (!el || elementsToKeep.has(el)) {
      return;
    }
    elementsToKeep.add(el);
    keep(el.parentNode);
  };
  targets.forEach(keep);
  var deep = function (parent) {
    if (!parent || elementsToStop.has(parent)) {
      return;
    }
    Array.prototype.forEach.call(parent.children, function (node) {
      if (elementsToKeep.has(node)) {
        deep(node);
      } else {
        var attr = node.getAttribute(controlAttribute);
        var alreadyHidden = attr !== null && attr !== 'false';
        var counterValue = (counterMap.get(node) || 0) + 1;
        var markerValue = (markerCounter.get(node) || 0) + 1;
        counterMap.set(node, counterValue);
        markerCounter.set(node, markerValue);
        hiddenNodes.push(node);
        if (counterValue === 1 && alreadyHidden) {
          uncontrolledNodes.set(node, true);
        }
        if (markerValue === 1) {
          node.setAttribute(markerName, 'true');
        }
        if (!alreadyHidden) {
          node.setAttribute(controlAttribute, 'true');
        }
      }
    });
  };
  deep(parentNode);
  elementsToKeep.clear();
  lockCount++;
  return function () {
    hiddenNodes.forEach(function (node) {
      var counterValue = counterMap.get(node) - 1;
      var markerValue = markerCounter.get(node) - 1;
      counterMap.set(node, counterValue);
      markerCounter.set(node, markerValue);
      if (!counterValue) {
        if (!uncontrolledNodes.has(node)) {
          node.removeAttribute(controlAttribute);
        }
        uncontrolledNodes.delete(node);
      }
      if (!markerValue) {
        node.removeAttribute(markerName);
      }
    });
    lockCount--;
    if (!lockCount) {
      // clear
      counterMap = new WeakMap();
      counterMap = new WeakMap();
      uncontrolledNodes = new WeakMap();
      markerMap = {};
    }
  };
};
/**
 * Marks everything except given node(or nodes) as aria-hidden
 * @param {Element | Element[]} originalTarget - elements to keep on the page
 * @param [parentNode] - top element, defaults to document.body
 * @param {String} [markerName] - a special attribute to mark every node
 * @return {Undo} undo command
 */
var hideOthers = function (originalTarget, parentNode, markerName) {
  if (markerName === void 0) {
    markerName = 'data-aria-hidden';
  }
  var targets = Array.from(Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
  var activeParentNode = parentNode || getDefaultParent(originalTarget);
  if (!activeParentNode) {
    return function () {
      return null;
    };
  }
  // we should not hide ariaLive elements - https://github.com/theKashey/aria-hidden/issues/10
  targets.push.apply(targets, Array.from(activeParentNode.querySelectorAll('[aria-live]')));
  return applyAttributeToOthers(targets, activeParentNode, markerName, 'aria-hidden');
};
/**
 * Marks everything except given node(or nodes) as inert
 * @param {Element | Element[]} originalTarget - elements to keep on the page
 * @param [parentNode] - top element, defaults to document.body
 * @param {String} [markerName] - a special attribute to mark every node
 * @return {Undo} undo command
 */
exports.hideOthers = hideOthers;
var inertOthers = function (originalTarget, parentNode, markerName) {
  if (markerName === void 0) {
    markerName = 'data-inert-ed';
  }
  var activeParentNode = parentNode || getDefaultParent(originalTarget);
  if (!activeParentNode) {
    return function () {
      return null;
    };
  }
  return applyAttributeToOthers(originalTarget, activeParentNode, markerName, 'inert');
};
/**
 * @returns if current browser supports inert
 */
exports.inertOthers = inertOthers;
var supportsInert = function () {
  return typeof HTMLElement !== 'undefined' && HTMLElement.prototype.hasOwnProperty('inert');
};
/**
 * Automatic function to "suppress" DOM elements - _hide_ or _inert_ in the best possible way
 * @param {Element | Element[]} originalTarget - elements to keep on the page
 * @param [parentNode] - top element, defaults to document.body
 * @param {String} [markerName] - a special attribute to mark every node
 * @return {Undo} undo command
 */
exports.supportsInert = supportsInert;
var suppressOthers = function (originalTarget, parentNode, markerName) {
  if (markerName === void 0) {
    markerName = 'data-suppressed';
  }
  return (supportsInert() ? inertOthers : hideOthers)(originalTarget, parentNode, markerName);
};
exports.suppressOthers = suppressOthers;

/***/ }),

/***/ "../../../node_modules/clsx/dist/clsx.m.js":
/*!*************************************************!*\
  !*** ../../../node_modules/clsx/dist/clsx.m.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.clsx = clsx;
exports["default"] = void 0;
function r(e) {
  var t,
    f,
    n = "";
  if ("string" == typeof e || "number" == typeof e) n += e;else if ("object" == typeof e) if (Array.isArray(e)) for (t = 0; t < e.length; t++) e[t] && (f = r(e[t])) && (n && (n += " "), n += f);else for (t in e) e[t] && (n && (n += " "), n += t);
  return n;
}
function clsx() {
  for (var e, t, f = 0, n = ""; f < arguments.length;) (e = arguments[f++]) && (t = r(e)) && (n && (n += " "), n += t);
  return n;
}
var _default = exports["default"] = clsx;

/***/ }),

/***/ "../../../node_modules/copy-to-clipboard/index.js":
/*!********************************************************!*\
  !*** ../../../node_modules/copy-to-clipboard/index.js ***!
  \********************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {



var deselectCurrent = __webpack_require__(/*! toggle-selection */ "../../../node_modules/toggle-selection/index.js");
var clipboardToIE11Formatting = {
  "text/plain": "Text",
  "text/html": "Url",
  "default": "Text"
};
var defaultMessage = "Copy to clipboard: #{key}, Enter";
function format(message) {
  var copyKey = (/mac os x/i.test(navigator.userAgent) ? "⌘" : "Ctrl") + "+C";
  return message.replace(/#{\s*key\s*}/g, copyKey);
}
function copy(text, options) {
  var debug,
    message,
    reselectPrevious,
    range,
    selection,
    mark,
    success = false;
  if (!options) {
    options = {};
  }
  debug = options.debug || false;
  try {
    reselectPrevious = deselectCurrent();
    range = document.createRange();
    selection = document.getSelection();
    mark = document.createElement("span");
    mark.textContent = text;
    // avoid screen readers from reading out loud the text
    mark.ariaHidden = "true";
    // reset user styles for span element
    mark.style.all = "unset";
    // prevents scrolling to the end of the page
    mark.style.position = "fixed";
    mark.style.top = 0;
    mark.style.clip = "rect(0, 0, 0, 0)";
    // used to preserve spaces and line breaks
    mark.style.whiteSpace = "pre";
    // do not inherit user-select (it may be `none`)
    mark.style.webkitUserSelect = "text";
    mark.style.MozUserSelect = "text";
    mark.style.msUserSelect = "text";
    mark.style.userSelect = "text";
    mark.addEventListener("copy", function (e) {
      e.stopPropagation();
      if (options.format) {
        e.preventDefault();
        if (typeof e.clipboardData === "undefined") {
          // IE 11
          debug && console.warn("unable to use e.clipboardData");
          debug && console.warn("trying IE specific stuff");
          window.clipboardData.clearData();
          var format = clipboardToIE11Formatting[options.format] || clipboardToIE11Formatting["default"];
          window.clipboardData.setData(format, text);
        } else {
          // all other browsers
          e.clipboardData.clearData();
          e.clipboardData.setData(options.format, text);
        }
      }
      if (options.onCopy) {
        e.preventDefault();
        options.onCopy(e.clipboardData);
      }
    });
    document.body.appendChild(mark);
    range.selectNodeContents(mark);
    selection.addRange(range);
    var successful = document.execCommand("copy");
    if (!successful) {
      throw new Error("copy command was unsuccessful");
    }
    success = true;
  } catch (err) {
    debug && console.error("unable to copy using execCommand: ", err);
    debug && console.warn("trying IE specific stuff");
    try {
      window.clipboardData.setData(options.format || "text", text);
      options.onCopy && options.onCopy(window.clipboardData);
      success = true;
    } catch (err) {
      debug && console.error("unable to copy using clipboardData: ", err);
      debug && console.error("falling back to prompt");
      message = format("message" in options ? options.message : defaultMessage);
      window.prompt(message, text);
    }
  } finally {
    if (selection) {
      if (typeof selection.removeRange == "function") {
        selection.removeRange(range);
      } else {
        selection.removeAllRanges();
      }
    }
    if (mark) {
      document.body.removeChild(mark);
    }
    reselectPrevious();
  }
  return success;
}
module.exports = copy;

/***/ }),

/***/ "../../../node_modules/detect-node-es/esm/browser.js":
/*!***********************************************************!*\
  !*** ../../../node_modules/detect-node-es/esm/browser.js ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isNode = void 0;
const isNode = exports.isNode = false;

/***/ }),

/***/ "../../../node_modules/entities/lib/decode.js":
/*!****************************************************!*\
  !*** ../../../node_modules/entities/lib/decode.js ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __setModuleDefault = void 0 && (void 0).__setModuleDefault || (Object.create ? function (o, v) {
  Object.defineProperty(o, "default", {
    enumerable: true,
    value: v
  });
} : function (o, v) {
  o["default"] = v;
});
var __importStar = void 0 && (void 0).__importStar || function (mod) {
  if (mod && mod.__esModule) return mod;
  var result = {};
  if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
  __setModuleDefault(result, mod);
  return result;
};
var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.decodeXML = exports.decodeHTMLStrict = exports.decodeHTMLAttribute = exports.decodeHTML = exports.determineBranch = exports.EntityDecoder = exports.DecodingMode = exports.BinTrieFlags = exports.fromCodePoint = exports.replaceCodePoint = exports.decodeCodePoint = exports.xmlDecodeTree = exports.htmlDecodeTree = void 0;
var decode_data_html_js_1 = __importDefault(__webpack_require__(/*! ./generated/decode-data-html.js */ "../../../node_modules/entities/lib/generated/decode-data-html.js"));
exports.htmlDecodeTree = decode_data_html_js_1.default;
var decode_data_xml_js_1 = __importDefault(__webpack_require__(/*! ./generated/decode-data-xml.js */ "../../../node_modules/entities/lib/generated/decode-data-xml.js"));
exports.xmlDecodeTree = decode_data_xml_js_1.default;
var decode_codepoint_js_1 = __importStar(__webpack_require__(/*! ./decode_codepoint.js */ "../../../node_modules/entities/lib/decode_codepoint.js"));
exports.decodeCodePoint = decode_codepoint_js_1.default;
var decode_codepoint_js_2 = __webpack_require__(/*! ./decode_codepoint.js */ "../../../node_modules/entities/lib/decode_codepoint.js");
Object.defineProperty(exports, "replaceCodePoint", ({
  enumerable: true,
  get: function () {
    return decode_codepoint_js_2.replaceCodePoint;
  }
}));
Object.defineProperty(exports, "fromCodePoint", ({
  enumerable: true,
  get: function () {
    return decode_codepoint_js_2.fromCodePoint;
  }
}));
var CharCodes;
(function (CharCodes) {
  CharCodes[CharCodes["NUM"] = 35] = "NUM";
  CharCodes[CharCodes["SEMI"] = 59] = "SEMI";
  CharCodes[CharCodes["EQUALS"] = 61] = "EQUALS";
  CharCodes[CharCodes["ZERO"] = 48] = "ZERO";
  CharCodes[CharCodes["NINE"] = 57] = "NINE";
  CharCodes[CharCodes["LOWER_A"] = 97] = "LOWER_A";
  CharCodes[CharCodes["LOWER_F"] = 102] = "LOWER_F";
  CharCodes[CharCodes["LOWER_X"] = 120] = "LOWER_X";
  CharCodes[CharCodes["LOWER_Z"] = 122] = "LOWER_Z";
  CharCodes[CharCodes["UPPER_A"] = 65] = "UPPER_A";
  CharCodes[CharCodes["UPPER_F"] = 70] = "UPPER_F";
  CharCodes[CharCodes["UPPER_Z"] = 90] = "UPPER_Z";
})(CharCodes || (CharCodes = {}));
/** Bit that needs to be set to convert an upper case ASCII character to lower case */
var TO_LOWER_BIT = 32;
var BinTrieFlags;
(function (BinTrieFlags) {
  BinTrieFlags[BinTrieFlags["VALUE_LENGTH"] = 49152] = "VALUE_LENGTH";
  BinTrieFlags[BinTrieFlags["BRANCH_LENGTH"] = 16256] = "BRANCH_LENGTH";
  BinTrieFlags[BinTrieFlags["JUMP_TABLE"] = 127] = "JUMP_TABLE";
})(BinTrieFlags = exports.BinTrieFlags || (exports.BinTrieFlags = {}));
function isNumber(code) {
  return code >= CharCodes.ZERO && code <= CharCodes.NINE;
}
function isHexadecimalCharacter(code) {
  return code >= CharCodes.UPPER_A && code <= CharCodes.UPPER_F || code >= CharCodes.LOWER_A && code <= CharCodes.LOWER_F;
}
function isAsciiAlphaNumeric(code) {
  return code >= CharCodes.UPPER_A && code <= CharCodes.UPPER_Z || code >= CharCodes.LOWER_A && code <= CharCodes.LOWER_Z || isNumber(code);
}
/**
 * Checks if the given character is a valid end character for an entity in an attribute.
 *
 * Attribute values that aren't terminated properly aren't parsed, and shouldn't lead to a parser error.
 * See the example in https://html.spec.whatwg.org/multipage/parsing.html#named-character-reference-state
 */
function isEntityInAttributeInvalidEnd(code) {
  return code === CharCodes.EQUALS || isAsciiAlphaNumeric(code);
}
var EntityDecoderState;
(function (EntityDecoderState) {
  EntityDecoderState[EntityDecoderState["EntityStart"] = 0] = "EntityStart";
  EntityDecoderState[EntityDecoderState["NumericStart"] = 1] = "NumericStart";
  EntityDecoderState[EntityDecoderState["NumericDecimal"] = 2] = "NumericDecimal";
  EntityDecoderState[EntityDecoderState["NumericHex"] = 3] = "NumericHex";
  EntityDecoderState[EntityDecoderState["NamedEntity"] = 4] = "NamedEntity";
})(EntityDecoderState || (EntityDecoderState = {}));
var DecodingMode;
(function (DecodingMode) {
  /** Entities in text nodes that can end with any character. */
  DecodingMode[DecodingMode["Legacy"] = 0] = "Legacy";
  /** Only allow entities terminated with a semicolon. */
  DecodingMode[DecodingMode["Strict"] = 1] = "Strict";
  /** Entities in attributes have limitations on ending characters. */
  DecodingMode[DecodingMode["Attribute"] = 2] = "Attribute";
})(DecodingMode = exports.DecodingMode || (exports.DecodingMode = {}));
/**
 * Token decoder with support of writing partial entities.
 */
var EntityDecoder = /** @class */function () {
  function EntityDecoder( /** The tree used to decode entities. */
  decodeTree,
  /**
   * The function that is called when a codepoint is decoded.
   *
   * For multi-byte named entities, this will be called multiple times,
   * with the second codepoint, and the same `consumed` value.
   *
   * @param codepoint The decoded codepoint.
   * @param consumed The number of bytes consumed by the decoder.
   */
  emitCodePoint, /** An object that is used to produce errors. */
  errors) {
    this.decodeTree = decodeTree;
    this.emitCodePoint = emitCodePoint;
    this.errors = errors;
    /** The current state of the decoder. */
    this.state = EntityDecoderState.EntityStart;
    /** Characters that were consumed while parsing an entity. */
    this.consumed = 1;
    /**
     * The result of the entity.
     *
     * Either the result index of a numeric entity, or the codepoint of a
     * numeric entity.
     */
    this.result = 0;
    /** The current index in the decode tree. */
    this.treeIndex = 0;
    /** The number of characters that were consumed in excess. */
    this.excess = 1;
    /** The mode in which the decoder is operating. */
    this.decodeMode = DecodingMode.Strict;
  }
  /** Resets the instance to make it reusable. */
  EntityDecoder.prototype.startEntity = function (decodeMode) {
    this.decodeMode = decodeMode;
    this.state = EntityDecoderState.EntityStart;
    this.result = 0;
    this.treeIndex = 0;
    this.excess = 1;
    this.consumed = 1;
  };
  /**
   * Write an entity to the decoder. This can be called multiple times with partial entities.
   * If the entity is incomplete, the decoder will return -1.
   *
   * Mirrors the implementation of `getDecoder`, but with the ability to stop decoding if the
   * entity is incomplete, and resume when the next string is written.
   *
   * @param string The string containing the entity (or a continuation of the entity).
   * @param offset The offset at which the entity begins. Should be 0 if this is not the first call.
   * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
   */
  EntityDecoder.prototype.write = function (str, offset) {
    switch (this.state) {
      case EntityDecoderState.EntityStart:
        {
          if (str.charCodeAt(offset) === CharCodes.NUM) {
            this.state = EntityDecoderState.NumericStart;
            this.consumed += 1;
            return this.stateNumericStart(str, offset + 1);
          }
          this.state = EntityDecoderState.NamedEntity;
          return this.stateNamedEntity(str, offset);
        }
      case EntityDecoderState.NumericStart:
        {
          return this.stateNumericStart(str, offset);
        }
      case EntityDecoderState.NumericDecimal:
        {
          return this.stateNumericDecimal(str, offset);
        }
      case EntityDecoderState.NumericHex:
        {
          return this.stateNumericHex(str, offset);
        }
      case EntityDecoderState.NamedEntity:
        {
          return this.stateNamedEntity(str, offset);
        }
    }
  };
  /**
   * Switches between the numeric decimal and hexadecimal states.
   *
   * Equivalent to the `Numeric character reference state` in the HTML spec.
   *
   * @param str The string containing the entity (or a continuation of the entity).
   * @param offset The current offset.
   * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
   */
  EntityDecoder.prototype.stateNumericStart = function (str, offset) {
    if (offset >= str.length) {
      return -1;
    }
    if ((str.charCodeAt(offset) | TO_LOWER_BIT) === CharCodes.LOWER_X) {
      this.state = EntityDecoderState.NumericHex;
      this.consumed += 1;
      return this.stateNumericHex(str, offset + 1);
    }
    this.state = EntityDecoderState.NumericDecimal;
    return this.stateNumericDecimal(str, offset);
  };
  EntityDecoder.prototype.addToNumericResult = function (str, start, end, base) {
    if (start !== end) {
      var digitCount = end - start;
      this.result = this.result * Math.pow(base, digitCount) + parseInt(str.substr(start, digitCount), base);
      this.consumed += digitCount;
    }
  };
  /**
   * Parses a hexadecimal numeric entity.
   *
   * Equivalent to the `Hexademical character reference state` in the HTML spec.
   *
   * @param str The string containing the entity (or a continuation of the entity).
   * @param offset The current offset.
   * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
   */
  EntityDecoder.prototype.stateNumericHex = function (str, offset) {
    var startIdx = offset;
    while (offset < str.length) {
      var char = str.charCodeAt(offset);
      if (isNumber(char) || isHexadecimalCharacter(char)) {
        offset += 1;
      } else {
        this.addToNumericResult(str, startIdx, offset, 16);
        return this.emitNumericEntity(char, 3);
      }
    }
    this.addToNumericResult(str, startIdx, offset, 16);
    return -1;
  };
  /**
   * Parses a decimal numeric entity.
   *
   * Equivalent to the `Decimal character reference state` in the HTML spec.
   *
   * @param str The string containing the entity (or a continuation of the entity).
   * @param offset The current offset.
   * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
   */
  EntityDecoder.prototype.stateNumericDecimal = function (str, offset) {
    var startIdx = offset;
    while (offset < str.length) {
      var char = str.charCodeAt(offset);
      if (isNumber(char)) {
        offset += 1;
      } else {
        this.addToNumericResult(str, startIdx, offset, 10);
        return this.emitNumericEntity(char, 2);
      }
    }
    this.addToNumericResult(str, startIdx, offset, 10);
    return -1;
  };
  /**
   * Validate and emit a numeric entity.
   *
   * Implements the logic from the `Hexademical character reference start
   * state` and `Numeric character reference end state` in the HTML spec.
   *
   * @param lastCp The last code point of the entity. Used to see if the
   *               entity was terminated with a semicolon.
   * @param expectedLength The minimum number of characters that should be
   *                       consumed. Used to validate that at least one digit
   *                       was consumed.
   * @returns The number of characters that were consumed.
   */
  EntityDecoder.prototype.emitNumericEntity = function (lastCp, expectedLength) {
    var _a;
    // Ensure we consumed at least one digit.
    if (this.consumed <= expectedLength) {
      (_a = this.errors) === null || _a === void 0 ? void 0 : _a.absenceOfDigitsInNumericCharacterReference(this.consumed);
      return 0;
    }
    // Figure out if this is a legit end of the entity
    if (lastCp === CharCodes.SEMI) {
      this.consumed += 1;
    } else if (this.decodeMode === DecodingMode.Strict) {
      return 0;
    }
    this.emitCodePoint((0, decode_codepoint_js_1.replaceCodePoint)(this.result), this.consumed);
    if (this.errors) {
      if (lastCp !== CharCodes.SEMI) {
        this.errors.missingSemicolonAfterCharacterReference();
      }
      this.errors.validateNumericCharacterReference(this.result);
    }
    return this.consumed;
  };
  /**
   * Parses a named entity.
   *
   * Equivalent to the `Named character reference state` in the HTML spec.
   *
   * @param str The string containing the entity (or a continuation of the entity).
   * @param offset The current offset.
   * @returns The number of characters that were consumed, or -1 if the entity is incomplete.
   */
  EntityDecoder.prototype.stateNamedEntity = function (str, offset) {
    var decodeTree = this.decodeTree;
    var current = decodeTree[this.treeIndex];
    // The mask is the number of bytes of the value, including the current byte.
    var valueLength = (current & BinTrieFlags.VALUE_LENGTH) >> 14;
    for (; offset < str.length; offset++, this.excess++) {
      var char = str.charCodeAt(offset);
      this.treeIndex = determineBranch(decodeTree, current, this.treeIndex + Math.max(1, valueLength), char);
      if (this.treeIndex < 0) {
        return this.result === 0 ||
        // If we are parsing an attribute
        this.decodeMode === DecodingMode.Attribute && (
        // We shouldn't have consumed any characters after the entity,
        valueLength === 0 ||
        // And there should be no invalid characters.
        isEntityInAttributeInvalidEnd(char)) ? 0 : this.emitNotTerminatedNamedEntity();
      }
      current = decodeTree[this.treeIndex];
      valueLength = (current & BinTrieFlags.VALUE_LENGTH) >> 14;
      // If the branch is a value, store it and continue
      if (valueLength !== 0) {
        // If the entity is terminated by a semicolon, we are done.
        if (char === CharCodes.SEMI) {
          return this.emitNamedEntityData(this.treeIndex, valueLength, this.consumed + this.excess);
        }
        // If we encounter a non-terminated (legacy) entity while parsing strictly, then ignore it.
        if (this.decodeMode !== DecodingMode.Strict) {
          this.result = this.treeIndex;
          this.consumed += this.excess;
          this.excess = 0;
        }
      }
    }
    return -1;
  };
  /**
   * Emit a named entity that was not terminated with a semicolon.
   *
   * @returns The number of characters consumed.
   */
  EntityDecoder.prototype.emitNotTerminatedNamedEntity = function () {
    var _a;
    var _b = this,
      result = _b.result,
      decodeTree = _b.decodeTree;
    var valueLength = (decodeTree[result] & BinTrieFlags.VALUE_LENGTH) >> 14;
    this.emitNamedEntityData(result, valueLength, this.consumed);
    (_a = this.errors) === null || _a === void 0 ? void 0 : _a.missingSemicolonAfterCharacterReference();
    return this.consumed;
  };
  /**
   * Emit a named entity.
   *
   * @param result The index of the entity in the decode tree.
   * @param valueLength The number of bytes in the entity.
   * @param consumed The number of characters consumed.
   *
   * @returns The number of characters consumed.
   */
  EntityDecoder.prototype.emitNamedEntityData = function (result, valueLength, consumed) {
    var decodeTree = this.decodeTree;
    this.emitCodePoint(valueLength === 1 ? decodeTree[result] & ~BinTrieFlags.VALUE_LENGTH : decodeTree[result + 1], consumed);
    if (valueLength === 3) {
      // For multi-byte values, we need to emit the second byte.
      this.emitCodePoint(decodeTree[result + 2], consumed);
    }
    return consumed;
  };
  /**
   * Signal to the parser that the end of the input was reached.
   *
   * Remaining data will be emitted and relevant errors will be produced.
   *
   * @returns The number of characters consumed.
   */
  EntityDecoder.prototype.end = function () {
    var _a;
    switch (this.state) {
      case EntityDecoderState.NamedEntity:
        {
          // Emit a named entity if we have one.
          return this.result !== 0 && (this.decodeMode !== DecodingMode.Attribute || this.result === this.treeIndex) ? this.emitNotTerminatedNamedEntity() : 0;
        }
      // Otherwise, emit a numeric entity if we have one.
      case EntityDecoderState.NumericDecimal:
        {
          return this.emitNumericEntity(0, 2);
        }
      case EntityDecoderState.NumericHex:
        {
          return this.emitNumericEntity(0, 3);
        }
      case EntityDecoderState.NumericStart:
        {
          (_a = this.errors) === null || _a === void 0 ? void 0 : _a.absenceOfDigitsInNumericCharacterReference(this.consumed);
          return 0;
        }
      case EntityDecoderState.EntityStart:
        {
          // Return 0 if we have no entity.
          return 0;
        }
    }
  };
  return EntityDecoder;
}();
exports.EntityDecoder = EntityDecoder;
/**
 * Creates a function that decodes entities in a string.
 *
 * @param decodeTree The decode tree.
 * @returns A function that decodes entities in a string.
 */
function getDecoder(decodeTree) {
  var ret = "";
  var decoder = new EntityDecoder(decodeTree, function (str) {
    return ret += (0, decode_codepoint_js_1.fromCodePoint)(str);
  });
  return function decodeWithTrie(str, decodeMode) {
    var lastIndex = 0;
    var offset = 0;
    while ((offset = str.indexOf("&", offset)) >= 0) {
      ret += str.slice(lastIndex, offset);
      decoder.startEntity(decodeMode);
      var len = decoder.write(str,
      // Skip the "&"
      offset + 1);
      if (len < 0) {
        lastIndex = offset + decoder.end();
        break;
      }
      lastIndex = offset + len;
      // If `len` is 0, skip the current `&` and continue.
      offset = len === 0 ? lastIndex + 1 : lastIndex;
    }
    var result = ret + str.slice(lastIndex);
    // Make sure we don't keep a reference to the final string.
    ret = "";
    return result;
  };
}
/**
 * Determines the branch of the current node that is taken given the current
 * character. This function is used to traverse the trie.
 *
 * @param decodeTree The trie.
 * @param current The current node.
 * @param nodeIdx The index right after the current node and its value.
 * @param char The current character.
 * @returns The index of the next node, or -1 if no branch is taken.
 */
function determineBranch(decodeTree, current, nodeIdx, char) {
  var branchCount = (current & BinTrieFlags.BRANCH_LENGTH) >> 7;
  var jumpOffset = current & BinTrieFlags.JUMP_TABLE;
  // Case 1: Single branch encoded in jump offset
  if (branchCount === 0) {
    return jumpOffset !== 0 && char === jumpOffset ? nodeIdx : -1;
  }
  // Case 2: Multiple branches encoded in jump table
  if (jumpOffset) {
    var value = char - jumpOffset;
    return value < 0 || value >= branchCount ? -1 : decodeTree[nodeIdx + value] - 1;
  }
  // Case 3: Multiple branches encoded in dictionary
  // Binary search for the character.
  var lo = nodeIdx;
  var hi = lo + branchCount - 1;
  while (lo <= hi) {
    var mid = lo + hi >>> 1;
    var midVal = decodeTree[mid];
    if (midVal < char) {
      lo = mid + 1;
    } else if (midVal > char) {
      hi = mid - 1;
    } else {
      return decodeTree[mid + branchCount];
    }
  }
  return -1;
}
exports.determineBranch = determineBranch;
var htmlDecoder = getDecoder(decode_data_html_js_1.default);
var xmlDecoder = getDecoder(decode_data_xml_js_1.default);
/**
 * Decodes an HTML string.
 *
 * @param str The string to decode.
 * @param mode The decoding mode.
 * @returns The decoded string.
 */
function decodeHTML(str, mode) {
  if (mode === void 0) {
    mode = DecodingMode.Legacy;
  }
  return htmlDecoder(str, mode);
}
exports.decodeHTML = decodeHTML;
/**
 * Decodes an HTML string in an attribute.
 *
 * @param str The string to decode.
 * @returns The decoded string.
 */
function decodeHTMLAttribute(str) {
  return htmlDecoder(str, DecodingMode.Attribute);
}
exports.decodeHTMLAttribute = decodeHTMLAttribute;
/**
 * Decodes an HTML string, requiring all entities to be terminated by a semicolon.
 *
 * @param str The string to decode.
 * @returns The decoded string.
 */
function decodeHTMLStrict(str) {
  return htmlDecoder(str, DecodingMode.Strict);
}
exports.decodeHTMLStrict = decodeHTMLStrict;
/**
 * Decodes an XML string, requiring all entities to be terminated by a semicolon.
 *
 * @param str The string to decode.
 * @returns The decoded string.
 */
function decodeXML(str) {
  return xmlDecoder(str, DecodingMode.Strict);
}
exports.decodeXML = decodeXML;

/***/ }),

/***/ "../../../node_modules/entities/lib/decode_codepoint.js":
/*!**************************************************************!*\
  !*** ../../../node_modules/entities/lib/decode_codepoint.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports) {



// Adapted from https://github.com/mathiasbynens/he/blob/36afe179392226cf1b6ccdb16ebbb7a5a844d93a/src/he.js#L106-L134
var _a;
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.replaceCodePoint = exports.fromCodePoint = void 0;
var decodeMap = new Map([[0, 65533],
// C1 Unicode control character reference replacements
[128, 8364], [130, 8218], [131, 402], [132, 8222], [133, 8230], [134, 8224], [135, 8225], [136, 710], [137, 8240], [138, 352], [139, 8249], [140, 338], [142, 381], [145, 8216], [146, 8217], [147, 8220], [148, 8221], [149, 8226], [150, 8211], [151, 8212], [152, 732], [153, 8482], [154, 353], [155, 8250], [156, 339], [158, 382], [159, 376]]);
/**
 * Polyfill for `String.fromCodePoint`. It is used to create a string from a Unicode code point.
 */
exports.fromCodePoint =
// eslint-disable-next-line @typescript-eslint/no-unnecessary-condition, node/no-unsupported-features/es-builtins
(_a = String.fromCodePoint) !== null && _a !== void 0 ? _a : function (codePoint) {
  var output = "";
  if (codePoint > 0xffff) {
    codePoint -= 0x10000;
    output += String.fromCharCode(codePoint >>> 10 & 0x3ff | 0xd800);
    codePoint = 0xdc00 | codePoint & 0x3ff;
  }
  output += String.fromCharCode(codePoint);
  return output;
};
/**
 * Replace the given code point with a replacement character if it is a
 * surrogate or is outside the valid range. Otherwise return the code
 * point unchanged.
 */
function replaceCodePoint(codePoint) {
  var _a;
  if (codePoint >= 0xd800 && codePoint <= 0xdfff || codePoint > 0x10ffff) {
    return 0xfffd;
  }
  return (_a = decodeMap.get(codePoint)) !== null && _a !== void 0 ? _a : codePoint;
}
exports.replaceCodePoint = replaceCodePoint;
/**
 * Replace the code point if relevant, then convert it to a string.
 *
 * @deprecated Use `fromCodePoint(replaceCodePoint(codePoint))` instead.
 * @param codePoint The code point to decode.
 * @returns The decoded code point.
 */
function decodeCodePoint(codePoint) {
  return (0, exports.fromCodePoint)(replaceCodePoint(codePoint));
}
exports["default"] = decodeCodePoint;

/***/ }),

/***/ "../../../node_modules/entities/lib/encode.js":
/*!****************************************************!*\
  !*** ../../../node_modules/entities/lib/encode.js ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



var __importDefault = void 0 && (void 0).__importDefault || function (mod) {
  return mod && mod.__esModule ? mod : {
    "default": mod
  };
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.encodeNonAsciiHTML = exports.encodeHTML = void 0;
var encode_html_js_1 = __importDefault(__webpack_require__(/*! ./generated/encode-html.js */ "../../../node_modules/entities/lib/generated/encode-html.js"));
var escape_js_1 = __webpack_require__(/*! ./escape.js */ "../../../node_modules/entities/lib/escape.js");
var htmlReplacer = /[\t\n!-,./:-@[-`\f{-}$\x80-\uFFFF]/g;
/**
 * Encodes all characters in the input using HTML entities. This includes
 * characters that are valid ASCII characters in HTML documents, such as `#`.
 *
 * To get a more compact output, consider using the `encodeNonAsciiHTML`
 * function, which will only encode characters that are not valid in HTML
 * documents, as well as non-ASCII characters.
 *
 * If a character has no equivalent entity, a numeric hexadecimal reference
 * (eg. `&#xfc;`) will be used.
 */
function encodeHTML(data) {
  return encodeHTMLTrieRe(htmlReplacer, data);
}
exports.encodeHTML = encodeHTML;
/**
 * Encodes all non-ASCII characters, as well as characters not valid in HTML
 * documents using HTML entities. This function will not encode characters that
 * are valid in HTML documents, such as `#`.
 *
 * If a character has no equivalent entity, a numeric hexadecimal reference
 * (eg. `&#xfc;`) will be used.
 */
function encodeNonAsciiHTML(data) {
  return encodeHTMLTrieRe(escape_js_1.xmlReplacer, data);
}
exports.encodeNonAsciiHTML = encodeNonAsciiHTML;
function encodeHTMLTrieRe(regExp, str) {
  var ret = "";
  var lastIdx = 0;
  var match;
  while ((match = regExp.exec(str)) !== null) {
    var i = match.index;
    ret += str.substring(lastIdx, i);
    var char = str.charCodeAt(i);
    var next = encode_html_js_1.default.get(char);
    if (typeof next === "object") {
      // We are in a branch. Try to match the next char.
      if (i + 1 < str.length) {
        var nextChar = str.charCodeAt(i + 1);
        var value = typeof next.n === "number" ? next.n === nextChar ? next.o : undefined : next.n.get(nextChar);
        if (value !== undefined) {
          ret += value;
          lastIdx = regExp.lastIndex += 1;
          continue;
        }
      }
      next = next.v;
    }
    // We might have a tree node without a value; skip and use a numeric entity.
    if (next !== undefined) {
      ret += next;
      lastIdx = i + 1;
    } else {
      var cp = (0, escape_js_1.getCodePoint)(str, i);
      ret += "&#x".concat(cp.toString(16), ";");
      // Increase by 1 if we have a surrogate pair
      lastIdx = regExp.lastIndex += Number(cp !== char);
    }
  }
  return ret + str.substr(lastIdx);
}

/***/ }),

/***/ "../../../node_modules/entities/lib/escape.js":
/*!****************************************************!*\
  !*** ../../../node_modules/entities/lib/escape.js ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.escapeText = exports.escapeAttribute = exports.escapeUTF8 = exports.escape = exports.encodeXML = exports.getCodePoint = exports.xmlReplacer = void 0;
exports.xmlReplacer = /["&'<>$\x80-\uFFFF]/g;
var xmlCodeMap = new Map([[34, "&quot;"], [38, "&amp;"], [39, "&apos;"], [60, "&lt;"], [62, "&gt;"]]);
// For compatibility with node < 4, we wrap `codePointAt`
exports.getCodePoint =
// eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
String.prototype.codePointAt != null ? function (str, index) {
  return str.codePointAt(index);
} :
// http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
function (c, index) {
  return (c.charCodeAt(index) & 0xfc00) === 0xd800 ? (c.charCodeAt(index) - 0xd800) * 0x400 + c.charCodeAt(index + 1) - 0xdc00 + 0x10000 : c.charCodeAt(index);
};
/**
 * Encodes all non-ASCII characters, as well as characters not valid in XML
 * documents using XML entities.
 *
 * If a character has no equivalent entity, a
 * numeric hexadecimal reference (eg. `&#xfc;`) will be used.
 */
function encodeXML(str) {
  var ret = "";
  var lastIdx = 0;
  var match;
  while ((match = exports.xmlReplacer.exec(str)) !== null) {
    var i = match.index;
    var char = str.charCodeAt(i);
    var next = xmlCodeMap.get(char);
    if (next !== undefined) {
      ret += str.substring(lastIdx, i) + next;
      lastIdx = i + 1;
    } else {
      ret += "".concat(str.substring(lastIdx, i), "&#x").concat((0, exports.getCodePoint)(str, i).toString(16), ";");
      // Increase by 1 if we have a surrogate pair
      lastIdx = exports.xmlReplacer.lastIndex += Number((char & 0xfc00) === 0xd800);
    }
  }
  return ret + str.substr(lastIdx);
}
exports.encodeXML = encodeXML;
/**
 * Encodes all non-ASCII characters, as well as characters not valid in XML
 * documents using numeric hexadecimal reference (eg. `&#xfc;`).
 *
 * Have a look at `escapeUTF8` if you want a more concise output at the expense
 * of reduced transportability.
 *
 * @param data String to escape.
 */
exports.escape = encodeXML;
/**
 * Creates a function that escapes all characters matched by the given regular
 * expression using the given map of characters to escape to their entities.
 *
 * @param regex Regular expression to match characters to escape.
 * @param map Map of characters to escape to their entities.
 *
 * @returns Function that escapes all characters matched by the given regular
 * expression using the given map of characters to escape to their entities.
 */
function getEscaper(regex, map) {
  return function escape(data) {
    var match;
    var lastIdx = 0;
    var result = "";
    while (match = regex.exec(data)) {
      if (lastIdx !== match.index) {
        result += data.substring(lastIdx, match.index);
      }
      // We know that this character will be in the map.
      result += map.get(match[0].charCodeAt(0));
      // Every match will be of length 1
      lastIdx = match.index + 1;
    }
    return result + data.substring(lastIdx);
  };
}
/**
 * Encodes all characters not valid in XML documents using XML entities.
 *
 * Note that the output will be character-set dependent.
 *
 * @param data String to escape.
 */
exports.escapeUTF8 = getEscaper(/[&<>'"]/g, xmlCodeMap);
/**
 * Encodes all characters that have to be escaped in HTML attributes,
 * following {@link https://html.spec.whatwg.org/multipage/parsing.html#escapingString}.
 *
 * @param data String to escape.
 */
exports.escapeAttribute = getEscaper(/["&\u00A0]/g, new Map([[34, "&quot;"], [38, "&amp;"], [160, "&nbsp;"]]));
/**
 * Encodes all characters that have to be escaped in HTML text,
 * following {@link https://html.spec.whatwg.org/multipage/parsing.html#escapingString}.
 *
 * @param data String to escape.
 */
exports.escapeText = getEscaper(/[&<>\u00A0]/g, new Map([[38, "&amp;"], [60, "&lt;"], [62, "&gt;"], [160, "&nbsp;"]]));

/***/ }),

/***/ "../../../node_modules/entities/lib/generated/decode-data-html.js":
/*!************************************************************************!*\
  !*** ../../../node_modules/entities/lib/generated/decode-data-html.js ***!
  \************************************************************************/
/***/ (function(__unused_webpack_module, exports) {



// Generated using scripts/write-decode-map.ts
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = new Uint16Array(
// prettier-ignore
"\u1d41<\xd5\u0131\u028a\u049d\u057b\u05d0\u0675\u06de\u07a2\u07d6\u080f\u0a4a\u0a91\u0da1\u0e6d\u0f09\u0f26\u10ca\u1228\u12e1\u1415\u149d\u14c3\u14df\u1525\0\0\0\0\0\0\u156b\u16cd\u198d\u1c12\u1ddd\u1f7e\u2060\u21b0\u228d\u23c0\u23fb\u2442\u2824\u2912\u2d08\u2e48\u2fce\u3016\u32ba\u3639\u37ac\u38fe\u3a28\u3a71\u3ae0\u3b2e\u0800EMabcfglmnoprstu\\bfms\x7f\x84\x8b\x90\x95\x98\xa6\xb3\xb9\xc8\xcflig\u803b\xc6\u40c6P\u803b&\u4026cute\u803b\xc1\u40c1reve;\u4102\u0100iyx}rc\u803b\xc2\u40c2;\u4410r;\uc000\ud835\udd04rave\u803b\xc0\u40c0pha;\u4391acr;\u4100d;\u6a53\u0100gp\x9d\xa1on;\u4104f;\uc000\ud835\udd38plyFunction;\u6061ing\u803b\xc5\u40c5\u0100cs\xbe\xc3r;\uc000\ud835\udc9cign;\u6254ilde\u803b\xc3\u40c3ml\u803b\xc4\u40c4\u0400aceforsu\xe5\xfb\xfe\u0117\u011c\u0122\u0127\u012a\u0100cr\xea\xf2kslash;\u6216\u0176\xf6\xf8;\u6ae7ed;\u6306y;\u4411\u0180crt\u0105\u010b\u0114ause;\u6235noullis;\u612ca;\u4392r;\uc000\ud835\udd05pf;\uc000\ud835\udd39eve;\u42d8c\xf2\u0113mpeq;\u624e\u0700HOacdefhilorsu\u014d\u0151\u0156\u0180\u019e\u01a2\u01b5\u01b7\u01ba\u01dc\u0215\u0273\u0278\u027ecy;\u4427PY\u803b\xa9\u40a9\u0180cpy\u015d\u0162\u017aute;\u4106\u0100;i\u0167\u0168\u62d2talDifferentialD;\u6145leys;\u612d\u0200aeio\u0189\u018e\u0194\u0198ron;\u410cdil\u803b\xc7\u40c7rc;\u4108nint;\u6230ot;\u410a\u0100dn\u01a7\u01adilla;\u40b8terDot;\u40b7\xf2\u017fi;\u43a7rcle\u0200DMPT\u01c7\u01cb\u01d1\u01d6ot;\u6299inus;\u6296lus;\u6295imes;\u6297o\u0100cs\u01e2\u01f8kwiseContourIntegral;\u6232eCurly\u0100DQ\u0203\u020foubleQuote;\u601duote;\u6019\u0200lnpu\u021e\u0228\u0247\u0255on\u0100;e\u0225\u0226\u6237;\u6a74\u0180git\u022f\u0236\u023aruent;\u6261nt;\u622fourIntegral;\u622e\u0100fr\u024c\u024e;\u6102oduct;\u6210nterClockwiseContourIntegral;\u6233oss;\u6a2fcr;\uc000\ud835\udc9ep\u0100;C\u0284\u0285\u62d3ap;\u624d\u0580DJSZacefios\u02a0\u02ac\u02b0\u02b4\u02b8\u02cb\u02d7\u02e1\u02e6\u0333\u048d\u0100;o\u0179\u02a5trahd;\u6911cy;\u4402cy;\u4405cy;\u440f\u0180grs\u02bf\u02c4\u02c7ger;\u6021r;\u61a1hv;\u6ae4\u0100ay\u02d0\u02d5ron;\u410e;\u4414l\u0100;t\u02dd\u02de\u6207a;\u4394r;\uc000\ud835\udd07\u0100af\u02eb\u0327\u0100cm\u02f0\u0322ritical\u0200ADGT\u0300\u0306\u0316\u031ccute;\u40b4o\u0174\u030b\u030d;\u42d9bleAcute;\u42ddrave;\u4060ilde;\u42dcond;\u62c4ferentialD;\u6146\u0470\u033d\0\0\0\u0342\u0354\0\u0405f;\uc000\ud835\udd3b\u0180;DE\u0348\u0349\u034d\u40a8ot;\u60dcqual;\u6250ble\u0300CDLRUV\u0363\u0372\u0382\u03cf\u03e2\u03f8ontourIntegra\xec\u0239o\u0274\u0379\0\0\u037b\xbb\u0349nArrow;\u61d3\u0100eo\u0387\u03a4ft\u0180ART\u0390\u0396\u03a1rrow;\u61d0ightArrow;\u61d4e\xe5\u02cang\u0100LR\u03ab\u03c4eft\u0100AR\u03b3\u03b9rrow;\u67f8ightArrow;\u67faightArrow;\u67f9ight\u0100AT\u03d8\u03derrow;\u61d2ee;\u62a8p\u0241\u03e9\0\0\u03efrrow;\u61d1ownArrow;\u61d5erticalBar;\u6225n\u0300ABLRTa\u0412\u042a\u0430\u045e\u047f\u037crrow\u0180;BU\u041d\u041e\u0422\u6193ar;\u6913pArrow;\u61f5reve;\u4311eft\u02d2\u043a\0\u0446\0\u0450ightVector;\u6950eeVector;\u695eector\u0100;B\u0459\u045a\u61bdar;\u6956ight\u01d4\u0467\0\u0471eeVector;\u695fector\u0100;B\u047a\u047b\u61c1ar;\u6957ee\u0100;A\u0486\u0487\u62a4rrow;\u61a7\u0100ct\u0492\u0497r;\uc000\ud835\udc9frok;\u4110\u0800NTacdfglmopqstux\u04bd\u04c0\u04c4\u04cb\u04de\u04e2\u04e7\u04ee\u04f5\u0521\u052f\u0536\u0552\u055d\u0560\u0565G;\u414aH\u803b\xd0\u40d0cute\u803b\xc9\u40c9\u0180aiy\u04d2\u04d7\u04dcron;\u411arc\u803b\xca\u40ca;\u442dot;\u4116r;\uc000\ud835\udd08rave\u803b\xc8\u40c8ement;\u6208\u0100ap\u04fa\u04fecr;\u4112ty\u0253\u0506\0\0\u0512mallSquare;\u65fberySmallSquare;\u65ab\u0100gp\u0526\u052aon;\u4118f;\uc000\ud835\udd3csilon;\u4395u\u0100ai\u053c\u0549l\u0100;T\u0542\u0543\u6a75ilde;\u6242librium;\u61cc\u0100ci\u0557\u055ar;\u6130m;\u6a73a;\u4397ml\u803b\xcb\u40cb\u0100ip\u056a\u056fsts;\u6203onentialE;\u6147\u0280cfios\u0585\u0588\u058d\u05b2\u05ccy;\u4424r;\uc000\ud835\udd09lled\u0253\u0597\0\0\u05a3mallSquare;\u65fcerySmallSquare;\u65aa\u0370\u05ba\0\u05bf\0\0\u05c4f;\uc000\ud835\udd3dAll;\u6200riertrf;\u6131c\xf2\u05cb\u0600JTabcdfgorst\u05e8\u05ec\u05ef\u05fa\u0600\u0612\u0616\u061b\u061d\u0623\u066c\u0672cy;\u4403\u803b>\u403emma\u0100;d\u05f7\u05f8\u4393;\u43dcreve;\u411e\u0180eiy\u0607\u060c\u0610dil;\u4122rc;\u411c;\u4413ot;\u4120r;\uc000\ud835\udd0a;\u62d9pf;\uc000\ud835\udd3eeater\u0300EFGLST\u0635\u0644\u064e\u0656\u065b\u0666qual\u0100;L\u063e\u063f\u6265ess;\u62dbullEqual;\u6267reater;\u6aa2ess;\u6277lantEqual;\u6a7eilde;\u6273cr;\uc000\ud835\udca2;\u626b\u0400Aacfiosu\u0685\u068b\u0696\u069b\u069e\u06aa\u06be\u06caRDcy;\u442a\u0100ct\u0690\u0694ek;\u42c7;\u405eirc;\u4124r;\u610clbertSpace;\u610b\u01f0\u06af\0\u06b2f;\u610dizontalLine;\u6500\u0100ct\u06c3\u06c5\xf2\u06a9rok;\u4126mp\u0144\u06d0\u06d8ownHum\xf0\u012fqual;\u624f\u0700EJOacdfgmnostu\u06fa\u06fe\u0703\u0707\u070e\u071a\u071e\u0721\u0728\u0744\u0778\u078b\u078f\u0795cy;\u4415lig;\u4132cy;\u4401cute\u803b\xcd\u40cd\u0100iy\u0713\u0718rc\u803b\xce\u40ce;\u4418ot;\u4130r;\u6111rave\u803b\xcc\u40cc\u0180;ap\u0720\u072f\u073f\u0100cg\u0734\u0737r;\u412ainaryI;\u6148lie\xf3\u03dd\u01f4\u0749\0\u0762\u0100;e\u074d\u074e\u622c\u0100gr\u0753\u0758ral;\u622bsection;\u62c2isible\u0100CT\u076c\u0772omma;\u6063imes;\u6062\u0180gpt\u077f\u0783\u0788on;\u412ef;\uc000\ud835\udd40a;\u4399cr;\u6110ilde;\u4128\u01eb\u079a\0\u079ecy;\u4406l\u803b\xcf\u40cf\u0280cfosu\u07ac\u07b7\u07bc\u07c2\u07d0\u0100iy\u07b1\u07b5rc;\u4134;\u4419r;\uc000\ud835\udd0dpf;\uc000\ud835\udd41\u01e3\u07c7\0\u07ccr;\uc000\ud835\udca5rcy;\u4408kcy;\u4404\u0380HJacfos\u07e4\u07e8\u07ec\u07f1\u07fd\u0802\u0808cy;\u4425cy;\u440cppa;\u439a\u0100ey\u07f6\u07fbdil;\u4136;\u441ar;\uc000\ud835\udd0epf;\uc000\ud835\udd42cr;\uc000\ud835\udca6\u0580JTaceflmost\u0825\u0829\u082c\u0850\u0863\u09b3\u09b8\u09c7\u09cd\u0a37\u0a47cy;\u4409\u803b<\u403c\u0280cmnpr\u0837\u083c\u0841\u0844\u084dute;\u4139bda;\u439bg;\u67ealacetrf;\u6112r;\u619e\u0180aey\u0857\u085c\u0861ron;\u413ddil;\u413b;\u441b\u0100fs\u0868\u0970t\u0500ACDFRTUVar\u087e\u08a9\u08b1\u08e0\u08e6\u08fc\u092f\u095b\u0390\u096a\u0100nr\u0883\u088fgleBracket;\u67e8row\u0180;BR\u0899\u089a\u089e\u6190ar;\u61e4ightArrow;\u61c6eiling;\u6308o\u01f5\u08b7\0\u08c3bleBracket;\u67e6n\u01d4\u08c8\0\u08d2eeVector;\u6961ector\u0100;B\u08db\u08dc\u61c3ar;\u6959loor;\u630aight\u0100AV\u08ef\u08f5rrow;\u6194ector;\u694e\u0100er\u0901\u0917e\u0180;AV\u0909\u090a\u0910\u62a3rrow;\u61a4ector;\u695aiangle\u0180;BE\u0924\u0925\u0929\u62b2ar;\u69cfqual;\u62b4p\u0180DTV\u0937\u0942\u094cownVector;\u6951eeVector;\u6960ector\u0100;B\u0956\u0957\u61bfar;\u6958ector\u0100;B\u0965\u0966\u61bcar;\u6952ight\xe1\u039cs\u0300EFGLST\u097e\u098b\u0995\u099d\u09a2\u09adqualGreater;\u62daullEqual;\u6266reater;\u6276ess;\u6aa1lantEqual;\u6a7dilde;\u6272r;\uc000\ud835\udd0f\u0100;e\u09bd\u09be\u62d8ftarrow;\u61daidot;\u413f\u0180npw\u09d4\u0a16\u0a1bg\u0200LRlr\u09de\u09f7\u0a02\u0a10eft\u0100AR\u09e6\u09ecrrow;\u67f5ightArrow;\u67f7ightArrow;\u67f6eft\u0100ar\u03b3\u0a0aight\xe1\u03bfight\xe1\u03caf;\uc000\ud835\udd43er\u0100LR\u0a22\u0a2ceftArrow;\u6199ightArrow;\u6198\u0180cht\u0a3e\u0a40\u0a42\xf2\u084c;\u61b0rok;\u4141;\u626a\u0400acefiosu\u0a5a\u0a5d\u0a60\u0a77\u0a7c\u0a85\u0a8b\u0a8ep;\u6905y;\u441c\u0100dl\u0a65\u0a6fiumSpace;\u605flintrf;\u6133r;\uc000\ud835\udd10nusPlus;\u6213pf;\uc000\ud835\udd44c\xf2\u0a76;\u439c\u0480Jacefostu\u0aa3\u0aa7\u0aad\u0ac0\u0b14\u0b19\u0d91\u0d97\u0d9ecy;\u440acute;\u4143\u0180aey\u0ab4\u0ab9\u0aberon;\u4147dil;\u4145;\u441d\u0180gsw\u0ac7\u0af0\u0b0eative\u0180MTV\u0ad3\u0adf\u0ae8ediumSpace;\u600bhi\u0100cn\u0ae6\u0ad8\xeb\u0ad9eryThi\xee\u0ad9ted\u0100GL\u0af8\u0b06reaterGreate\xf2\u0673essLes\xf3\u0a48Line;\u400ar;\uc000\ud835\udd11\u0200Bnpt\u0b22\u0b28\u0b37\u0b3areak;\u6060BreakingSpace;\u40a0f;\u6115\u0680;CDEGHLNPRSTV\u0b55\u0b56\u0b6a\u0b7c\u0ba1\u0beb\u0c04\u0c5e\u0c84\u0ca6\u0cd8\u0d61\u0d85\u6aec\u0100ou\u0b5b\u0b64ngruent;\u6262pCap;\u626doubleVerticalBar;\u6226\u0180lqx\u0b83\u0b8a\u0b9bement;\u6209ual\u0100;T\u0b92\u0b93\u6260ilde;\uc000\u2242\u0338ists;\u6204reater\u0380;EFGLST\u0bb6\u0bb7\u0bbd\u0bc9\u0bd3\u0bd8\u0be5\u626fqual;\u6271ullEqual;\uc000\u2267\u0338reater;\uc000\u226b\u0338ess;\u6279lantEqual;\uc000\u2a7e\u0338ilde;\u6275ump\u0144\u0bf2\u0bfdownHump;\uc000\u224e\u0338qual;\uc000\u224f\u0338e\u0100fs\u0c0a\u0c27tTriangle\u0180;BE\u0c1a\u0c1b\u0c21\u62eaar;\uc000\u29cf\u0338qual;\u62ecs\u0300;EGLST\u0c35\u0c36\u0c3c\u0c44\u0c4b\u0c58\u626equal;\u6270reater;\u6278ess;\uc000\u226a\u0338lantEqual;\uc000\u2a7d\u0338ilde;\u6274ested\u0100GL\u0c68\u0c79reaterGreater;\uc000\u2aa2\u0338essLess;\uc000\u2aa1\u0338recedes\u0180;ES\u0c92\u0c93\u0c9b\u6280qual;\uc000\u2aaf\u0338lantEqual;\u62e0\u0100ei\u0cab\u0cb9verseElement;\u620cghtTriangle\u0180;BE\u0ccb\u0ccc\u0cd2\u62ebar;\uc000\u29d0\u0338qual;\u62ed\u0100qu\u0cdd\u0d0cuareSu\u0100bp\u0ce8\u0cf9set\u0100;E\u0cf0\u0cf3\uc000\u228f\u0338qual;\u62e2erset\u0100;E\u0d03\u0d06\uc000\u2290\u0338qual;\u62e3\u0180bcp\u0d13\u0d24\u0d4eset\u0100;E\u0d1b\u0d1e\uc000\u2282\u20d2qual;\u6288ceeds\u0200;EST\u0d32\u0d33\u0d3b\u0d46\u6281qual;\uc000\u2ab0\u0338lantEqual;\u62e1ilde;\uc000\u227f\u0338erset\u0100;E\u0d58\u0d5b\uc000\u2283\u20d2qual;\u6289ilde\u0200;EFT\u0d6e\u0d6f\u0d75\u0d7f\u6241qual;\u6244ullEqual;\u6247ilde;\u6249erticalBar;\u6224cr;\uc000\ud835\udca9ilde\u803b\xd1\u40d1;\u439d\u0700Eacdfgmoprstuv\u0dbd\u0dc2\u0dc9\u0dd5\u0ddb\u0de0\u0de7\u0dfc\u0e02\u0e20\u0e22\u0e32\u0e3f\u0e44lig;\u4152cute\u803b\xd3\u40d3\u0100iy\u0dce\u0dd3rc\u803b\xd4\u40d4;\u441eblac;\u4150r;\uc000\ud835\udd12rave\u803b\xd2\u40d2\u0180aei\u0dee\u0df2\u0df6cr;\u414cga;\u43a9cron;\u439fpf;\uc000\ud835\udd46enCurly\u0100DQ\u0e0e\u0e1aoubleQuote;\u601cuote;\u6018;\u6a54\u0100cl\u0e27\u0e2cr;\uc000\ud835\udcaaash\u803b\xd8\u40d8i\u016c\u0e37\u0e3cde\u803b\xd5\u40d5es;\u6a37ml\u803b\xd6\u40d6er\u0100BP\u0e4b\u0e60\u0100ar\u0e50\u0e53r;\u603eac\u0100ek\u0e5a\u0e5c;\u63deet;\u63b4arenthesis;\u63dc\u0480acfhilors\u0e7f\u0e87\u0e8a\u0e8f\u0e92\u0e94\u0e9d\u0eb0\u0efcrtialD;\u6202y;\u441fr;\uc000\ud835\udd13i;\u43a6;\u43a0usMinus;\u40b1\u0100ip\u0ea2\u0eadncareplan\xe5\u069df;\u6119\u0200;eio\u0eb9\u0eba\u0ee0\u0ee4\u6abbcedes\u0200;EST\u0ec8\u0ec9\u0ecf\u0eda\u627aqual;\u6aaflantEqual;\u627cilde;\u627eme;\u6033\u0100dp\u0ee9\u0eeeuct;\u620fortion\u0100;a\u0225\u0ef9l;\u621d\u0100ci\u0f01\u0f06r;\uc000\ud835\udcab;\u43a8\u0200Ufos\u0f11\u0f16\u0f1b\u0f1fOT\u803b\"\u4022r;\uc000\ud835\udd14pf;\u611acr;\uc000\ud835\udcac\u0600BEacefhiorsu\u0f3e\u0f43\u0f47\u0f60\u0f73\u0fa7\u0faa\u0fad\u1096\u10a9\u10b4\u10bearr;\u6910G\u803b\xae\u40ae\u0180cnr\u0f4e\u0f53\u0f56ute;\u4154g;\u67ebr\u0100;t\u0f5c\u0f5d\u61a0l;\u6916\u0180aey\u0f67\u0f6c\u0f71ron;\u4158dil;\u4156;\u4420\u0100;v\u0f78\u0f79\u611cerse\u0100EU\u0f82\u0f99\u0100lq\u0f87\u0f8eement;\u620builibrium;\u61cbpEquilibrium;\u696fr\xbb\u0f79o;\u43a1ght\u0400ACDFTUVa\u0fc1\u0feb\u0ff3\u1022\u1028\u105b\u1087\u03d8\u0100nr\u0fc6\u0fd2gleBracket;\u67e9row\u0180;BL\u0fdc\u0fdd\u0fe1\u6192ar;\u61e5eftArrow;\u61c4eiling;\u6309o\u01f5\u0ff9\0\u1005bleBracket;\u67e7n\u01d4\u100a\0\u1014eeVector;\u695dector\u0100;B\u101d\u101e\u61c2ar;\u6955loor;\u630b\u0100er\u102d\u1043e\u0180;AV\u1035\u1036\u103c\u62a2rrow;\u61a6ector;\u695biangle\u0180;BE\u1050\u1051\u1055\u62b3ar;\u69d0qual;\u62b5p\u0180DTV\u1063\u106e\u1078ownVector;\u694feeVector;\u695cector\u0100;B\u1082\u1083\u61bear;\u6954ector\u0100;B\u1091\u1092\u61c0ar;\u6953\u0100pu\u109b\u109ef;\u611dndImplies;\u6970ightarrow;\u61db\u0100ch\u10b9\u10bcr;\u611b;\u61b1leDelayed;\u69f4\u0680HOacfhimoqstu\u10e4\u10f1\u10f7\u10fd\u1119\u111e\u1151\u1156\u1161\u1167\u11b5\u11bb\u11bf\u0100Cc\u10e9\u10eeHcy;\u4429y;\u4428FTcy;\u442ccute;\u415a\u0280;aeiy\u1108\u1109\u110e\u1113\u1117\u6abcron;\u4160dil;\u415erc;\u415c;\u4421r;\uc000\ud835\udd16ort\u0200DLRU\u112a\u1134\u113e\u1149ownArrow\xbb\u041eeftArrow\xbb\u089aightArrow\xbb\u0fddpArrow;\u6191gma;\u43a3allCircle;\u6218pf;\uc000\ud835\udd4a\u0272\u116d\0\0\u1170t;\u621aare\u0200;ISU\u117b\u117c\u1189\u11af\u65a1ntersection;\u6293u\u0100bp\u118f\u119eset\u0100;E\u1197\u1198\u628fqual;\u6291erset\u0100;E\u11a8\u11a9\u6290qual;\u6292nion;\u6294cr;\uc000\ud835\udcaear;\u62c6\u0200bcmp\u11c8\u11db\u1209\u120b\u0100;s\u11cd\u11ce\u62d0et\u0100;E\u11cd\u11d5qual;\u6286\u0100ch\u11e0\u1205eeds\u0200;EST\u11ed\u11ee\u11f4\u11ff\u627bqual;\u6ab0lantEqual;\u627dilde;\u627fTh\xe1\u0f8c;\u6211\u0180;es\u1212\u1213\u1223\u62d1rset\u0100;E\u121c\u121d\u6283qual;\u6287et\xbb\u1213\u0580HRSacfhiors\u123e\u1244\u1249\u1255\u125e\u1271\u1276\u129f\u12c2\u12c8\u12d1ORN\u803b\xde\u40deADE;\u6122\u0100Hc\u124e\u1252cy;\u440by;\u4426\u0100bu\u125a\u125c;\u4009;\u43a4\u0180aey\u1265\u126a\u126fron;\u4164dil;\u4162;\u4422r;\uc000\ud835\udd17\u0100ei\u127b\u1289\u01f2\u1280\0\u1287efore;\u6234a;\u4398\u0100cn\u128e\u1298kSpace;\uc000\u205f\u200aSpace;\u6009lde\u0200;EFT\u12ab\u12ac\u12b2\u12bc\u623cqual;\u6243ullEqual;\u6245ilde;\u6248pf;\uc000\ud835\udd4bipleDot;\u60db\u0100ct\u12d6\u12dbr;\uc000\ud835\udcafrok;\u4166\u0ae1\u12f7\u130e\u131a\u1326\0\u132c\u1331\0\0\0\0\0\u1338\u133d\u1377\u1385\0\u13ff\u1404\u140a\u1410\u0100cr\u12fb\u1301ute\u803b\xda\u40dar\u0100;o\u1307\u1308\u619fcir;\u6949r\u01e3\u1313\0\u1316y;\u440eve;\u416c\u0100iy\u131e\u1323rc\u803b\xdb\u40db;\u4423blac;\u4170r;\uc000\ud835\udd18rave\u803b\xd9\u40d9acr;\u416a\u0100di\u1341\u1369er\u0100BP\u1348\u135d\u0100ar\u134d\u1350r;\u405fac\u0100ek\u1357\u1359;\u63dfet;\u63b5arenthesis;\u63ddon\u0100;P\u1370\u1371\u62c3lus;\u628e\u0100gp\u137b\u137fon;\u4172f;\uc000\ud835\udd4c\u0400ADETadps\u1395\u13ae\u13b8\u13c4\u03e8\u13d2\u13d7\u13f3rrow\u0180;BD\u1150\u13a0\u13a4ar;\u6912ownArrow;\u61c5ownArrow;\u6195quilibrium;\u696eee\u0100;A\u13cb\u13cc\u62a5rrow;\u61a5own\xe1\u03f3er\u0100LR\u13de\u13e8eftArrow;\u6196ightArrow;\u6197i\u0100;l\u13f9\u13fa\u43d2on;\u43a5ing;\u416ecr;\uc000\ud835\udcb0ilde;\u4168ml\u803b\xdc\u40dc\u0480Dbcdefosv\u1427\u142c\u1430\u1433\u143e\u1485\u148a\u1490\u1496ash;\u62abar;\u6aeby;\u4412ash\u0100;l\u143b\u143c\u62a9;\u6ae6\u0100er\u1443\u1445;\u62c1\u0180bty\u144c\u1450\u147aar;\u6016\u0100;i\u144f\u1455cal\u0200BLST\u1461\u1465\u146a\u1474ar;\u6223ine;\u407ceparator;\u6758ilde;\u6240ThinSpace;\u600ar;\uc000\ud835\udd19pf;\uc000\ud835\udd4dcr;\uc000\ud835\udcb1dash;\u62aa\u0280cefos\u14a7\u14ac\u14b1\u14b6\u14bcirc;\u4174dge;\u62c0r;\uc000\ud835\udd1apf;\uc000\ud835\udd4ecr;\uc000\ud835\udcb2\u0200fios\u14cb\u14d0\u14d2\u14d8r;\uc000\ud835\udd1b;\u439epf;\uc000\ud835\udd4fcr;\uc000\ud835\udcb3\u0480AIUacfosu\u14f1\u14f5\u14f9\u14fd\u1504\u150f\u1514\u151a\u1520cy;\u442fcy;\u4407cy;\u442ecute\u803b\xdd\u40dd\u0100iy\u1509\u150drc;\u4176;\u442br;\uc000\ud835\udd1cpf;\uc000\ud835\udd50cr;\uc000\ud835\udcb4ml;\u4178\u0400Hacdefos\u1535\u1539\u153f\u154b\u154f\u155d\u1560\u1564cy;\u4416cute;\u4179\u0100ay\u1544\u1549ron;\u417d;\u4417ot;\u417b\u01f2\u1554\0\u155boWidt\xe8\u0ad9a;\u4396r;\u6128pf;\u6124cr;\uc000\ud835\udcb5\u0be1\u1583\u158a\u1590\0\u15b0\u15b6\u15bf\0\0\0\0\u15c6\u15db\u15eb\u165f\u166d\0\u1695\u169b\u16b2\u16b9\0\u16becute\u803b\xe1\u40e1reve;\u4103\u0300;Ediuy\u159c\u159d\u15a1\u15a3\u15a8\u15ad\u623e;\uc000\u223e\u0333;\u623frc\u803b\xe2\u40e2te\u80bb\xb4\u0306;\u4430lig\u803b\xe6\u40e6\u0100;r\xb2\u15ba;\uc000\ud835\udd1erave\u803b\xe0\u40e0\u0100ep\u15ca\u15d6\u0100fp\u15cf\u15d4sym;\u6135\xe8\u15d3ha;\u43b1\u0100ap\u15dfc\u0100cl\u15e4\u15e7r;\u4101g;\u6a3f\u0264\u15f0\0\0\u160a\u0280;adsv\u15fa\u15fb\u15ff\u1601\u1607\u6227nd;\u6a55;\u6a5clope;\u6a58;\u6a5a\u0380;elmrsz\u1618\u1619\u161b\u161e\u163f\u164f\u1659\u6220;\u69a4e\xbb\u1619sd\u0100;a\u1625\u1626\u6221\u0461\u1630\u1632\u1634\u1636\u1638\u163a\u163c\u163e;\u69a8;\u69a9;\u69aa;\u69ab;\u69ac;\u69ad;\u69ae;\u69aft\u0100;v\u1645\u1646\u621fb\u0100;d\u164c\u164d\u62be;\u699d\u0100pt\u1654\u1657h;\u6222\xbb\xb9arr;\u637c\u0100gp\u1663\u1667on;\u4105f;\uc000\ud835\udd52\u0380;Eaeiop\u12c1\u167b\u167d\u1682\u1684\u1687\u168a;\u6a70cir;\u6a6f;\u624ad;\u624bs;\u4027rox\u0100;e\u12c1\u1692\xf1\u1683ing\u803b\xe5\u40e5\u0180cty\u16a1\u16a6\u16a8r;\uc000\ud835\udcb6;\u402amp\u0100;e\u12c1\u16af\xf1\u0288ilde\u803b\xe3\u40e3ml\u803b\xe4\u40e4\u0100ci\u16c2\u16c8onin\xf4\u0272nt;\u6a11\u0800Nabcdefiklnoprsu\u16ed\u16f1\u1730\u173c\u1743\u1748\u1778\u177d\u17e0\u17e6\u1839\u1850\u170d\u193d\u1948\u1970ot;\u6aed\u0100cr\u16f6\u171ek\u0200ceps\u1700\u1705\u170d\u1713ong;\u624cpsilon;\u43f6rime;\u6035im\u0100;e\u171a\u171b\u623dq;\u62cd\u0176\u1722\u1726ee;\u62bded\u0100;g\u172c\u172d\u6305e\xbb\u172drk\u0100;t\u135c\u1737brk;\u63b6\u0100oy\u1701\u1741;\u4431quo;\u601e\u0280cmprt\u1753\u175b\u1761\u1764\u1768aus\u0100;e\u010a\u0109ptyv;\u69b0s\xe9\u170cno\xf5\u0113\u0180ahw\u176f\u1771\u1773;\u43b2;\u6136een;\u626cr;\uc000\ud835\udd1fg\u0380costuvw\u178d\u179d\u17b3\u17c1\u17d5\u17db\u17de\u0180aiu\u1794\u1796\u179a\xf0\u0760rc;\u65efp\xbb\u1371\u0180dpt\u17a4\u17a8\u17adot;\u6a00lus;\u6a01imes;\u6a02\u0271\u17b9\0\0\u17becup;\u6a06ar;\u6605riangle\u0100du\u17cd\u17d2own;\u65bdp;\u65b3plus;\u6a04e\xe5\u1444\xe5\u14adarow;\u690d\u0180ako\u17ed\u1826\u1835\u0100cn\u17f2\u1823k\u0180lst\u17fa\u05ab\u1802ozenge;\u69ebriangle\u0200;dlr\u1812\u1813\u1818\u181d\u65b4own;\u65beeft;\u65c2ight;\u65b8k;\u6423\u01b1\u182b\0\u1833\u01b2\u182f\0\u1831;\u6592;\u65914;\u6593ck;\u6588\u0100eo\u183e\u184d\u0100;q\u1843\u1846\uc000=\u20e5uiv;\uc000\u2261\u20e5t;\u6310\u0200ptwx\u1859\u185e\u1867\u186cf;\uc000\ud835\udd53\u0100;t\u13cb\u1863om\xbb\u13cctie;\u62c8\u0600DHUVbdhmptuv\u1885\u1896\u18aa\u18bb\u18d7\u18db\u18ec\u18ff\u1905\u190a\u1910\u1921\u0200LRlr\u188e\u1890\u1892\u1894;\u6557;\u6554;\u6556;\u6553\u0280;DUdu\u18a1\u18a2\u18a4\u18a6\u18a8\u6550;\u6566;\u6569;\u6564;\u6567\u0200LRlr\u18b3\u18b5\u18b7\u18b9;\u655d;\u655a;\u655c;\u6559\u0380;HLRhlr\u18ca\u18cb\u18cd\u18cf\u18d1\u18d3\u18d5\u6551;\u656c;\u6563;\u6560;\u656b;\u6562;\u655fox;\u69c9\u0200LRlr\u18e4\u18e6\u18e8\u18ea;\u6555;\u6552;\u6510;\u650c\u0280;DUdu\u06bd\u18f7\u18f9\u18fb\u18fd;\u6565;\u6568;\u652c;\u6534inus;\u629flus;\u629eimes;\u62a0\u0200LRlr\u1919\u191b\u191d\u191f;\u655b;\u6558;\u6518;\u6514\u0380;HLRhlr\u1930\u1931\u1933\u1935\u1937\u1939\u193b\u6502;\u656a;\u6561;\u655e;\u653c;\u6524;\u651c\u0100ev\u0123\u1942bar\u803b\xa6\u40a6\u0200ceio\u1951\u1956\u195a\u1960r;\uc000\ud835\udcb7mi;\u604fm\u0100;e\u171a\u171cl\u0180;bh\u1968\u1969\u196b\u405c;\u69c5sub;\u67c8\u016c\u1974\u197el\u0100;e\u1979\u197a\u6022t\xbb\u197ap\u0180;Ee\u012f\u1985\u1987;\u6aae\u0100;q\u06dc\u06db\u0ce1\u19a7\0\u19e8\u1a11\u1a15\u1a32\0\u1a37\u1a50\0\0\u1ab4\0\0\u1ac1\0\0\u1b21\u1b2e\u1b4d\u1b52\0\u1bfd\0\u1c0c\u0180cpr\u19ad\u19b2\u19ddute;\u4107\u0300;abcds\u19bf\u19c0\u19c4\u19ca\u19d5\u19d9\u6229nd;\u6a44rcup;\u6a49\u0100au\u19cf\u19d2p;\u6a4bp;\u6a47ot;\u6a40;\uc000\u2229\ufe00\u0100eo\u19e2\u19e5t;\u6041\xee\u0693\u0200aeiu\u19f0\u19fb\u1a01\u1a05\u01f0\u19f5\0\u19f8s;\u6a4don;\u410ddil\u803b\xe7\u40e7rc;\u4109ps\u0100;s\u1a0c\u1a0d\u6a4cm;\u6a50ot;\u410b\u0180dmn\u1a1b\u1a20\u1a26il\u80bb\xb8\u01adptyv;\u69b2t\u8100\xa2;e\u1a2d\u1a2e\u40a2r\xe4\u01b2r;\uc000\ud835\udd20\u0180cei\u1a3d\u1a40\u1a4dy;\u4447ck\u0100;m\u1a47\u1a48\u6713ark\xbb\u1a48;\u43c7r\u0380;Ecefms\u1a5f\u1a60\u1a62\u1a6b\u1aa4\u1aaa\u1aae\u65cb;\u69c3\u0180;el\u1a69\u1a6a\u1a6d\u42c6q;\u6257e\u0261\u1a74\0\0\u1a88rrow\u0100lr\u1a7c\u1a81eft;\u61baight;\u61bb\u0280RSacd\u1a92\u1a94\u1a96\u1a9a\u1a9f\xbb\u0f47;\u64c8st;\u629birc;\u629aash;\u629dnint;\u6a10id;\u6aefcir;\u69c2ubs\u0100;u\u1abb\u1abc\u6663it\xbb\u1abc\u02ec\u1ac7\u1ad4\u1afa\0\u1b0aon\u0100;e\u1acd\u1ace\u403a\u0100;q\xc7\xc6\u026d\u1ad9\0\0\u1ae2a\u0100;t\u1ade\u1adf\u402c;\u4040\u0180;fl\u1ae8\u1ae9\u1aeb\u6201\xee\u1160e\u0100mx\u1af1\u1af6ent\xbb\u1ae9e\xf3\u024d\u01e7\u1afe\0\u1b07\u0100;d\u12bb\u1b02ot;\u6a6dn\xf4\u0246\u0180fry\u1b10\u1b14\u1b17;\uc000\ud835\udd54o\xe4\u0254\u8100\xa9;s\u0155\u1b1dr;\u6117\u0100ao\u1b25\u1b29rr;\u61b5ss;\u6717\u0100cu\u1b32\u1b37r;\uc000\ud835\udcb8\u0100bp\u1b3c\u1b44\u0100;e\u1b41\u1b42\u6acf;\u6ad1\u0100;e\u1b49\u1b4a\u6ad0;\u6ad2dot;\u62ef\u0380delprvw\u1b60\u1b6c\u1b77\u1b82\u1bac\u1bd4\u1bf9arr\u0100lr\u1b68\u1b6a;\u6938;\u6935\u0270\u1b72\0\0\u1b75r;\u62dec;\u62dfarr\u0100;p\u1b7f\u1b80\u61b6;\u693d\u0300;bcdos\u1b8f\u1b90\u1b96\u1ba1\u1ba5\u1ba8\u622arcap;\u6a48\u0100au\u1b9b\u1b9ep;\u6a46p;\u6a4aot;\u628dr;\u6a45;\uc000\u222a\ufe00\u0200alrv\u1bb5\u1bbf\u1bde\u1be3rr\u0100;m\u1bbc\u1bbd\u61b7;\u693cy\u0180evw\u1bc7\u1bd4\u1bd8q\u0270\u1bce\0\0\u1bd2re\xe3\u1b73u\xe3\u1b75ee;\u62ceedge;\u62cfen\u803b\xa4\u40a4earrow\u0100lr\u1bee\u1bf3eft\xbb\u1b80ight\xbb\u1bbde\xe4\u1bdd\u0100ci\u1c01\u1c07onin\xf4\u01f7nt;\u6231lcty;\u632d\u0980AHabcdefhijlorstuwz\u1c38\u1c3b\u1c3f\u1c5d\u1c69\u1c75\u1c8a\u1c9e\u1cac\u1cb7\u1cfb\u1cff\u1d0d\u1d7b\u1d91\u1dab\u1dbb\u1dc6\u1dcdr\xf2\u0381ar;\u6965\u0200glrs\u1c48\u1c4d\u1c52\u1c54ger;\u6020eth;\u6138\xf2\u1133h\u0100;v\u1c5a\u1c5b\u6010\xbb\u090a\u016b\u1c61\u1c67arow;\u690fa\xe3\u0315\u0100ay\u1c6e\u1c73ron;\u410f;\u4434\u0180;ao\u0332\u1c7c\u1c84\u0100gr\u02bf\u1c81r;\u61catseq;\u6a77\u0180glm\u1c91\u1c94\u1c98\u803b\xb0\u40b0ta;\u43b4ptyv;\u69b1\u0100ir\u1ca3\u1ca8sht;\u697f;\uc000\ud835\udd21ar\u0100lr\u1cb3\u1cb5\xbb\u08dc\xbb\u101e\u0280aegsv\u1cc2\u0378\u1cd6\u1cdc\u1ce0m\u0180;os\u0326\u1cca\u1cd4nd\u0100;s\u0326\u1cd1uit;\u6666amma;\u43ddin;\u62f2\u0180;io\u1ce7\u1ce8\u1cf8\u40f7de\u8100\xf7;o\u1ce7\u1cf0ntimes;\u62c7n\xf8\u1cf7cy;\u4452c\u026f\u1d06\0\0\u1d0arn;\u631eop;\u630d\u0280lptuw\u1d18\u1d1d\u1d22\u1d49\u1d55lar;\u4024f;\uc000\ud835\udd55\u0280;emps\u030b\u1d2d\u1d37\u1d3d\u1d42q\u0100;d\u0352\u1d33ot;\u6251inus;\u6238lus;\u6214quare;\u62a1blebarwedg\xe5\xfan\u0180adh\u112e\u1d5d\u1d67ownarrow\xf3\u1c83arpoon\u0100lr\u1d72\u1d76ef\xf4\u1cb4igh\xf4\u1cb6\u0162\u1d7f\u1d85karo\xf7\u0f42\u026f\u1d8a\0\0\u1d8ern;\u631fop;\u630c\u0180cot\u1d98\u1da3\u1da6\u0100ry\u1d9d\u1da1;\uc000\ud835\udcb9;\u4455l;\u69f6rok;\u4111\u0100dr\u1db0\u1db4ot;\u62f1i\u0100;f\u1dba\u1816\u65bf\u0100ah\u1dc0\u1dc3r\xf2\u0429a\xf2\u0fa6angle;\u69a6\u0100ci\u1dd2\u1dd5y;\u445fgrarr;\u67ff\u0900Dacdefglmnopqrstux\u1e01\u1e09\u1e19\u1e38\u0578\u1e3c\u1e49\u1e61\u1e7e\u1ea5\u1eaf\u1ebd\u1ee1\u1f2a\u1f37\u1f44\u1f4e\u1f5a\u0100Do\u1e06\u1d34o\xf4\u1c89\u0100cs\u1e0e\u1e14ute\u803b\xe9\u40e9ter;\u6a6e\u0200aioy\u1e22\u1e27\u1e31\u1e36ron;\u411br\u0100;c\u1e2d\u1e2e\u6256\u803b\xea\u40ealon;\u6255;\u444dot;\u4117\u0100Dr\u1e41\u1e45ot;\u6252;\uc000\ud835\udd22\u0180;rs\u1e50\u1e51\u1e57\u6a9aave\u803b\xe8\u40e8\u0100;d\u1e5c\u1e5d\u6a96ot;\u6a98\u0200;ils\u1e6a\u1e6b\u1e72\u1e74\u6a99nters;\u63e7;\u6113\u0100;d\u1e79\u1e7a\u6a95ot;\u6a97\u0180aps\u1e85\u1e89\u1e97cr;\u4113ty\u0180;sv\u1e92\u1e93\u1e95\u6205et\xbb\u1e93p\u01001;\u1e9d\u1ea4\u0133\u1ea1\u1ea3;\u6004;\u6005\u6003\u0100gs\u1eaa\u1eac;\u414bp;\u6002\u0100gp\u1eb4\u1eb8on;\u4119f;\uc000\ud835\udd56\u0180als\u1ec4\u1ece\u1ed2r\u0100;s\u1eca\u1ecb\u62d5l;\u69e3us;\u6a71i\u0180;lv\u1eda\u1edb\u1edf\u43b5on\xbb\u1edb;\u43f5\u0200csuv\u1eea\u1ef3\u1f0b\u1f23\u0100io\u1eef\u1e31rc\xbb\u1e2e\u0269\u1ef9\0\0\u1efb\xed\u0548ant\u0100gl\u1f02\u1f06tr\xbb\u1e5dess\xbb\u1e7a\u0180aei\u1f12\u1f16\u1f1als;\u403dst;\u625fv\u0100;D\u0235\u1f20D;\u6a78parsl;\u69e5\u0100Da\u1f2f\u1f33ot;\u6253rr;\u6971\u0180cdi\u1f3e\u1f41\u1ef8r;\u612fo\xf4\u0352\u0100ah\u1f49\u1f4b;\u43b7\u803b\xf0\u40f0\u0100mr\u1f53\u1f57l\u803b\xeb\u40ebo;\u60ac\u0180cip\u1f61\u1f64\u1f67l;\u4021s\xf4\u056e\u0100eo\u1f6c\u1f74ctatio\xee\u0559nential\xe5\u0579\u09e1\u1f92\0\u1f9e\0\u1fa1\u1fa7\0\0\u1fc6\u1fcc\0\u1fd3\0\u1fe6\u1fea\u2000\0\u2008\u205allingdotse\xf1\u1e44y;\u4444male;\u6640\u0180ilr\u1fad\u1fb3\u1fc1lig;\u8000\ufb03\u0269\u1fb9\0\0\u1fbdg;\u8000\ufb00ig;\u8000\ufb04;\uc000\ud835\udd23lig;\u8000\ufb01lig;\uc000fj\u0180alt\u1fd9\u1fdc\u1fe1t;\u666dig;\u8000\ufb02ns;\u65b1of;\u4192\u01f0\u1fee\0\u1ff3f;\uc000\ud835\udd57\u0100ak\u05bf\u1ff7\u0100;v\u1ffc\u1ffd\u62d4;\u6ad9artint;\u6a0d\u0100ao\u200c\u2055\u0100cs\u2011\u2052\u03b1\u201a\u2030\u2038\u2045\u2048\0\u2050\u03b2\u2022\u2025\u2027\u202a\u202c\0\u202e\u803b\xbd\u40bd;\u6153\u803b\xbc\u40bc;\u6155;\u6159;\u615b\u01b3\u2034\0\u2036;\u6154;\u6156\u02b4\u203e\u2041\0\0\u2043\u803b\xbe\u40be;\u6157;\u615c5;\u6158\u01b6\u204c\0\u204e;\u615a;\u615d8;\u615el;\u6044wn;\u6322cr;\uc000\ud835\udcbb\u0880Eabcdefgijlnorstv\u2082\u2089\u209f\u20a5\u20b0\u20b4\u20f0\u20f5\u20fa\u20ff\u2103\u2112\u2138\u0317\u213e\u2152\u219e\u0100;l\u064d\u2087;\u6a8c\u0180cmp\u2090\u2095\u209dute;\u41f5ma\u0100;d\u209c\u1cda\u43b3;\u6a86reve;\u411f\u0100iy\u20aa\u20aerc;\u411d;\u4433ot;\u4121\u0200;lqs\u063e\u0642\u20bd\u20c9\u0180;qs\u063e\u064c\u20c4lan\xf4\u0665\u0200;cdl\u0665\u20d2\u20d5\u20e5c;\u6aa9ot\u0100;o\u20dc\u20dd\u6a80\u0100;l\u20e2\u20e3\u6a82;\u6a84\u0100;e\u20ea\u20ed\uc000\u22db\ufe00s;\u6a94r;\uc000\ud835\udd24\u0100;g\u0673\u061bmel;\u6137cy;\u4453\u0200;Eaj\u065a\u210c\u210e\u2110;\u6a92;\u6aa5;\u6aa4\u0200Eaes\u211b\u211d\u2129\u2134;\u6269p\u0100;p\u2123\u2124\u6a8arox\xbb\u2124\u0100;q\u212e\u212f\u6a88\u0100;q\u212e\u211bim;\u62e7pf;\uc000\ud835\udd58\u0100ci\u2143\u2146r;\u610am\u0180;el\u066b\u214e\u2150;\u6a8e;\u6a90\u8300>;cdlqr\u05ee\u2160\u216a\u216e\u2173\u2179\u0100ci\u2165\u2167;\u6aa7r;\u6a7aot;\u62d7Par;\u6995uest;\u6a7c\u0280adels\u2184\u216a\u2190\u0656\u219b\u01f0\u2189\0\u218epro\xf8\u209er;\u6978q\u0100lq\u063f\u2196les\xf3\u2088i\xed\u066b\u0100en\u21a3\u21adrtneqq;\uc000\u2269\ufe00\xc5\u21aa\u0500Aabcefkosy\u21c4\u21c7\u21f1\u21f5\u21fa\u2218\u221d\u222f\u2268\u227dr\xf2\u03a0\u0200ilmr\u21d0\u21d4\u21d7\u21dbrs\xf0\u1484f\xbb\u2024il\xf4\u06a9\u0100dr\u21e0\u21e4cy;\u444a\u0180;cw\u08f4\u21eb\u21efir;\u6948;\u61adar;\u610firc;\u4125\u0180alr\u2201\u220e\u2213rts\u0100;u\u2209\u220a\u6665it\xbb\u220alip;\u6026con;\u62b9r;\uc000\ud835\udd25s\u0100ew\u2223\u2229arow;\u6925arow;\u6926\u0280amopr\u223a\u223e\u2243\u225e\u2263rr;\u61fftht;\u623bk\u0100lr\u2249\u2253eftarrow;\u61a9ightarrow;\u61aaf;\uc000\ud835\udd59bar;\u6015\u0180clt\u226f\u2274\u2278r;\uc000\ud835\udcbdas\xe8\u21f4rok;\u4127\u0100bp\u2282\u2287ull;\u6043hen\xbb\u1c5b\u0ae1\u22a3\0\u22aa\0\u22b8\u22c5\u22ce\0\u22d5\u22f3\0\0\u22f8\u2322\u2367\u2362\u237f\0\u2386\u23aa\u23b4cute\u803b\xed\u40ed\u0180;iy\u0771\u22b0\u22b5rc\u803b\xee\u40ee;\u4438\u0100cx\u22bc\u22bfy;\u4435cl\u803b\xa1\u40a1\u0100fr\u039f\u22c9;\uc000\ud835\udd26rave\u803b\xec\u40ec\u0200;ino\u073e\u22dd\u22e9\u22ee\u0100in\u22e2\u22e6nt;\u6a0ct;\u622dfin;\u69dcta;\u6129lig;\u4133\u0180aop\u22fe\u231a\u231d\u0180cgt\u2305\u2308\u2317r;\u412b\u0180elp\u071f\u230f\u2313in\xe5\u078ear\xf4\u0720h;\u4131f;\u62b7ed;\u41b5\u0280;cfot\u04f4\u232c\u2331\u233d\u2341are;\u6105in\u0100;t\u2338\u2339\u621eie;\u69dddo\xf4\u2319\u0280;celp\u0757\u234c\u2350\u235b\u2361al;\u62ba\u0100gr\u2355\u2359er\xf3\u1563\xe3\u234darhk;\u6a17rod;\u6a3c\u0200cgpt\u236f\u2372\u2376\u237by;\u4451on;\u412ff;\uc000\ud835\udd5aa;\u43b9uest\u803b\xbf\u40bf\u0100ci\u238a\u238fr;\uc000\ud835\udcben\u0280;Edsv\u04f4\u239b\u239d\u23a1\u04f3;\u62f9ot;\u62f5\u0100;v\u23a6\u23a7\u62f4;\u62f3\u0100;i\u0777\u23aelde;\u4129\u01eb\u23b8\0\u23bccy;\u4456l\u803b\xef\u40ef\u0300cfmosu\u23cc\u23d7\u23dc\u23e1\u23e7\u23f5\u0100iy\u23d1\u23d5rc;\u4135;\u4439r;\uc000\ud835\udd27ath;\u4237pf;\uc000\ud835\udd5b\u01e3\u23ec\0\u23f1r;\uc000\ud835\udcbfrcy;\u4458kcy;\u4454\u0400acfghjos\u240b\u2416\u2422\u2427\u242d\u2431\u2435\u243bppa\u0100;v\u2413\u2414\u43ba;\u43f0\u0100ey\u241b\u2420dil;\u4137;\u443ar;\uc000\ud835\udd28reen;\u4138cy;\u4445cy;\u445cpf;\uc000\ud835\udd5ccr;\uc000\ud835\udcc0\u0b80ABEHabcdefghjlmnoprstuv\u2470\u2481\u2486\u248d\u2491\u250e\u253d\u255a\u2580\u264e\u265e\u2665\u2679\u267d\u269a\u26b2\u26d8\u275d\u2768\u278b\u27c0\u2801\u2812\u0180art\u2477\u247a\u247cr\xf2\u09c6\xf2\u0395ail;\u691barr;\u690e\u0100;g\u0994\u248b;\u6a8bar;\u6962\u0963\u24a5\0\u24aa\0\u24b1\0\0\0\0\0\u24b5\u24ba\0\u24c6\u24c8\u24cd\0\u24f9ute;\u413amptyv;\u69b4ra\xee\u084cbda;\u43bbg\u0180;dl\u088e\u24c1\u24c3;\u6991\xe5\u088e;\u6a85uo\u803b\xab\u40abr\u0400;bfhlpst\u0899\u24de\u24e6\u24e9\u24eb\u24ee\u24f1\u24f5\u0100;f\u089d\u24e3s;\u691fs;\u691d\xeb\u2252p;\u61abl;\u6939im;\u6973l;\u61a2\u0180;ae\u24ff\u2500\u2504\u6aabil;\u6919\u0100;s\u2509\u250a\u6aad;\uc000\u2aad\ufe00\u0180abr\u2515\u2519\u251drr;\u690crk;\u6772\u0100ak\u2522\u252cc\u0100ek\u2528\u252a;\u407b;\u405b\u0100es\u2531\u2533;\u698bl\u0100du\u2539\u253b;\u698f;\u698d\u0200aeuy\u2546\u254b\u2556\u2558ron;\u413e\u0100di\u2550\u2554il;\u413c\xec\u08b0\xe2\u2529;\u443b\u0200cqrs\u2563\u2566\u256d\u257da;\u6936uo\u0100;r\u0e19\u1746\u0100du\u2572\u2577har;\u6967shar;\u694bh;\u61b2\u0280;fgqs\u258b\u258c\u0989\u25f3\u25ff\u6264t\u0280ahlrt\u2598\u25a4\u25b7\u25c2\u25e8rrow\u0100;t\u0899\u25a1a\xe9\u24f6arpoon\u0100du\u25af\u25b4own\xbb\u045ap\xbb\u0966eftarrows;\u61c7ight\u0180ahs\u25cd\u25d6\u25derrow\u0100;s\u08f4\u08a7arpoon\xf3\u0f98quigarro\xf7\u21f0hreetimes;\u62cb\u0180;qs\u258b\u0993\u25falan\xf4\u09ac\u0280;cdgs\u09ac\u260a\u260d\u261d\u2628c;\u6aa8ot\u0100;o\u2614\u2615\u6a7f\u0100;r\u261a\u261b\u6a81;\u6a83\u0100;e\u2622\u2625\uc000\u22da\ufe00s;\u6a93\u0280adegs\u2633\u2639\u263d\u2649\u264bppro\xf8\u24c6ot;\u62d6q\u0100gq\u2643\u2645\xf4\u0989gt\xf2\u248c\xf4\u099bi\xed\u09b2\u0180ilr\u2655\u08e1\u265asht;\u697c;\uc000\ud835\udd29\u0100;E\u099c\u2663;\u6a91\u0161\u2669\u2676r\u0100du\u25b2\u266e\u0100;l\u0965\u2673;\u696alk;\u6584cy;\u4459\u0280;acht\u0a48\u2688\u268b\u2691\u2696r\xf2\u25c1orne\xf2\u1d08ard;\u696bri;\u65fa\u0100io\u269f\u26a4dot;\u4140ust\u0100;a\u26ac\u26ad\u63b0che\xbb\u26ad\u0200Eaes\u26bb\u26bd\u26c9\u26d4;\u6268p\u0100;p\u26c3\u26c4\u6a89rox\xbb\u26c4\u0100;q\u26ce\u26cf\u6a87\u0100;q\u26ce\u26bbim;\u62e6\u0400abnoptwz\u26e9\u26f4\u26f7\u271a\u272f\u2741\u2747\u2750\u0100nr\u26ee\u26f1g;\u67ecr;\u61fdr\xeb\u08c1g\u0180lmr\u26ff\u270d\u2714eft\u0100ar\u09e6\u2707ight\xe1\u09f2apsto;\u67fcight\xe1\u09fdparrow\u0100lr\u2725\u2729ef\xf4\u24edight;\u61ac\u0180afl\u2736\u2739\u273dr;\u6985;\uc000\ud835\udd5dus;\u6a2dimes;\u6a34\u0161\u274b\u274fst;\u6217\xe1\u134e\u0180;ef\u2757\u2758\u1800\u65cange\xbb\u2758ar\u0100;l\u2764\u2765\u4028t;\u6993\u0280achmt\u2773\u2776\u277c\u2785\u2787r\xf2\u08a8orne\xf2\u1d8car\u0100;d\u0f98\u2783;\u696d;\u600eri;\u62bf\u0300achiqt\u2798\u279d\u0a40\u27a2\u27ae\u27bbquo;\u6039r;\uc000\ud835\udcc1m\u0180;eg\u09b2\u27aa\u27ac;\u6a8d;\u6a8f\u0100bu\u252a\u27b3o\u0100;r\u0e1f\u27b9;\u601arok;\u4142\u8400<;cdhilqr\u082b\u27d2\u2639\u27dc\u27e0\u27e5\u27ea\u27f0\u0100ci\u27d7\u27d9;\u6aa6r;\u6a79re\xe5\u25f2mes;\u62c9arr;\u6976uest;\u6a7b\u0100Pi\u27f5\u27f9ar;\u6996\u0180;ef\u2800\u092d\u181b\u65c3r\u0100du\u2807\u280dshar;\u694ahar;\u6966\u0100en\u2817\u2821rtneqq;\uc000\u2268\ufe00\xc5\u281e\u0700Dacdefhilnopsu\u2840\u2845\u2882\u288e\u2893\u28a0\u28a5\u28a8\u28da\u28e2\u28e4\u0a83\u28f3\u2902Dot;\u623a\u0200clpr\u284e\u2852\u2863\u287dr\u803b\xaf\u40af\u0100et\u2857\u2859;\u6642\u0100;e\u285e\u285f\u6720se\xbb\u285f\u0100;s\u103b\u2868to\u0200;dlu\u103b\u2873\u2877\u287bow\xee\u048cef\xf4\u090f\xf0\u13d1ker;\u65ae\u0100oy\u2887\u288cmma;\u6a29;\u443cash;\u6014asuredangle\xbb\u1626r;\uc000\ud835\udd2ao;\u6127\u0180cdn\u28af\u28b4\u28c9ro\u803b\xb5\u40b5\u0200;acd\u1464\u28bd\u28c0\u28c4s\xf4\u16a7ir;\u6af0ot\u80bb\xb7\u01b5us\u0180;bd\u28d2\u1903\u28d3\u6212\u0100;u\u1d3c\u28d8;\u6a2a\u0163\u28de\u28e1p;\u6adb\xf2\u2212\xf0\u0a81\u0100dp\u28e9\u28eeels;\u62a7f;\uc000\ud835\udd5e\u0100ct\u28f8\u28fdr;\uc000\ud835\udcc2pos\xbb\u159d\u0180;lm\u2909\u290a\u290d\u43bctimap;\u62b8\u0c00GLRVabcdefghijlmoprstuvw\u2942\u2953\u297e\u2989\u2998\u29da\u29e9\u2a15\u2a1a\u2a58\u2a5d\u2a83\u2a95\u2aa4\u2aa8\u2b04\u2b07\u2b44\u2b7f\u2bae\u2c34\u2c67\u2c7c\u2ce9\u0100gt\u2947\u294b;\uc000\u22d9\u0338\u0100;v\u2950\u0bcf\uc000\u226b\u20d2\u0180elt\u295a\u2972\u2976ft\u0100ar\u2961\u2967rrow;\u61cdightarrow;\u61ce;\uc000\u22d8\u0338\u0100;v\u297b\u0c47\uc000\u226a\u20d2ightarrow;\u61cf\u0100Dd\u298e\u2993ash;\u62afash;\u62ae\u0280bcnpt\u29a3\u29a7\u29ac\u29b1\u29ccla\xbb\u02deute;\u4144g;\uc000\u2220\u20d2\u0280;Eiop\u0d84\u29bc\u29c0\u29c5\u29c8;\uc000\u2a70\u0338d;\uc000\u224b\u0338s;\u4149ro\xf8\u0d84ur\u0100;a\u29d3\u29d4\u666el\u0100;s\u29d3\u0b38\u01f3\u29df\0\u29e3p\u80bb\xa0\u0b37mp\u0100;e\u0bf9\u0c00\u0280aeouy\u29f4\u29fe\u2a03\u2a10\u2a13\u01f0\u29f9\0\u29fb;\u6a43on;\u4148dil;\u4146ng\u0100;d\u0d7e\u2a0aot;\uc000\u2a6d\u0338p;\u6a42;\u443dash;\u6013\u0380;Aadqsx\u0b92\u2a29\u2a2d\u2a3b\u2a41\u2a45\u2a50rr;\u61d7r\u0100hr\u2a33\u2a36k;\u6924\u0100;o\u13f2\u13f0ot;\uc000\u2250\u0338ui\xf6\u0b63\u0100ei\u2a4a\u2a4ear;\u6928\xed\u0b98ist\u0100;s\u0ba0\u0b9fr;\uc000\ud835\udd2b\u0200Eest\u0bc5\u2a66\u2a79\u2a7c\u0180;qs\u0bbc\u2a6d\u0be1\u0180;qs\u0bbc\u0bc5\u2a74lan\xf4\u0be2i\xed\u0bea\u0100;r\u0bb6\u2a81\xbb\u0bb7\u0180Aap\u2a8a\u2a8d\u2a91r\xf2\u2971rr;\u61aear;\u6af2\u0180;sv\u0f8d\u2a9c\u0f8c\u0100;d\u2aa1\u2aa2\u62fc;\u62facy;\u445a\u0380AEadest\u2ab7\u2aba\u2abe\u2ac2\u2ac5\u2af6\u2af9r\xf2\u2966;\uc000\u2266\u0338rr;\u619ar;\u6025\u0200;fqs\u0c3b\u2ace\u2ae3\u2aeft\u0100ar\u2ad4\u2ad9rro\xf7\u2ac1ightarro\xf7\u2a90\u0180;qs\u0c3b\u2aba\u2aealan\xf4\u0c55\u0100;s\u0c55\u2af4\xbb\u0c36i\xed\u0c5d\u0100;r\u0c35\u2afei\u0100;e\u0c1a\u0c25i\xe4\u0d90\u0100pt\u2b0c\u2b11f;\uc000\ud835\udd5f\u8180\xac;in\u2b19\u2b1a\u2b36\u40acn\u0200;Edv\u0b89\u2b24\u2b28\u2b2e;\uc000\u22f9\u0338ot;\uc000\u22f5\u0338\u01e1\u0b89\u2b33\u2b35;\u62f7;\u62f6i\u0100;v\u0cb8\u2b3c\u01e1\u0cb8\u2b41\u2b43;\u62fe;\u62fd\u0180aor\u2b4b\u2b63\u2b69r\u0200;ast\u0b7b\u2b55\u2b5a\u2b5flle\xec\u0b7bl;\uc000\u2afd\u20e5;\uc000\u2202\u0338lint;\u6a14\u0180;ce\u0c92\u2b70\u2b73u\xe5\u0ca5\u0100;c\u0c98\u2b78\u0100;e\u0c92\u2b7d\xf1\u0c98\u0200Aait\u2b88\u2b8b\u2b9d\u2ba7r\xf2\u2988rr\u0180;cw\u2b94\u2b95\u2b99\u619b;\uc000\u2933\u0338;\uc000\u219d\u0338ghtarrow\xbb\u2b95ri\u0100;e\u0ccb\u0cd6\u0380chimpqu\u2bbd\u2bcd\u2bd9\u2b04\u0b78\u2be4\u2bef\u0200;cer\u0d32\u2bc6\u0d37\u2bc9u\xe5\u0d45;\uc000\ud835\udcc3ort\u026d\u2b05\0\0\u2bd6ar\xe1\u2b56m\u0100;e\u0d6e\u2bdf\u0100;q\u0d74\u0d73su\u0100bp\u2beb\u2bed\xe5\u0cf8\xe5\u0d0b\u0180bcp\u2bf6\u2c11\u2c19\u0200;Ees\u2bff\u2c00\u0d22\u2c04\u6284;\uc000\u2ac5\u0338et\u0100;e\u0d1b\u2c0bq\u0100;q\u0d23\u2c00c\u0100;e\u0d32\u2c17\xf1\u0d38\u0200;Ees\u2c22\u2c23\u0d5f\u2c27\u6285;\uc000\u2ac6\u0338et\u0100;e\u0d58\u2c2eq\u0100;q\u0d60\u2c23\u0200gilr\u2c3d\u2c3f\u2c45\u2c47\xec\u0bd7lde\u803b\xf1\u40f1\xe7\u0c43iangle\u0100lr\u2c52\u2c5ceft\u0100;e\u0c1a\u2c5a\xf1\u0c26ight\u0100;e\u0ccb\u2c65\xf1\u0cd7\u0100;m\u2c6c\u2c6d\u43bd\u0180;es\u2c74\u2c75\u2c79\u4023ro;\u6116p;\u6007\u0480DHadgilrs\u2c8f\u2c94\u2c99\u2c9e\u2ca3\u2cb0\u2cb6\u2cd3\u2ce3ash;\u62adarr;\u6904p;\uc000\u224d\u20d2ash;\u62ac\u0100et\u2ca8\u2cac;\uc000\u2265\u20d2;\uc000>\u20d2nfin;\u69de\u0180Aet\u2cbd\u2cc1\u2cc5rr;\u6902;\uc000\u2264\u20d2\u0100;r\u2cca\u2ccd\uc000<\u20d2ie;\uc000\u22b4\u20d2\u0100At\u2cd8\u2cdcrr;\u6903rie;\uc000\u22b5\u20d2im;\uc000\u223c\u20d2\u0180Aan\u2cf0\u2cf4\u2d02rr;\u61d6r\u0100hr\u2cfa\u2cfdk;\u6923\u0100;o\u13e7\u13e5ear;\u6927\u1253\u1a95\0\0\0\0\0\0\0\0\0\0\0\0\0\u2d2d\0\u2d38\u2d48\u2d60\u2d65\u2d72\u2d84\u1b07\0\0\u2d8d\u2dab\0\u2dc8\u2dce\0\u2ddc\u2e19\u2e2b\u2e3e\u2e43\u0100cs\u2d31\u1a97ute\u803b\xf3\u40f3\u0100iy\u2d3c\u2d45r\u0100;c\u1a9e\u2d42\u803b\xf4\u40f4;\u443e\u0280abios\u1aa0\u2d52\u2d57\u01c8\u2d5alac;\u4151v;\u6a38old;\u69bclig;\u4153\u0100cr\u2d69\u2d6dir;\u69bf;\uc000\ud835\udd2c\u036f\u2d79\0\0\u2d7c\0\u2d82n;\u42dbave\u803b\xf2\u40f2;\u69c1\u0100bm\u2d88\u0df4ar;\u69b5\u0200acit\u2d95\u2d98\u2da5\u2da8r\xf2\u1a80\u0100ir\u2d9d\u2da0r;\u69beoss;\u69bbn\xe5\u0e52;\u69c0\u0180aei\u2db1\u2db5\u2db9cr;\u414dga;\u43c9\u0180cdn\u2dc0\u2dc5\u01cdron;\u43bf;\u69b6pf;\uc000\ud835\udd60\u0180ael\u2dd4\u2dd7\u01d2r;\u69b7rp;\u69b9\u0380;adiosv\u2dea\u2deb\u2dee\u2e08\u2e0d\u2e10\u2e16\u6228r\xf2\u1a86\u0200;efm\u2df7\u2df8\u2e02\u2e05\u6a5dr\u0100;o\u2dfe\u2dff\u6134f\xbb\u2dff\u803b\xaa\u40aa\u803b\xba\u40bagof;\u62b6r;\u6a56lope;\u6a57;\u6a5b\u0180clo\u2e1f\u2e21\u2e27\xf2\u2e01ash\u803b\xf8\u40f8l;\u6298i\u016c\u2e2f\u2e34de\u803b\xf5\u40f5es\u0100;a\u01db\u2e3as;\u6a36ml\u803b\xf6\u40f6bar;\u633d\u0ae1\u2e5e\0\u2e7d\0\u2e80\u2e9d\0\u2ea2\u2eb9\0\0\u2ecb\u0e9c\0\u2f13\0\0\u2f2b\u2fbc\0\u2fc8r\u0200;ast\u0403\u2e67\u2e72\u0e85\u8100\xb6;l\u2e6d\u2e6e\u40b6le\xec\u0403\u0269\u2e78\0\0\u2e7bm;\u6af3;\u6afdy;\u443fr\u0280cimpt\u2e8b\u2e8f\u2e93\u1865\u2e97nt;\u4025od;\u402eil;\u6030enk;\u6031r;\uc000\ud835\udd2d\u0180imo\u2ea8\u2eb0\u2eb4\u0100;v\u2ead\u2eae\u43c6;\u43d5ma\xf4\u0a76ne;\u660e\u0180;tv\u2ebf\u2ec0\u2ec8\u43c0chfork\xbb\u1ffd;\u43d6\u0100au\u2ecf\u2edfn\u0100ck\u2ed5\u2eddk\u0100;h\u21f4\u2edb;\u610e\xf6\u21f4s\u0480;abcdemst\u2ef3\u2ef4\u1908\u2ef9\u2efd\u2f04\u2f06\u2f0a\u2f0e\u402bcir;\u6a23ir;\u6a22\u0100ou\u1d40\u2f02;\u6a25;\u6a72n\u80bb\xb1\u0e9dim;\u6a26wo;\u6a27\u0180ipu\u2f19\u2f20\u2f25ntint;\u6a15f;\uc000\ud835\udd61nd\u803b\xa3\u40a3\u0500;Eaceinosu\u0ec8\u2f3f\u2f41\u2f44\u2f47\u2f81\u2f89\u2f92\u2f7e\u2fb6;\u6ab3p;\u6ab7u\xe5\u0ed9\u0100;c\u0ece\u2f4c\u0300;acens\u0ec8\u2f59\u2f5f\u2f66\u2f68\u2f7eppro\xf8\u2f43urlye\xf1\u0ed9\xf1\u0ece\u0180aes\u2f6f\u2f76\u2f7approx;\u6ab9qq;\u6ab5im;\u62e8i\xed\u0edfme\u0100;s\u2f88\u0eae\u6032\u0180Eas\u2f78\u2f90\u2f7a\xf0\u2f75\u0180dfp\u0eec\u2f99\u2faf\u0180als\u2fa0\u2fa5\u2faalar;\u632eine;\u6312urf;\u6313\u0100;t\u0efb\u2fb4\xef\u0efbrel;\u62b0\u0100ci\u2fc0\u2fc5r;\uc000\ud835\udcc5;\u43c8ncsp;\u6008\u0300fiopsu\u2fda\u22e2\u2fdf\u2fe5\u2feb\u2ff1r;\uc000\ud835\udd2epf;\uc000\ud835\udd62rime;\u6057cr;\uc000\ud835\udcc6\u0180aeo\u2ff8\u3009\u3013t\u0100ei\u2ffe\u3005rnion\xf3\u06b0nt;\u6a16st\u0100;e\u3010\u3011\u403f\xf1\u1f19\xf4\u0f14\u0a80ABHabcdefhilmnoprstux\u3040\u3051\u3055\u3059\u30e0\u310e\u312b\u3147\u3162\u3172\u318e\u3206\u3215\u3224\u3229\u3258\u326e\u3272\u3290\u32b0\u32b7\u0180art\u3047\u304a\u304cr\xf2\u10b3\xf2\u03ddail;\u691car\xf2\u1c65ar;\u6964\u0380cdenqrt\u3068\u3075\u3078\u307f\u308f\u3094\u30cc\u0100eu\u306d\u3071;\uc000\u223d\u0331te;\u4155i\xe3\u116emptyv;\u69b3g\u0200;del\u0fd1\u3089\u308b\u308d;\u6992;\u69a5\xe5\u0fd1uo\u803b\xbb\u40bbr\u0580;abcfhlpstw\u0fdc\u30ac\u30af\u30b7\u30b9\u30bc\u30be\u30c0\u30c3\u30c7\u30cap;\u6975\u0100;f\u0fe0\u30b4s;\u6920;\u6933s;\u691e\xeb\u225d\xf0\u272el;\u6945im;\u6974l;\u61a3;\u619d\u0100ai\u30d1\u30d5il;\u691ao\u0100;n\u30db\u30dc\u6236al\xf3\u0f1e\u0180abr\u30e7\u30ea\u30eer\xf2\u17e5rk;\u6773\u0100ak\u30f3\u30fdc\u0100ek\u30f9\u30fb;\u407d;\u405d\u0100es\u3102\u3104;\u698cl\u0100du\u310a\u310c;\u698e;\u6990\u0200aeuy\u3117\u311c\u3127\u3129ron;\u4159\u0100di\u3121\u3125il;\u4157\xec\u0ff2\xe2\u30fa;\u4440\u0200clqs\u3134\u3137\u313d\u3144a;\u6937dhar;\u6969uo\u0100;r\u020e\u020dh;\u61b3\u0180acg\u314e\u315f\u0f44l\u0200;ips\u0f78\u3158\u315b\u109cn\xe5\u10bbar\xf4\u0fa9t;\u65ad\u0180ilr\u3169\u1023\u316esht;\u697d;\uc000\ud835\udd2f\u0100ao\u3177\u3186r\u0100du\u317d\u317f\xbb\u047b\u0100;l\u1091\u3184;\u696c\u0100;v\u318b\u318c\u43c1;\u43f1\u0180gns\u3195\u31f9\u31fcht\u0300ahlrst\u31a4\u31b0\u31c2\u31d8\u31e4\u31eerrow\u0100;t\u0fdc\u31ada\xe9\u30c8arpoon\u0100du\u31bb\u31bfow\xee\u317ep\xbb\u1092eft\u0100ah\u31ca\u31d0rrow\xf3\u0feaarpoon\xf3\u0551ightarrows;\u61c9quigarro\xf7\u30cbhreetimes;\u62ccg;\u42daingdotse\xf1\u1f32\u0180ahm\u320d\u3210\u3213r\xf2\u0feaa\xf2\u0551;\u600foust\u0100;a\u321e\u321f\u63b1che\xbb\u321fmid;\u6aee\u0200abpt\u3232\u323d\u3240\u3252\u0100nr\u3237\u323ag;\u67edr;\u61fer\xeb\u1003\u0180afl\u3247\u324a\u324er;\u6986;\uc000\ud835\udd63us;\u6a2eimes;\u6a35\u0100ap\u325d\u3267r\u0100;g\u3263\u3264\u4029t;\u6994olint;\u6a12ar\xf2\u31e3\u0200achq\u327b\u3280\u10bc\u3285quo;\u603ar;\uc000\ud835\udcc7\u0100bu\u30fb\u328ao\u0100;r\u0214\u0213\u0180hir\u3297\u329b\u32a0re\xe5\u31f8mes;\u62cai\u0200;efl\u32aa\u1059\u1821\u32ab\u65b9tri;\u69celuhar;\u6968;\u611e\u0d61\u32d5\u32db\u32df\u332c\u3338\u3371\0\u337a\u33a4\0\0\u33ec\u33f0\0\u3428\u3448\u345a\u34ad\u34b1\u34ca\u34f1\0\u3616\0\0\u3633cute;\u415bqu\xef\u27ba\u0500;Eaceinpsy\u11ed\u32f3\u32f5\u32ff\u3302\u330b\u330f\u331f\u3326\u3329;\u6ab4\u01f0\u32fa\0\u32fc;\u6ab8on;\u4161u\xe5\u11fe\u0100;d\u11f3\u3307il;\u415frc;\u415d\u0180Eas\u3316\u3318\u331b;\u6ab6p;\u6abaim;\u62e9olint;\u6a13i\xed\u1204;\u4441ot\u0180;be\u3334\u1d47\u3335\u62c5;\u6a66\u0380Aacmstx\u3346\u334a\u3357\u335b\u335e\u3363\u336drr;\u61d8r\u0100hr\u3350\u3352\xeb\u2228\u0100;o\u0a36\u0a34t\u803b\xa7\u40a7i;\u403bwar;\u6929m\u0100in\u3369\xf0nu\xf3\xf1t;\u6736r\u0100;o\u3376\u2055\uc000\ud835\udd30\u0200acoy\u3382\u3386\u3391\u33a0rp;\u666f\u0100hy\u338b\u338fcy;\u4449;\u4448rt\u026d\u3399\0\0\u339ci\xe4\u1464ara\xec\u2e6f\u803b\xad\u40ad\u0100gm\u33a8\u33b4ma\u0180;fv\u33b1\u33b2\u33b2\u43c3;\u43c2\u0400;deglnpr\u12ab\u33c5\u33c9\u33ce\u33d6\u33de\u33e1\u33e6ot;\u6a6a\u0100;q\u12b1\u12b0\u0100;E\u33d3\u33d4\u6a9e;\u6aa0\u0100;E\u33db\u33dc\u6a9d;\u6a9fe;\u6246lus;\u6a24arr;\u6972ar\xf2\u113d\u0200aeit\u33f8\u3408\u340f\u3417\u0100ls\u33fd\u3404lsetm\xe9\u336ahp;\u6a33parsl;\u69e4\u0100dl\u1463\u3414e;\u6323\u0100;e\u341c\u341d\u6aaa\u0100;s\u3422\u3423\u6aac;\uc000\u2aac\ufe00\u0180flp\u342e\u3433\u3442tcy;\u444c\u0100;b\u3438\u3439\u402f\u0100;a\u343e\u343f\u69c4r;\u633ff;\uc000\ud835\udd64a\u0100dr\u344d\u0402es\u0100;u\u3454\u3455\u6660it\xbb\u3455\u0180csu\u3460\u3479\u349f\u0100au\u3465\u346fp\u0100;s\u1188\u346b;\uc000\u2293\ufe00p\u0100;s\u11b4\u3475;\uc000\u2294\ufe00u\u0100bp\u347f\u348f\u0180;es\u1197\u119c\u3486et\u0100;e\u1197\u348d\xf1\u119d\u0180;es\u11a8\u11ad\u3496et\u0100;e\u11a8\u349d\xf1\u11ae\u0180;af\u117b\u34a6\u05b0r\u0165\u34ab\u05b1\xbb\u117car\xf2\u1148\u0200cemt\u34b9\u34be\u34c2\u34c5r;\uc000\ud835\udcc8tm\xee\xf1i\xec\u3415ar\xe6\u11be\u0100ar\u34ce\u34d5r\u0100;f\u34d4\u17bf\u6606\u0100an\u34da\u34edight\u0100ep\u34e3\u34eapsilo\xee\u1ee0h\xe9\u2eafs\xbb\u2852\u0280bcmnp\u34fb\u355e\u1209\u358b\u358e\u0480;Edemnprs\u350e\u350f\u3511\u3515\u351e\u3523\u352c\u3531\u3536\u6282;\u6ac5ot;\u6abd\u0100;d\u11da\u351aot;\u6ac3ult;\u6ac1\u0100Ee\u3528\u352a;\u6acb;\u628alus;\u6abfarr;\u6979\u0180eiu\u353d\u3552\u3555t\u0180;en\u350e\u3545\u354bq\u0100;q\u11da\u350feq\u0100;q\u352b\u3528m;\u6ac7\u0100bp\u355a\u355c;\u6ad5;\u6ad3c\u0300;acens\u11ed\u356c\u3572\u3579\u357b\u3326ppro\xf8\u32faurlye\xf1\u11fe\xf1\u11f3\u0180aes\u3582\u3588\u331bppro\xf8\u331aq\xf1\u3317g;\u666a\u0680123;Edehlmnps\u35a9\u35ac\u35af\u121c\u35b2\u35b4\u35c0\u35c9\u35d5\u35da\u35df\u35e8\u35ed\u803b\xb9\u40b9\u803b\xb2\u40b2\u803b\xb3\u40b3;\u6ac6\u0100os\u35b9\u35bct;\u6abeub;\u6ad8\u0100;d\u1222\u35c5ot;\u6ac4s\u0100ou\u35cf\u35d2l;\u67c9b;\u6ad7arr;\u697bult;\u6ac2\u0100Ee\u35e4\u35e6;\u6acc;\u628blus;\u6ac0\u0180eiu\u35f4\u3609\u360ct\u0180;en\u121c\u35fc\u3602q\u0100;q\u1222\u35b2eq\u0100;q\u35e7\u35e4m;\u6ac8\u0100bp\u3611\u3613;\u6ad4;\u6ad6\u0180Aan\u361c\u3620\u362drr;\u61d9r\u0100hr\u3626\u3628\xeb\u222e\u0100;o\u0a2b\u0a29war;\u692alig\u803b\xdf\u40df\u0be1\u3651\u365d\u3660\u12ce\u3673\u3679\0\u367e\u36c2\0\0\0\0\0\u36db\u3703\0\u3709\u376c\0\0\0\u3787\u0272\u3656\0\0\u365bget;\u6316;\u43c4r\xeb\u0e5f\u0180aey\u3666\u366b\u3670ron;\u4165dil;\u4163;\u4442lrec;\u6315r;\uc000\ud835\udd31\u0200eiko\u3686\u369d\u36b5\u36bc\u01f2\u368b\0\u3691e\u01004f\u1284\u1281a\u0180;sv\u3698\u3699\u369b\u43b8ym;\u43d1\u0100cn\u36a2\u36b2k\u0100as\u36a8\u36aeppro\xf8\u12c1im\xbb\u12acs\xf0\u129e\u0100as\u36ba\u36ae\xf0\u12c1rn\u803b\xfe\u40fe\u01ec\u031f\u36c6\u22e7es\u8180\xd7;bd\u36cf\u36d0\u36d8\u40d7\u0100;a\u190f\u36d5r;\u6a31;\u6a30\u0180eps\u36e1\u36e3\u3700\xe1\u2a4d\u0200;bcf\u0486\u36ec\u36f0\u36f4ot;\u6336ir;\u6af1\u0100;o\u36f9\u36fc\uc000\ud835\udd65rk;\u6ada\xe1\u3362rime;\u6034\u0180aip\u370f\u3712\u3764d\xe5\u1248\u0380adempst\u3721\u374d\u3740\u3751\u3757\u375c\u375fngle\u0280;dlqr\u3730\u3731\u3736\u3740\u3742\u65b5own\xbb\u1dbbeft\u0100;e\u2800\u373e\xf1\u092e;\u625cight\u0100;e\u32aa\u374b\xf1\u105aot;\u65ecinus;\u6a3alus;\u6a39b;\u69cdime;\u6a3bezium;\u63e2\u0180cht\u3772\u377d\u3781\u0100ry\u3777\u377b;\uc000\ud835\udcc9;\u4446cy;\u445brok;\u4167\u0100io\u378b\u378ex\xf4\u1777head\u0100lr\u3797\u37a0eftarro\xf7\u084fightarrow\xbb\u0f5d\u0900AHabcdfghlmoprstuw\u37d0\u37d3\u37d7\u37e4\u37f0\u37fc\u380e\u381c\u3823\u3834\u3851\u385d\u386b\u38a9\u38cc\u38d2\u38ea\u38f6r\xf2\u03edar;\u6963\u0100cr\u37dc\u37e2ute\u803b\xfa\u40fa\xf2\u1150r\u01e3\u37ea\0\u37edy;\u445eve;\u416d\u0100iy\u37f5\u37farc\u803b\xfb\u40fb;\u4443\u0180abh\u3803\u3806\u380br\xf2\u13adlac;\u4171a\xf2\u13c3\u0100ir\u3813\u3818sht;\u697e;\uc000\ud835\udd32rave\u803b\xf9\u40f9\u0161\u3827\u3831r\u0100lr\u382c\u382e\xbb\u0957\xbb\u1083lk;\u6580\u0100ct\u3839\u384d\u026f\u383f\0\0\u384arn\u0100;e\u3845\u3846\u631cr\xbb\u3846op;\u630fri;\u65f8\u0100al\u3856\u385acr;\u416b\u80bb\xa8\u0349\u0100gp\u3862\u3866on;\u4173f;\uc000\ud835\udd66\u0300adhlsu\u114b\u3878\u387d\u1372\u3891\u38a0own\xe1\u13b3arpoon\u0100lr\u3888\u388cef\xf4\u382digh\xf4\u382fi\u0180;hl\u3899\u389a\u389c\u43c5\xbb\u13faon\xbb\u389aparrows;\u61c8\u0180cit\u38b0\u38c4\u38c8\u026f\u38b6\0\0\u38c1rn\u0100;e\u38bc\u38bd\u631dr\xbb\u38bdop;\u630eng;\u416fri;\u65f9cr;\uc000\ud835\udcca\u0180dir\u38d9\u38dd\u38e2ot;\u62f0lde;\u4169i\u0100;f\u3730\u38e8\xbb\u1813\u0100am\u38ef\u38f2r\xf2\u38a8l\u803b\xfc\u40fcangle;\u69a7\u0780ABDacdeflnoprsz\u391c\u391f\u3929\u392d\u39b5\u39b8\u39bd\u39df\u39e4\u39e8\u39f3\u39f9\u39fd\u3a01\u3a20r\xf2\u03f7ar\u0100;v\u3926\u3927\u6ae8;\u6ae9as\xe8\u03e1\u0100nr\u3932\u3937grt;\u699c\u0380eknprst\u34e3\u3946\u394b\u3952\u395d\u3964\u3996app\xe1\u2415othin\xe7\u1e96\u0180hir\u34eb\u2ec8\u3959op\xf4\u2fb5\u0100;h\u13b7\u3962\xef\u318d\u0100iu\u3969\u396dgm\xe1\u33b3\u0100bp\u3972\u3984setneq\u0100;q\u397d\u3980\uc000\u228a\ufe00;\uc000\u2acb\ufe00setneq\u0100;q\u398f\u3992\uc000\u228b\ufe00;\uc000\u2acc\ufe00\u0100hr\u399b\u399fet\xe1\u369ciangle\u0100lr\u39aa\u39afeft\xbb\u0925ight\xbb\u1051y;\u4432ash\xbb\u1036\u0180elr\u39c4\u39d2\u39d7\u0180;be\u2dea\u39cb\u39cfar;\u62bbq;\u625alip;\u62ee\u0100bt\u39dc\u1468a\xf2\u1469r;\uc000\ud835\udd33tr\xe9\u39aesu\u0100bp\u39ef\u39f1\xbb\u0d1c\xbb\u0d59pf;\uc000\ud835\udd67ro\xf0\u0efbtr\xe9\u39b4\u0100cu\u3a06\u3a0br;\uc000\ud835\udccb\u0100bp\u3a10\u3a18n\u0100Ee\u3980\u3a16\xbb\u397en\u0100Ee\u3992\u3a1e\xbb\u3990igzag;\u699a\u0380cefoprs\u3a36\u3a3b\u3a56\u3a5b\u3a54\u3a61\u3a6airc;\u4175\u0100di\u3a40\u3a51\u0100bg\u3a45\u3a49ar;\u6a5fe\u0100;q\u15fa\u3a4f;\u6259erp;\u6118r;\uc000\ud835\udd34pf;\uc000\ud835\udd68\u0100;e\u1479\u3a66at\xe8\u1479cr;\uc000\ud835\udccc\u0ae3\u178e\u3a87\0\u3a8b\0\u3a90\u3a9b\0\0\u3a9d\u3aa8\u3aab\u3aaf\0\0\u3ac3\u3ace\0\u3ad8\u17dc\u17dftr\xe9\u17d1r;\uc000\ud835\udd35\u0100Aa\u3a94\u3a97r\xf2\u03c3r\xf2\u09f6;\u43be\u0100Aa\u3aa1\u3aa4r\xf2\u03b8r\xf2\u09eba\xf0\u2713is;\u62fb\u0180dpt\u17a4\u3ab5\u3abe\u0100fl\u3aba\u17a9;\uc000\ud835\udd69im\xe5\u17b2\u0100Aa\u3ac7\u3acar\xf2\u03cer\xf2\u0a01\u0100cq\u3ad2\u17b8r;\uc000\ud835\udccd\u0100pt\u17d6\u3adcr\xe9\u17d4\u0400acefiosu\u3af0\u3afd\u3b08\u3b0c\u3b11\u3b15\u3b1b\u3b21c\u0100uy\u3af6\u3afbte\u803b\xfd\u40fd;\u444f\u0100iy\u3b02\u3b06rc;\u4177;\u444bn\u803b\xa5\u40a5r;\uc000\ud835\udd36cy;\u4457pf;\uc000\ud835\udd6acr;\uc000\ud835\udcce\u0100cm\u3b26\u3b29y;\u444el\u803b\xff\u40ff\u0500acdefhiosw\u3b42\u3b48\u3b54\u3b58\u3b64\u3b69\u3b6d\u3b74\u3b7a\u3b80cute;\u417a\u0100ay\u3b4d\u3b52ron;\u417e;\u4437ot;\u417c\u0100et\u3b5d\u3b61tr\xe6\u155fa;\u43b6r;\uc000\ud835\udd37cy;\u4436grarr;\u61ddpf;\uc000\ud835\udd6bcr;\uc000\ud835\udccf\u0100jn\u3b85\u3b87;\u600dj;\u600c".split("").map(function (c) {
  return c.charCodeAt(0);
}));

/***/ }),

/***/ "../../../node_modules/entities/lib/generated/decode-data-xml.js":
/*!***********************************************************************!*\
  !*** ../../../node_modules/entities/lib/generated/decode-data-xml.js ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, exports) {



// Generated using scripts/write-decode-map.ts
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = new Uint16Array(
// prettier-ignore
"\u0200aglq\t\x15\x18\x1b\u026d\x0f\0\0\x12p;\u4026os;\u4027t;\u403et;\u403cuot;\u4022".split("").map(function (c) {
  return c.charCodeAt(0);
}));

/***/ }),

/***/ "../../../node_modules/entities/lib/generated/encode-html.js":
/*!*******************************************************************!*\
  !*** ../../../node_modules/entities/lib/generated/encode-html.js ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports) {



// Generated using scripts/write-encode-map.ts
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
function restoreDiff(arr) {
  for (var i = 1; i < arr.length; i++) {
    arr[i][0] += arr[i - 1][0] + 1;
  }
  return arr;
}
// prettier-ignore
exports["default"] = new Map( /* #__PURE__ */restoreDiff([[9, "&Tab;"], [0, "&NewLine;"], [22, "&excl;"], [0, "&quot;"], [0, "&num;"], [0, "&dollar;"], [0, "&percnt;"], [0, "&amp;"], [0, "&apos;"], [0, "&lpar;"], [0, "&rpar;"], [0, "&ast;"], [0, "&plus;"], [0, "&comma;"], [1, "&period;"], [0, "&sol;"], [10, "&colon;"], [0, "&semi;"], [0, {
  v: "&lt;",
  n: 8402,
  o: "&nvlt;"
}], [0, {
  v: "&equals;",
  n: 8421,
  o: "&bne;"
}], [0, {
  v: "&gt;",
  n: 8402,
  o: "&nvgt;"
}], [0, "&quest;"], [0, "&commat;"], [26, "&lbrack;"], [0, "&bsol;"], [0, "&rbrack;"], [0, "&Hat;"], [0, "&lowbar;"], [0, "&DiacriticalGrave;"], [5, {
  n: 106,
  o: "&fjlig;"
}], [20, "&lbrace;"], [0, "&verbar;"], [0, "&rbrace;"], [34, "&nbsp;"], [0, "&iexcl;"], [0, "&cent;"], [0, "&pound;"], [0, "&curren;"], [0, "&yen;"], [0, "&brvbar;"], [0, "&sect;"], [0, "&die;"], [0, "&copy;"], [0, "&ordf;"], [0, "&laquo;"], [0, "&not;"], [0, "&shy;"], [0, "&circledR;"], [0, "&macr;"], [0, "&deg;"], [0, "&PlusMinus;"], [0, "&sup2;"], [0, "&sup3;"], [0, "&acute;"], [0, "&micro;"], [0, "&para;"], [0, "&centerdot;"], [0, "&cedil;"], [0, "&sup1;"], [0, "&ordm;"], [0, "&raquo;"], [0, "&frac14;"], [0, "&frac12;"], [0, "&frac34;"], [0, "&iquest;"], [0, "&Agrave;"], [0, "&Aacute;"], [0, "&Acirc;"], [0, "&Atilde;"], [0, "&Auml;"], [0, "&angst;"], [0, "&AElig;"], [0, "&Ccedil;"], [0, "&Egrave;"], [0, "&Eacute;"], [0, "&Ecirc;"], [0, "&Euml;"], [0, "&Igrave;"], [0, "&Iacute;"], [0, "&Icirc;"], [0, "&Iuml;"], [0, "&ETH;"], [0, "&Ntilde;"], [0, "&Ograve;"], [0, "&Oacute;"], [0, "&Ocirc;"], [0, "&Otilde;"], [0, "&Ouml;"], [0, "&times;"], [0, "&Oslash;"], [0, "&Ugrave;"], [0, "&Uacute;"], [0, "&Ucirc;"], [0, "&Uuml;"], [0, "&Yacute;"], [0, "&THORN;"], [0, "&szlig;"], [0, "&agrave;"], [0, "&aacute;"], [0, "&acirc;"], [0, "&atilde;"], [0, "&auml;"], [0, "&aring;"], [0, "&aelig;"], [0, "&ccedil;"], [0, "&egrave;"], [0, "&eacute;"], [0, "&ecirc;"], [0, "&euml;"], [0, "&igrave;"], [0, "&iacute;"], [0, "&icirc;"], [0, "&iuml;"], [0, "&eth;"], [0, "&ntilde;"], [0, "&ograve;"], [0, "&oacute;"], [0, "&ocirc;"], [0, "&otilde;"], [0, "&ouml;"], [0, "&div;"], [0, "&oslash;"], [0, "&ugrave;"], [0, "&uacute;"], [0, "&ucirc;"], [0, "&uuml;"], [0, "&yacute;"], [0, "&thorn;"], [0, "&yuml;"], [0, "&Amacr;"], [0, "&amacr;"], [0, "&Abreve;"], [0, "&abreve;"], [0, "&Aogon;"], [0, "&aogon;"], [0, "&Cacute;"], [0, "&cacute;"], [0, "&Ccirc;"], [0, "&ccirc;"], [0, "&Cdot;"], [0, "&cdot;"], [0, "&Ccaron;"], [0, "&ccaron;"], [0, "&Dcaron;"], [0, "&dcaron;"], [0, "&Dstrok;"], [0, "&dstrok;"], [0, "&Emacr;"], [0, "&emacr;"], [2, "&Edot;"], [0, "&edot;"], [0, "&Eogon;"], [0, "&eogon;"], [0, "&Ecaron;"], [0, "&ecaron;"], [0, "&Gcirc;"], [0, "&gcirc;"], [0, "&Gbreve;"], [0, "&gbreve;"], [0, "&Gdot;"], [0, "&gdot;"], [0, "&Gcedil;"], [1, "&Hcirc;"], [0, "&hcirc;"], [0, "&Hstrok;"], [0, "&hstrok;"], [0, "&Itilde;"], [0, "&itilde;"], [0, "&Imacr;"], [0, "&imacr;"], [2, "&Iogon;"], [0, "&iogon;"], [0, "&Idot;"], [0, "&imath;"], [0, "&IJlig;"], [0, "&ijlig;"], [0, "&Jcirc;"], [0, "&jcirc;"], [0, "&Kcedil;"], [0, "&kcedil;"], [0, "&kgreen;"], [0, "&Lacute;"], [0, "&lacute;"], [0, "&Lcedil;"], [0, "&lcedil;"], [0, "&Lcaron;"], [0, "&lcaron;"], [0, "&Lmidot;"], [0, "&lmidot;"], [0, "&Lstrok;"], [0, "&lstrok;"], [0, "&Nacute;"], [0, "&nacute;"], [0, "&Ncedil;"], [0, "&ncedil;"], [0, "&Ncaron;"], [0, "&ncaron;"], [0, "&napos;"], [0, "&ENG;"], [0, "&eng;"], [0, "&Omacr;"], [0, "&omacr;"], [2, "&Odblac;"], [0, "&odblac;"], [0, "&OElig;"], [0, "&oelig;"], [0, "&Racute;"], [0, "&racute;"], [0, "&Rcedil;"], [0, "&rcedil;"], [0, "&Rcaron;"], [0, "&rcaron;"], [0, "&Sacute;"], [0, "&sacute;"], [0, "&Scirc;"], [0, "&scirc;"], [0, "&Scedil;"], [0, "&scedil;"], [0, "&Scaron;"], [0, "&scaron;"], [0, "&Tcedil;"], [0, "&tcedil;"], [0, "&Tcaron;"], [0, "&tcaron;"], [0, "&Tstrok;"], [0, "&tstrok;"], [0, "&Utilde;"], [0, "&utilde;"], [0, "&Umacr;"], [0, "&umacr;"], [0, "&Ubreve;"], [0, "&ubreve;"], [0, "&Uring;"], [0, "&uring;"], [0, "&Udblac;"], [0, "&udblac;"], [0, "&Uogon;"], [0, "&uogon;"], [0, "&Wcirc;"], [0, "&wcirc;"], [0, "&Ycirc;"], [0, "&ycirc;"], [0, "&Yuml;"], [0, "&Zacute;"], [0, "&zacute;"], [0, "&Zdot;"], [0, "&zdot;"], [0, "&Zcaron;"], [0, "&zcaron;"], [19, "&fnof;"], [34, "&imped;"], [63, "&gacute;"], [65, "&jmath;"], [142, "&circ;"], [0, "&caron;"], [16, "&breve;"], [0, "&DiacriticalDot;"], [0, "&ring;"], [0, "&ogon;"], [0, "&DiacriticalTilde;"], [0, "&dblac;"], [51, "&DownBreve;"], [127, "&Alpha;"], [0, "&Beta;"], [0, "&Gamma;"], [0, "&Delta;"], [0, "&Epsilon;"], [0, "&Zeta;"], [0, "&Eta;"], [0, "&Theta;"], [0, "&Iota;"], [0, "&Kappa;"], [0, "&Lambda;"], [0, "&Mu;"], [0, "&Nu;"], [0, "&Xi;"], [0, "&Omicron;"], [0, "&Pi;"], [0, "&Rho;"], [1, "&Sigma;"], [0, "&Tau;"], [0, "&Upsilon;"], [0, "&Phi;"], [0, "&Chi;"], [0, "&Psi;"], [0, "&ohm;"], [7, "&alpha;"], [0, "&beta;"], [0, "&gamma;"], [0, "&delta;"], [0, "&epsi;"], [0, "&zeta;"], [0, "&eta;"], [0, "&theta;"], [0, "&iota;"], [0, "&kappa;"], [0, "&lambda;"], [0, "&mu;"], [0, "&nu;"], [0, "&xi;"], [0, "&omicron;"], [0, "&pi;"], [0, "&rho;"], [0, "&sigmaf;"], [0, "&sigma;"], [0, "&tau;"], [0, "&upsi;"], [0, "&phi;"], [0, "&chi;"], [0, "&psi;"], [0, "&omega;"], [7, "&thetasym;"], [0, "&Upsi;"], [2, "&phiv;"], [0, "&piv;"], [5, "&Gammad;"], [0, "&digamma;"], [18, "&kappav;"], [0, "&rhov;"], [3, "&epsiv;"], [0, "&backepsilon;"], [10, "&IOcy;"], [0, "&DJcy;"], [0, "&GJcy;"], [0, "&Jukcy;"], [0, "&DScy;"], [0, "&Iukcy;"], [0, "&YIcy;"], [0, "&Jsercy;"], [0, "&LJcy;"], [0, "&NJcy;"], [0, "&TSHcy;"], [0, "&KJcy;"], [1, "&Ubrcy;"], [0, "&DZcy;"], [0, "&Acy;"], [0, "&Bcy;"], [0, "&Vcy;"], [0, "&Gcy;"], [0, "&Dcy;"], [0, "&IEcy;"], [0, "&ZHcy;"], [0, "&Zcy;"], [0, "&Icy;"], [0, "&Jcy;"], [0, "&Kcy;"], [0, "&Lcy;"], [0, "&Mcy;"], [0, "&Ncy;"], [0, "&Ocy;"], [0, "&Pcy;"], [0, "&Rcy;"], [0, "&Scy;"], [0, "&Tcy;"], [0, "&Ucy;"], [0, "&Fcy;"], [0, "&KHcy;"], [0, "&TScy;"], [0, "&CHcy;"], [0, "&SHcy;"], [0, "&SHCHcy;"], [0, "&HARDcy;"], [0, "&Ycy;"], [0, "&SOFTcy;"], [0, "&Ecy;"], [0, "&YUcy;"], [0, "&YAcy;"], [0, "&acy;"], [0, "&bcy;"], [0, "&vcy;"], [0, "&gcy;"], [0, "&dcy;"], [0, "&iecy;"], [0, "&zhcy;"], [0, "&zcy;"], [0, "&icy;"], [0, "&jcy;"], [0, "&kcy;"], [0, "&lcy;"], [0, "&mcy;"], [0, "&ncy;"], [0, "&ocy;"], [0, "&pcy;"], [0, "&rcy;"], [0, "&scy;"], [0, "&tcy;"], [0, "&ucy;"], [0, "&fcy;"], [0, "&khcy;"], [0, "&tscy;"], [0, "&chcy;"], [0, "&shcy;"], [0, "&shchcy;"], [0, "&hardcy;"], [0, "&ycy;"], [0, "&softcy;"], [0, "&ecy;"], [0, "&yucy;"], [0, "&yacy;"], [1, "&iocy;"], [0, "&djcy;"], [0, "&gjcy;"], [0, "&jukcy;"], [0, "&dscy;"], [0, "&iukcy;"], [0, "&yicy;"], [0, "&jsercy;"], [0, "&ljcy;"], [0, "&njcy;"], [0, "&tshcy;"], [0, "&kjcy;"], [1, "&ubrcy;"], [0, "&dzcy;"], [7074, "&ensp;"], [0, "&emsp;"], [0, "&emsp13;"], [0, "&emsp14;"], [1, "&numsp;"], [0, "&puncsp;"], [0, "&ThinSpace;"], [0, "&hairsp;"], [0, "&NegativeMediumSpace;"], [0, "&zwnj;"], [0, "&zwj;"], [0, "&lrm;"], [0, "&rlm;"], [0, "&dash;"], [2, "&ndash;"], [0, "&mdash;"], [0, "&horbar;"], [0, "&Verbar;"], [1, "&lsquo;"], [0, "&CloseCurlyQuote;"], [0, "&lsquor;"], [1, "&ldquo;"], [0, "&CloseCurlyDoubleQuote;"], [0, "&bdquo;"], [1, "&dagger;"], [0, "&Dagger;"], [0, "&bull;"], [2, "&nldr;"], [0, "&hellip;"], [9, "&permil;"], [0, "&pertenk;"], [0, "&prime;"], [0, "&Prime;"], [0, "&tprime;"], [0, "&backprime;"], [3, "&lsaquo;"], [0, "&rsaquo;"], [3, "&oline;"], [2, "&caret;"], [1, "&hybull;"], [0, "&frasl;"], [10, "&bsemi;"], [7, "&qprime;"], [7, {
  v: "&MediumSpace;",
  n: 8202,
  o: "&ThickSpace;"
}], [0, "&NoBreak;"], [0, "&af;"], [0, "&InvisibleTimes;"], [0, "&ic;"], [72, "&euro;"], [46, "&tdot;"], [0, "&DotDot;"], [37, "&complexes;"], [2, "&incare;"], [4, "&gscr;"], [0, "&hamilt;"], [0, "&Hfr;"], [0, "&Hopf;"], [0, "&planckh;"], [0, "&hbar;"], [0, "&imagline;"], [0, "&Ifr;"], [0, "&lagran;"], [0, "&ell;"], [1, "&naturals;"], [0, "&numero;"], [0, "&copysr;"], [0, "&weierp;"], [0, "&Popf;"], [0, "&Qopf;"], [0, "&realine;"], [0, "&real;"], [0, "&reals;"], [0, "&rx;"], [3, "&trade;"], [1, "&integers;"], [2, "&mho;"], [0, "&zeetrf;"], [0, "&iiota;"], [2, "&bernou;"], [0, "&Cayleys;"], [1, "&escr;"], [0, "&Escr;"], [0, "&Fouriertrf;"], [1, "&Mellintrf;"], [0, "&order;"], [0, "&alefsym;"], [0, "&beth;"], [0, "&gimel;"], [0, "&daleth;"], [12, "&CapitalDifferentialD;"], [0, "&dd;"], [0, "&ee;"], [0, "&ii;"], [10, "&frac13;"], [0, "&frac23;"], [0, "&frac15;"], [0, "&frac25;"], [0, "&frac35;"], [0, "&frac45;"], [0, "&frac16;"], [0, "&frac56;"], [0, "&frac18;"], [0, "&frac38;"], [0, "&frac58;"], [0, "&frac78;"], [49, "&larr;"], [0, "&ShortUpArrow;"], [0, "&rarr;"], [0, "&darr;"], [0, "&harr;"], [0, "&updownarrow;"], [0, "&nwarr;"], [0, "&nearr;"], [0, "&LowerRightArrow;"], [0, "&LowerLeftArrow;"], [0, "&nlarr;"], [0, "&nrarr;"], [1, {
  v: "&rarrw;",
  n: 824,
  o: "&nrarrw;"
}], [0, "&Larr;"], [0, "&Uarr;"], [0, "&Rarr;"], [0, "&Darr;"], [0, "&larrtl;"], [0, "&rarrtl;"], [0, "&LeftTeeArrow;"], [0, "&mapstoup;"], [0, "&map;"], [0, "&DownTeeArrow;"], [1, "&hookleftarrow;"], [0, "&hookrightarrow;"], [0, "&larrlp;"], [0, "&looparrowright;"], [0, "&harrw;"], [0, "&nharr;"], [1, "&lsh;"], [0, "&rsh;"], [0, "&ldsh;"], [0, "&rdsh;"], [1, "&crarr;"], [0, "&cularr;"], [0, "&curarr;"], [2, "&circlearrowleft;"], [0, "&circlearrowright;"], [0, "&leftharpoonup;"], [0, "&DownLeftVector;"], [0, "&RightUpVector;"], [0, "&LeftUpVector;"], [0, "&rharu;"], [0, "&DownRightVector;"], [0, "&dharr;"], [0, "&dharl;"], [0, "&RightArrowLeftArrow;"], [0, "&udarr;"], [0, "&LeftArrowRightArrow;"], [0, "&leftleftarrows;"], [0, "&upuparrows;"], [0, "&rightrightarrows;"], [0, "&ddarr;"], [0, "&leftrightharpoons;"], [0, "&Equilibrium;"], [0, "&nlArr;"], [0, "&nhArr;"], [0, "&nrArr;"], [0, "&DoubleLeftArrow;"], [0, "&DoubleUpArrow;"], [0, "&DoubleRightArrow;"], [0, "&dArr;"], [0, "&DoubleLeftRightArrow;"], [0, "&DoubleUpDownArrow;"], [0, "&nwArr;"], [0, "&neArr;"], [0, "&seArr;"], [0, "&swArr;"], [0, "&lAarr;"], [0, "&rAarr;"], [1, "&zigrarr;"], [6, "&larrb;"], [0, "&rarrb;"], [15, "&DownArrowUpArrow;"], [7, "&loarr;"], [0, "&roarr;"], [0, "&hoarr;"], [0, "&forall;"], [0, "&comp;"], [0, {
  v: "&part;",
  n: 824,
  o: "&npart;"
}], [0, "&exist;"], [0, "&nexist;"], [0, "&empty;"], [1, "&Del;"], [0, "&Element;"], [0, "&NotElement;"], [1, "&ni;"], [0, "&notni;"], [2, "&prod;"], [0, "&coprod;"], [0, "&sum;"], [0, "&minus;"], [0, "&MinusPlus;"], [0, "&dotplus;"], [1, "&Backslash;"], [0, "&lowast;"], [0, "&compfn;"], [1, "&radic;"], [2, "&prop;"], [0, "&infin;"], [0, "&angrt;"], [0, {
  v: "&ang;",
  n: 8402,
  o: "&nang;"
}], [0, "&angmsd;"], [0, "&angsph;"], [0, "&mid;"], [0, "&nmid;"], [0, "&DoubleVerticalBar;"], [0, "&NotDoubleVerticalBar;"], [0, "&and;"], [0, "&or;"], [0, {
  v: "&cap;",
  n: 65024,
  o: "&caps;"
}], [0, {
  v: "&cup;",
  n: 65024,
  o: "&cups;"
}], [0, "&int;"], [0, "&Int;"], [0, "&iiint;"], [0, "&conint;"], [0, "&Conint;"], [0, "&Cconint;"], [0, "&cwint;"], [0, "&ClockwiseContourIntegral;"], [0, "&awconint;"], [0, "&there4;"], [0, "&becaus;"], [0, "&ratio;"], [0, "&Colon;"], [0, "&dotminus;"], [1, "&mDDot;"], [0, "&homtht;"], [0, {
  v: "&sim;",
  n: 8402,
  o: "&nvsim;"
}], [0, {
  v: "&backsim;",
  n: 817,
  o: "&race;"
}], [0, {
  v: "&ac;",
  n: 819,
  o: "&acE;"
}], [0, "&acd;"], [0, "&VerticalTilde;"], [0, "&NotTilde;"], [0, {
  v: "&eqsim;",
  n: 824,
  o: "&nesim;"
}], [0, "&sime;"], [0, "&NotTildeEqual;"], [0, "&cong;"], [0, "&simne;"], [0, "&ncong;"], [0, "&ap;"], [0, "&nap;"], [0, "&ape;"], [0, {
  v: "&apid;",
  n: 824,
  o: "&napid;"
}], [0, "&backcong;"], [0, {
  v: "&asympeq;",
  n: 8402,
  o: "&nvap;"
}], [0, {
  v: "&bump;",
  n: 824,
  o: "&nbump;"
}], [0, {
  v: "&bumpe;",
  n: 824,
  o: "&nbumpe;"
}], [0, {
  v: "&doteq;",
  n: 824,
  o: "&nedot;"
}], [0, "&doteqdot;"], [0, "&efDot;"], [0, "&erDot;"], [0, "&Assign;"], [0, "&ecolon;"], [0, "&ecir;"], [0, "&circeq;"], [1, "&wedgeq;"], [0, "&veeeq;"], [1, "&triangleq;"], [2, "&equest;"], [0, "&ne;"], [0, {
  v: "&Congruent;",
  n: 8421,
  o: "&bnequiv;"
}], [0, "&nequiv;"], [1, {
  v: "&le;",
  n: 8402,
  o: "&nvle;"
}], [0, {
  v: "&ge;",
  n: 8402,
  o: "&nvge;"
}], [0, {
  v: "&lE;",
  n: 824,
  o: "&nlE;"
}], [0, {
  v: "&gE;",
  n: 824,
  o: "&ngE;"
}], [0, {
  v: "&lnE;",
  n: 65024,
  o: "&lvertneqq;"
}], [0, {
  v: "&gnE;",
  n: 65024,
  o: "&gvertneqq;"
}], [0, {
  v: "&ll;",
  n: new Map( /* #__PURE__ */restoreDiff([[824, "&nLtv;"], [7577, "&nLt;"]]))
}], [0, {
  v: "&gg;",
  n: new Map( /* #__PURE__ */restoreDiff([[824, "&nGtv;"], [7577, "&nGt;"]]))
}], [0, "&between;"], [0, "&NotCupCap;"], [0, "&nless;"], [0, "&ngt;"], [0, "&nle;"], [0, "&nge;"], [0, "&lesssim;"], [0, "&GreaterTilde;"], [0, "&nlsim;"], [0, "&ngsim;"], [0, "&LessGreater;"], [0, "&gl;"], [0, "&NotLessGreater;"], [0, "&NotGreaterLess;"], [0, "&pr;"], [0, "&sc;"], [0, "&prcue;"], [0, "&sccue;"], [0, "&PrecedesTilde;"], [0, {
  v: "&scsim;",
  n: 824,
  o: "&NotSucceedsTilde;"
}], [0, "&NotPrecedes;"], [0, "&NotSucceeds;"], [0, {
  v: "&sub;",
  n: 8402,
  o: "&NotSubset;"
}], [0, {
  v: "&sup;",
  n: 8402,
  o: "&NotSuperset;"
}], [0, "&nsub;"], [0, "&nsup;"], [0, "&sube;"], [0, "&supe;"], [0, "&NotSubsetEqual;"], [0, "&NotSupersetEqual;"], [0, {
  v: "&subne;",
  n: 65024,
  o: "&varsubsetneq;"
}], [0, {
  v: "&supne;",
  n: 65024,
  o: "&varsupsetneq;"
}], [1, "&cupdot;"], [0, "&UnionPlus;"], [0, {
  v: "&sqsub;",
  n: 824,
  o: "&NotSquareSubset;"
}], [0, {
  v: "&sqsup;",
  n: 824,
  o: "&NotSquareSuperset;"
}], [0, "&sqsube;"], [0, "&sqsupe;"], [0, {
  v: "&sqcap;",
  n: 65024,
  o: "&sqcaps;"
}], [0, {
  v: "&sqcup;",
  n: 65024,
  o: "&sqcups;"
}], [0, "&CirclePlus;"], [0, "&CircleMinus;"], [0, "&CircleTimes;"], [0, "&osol;"], [0, "&CircleDot;"], [0, "&circledcirc;"], [0, "&circledast;"], [1, "&circleddash;"], [0, "&boxplus;"], [0, "&boxminus;"], [0, "&boxtimes;"], [0, "&dotsquare;"], [0, "&RightTee;"], [0, "&dashv;"], [0, "&DownTee;"], [0, "&bot;"], [1, "&models;"], [0, "&DoubleRightTee;"], [0, "&Vdash;"], [0, "&Vvdash;"], [0, "&VDash;"], [0, "&nvdash;"], [0, "&nvDash;"], [0, "&nVdash;"], [0, "&nVDash;"], [0, "&prurel;"], [1, "&LeftTriangle;"], [0, "&RightTriangle;"], [0, {
  v: "&LeftTriangleEqual;",
  n: 8402,
  o: "&nvltrie;"
}], [0, {
  v: "&RightTriangleEqual;",
  n: 8402,
  o: "&nvrtrie;"
}], [0, "&origof;"], [0, "&imof;"], [0, "&multimap;"], [0, "&hercon;"], [0, "&intcal;"], [0, "&veebar;"], [1, "&barvee;"], [0, "&angrtvb;"], [0, "&lrtri;"], [0, "&bigwedge;"], [0, "&bigvee;"], [0, "&bigcap;"], [0, "&bigcup;"], [0, "&diam;"], [0, "&sdot;"], [0, "&sstarf;"], [0, "&divideontimes;"], [0, "&bowtie;"], [0, "&ltimes;"], [0, "&rtimes;"], [0, "&leftthreetimes;"], [0, "&rightthreetimes;"], [0, "&backsimeq;"], [0, "&curlyvee;"], [0, "&curlywedge;"], [0, "&Sub;"], [0, "&Sup;"], [0, "&Cap;"], [0, "&Cup;"], [0, "&fork;"], [0, "&epar;"], [0, "&lessdot;"], [0, "&gtdot;"], [0, {
  v: "&Ll;",
  n: 824,
  o: "&nLl;"
}], [0, {
  v: "&Gg;",
  n: 824,
  o: "&nGg;"
}], [0, {
  v: "&leg;",
  n: 65024,
  o: "&lesg;"
}], [0, {
  v: "&gel;",
  n: 65024,
  o: "&gesl;"
}], [2, "&cuepr;"], [0, "&cuesc;"], [0, "&NotPrecedesSlantEqual;"], [0, "&NotSucceedsSlantEqual;"], [0, "&NotSquareSubsetEqual;"], [0, "&NotSquareSupersetEqual;"], [2, "&lnsim;"], [0, "&gnsim;"], [0, "&precnsim;"], [0, "&scnsim;"], [0, "&nltri;"], [0, "&NotRightTriangle;"], [0, "&nltrie;"], [0, "&NotRightTriangleEqual;"], [0, "&vellip;"], [0, "&ctdot;"], [0, "&utdot;"], [0, "&dtdot;"], [0, "&disin;"], [0, "&isinsv;"], [0, "&isins;"], [0, {
  v: "&isindot;",
  n: 824,
  o: "&notindot;"
}], [0, "&notinvc;"], [0, "&notinvb;"], [1, {
  v: "&isinE;",
  n: 824,
  o: "&notinE;"
}], [0, "&nisd;"], [0, "&xnis;"], [0, "&nis;"], [0, "&notnivc;"], [0, "&notnivb;"], [6, "&barwed;"], [0, "&Barwed;"], [1, "&lceil;"], [0, "&rceil;"], [0, "&LeftFloor;"], [0, "&rfloor;"], [0, "&drcrop;"], [0, "&dlcrop;"], [0, "&urcrop;"], [0, "&ulcrop;"], [0, "&bnot;"], [1, "&profline;"], [0, "&profsurf;"], [1, "&telrec;"], [0, "&target;"], [5, "&ulcorn;"], [0, "&urcorn;"], [0, "&dlcorn;"], [0, "&drcorn;"], [2, "&frown;"], [0, "&smile;"], [9, "&cylcty;"], [0, "&profalar;"], [7, "&topbot;"], [6, "&ovbar;"], [1, "&solbar;"], [60, "&angzarr;"], [51, "&lmoustache;"], [0, "&rmoustache;"], [2, "&OverBracket;"], [0, "&bbrk;"], [0, "&bbrktbrk;"], [37, "&OverParenthesis;"], [0, "&UnderParenthesis;"], [0, "&OverBrace;"], [0, "&UnderBrace;"], [2, "&trpezium;"], [4, "&elinters;"], [59, "&blank;"], [164, "&circledS;"], [55, "&boxh;"], [1, "&boxv;"], [9, "&boxdr;"], [3, "&boxdl;"], [3, "&boxur;"], [3, "&boxul;"], [3, "&boxvr;"], [7, "&boxvl;"], [7, "&boxhd;"], [7, "&boxhu;"], [7, "&boxvh;"], [19, "&boxH;"], [0, "&boxV;"], [0, "&boxdR;"], [0, "&boxDr;"], [0, "&boxDR;"], [0, "&boxdL;"], [0, "&boxDl;"], [0, "&boxDL;"], [0, "&boxuR;"], [0, "&boxUr;"], [0, "&boxUR;"], [0, "&boxuL;"], [0, "&boxUl;"], [0, "&boxUL;"], [0, "&boxvR;"], [0, "&boxVr;"], [0, "&boxVR;"], [0, "&boxvL;"], [0, "&boxVl;"], [0, "&boxVL;"], [0, "&boxHd;"], [0, "&boxhD;"], [0, "&boxHD;"], [0, "&boxHu;"], [0, "&boxhU;"], [0, "&boxHU;"], [0, "&boxvH;"], [0, "&boxVh;"], [0, "&boxVH;"], [19, "&uhblk;"], [3, "&lhblk;"], [3, "&block;"], [8, "&blk14;"], [0, "&blk12;"], [0, "&blk34;"], [13, "&square;"], [8, "&blacksquare;"], [0, "&EmptyVerySmallSquare;"], [1, "&rect;"], [0, "&marker;"], [2, "&fltns;"], [1, "&bigtriangleup;"], [0, "&blacktriangle;"], [0, "&triangle;"], [2, "&blacktriangleright;"], [0, "&rtri;"], [3, "&bigtriangledown;"], [0, "&blacktriangledown;"], [0, "&dtri;"], [2, "&blacktriangleleft;"], [0, "&ltri;"], [6, "&loz;"], [0, "&cir;"], [32, "&tridot;"], [2, "&bigcirc;"], [8, "&ultri;"], [0, "&urtri;"], [0, "&lltri;"], [0, "&EmptySmallSquare;"], [0, "&FilledSmallSquare;"], [8, "&bigstar;"], [0, "&star;"], [7, "&phone;"], [49, "&female;"], [1, "&male;"], [29, "&spades;"], [2, "&clubs;"], [1, "&hearts;"], [0, "&diamondsuit;"], [3, "&sung;"], [2, "&flat;"], [0, "&natural;"], [0, "&sharp;"], [163, "&check;"], [3, "&cross;"], [8, "&malt;"], [21, "&sext;"], [33, "&VerticalSeparator;"], [25, "&lbbrk;"], [0, "&rbbrk;"], [84, "&bsolhsub;"], [0, "&suphsol;"], [28, "&LeftDoubleBracket;"], [0, "&RightDoubleBracket;"], [0, "&lang;"], [0, "&rang;"], [0, "&Lang;"], [0, "&Rang;"], [0, "&loang;"], [0, "&roang;"], [7, "&longleftarrow;"], [0, "&longrightarrow;"], [0, "&longleftrightarrow;"], [0, "&DoubleLongLeftArrow;"], [0, "&DoubleLongRightArrow;"], [0, "&DoubleLongLeftRightArrow;"], [1, "&longmapsto;"], [2, "&dzigrarr;"], [258, "&nvlArr;"], [0, "&nvrArr;"], [0, "&nvHarr;"], [0, "&Map;"], [6, "&lbarr;"], [0, "&bkarow;"], [0, "&lBarr;"], [0, "&dbkarow;"], [0, "&drbkarow;"], [0, "&DDotrahd;"], [0, "&UpArrowBar;"], [0, "&DownArrowBar;"], [2, "&Rarrtl;"], [2, "&latail;"], [0, "&ratail;"], [0, "&lAtail;"], [0, "&rAtail;"], [0, "&larrfs;"], [0, "&rarrfs;"], [0, "&larrbfs;"], [0, "&rarrbfs;"], [2, "&nwarhk;"], [0, "&nearhk;"], [0, "&hksearow;"], [0, "&hkswarow;"], [0, "&nwnear;"], [0, "&nesear;"], [0, "&seswar;"], [0, "&swnwar;"], [8, {
  v: "&rarrc;",
  n: 824,
  o: "&nrarrc;"
}], [1, "&cudarrr;"], [0, "&ldca;"], [0, "&rdca;"], [0, "&cudarrl;"], [0, "&larrpl;"], [2, "&curarrm;"], [0, "&cularrp;"], [7, "&rarrpl;"], [2, "&harrcir;"], [0, "&Uarrocir;"], [0, "&lurdshar;"], [0, "&ldrushar;"], [2, "&LeftRightVector;"], [0, "&RightUpDownVector;"], [0, "&DownLeftRightVector;"], [0, "&LeftUpDownVector;"], [0, "&LeftVectorBar;"], [0, "&RightVectorBar;"], [0, "&RightUpVectorBar;"], [0, "&RightDownVectorBar;"], [0, "&DownLeftVectorBar;"], [0, "&DownRightVectorBar;"], [0, "&LeftUpVectorBar;"], [0, "&LeftDownVectorBar;"], [0, "&LeftTeeVector;"], [0, "&RightTeeVector;"], [0, "&RightUpTeeVector;"], [0, "&RightDownTeeVector;"], [0, "&DownLeftTeeVector;"], [0, "&DownRightTeeVector;"], [0, "&LeftUpTeeVector;"], [0, "&LeftDownTeeVector;"], [0, "&lHar;"], [0, "&uHar;"], [0, "&rHar;"], [0, "&dHar;"], [0, "&luruhar;"], [0, "&ldrdhar;"], [0, "&ruluhar;"], [0, "&rdldhar;"], [0, "&lharul;"], [0, "&llhard;"], [0, "&rharul;"], [0, "&lrhard;"], [0, "&udhar;"], [0, "&duhar;"], [0, "&RoundImplies;"], [0, "&erarr;"], [0, "&simrarr;"], [0, "&larrsim;"], [0, "&rarrsim;"], [0, "&rarrap;"], [0, "&ltlarr;"], [1, "&gtrarr;"], [0, "&subrarr;"], [1, "&suplarr;"], [0, "&lfisht;"], [0, "&rfisht;"], [0, "&ufisht;"], [0, "&dfisht;"], [5, "&lopar;"], [0, "&ropar;"], [4, "&lbrke;"], [0, "&rbrke;"], [0, "&lbrkslu;"], [0, "&rbrksld;"], [0, "&lbrksld;"], [0, "&rbrkslu;"], [0, "&langd;"], [0, "&rangd;"], [0, "&lparlt;"], [0, "&rpargt;"], [0, "&gtlPar;"], [0, "&ltrPar;"], [3, "&vzigzag;"], [1, "&vangrt;"], [0, "&angrtvbd;"], [6, "&ange;"], [0, "&range;"], [0, "&dwangle;"], [0, "&uwangle;"], [0, "&angmsdaa;"], [0, "&angmsdab;"], [0, "&angmsdac;"], [0, "&angmsdad;"], [0, "&angmsdae;"], [0, "&angmsdaf;"], [0, "&angmsdag;"], [0, "&angmsdah;"], [0, "&bemptyv;"], [0, "&demptyv;"], [0, "&cemptyv;"], [0, "&raemptyv;"], [0, "&laemptyv;"], [0, "&ohbar;"], [0, "&omid;"], [0, "&opar;"], [1, "&operp;"], [1, "&olcross;"], [0, "&odsold;"], [1, "&olcir;"], [0, "&ofcir;"], [0, "&olt;"], [0, "&ogt;"], [0, "&cirscir;"], [0, "&cirE;"], [0, "&solb;"], [0, "&bsolb;"], [3, "&boxbox;"], [3, "&trisb;"], [0, "&rtriltri;"], [0, {
  v: "&LeftTriangleBar;",
  n: 824,
  o: "&NotLeftTriangleBar;"
}], [0, {
  v: "&RightTriangleBar;",
  n: 824,
  o: "&NotRightTriangleBar;"
}], [11, "&iinfin;"], [0, "&infintie;"], [0, "&nvinfin;"], [4, "&eparsl;"], [0, "&smeparsl;"], [0, "&eqvparsl;"], [5, "&blacklozenge;"], [8, "&RuleDelayed;"], [1, "&dsol;"], [9, "&bigodot;"], [0, "&bigoplus;"], [0, "&bigotimes;"], [1, "&biguplus;"], [1, "&bigsqcup;"], [5, "&iiiint;"], [0, "&fpartint;"], [2, "&cirfnint;"], [0, "&awint;"], [0, "&rppolint;"], [0, "&scpolint;"], [0, "&npolint;"], [0, "&pointint;"], [0, "&quatint;"], [0, "&intlarhk;"], [10, "&pluscir;"], [0, "&plusacir;"], [0, "&simplus;"], [0, "&plusdu;"], [0, "&plussim;"], [0, "&plustwo;"], [1, "&mcomma;"], [0, "&minusdu;"], [2, "&loplus;"], [0, "&roplus;"], [0, "&Cross;"], [0, "&timesd;"], [0, "&timesbar;"], [1, "&smashp;"], [0, "&lotimes;"], [0, "&rotimes;"], [0, "&otimesas;"], [0, "&Otimes;"], [0, "&odiv;"], [0, "&triplus;"], [0, "&triminus;"], [0, "&tritime;"], [0, "&intprod;"], [2, "&amalg;"], [0, "&capdot;"], [1, "&ncup;"], [0, "&ncap;"], [0, "&capand;"], [0, "&cupor;"], [0, "&cupcap;"], [0, "&capcup;"], [0, "&cupbrcap;"], [0, "&capbrcup;"], [0, "&cupcup;"], [0, "&capcap;"], [0, "&ccups;"], [0, "&ccaps;"], [2, "&ccupssm;"], [2, "&And;"], [0, "&Or;"], [0, "&andand;"], [0, "&oror;"], [0, "&orslope;"], [0, "&andslope;"], [1, "&andv;"], [0, "&orv;"], [0, "&andd;"], [0, "&ord;"], [1, "&wedbar;"], [6, "&sdote;"], [3, "&simdot;"], [2, {
  v: "&congdot;",
  n: 824,
  o: "&ncongdot;"
}], [0, "&easter;"], [0, "&apacir;"], [0, {
  v: "&apE;",
  n: 824,
  o: "&napE;"
}], [0, "&eplus;"], [0, "&pluse;"], [0, "&Esim;"], [0, "&Colone;"], [0, "&Equal;"], [1, "&ddotseq;"], [0, "&equivDD;"], [0, "&ltcir;"], [0, "&gtcir;"], [0, "&ltquest;"], [0, "&gtquest;"], [0, {
  v: "&leqslant;",
  n: 824,
  o: "&nleqslant;"
}], [0, {
  v: "&geqslant;",
  n: 824,
  o: "&ngeqslant;"
}], [0, "&lesdot;"], [0, "&gesdot;"], [0, "&lesdoto;"], [0, "&gesdoto;"], [0, "&lesdotor;"], [0, "&gesdotol;"], [0, "&lap;"], [0, "&gap;"], [0, "&lne;"], [0, "&gne;"], [0, "&lnap;"], [0, "&gnap;"], [0, "&lEg;"], [0, "&gEl;"], [0, "&lsime;"], [0, "&gsime;"], [0, "&lsimg;"], [0, "&gsiml;"], [0, "&lgE;"], [0, "&glE;"], [0, "&lesges;"], [0, "&gesles;"], [0, "&els;"], [0, "&egs;"], [0, "&elsdot;"], [0, "&egsdot;"], [0, "&el;"], [0, "&eg;"], [2, "&siml;"], [0, "&simg;"], [0, "&simlE;"], [0, "&simgE;"], [0, {
  v: "&LessLess;",
  n: 824,
  o: "&NotNestedLessLess;"
}], [0, {
  v: "&GreaterGreater;",
  n: 824,
  o: "&NotNestedGreaterGreater;"
}], [1, "&glj;"], [0, "&gla;"], [0, "&ltcc;"], [0, "&gtcc;"], [0, "&lescc;"], [0, "&gescc;"], [0, "&smt;"], [0, "&lat;"], [0, {
  v: "&smte;",
  n: 65024,
  o: "&smtes;"
}], [0, {
  v: "&late;",
  n: 65024,
  o: "&lates;"
}], [0, "&bumpE;"], [0, {
  v: "&PrecedesEqual;",
  n: 824,
  o: "&NotPrecedesEqual;"
}], [0, {
  v: "&sce;",
  n: 824,
  o: "&NotSucceedsEqual;"
}], [2, "&prE;"], [0, "&scE;"], [0, "&precneqq;"], [0, "&scnE;"], [0, "&prap;"], [0, "&scap;"], [0, "&precnapprox;"], [0, "&scnap;"], [0, "&Pr;"], [0, "&Sc;"], [0, "&subdot;"], [0, "&supdot;"], [0, "&subplus;"], [0, "&supplus;"], [0, "&submult;"], [0, "&supmult;"], [0, "&subedot;"], [0, "&supedot;"], [0, {
  v: "&subE;",
  n: 824,
  o: "&nsubE;"
}], [0, {
  v: "&supE;",
  n: 824,
  o: "&nsupE;"
}], [0, "&subsim;"], [0, "&supsim;"], [2, {
  v: "&subnE;",
  n: 65024,
  o: "&varsubsetneqq;"
}], [0, {
  v: "&supnE;",
  n: 65024,
  o: "&varsupsetneqq;"
}], [2, "&csub;"], [0, "&csup;"], [0, "&csube;"], [0, "&csupe;"], [0, "&subsup;"], [0, "&supsub;"], [0, "&subsub;"], [0, "&supsup;"], [0, "&suphsub;"], [0, "&supdsub;"], [0, "&forkv;"], [0, "&topfork;"], [0, "&mlcp;"], [8, "&Dashv;"], [1, "&Vdashl;"], [0, "&Barv;"], [0, "&vBar;"], [0, "&vBarv;"], [1, "&Vbar;"], [0, "&Not;"], [0, "&bNot;"], [0, "&rnmid;"], [0, "&cirmid;"], [0, "&midcir;"], [0, "&topcir;"], [0, "&nhpar;"], [0, "&parsim;"], [9, {
  v: "&parsl;",
  n: 8421,
  o: "&nparsl;"
}], [44343, {
  n: new Map( /* #__PURE__ */restoreDiff([[56476, "&Ascr;"], [1, "&Cscr;"], [0, "&Dscr;"], [2, "&Gscr;"], [2, "&Jscr;"], [0, "&Kscr;"], [2, "&Nscr;"], [0, "&Oscr;"], [0, "&Pscr;"], [0, "&Qscr;"], [1, "&Sscr;"], [0, "&Tscr;"], [0, "&Uscr;"], [0, "&Vscr;"], [0, "&Wscr;"], [0, "&Xscr;"], [0, "&Yscr;"], [0, "&Zscr;"], [0, "&ascr;"], [0, "&bscr;"], [0, "&cscr;"], [0, "&dscr;"], [1, "&fscr;"], [1, "&hscr;"], [0, "&iscr;"], [0, "&jscr;"], [0, "&kscr;"], [0, "&lscr;"], [0, "&mscr;"], [0, "&nscr;"], [1, "&pscr;"], [0, "&qscr;"], [0, "&rscr;"], [0, "&sscr;"], [0, "&tscr;"], [0, "&uscr;"], [0, "&vscr;"], [0, "&wscr;"], [0, "&xscr;"], [0, "&yscr;"], [0, "&zscr;"], [52, "&Afr;"], [0, "&Bfr;"], [1, "&Dfr;"], [0, "&Efr;"], [0, "&Ffr;"], [0, "&Gfr;"], [2, "&Jfr;"], [0, "&Kfr;"], [0, "&Lfr;"], [0, "&Mfr;"], [0, "&Nfr;"], [0, "&Ofr;"], [0, "&Pfr;"], [0, "&Qfr;"], [1, "&Sfr;"], [0, "&Tfr;"], [0, "&Ufr;"], [0, "&Vfr;"], [0, "&Wfr;"], [0, "&Xfr;"], [0, "&Yfr;"], [1, "&afr;"], [0, "&bfr;"], [0, "&cfr;"], [0, "&dfr;"], [0, "&efr;"], [0, "&ffr;"], [0, "&gfr;"], [0, "&hfr;"], [0, "&ifr;"], [0, "&jfr;"], [0, "&kfr;"], [0, "&lfr;"], [0, "&mfr;"], [0, "&nfr;"], [0, "&ofr;"], [0, "&pfr;"], [0, "&qfr;"], [0, "&rfr;"], [0, "&sfr;"], [0, "&tfr;"], [0, "&ufr;"], [0, "&vfr;"], [0, "&wfr;"], [0, "&xfr;"], [0, "&yfr;"], [0, "&zfr;"], [0, "&Aopf;"], [0, "&Bopf;"], [1, "&Dopf;"], [0, "&Eopf;"], [0, "&Fopf;"], [0, "&Gopf;"], [1, "&Iopf;"], [0, "&Jopf;"], [0, "&Kopf;"], [0, "&Lopf;"], [0, "&Mopf;"], [1, "&Oopf;"], [3, "&Sopf;"], [0, "&Topf;"], [0, "&Uopf;"], [0, "&Vopf;"], [0, "&Wopf;"], [0, "&Xopf;"], [0, "&Yopf;"], [1, "&aopf;"], [0, "&bopf;"], [0, "&copf;"], [0, "&dopf;"], [0, "&eopf;"], [0, "&fopf;"], [0, "&gopf;"], [0, "&hopf;"], [0, "&iopf;"], [0, "&jopf;"], [0, "&kopf;"], [0, "&lopf;"], [0, "&mopf;"], [0, "&nopf;"], [0, "&oopf;"], [0, "&popf;"], [0, "&qopf;"], [0, "&ropf;"], [0, "&sopf;"], [0, "&topf;"], [0, "&uopf;"], [0, "&vopf;"], [0, "&wopf;"], [0, "&xopf;"], [0, "&yopf;"], [0, "&zopf;"]]))
}], [8906, "&fflig;"], [0, "&filig;"], [0, "&fllig;"], [0, "&ffilig;"], [0, "&ffllig;"]]));

/***/ }),

/***/ "../../../node_modules/entities/lib/index.js":
/*!***************************************************!*\
  !*** ../../../node_modules/entities/lib/index.js ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.decodeXMLStrict = exports.decodeHTML5Strict = exports.decodeHTML4Strict = exports.decodeHTML5 = exports.decodeHTML4 = exports.decodeHTMLAttribute = exports.decodeHTMLStrict = exports.decodeHTML = exports.decodeXML = exports.DecodingMode = exports.EntityDecoder = exports.encodeHTML5 = exports.encodeHTML4 = exports.encodeNonAsciiHTML = exports.encodeHTML = exports.escapeText = exports.escapeAttribute = exports.escapeUTF8 = exports.escape = exports.encodeXML = exports.encode = exports.decodeStrict = exports.decode = exports.EncodingMode = exports.EntityLevel = void 0;
var decode_js_1 = __webpack_require__(/*! ./decode.js */ "../../../node_modules/entities/lib/decode.js");
var encode_js_1 = __webpack_require__(/*! ./encode.js */ "../../../node_modules/entities/lib/encode.js");
var escape_js_1 = __webpack_require__(/*! ./escape.js */ "../../../node_modules/entities/lib/escape.js");
/** The level of entities to support. */
var EntityLevel;
(function (EntityLevel) {
  /** Support only XML entities. */
  EntityLevel[EntityLevel["XML"] = 0] = "XML";
  /** Support HTML entities, which are a superset of XML entities. */
  EntityLevel[EntityLevel["HTML"] = 1] = "HTML";
})(EntityLevel = exports.EntityLevel || (exports.EntityLevel = {}));
var EncodingMode;
(function (EncodingMode) {
  /**
   * The output is UTF-8 encoded. Only characters that need escaping within
   * XML will be escaped.
   */
  EncodingMode[EncodingMode["UTF8"] = 0] = "UTF8";
  /**
   * The output consists only of ASCII characters. Characters that need
   * escaping within HTML, and characters that aren't ASCII characters will
   * be escaped.
   */
  EncodingMode[EncodingMode["ASCII"] = 1] = "ASCII";
  /**
   * Encode all characters that have an equivalent entity, as well as all
   * characters that are not ASCII characters.
   */
  EncodingMode[EncodingMode["Extensive"] = 2] = "Extensive";
  /**
   * Encode all characters that have to be escaped in HTML attributes,
   * following {@link https://html.spec.whatwg.org/multipage/parsing.html#escapingString}.
   */
  EncodingMode[EncodingMode["Attribute"] = 3] = "Attribute";
  /**
   * Encode all characters that have to be escaped in HTML text,
   * following {@link https://html.spec.whatwg.org/multipage/parsing.html#escapingString}.
   */
  EncodingMode[EncodingMode["Text"] = 4] = "Text";
})(EncodingMode = exports.EncodingMode || (exports.EncodingMode = {}));
/**
 * Decodes a string with entities.
 *
 * @param data String to decode.
 * @param options Decoding options.
 */
function decode(data, options) {
  if (options === void 0) {
    options = EntityLevel.XML;
  }
  var level = typeof options === "number" ? options : options.level;
  if (level === EntityLevel.HTML) {
    var mode = typeof options === "object" ? options.mode : undefined;
    return (0, decode_js_1.decodeHTML)(data, mode);
  }
  return (0, decode_js_1.decodeXML)(data);
}
exports.decode = decode;
/**
 * Decodes a string with entities. Does not allow missing trailing semicolons for entities.
 *
 * @param data String to decode.
 * @param options Decoding options.
 * @deprecated Use `decode` with the `mode` set to `Strict`.
 */
function decodeStrict(data, options) {
  var _a;
  if (options === void 0) {
    options = EntityLevel.XML;
  }
  var opts = typeof options === "number" ? {
    level: options
  } : options;
  (_a = opts.mode) !== null && _a !== void 0 ? _a : opts.mode = decode_js_1.DecodingMode.Strict;
  return decode(data, opts);
}
exports.decodeStrict = decodeStrict;
/**
 * Encodes a string with entities.
 *
 * @param data String to encode.
 * @param options Encoding options.
 */
function encode(data, options) {
  if (options === void 0) {
    options = EntityLevel.XML;
  }
  var opts = typeof options === "number" ? {
    level: options
  } : options;
  // Mode `UTF8` just escapes XML entities
  if (opts.mode === EncodingMode.UTF8) return (0, escape_js_1.escapeUTF8)(data);
  if (opts.mode === EncodingMode.Attribute) return (0, escape_js_1.escapeAttribute)(data);
  if (opts.mode === EncodingMode.Text) return (0, escape_js_1.escapeText)(data);
  if (opts.level === EntityLevel.HTML) {
    if (opts.mode === EncodingMode.ASCII) {
      return (0, encode_js_1.encodeNonAsciiHTML)(data);
    }
    return (0, encode_js_1.encodeHTML)(data);
  }
  // ASCII and Extensive are equivalent
  return (0, escape_js_1.encodeXML)(data);
}
exports.encode = encode;
var escape_js_2 = __webpack_require__(/*! ./escape.js */ "../../../node_modules/entities/lib/escape.js");
Object.defineProperty(exports, "encodeXML", ({
  enumerable: true,
  get: function () {
    return escape_js_2.encodeXML;
  }
}));
Object.defineProperty(exports, "escape", ({
  enumerable: true,
  get: function () {
    return escape_js_2.escape;
  }
}));
Object.defineProperty(exports, "escapeUTF8", ({
  enumerable: true,
  get: function () {
    return escape_js_2.escapeUTF8;
  }
}));
Object.defineProperty(exports, "escapeAttribute", ({
  enumerable: true,
  get: function () {
    return escape_js_2.escapeAttribute;
  }
}));
Object.defineProperty(exports, "escapeText", ({
  enumerable: true,
  get: function () {
    return escape_js_2.escapeText;
  }
}));
var encode_js_2 = __webpack_require__(/*! ./encode.js */ "../../../node_modules/entities/lib/encode.js");
Object.defineProperty(exports, "encodeHTML", ({
  enumerable: true,
  get: function () {
    return encode_js_2.encodeHTML;
  }
}));
Object.defineProperty(exports, "encodeNonAsciiHTML", ({
  enumerable: true,
  get: function () {
    return encode_js_2.encodeNonAsciiHTML;
  }
}));
// Legacy aliases (deprecated)
Object.defineProperty(exports, "encodeHTML4", ({
  enumerable: true,
  get: function () {
    return encode_js_2.encodeHTML;
  }
}));
Object.defineProperty(exports, "encodeHTML5", ({
  enumerable: true,
  get: function () {
    return encode_js_2.encodeHTML;
  }
}));
var decode_js_2 = __webpack_require__(/*! ./decode.js */ "../../../node_modules/entities/lib/decode.js");
Object.defineProperty(exports, "EntityDecoder", ({
  enumerable: true,
  get: function () {
    return decode_js_2.EntityDecoder;
  }
}));
Object.defineProperty(exports, "DecodingMode", ({
  enumerable: true,
  get: function () {
    return decode_js_2.DecodingMode;
  }
}));
Object.defineProperty(exports, "decodeXML", ({
  enumerable: true,
  get: function () {
    return decode_js_2.decodeXML;
  }
}));
Object.defineProperty(exports, "decodeHTML", ({
  enumerable: true,
  get: function () {
    return decode_js_2.decodeHTML;
  }
}));
Object.defineProperty(exports, "decodeHTMLStrict", ({
  enumerable: true,
  get: function () {
    return decode_js_2.decodeHTMLStrict;
  }
}));
Object.defineProperty(exports, "decodeHTMLAttribute", ({
  enumerable: true,
  get: function () {
    return decode_js_2.decodeHTMLAttribute;
  }
}));
// Legacy aliases (deprecated)
Object.defineProperty(exports, "decodeHTML4", ({
  enumerable: true,
  get: function () {
    return decode_js_2.decodeHTML;
  }
}));
Object.defineProperty(exports, "decodeHTML5", ({
  enumerable: true,
  get: function () {
    return decode_js_2.decodeHTML;
  }
}));
Object.defineProperty(exports, "decodeHTML4Strict", ({
  enumerable: true,
  get: function () {
    return decode_js_2.decodeHTMLStrict;
  }
}));
Object.defineProperty(exports, "decodeHTML5Strict", ({
  enumerable: true,
  get: function () {
    return decode_js_2.decodeHTMLStrict;
  }
}));
Object.defineProperty(exports, "decodeXMLStrict", ({
  enumerable: true,
  get: function () {
    return decode_js_2.decodeXML;
  }
}));

/***/ }),

/***/ "../../../node_modules/framer-motion/dist/cjs/index.js":
/*!*************************************************************!*\
  !*** ../../../node_modules/framer-motion/dist/cjs/index.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var tslib = __webpack_require__(/*! tslib */ "../../../node_modules/tslib/tslib.es6.mjs");
var React = __webpack_require__(/*! react */ "react");
var heyListen = __webpack_require__(/*! hey-listen */ "../../../node_modules/hey-listen/dist/hey-listen.es.js");
var styleValueTypes = __webpack_require__(/*! style-value-types */ "../../../node_modules/style-value-types/dist/valueTypes.cjs.js");
var popmotion = __webpack_require__(/*! popmotion */ "../../../node_modules/popmotion/dist/popmotion.cjs.js");
var sync = __webpack_require__(/*! framesync */ "../../../node_modules/framesync/dist/framesync.cjs.js");
var dom = __webpack_require__(/*! @motionone/dom */ "../../../node_modules/@motionone/dom/dist/index.es.js");
function _interopDefaultLegacy(e) {
  return e && typeof e === 'object' && 'default' in e ? e : {
    'default': e
  };
}
function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () {
            return e[k];
          }
        });
      }
    });
  }
  n["default"] = e;
  return Object.freeze(n);
}
var React__namespace = /*#__PURE__*/_interopNamespace(React);
var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
var sync__default = /*#__PURE__*/_interopDefaultLegacy(sync);

/**
 * Browser-safe usage of process
 */
var defaultEnvironment = "production";
var env = typeof process === "undefined" || process.env === undefined ? defaultEnvironment : "development" || 0;
var createDefinition = function (propNames) {
  return {
    isEnabled: function (props) {
      return propNames.some(function (name) {
        return !!props[name];
      });
    }
  };
};
var featureDefinitions = {
  measureLayout: createDefinition(["layout", "layoutId", "drag"]),
  animation: createDefinition(["animate", "exit", "variants", "whileHover", "whileTap", "whileFocus", "whileDrag", "whileInView"]),
  exit: createDefinition(["exit"]),
  drag: createDefinition(["drag", "dragControls"]),
  focus: createDefinition(["whileFocus"]),
  hover: createDefinition(["whileHover", "onHoverStart", "onHoverEnd"]),
  tap: createDefinition(["whileTap", "onTap", "onTapStart", "onTapCancel"]),
  pan: createDefinition(["onPan", "onPanStart", "onPanSessionStart", "onPanEnd"]),
  inView: createDefinition(["whileInView", "onViewportEnter", "onViewportLeave"])
};
function loadFeatures(features) {
  for (var key in features) {
    if (features[key] === null) continue;
    if (key === "projectionNodeConstructor") {
      featureDefinitions.projectionNodeConstructor = features[key];
    } else {
      featureDefinitions[key].Component = features[key];
    }
  }
}
var LazyContext = React.createContext({
  strict: false
});
var featureNames = Object.keys(featureDefinitions);
var numFeatures = featureNames.length;
/**
 * Load features via renderless components based on the provided MotionProps.
 */
function useFeatures(props, visualElement, preloadedFeatures) {
  var features = [];
  var lazyContext = React.useContext(LazyContext);
  if (!visualElement) return null;
  /**
   * If we're in development mode, check to make sure we're not rendering a motion component
   * as a child of LazyMotion, as this will break the file-size benefits of using it.
   */
  if (env !== "production" && preloadedFeatures && lazyContext.strict) {
    heyListen.invariant(false, "You have rendered a `motion` component within a `LazyMotion` component. This will break tree shaking. Import and render a `m` component instead.");
  }
  for (var i = 0; i < numFeatures; i++) {
    var name_1 = featureNames[i];
    var _a = featureDefinitions[name_1],
      isEnabled = _a.isEnabled,
      Component = _a.Component;
    /**
     * It might be possible in the future to use this moment to
     * dynamically request functionality. In initial tests this
     * was producing a lot of duplication amongst bundles.
     */
    if (isEnabled(props) && Component) {
      features.push(React__namespace.createElement(Component, tslib.__assign({
        key: name_1
      }, props, {
        visualElement: visualElement
      })));
    }
  }
  return features;
}

/**
 * @public
 */
var MotionConfigContext = React.createContext({
  transformPagePoint: function (p) {
    return p;
  },
  isStatic: false,
  reducedMotion: "never"
});
var MotionContext = React.createContext({});
function useVisualElementContext() {
  return React.useContext(MotionContext).visualElement;
}

/**
 * @public
 */
var PresenceContext = React.createContext(null);
var isBrowser = typeof document !== "undefined";
var useIsomorphicLayoutEffect = isBrowser ? React.useLayoutEffect : React.useEffect;

// Does this device prefer reduced motion? Returns `null` server-side.
var prefersReducedMotion = {
  current: null
};
var hasDetected = false;
function initPrefersReducedMotion() {
  hasDetected = true;
  if (!isBrowser) return;
  if (window.matchMedia) {
    var motionMediaQuery_1 = window.matchMedia("(prefers-reduced-motion)");
    var setReducedMotionPreferences = function () {
      return prefersReducedMotion.current = motionMediaQuery_1.matches;
    };
    motionMediaQuery_1.addListener(setReducedMotionPreferences);
    setReducedMotionPreferences();
  } else {
    prefersReducedMotion.current = false;
  }
}
/**
 * A hook that returns `true` if we should be using reduced motion based on the current device's Reduced Motion setting.
 *
 * This can be used to implement changes to your UI based on Reduced Motion. For instance, replacing motion-sickness inducing
 * `x`/`y` animations with `opacity`, disabling the autoplay of background videos, or turning off parallax motion.
 *
 * It will actively respond to changes and re-render your components with the latest setting.
 *
 * ```jsx
 * export function Sidebar({ isOpen }) {
 *   const shouldReduceMotion = useReducedMotion()
 *   const closedX = shouldReduceMotion ? 0 : "-100%"
 *
 *   return (
 *     <motion.div animate={{
 *       opacity: isOpen ? 1 : 0,
 *       x: isOpen ? 0 : closedX
 *     }} />
 *   )
 * }
 * ```
 *
 * @return boolean
 *
 * @public
 */
function useReducedMotion() {
  /**
   * Lazy initialisation of prefersReducedMotion
   */
  !hasDetected && initPrefersReducedMotion();
  var _a = tslib.__read(React.useState(prefersReducedMotion.current), 1),
    shouldReduceMotion = _a[0];
  /**
   * TODO See if people miss automatically updating shouldReduceMotion setting
   */
  return shouldReduceMotion;
}
function useReducedMotionConfig() {
  var reducedMotionPreference = useReducedMotion();
  var reducedMotion = React.useContext(MotionConfigContext).reducedMotion;
  if (reducedMotion === "never") {
    return false;
  } else if (reducedMotion === "always") {
    return true;
  } else {
    return reducedMotionPreference;
  }
}
function useVisualElement(Component, visualState, props, createVisualElement) {
  var lazyContext = React.useContext(LazyContext);
  var parent = useVisualElementContext();
  var presenceContext = React.useContext(PresenceContext);
  var shouldReduceMotion = useReducedMotionConfig();
  var visualElementRef = React.useRef(undefined);
  /**
   * If we haven't preloaded a renderer, check to see if we have one lazy-loaded
   */
  if (!createVisualElement) createVisualElement = lazyContext.renderer;
  if (!visualElementRef.current && createVisualElement) {
    visualElementRef.current = createVisualElement(Component, {
      visualState: visualState,
      parent: parent,
      props: props,
      presenceId: presenceContext === null || presenceContext === void 0 ? void 0 : presenceContext.id,
      blockInitialAnimation: (presenceContext === null || presenceContext === void 0 ? void 0 : presenceContext.initial) === false,
      shouldReduceMotion: shouldReduceMotion
    });
  }
  var visualElement = visualElementRef.current;
  useIsomorphicLayoutEffect(function () {
    visualElement === null || visualElement === void 0 ? void 0 : visualElement.syncRender();
  });
  React.useEffect(function () {
    var _a;
    (_a = visualElement === null || visualElement === void 0 ? void 0 : visualElement.animationState) === null || _a === void 0 ? void 0 : _a.animateChanges();
  });
  useIsomorphicLayoutEffect(function () {
    return function () {
      return visualElement === null || visualElement === void 0 ? void 0 : visualElement.notifyUnmount();
    };
  }, []);
  return visualElement;
}
function isRefObject(ref) {
  return typeof ref === "object" && Object.prototype.hasOwnProperty.call(ref, "current");
}

/**
 * Creates a ref function that, when called, hydrates the provided
 * external ref and VisualElement.
 */
function useMotionRef(visualState, visualElement, externalRef) {
  return React.useCallback(function (instance) {
    var _a;
    instance && ((_a = visualState.mount) === null || _a === void 0 ? void 0 : _a.call(visualState, instance));
    if (visualElement) {
      instance ? visualElement.mount(instance) : visualElement.unmount();
    }
    if (externalRef) {
      if (typeof externalRef === "function") {
        externalRef(instance);
      } else if (isRefObject(externalRef)) {
        externalRef.current = instance;
      }
    }
  },
  /**
   * Only pass a new ref callback to React if we've received a visual element
   * factory. Otherwise we'll be mounting/remounting every time externalRef
   * or other dependencies change.
   */
  [visualElement]);
}

/**
 * Decides if the supplied variable is an array of variant labels
 */
function isVariantLabels(v) {
  return Array.isArray(v);
}
/**
 * Decides if the supplied variable is variant label
 */
function isVariantLabel(v) {
  return typeof v === "string" || isVariantLabels(v);
}
/**
 * Creates an object containing the latest state of every MotionValue on a VisualElement
 */
function getCurrent(visualElement) {
  var current = {};
  visualElement.forEachValue(function (value, key) {
    return current[key] = value.get();
  });
  return current;
}
/**
 * Creates an object containing the latest velocity of every MotionValue on a VisualElement
 */
function getVelocity$1(visualElement) {
  var velocity = {};
  visualElement.forEachValue(function (value, key) {
    return velocity[key] = value.getVelocity();
  });
  return velocity;
}
function resolveVariantFromProps(props, definition, custom, currentValues, currentVelocity) {
  var _a;
  if (currentValues === void 0) {
    currentValues = {};
  }
  if (currentVelocity === void 0) {
    currentVelocity = {};
  }
  /**
   * If the variant definition is a function, resolve.
   */
  if (typeof definition === "function") {
    definition = definition(custom !== null && custom !== void 0 ? custom : props.custom, currentValues, currentVelocity);
  }
  /**
   * If the variant definition is a variant label, or
   * the function returned a variant label, resolve.
   */
  if (typeof definition === "string") {
    definition = (_a = props.variants) === null || _a === void 0 ? void 0 : _a[definition];
  }
  /**
   * At this point we've resolved both functions and variant labels,
   * but the resolved variant label might itself have been a function.
   * If so, resolve. This can only have returned a valid target object.
   */
  if (typeof definition === "function") {
    definition = definition(custom !== null && custom !== void 0 ? custom : props.custom, currentValues, currentVelocity);
  }
  return definition;
}
function resolveVariant(visualElement, definition, custom) {
  var props = visualElement.getProps();
  return resolveVariantFromProps(props, definition, custom !== null && custom !== void 0 ? custom : props.custom, getCurrent(visualElement), getVelocity$1(visualElement));
}
function checkIfControllingVariants(props) {
  var _a;
  return typeof ((_a = props.animate) === null || _a === void 0 ? void 0 : _a.start) === "function" || isVariantLabel(props.initial) || isVariantLabel(props.animate) || isVariantLabel(props.whileHover) || isVariantLabel(props.whileDrag) || isVariantLabel(props.whileTap) || isVariantLabel(props.whileFocus) || isVariantLabel(props.exit);
}
function checkIfVariantNode(props) {
  return Boolean(checkIfControllingVariants(props) || props.variants);
}
function getCurrentTreeVariants(props, context) {
  if (checkIfControllingVariants(props)) {
    var initial = props.initial,
      animate = props.animate;
    return {
      initial: initial === false || isVariantLabel(initial) ? initial : undefined,
      animate: isVariantLabel(animate) ? animate : undefined
    };
  }
  return props.inherit !== false ? context : {};
}
function useCreateMotionContext(props) {
  var _a = getCurrentTreeVariants(props, React.useContext(MotionContext)),
    initial = _a.initial,
    animate = _a.animate;
  return React.useMemo(function () {
    return {
      initial: initial,
      animate: animate
    };
  }, [variantLabelsAsDependency(initial), variantLabelsAsDependency(animate)]);
}
function variantLabelsAsDependency(prop) {
  return Array.isArray(prop) ? prop.join(" ") : prop;
}

/**
 * Creates a constant value over the lifecycle of a component.
 *
 * Even if `useMemo` is provided an empty array as its final argument, it doesn't offer
 * a guarantee that it won't re-run for performance reasons later on. By using `useConstant`
 * you can ensure that initialisers don't execute twice or more.
 */
function useConstant(init) {
  var ref = React.useRef(null);
  if (ref.current === null) {
    ref.current = init();
  }
  return ref.current;
}

/**
 * This should only ever be modified on the client otherwise it'll
 * persist through server requests. If we need instanced states we
 * could lazy-init via root.
 */
var globalProjectionState = {
  /**
   * Global flag as to whether the tree has animated since the last time
   * we resized the window
   */
  hasAnimatedSinceResize: true,
  /**
   * We set this to true once, on the first update. Any nodes added to the tree beyond that
   * update will be given a `data-projection-id` attribute.
   */
  hasEverUpdated: false
};
var id$1 = 1;
function useProjectionId() {
  return useConstant(function () {
    if (globalProjectionState.hasEverUpdated) {
      return id$1++;
    }
  });
}
var LayoutGroupContext = React.createContext({});

/**
 * Internal, exported only for usage in Framer
 */
var SwitchLayoutGroupContext = React.createContext({});
function useProjection(projectionId, _a, visualElement, ProjectionNodeConstructor) {
  var _b;
  var layoutId = _a.layoutId,
    layout = _a.layout,
    drag = _a.drag,
    dragConstraints = _a.dragConstraints,
    layoutScroll = _a.layoutScroll;
  var initialPromotionConfig = React.useContext(SwitchLayoutGroupContext);
  if (!ProjectionNodeConstructor || !visualElement || (visualElement === null || visualElement === void 0 ? void 0 : visualElement.projection)) {
    return;
  }
  visualElement.projection = new ProjectionNodeConstructor(projectionId, visualElement.getLatestValues(), (_b = visualElement.parent) === null || _b === void 0 ? void 0 : _b.projection);
  visualElement.projection.setOptions({
    layoutId: layoutId,
    layout: layout,
    alwaysMeasureLayout: Boolean(drag) || dragConstraints && isRefObject(dragConstraints),
    visualElement: visualElement,
    scheduleRender: function () {
      return visualElement.scheduleRender();
    },
    /**
     * TODO: Update options in an effect. This could be tricky as it'll be too late
     * to update by the time layout animations run.
     * We also need to fix this safeToRemove by linking it up to the one returned by usePresence,
     * ensuring it gets called if there's no potential layout animations.
     *
     */
    animationType: typeof layout === "string" ? layout : "both",
    initialPromotionConfig: initialPromotionConfig,
    layoutScroll: layoutScroll
  });
}
var VisualElementHandler = /** @class */function (_super) {
  tslib.__extends(VisualElementHandler, _super);
  function VisualElementHandler() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * Update visual element props as soon as we know this update is going to be commited.
   */
  VisualElementHandler.prototype.getSnapshotBeforeUpdate = function () {
    this.updateProps();
    return null;
  };
  VisualElementHandler.prototype.componentDidUpdate = function () {};
  VisualElementHandler.prototype.updateProps = function () {
    var _a = this.props,
      visualElement = _a.visualElement,
      props = _a.props;
    if (visualElement) visualElement.setProps(props);
  };
  VisualElementHandler.prototype.render = function () {
    return this.props.children;
  };
  return VisualElementHandler;
}(React__default["default"].Component);

/**
 * Create a `motion` component.
 *
 * This function accepts a Component argument, which can be either a string (ie "div"
 * for `motion.div`), or an actual React component.
 *
 * Alongside this is a config option which provides a way of rendering the provided
 * component "offline", or outside the React render cycle.
 */
function createMotionComponent(_a) {
  var preloadedFeatures = _a.preloadedFeatures,
    createVisualElement = _a.createVisualElement,
    projectionNodeConstructor = _a.projectionNodeConstructor,
    useRender = _a.useRender,
    useVisualState = _a.useVisualState,
    Component = _a.Component;
  preloadedFeatures && loadFeatures(preloadedFeatures);
  function MotionComponent(props, externalRef) {
    var layoutId = useLayoutId(props);
    props = tslib.__assign(tslib.__assign({}, props), {
      layoutId: layoutId
    });
    /**
     * If we're rendering in a static environment, we only visually update the component
     * as a result of a React-rerender rather than interactions or animations. This
     * means we don't need to load additional memory structures like VisualElement,
     * or any gesture/animation features.
     */
    var config = React.useContext(MotionConfigContext);
    var features = null;
    var context = useCreateMotionContext(props);
    /**
     * Create a unique projection ID for this component. If a new component is added
     * during a layout animation we'll use this to query the DOM and hydrate its ref early, allowing
     * us to measure it as soon as any layout effect flushes pending layout animations.
     *
     * Performance note: It'd be better not to have to search the DOM for these elements.
     * For newly-entering components it could be enough to only correct treeScale, in which
     * case we could mount in a scale-correction mode. This wouldn't be enough for
     * shared element transitions however. Perhaps for those we could revert to a root node
     * that gets forceRendered and layout animations are triggered on its layout effect.
     */
    var projectionId = config.isStatic ? undefined : useProjectionId();
    /**
     *
     */
    var visualState = useVisualState(props, config.isStatic);
    if (!config.isStatic && isBrowser) {
      /**
       * Create a VisualElement for this component. A VisualElement provides a common
       * interface to renderer-specific APIs (ie DOM/Three.js etc) as well as
       * providing a way of rendering to these APIs outside of the React render loop
       * for more performant animations and interactions
       */
      context.visualElement = useVisualElement(Component, visualState, tslib.__assign(tslib.__assign({}, config), props), createVisualElement);
      useProjection(projectionId, props, context.visualElement, projectionNodeConstructor || featureDefinitions.projectionNodeConstructor);
      /**
       * Load Motion gesture and animation features. These are rendered as renderless
       * components so each feature can optionally make use of React lifecycle methods.
       */
      features = useFeatures(props, context.visualElement, preloadedFeatures);
    }
    /**
     * The mount order and hierarchy is specific to ensure our element ref
     * is hydrated by the time features fire their effects.
     */
    return React__namespace.createElement(VisualElementHandler, {
      visualElement: context.visualElement,
      props: tslib.__assign(tslib.__assign({}, config), props)
    }, features, React__namespace.createElement(MotionContext.Provider, {
      value: context
    }, useRender(Component, props, projectionId, useMotionRef(visualState, context.visualElement, externalRef), visualState, config.isStatic, context.visualElement)));
  }
  return React.forwardRef(MotionComponent);
}
function useLayoutId(_a) {
  var _b;
  var layoutId = _a.layoutId;
  var layoutGroupId = (_b = React.useContext(LayoutGroupContext)) === null || _b === void 0 ? void 0 : _b.id;
  return layoutGroupId && layoutId !== undefined ? layoutGroupId + "-" + layoutId : layoutId;
}

/**
 * Convert any React component into a `motion` component. The provided component
 * **must** use `React.forwardRef` to the underlying DOM component you want to animate.
 *
 * ```jsx
 * const Component = React.forwardRef((props, ref) => {
 *   return <div ref={ref} />
 * })
 *
 * const MotionComponent = motion(Component)
 * ```
 *
 * @public
 */
function createMotionProxy(createConfig) {
  function custom(Component, customMotionComponentConfig) {
    if (customMotionComponentConfig === void 0) {
      customMotionComponentConfig = {};
    }
    return createMotionComponent(createConfig(Component, customMotionComponentConfig));
  }
  if (typeof Proxy === "undefined") {
    return custom;
  }
  /**
   * A cache of generated `motion` components, e.g `motion.div`, `motion.input` etc.
   * Rather than generating them anew every render.
   */
  var componentCache = new Map();
  return new Proxy(custom, {
    /**
     * Called when `motion` is referenced with a prop: `motion.div`, `motion.input` etc.
     * The prop name is passed through as `key` and we can use that to generate a `motion`
     * DOM component with that name.
     */
    get: function (_target, key) {
      /**
       * If this element doesn't exist in the component cache, create it and cache.
       */
      if (!componentCache.has(key)) {
        componentCache.set(key, custom(key));
      }
      return componentCache.get(key);
    }
  });
}

/**
 * We keep these listed seperately as we use the lowercase tag names as part
 * of the runtime bundle to detect SVG components
 */
var lowercaseSVGElements = ["animate", "circle", "defs", "desc", "ellipse", "g", "image", "line", "filter", "marker", "mask", "metadata", "path", "pattern", "polygon", "polyline", "rect", "stop", "svg", "switch", "symbol", "text", "tspan", "use", "view"];
function isSVGComponent(Component) {
  if (
  /**
   * If it's not a string, it's a custom React component. Currently we only support
   * HTML custom React components.
   */
  typeof Component !== "string" ||
  /**
   * If it contains a dash, the element is a custom HTML webcomponent.
   */
  Component.includes("-")) {
    return false;
  } else if (
  /**
   * If it's in our list of lowercase SVG tags, it's an SVG component
   */
  lowercaseSVGElements.indexOf(Component) > -1 ||
  /**
   * If it contains a capital letter, it's an SVG component
   */
  /[A-Z]/.test(Component)) {
    return true;
  }
  return false;
}
var scaleCorrectors = {};
function addScaleCorrector(correctors) {
  Object.assign(scaleCorrectors, correctors);
}

/**
 * A list of all transformable axes. We'll use this list to generated a version
 * of each axes for each transform.
 */
var transformAxes = ["", "X", "Y", "Z"];
/**
 * An ordered array of each transformable value. By default, transform values
 * will be sorted to this order.
 */
var order = ["translate", "scale", "rotate", "skew"];
/**
 * Generate a list of every possible transform key.
 */
var transformProps = ["transformPerspective", "x", "y", "z"];
order.forEach(function (operationKey) {
  return transformAxes.forEach(function (axesKey) {
    return transformProps.push(operationKey + axesKey);
  });
});
/**
 * A function to use with Array.sort to sort transform keys by their default order.
 */
function sortTransformProps(a, b) {
  return transformProps.indexOf(a) - transformProps.indexOf(b);
}
/**
 * A quick lookup for transform props.
 */
var transformPropSet = new Set(transformProps);
function isTransformProp(key) {
  return transformPropSet.has(key);
}
/**
 * A quick lookup for transform origin props
 */
var transformOriginProps = new Set(["originX", "originY", "originZ"]);
function isTransformOriginProp(key) {
  return transformOriginProps.has(key);
}
function isForcedMotionValue(key, _a) {
  var layout = _a.layout,
    layoutId = _a.layoutId;
  return isTransformProp(key) || isTransformOriginProp(key) || (layout || layoutId !== undefined) && (!!scaleCorrectors[key] || key === "opacity");
}
var isMotionValue = function (value) {
  return Boolean(value !== null && typeof value === "object" && value.getVelocity);
};
var translateAlias = {
  x: "translateX",
  y: "translateY",
  z: "translateZ",
  transformPerspective: "perspective"
};
/**
 * Build a CSS transform style from individual x/y/scale etc properties.
 *
 * This outputs with a default order of transforms/scales/rotations, this can be customised by
 * providing a transformTemplate function.
 */
function buildTransform(_a, _b, transformIsDefault, transformTemplate) {
  var transform = _a.transform,
    transformKeys = _a.transformKeys;
  var _c = _b.enableHardwareAcceleration,
    enableHardwareAcceleration = _c === void 0 ? true : _c,
    _d = _b.allowTransformNone,
    allowTransformNone = _d === void 0 ? true : _d;
  // The transform string we're going to build into.
  var transformString = "";
  // Transform keys into their default order - this will determine the output order.
  transformKeys.sort(sortTransformProps);
  // Track whether the defined transform has a defined z so we don't add a
  // second to enable hardware acceleration
  var transformHasZ = false;
  // Loop over each transform and build them into transformString
  var numTransformKeys = transformKeys.length;
  for (var i = 0; i < numTransformKeys; i++) {
    var key = transformKeys[i];
    transformString += "".concat(translateAlias[key] || key, "(").concat(transform[key], ") ");
    if (key === "z") transformHasZ = true;
  }
  if (!transformHasZ && enableHardwareAcceleration) {
    transformString += "translateZ(0)";
  } else {
    transformString = transformString.trim();
  }
  // If we have a custom `transform` template, pass our transform values and
  // generated transformString to that before returning
  if (transformTemplate) {
    transformString = transformTemplate(transform, transformIsDefault ? "" : transformString);
  } else if (allowTransformNone && transformIsDefault) {
    transformString = "none";
  }
  return transformString;
}
/**
 * Build a transformOrigin style. Uses the same defaults as the browser for
 * undefined origins.
 */
function buildTransformOrigin(_a) {
  var _b = _a.originX,
    originX = _b === void 0 ? "50%" : _b,
    _c = _a.originY,
    originY = _c === void 0 ? "50%" : _c,
    _d = _a.originZ,
    originZ = _d === void 0 ? 0 : _d;
  return "".concat(originX, " ").concat(originY, " ").concat(originZ);
}

/**
 * Returns true if the provided key is a CSS variable
 */
function isCSSVariable$1(key) {
  return key.startsWith("--");
}

/**
 * Provided a value and a ValueType, returns the value as that value type.
 */
var getValueAsType = function (value, type) {
  return type && typeof value === "number" ? type.transform(value) : value;
};
var int = tslib.__assign(tslib.__assign({}, styleValueTypes.number), {
  transform: Math.round
});
var numberValueTypes = {
  // Border props
  borderWidth: styleValueTypes.px,
  borderTopWidth: styleValueTypes.px,
  borderRightWidth: styleValueTypes.px,
  borderBottomWidth: styleValueTypes.px,
  borderLeftWidth: styleValueTypes.px,
  borderRadius: styleValueTypes.px,
  radius: styleValueTypes.px,
  borderTopLeftRadius: styleValueTypes.px,
  borderTopRightRadius: styleValueTypes.px,
  borderBottomRightRadius: styleValueTypes.px,
  borderBottomLeftRadius: styleValueTypes.px,
  // Positioning props
  width: styleValueTypes.px,
  maxWidth: styleValueTypes.px,
  height: styleValueTypes.px,
  maxHeight: styleValueTypes.px,
  size: styleValueTypes.px,
  top: styleValueTypes.px,
  right: styleValueTypes.px,
  bottom: styleValueTypes.px,
  left: styleValueTypes.px,
  // Spacing props
  padding: styleValueTypes.px,
  paddingTop: styleValueTypes.px,
  paddingRight: styleValueTypes.px,
  paddingBottom: styleValueTypes.px,
  paddingLeft: styleValueTypes.px,
  margin: styleValueTypes.px,
  marginTop: styleValueTypes.px,
  marginRight: styleValueTypes.px,
  marginBottom: styleValueTypes.px,
  marginLeft: styleValueTypes.px,
  // Transform props
  rotate: styleValueTypes.degrees,
  rotateX: styleValueTypes.degrees,
  rotateY: styleValueTypes.degrees,
  rotateZ: styleValueTypes.degrees,
  scale: styleValueTypes.scale,
  scaleX: styleValueTypes.scale,
  scaleY: styleValueTypes.scale,
  scaleZ: styleValueTypes.scale,
  skew: styleValueTypes.degrees,
  skewX: styleValueTypes.degrees,
  skewY: styleValueTypes.degrees,
  distance: styleValueTypes.px,
  translateX: styleValueTypes.px,
  translateY: styleValueTypes.px,
  translateZ: styleValueTypes.px,
  x: styleValueTypes.px,
  y: styleValueTypes.px,
  z: styleValueTypes.px,
  perspective: styleValueTypes.px,
  transformPerspective: styleValueTypes.px,
  opacity: styleValueTypes.alpha,
  originX: styleValueTypes.progressPercentage,
  originY: styleValueTypes.progressPercentage,
  originZ: styleValueTypes.px,
  // Misc
  zIndex: int,
  // SVG
  fillOpacity: styleValueTypes.alpha,
  strokeOpacity: styleValueTypes.alpha,
  numOctaves: int
};
function buildHTMLStyles(state, latestValues, options, transformTemplate) {
  var _a;
  var style = state.style,
    vars = state.vars,
    transform = state.transform,
    transformKeys = state.transformKeys,
    transformOrigin = state.transformOrigin;
  // Empty the transformKeys array. As we're throwing out refs to its items
  // this might not be as cheap as suspected. Maybe using the array as a buffer
  // with a manual incrementation would be better.
  transformKeys.length = 0;
  // Track whether we encounter any transform or transformOrigin values.
  var hasTransform = false;
  var hasTransformOrigin = false;
  // Does the calculated transform essentially equal "none"?
  var transformIsNone = true;
  /**
   * Loop over all our latest animated values and decide whether to handle them
   * as a style or CSS variable.
   *
   * Transforms and transform origins are kept seperately for further processing.
   */
  for (var key in latestValues) {
    var value = latestValues[key];
    /**
     * If this is a CSS variable we don't do any further processing.
     */
    if (isCSSVariable$1(key)) {
      vars[key] = value;
      continue;
    }
    // Convert the value to its default value type, ie 0 -> "0px"
    var valueType = numberValueTypes[key];
    var valueAsType = getValueAsType(value, valueType);
    if (isTransformProp(key)) {
      // If this is a transform, flag to enable further transform processing
      hasTransform = true;
      transform[key] = valueAsType;
      transformKeys.push(key);
      // If we already know we have a non-default transform, early return
      if (!transformIsNone) continue;
      // Otherwise check to see if this is a default transform
      if (value !== ((_a = valueType.default) !== null && _a !== void 0 ? _a : 0)) transformIsNone = false;
    } else if (isTransformOriginProp(key)) {
      transformOrigin[key] = valueAsType;
      // If this is a transform origin, flag and enable further transform-origin processing
      hasTransformOrigin = true;
    } else {
      style[key] = valueAsType;
    }
  }
  if (hasTransform) {
    style.transform = buildTransform(state, options, transformIsNone, transformTemplate);
  } else if (transformTemplate) {
    style.transform = transformTemplate({}, "");
  } else if (!latestValues.transform && style.transform) {
    style.transform = "none";
  }
  if (hasTransformOrigin) {
    style.transformOrigin = buildTransformOrigin(transformOrigin);
  }
}
var createHtmlRenderState = function () {
  return {
    style: {},
    transform: {},
    transformKeys: [],
    transformOrigin: {},
    vars: {}
  };
};
function copyRawValuesOnly(target, source, props) {
  for (var key in source) {
    if (!isMotionValue(source[key]) && !isForcedMotionValue(key, props)) {
      target[key] = source[key];
    }
  }
}
function useInitialMotionValues(_a, visualState, isStatic) {
  var transformTemplate = _a.transformTemplate;
  return React.useMemo(function () {
    var state = createHtmlRenderState();
    buildHTMLStyles(state, visualState, {
      enableHardwareAcceleration: !isStatic
    }, transformTemplate);
    var vars = state.vars,
      style = state.style;
    return tslib.__assign(tslib.__assign({}, vars), style);
  }, [visualState]);
}
function useStyle(props, visualState, isStatic) {
  var styleProp = props.style || {};
  var style = {};
  /**
   * Copy non-Motion Values straight into style
   */
  copyRawValuesOnly(style, styleProp, props);
  Object.assign(style, useInitialMotionValues(props, visualState, isStatic));
  if (props.transformValues) {
    style = props.transformValues(style);
  }
  return style;
}
function useHTMLProps(props, visualState, isStatic) {
  // The `any` isn't ideal but it is the type of createElement props argument
  var htmlProps = {};
  var style = useStyle(props, visualState, isStatic);
  if (Boolean(props.drag) && props.dragListener !== false) {
    // Disable the ghost element when a user drags
    htmlProps.draggable = false;
    // Disable text selection
    style.userSelect = style.WebkitUserSelect = style.WebkitTouchCallout = "none";
    // Disable scrolling on the draggable direction
    style.touchAction = props.drag === true ? "none" : "pan-".concat(props.drag === "x" ? "y" : "x");
  }
  htmlProps.style = style;
  return htmlProps;
}

/**
 * A list of all valid MotionProps.
 *
 * @privateRemarks
 * This doesn't throw if a `MotionProp` name is missing - it should.
 */
var validMotionProps = new Set(["initial", "animate", "exit", "style", "variants", "transition", "transformTemplate", "transformValues", "custom", "inherit", "layout", "layoutId", "layoutDependency", "onLayoutAnimationStart", "onLayoutAnimationComplete", "onLayoutMeasure", "onBeforeLayoutMeasure", "onAnimationStart", "onAnimationComplete", "onUpdate", "onDragStart", "onDrag", "onDragEnd", "onMeasureDragConstraints", "onDirectionLock", "onDragTransitionEnd", "drag", "dragControls", "dragListener", "dragConstraints", "dragDirectionLock", "dragSnapToOrigin", "_dragX", "_dragY", "dragElastic", "dragMomentum", "dragPropagation", "dragTransition", "whileDrag", "onPan", "onPanStart", "onPanEnd", "onPanSessionStart", "onTap", "onTapStart", "onTapCancel", "onHoverStart", "onHoverEnd", "whileFocus", "whileTap", "whileHover", "whileInView", "onViewportEnter", "onViewportLeave", "viewport", "layoutScroll"]);
/**
 * Check whether a prop name is a valid `MotionProp` key.
 *
 * @param key - Name of the property to check
 * @returns `true` is key is a valid `MotionProp`.
 *
 * @public
 */
function isValidMotionProp(key) {
  return validMotionProps.has(key);
}
var shouldForward = function (key) {
  return !isValidMotionProp(key);
};
function loadExternalIsValidProp(isValidProp) {
  if (!isValidProp) return;
  // Explicitly filter our events
  shouldForward = function (key) {
    return key.startsWith("on") ? !isValidMotionProp(key) : isValidProp(key);
  };
}
/**
 * Emotion and Styled Components both allow users to pass through arbitrary props to their components
 * to dynamically generate CSS. They both use the `@emotion/is-prop-valid` package to determine which
 * of these should be passed to the underlying DOM node.
 *
 * However, when styling a Motion component `styled(motion.div)`, both packages pass through *all* props
 * as it's seen as an arbitrary component rather than a DOM node. Motion only allows arbitrary props
 * passed through the `custom` prop so it doesn't *need* the payload or computational overhead of
 * `@emotion/is-prop-valid`, however to fix this problem we need to use it.
 *
 * By making it an optionalDependency we can offer this functionality only in the situations where it's
 * actually required.
 */
try {
  /**
   * We attempt to import this package but require won't be defined in esm environments, in that case
   * isPropValid will have to be provided via `MotionContext`. In a 6.0.0 this should probably be removed
   * in favour of explicit injection.
   */
  loadExternalIsValidProp((__webpack_require__(/*! @emotion/is-prop-valid */ "../../../node_modules/@emotion/is-prop-valid/dist/is-prop-valid.browser.esm.js")["default"]));
} catch (_a) {
  // We don't need to actually do anything here - the fallback is the existing `isPropValid`.
}
function filterProps(props, isDom, forwardMotionProps) {
  var filteredProps = {};
  for (var key in props) {
    if (shouldForward(key) || forwardMotionProps === true && isValidMotionProp(key) || !isDom && !isValidMotionProp(key) ||
    // If trying to use native HTML drag events, forward drag listeners
    props["draggable"] && key.startsWith("onDrag")) {
      filteredProps[key] = props[key];
    }
  }
  return filteredProps;
}
function calcOrigin$1(origin, offset, size) {
  return typeof origin === "string" ? origin : styleValueTypes.px.transform(offset + size * origin);
}
/**
 * The SVG transform origin defaults are different to CSS and is less intuitive,
 * so we use the measured dimensions of the SVG to reconcile these.
 */
function calcSVGTransformOrigin(dimensions, originX, originY) {
  var pxOriginX = calcOrigin$1(originX, dimensions.x, dimensions.width);
  var pxOriginY = calcOrigin$1(originY, dimensions.y, dimensions.height);
  return "".concat(pxOriginX, " ").concat(pxOriginY);
}
var dashKeys = {
  offset: "stroke-dashoffset",
  array: "stroke-dasharray"
};
var camelKeys = {
  offset: "strokeDashoffset",
  array: "strokeDasharray"
};
/**
 * Build SVG path properties. Uses the path's measured length to convert
 * our custom pathLength, pathSpacing and pathOffset into stroke-dashoffset
 * and stroke-dasharray attributes.
 *
 * This function is mutative to reduce per-frame GC.
 */
function buildSVGPath(attrs, length, spacing, offset, useDashCase) {
  if (spacing === void 0) {
    spacing = 1;
  }
  if (offset === void 0) {
    offset = 0;
  }
  if (useDashCase === void 0) {
    useDashCase = true;
  }
  // Normalise path length by setting SVG attribute pathLength to 1
  attrs.pathLength = 1;
  // We use dash case when setting attributes directly to the DOM node and camel case
  // when defining props on a React component.
  var keys = useDashCase ? dashKeys : camelKeys;
  // Build the dash offset
  attrs[keys.offset] = styleValueTypes.px.transform(-offset);
  // Build the dash array
  var pathLength = styleValueTypes.px.transform(length);
  var pathSpacing = styleValueTypes.px.transform(spacing);
  attrs[keys.array] = "".concat(pathLength, " ").concat(pathSpacing);
}

/**
 * Build SVG visual attrbutes, like cx and style.transform
 */
function buildSVGAttrs(state, _a, options, transformTemplate) {
  var attrX = _a.attrX,
    attrY = _a.attrY,
    originX = _a.originX,
    originY = _a.originY,
    pathLength = _a.pathLength,
    _b = _a.pathSpacing,
    pathSpacing = _b === void 0 ? 1 : _b,
    _c = _a.pathOffset,
    pathOffset = _c === void 0 ? 0 : _c,
    // This is object creation, which we try to avoid per-frame.
    latest = tslib.__rest(_a, ["attrX", "attrY", "originX", "originY", "pathLength", "pathSpacing", "pathOffset"]);
  buildHTMLStyles(state, latest, options, transformTemplate);
  state.attrs = state.style;
  state.style = {};
  var attrs = state.attrs,
    style = state.style,
    dimensions = state.dimensions;
  /**
   * However, we apply transforms as CSS transforms. So if we detect a transform we take it from attrs
   * and copy it into style.
   */
  if (attrs.transform) {
    if (dimensions) style.transform = attrs.transform;
    delete attrs.transform;
  }
  // Parse transformOrigin
  if (dimensions && (originX !== undefined || originY !== undefined || style.transform)) {
    style.transformOrigin = calcSVGTransformOrigin(dimensions, originX !== undefined ? originX : 0.5, originY !== undefined ? originY : 0.5);
  }
  // Treat x/y not as shortcuts but as actual attributes
  if (attrX !== undefined) attrs.x = attrX;
  if (attrY !== undefined) attrs.y = attrY;
  // Build SVG path if one has been defined
  if (pathLength !== undefined) {
    buildSVGPath(attrs, pathLength, pathSpacing, pathOffset, false);
  }
}
var createSvgRenderState = function () {
  return tslib.__assign(tslib.__assign({}, createHtmlRenderState()), {
    attrs: {}
  });
};
function useSVGProps(props, visualState) {
  var visualProps = React.useMemo(function () {
    var state = createSvgRenderState();
    buildSVGAttrs(state, visualState, {
      enableHardwareAcceleration: false
    }, props.transformTemplate);
    return tslib.__assign(tslib.__assign({}, state.attrs), {
      style: tslib.__assign({}, state.style)
    });
  }, [visualState]);
  if (props.style) {
    var rawStyles = {};
    copyRawValuesOnly(rawStyles, props.style, props);
    visualProps.style = tslib.__assign(tslib.__assign({}, rawStyles), visualProps.style);
  }
  return visualProps;
}
function createUseRender(forwardMotionProps) {
  if (forwardMotionProps === void 0) {
    forwardMotionProps = false;
  }
  var useRender = function (Component, props, projectionId, ref, _a, isStatic) {
    var latestValues = _a.latestValues;
    var useVisualProps = isSVGComponent(Component) ? useSVGProps : useHTMLProps;
    var visualProps = useVisualProps(props, latestValues, isStatic);
    var filteredProps = filterProps(props, typeof Component === "string", forwardMotionProps);
    var elementProps = tslib.__assign(tslib.__assign(tslib.__assign({}, filteredProps), visualProps), {
      ref: ref
    });
    if (projectionId) {
      elementProps["data-projection-id"] = projectionId;
    }
    return React.createElement(Component, elementProps);
  };
  return useRender;
}
var CAMEL_CASE_PATTERN = /([a-z])([A-Z])/g;
var REPLACE_TEMPLATE = "$1-$2";
/**
 * Convert camelCase to dash-case properties.
 */
var camelToDash = function (str) {
  return str.replace(CAMEL_CASE_PATTERN, REPLACE_TEMPLATE).toLowerCase();
};
function renderHTML(element, _a, styleProp, projection) {
  var style = _a.style,
    vars = _a.vars;
  Object.assign(element.style, style, projection && projection.getProjectionStyles(styleProp));
  // Loop over any CSS variables and assign those.
  for (var key in vars) {
    element.style.setProperty(key, vars[key]);
  }
}

/**
 * A set of attribute names that are always read/written as camel case.
 */
var camelCaseAttributes = new Set(["baseFrequency", "diffuseConstant", "kernelMatrix", "kernelUnitLength", "keySplines", "keyTimes", "limitingConeAngle", "markerHeight", "markerWidth", "numOctaves", "targetX", "targetY", "surfaceScale", "specularConstant", "specularExponent", "stdDeviation", "tableValues", "viewBox", "gradientTransform", "pathLength"]);
function renderSVG(element, renderState, _styleProp, projection) {
  renderHTML(element, renderState, undefined, projection);
  for (var key in renderState.attrs) {
    element.setAttribute(!camelCaseAttributes.has(key) ? camelToDash(key) : key, renderState.attrs[key]);
  }
}
function scrapeMotionValuesFromProps$1(props) {
  var style = props.style;
  var newValues = {};
  for (var key in style) {
    if (isMotionValue(style[key]) || isForcedMotionValue(key, props)) {
      newValues[key] = style[key];
    }
  }
  return newValues;
}
function scrapeMotionValuesFromProps(props) {
  var newValues = scrapeMotionValuesFromProps$1(props);
  for (var key in props) {
    if (isMotionValue(props[key])) {
      var targetKey = key === "x" || key === "y" ? "attr" + key.toUpperCase() : key;
      newValues[targetKey] = props[key];
    }
  }
  return newValues;
}
function isAnimationControls(v) {
  return typeof v === "object" && typeof v.start === "function";
}
var isKeyframesTarget = function (v) {
  return Array.isArray(v);
};
var isCustomValue = function (v) {
  return Boolean(v && typeof v === "object" && v.mix && v.toValue);
};
var resolveFinalValueInKeyframes = function (v) {
  // TODO maybe throw if v.length - 1 is placeholder token?
  return isKeyframesTarget(v) ? v[v.length - 1] || 0 : v;
};

/**
 * If the provided value is a MotionValue, this returns the actual value, otherwise just the value itself
 *
 * TODO: Remove and move to library
 */
function resolveMotionValue(value) {
  var unwrappedValue = isMotionValue(value) ? value.get() : value;
  return isCustomValue(unwrappedValue) ? unwrappedValue.toValue() : unwrappedValue;
}
function makeState(_a, props, context, presenceContext) {
  var scrapeMotionValuesFromProps = _a.scrapeMotionValuesFromProps,
    createRenderState = _a.createRenderState,
    onMount = _a.onMount;
  var state = {
    latestValues: makeLatestValues(props, context, presenceContext, scrapeMotionValuesFromProps),
    renderState: createRenderState()
  };
  if (onMount) {
    state.mount = function (instance) {
      return onMount(props, instance, state);
    };
  }
  return state;
}
var makeUseVisualState = function (config) {
  return function (props, isStatic) {
    var context = React.useContext(MotionContext);
    var presenceContext = React.useContext(PresenceContext);
    return isStatic ? makeState(config, props, context, presenceContext) : useConstant(function () {
      return makeState(config, props, context, presenceContext);
    });
  };
};
function makeLatestValues(props, context, presenceContext, scrapeMotionValues) {
  var values = {};
  var blockInitialAnimation = (presenceContext === null || presenceContext === void 0 ? void 0 : presenceContext.initial) === false;
  var motionValues = scrapeMotionValues(props);
  for (var key in motionValues) {
    values[key] = resolveMotionValue(motionValues[key]);
  }
  var initial = props.initial,
    animate = props.animate;
  var isControllingVariants = checkIfControllingVariants(props);
  var isVariantNode = checkIfVariantNode(props);
  if (context && isVariantNode && !isControllingVariants && props.inherit !== false) {
    initial !== null && initial !== void 0 ? initial : initial = context.initial;
    animate !== null && animate !== void 0 ? animate : animate = context.animate;
  }
  var initialAnimationIsBlocked = blockInitialAnimation || initial === false;
  var variantToSet = initialAnimationIsBlocked ? animate : initial;
  if (variantToSet && typeof variantToSet !== "boolean" && !isAnimationControls(variantToSet)) {
    var list = Array.isArray(variantToSet) ? variantToSet : [variantToSet];
    list.forEach(function (definition) {
      var resolved = resolveVariantFromProps(props, definition);
      if (!resolved) return;
      var transitionEnd = resolved.transitionEnd;
      resolved.transition;
      var target = tslib.__rest(resolved, ["transitionEnd", "transition"]);
      for (var key in target) {
        var valueTarget = target[key];
        if (Array.isArray(valueTarget)) {
          /**
           * Take final keyframe if the initial animation is blocked because
           * we want to initialise at the end of that blocked animation.
           */
          var index = initialAnimationIsBlocked ? valueTarget.length - 1 : 0;
          valueTarget = valueTarget[index];
        }
        if (valueTarget !== null) {
          values[key] = valueTarget;
        }
      }
      for (var key in transitionEnd) values[key] = transitionEnd[key];
    });
  }
  return values;
}
var svgMotionConfig = {
  useVisualState: makeUseVisualState({
    scrapeMotionValuesFromProps: scrapeMotionValuesFromProps,
    createRenderState: createSvgRenderState,
    onMount: function (props, instance, _a) {
      var renderState = _a.renderState,
        latestValues = _a.latestValues;
      try {
        renderState.dimensions = typeof instance.getBBox === "function" ? instance.getBBox() : instance.getBoundingClientRect();
      } catch (e) {
        // Most likely trying to measure an unrendered element under Firefox
        renderState.dimensions = {
          x: 0,
          y: 0,
          width: 0,
          height: 0
        };
      }
      buildSVGAttrs(renderState, latestValues, {
        enableHardwareAcceleration: false
      }, props.transformTemplate);
      renderSVG(instance, renderState);
    }
  })
};
var htmlMotionConfig = {
  useVisualState: makeUseVisualState({
    scrapeMotionValuesFromProps: scrapeMotionValuesFromProps$1,
    createRenderState: createHtmlRenderState
  })
};
function createDomMotionConfig(Component, _a, preloadedFeatures, createVisualElement, projectionNodeConstructor) {
  var _b = _a.forwardMotionProps,
    forwardMotionProps = _b === void 0 ? false : _b;
  var baseConfig = isSVGComponent(Component) ? svgMotionConfig : htmlMotionConfig;
  return tslib.__assign(tslib.__assign({}, baseConfig), {
    preloadedFeatures: preloadedFeatures,
    useRender: createUseRender(forwardMotionProps),
    createVisualElement: createVisualElement,
    projectionNodeConstructor: projectionNodeConstructor,
    Component: Component
  });
}
exports.AnimationType = void 0;
(function (AnimationType) {
  AnimationType["Animate"] = "animate";
  AnimationType["Hover"] = "whileHover";
  AnimationType["Tap"] = "whileTap";
  AnimationType["Drag"] = "whileDrag";
  AnimationType["Focus"] = "whileFocus";
  AnimationType["InView"] = "whileInView";
  AnimationType["Exit"] = "exit";
})(exports.AnimationType || (exports.AnimationType = {}));
function addDomEvent(target, eventName, handler, options) {
  if (options === void 0) {
    options = {
      passive: true
    };
  }
  target.addEventListener(eventName, handler, options);
  return function () {
    return target.removeEventListener(eventName, handler);
  };
}
/**
 * Attaches an event listener directly to the provided DOM element.
 *
 * Bypassing React's event system can be desirable, for instance when attaching non-passive
 * event handlers.
 *
 * ```jsx
 * const ref = useRef(null)
 *
 * useDomEvent(ref, 'wheel', onWheel, { passive: false })
 *
 * return <div ref={ref} />
 * ```
 *
 * @param ref - React.RefObject that's been provided to the element you want to bind the listener to.
 * @param eventName - Name of the event you want listen for.
 * @param handler - Function to fire when receiving the event.
 * @param options - Options to pass to `Event.addEventListener`.
 *
 * @public
 */
function useDomEvent(ref, eventName, handler, options) {
  React.useEffect(function () {
    var element = ref.current;
    if (handler && element) {
      return addDomEvent(element, eventName, handler, options);
    }
  }, [ref, eventName, handler, options]);
}

/**
 *
 * @param props
 * @param ref
 * @internal
 */
function useFocusGesture(_a) {
  var whileFocus = _a.whileFocus,
    visualElement = _a.visualElement;
  var onFocus = function () {
    var _a;
    (_a = visualElement.animationState) === null || _a === void 0 ? void 0 : _a.setActive(exports.AnimationType.Focus, true);
  };
  var onBlur = function () {
    var _a;
    (_a = visualElement.animationState) === null || _a === void 0 ? void 0 : _a.setActive(exports.AnimationType.Focus, false);
  };
  useDomEvent(visualElement, "focus", whileFocus ? onFocus : undefined);
  useDomEvent(visualElement, "blur", whileFocus ? onBlur : undefined);
}
function isMouseEvent(event) {
  // PointerEvent inherits from MouseEvent so we can't use a straight instanceof check.
  if (typeof PointerEvent !== "undefined" && event instanceof PointerEvent) {
    return !!(event.pointerType === "mouse");
  }
  return event instanceof MouseEvent;
}
function isTouchEvent(event) {
  var hasTouches = !!event.touches;
  return hasTouches;
}

/**
 * Filters out events not attached to the primary pointer (currently left mouse button)
 * @param eventHandler
 */
function filterPrimaryPointer(eventHandler) {
  return function (event) {
    var isMouseEvent = event instanceof MouseEvent;
    var isPrimaryPointer = !isMouseEvent || isMouseEvent && event.button === 0;
    if (isPrimaryPointer) {
      eventHandler(event);
    }
  };
}
var defaultPagePoint = {
  pageX: 0,
  pageY: 0
};
function pointFromTouch(e, pointType) {
  if (pointType === void 0) {
    pointType = "page";
  }
  var primaryTouch = e.touches[0] || e.changedTouches[0];
  var point = primaryTouch || defaultPagePoint;
  return {
    x: point[pointType + "X"],
    y: point[pointType + "Y"]
  };
}
function pointFromMouse(point, pointType) {
  if (pointType === void 0) {
    pointType = "page";
  }
  return {
    x: point[pointType + "X"],
    y: point[pointType + "Y"]
  };
}
function extractEventInfo(event, pointType) {
  if (pointType === void 0) {
    pointType = "page";
  }
  return {
    point: isTouchEvent(event) ? pointFromTouch(event, pointType) : pointFromMouse(event, pointType)
  };
}
var wrapHandler = function (handler, shouldFilterPrimaryPointer) {
  if (shouldFilterPrimaryPointer === void 0) {
    shouldFilterPrimaryPointer = false;
  }
  var listener = function (event) {
    return handler(event, extractEventInfo(event));
  };
  return shouldFilterPrimaryPointer ? filterPrimaryPointer(listener) : listener;
};

// We check for event support via functions in case they've been mocked by a testing suite.
var supportsPointerEvents = function () {
  return isBrowser && window.onpointerdown === null;
};
var supportsTouchEvents = function () {
  return isBrowser && window.ontouchstart === null;
};
var supportsMouseEvents = function () {
  return isBrowser && window.onmousedown === null;
};
var mouseEventNames = {
  pointerdown: "mousedown",
  pointermove: "mousemove",
  pointerup: "mouseup",
  pointercancel: "mousecancel",
  pointerover: "mouseover",
  pointerout: "mouseout",
  pointerenter: "mouseenter",
  pointerleave: "mouseleave"
};
var touchEventNames = {
  pointerdown: "touchstart",
  pointermove: "touchmove",
  pointerup: "touchend",
  pointercancel: "touchcancel"
};
function getPointerEventName(name) {
  if (supportsPointerEvents()) {
    return name;
  } else if (supportsTouchEvents()) {
    return touchEventNames[name];
  } else if (supportsMouseEvents()) {
    return mouseEventNames[name];
  }
  return name;
}
function addPointerEvent(target, eventName, handler, options) {
  return addDomEvent(target, getPointerEventName(eventName), wrapHandler(handler, eventName === "pointerdown"), options);
}
function usePointerEvent(ref, eventName, handler, options) {
  return useDomEvent(ref, getPointerEventName(eventName), handler && wrapHandler(handler, eventName === "pointerdown"), options);
}
function createLock(name) {
  var lock = null;
  return function () {
    var openLock = function () {
      lock = null;
    };
    if (lock === null) {
      lock = name;
      return openLock;
    }
    return false;
  };
}
var globalHorizontalLock = createLock("dragHorizontal");
var globalVerticalLock = createLock("dragVertical");
function getGlobalLock(drag) {
  var lock = false;
  if (drag === "y") {
    lock = globalVerticalLock();
  } else if (drag === "x") {
    lock = globalHorizontalLock();
  } else {
    var openHorizontal_1 = globalHorizontalLock();
    var openVertical_1 = globalVerticalLock();
    if (openHorizontal_1 && openVertical_1) {
      lock = function () {
        openHorizontal_1();
        openVertical_1();
      };
    } else {
      // Release the locks because we don't use them
      if (openHorizontal_1) openHorizontal_1();
      if (openVertical_1) openVertical_1();
    }
  }
  return lock;
}
function isDragActive() {
  // Check the gesture lock - if we get it, it means no drag gesture is active
  // and we can safely fire the tap gesture.
  var openGestureLock = getGlobalLock(true);
  if (!openGestureLock) return true;
  openGestureLock();
  return false;
}
function createHoverEvent(visualElement, isActive, callback) {
  return function (event, info) {
    var _a;
    if (!isMouseEvent(event) || isDragActive()) return;
    /**
     * Ensure we trigger animations before firing event callback
     */
    (_a = visualElement.animationState) === null || _a === void 0 ? void 0 : _a.setActive(exports.AnimationType.Hover, isActive);
    callback === null || callback === void 0 ? void 0 : callback(event, info);
  };
}
function useHoverGesture(_a) {
  var onHoverStart = _a.onHoverStart,
    onHoverEnd = _a.onHoverEnd,
    whileHover = _a.whileHover,
    visualElement = _a.visualElement;
  usePointerEvent(visualElement, "pointerenter", onHoverStart || whileHover ? createHoverEvent(visualElement, true, onHoverStart) : undefined, {
    passive: !onHoverStart
  });
  usePointerEvent(visualElement, "pointerleave", onHoverEnd || whileHover ? createHoverEvent(visualElement, false, onHoverEnd) : undefined, {
    passive: !onHoverEnd
  });
}

/**
 * Recursively traverse up the tree to check whether the provided child node
 * is the parent or a descendant of it.
 *
 * @param parent - Element to find
 * @param child - Element to test against parent
 */
var isNodeOrChild = function (parent, child) {
  if (!child) {
    return false;
  } else if (parent === child) {
    return true;
  } else {
    return isNodeOrChild(parent, child.parentElement);
  }
};
function useUnmountEffect(callback) {
  return React.useEffect(function () {
    return function () {
      return callback();
    };
  }, []);
}

/**
 * @param handlers -
 * @internal
 */
function useTapGesture(_a) {
  var onTap = _a.onTap,
    onTapStart = _a.onTapStart,
    onTapCancel = _a.onTapCancel,
    whileTap = _a.whileTap,
    visualElement = _a.visualElement;
  var hasPressListeners = onTap || onTapStart || onTapCancel || whileTap;
  var isPressing = React.useRef(false);
  var cancelPointerEndListeners = React.useRef(null);
  /**
   * Only set listener to passive if there are no external listeners.
   */
  var eventOptions = {
    passive: !(onTapStart || onTap || onTapCancel || onPointerDown)
  };
  function removePointerEndListener() {
    var _a;
    (_a = cancelPointerEndListeners.current) === null || _a === void 0 ? void 0 : _a.call(cancelPointerEndListeners);
    cancelPointerEndListeners.current = null;
  }
  function checkPointerEnd() {
    var _a;
    removePointerEndListener();
    isPressing.current = false;
    (_a = visualElement.animationState) === null || _a === void 0 ? void 0 : _a.setActive(exports.AnimationType.Tap, false);
    return !isDragActive();
  }
  function onPointerUp(event, info) {
    if (!checkPointerEnd()) return;
    /**
     * We only count this as a tap gesture if the event.target is the same
     * as, or a child of, this component's element
     */
    !isNodeOrChild(visualElement.getInstance(), event.target) ? onTapCancel === null || onTapCancel === void 0 ? void 0 : onTapCancel(event, info) : onTap === null || onTap === void 0 ? void 0 : onTap(event, info);
  }
  function onPointerCancel(event, info) {
    if (!checkPointerEnd()) return;
    onTapCancel === null || onTapCancel === void 0 ? void 0 : onTapCancel(event, info);
  }
  function onPointerDown(event, info) {
    var _a;
    removePointerEndListener();
    if (isPressing.current) return;
    isPressing.current = true;
    cancelPointerEndListeners.current = popmotion.pipe(addPointerEvent(window, "pointerup", onPointerUp, eventOptions), addPointerEvent(window, "pointercancel", onPointerCancel, eventOptions));
    /**
     * Ensure we trigger animations before firing event callback
     */
    (_a = visualElement.animationState) === null || _a === void 0 ? void 0 : _a.setActive(exports.AnimationType.Tap, true);
    onTapStart === null || onTapStart === void 0 ? void 0 : onTapStart(event, info);
  }
  usePointerEvent(visualElement, "pointerdown", hasPressListeners ? onPointerDown : undefined, eventOptions);
  useUnmountEffect(removePointerEndListener);
}
var warned = new Set();
function warnOnce(condition, message, element) {
  if (condition || warned.has(message)) return;
  console.warn(message);
  if (element) console.warn(element);
  warned.add(message);
}

/**
 * Map an IntersectionHandler callback to an element. We only ever make one handler for one
 * element, so even though these handlers might all be triggered by different
 * observers, we can keep them in the same map.
 */
var observerCallbacks = new WeakMap();
/**
 * Multiple observers can be created for multiple element/document roots. Each with
 * different settings. So here we store dictionaries of observers to each root,
 * using serialised settings (threshold/margin) as lookup keys.
 */
var observers = new WeakMap();
var fireObserverCallback = function (entry) {
  var _a;
  (_a = observerCallbacks.get(entry.target)) === null || _a === void 0 ? void 0 : _a(entry);
};
var fireAllObserverCallbacks = function (entries) {
  entries.forEach(fireObserverCallback);
};
function initIntersectionObserver(_a) {
  var root = _a.root,
    options = tslib.__rest(_a, ["root"]);
  var lookupRoot = root || document;
  /**
   * If we don't have an observer lookup map for this root, create one.
   */
  if (!observers.has(lookupRoot)) {
    observers.set(lookupRoot, {});
  }
  var rootObservers = observers.get(lookupRoot);
  var key = JSON.stringify(options);
  /**
   * If we don't have an observer for this combination of root and settings,
   * create one.
   */
  if (!rootObservers[key]) {
    rootObservers[key] = new IntersectionObserver(fireAllObserverCallbacks, tslib.__assign({
      root: root
    }, options));
  }
  return rootObservers[key];
}
function observeIntersection(element, options, callback) {
  var rootInteresectionObserver = initIntersectionObserver(options);
  observerCallbacks.set(element, callback);
  rootInteresectionObserver.observe(element);
  return function () {
    observerCallbacks.delete(element);
    rootInteresectionObserver.unobserve(element);
  };
}
function useViewport(_a) {
  var visualElement = _a.visualElement,
    whileInView = _a.whileInView,
    onViewportEnter = _a.onViewportEnter,
    onViewportLeave = _a.onViewportLeave,
    _b = _a.viewport,
    viewport = _b === void 0 ? {} : _b;
  var state = React.useRef({
    hasEnteredView: false,
    isInView: false
  });
  var shouldObserve = Boolean(whileInView || onViewportEnter || onViewportLeave);
  if (viewport.once && state.current.hasEnteredView) shouldObserve = false;
  var useObserver = typeof IntersectionObserver === "undefined" ? useMissingIntersectionObserver : useIntersectionObserver;
  useObserver(shouldObserve, state.current, visualElement, viewport);
}
var thresholdNames = {
  some: 0,
  all: 1
};
function useIntersectionObserver(shouldObserve, state, visualElement, _a) {
  var root = _a.root,
    rootMargin = _a.margin,
    _b = _a.amount,
    amount = _b === void 0 ? "some" : _b,
    once = _a.once;
  React.useEffect(function () {
    if (!shouldObserve) return;
    var options = {
      root: root === null || root === void 0 ? void 0 : root.current,
      rootMargin: rootMargin,
      threshold: typeof amount === "number" ? amount : thresholdNames[amount]
    };
    var intersectionCallback = function (entry) {
      var _a;
      var isIntersecting = entry.isIntersecting;
      /**
       * If there's been no change in the viewport state, early return.
       */
      if (state.isInView === isIntersecting) return;
      state.isInView = isIntersecting;
      /**
       * Handle hasEnteredView. If this is only meant to run once, and
       * element isn't visible, early return. Otherwise set hasEnteredView to true.
       */
      if (once && !isIntersecting && state.hasEnteredView) {
        return;
      } else if (isIntersecting) {
        state.hasEnteredView = true;
      }
      (_a = visualElement.animationState) === null || _a === void 0 ? void 0 : _a.setActive(exports.AnimationType.InView, isIntersecting);
      /**
       * Use the latest committed props rather than the ones in scope
       * when this observer is created
       */
      var props = visualElement.getProps();
      var callback = isIntersecting ? props.onViewportEnter : props.onViewportLeave;
      callback === null || callback === void 0 ? void 0 : callback(entry);
    };
    return observeIntersection(visualElement.getInstance(), options, intersectionCallback);
  }, [shouldObserve, root, rootMargin, amount]);
}
/**
 * If IntersectionObserver is missing, we activate inView and fire onViewportEnter
 * on mount. This way, the page will be in the state the author expects users
 * to see it in for everyone.
 */
function useMissingIntersectionObserver(shouldObserve, state, visualElement, _a) {
  var _b = _a.fallback,
    fallback = _b === void 0 ? true : _b;
  React.useEffect(function () {
    if (!shouldObserve || !fallback) return;
    if (env !== "production") {
      warnOnce(false, "IntersectionObserver not available on this device. whileInView animations will trigger on mount.");
    }
    /**
     * Fire this in an rAF because, at this point, the animation state
     * won't have flushed for the first time and there's certain logic in
     * there that behaves differently on the initial animation.
     *
     * This hook should be quite rarely called so setting this in an rAF
     * is preferred to changing the behaviour of the animation state.
     */
    requestAnimationFrame(function () {
      var _a;
      state.hasEnteredView = true;
      var onViewportEnter = visualElement.getProps().onViewportEnter;
      onViewportEnter === null || onViewportEnter === void 0 ? void 0 : onViewportEnter(null);
      (_a = visualElement.animationState) === null || _a === void 0 ? void 0 : _a.setActive(exports.AnimationType.InView, true);
    });
  }, [shouldObserve]);
}
var makeRenderlessComponent = function (hook) {
  return function (props) {
    hook(props);
    return null;
  };
};
var gestureAnimations = {
  inView: makeRenderlessComponent(useViewport),
  tap: makeRenderlessComponent(useTapGesture),
  focus: makeRenderlessComponent(useFocusGesture),
  hover: makeRenderlessComponent(useHoverGesture)
};
var counter = 0;
var incrementId = function () {
  return counter++;
};
var useId = function () {
  return useConstant(incrementId);
};
/**
 * Ideally we'd use the following code to support React 18 optionally.
 * But this fairly fails in Webpack (otherwise treeshaking wouldn't work at all).
 * Need to come up with a different way of figuring this out.
 */
// export const useId = (React as any).useId
//     ? (React as any).useId
//     : () => useConstant(incrementId)

/**
 * When a component is the child of `AnimatePresence`, it can use `usePresence`
 * to access information about whether it's still present in the React tree.
 *
 * ```jsx
 * import { usePresence } from "framer-motion"
 *
 * export const Component = () => {
 *   const [isPresent, safeToRemove] = usePresence()
 *
 *   useEffect(() => {
 *     !isPresent && setTimeout(safeToRemove, 1000)
 *   }, [isPresent])
 *
 *   return <div />
 * }
 * ```
 *
 * If `isPresent` is `false`, it means that a component has been removed the tree, but
 * `AnimatePresence` won't really remove it until `safeToRemove` has been called.
 *
 * @public
 */
function usePresence() {
  var context = React.useContext(PresenceContext);
  if (context === null) return [true, null];
  var isPresent = context.isPresent,
    onExitComplete = context.onExitComplete,
    register = context.register;
  // It's safe to call the following hooks conditionally (after an early return) because the context will always
  // either be null or non-null for the lifespan of the component.
  // Replace with useId when released in React
  var id = useId();
  React.useEffect(function () {
    return register(id);
  }, []);
  var safeToRemove = function () {
    return onExitComplete === null || onExitComplete === void 0 ? void 0 : onExitComplete(id);
  };
  return !isPresent && onExitComplete ? [false, safeToRemove] : [true];
}
/**
 * Similar to `usePresence`, except `useIsPresent` simply returns whether or not the component is present.
 * There is no `safeToRemove` function.
 *
 * ```jsx
 * import { useIsPresent } from "framer-motion"
 *
 * export const Component = () => {
 *   const isPresent = useIsPresent()
 *
 *   useEffect(() => {
 *     !isPresent && console.log("I've been removed!")
 *   }, [isPresent])
 *
 *   return <div />
 * }
 * ```
 *
 * @public
 */
function useIsPresent() {
  return isPresent(React.useContext(PresenceContext));
}
function isPresent(context) {
  return context === null ? true : context.isPresent;
}
function shallowCompare(next, prev) {
  if (!Array.isArray(prev)) return false;
  var prevLength = prev.length;
  if (prevLength !== next.length) return false;
  for (var i = 0; i < prevLength; i++) {
    if (prev[i] !== next[i]) return false;
  }
  return true;
}

/**
 * Converts seconds to milliseconds
 *
 * @param seconds - Time in seconds.
 * @return milliseconds - Converted time in milliseconds.
 */
var secondsToMilliseconds = function (seconds) {
  return seconds * 1000;
};
var easingLookup = {
  linear: popmotion.linear,
  easeIn: popmotion.easeIn,
  easeInOut: popmotion.easeInOut,
  easeOut: popmotion.easeOut,
  circIn: popmotion.circIn,
  circInOut: popmotion.circInOut,
  circOut: popmotion.circOut,
  backIn: popmotion.backIn,
  backInOut: popmotion.backInOut,
  backOut: popmotion.backOut,
  anticipate: popmotion.anticipate,
  bounceIn: popmotion.bounceIn,
  bounceInOut: popmotion.bounceInOut,
  bounceOut: popmotion.bounceOut
};
var easingDefinitionToFunction = function (definition) {
  if (Array.isArray(definition)) {
    // If cubic bezier definition, create bezier curve
    heyListen.invariant(definition.length === 4, "Cubic bezier arrays must contain four numerical values.");
    var _a = tslib.__read(definition, 4),
      x1 = _a[0],
      y1 = _a[1],
      x2 = _a[2],
      y2 = _a[3];
    return popmotion.cubicBezier(x1, y1, x2, y2);
  } else if (typeof definition === "string") {
    // Else lookup from table
    heyListen.invariant(easingLookup[definition] !== undefined, "Invalid easing type '".concat(definition, "'"));
    return easingLookup[definition];
  }
  return definition;
};
var isEasingArray = function (ease) {
  return Array.isArray(ease) && typeof ease[0] !== "number";
};

/**
 * Check if a value is animatable. Examples:
 *
 * ✅: 100, "100px", "#fff"
 * ❌: "block", "url(2.jpg)"
 * @param value
 *
 * @internal
 */
var isAnimatable = function (key, value) {
  // If the list of keys tat might be non-animatable grows, replace with Set
  if (key === "zIndex") return false;
  // If it's a number or a keyframes array, we can animate it. We might at some point
  // need to do a deep isAnimatable check of keyframes, or let Popmotion handle this,
  // but for now lets leave it like this for performance reasons
  if (typeof value === "number" || Array.isArray(value)) return true;
  if (typeof value === "string" &&
  // It's animatable if we have a string
  styleValueTypes.complex.test(value) &&
  // And it contains numbers and/or colors
  !value.startsWith("url(") // Unless it starts with "url("
  ) {
    return true;
  }
  return false;
};
var underDampedSpring = function () {
  return {
    type: "spring",
    stiffness: 500,
    damping: 25,
    restSpeed: 10
  };
};
var criticallyDampedSpring = function (to) {
  return {
    type: "spring",
    stiffness: 550,
    damping: to === 0 ? 2 * Math.sqrt(550) : 30,
    restSpeed: 10
  };
};
var linearTween = function () {
  return {
    type: "keyframes",
    ease: "linear",
    duration: 0.3
  };
};
var keyframes = function (values) {
  return {
    type: "keyframes",
    duration: 0.8,
    values: values
  };
};
var defaultTransitions = {
  x: underDampedSpring,
  y: underDampedSpring,
  z: underDampedSpring,
  rotate: underDampedSpring,
  rotateX: underDampedSpring,
  rotateY: underDampedSpring,
  rotateZ: underDampedSpring,
  scaleX: criticallyDampedSpring,
  scaleY: criticallyDampedSpring,
  scale: criticallyDampedSpring,
  opacity: linearTween,
  backgroundColor: linearTween,
  color: linearTween,
  default: criticallyDampedSpring
};
var getDefaultTransition = function (valueKey, to) {
  var transitionFactory;
  if (isKeyframesTarget(to)) {
    transitionFactory = keyframes;
  } else {
    transitionFactory = defaultTransitions[valueKey] || defaultTransitions.default;
  }
  return tslib.__assign({
    to: to
  }, transitionFactory(to));
};

/**
 * A map of default value types for common values
 */
var defaultValueTypes = tslib.__assign(tslib.__assign({}, numberValueTypes), {
  // Color props
  color: styleValueTypes.color,
  backgroundColor: styleValueTypes.color,
  outlineColor: styleValueTypes.color,
  fill: styleValueTypes.color,
  stroke: styleValueTypes.color,
  // Border props
  borderColor: styleValueTypes.color,
  borderTopColor: styleValueTypes.color,
  borderRightColor: styleValueTypes.color,
  borderBottomColor: styleValueTypes.color,
  borderLeftColor: styleValueTypes.color,
  filter: styleValueTypes.filter,
  WebkitFilter: styleValueTypes.filter
});
/**
 * Gets the default ValueType for the provided value key
 */
var getDefaultValueType = function (key) {
  return defaultValueTypes[key];
};
function getAnimatableNone(key, value) {
  var _a;
  var defaultValueType = getDefaultValueType(key);
  if (defaultValueType !== styleValueTypes.filter) defaultValueType = styleValueTypes.complex;
  // If value is not recognised as animatable, ie "none", create an animatable version origin based on the target
  return (_a = defaultValueType.getAnimatableNone) === null || _a === void 0 ? void 0 : _a.call(defaultValueType, value);
}
var instantAnimationState = {
  current: false
};

/**
 * Decide whether a transition is defined on a given Transition.
 * This filters out orchestration options and returns true
 * if any options are left.
 */
function isTransitionDefined(_a) {
  _a.when;
  _a.delay;
  _a.delayChildren;
  _a.staggerChildren;
  _a.staggerDirection;
  _a.repeat;
  _a.repeatType;
  _a.repeatDelay;
  _a.from;
  var transition = tslib.__rest(_a, ["when", "delay", "delayChildren", "staggerChildren", "staggerDirection", "repeat", "repeatType", "repeatDelay", "from"]);
  return !!Object.keys(transition).length;
}
var legacyRepeatWarning = false;
/**
 * Convert Framer Motion's Transition type into Popmotion-compatible options.
 */
function convertTransitionToAnimationOptions(_a) {
  var ease = _a.ease,
    times = _a.times,
    yoyo = _a.yoyo,
    flip = _a.flip,
    loop = _a.loop,
    transition = tslib.__rest(_a, ["ease", "times", "yoyo", "flip", "loop"]);
  var options = tslib.__assign({}, transition);
  if (times) options["offset"] = times;
  /**
   * Convert any existing durations from seconds to milliseconds
   */
  if (transition.duration) options["duration"] = secondsToMilliseconds(transition.duration);
  if (transition.repeatDelay) options.repeatDelay = secondsToMilliseconds(transition.repeatDelay);
  /**
   * Map easing names to Popmotion's easing functions
   */
  if (ease) {
    options["ease"] = isEasingArray(ease) ? ease.map(easingDefinitionToFunction) : easingDefinitionToFunction(ease);
  }
  /**
   * Support legacy transition API
   */
  if (transition.type === "tween") options.type = "keyframes";
  /**
   * TODO: These options are officially removed from the API.
   */
  if (yoyo || loop || flip) {
    heyListen.warning(!legacyRepeatWarning, "yoyo, loop and flip have been removed from the API. Replace with repeat and repeatType options.");
    legacyRepeatWarning = true;
    if (yoyo) {
      options.repeatType = "reverse";
    } else if (loop) {
      options.repeatType = "loop";
    } else if (flip) {
      options.repeatType = "mirror";
    }
    options.repeat = loop || yoyo || flip || transition.repeat;
  }
  /**
   * TODO: Popmotion 9 has the ability to automatically detect whether to use
   * a keyframes or spring animation, but does so by detecting velocity and other spring options.
   * It'd be good to introduce a similar thing here.
   */
  if (transition.type !== "spring") options.type = "keyframes";
  return options;
}
/**
 * Get the delay for a value by checking Transition with decreasing specificity.
 */
function getDelayFromTransition(transition, key) {
  var _a, _b;
  var valueTransition = getValueTransition(transition, key) || {};
  return (_b = (_a = valueTransition.delay) !== null && _a !== void 0 ? _a : transition.delay) !== null && _b !== void 0 ? _b : 0;
}
function hydrateKeyframes(options) {
  if (Array.isArray(options.to) && options.to[0] === null) {
    options.to = tslib.__spreadArray([], tslib.__read(options.to), false);
    options.to[0] = options.from;
  }
  return options;
}
function getPopmotionAnimationOptions(transition, options, key) {
  var _a;
  if (Array.isArray(options.to)) {
    (_a = transition.duration) !== null && _a !== void 0 ? _a : transition.duration = 0.8;
  }
  hydrateKeyframes(options);
  /**
   * Get a default transition if none is determined to be defined.
   */
  if (!isTransitionDefined(transition)) {
    transition = tslib.__assign(tslib.__assign({}, transition), getDefaultTransition(key, options.to));
  }
  return tslib.__assign(tslib.__assign({}, options), convertTransitionToAnimationOptions(transition));
}
/**
 *
 */
function getAnimation(key, value, target, transition, onComplete) {
  var _a;
  var valueTransition = getValueTransition(transition, key);
  var origin = (_a = valueTransition.from) !== null && _a !== void 0 ? _a : value.get();
  var isTargetAnimatable = isAnimatable(key, target);
  if (origin === "none" && isTargetAnimatable && typeof target === "string") {
    /**
     * If we're trying to animate from "none", try and get an animatable version
     * of the target. This could be improved to work both ways.
     */
    origin = getAnimatableNone(key, target);
  } else if (isZero(origin) && typeof target === "string") {
    origin = getZeroUnit(target);
  } else if (!Array.isArray(target) && isZero(target) && typeof origin === "string") {
    target = getZeroUnit(origin);
  }
  var isOriginAnimatable = isAnimatable(key, origin);
  heyListen.warning(isOriginAnimatable === isTargetAnimatable, "You are trying to animate ".concat(key, " from \"").concat(origin, "\" to \"").concat(target, "\". ").concat(origin, " is not an animatable value - to enable this animation set ").concat(origin, " to a value animatable to ").concat(target, " via the `style` property."));
  function start() {
    var options = {
      from: origin,
      to: target,
      velocity: value.getVelocity(),
      onComplete: onComplete,
      onUpdate: function (v) {
        return value.set(v);
      }
    };
    return valueTransition.type === "inertia" || valueTransition.type === "decay" ? popmotion.inertia(tslib.__assign(tslib.__assign({}, options), valueTransition)) : popmotion.animate(tslib.__assign(tslib.__assign({}, getPopmotionAnimationOptions(valueTransition, options, key)), {
      onUpdate: function (v) {
        var _a;
        options.onUpdate(v);
        (_a = valueTransition.onUpdate) === null || _a === void 0 ? void 0 : _a.call(valueTransition, v);
      },
      onComplete: function () {
        var _a;
        options.onComplete();
        (_a = valueTransition.onComplete) === null || _a === void 0 ? void 0 : _a.call(valueTransition);
      }
    }));
  }
  function set() {
    var _a, _b;
    var finalTarget = resolveFinalValueInKeyframes(target);
    value.set(finalTarget);
    onComplete();
    (_a = valueTransition === null || valueTransition === void 0 ? void 0 : valueTransition.onUpdate) === null || _a === void 0 ? void 0 : _a.call(valueTransition, finalTarget);
    (_b = valueTransition === null || valueTransition === void 0 ? void 0 : valueTransition.onComplete) === null || _b === void 0 ? void 0 : _b.call(valueTransition);
    return {
      stop: function () {}
    };
  }
  return !isOriginAnimatable || !isTargetAnimatable || valueTransition.type === false ? set : start;
}
function isZero(value) {
  return value === 0 || typeof value === "string" && parseFloat(value) === 0 && value.indexOf(" ") === -1;
}
function getZeroUnit(potentialUnitType) {
  return typeof potentialUnitType === "number" ? 0 : getAnimatableNone("", potentialUnitType);
}
function getValueTransition(transition, key) {
  return transition[key] || transition["default"] || transition;
}
/**
 * Start animation on a MotionValue. This function is an interface between
 * Framer Motion and Popmotion
 */
function startAnimation(key, value, target, transition) {
  if (transition === void 0) {
    transition = {};
  }
  if (instantAnimationState.current) {
    transition = {
      type: false
    };
  }
  return value.start(function (onComplete) {
    var delayTimer;
    var controls;
    var animation = getAnimation(key, value, target, transition, onComplete);
    var delay = getDelayFromTransition(transition, key);
    var start = function () {
      return controls = animation();
    };
    if (delay) {
      delayTimer = window.setTimeout(start, secondsToMilliseconds(delay));
    } else {
      start();
    }
    return function () {
      clearTimeout(delayTimer);
      controls === null || controls === void 0 ? void 0 : controls.stop();
    };
  });
}

/**
 * Check if value is a numerical string, ie a string that is purely a number eg "100" or "-100.1"
 */
var isNumericalString = function (v) {
  return /^\-?\d*\.?\d+$/.test(v);
};

/**
 * Check if the value is a zero value string like "0px" or "0%"
 */
var isZeroValueString = function (v) {
  return /^0[^.\s]+$/.test(v);
};
function addUniqueItem(arr, item) {
  arr.indexOf(item) === -1 && arr.push(item);
}
function removeItem(arr, item) {
  var index = arr.indexOf(item);
  index > -1 && arr.splice(index, 1);
}
// Adapted from array-move
function moveItem(_a, fromIndex, toIndex) {
  var _b = tslib.__read(_a),
    arr = _b.slice(0);
  var startIndex = fromIndex < 0 ? arr.length + fromIndex : fromIndex;
  if (startIndex >= 0 && startIndex < arr.length) {
    var endIndex = toIndex < 0 ? arr.length + toIndex : toIndex;
    var _c = tslib.__read(arr.splice(fromIndex, 1), 1),
      item = _c[0];
    arr.splice(endIndex, 0, item);
  }
  return arr;
}
var SubscriptionManager = /** @class */function () {
  function SubscriptionManager() {
    this.subscriptions = [];
  }
  SubscriptionManager.prototype.add = function (handler) {
    var _this = this;
    addUniqueItem(this.subscriptions, handler);
    return function () {
      return removeItem(_this.subscriptions, handler);
    };
  };
  SubscriptionManager.prototype.notify = function (a, b, c) {
    var numSubscriptions = this.subscriptions.length;
    if (!numSubscriptions) return;
    if (numSubscriptions === 1) {
      /**
       * If there's only a single handler we can just call it without invoking a loop.
       */
      this.subscriptions[0](a, b, c);
    } else {
      for (var i = 0; i < numSubscriptions; i++) {
        /**
         * Check whether the handler exists before firing as it's possible
         * the subscriptions were modified during this loop running.
         */
        var handler = this.subscriptions[i];
        handler && handler(a, b, c);
      }
    }
  };
  SubscriptionManager.prototype.getSize = function () {
    return this.subscriptions.length;
  };
  SubscriptionManager.prototype.clear = function () {
    this.subscriptions.length = 0;
  };
  return SubscriptionManager;
}();
var isFloat = function (value) {
  return !isNaN(parseFloat(value));
};
/**
 * `MotionValue` is used to track the state and velocity of motion values.
 *
 * @public
 */
var MotionValue = /** @class */function () {
  /**
   * @param init - The initiating value
   * @param config - Optional configuration options
   *
   * -  `transformer`: A function to transform incoming values with.
   *
   * @internal
   */
  function MotionValue(init) {
    var _this = this;
    /**
     * This will be replaced by the build step with the latest version number.
     * When MotionValues are provided to motion components, warn if versions are mixed.
     */
    this.version = "6.5.1";
    /**
     * Duration, in milliseconds, since last updating frame.
     *
     * @internal
     */
    this.timeDelta = 0;
    /**
     * Timestamp of the last time this `MotionValue` was updated.
     *
     * @internal
     */
    this.lastUpdated = 0;
    /**
     * Functions to notify when the `MotionValue` updates.
     *
     * @internal
     */
    this.updateSubscribers = new SubscriptionManager();
    /**
     * Functions to notify when the velocity updates.
     *
     * @internal
     */
    this.velocityUpdateSubscribers = new SubscriptionManager();
    /**
     * Functions to notify when the `MotionValue` updates and `render` is set to `true`.
     *
     * @internal
     */
    this.renderSubscribers = new SubscriptionManager();
    /**
     * Tracks whether this value can output a velocity. Currently this is only true
     * if the value is numerical, but we might be able to widen the scope here and support
     * other value types.
     *
     * @internal
     */
    this.canTrackVelocity = false;
    this.updateAndNotify = function (v, render) {
      if (render === void 0) {
        render = true;
      }
      _this.prev = _this.current;
      _this.current = v;
      // Update timestamp
      var _a = sync.getFrameData(),
        delta = _a.delta,
        timestamp = _a.timestamp;
      if (_this.lastUpdated !== timestamp) {
        _this.timeDelta = delta;
        _this.lastUpdated = timestamp;
        sync__default["default"].postRender(_this.scheduleVelocityCheck);
      }
      // Update update subscribers
      if (_this.prev !== _this.current) {
        _this.updateSubscribers.notify(_this.current);
      }
      // Update velocity subscribers
      if (_this.velocityUpdateSubscribers.getSize()) {
        _this.velocityUpdateSubscribers.notify(_this.getVelocity());
      }
      // Update render subscribers
      if (render) {
        _this.renderSubscribers.notify(_this.current);
      }
    };
    /**
     * Schedule a velocity check for the next frame.
     *
     * This is an instanced and bound function to prevent generating a new
     * function once per frame.
     *
     * @internal
     */
    this.scheduleVelocityCheck = function () {
      return sync__default["default"].postRender(_this.velocityCheck);
    };
    /**
     * Updates `prev` with `current` if the value hasn't been updated this frame.
     * This ensures velocity calculations return `0`.
     *
     * This is an instanced and bound function to prevent generating a new
     * function once per frame.
     *
     * @internal
     */
    this.velocityCheck = function (_a) {
      var timestamp = _a.timestamp;
      if (timestamp !== _this.lastUpdated) {
        _this.prev = _this.current;
        _this.velocityUpdateSubscribers.notify(_this.getVelocity());
      }
    };
    this.hasAnimated = false;
    this.prev = this.current = init;
    this.canTrackVelocity = isFloat(this.current);
  }
  /**
   * Adds a function that will be notified when the `MotionValue` is updated.
   *
   * It returns a function that, when called, will cancel the subscription.
   *
   * When calling `onChange` inside a React component, it should be wrapped with the
   * `useEffect` hook. As it returns an unsubscribe function, this should be returned
   * from the `useEffect` function to ensure you don't add duplicate subscribers..
   *
   * ```jsx
   * export const MyComponent = () => {
   *   const x = useMotionValue(0)
   *   const y = useMotionValue(0)
   *   const opacity = useMotionValue(1)
   *
   *   useEffect(() => {
   *     function updateOpacity() {
   *       const maxXY = Math.max(x.get(), y.get())
   *       const newOpacity = transform(maxXY, [0, 100], [1, 0])
   *       opacity.set(newOpacity)
   *     }
   *
   *     const unsubscribeX = x.onChange(updateOpacity)
   *     const unsubscribeY = y.onChange(updateOpacity)
   *
   *     return () => {
   *       unsubscribeX()
   *       unsubscribeY()
   *     }
   *   }, [])
   *
   *   return <motion.div style={{ x }} />
   * }
   * ```
   *
   * @privateRemarks
   *
   * We could look into a `useOnChange` hook if the above lifecycle management proves confusing.
   *
   * ```jsx
   * useOnChange(x, () => {})
   * ```
   *
   * @param subscriber - A function that receives the latest value.
   * @returns A function that, when called, will cancel this subscription.
   *
   * @public
   */
  MotionValue.prototype.onChange = function (subscription) {
    return this.updateSubscribers.add(subscription);
  };
  MotionValue.prototype.clearListeners = function () {
    this.updateSubscribers.clear();
  };
  /**
   * Adds a function that will be notified when the `MotionValue` requests a render.
   *
   * @param subscriber - A function that's provided the latest value.
   * @returns A function that, when called, will cancel this subscription.
   *
   * @internal
   */
  MotionValue.prototype.onRenderRequest = function (subscription) {
    // Render immediately
    subscription(this.get());
    return this.renderSubscribers.add(subscription);
  };
  /**
   * Attaches a passive effect to the `MotionValue`.
   *
   * @internal
   */
  MotionValue.prototype.attach = function (passiveEffect) {
    this.passiveEffect = passiveEffect;
  };
  /**
   * Sets the state of the `MotionValue`.
   *
   * @remarks
   *
   * ```jsx
   * const x = useMotionValue(0)
   * x.set(10)
   * ```
   *
   * @param latest - Latest value to set.
   * @param render - Whether to notify render subscribers. Defaults to `true`
   *
   * @public
   */
  MotionValue.prototype.set = function (v, render) {
    if (render === void 0) {
      render = true;
    }
    if (!render || !this.passiveEffect) {
      this.updateAndNotify(v, render);
    } else {
      this.passiveEffect(v, this.updateAndNotify);
    }
  };
  /**
   * Returns the latest state of `MotionValue`
   *
   * @returns - The latest state of `MotionValue`
   *
   * @public
   */
  MotionValue.prototype.get = function () {
    return this.current;
  };
  /**
   * @public
   */
  MotionValue.prototype.getPrevious = function () {
    return this.prev;
  };
  /**
   * Returns the latest velocity of `MotionValue`
   *
   * @returns - The latest velocity of `MotionValue`. Returns `0` if the state is non-numerical.
   *
   * @public
   */
  MotionValue.prototype.getVelocity = function () {
    // This could be isFloat(this.prev) && isFloat(this.current), but that would be wasteful
    return this.canTrackVelocity ?
    // These casts could be avoided if parseFloat would be typed better
    popmotion.velocityPerSecond(parseFloat(this.current) - parseFloat(this.prev), this.timeDelta) : 0;
  };
  /**
   * Registers a new animation to control this `MotionValue`. Only one
   * animation can drive a `MotionValue` at one time.
   *
   * ```jsx
   * value.start()
   * ```
   *
   * @param animation - A function that starts the provided animation
   *
   * @internal
   */
  MotionValue.prototype.start = function (animation) {
    var _this = this;
    this.stop();
    return new Promise(function (resolve) {
      _this.hasAnimated = true;
      _this.stopAnimation = animation(resolve);
    }).then(function () {
      return _this.clearAnimation();
    });
  };
  /**
   * Stop the currently active animation.
   *
   * @public
   */
  MotionValue.prototype.stop = function () {
    if (this.stopAnimation) this.stopAnimation();
    this.clearAnimation();
  };
  /**
   * Returns `true` if this value is currently animating.
   *
   * @public
   */
  MotionValue.prototype.isAnimating = function () {
    return !!this.stopAnimation;
  };
  MotionValue.prototype.clearAnimation = function () {
    this.stopAnimation = null;
  };
  /**
   * Destroy and clean up subscribers to this `MotionValue`.
   *
   * The `MotionValue` hooks like `useMotionValue` and `useTransform` automatically
   * handle the lifecycle of the returned `MotionValue`, so this method is only necessary if you've manually
   * created a `MotionValue` via the `motionValue` function.
   *
   * @public
   */
  MotionValue.prototype.destroy = function () {
    this.updateSubscribers.clear();
    this.renderSubscribers.clear();
    this.stop();
  };
  return MotionValue;
}();
function motionValue(init) {
  return new MotionValue(init);
}

/**
 * Tests a provided value against a ValueType
 */
var testValueType = function (v) {
  return function (type) {
    return type.test(v);
  };
};

/**
 * ValueType for "auto"
 */
var auto = {
  test: function (v) {
    return v === "auto";
  },
  parse: function (v) {
    return v;
  }
};

/**
 * A list of value types commonly used for dimensions
 */
var dimensionValueTypes = [styleValueTypes.number, styleValueTypes.px, styleValueTypes.percent, styleValueTypes.degrees, styleValueTypes.vw, styleValueTypes.vh, auto];
/**
 * Tests a dimensional value against the list of dimension ValueTypes
 */
var findDimensionValueType = function (v) {
  return dimensionValueTypes.find(testValueType(v));
};

/**
 * A list of all ValueTypes
 */
var valueTypes = tslib.__spreadArray(tslib.__spreadArray([], tslib.__read(dimensionValueTypes), false), [styleValueTypes.color, styleValueTypes.complex], false);
/**
 * Tests a value against the list of ValueTypes
 */
var findValueType = function (v) {
  return valueTypes.find(testValueType(v));
};

/**
 * Set VisualElement's MotionValue, creating a new MotionValue for it if
 * it doesn't exist.
 */
function setMotionValue(visualElement, key, value) {
  if (visualElement.hasValue(key)) {
    visualElement.getValue(key).set(value);
  } else {
    visualElement.addValue(key, motionValue(value));
  }
}
function setTarget(visualElement, definition) {
  var resolved = resolveVariant(visualElement, definition);
  var _a = resolved ? visualElement.makeTargetAnimatable(resolved, false) : {},
    _b = _a.transitionEnd,
    transitionEnd = _b === void 0 ? {} : _b;
  _a.transition;
  var target = tslib.__rest(_a, ["transitionEnd", "transition"]);
  target = tslib.__assign(tslib.__assign({}, target), transitionEnd);
  for (var key in target) {
    var value = resolveFinalValueInKeyframes(target[key]);
    setMotionValue(visualElement, key, value);
  }
}
function setVariants(visualElement, variantLabels) {
  var reversedLabels = tslib.__spreadArray([], tslib.__read(variantLabels), false).reverse();
  reversedLabels.forEach(function (key) {
    var _a;
    var variant = visualElement.getVariant(key);
    variant && setTarget(visualElement, variant);
    (_a = visualElement.variantChildren) === null || _a === void 0 ? void 0 : _a.forEach(function (child) {
      setVariants(child, variantLabels);
    });
  });
}
function setValues(visualElement, definition) {
  if (Array.isArray(definition)) {
    return setVariants(visualElement, definition);
  } else if (typeof definition === "string") {
    return setVariants(visualElement, [definition]);
  } else {
    setTarget(visualElement, definition);
  }
}
function checkTargetForNewValues(visualElement, target, origin) {
  var _a, _b, _c;
  var _d;
  var newValueKeys = Object.keys(target).filter(function (key) {
    return !visualElement.hasValue(key);
  });
  var numNewValues = newValueKeys.length;
  if (!numNewValues) return;
  for (var i = 0; i < numNewValues; i++) {
    var key = newValueKeys[i];
    var targetValue = target[key];
    var value = null;
    /**
     * If the target is a series of keyframes, we can use the first value
     * in the array. If this first value is null, we'll still need to read from the DOM.
     */
    if (Array.isArray(targetValue)) {
      value = targetValue[0];
    }
    /**
     * If the target isn't keyframes, or the first keyframe was null, we need to
     * first check if an origin value was explicitly defined in the transition as "from",
     * if not read the value from the DOM. As an absolute fallback, take the defined target value.
     */
    if (value === null) {
      value = (_b = (_a = origin[key]) !== null && _a !== void 0 ? _a : visualElement.readValue(key)) !== null && _b !== void 0 ? _b : target[key];
    }
    /**
     * If value is still undefined or null, ignore it. Preferably this would throw,
     * but this was causing issues in Framer.
     */
    if (value === undefined || value === null) continue;
    if (typeof value === "string" && (isNumericalString(value) || isZeroValueString(value))) {
      // If this is a number read as a string, ie "0" or "200", convert it to a number
      value = parseFloat(value);
    } else if (!findValueType(value) && styleValueTypes.complex.test(targetValue)) {
      value = getAnimatableNone(key, targetValue);
    }
    visualElement.addValue(key, motionValue(value));
    (_c = (_d = origin)[key]) !== null && _c !== void 0 ? _c : _d[key] = value;
    visualElement.setBaseTarget(key, value);
  }
}
function getOriginFromTransition(key, transition) {
  if (!transition) return;
  var valueTransition = transition[key] || transition["default"] || transition;
  return valueTransition.from;
}
function getOrigin(target, transition, visualElement) {
  var _a, _b;
  var origin = {};
  for (var key in target) {
    origin[key] = (_a = getOriginFromTransition(key, transition)) !== null && _a !== void 0 ? _a : (_b = visualElement.getValue(key)) === null || _b === void 0 ? void 0 : _b.get();
  }
  return origin;
}
function animateVisualElement(visualElement, definition, options) {
  if (options === void 0) {
    options = {};
  }
  visualElement.notifyAnimationStart(definition);
  var animation;
  if (Array.isArray(definition)) {
    var animations = definition.map(function (variant) {
      return animateVariant(visualElement, variant, options);
    });
    animation = Promise.all(animations);
  } else if (typeof definition === "string") {
    animation = animateVariant(visualElement, definition, options);
  } else {
    var resolvedDefinition = typeof definition === "function" ? resolveVariant(visualElement, definition, options.custom) : definition;
    animation = animateTarget(visualElement, resolvedDefinition, options);
  }
  return animation.then(function () {
    return visualElement.notifyAnimationComplete(definition);
  });
}
function animateVariant(visualElement, variant, options) {
  var _a;
  if (options === void 0) {
    options = {};
  }
  var resolved = resolveVariant(visualElement, variant, options.custom);
  var _b = (resolved || {}).transition,
    transition = _b === void 0 ? visualElement.getDefaultTransition() || {} : _b;
  if (options.transitionOverride) {
    transition = options.transitionOverride;
  }
  /**
   * If we have a variant, create a callback that runs it as an animation.
   * Otherwise, we resolve a Promise immediately for a composable no-op.
   */
  var getAnimation = resolved ? function () {
    return animateTarget(visualElement, resolved, options);
  } : function () {
    return Promise.resolve();
  };
  /**
   * If we have children, create a callback that runs all their animations.
   * Otherwise, we resolve a Promise immediately for a composable no-op.
   */
  var getChildAnimations = ((_a = visualElement.variantChildren) === null || _a === void 0 ? void 0 : _a.size) ? function (forwardDelay) {
    if (forwardDelay === void 0) {
      forwardDelay = 0;
    }
    var _a = transition.delayChildren,
      delayChildren = _a === void 0 ? 0 : _a,
      staggerChildren = transition.staggerChildren,
      staggerDirection = transition.staggerDirection;
    return animateChildren(visualElement, variant, delayChildren + forwardDelay, staggerChildren, staggerDirection, options);
  } : function () {
    return Promise.resolve();
  };
  /**
   * If the transition explicitly defines a "when" option, we need to resolve either
   * this animation or all children animations before playing the other.
   */
  var when = transition.when;
  if (when) {
    var _c = tslib.__read(when === "beforeChildren" ? [getAnimation, getChildAnimations] : [getChildAnimations, getAnimation], 2),
      first = _c[0],
      last = _c[1];
    return first().then(last);
  } else {
    return Promise.all([getAnimation(), getChildAnimations(options.delay)]);
  }
}
/**
 * @internal
 */
function animateTarget(visualElement, definition, _a) {
  var _b;
  var _c = _a === void 0 ? {} : _a,
    _d = _c.delay,
    delay = _d === void 0 ? 0 : _d,
    transitionOverride = _c.transitionOverride,
    type = _c.type;
  var _e = visualElement.makeTargetAnimatable(definition),
    _f = _e.transition,
    transition = _f === void 0 ? visualElement.getDefaultTransition() : _f,
    transitionEnd = _e.transitionEnd,
    target = tslib.__rest(_e, ["transition", "transitionEnd"]);
  if (transitionOverride) transition = transitionOverride;
  var animations = [];
  var animationTypeState = type && ((_b = visualElement.animationState) === null || _b === void 0 ? void 0 : _b.getState()[type]);
  for (var key in target) {
    var value = visualElement.getValue(key);
    var valueTarget = target[key];
    if (!value || valueTarget === undefined || animationTypeState && shouldBlockAnimation(animationTypeState, key)) {
      continue;
    }
    var valueTransition = tslib.__assign({
      delay: delay
    }, transition);
    /**
     * Make animation instant if this is a transform prop and we should reduce motion.
     */
    if (visualElement.shouldReduceMotion && isTransformProp(key)) {
      valueTransition = tslib.__assign(tslib.__assign({}, valueTransition), {
        type: false,
        delay: 0
      });
    }
    var animation = startAnimation(key, value, valueTarget, valueTransition);
    animations.push(animation);
  }
  return Promise.all(animations).then(function () {
    transitionEnd && setTarget(visualElement, transitionEnd);
  });
}
function animateChildren(visualElement, variant, delayChildren, staggerChildren, staggerDirection, options) {
  if (delayChildren === void 0) {
    delayChildren = 0;
  }
  if (staggerChildren === void 0) {
    staggerChildren = 0;
  }
  if (staggerDirection === void 0) {
    staggerDirection = 1;
  }
  var animations = [];
  var maxStaggerDuration = (visualElement.variantChildren.size - 1) * staggerChildren;
  var generateStaggerDuration = staggerDirection === 1 ? function (i) {
    if (i === void 0) {
      i = 0;
    }
    return i * staggerChildren;
  } : function (i) {
    if (i === void 0) {
      i = 0;
    }
    return maxStaggerDuration - i * staggerChildren;
  };
  Array.from(visualElement.variantChildren).sort(sortByTreeOrder).forEach(function (child, i) {
    animations.push(animateVariant(child, variant, tslib.__assign(tslib.__assign({}, options), {
      delay: delayChildren + generateStaggerDuration(i)
    })).then(function () {
      return child.notifyAnimationComplete(variant);
    }));
  });
  return Promise.all(animations);
}
function stopAnimation(visualElement) {
  visualElement.forEachValue(function (value) {
    return value.stop();
  });
}
function sortByTreeOrder(a, b) {
  return a.sortNodePosition(b);
}
/**
 * Decide whether we should block this animation. Previously, we achieved this
 * just by checking whether the key was listed in protectedKeys, but this
 * posed problems if an animation was triggered by afterChildren and protectedKeys
 * had been set to true in the meantime.
 */
function shouldBlockAnimation(_a, key) {
  var protectedKeys = _a.protectedKeys,
    needsAnimating = _a.needsAnimating;
  var shouldBlock = protectedKeys.hasOwnProperty(key) && needsAnimating[key] !== true;
  needsAnimating[key] = false;
  return shouldBlock;
}
var variantPriorityOrder = [exports.AnimationType.Animate, exports.AnimationType.InView, exports.AnimationType.Focus, exports.AnimationType.Hover, exports.AnimationType.Tap, exports.AnimationType.Drag, exports.AnimationType.Exit];
var reversePriorityOrder = tslib.__spreadArray([], tslib.__read(variantPriorityOrder), false).reverse();
var numAnimationTypes = variantPriorityOrder.length;
function animateList(visualElement) {
  return function (animations) {
    return Promise.all(animations.map(function (_a) {
      var animation = _a.animation,
        options = _a.options;
      return animateVisualElement(visualElement, animation, options);
    }));
  };
}
function createAnimationState(visualElement) {
  var animate = animateList(visualElement);
  var state = createState();
  var allAnimatedKeys = {};
  var isInitialRender = true;
  /**
   * This function will be used to reduce the animation definitions for
   * each active animation type into an object of resolved values for it.
   */
  var buildResolvedTypeValues = function (acc, definition) {
    var resolved = resolveVariant(visualElement, definition);
    if (resolved) {
      resolved.transition;
      var transitionEnd = resolved.transitionEnd,
        target = tslib.__rest(resolved, ["transition", "transitionEnd"]);
      acc = tslib.__assign(tslib.__assign(tslib.__assign({}, acc), target), transitionEnd);
    }
    return acc;
  };
  function isAnimated(key) {
    return allAnimatedKeys[key] !== undefined;
  }
  /**
   * This just allows us to inject mocked animation functions
   * @internal
   */
  function setAnimateFunction(makeAnimator) {
    animate = makeAnimator(visualElement);
  }
  /**
   * When we receive new props, we need to:
   * 1. Create a list of protected keys for each type. This is a directory of
   *    value keys that are currently being "handled" by types of a higher priority
   *    so that whenever an animation is played of a given type, these values are
   *    protected from being animated.
   * 2. Determine if an animation type needs animating.
   * 3. Determine if any values have been removed from a type and figure out
   *    what to animate those to.
   */
  function animateChanges(options, changedActiveType) {
    var _a;
    var props = visualElement.getProps();
    var context = visualElement.getVariantContext(true) || {};
    /**
     * A list of animations that we'll build into as we iterate through the animation
     * types. This will get executed at the end of the function.
     */
    var animations = [];
    /**
     * Keep track of which values have been removed. Then, as we hit lower priority
     * animation types, we can check if they contain removed values and animate to that.
     */
    var removedKeys = new Set();
    /**
     * A dictionary of all encountered keys. This is an object to let us build into and
     * copy it without iteration. Each time we hit an animation type we set its protected
     * keys - the keys its not allowed to animate - to the latest version of this object.
     */
    var encounteredKeys = {};
    /**
     * If a variant has been removed at a given index, and this component is controlling
     * variant animations, we want to ensure lower-priority variants are forced to animate.
     */
    var removedVariantIndex = Infinity;
    var _loop_1 = function (i) {
      var type = reversePriorityOrder[i];
      var typeState = state[type];
      var prop = (_a = props[type]) !== null && _a !== void 0 ? _a : context[type];
      var propIsVariant = isVariantLabel(prop);
      /**
       * If this type has *just* changed isActive status, set activeDelta
       * to that status. Otherwise set to null.
       */
      var activeDelta = type === changedActiveType ? typeState.isActive : null;
      if (activeDelta === false) removedVariantIndex = i;
      /**
       * If this prop is an inherited variant, rather than been set directly on the
       * component itself, we want to make sure we allow the parent to trigger animations.
       *
       * TODO: Can probably change this to a !isControllingVariants check
       */
      var isInherited = prop === context[type] && prop !== props[type] && propIsVariant;
      /**
       *
       */
      if (isInherited && isInitialRender && visualElement.manuallyAnimateOnMount) {
        isInherited = false;
      }
      /**
       * Set all encountered keys so far as the protected keys for this type. This will
       * be any key that has been animated or otherwise handled by active, higher-priortiy types.
       */
      typeState.protectedKeys = tslib.__assign({}, encounteredKeys);
      // Check if we can skip analysing this prop early
      if (
      // If it isn't active and hasn't *just* been set as inactive
      !typeState.isActive && activeDelta === null ||
      // If we didn't and don't have any defined prop for this animation type
      !prop && !typeState.prevProp ||
      // Or if the prop doesn't define an animation
      isAnimationControls(prop) || typeof prop === "boolean") {
        return "continue";
      }
      /**
       * As we go look through the values defined on this type, if we detect
       * a changed value or a value that was removed in a higher priority, we set
       * this to true and add this prop to the animation list.
       */
      var variantDidChange = checkVariantsDidChange(typeState.prevProp, prop);
      var shouldAnimateType = variantDidChange ||
      // If we're making this variant active, we want to always make it active
      type === changedActiveType && typeState.isActive && !isInherited && propIsVariant ||
      // If we removed a higher-priority variant (i is in reverse order)
      i > removedVariantIndex && propIsVariant;
      /**
       * As animations can be set as variant lists, variants or target objects, we
       * coerce everything to an array if it isn't one already
       */
      var definitionList = Array.isArray(prop) ? prop : [prop];
      /**
       * Build an object of all the resolved values. We'll use this in the subsequent
       * animateChanges calls to determine whether a value has changed.
       */
      var resolvedValues = definitionList.reduce(buildResolvedTypeValues, {});
      if (activeDelta === false) resolvedValues = {};
      /**
       * Now we need to loop through all the keys in the prev prop and this prop,
       * and decide:
       * 1. If the value has changed, and needs animating
       * 2. If it has been removed, and needs adding to the removedKeys set
       * 3. If it has been removed in a higher priority type and needs animating
       * 4. If it hasn't been removed in a higher priority but hasn't changed, and
       *    needs adding to the type's protectedKeys list.
       */
      var _b = typeState.prevResolvedValues,
        prevResolvedValues = _b === void 0 ? {} : _b;
      var allKeys = tslib.__assign(tslib.__assign({}, prevResolvedValues), resolvedValues);
      var markToAnimate = function (key) {
        shouldAnimateType = true;
        removedKeys.delete(key);
        typeState.needsAnimating[key] = true;
      };
      for (var key in allKeys) {
        var next = resolvedValues[key];
        var prev = prevResolvedValues[key];
        // If we've already handled this we can just skip ahead
        if (encounteredKeys.hasOwnProperty(key)) continue;
        /**
         * If the value has changed, we probably want to animate it.
         */
        if (next !== prev) {
          /**
           * If both values are keyframes, we need to shallow compare them to
           * detect whether any value has changed. If it has, we animate it.
           */
          if (isKeyframesTarget(next) && isKeyframesTarget(prev)) {
            if (!shallowCompare(next, prev) || variantDidChange) {
              markToAnimate(key);
            } else {
              /**
               * If it hasn't changed, we want to ensure it doesn't animate by
               * adding it to the list of protected keys.
               */
              typeState.protectedKeys[key] = true;
            }
          } else if (next !== undefined) {
            // If next is defined and doesn't equal prev, it needs animating
            markToAnimate(key);
          } else {
            // If it's undefined, it's been removed.
            removedKeys.add(key);
          }
        } else if (next !== undefined && removedKeys.has(key)) {
          /**
           * If next hasn't changed and it isn't undefined, we want to check if it's
           * been removed by a higher priority
           */
          markToAnimate(key);
        } else {
          /**
           * If it hasn't changed, we add it to the list of protected values
           * to ensure it doesn't get animated.
           */
          typeState.protectedKeys[key] = true;
        }
      }
      /**
       * Update the typeState so next time animateChanges is called we can compare the
       * latest prop and resolvedValues to these.
       */
      typeState.prevProp = prop;
      typeState.prevResolvedValues = resolvedValues;
      /**
       *
       */
      if (typeState.isActive) {
        encounteredKeys = tslib.__assign(tslib.__assign({}, encounteredKeys), resolvedValues);
      }
      if (isInitialRender && visualElement.blockInitialAnimation) {
        shouldAnimateType = false;
      }
      /**
       * If this is an inherited prop we want to hard-block animations
       * TODO: Test as this should probably still handle animations triggered
       * by removed values?
       */
      if (shouldAnimateType && !isInherited) {
        animations.push.apply(animations, tslib.__spreadArray([], tslib.__read(definitionList.map(function (animation) {
          return {
            animation: animation,
            options: tslib.__assign({
              type: type
            }, options)
          };
        })), false));
      }
    };
    /**
     * Iterate through all animation types in reverse priority order. For each, we want to
     * detect which values it's handling and whether or not they've changed (and therefore
     * need to be animated). If any values have been removed, we want to detect those in
     * lower priority props and flag for animation.
     */
    for (var i = 0; i < numAnimationTypes; i++) {
      _loop_1(i);
    }
    allAnimatedKeys = tslib.__assign({}, encounteredKeys);
    /**
     * If there are some removed value that haven't been dealt with,
     * we need to create a new animation that falls back either to the value
     * defined in the style prop, or the last read value.
     */
    if (removedKeys.size) {
      var fallbackAnimation_1 = {};
      removedKeys.forEach(function (key) {
        var fallbackTarget = visualElement.getBaseTarget(key);
        if (fallbackTarget !== undefined) {
          fallbackAnimation_1[key] = fallbackTarget;
        }
      });
      animations.push({
        animation: fallbackAnimation_1
      });
    }
    var shouldAnimate = Boolean(animations.length);
    if (isInitialRender && props.initial === false && !visualElement.manuallyAnimateOnMount) {
      shouldAnimate = false;
    }
    isInitialRender = false;
    return shouldAnimate ? animate(animations) : Promise.resolve();
  }
  /**
   * Change whether a certain animation type is active.
   */
  function setActive(type, isActive, options) {
    var _a;
    // If the active state hasn't changed, we can safely do nothing here
    if (state[type].isActive === isActive) return Promise.resolve();
    // Propagate active change to children
    (_a = visualElement.variantChildren) === null || _a === void 0 ? void 0 : _a.forEach(function (child) {
      var _a;
      return (_a = child.animationState) === null || _a === void 0 ? void 0 : _a.setActive(type, isActive);
    });
    state[type].isActive = isActive;
    var animations = animateChanges(options, type);
    for (var key in state) {
      state[key].protectedKeys = {};
    }
    return animations;
  }
  return {
    isAnimated: isAnimated,
    animateChanges: animateChanges,
    setActive: setActive,
    setAnimateFunction: setAnimateFunction,
    getState: function () {
      return state;
    }
  };
}
function checkVariantsDidChange(prev, next) {
  if (typeof next === "string") {
    return next !== prev;
  } else if (isVariantLabels(next)) {
    return !shallowCompare(next, prev);
  }
  return false;
}
function createTypeState(isActive) {
  if (isActive === void 0) {
    isActive = false;
  }
  return {
    isActive: isActive,
    protectedKeys: {},
    needsAnimating: {},
    prevResolvedValues: {}
  };
}
function createState() {
  var _a;
  return _a = {}, _a[exports.AnimationType.Animate] = createTypeState(true), _a[exports.AnimationType.InView] = createTypeState(), _a[exports.AnimationType.Hover] = createTypeState(), _a[exports.AnimationType.Tap] = createTypeState(), _a[exports.AnimationType.Drag] = createTypeState(), _a[exports.AnimationType.Focus] = createTypeState(), _a[exports.AnimationType.Exit] = createTypeState(), _a;
}
var animations = {
  animation: makeRenderlessComponent(function (_a) {
    var visualElement = _a.visualElement,
      animate = _a.animate;
    /**
     * We dynamically generate the AnimationState manager as it contains a reference
     * to the underlying animation library. We only want to load that if we load this,
     * so people can optionally code split it out using the `m` component.
     */
    visualElement.animationState || (visualElement.animationState = createAnimationState(visualElement));
    /**
     * Subscribe any provided AnimationControls to the component's VisualElement
     */
    if (isAnimationControls(animate)) {
      React.useEffect(function () {
        return animate.subscribe(visualElement);
      }, [animate]);
    }
  }),
  exit: makeRenderlessComponent(function (props) {
    var custom = props.custom,
      visualElement = props.visualElement;
    var _a = tslib.__read(usePresence(), 2),
      isPresent = _a[0],
      safeToRemove = _a[1];
    var presenceContext = React.useContext(PresenceContext);
    React.useEffect(function () {
      var _a, _b;
      visualElement.isPresent = isPresent;
      var animation = (_a = visualElement.animationState) === null || _a === void 0 ? void 0 : _a.setActive(exports.AnimationType.Exit, !isPresent, {
        custom: (_b = presenceContext === null || presenceContext === void 0 ? void 0 : presenceContext.custom) !== null && _b !== void 0 ? _b : custom
      });
      !isPresent && (animation === null || animation === void 0 ? void 0 : animation.then(safeToRemove));
    }, [isPresent]);
  })
};

/**
 * @internal
 */
var PanSession = /** @class */function () {
  function PanSession(event, handlers, _a) {
    var _this = this;
    var _b = _a === void 0 ? {} : _a,
      transformPagePoint = _b.transformPagePoint;
    /**
     * @internal
     */
    this.startEvent = null;
    /**
     * @internal
     */
    this.lastMoveEvent = null;
    /**
     * @internal
     */
    this.lastMoveEventInfo = null;
    /**
     * @internal
     */
    this.handlers = {};
    this.updatePoint = function () {
      if (!(_this.lastMoveEvent && _this.lastMoveEventInfo)) return;
      var info = getPanInfo(_this.lastMoveEventInfo, _this.history);
      var isPanStarted = _this.startEvent !== null;
      // Only start panning if the offset is larger than 3 pixels. If we make it
      // any larger than this we'll want to reset the pointer history
      // on the first update to avoid visual snapping to the cursoe.
      var isDistancePastThreshold = popmotion.distance(info.offset, {
        x: 0,
        y: 0
      }) >= 3;
      if (!isPanStarted && !isDistancePastThreshold) return;
      var point = info.point;
      var timestamp = sync.getFrameData().timestamp;
      _this.history.push(tslib.__assign(tslib.__assign({}, point), {
        timestamp: timestamp
      }));
      var _a = _this.handlers,
        onStart = _a.onStart,
        onMove = _a.onMove;
      if (!isPanStarted) {
        onStart && onStart(_this.lastMoveEvent, info);
        _this.startEvent = _this.lastMoveEvent;
      }
      onMove && onMove(_this.lastMoveEvent, info);
    };
    this.handlePointerMove = function (event, info) {
      _this.lastMoveEvent = event;
      _this.lastMoveEventInfo = transformPoint(info, _this.transformPagePoint);
      // Because Safari doesn't trigger mouseup events when it's above a `<select>`
      if (isMouseEvent(event) && event.buttons === 0) {
        _this.handlePointerUp(event, info);
        return;
      }
      // Throttle mouse move event to once per frame
      sync__default["default"].update(_this.updatePoint, true);
    };
    this.handlePointerUp = function (event, info) {
      _this.end();
      var _a = _this.handlers,
        onEnd = _a.onEnd,
        onSessionEnd = _a.onSessionEnd;
      var panInfo = getPanInfo(transformPoint(info, _this.transformPagePoint), _this.history);
      if (_this.startEvent && onEnd) {
        onEnd(event, panInfo);
      }
      onSessionEnd && onSessionEnd(event, panInfo);
    };
    // If we have more than one touch, don't start detecting this gesture
    if (isTouchEvent(event) && event.touches.length > 1) return;
    this.handlers = handlers;
    this.transformPagePoint = transformPagePoint;
    var info = extractEventInfo(event);
    var initialInfo = transformPoint(info, this.transformPagePoint);
    var point = initialInfo.point;
    var timestamp = sync.getFrameData().timestamp;
    this.history = [tslib.__assign(tslib.__assign({}, point), {
      timestamp: timestamp
    })];
    var onSessionStart = handlers.onSessionStart;
    onSessionStart && onSessionStart(event, getPanInfo(initialInfo, this.history));
    this.removeListeners = popmotion.pipe(addPointerEvent(window, "pointermove", this.handlePointerMove), addPointerEvent(window, "pointerup", this.handlePointerUp), addPointerEvent(window, "pointercancel", this.handlePointerUp));
  }
  PanSession.prototype.updateHandlers = function (handlers) {
    this.handlers = handlers;
  };
  PanSession.prototype.end = function () {
    this.removeListeners && this.removeListeners();
    sync.cancelSync.update(this.updatePoint);
  };
  return PanSession;
}();
function transformPoint(info, transformPagePoint) {
  return transformPagePoint ? {
    point: transformPagePoint(info.point)
  } : info;
}
function subtractPoint(a, b) {
  return {
    x: a.x - b.x,
    y: a.y - b.y
  };
}
function getPanInfo(_a, history) {
  var point = _a.point;
  return {
    point: point,
    delta: subtractPoint(point, lastDevicePoint(history)),
    offset: subtractPoint(point, startDevicePoint(history)),
    velocity: getVelocity(history, 0.1)
  };
}
function startDevicePoint(history) {
  return history[0];
}
function lastDevicePoint(history) {
  return history[history.length - 1];
}
function getVelocity(history, timeDelta) {
  if (history.length < 2) {
    return {
      x: 0,
      y: 0
    };
  }
  var i = history.length - 1;
  var timestampedPoint = null;
  var lastPoint = lastDevicePoint(history);
  while (i >= 0) {
    timestampedPoint = history[i];
    if (lastPoint.timestamp - timestampedPoint.timestamp > secondsToMilliseconds(timeDelta)) {
      break;
    }
    i--;
  }
  if (!timestampedPoint) {
    return {
      x: 0,
      y: 0
    };
  }
  var time = (lastPoint.timestamp - timestampedPoint.timestamp) / 1000;
  if (time === 0) {
    return {
      x: 0,
      y: 0
    };
  }
  var currentVelocity = {
    x: (lastPoint.x - timestampedPoint.x) / time,
    y: (lastPoint.y - timestampedPoint.y) / time
  };
  if (currentVelocity.x === Infinity) {
    currentVelocity.x = 0;
  }
  if (currentVelocity.y === Infinity) {
    currentVelocity.y = 0;
  }
  return currentVelocity;
}
function calcLength(axis) {
  return axis.max - axis.min;
}
function isNear(value, target, maxDistance) {
  if (target === void 0) {
    target = 0;
  }
  if (maxDistance === void 0) {
    maxDistance = 0.01;
  }
  return popmotion.distance(value, target) < maxDistance;
}
function calcAxisDelta(delta, source, target, origin) {
  if (origin === void 0) {
    origin = 0.5;
  }
  delta.origin = origin;
  delta.originPoint = popmotion.mix(source.min, source.max, delta.origin);
  delta.scale = calcLength(target) / calcLength(source);
  if (isNear(delta.scale, 1, 0.0001) || isNaN(delta.scale)) delta.scale = 1;
  delta.translate = popmotion.mix(target.min, target.max, delta.origin) - delta.originPoint;
  if (isNear(delta.translate) || isNaN(delta.translate)) delta.translate = 0;
}
function calcBoxDelta(delta, source, target, origin) {
  calcAxisDelta(delta.x, source.x, target.x, origin === null || origin === void 0 ? void 0 : origin.originX);
  calcAxisDelta(delta.y, source.y, target.y, origin === null || origin === void 0 ? void 0 : origin.originY);
}
function calcRelativeAxis(target, relative, parent) {
  target.min = parent.min + relative.min;
  target.max = target.min + calcLength(relative);
}
function calcRelativeBox(target, relative, parent) {
  calcRelativeAxis(target.x, relative.x, parent.x);
  calcRelativeAxis(target.y, relative.y, parent.y);
}
function calcRelativeAxisPosition(target, layout, parent) {
  target.min = layout.min - parent.min;
  target.max = target.min + calcLength(layout);
}
function calcRelativePosition(target, layout, parent) {
  calcRelativeAxisPosition(target.x, layout.x, parent.x);
  calcRelativeAxisPosition(target.y, layout.y, parent.y);
}

/**
 * Apply constraints to a point. These constraints are both physical along an
 * axis, and an elastic factor that determines how much to constrain the point
 * by if it does lie outside the defined parameters.
 */
function applyConstraints(point, _a, elastic) {
  var min = _a.min,
    max = _a.max;
  if (min !== undefined && point < min) {
    // If we have a min point defined, and this is outside of that, constrain
    point = elastic ? popmotion.mix(min, point, elastic.min) : Math.max(point, min);
  } else if (max !== undefined && point > max) {
    // If we have a max point defined, and this is outside of that, constrain
    point = elastic ? popmotion.mix(max, point, elastic.max) : Math.min(point, max);
  }
  return point;
}
/**
 * Calculate constraints in terms of the viewport when defined relatively to the
 * measured axis. This is measured from the nearest edge, so a max constraint of 200
 * on an axis with a max value of 300 would return a constraint of 500 - axis length
 */
function calcRelativeAxisConstraints(axis, min, max) {
  return {
    min: min !== undefined ? axis.min + min : undefined,
    max: max !== undefined ? axis.max + max - (axis.max - axis.min) : undefined
  };
}
/**
 * Calculate constraints in terms of the viewport when
 * defined relatively to the measured bounding box.
 */
function calcRelativeConstraints(layoutBox, _a) {
  var top = _a.top,
    left = _a.left,
    bottom = _a.bottom,
    right = _a.right;
  return {
    x: calcRelativeAxisConstraints(layoutBox.x, left, right),
    y: calcRelativeAxisConstraints(layoutBox.y, top, bottom)
  };
}
/**
 * Calculate viewport constraints when defined as another viewport-relative axis
 */
function calcViewportAxisConstraints(layoutAxis, constraintsAxis) {
  var _a;
  var min = constraintsAxis.min - layoutAxis.min;
  var max = constraintsAxis.max - layoutAxis.max;
  // If the constraints axis is actually smaller than the layout axis then we can
  // flip the constraints
  if (constraintsAxis.max - constraintsAxis.min < layoutAxis.max - layoutAxis.min) {
    _a = tslib.__read([max, min], 2), min = _a[0], max = _a[1];
  }
  return {
    min: min,
    max: max
  };
}
/**
 * Calculate viewport constraints when defined as another viewport-relative box
 */
function calcViewportConstraints(layoutBox, constraintsBox) {
  return {
    x: calcViewportAxisConstraints(layoutBox.x, constraintsBox.x),
    y: calcViewportAxisConstraints(layoutBox.y, constraintsBox.y)
  };
}
/**
 * Calculate a transform origin relative to the source axis, between 0-1, that results
 * in an asthetically pleasing scale/transform needed to project from source to target.
 */
function calcOrigin(source, target) {
  var origin = 0.5;
  var sourceLength = calcLength(source);
  var targetLength = calcLength(target);
  if (targetLength > sourceLength) {
    origin = popmotion.progress(target.min, target.max - sourceLength, source.min);
  } else if (sourceLength > targetLength) {
    origin = popmotion.progress(source.min, source.max - targetLength, target.min);
  }
  return popmotion.clamp(0, 1, origin);
}
/**
 * Rebase the calculated viewport constraints relative to the layout.min point.
 */
function rebaseAxisConstraints(layout, constraints) {
  var relativeConstraints = {};
  if (constraints.min !== undefined) {
    relativeConstraints.min = constraints.min - layout.min;
  }
  if (constraints.max !== undefined) {
    relativeConstraints.max = constraints.max - layout.min;
  }
  return relativeConstraints;
}
var defaultElastic = 0.35;
/**
 * Accepts a dragElastic prop and returns resolved elastic values for each axis.
 */
function resolveDragElastic(dragElastic) {
  if (dragElastic === void 0) {
    dragElastic = defaultElastic;
  }
  if (dragElastic === false) {
    dragElastic = 0;
  } else if (dragElastic === true) {
    dragElastic = defaultElastic;
  }
  return {
    x: resolveAxisElastic(dragElastic, "left", "right"),
    y: resolveAxisElastic(dragElastic, "top", "bottom")
  };
}
function resolveAxisElastic(dragElastic, minLabel, maxLabel) {
  return {
    min: resolvePointElastic(dragElastic, minLabel),
    max: resolvePointElastic(dragElastic, maxLabel)
  };
}
function resolvePointElastic(dragElastic, label) {
  var _a;
  return typeof dragElastic === "number" ? dragElastic : (_a = dragElastic[label]) !== null && _a !== void 0 ? _a : 0;
}
var createAxisDelta = function () {
  return {
    translate: 0,
    scale: 1,
    origin: 0,
    originPoint: 0
  };
};
var createDelta = function () {
  return {
    x: createAxisDelta(),
    y: createAxisDelta()
  };
};
var createAxis = function () {
  return {
    min: 0,
    max: 0
  };
};
var createBox = function () {
  return {
    x: createAxis(),
    y: createAxis()
  };
};
function eachAxis(callback) {
  return [callback("x"), callback("y")];
}

/**
 * Bounding boxes tend to be defined as top, left, right, bottom. For various operations
 * it's easier to consider each axis individually. This function returns a bounding box
 * as a map of single-axis min/max values.
 */
function convertBoundingBoxToBox(_a) {
  var top = _a.top,
    left = _a.left,
    right = _a.right,
    bottom = _a.bottom;
  return {
    x: {
      min: left,
      max: right
    },
    y: {
      min: top,
      max: bottom
    }
  };
}
function convertBoxToBoundingBox(_a) {
  var x = _a.x,
    y = _a.y;
  return {
    top: y.min,
    right: x.max,
    bottom: y.max,
    left: x.min
  };
}
/**
 * Applies a TransformPoint function to a bounding box. TransformPoint is usually a function
 * provided by Framer to allow measured points to be corrected for device scaling. This is used
 * when measuring DOM elements and DOM event points.
 */
function transformBoxPoints(point, transformPoint) {
  if (!transformPoint) return point;
  var topLeft = transformPoint({
    x: point.left,
    y: point.top
  });
  var bottomRight = transformPoint({
    x: point.right,
    y: point.bottom
  });
  return {
    top: topLeft.y,
    left: topLeft.x,
    bottom: bottomRight.y,
    right: bottomRight.x
  };
}
function isIdentityScale(scale) {
  return scale === undefined || scale === 1;
}
function hasScale(_a) {
  var scale = _a.scale,
    scaleX = _a.scaleX,
    scaleY = _a.scaleY;
  return !isIdentityScale(scale) || !isIdentityScale(scaleX) || !isIdentityScale(scaleY);
}
function hasTransform(values) {
  return hasScale(values) || hasTranslate(values.x) || hasTranslate(values.y) || values.z || values.rotate || values.rotateX || values.rotateY;
}
function hasTranslate(value) {
  return value && value !== "0%";
}

/**
 * Scales a point based on a factor and an originPoint
 */
function scalePoint(point, scale, originPoint) {
  var distanceFromOrigin = point - originPoint;
  var scaled = scale * distanceFromOrigin;
  return originPoint + scaled;
}
/**
 * Applies a translate/scale delta to a point
 */
function applyPointDelta(point, translate, scale, originPoint, boxScale) {
  if (boxScale !== undefined) {
    point = scalePoint(point, boxScale, originPoint);
  }
  return scalePoint(point, scale, originPoint) + translate;
}
/**
 * Applies a translate/scale delta to an axis
 */
function applyAxisDelta(axis, translate, scale, originPoint, boxScale) {
  if (translate === void 0) {
    translate = 0;
  }
  if (scale === void 0) {
    scale = 1;
  }
  axis.min = applyPointDelta(axis.min, translate, scale, originPoint, boxScale);
  axis.max = applyPointDelta(axis.max, translate, scale, originPoint, boxScale);
}
/**
 * Applies a translate/scale delta to a box
 */
function applyBoxDelta(box, _a) {
  var x = _a.x,
    y = _a.y;
  applyAxisDelta(box.x, x.translate, x.scale, x.originPoint);
  applyAxisDelta(box.y, y.translate, y.scale, y.originPoint);
}
/**
 * Apply a tree of deltas to a box. We do this to calculate the effect of all the transforms
 * in a tree upon our box before then calculating how to project it into our desired viewport-relative box
 *
 * This is the final nested loop within updateLayoutDelta for future refactoring
 */
function applyTreeDeltas(box, treeScale, treePath, isSharedTransition) {
  var _a, _b;
  if (isSharedTransition === void 0) {
    isSharedTransition = false;
  }
  var treeLength = treePath.length;
  if (!treeLength) return;
  // Reset the treeScale
  treeScale.x = treeScale.y = 1;
  var node;
  var delta;
  for (var i = 0; i < treeLength; i++) {
    node = treePath[i];
    delta = node.projectionDelta;
    if (((_b = (_a = node.instance) === null || _a === void 0 ? void 0 : _a.style) === null || _b === void 0 ? void 0 : _b.display) === "contents") continue;
    if (isSharedTransition && node.options.layoutScroll && node.scroll && node !== node.root) {
      transformBox(box, {
        x: -node.scroll.x,
        y: -node.scroll.y
      });
    }
    if (delta) {
      // Incoporate each ancestor's scale into a culmulative treeScale for this component
      treeScale.x *= delta.x.scale;
      treeScale.y *= delta.y.scale;
      // Apply each ancestor's calculated delta into this component's recorded layout box
      applyBoxDelta(box, delta);
    }
    if (isSharedTransition && hasTransform(node.latestValues)) {
      transformBox(box, node.latestValues);
    }
  }
}
function translateAxis(axis, distance) {
  axis.min = axis.min + distance;
  axis.max = axis.max + distance;
}
/**
 * Apply a transform to an axis from the latest resolved motion values.
 * This function basically acts as a bridge between a flat motion value map
 * and applyAxisDelta
 */
function transformAxis(axis, transforms, _a) {
  var _b = tslib.__read(_a, 3),
    key = _b[0],
    scaleKey = _b[1],
    originKey = _b[2];
  var axisOrigin = transforms[originKey] !== undefined ? transforms[originKey] : 0.5;
  var originPoint = popmotion.mix(axis.min, axis.max, axisOrigin);
  // Apply the axis delta to the final axis
  applyAxisDelta(axis, transforms[key], transforms[scaleKey], originPoint, transforms.scale);
}
/**
 * The names of the motion values we want to apply as translation, scale and origin.
 */
var xKeys$1 = ["x", "scaleX", "originX"];
var yKeys$1 = ["y", "scaleY", "originY"];
/**
 * Apply a transform to a box from the latest resolved motion values.
 */
function transformBox(box, transform) {
  transformAxis(box.x, transform, xKeys$1);
  transformAxis(box.y, transform, yKeys$1);
}
function measureViewportBox(instance, transformPoint) {
  return convertBoundingBoxToBox(transformBoxPoints(instance.getBoundingClientRect(), transformPoint));
}
function measurePageBox(element, rootProjectionNode, transformPagePoint) {
  var viewportBox = measureViewportBox(element, transformPagePoint);
  var scroll = rootProjectionNode.scroll;
  if (scroll) {
    translateAxis(viewportBox.x, scroll.x);
    translateAxis(viewportBox.y, scroll.y);
  }
  return viewportBox;
}
var elementDragControls = new WeakMap();
/**
 *
 */
// let latestPointerEvent: AnyPointerEvent
var VisualElementDragControls = /** @class */function () {
  function VisualElementDragControls(visualElement) {
    // This is a reference to the global drag gesture lock, ensuring only one component
    // can "capture" the drag of one or both axes.
    // TODO: Look into moving this into pansession?
    this.openGlobalLock = null;
    this.isDragging = false;
    this.currentDirection = null;
    this.originPoint = {
      x: 0,
      y: 0
    };
    /**
     * The permitted boundaries of travel, in pixels.
     */
    this.constraints = false;
    this.hasMutatedConstraints = false;
    /**
     * The per-axis resolved elastic values.
     */
    this.elastic = createBox();
    this.visualElement = visualElement;
  }
  VisualElementDragControls.prototype.start = function (originEvent, _a) {
    var _this = this;
    var _b = _a === void 0 ? {} : _a,
      _c = _b.snapToCursor,
      snapToCursor = _c === void 0 ? false : _c;
    /**
     * Don't start dragging if this component is exiting
     */
    if (this.visualElement.isPresent === false) return;
    var onSessionStart = function (event) {
      // Stop any animations on both axis values immediately. This allows the user to throw and catch
      // the component.
      _this.stopAnimation();
      if (snapToCursor) {
        _this.snapToCursor(extractEventInfo(event, "page").point);
      }
    };
    var onStart = function (event, info) {
      var _a;
      // Attempt to grab the global drag gesture lock - maybe make this part of PanSession
      var _b = _this.getProps(),
        drag = _b.drag,
        dragPropagation = _b.dragPropagation,
        onDragStart = _b.onDragStart;
      if (drag && !dragPropagation) {
        if (_this.openGlobalLock) _this.openGlobalLock();
        _this.openGlobalLock = getGlobalLock(drag);
        // If we don 't have the lock, don't start dragging
        if (!_this.openGlobalLock) return;
      }
      _this.isDragging = true;
      _this.currentDirection = null;
      _this.resolveConstraints();
      if (_this.visualElement.projection) {
        _this.visualElement.projection.isAnimationBlocked = true;
        _this.visualElement.projection.target = undefined;
      }
      /**
       * Record gesture origin
       */
      eachAxis(function (axis) {
        var _a, _b;
        var current = _this.getAxisMotionValue(axis).get() || 0;
        /**
         * If the MotionValue is a percentage value convert to px
         */
        if (styleValueTypes.percent.test(current)) {
          var measuredAxis = (_b = (_a = _this.visualElement.projection) === null || _a === void 0 ? void 0 : _a.layout) === null || _b === void 0 ? void 0 : _b.actual[axis];
          if (measuredAxis) {
            var length_1 = calcLength(measuredAxis);
            current = length_1 * (parseFloat(current) / 100);
          }
        }
        _this.originPoint[axis] = current;
      });
      // Fire onDragStart event
      onDragStart === null || onDragStart === void 0 ? void 0 : onDragStart(event, info);
      (_a = _this.visualElement.animationState) === null || _a === void 0 ? void 0 : _a.setActive(exports.AnimationType.Drag, true);
    };
    var onMove = function (event, info) {
      // latestPointerEvent = event
      var _a = _this.getProps(),
        dragPropagation = _a.dragPropagation,
        dragDirectionLock = _a.dragDirectionLock,
        onDirectionLock = _a.onDirectionLock,
        onDrag = _a.onDrag;
      // If we didn't successfully receive the gesture lock, early return.
      if (!dragPropagation && !_this.openGlobalLock) return;
      var offset = info.offset;
      // Attempt to detect drag direction if directionLock is true
      if (dragDirectionLock && _this.currentDirection === null) {
        _this.currentDirection = getCurrentDirection(offset);
        // If we've successfully set a direction, notify listener
        if (_this.currentDirection !== null) {
          onDirectionLock === null || onDirectionLock === void 0 ? void 0 : onDirectionLock(_this.currentDirection);
        }
        return;
      }
      // Update each point with the latest position
      _this.updateAxis("x", info.point, offset);
      _this.updateAxis("y", info.point, offset);
      /**
       * Ideally we would leave the renderer to fire naturally at the end of
       * this frame but if the element is about to change layout as the result
       * of a re-render we want to ensure the browser can read the latest
       * bounding box to ensure the pointer and element don't fall out of sync.
       */
      _this.visualElement.syncRender();
      /**
       * This must fire after the syncRender call as it might trigger a state
       * change which itself might trigger a layout update.
       */
      onDrag === null || onDrag === void 0 ? void 0 : onDrag(event, info);
    };
    var onSessionEnd = function (event, info) {
      return _this.stop(event, info);
    };
    this.panSession = new PanSession(originEvent, {
      onSessionStart: onSessionStart,
      onStart: onStart,
      onMove: onMove,
      onSessionEnd: onSessionEnd
    }, {
      transformPagePoint: this.visualElement.getTransformPagePoint()
    });
  };
  VisualElementDragControls.prototype.stop = function (event, info) {
    var isDragging = this.isDragging;
    this.cancel();
    if (!isDragging) return;
    var velocity = info.velocity;
    this.startAnimation(velocity);
    var onDragEnd = this.getProps().onDragEnd;
    onDragEnd === null || onDragEnd === void 0 ? void 0 : onDragEnd(event, info);
  };
  VisualElementDragControls.prototype.cancel = function () {
    var _a, _b;
    this.isDragging = false;
    if (this.visualElement.projection) {
      this.visualElement.projection.isAnimationBlocked = false;
    }
    (_a = this.panSession) === null || _a === void 0 ? void 0 : _a.end();
    this.panSession = undefined;
    var dragPropagation = this.getProps().dragPropagation;
    if (!dragPropagation && this.openGlobalLock) {
      this.openGlobalLock();
      this.openGlobalLock = null;
    }
    (_b = this.visualElement.animationState) === null || _b === void 0 ? void 0 : _b.setActive(exports.AnimationType.Drag, false);
  };
  VisualElementDragControls.prototype.updateAxis = function (axis, _point, offset) {
    var drag = this.getProps().drag;
    // If we're not dragging this axis, do an early return.
    if (!offset || !shouldDrag(axis, drag, this.currentDirection)) return;
    var axisValue = this.getAxisMotionValue(axis);
    var next = this.originPoint[axis] + offset[axis];
    // Apply constraints
    if (this.constraints && this.constraints[axis]) {
      next = applyConstraints(next, this.constraints[axis], this.elastic[axis]);
    }
    axisValue.set(next);
  };
  VisualElementDragControls.prototype.resolveConstraints = function () {
    var _this = this;
    var _a = this.getProps(),
      dragConstraints = _a.dragConstraints,
      dragElastic = _a.dragElastic;
    var layout = (this.visualElement.projection || {}).layout;
    var prevConstraints = this.constraints;
    if (dragConstraints && isRefObject(dragConstraints)) {
      if (!this.constraints) {
        this.constraints = this.resolveRefConstraints();
      }
    } else {
      if (dragConstraints && layout) {
        this.constraints = calcRelativeConstraints(layout.actual, dragConstraints);
      } else {
        this.constraints = false;
      }
    }
    this.elastic = resolveDragElastic(dragElastic);
    /**
     * If we're outputting to external MotionValues, we want to rebase the measured constraints
     * from viewport-relative to component-relative.
     */
    if (prevConstraints !== this.constraints && layout && this.constraints && !this.hasMutatedConstraints) {
      eachAxis(function (axis) {
        if (_this.getAxisMotionValue(axis)) {
          _this.constraints[axis] = rebaseAxisConstraints(layout.actual[axis], _this.constraints[axis]);
        }
      });
    }
  };
  VisualElementDragControls.prototype.resolveRefConstraints = function () {
    var _a = this.getProps(),
      constraints = _a.dragConstraints,
      onMeasureDragConstraints = _a.onMeasureDragConstraints;
    if (!constraints || !isRefObject(constraints)) return false;
    var constraintsElement = constraints.current;
    heyListen.invariant(constraintsElement !== null, "If `dragConstraints` is set as a React ref, that ref must be passed to another component's `ref` prop.");
    var projection = this.visualElement.projection;
    // TODO
    if (!projection || !projection.layout) return false;
    var constraintsBox = measurePageBox(constraintsElement, projection.root, this.visualElement.getTransformPagePoint());
    var measuredConstraints = calcViewportConstraints(projection.layout.actual, constraintsBox);
    /**
     * If there's an onMeasureDragConstraints listener we call it and
     * if different constraints are returned, set constraints to that
     */
    if (onMeasureDragConstraints) {
      var userConstraints = onMeasureDragConstraints(convertBoxToBoundingBox(measuredConstraints));
      this.hasMutatedConstraints = !!userConstraints;
      if (userConstraints) {
        measuredConstraints = convertBoundingBoxToBox(userConstraints);
      }
    }
    return measuredConstraints;
  };
  VisualElementDragControls.prototype.startAnimation = function (velocity) {
    var _this = this;
    var _a = this.getProps(),
      drag = _a.drag,
      dragMomentum = _a.dragMomentum,
      dragElastic = _a.dragElastic,
      dragTransition = _a.dragTransition,
      dragSnapToOrigin = _a.dragSnapToOrigin,
      onDragTransitionEnd = _a.onDragTransitionEnd;
    var constraints = this.constraints || {};
    var momentumAnimations = eachAxis(function (axis) {
      var _a;
      if (!shouldDrag(axis, drag, _this.currentDirection)) {
        return;
      }
      var transition = (_a = constraints === null || constraints === void 0 ? void 0 : constraints[axis]) !== null && _a !== void 0 ? _a : {};
      if (dragSnapToOrigin) transition = {
        min: 0,
        max: 0
      };
      /**
       * Overdamp the boundary spring if `dragElastic` is disabled. There's still a frame
       * of spring animations so we should look into adding a disable spring option to `inertia`.
       * We could do something here where we affect the `bounceStiffness` and `bounceDamping`
       * using the value of `dragElastic`.
       */
      var bounceStiffness = dragElastic ? 200 : 1000000;
      var bounceDamping = dragElastic ? 40 : 10000000;
      var inertia = tslib.__assign(tslib.__assign({
        type: "inertia",
        velocity: dragMomentum ? velocity[axis] : 0,
        bounceStiffness: bounceStiffness,
        bounceDamping: bounceDamping,
        timeConstant: 750,
        restDelta: 1,
        restSpeed: 10
      }, dragTransition), transition);
      // If we're not animating on an externally-provided `MotionValue` we can use the
      // component's animation controls which will handle interactions with whileHover (etc),
      // otherwise we just have to animate the `MotionValue` itself.
      return _this.startAxisValueAnimation(axis, inertia);
    });
    // Run all animations and then resolve the new drag constraints.
    return Promise.all(momentumAnimations).then(onDragTransitionEnd);
  };
  VisualElementDragControls.prototype.startAxisValueAnimation = function (axis, transition) {
    var axisValue = this.getAxisMotionValue(axis);
    return startAnimation(axis, axisValue, 0, transition);
  };
  VisualElementDragControls.prototype.stopAnimation = function () {
    var _this = this;
    eachAxis(function (axis) {
      return _this.getAxisMotionValue(axis).stop();
    });
  };
  /**
   * Drag works differently depending on which props are provided.
   *
   * - If _dragX and _dragY are provided, we output the gesture delta directly to those motion values.
   * - Otherwise, we apply the delta to the x/y motion values.
   */
  VisualElementDragControls.prototype.getAxisMotionValue = function (axis) {
    var _a, _b;
    var dragKey = "_drag" + axis.toUpperCase();
    var externalMotionValue = this.visualElement.getProps()[dragKey];
    return externalMotionValue ? externalMotionValue : this.visualElement.getValue(axis, (_b = (_a = this.visualElement.getProps().initial) === null || _a === void 0 ? void 0 : _a[axis]) !== null && _b !== void 0 ? _b : 0);
  };
  VisualElementDragControls.prototype.snapToCursor = function (point) {
    var _this = this;
    eachAxis(function (axis) {
      var drag = _this.getProps().drag;
      // If we're not dragging this axis, do an early return.
      if (!shouldDrag(axis, drag, _this.currentDirection)) return;
      var projection = _this.visualElement.projection;
      var axisValue = _this.getAxisMotionValue(axis);
      if (projection && projection.layout) {
        var _a = projection.layout.actual[axis],
          min = _a.min,
          max = _a.max;
        axisValue.set(point[axis] - popmotion.mix(min, max, 0.5));
      }
    });
  };
  /**
   * When the viewport resizes we want to check if the measured constraints
   * have changed and, if so, reposition the element within those new constraints
   * relative to where it was before the resize.
   */
  VisualElementDragControls.prototype.scalePositionWithinConstraints = function () {
    var _this = this;
    var _a;
    var _b = this.getProps(),
      drag = _b.drag,
      dragConstraints = _b.dragConstraints;
    var projection = this.visualElement.projection;
    if (!isRefObject(dragConstraints) || !projection || !this.constraints) return;
    /**
     * Stop current animations as there can be visual glitching if we try to do
     * this mid-animation
     */
    this.stopAnimation();
    /**
     * Record the relative position of the dragged element relative to the
     * constraints box and save as a progress value.
     */
    var boxProgress = {
      x: 0,
      y: 0
    };
    eachAxis(function (axis) {
      var axisValue = _this.getAxisMotionValue(axis);
      if (axisValue) {
        var latest = axisValue.get();
        boxProgress[axis] = calcOrigin({
          min: latest,
          max: latest
        }, _this.constraints[axis]);
      }
    });
    /**
     * Update the layout of this element and resolve the latest drag constraints
     */
    var transformTemplate = this.visualElement.getProps().transformTemplate;
    this.visualElement.getInstance().style.transform = transformTemplate ? transformTemplate({}, "") : "none";
    (_a = projection.root) === null || _a === void 0 ? void 0 : _a.updateScroll();
    projection.updateLayout();
    this.resolveConstraints();
    /**
     * For each axis, calculate the current progress of the layout axis
     * within the new constraints.
     */
    eachAxis(function (axis) {
      if (!shouldDrag(axis, drag, null)) return;
      /**
       * Calculate a new transform based on the previous box progress
       */
      var axisValue = _this.getAxisMotionValue(axis);
      var _a = _this.constraints[axis],
        min = _a.min,
        max = _a.max;
      axisValue.set(popmotion.mix(min, max, boxProgress[axis]));
    });
  };
  VisualElementDragControls.prototype.addListeners = function () {
    var _this = this;
    var _a;
    elementDragControls.set(this.visualElement, this);
    var element = this.visualElement.getInstance();
    /**
     * Attach a pointerdown event listener on this DOM element to initiate drag tracking.
     */
    var stopPointerListener = addPointerEvent(element, "pointerdown", function (event) {
      var _a = _this.getProps(),
        drag = _a.drag,
        _b = _a.dragListener,
        dragListener = _b === void 0 ? true : _b;
      drag && dragListener && _this.start(event);
    });
    var measureDragConstraints = function () {
      var dragConstraints = _this.getProps().dragConstraints;
      if (isRefObject(dragConstraints)) {
        _this.constraints = _this.resolveRefConstraints();
      }
    };
    var projection = this.visualElement.projection;
    var stopMeasureLayoutListener = projection.addEventListener("measure", measureDragConstraints);
    if (projection && !projection.layout) {
      (_a = projection.root) === null || _a === void 0 ? void 0 : _a.updateScroll();
      projection.updateLayout();
    }
    measureDragConstraints();
    /**
     * Attach a window resize listener to scale the draggable target within its defined
     * constraints as the window resizes.
     */
    var stopResizeListener = addDomEvent(window, "resize", function () {
      return _this.scalePositionWithinConstraints();
    });
    /**
     * If the element's layout changes, calculate the delta and apply that to
     * the drag gesture's origin point.
     */
    projection.addEventListener("didUpdate", function (_a) {
      var delta = _a.delta,
        hasLayoutChanged = _a.hasLayoutChanged;
      if (_this.isDragging && hasLayoutChanged) {
        eachAxis(function (axis) {
          var motionValue = _this.getAxisMotionValue(axis);
          if (!motionValue) return;
          _this.originPoint[axis] += delta[axis].translate;
          motionValue.set(motionValue.get() + delta[axis].translate);
        });
        _this.visualElement.syncRender();
      }
    });
    return function () {
      stopResizeListener();
      stopPointerListener();
      stopMeasureLayoutListener();
    };
  };
  VisualElementDragControls.prototype.getProps = function () {
    var props = this.visualElement.getProps();
    var _a = props.drag,
      drag = _a === void 0 ? false : _a,
      _b = props.dragDirectionLock,
      dragDirectionLock = _b === void 0 ? false : _b,
      _c = props.dragPropagation,
      dragPropagation = _c === void 0 ? false : _c,
      _d = props.dragConstraints,
      dragConstraints = _d === void 0 ? false : _d,
      _e = props.dragElastic,
      dragElastic = _e === void 0 ? defaultElastic : _e,
      _f = props.dragMomentum,
      dragMomentum = _f === void 0 ? true : _f;
    return tslib.__assign(tslib.__assign({}, props), {
      drag: drag,
      dragDirectionLock: dragDirectionLock,
      dragPropagation: dragPropagation,
      dragConstraints: dragConstraints,
      dragElastic: dragElastic,
      dragMomentum: dragMomentum
    });
  };
  return VisualElementDragControls;
}();
function shouldDrag(direction, drag, currentDirection) {
  return (drag === true || drag === direction) && (currentDirection === null || currentDirection === direction);
}
/**
 * Based on an x/y offset determine the current drag direction. If both axis' offsets are lower
 * than the provided threshold, return `null`.
 *
 * @param offset - The x/y offset from origin.
 * @param lockThreshold - (Optional) - the minimum absolute offset before we can determine a drag direction.
 */
function getCurrentDirection(offset, lockThreshold) {
  if (lockThreshold === void 0) {
    lockThreshold = 10;
  }
  var direction = null;
  if (Math.abs(offset.y) > lockThreshold) {
    direction = "y";
  } else if (Math.abs(offset.x) > lockThreshold) {
    direction = "x";
  }
  return direction;
}

/**
 * A hook that allows an element to be dragged.
 *
 * @internal
 */
function useDrag(props) {
  var groupDragControls = props.dragControls,
    visualElement = props.visualElement;
  var dragControls = useConstant(function () {
    return new VisualElementDragControls(visualElement);
  });
  // If we've been provided a DragControls for manual control over the drag gesture,
  // subscribe this component to it on mount.
  React.useEffect(function () {
    return groupDragControls && groupDragControls.subscribe(dragControls);
  }, [dragControls, groupDragControls]);
  // Apply the event listeners to the element
  React.useEffect(function () {
    return dragControls.addListeners();
  }, [dragControls]);
}

/**
 *
 * @param handlers -
 * @param ref -
 *
 * @privateRemarks
 * Currently this sets new pan gesture functions every render. The memo route has been explored
 * in the past but ultimately we're still creating new functions every render. An optimisation
 * to explore is creating the pan gestures and loading them into a `ref`.
 *
 * @internal
 */
function usePanGesture(_a) {
  var onPan = _a.onPan,
    onPanStart = _a.onPanStart,
    onPanEnd = _a.onPanEnd,
    onPanSessionStart = _a.onPanSessionStart,
    visualElement = _a.visualElement;
  var hasPanEvents = onPan || onPanStart || onPanEnd || onPanSessionStart;
  var panSession = React.useRef(null);
  var transformPagePoint = React.useContext(MotionConfigContext).transformPagePoint;
  var handlers = {
    onSessionStart: onPanSessionStart,
    onStart: onPanStart,
    onMove: onPan,
    onEnd: function (event, info) {
      panSession.current = null;
      onPanEnd && onPanEnd(event, info);
    }
  };
  React.useEffect(function () {
    if (panSession.current !== null) {
      panSession.current.updateHandlers(handlers);
    }
  });
  function onPointerDown(event) {
    panSession.current = new PanSession(event, handlers, {
      transformPagePoint: transformPagePoint
    });
  }
  usePointerEvent(visualElement, "pointerdown", hasPanEvents && onPointerDown);
  useUnmountEffect(function () {
    return panSession.current && panSession.current.end();
  });
}
var drag = {
  pan: makeRenderlessComponent(usePanGesture),
  drag: makeRenderlessComponent(useDrag)
};
var names = ["LayoutMeasure", "BeforeLayoutMeasure", "LayoutUpdate", "ViewportBoxUpdate", "Update", "Render", "AnimationComplete", "LayoutAnimationComplete", "AnimationStart", "LayoutAnimationStart", "SetAxisTarget", "Unmount"];
function createLifecycles() {
  var managers = names.map(function () {
    return new SubscriptionManager();
  });
  var propSubscriptions = {};
  var lifecycles = {
    clearAllListeners: function () {
      return managers.forEach(function (manager) {
        return manager.clear();
      });
    },
    updatePropListeners: function (props) {
      names.forEach(function (name) {
        var _a;
        var on = "on" + name;
        var propListener = props[on];
        // Unsubscribe existing subscription
        (_a = propSubscriptions[name]) === null || _a === void 0 ? void 0 : _a.call(propSubscriptions);
        // Add new subscription
        if (propListener) {
          propSubscriptions[name] = lifecycles[on](propListener);
        }
      });
    }
  };
  managers.forEach(function (manager, i) {
    lifecycles["on" + names[i]] = function (handler) {
      return manager.add(handler);
    };
    lifecycles["notify" + names[i]] = function () {
      var args = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
      }
      return manager.notify.apply(manager, tslib.__spreadArray([], tslib.__read(args), false));
    };
  });
  return lifecycles;
}
function updateMotionValuesFromProps(element, next, prev) {
  var _a;
  for (var key in next) {
    var nextValue = next[key];
    var prevValue = prev[key];
    if (isMotionValue(nextValue)) {
      /**
       * If this is a motion value found in props or style, we want to add it
       * to our visual element's motion value map.
       */
      element.addValue(key, nextValue);
      /**
       * Check the version of the incoming motion value with this version
       * and warn against mismatches.
       */
      if (true) {
        warnOnce(nextValue.version === "6.5.1", "Attempting to mix Framer Motion versions ".concat(nextValue.version, " with 6.5.1 may not work as expected."));
      }
    } else if (isMotionValue(prevValue)) {
      /**
       * If we're swapping to a new motion value, create a new motion value
       * from that
       */
      element.addValue(key, motionValue(nextValue));
    } else if (prevValue !== nextValue) {
      /**
       * If this is a flat value that has changed, update the motion value
       * or create one if it doesn't exist. We only want to do this if we're
       * not handling the value with our animation state.
       */
      if (element.hasValue(key)) {
        var existingValue = element.getValue(key);
        // TODO: Only update values that aren't being animated or even looked at
        !existingValue.hasAnimated && existingValue.set(nextValue);
      } else {
        element.addValue(key, motionValue((_a = element.getStaticValue(key)) !== null && _a !== void 0 ? _a : nextValue));
      }
    }
  }
  // Handle removed values
  for (var key in prev) {
    if (next[key] === undefined) element.removeValue(key);
  }
  return next;
}
var visualElement = function (_a) {
  var _b = _a.treeType,
    treeType = _b === void 0 ? "" : _b,
    build = _a.build,
    getBaseTarget = _a.getBaseTarget,
    makeTargetAnimatable = _a.makeTargetAnimatable,
    measureViewportBox = _a.measureViewportBox,
    renderInstance = _a.render,
    readValueFromInstance = _a.readValueFromInstance,
    removeValueFromRenderState = _a.removeValueFromRenderState,
    sortNodePosition = _a.sortNodePosition,
    scrapeMotionValuesFromProps = _a.scrapeMotionValuesFromProps;
  return function (_a, options) {
    var parent = _a.parent,
      props = _a.props,
      presenceId = _a.presenceId,
      blockInitialAnimation = _a.blockInitialAnimation,
      visualState = _a.visualState,
      shouldReduceMotion = _a.shouldReduceMotion;
    if (options === void 0) {
      options = {};
    }
    var isMounted = false;
    var latestValues = visualState.latestValues,
      renderState = visualState.renderState;
    /**
     * The instance of the render-specific node that will be hydrated by the
     * exposed React ref. So for example, this visual element can host a
     * HTMLElement, plain object, or Three.js object. The functions provided
     * in VisualElementConfig allow us to interface with this instance.
     */
    var instance;
    /**
     * Manages the subscriptions for a visual element's lifecycle, for instance
     * onRender
     */
    var lifecycles = createLifecycles();
    /**
     * A map of all motion values attached to this visual element. Motion
     * values are source of truth for any given animated value. A motion
     * value might be provided externally by the component via props.
     */
    var values = new Map();
    /**
     * A map of every subscription that binds the provided or generated
     * motion values onChange listeners to this visual element.
     */
    var valueSubscriptions = new Map();
    /**
     * A reference to the previously-provided motion values as returned
     * from scrapeMotionValuesFromProps. We use the keys in here to determine
     * if any motion values need to be removed after props are updated.
     */
    var prevMotionValues = {};
    /**
     * When values are removed from all animation props we need to search
     * for a fallback value to animate to. These values are tracked in baseTarget.
     */
    var baseTarget = tslib.__assign({}, latestValues);
    // Internal methods ========================
    /**
     * On mount, this will be hydrated with a callback to disconnect
     * this visual element from its parent on unmount.
     */
    var removeFromVariantTree;
    /**
     * Render the element with the latest styles outside of the React
     * render lifecycle
     */
    function render() {
      if (!instance || !isMounted) return;
      triggerBuild();
      renderInstance(instance, renderState, props.style, element.projection);
    }
    function triggerBuild() {
      build(element, renderState, latestValues, options, props);
    }
    function update() {
      lifecycles.notifyUpdate(latestValues);
    }
    /**
     *
     */
    function bindToMotionValue(key, value) {
      var removeOnChange = value.onChange(function (latestValue) {
        latestValues[key] = latestValue;
        props.onUpdate && sync__default["default"].update(update, false, true);
      });
      var removeOnRenderRequest = value.onRenderRequest(element.scheduleRender);
      valueSubscriptions.set(key, function () {
        removeOnChange();
        removeOnRenderRequest();
      });
    }
    /**
     * Any motion values that are provided to the element when created
     * aren't yet bound to the element, as this would technically be impure.
     * However, we iterate through the motion values and set them to the
     * initial values for this component.
     *
     * TODO: This is impure and we should look at changing this to run on mount.
     * Doing so will break some tests but this isn't neccessarily a breaking change,
     * more a reflection of the test.
     */
    var initialMotionValues = scrapeMotionValuesFromProps(props);
    for (var key in initialMotionValues) {
      var value = initialMotionValues[key];
      if (latestValues[key] !== undefined && isMotionValue(value)) {
        value.set(latestValues[key], false);
      }
    }
    /**
     * Determine what role this visual element should take in the variant tree.
     */
    var isControllingVariants = checkIfControllingVariants(props);
    var isVariantNode = checkIfVariantNode(props);
    var element = tslib.__assign(tslib.__assign({
      treeType: treeType,
      /**
       * This is a mirror of the internal instance prop, which keeps
       * VisualElement type-compatible with React's RefObject.
       */
      current: null,
      /**
       * The depth of this visual element within the visual element tree.
       */
      depth: parent ? parent.depth + 1 : 0,
      parent: parent,
      children: new Set(),
      /**
       *
       */
      presenceId: presenceId,
      shouldReduceMotion: shouldReduceMotion,
      /**
       * If this component is part of the variant tree, it should track
       * any children that are also part of the tree. This is essentially
       * a shadow tree to simplify logic around how to stagger over children.
       */
      variantChildren: isVariantNode ? new Set() : undefined,
      /**
       * Whether this instance is visible. This can be changed imperatively
       * by the projection tree, is analogous to CSS's visibility in that
       * hidden elements should take up layout, and needs enacting by the configured
       * render function.
       */
      isVisible: undefined,
      /**
       * Normally, if a component is controlled by a parent's variants, it can
       * rely on that ancestor to trigger animations further down the tree.
       * However, if a component is created after its parent is mounted, the parent
       * won't trigger that mount animation so the child needs to.
       *
       * TODO: This might be better replaced with a method isParentMounted
       */
      manuallyAnimateOnMount: Boolean(parent === null || parent === void 0 ? void 0 : parent.isMounted()),
      /**
       * This can be set by AnimatePresence to force components that mount
       * at the same time as it to mount as if they have initial={false} set.
       */
      blockInitialAnimation: blockInitialAnimation,
      /**
       * Determine whether this component has mounted yet. This is mostly used
       * by variant children to determine whether they need to trigger their
       * own animations on mount.
       */
      isMounted: function () {
        return Boolean(instance);
      },
      mount: function (newInstance) {
        isMounted = true;
        instance = element.current = newInstance;
        if (element.projection) {
          element.projection.mount(newInstance);
        }
        if (isVariantNode && parent && !isControllingVariants) {
          removeFromVariantTree = parent === null || parent === void 0 ? void 0 : parent.addVariantChild(element);
        }
        values.forEach(function (value, key) {
          return bindToMotionValue(key, value);
        });
        parent === null || parent === void 0 ? void 0 : parent.children.add(element);
        element.setProps(props);
      },
      /**
       *
       */
      unmount: function () {
        var _a;
        (_a = element.projection) === null || _a === void 0 ? void 0 : _a.unmount();
        sync.cancelSync.update(update);
        sync.cancelSync.render(render);
        valueSubscriptions.forEach(function (remove) {
          return remove();
        });
        removeFromVariantTree === null || removeFromVariantTree === void 0 ? void 0 : removeFromVariantTree();
        parent === null || parent === void 0 ? void 0 : parent.children.delete(element);
        lifecycles.clearAllListeners();
        instance = undefined;
        isMounted = false;
      },
      /**
       * Add a child visual element to our set of children.
       */
      addVariantChild: function (child) {
        var _a;
        var closestVariantNode = element.getClosestVariantNode();
        if (closestVariantNode) {
          (_a = closestVariantNode.variantChildren) === null || _a === void 0 ? void 0 : _a.add(child);
          return function () {
            return closestVariantNode.variantChildren.delete(child);
          };
        }
      },
      sortNodePosition: function (other) {
        /**
         * If these nodes aren't even of the same type we can't compare their depth.
         */
        if (!sortNodePosition || treeType !== other.treeType) return 0;
        return sortNodePosition(element.getInstance(), other.getInstance());
      },
      /**
       * Returns the closest variant node in the tree starting from
       * this visual element.
       */
      getClosestVariantNode: function () {
        return isVariantNode ? element : parent === null || parent === void 0 ? void 0 : parent.getClosestVariantNode();
      },
      /**
       * Expose the latest layoutId prop.
       */
      getLayoutId: function () {
        return props.layoutId;
      },
      /**
       * Returns the current instance.
       */
      getInstance: function () {
        return instance;
      },
      /**
       * Get/set the latest static values.
       */
      getStaticValue: function (key) {
        return latestValues[key];
      },
      setStaticValue: function (key, value) {
        return latestValues[key] = value;
      },
      /**
       * Returns the latest motion value state. Currently only used to take
       * a snapshot of the visual element - perhaps this can return the whole
       * visual state
       */
      getLatestValues: function () {
        return latestValues;
      },
      /**
       * Set the visiblity of the visual element. If it's changed, schedule
       * a render to reflect these changes.
       */
      setVisibility: function (visibility) {
        if (element.isVisible === visibility) return;
        element.isVisible = visibility;
        element.scheduleRender();
      },
      /**
       * Make a target animatable by Popmotion. For instance, if we're
       * trying to animate width from 100px to 100vw we need to measure 100vw
       * in pixels to determine what we really need to animate to. This is also
       * pluggable to support Framer's custom value types like Color,
       * and CSS variables.
       */
      makeTargetAnimatable: function (target, canMutate) {
        if (canMutate === void 0) {
          canMutate = true;
        }
        return makeTargetAnimatable(element, target, props, canMutate);
      },
      /**
       * Measure the current viewport box with or without transforms.
       * Only measures axis-aligned boxes, rotate and skew must be manually
       * removed with a re-render to work.
       */
      measureViewportBox: function () {
        return measureViewportBox(instance, props);
      },
      // Motion values ========================
      /**
       * Add a motion value and bind it to this visual element.
       */
      addValue: function (key, value) {
        // Remove existing value if it exists
        if (element.hasValue(key)) element.removeValue(key);
        values.set(key, value);
        latestValues[key] = value.get();
        bindToMotionValue(key, value);
      },
      /**
       * Remove a motion value and unbind any active subscriptions.
       */
      removeValue: function (key) {
        var _a;
        values.delete(key);
        (_a = valueSubscriptions.get(key)) === null || _a === void 0 ? void 0 : _a();
        valueSubscriptions.delete(key);
        delete latestValues[key];
        removeValueFromRenderState(key, renderState);
      },
      /**
       * Check whether we have a motion value for this key
       */
      hasValue: function (key) {
        return values.has(key);
      },
      /**
       * Get a motion value for this key. If called with a default
       * value, we'll create one if none exists.
       */
      getValue: function (key, defaultValue) {
        var value = values.get(key);
        if (value === undefined && defaultValue !== undefined) {
          value = motionValue(defaultValue);
          element.addValue(key, value);
        }
        return value;
      },
      /**
       * Iterate over our motion values.
       */
      forEachValue: function (callback) {
        return values.forEach(callback);
      },
      /**
       * If we're trying to animate to a previously unencountered value,
       * we need to check for it in our state and as a last resort read it
       * directly from the instance (which might have performance implications).
       */
      readValue: function (key) {
        var _a;
        return (_a = latestValues[key]) !== null && _a !== void 0 ? _a : readValueFromInstance(instance, key, options);
      },
      /**
       * Set the base target to later animate back to. This is currently
       * only hydrated on creation and when we first read a value.
       */
      setBaseTarget: function (key, value) {
        baseTarget[key] = value;
      },
      /**
       * Find the base target for a value thats been removed from all animation
       * props.
       */
      getBaseTarget: function (key) {
        if (getBaseTarget) {
          var target = getBaseTarget(props, key);
          if (target !== undefined && !isMotionValue(target)) return target;
        }
        return baseTarget[key];
      }
    }, lifecycles), {
      /**
       * Build the renderer state based on the latest visual state.
       */
      build: function () {
        triggerBuild();
        return renderState;
      },
      /**
       * Schedule a render on the next animation frame.
       */
      scheduleRender: function () {
        sync__default["default"].render(render, false, true);
      },
      /**
       * Synchronously fire render. It's prefered that we batch renders but
       * in many circumstances, like layout measurement, we need to run this
       * synchronously. However in those instances other measures should be taken
       * to batch reads/writes.
       */
      syncRender: render,
      /**
       * Update the provided props. Ensure any newly-added motion values are
       * added to our map, old ones removed, and listeners updated.
       */
      setProps: function (newProps) {
        if (newProps.transformTemplate || props.transformTemplate) {
          element.scheduleRender();
        }
        props = newProps;
        lifecycles.updatePropListeners(newProps);
        prevMotionValues = updateMotionValuesFromProps(element, scrapeMotionValuesFromProps(props), prevMotionValues);
      },
      getProps: function () {
        return props;
      },
      // Variants ==============================
      /**
       * Returns the variant definition with a given name.
       */
      getVariant: function (name) {
        var _a;
        return (_a = props.variants) === null || _a === void 0 ? void 0 : _a[name];
      },
      /**
       * Returns the defined default transition on this component.
       */
      getDefaultTransition: function () {
        return props.transition;
      },
      getTransformPagePoint: function () {
        return props.transformPagePoint;
      },
      /**
       * Used by child variant nodes to get the closest ancestor variant props.
       */
      getVariantContext: function (startAtParent) {
        if (startAtParent === void 0) {
          startAtParent = false;
        }
        if (startAtParent) return parent === null || parent === void 0 ? void 0 : parent.getVariantContext();
        if (!isControllingVariants) {
          var context_1 = (parent === null || parent === void 0 ? void 0 : parent.getVariantContext()) || {};
          if (props.initial !== undefined) {
            context_1.initial = props.initial;
          }
          return context_1;
        }
        var context = {};
        for (var i = 0; i < numVariantProps; i++) {
          var name_1 = variantProps[i];
          var prop = props[name_1];
          if (isVariantLabel(prop) || prop === false) {
            context[name_1] = prop;
          }
        }
        return context;
      }
    });
    return element;
  };
};
var variantProps = tslib.__spreadArray(["initial"], tslib.__read(variantPriorityOrder), false);
var numVariantProps = variantProps.length;
function isCSSVariable(value) {
  return typeof value === "string" && value.startsWith("var(--");
}
/**
 * Parse Framer's special CSS variable format into a CSS token and a fallback.
 *
 * ```
 * `var(--foo, #fff)` => [`--foo`, '#fff']
 * ```
 *
 * @param current
 */
var cssVariableRegex = /var\((--[a-zA-Z0-9-_]+),? ?([a-zA-Z0-9 ()%#.,-]+)?\)/;
function parseCSSVariable(current) {
  var match = cssVariableRegex.exec(current);
  if (!match) return [,];
  var _a = tslib.__read(match, 3),
    token = _a[1],
    fallback = _a[2];
  return [token, fallback];
}
var maxDepth = 4;
function getVariableValue(current, element, depth) {
  if (depth === void 0) {
    depth = 1;
  }
  heyListen.invariant(depth <= maxDepth, "Max CSS variable fallback depth detected in property \"".concat(current, "\". This may indicate a circular fallback dependency."));
  var _a = tslib.__read(parseCSSVariable(current), 2),
    token = _a[0],
    fallback = _a[1];
  // No CSS variable detected
  if (!token) return;
  // Attempt to read this CSS variable off the element
  var resolved = window.getComputedStyle(element).getPropertyValue(token);
  if (resolved) {
    return resolved.trim();
  } else if (isCSSVariable(fallback)) {
    // The fallback might itself be a CSS variable, in which case we attempt to resolve it too.
    return getVariableValue(fallback, element, depth + 1);
  } else {
    return fallback;
  }
}
/**
 * Resolve CSS variables from
 *
 * @internal
 */
function resolveCSSVariables(visualElement, _a, transitionEnd) {
  var _b;
  var target = tslib.__rest(_a, []);
  var element = visualElement.getInstance();
  if (!(element instanceof Element)) return {
    target: target,
    transitionEnd: transitionEnd
  };
  // If `transitionEnd` isn't `undefined`, clone it. We could clone `target` and `transitionEnd`
  // only if they change but I think this reads clearer and this isn't a performance-critical path.
  if (transitionEnd) {
    transitionEnd = tslib.__assign({}, transitionEnd);
  }
  // Go through existing `MotionValue`s and ensure any existing CSS variables are resolved
  visualElement.forEachValue(function (value) {
    var current = value.get();
    if (!isCSSVariable(current)) return;
    var resolved = getVariableValue(current, element);
    if (resolved) value.set(resolved);
  });
  // Cycle through every target property and resolve CSS variables. Currently
  // we only read single-var properties like `var(--foo)`, not `calc(var(--foo) + 20px)`
  for (var key in target) {
    var current = target[key];
    if (!isCSSVariable(current)) continue;
    var resolved = getVariableValue(current, element);
    if (!resolved) continue;
    // Clone target if it hasn't already been
    target[key] = resolved;
    // If the user hasn't already set this key on `transitionEnd`, set it to the unresolved
    // CSS variable. This will ensure that after the animation the component will reflect
    // changes in the value of the CSS variable.
    if (transitionEnd) (_b = transitionEnd[key]) !== null && _b !== void 0 ? _b : transitionEnd[key] = current;
  }
  return {
    target: target,
    transitionEnd: transitionEnd
  };
}
var positionalKeys = new Set(["width", "height", "top", "left", "right", "bottom", "x", "y"]);
var isPositionalKey = function (key) {
  return positionalKeys.has(key);
};
var hasPositionalKey = function (target) {
  return Object.keys(target).some(isPositionalKey);
};
var setAndResetVelocity = function (value, to) {
  // Looks odd but setting it twice doesn't render, it'll just
  // set both prev and current to the latest value
  value.set(to, false);
  value.set(to);
};
var isNumOrPxType = function (v) {
  return v === styleValueTypes.number || v === styleValueTypes.px;
};
var BoundingBoxDimension;
(function (BoundingBoxDimension) {
  BoundingBoxDimension["width"] = "width";
  BoundingBoxDimension["height"] = "height";
  BoundingBoxDimension["left"] = "left";
  BoundingBoxDimension["right"] = "right";
  BoundingBoxDimension["top"] = "top";
  BoundingBoxDimension["bottom"] = "bottom";
})(BoundingBoxDimension || (BoundingBoxDimension = {}));
var getPosFromMatrix = function (matrix, pos) {
  return parseFloat(matrix.split(", ")[pos]);
};
var getTranslateFromMatrix = function (pos2, pos3) {
  return function (_bbox, _a) {
    var transform = _a.transform;
    if (transform === "none" || !transform) return 0;
    var matrix3d = transform.match(/^matrix3d\((.+)\)$/);
    if (matrix3d) {
      return getPosFromMatrix(matrix3d[1], pos3);
    } else {
      var matrix = transform.match(/^matrix\((.+)\)$/);
      if (matrix) {
        return getPosFromMatrix(matrix[1], pos2);
      } else {
        return 0;
      }
    }
  };
};
var transformKeys = new Set(["x", "y", "z"]);
var nonTranslationalTransformKeys = transformProps.filter(function (key) {
  return !transformKeys.has(key);
});
function removeNonTranslationalTransform(visualElement) {
  var removedTransforms = [];
  nonTranslationalTransformKeys.forEach(function (key) {
    var value = visualElement.getValue(key);
    if (value !== undefined) {
      removedTransforms.push([key, value.get()]);
      value.set(key.startsWith("scale") ? 1 : 0);
    }
  });
  // Apply changes to element before measurement
  if (removedTransforms.length) visualElement.syncRender();
  return removedTransforms;
}
var positionalValues = {
  // Dimensions
  width: function (_a, _b) {
    var x = _a.x;
    var _c = _b.paddingLeft,
      paddingLeft = _c === void 0 ? "0" : _c,
      _d = _b.paddingRight,
      paddingRight = _d === void 0 ? "0" : _d;
    return x.max - x.min - parseFloat(paddingLeft) - parseFloat(paddingRight);
  },
  height: function (_a, _b) {
    var y = _a.y;
    var _c = _b.paddingTop,
      paddingTop = _c === void 0 ? "0" : _c,
      _d = _b.paddingBottom,
      paddingBottom = _d === void 0 ? "0" : _d;
    return y.max - y.min - parseFloat(paddingTop) - parseFloat(paddingBottom);
  },
  top: function (_bbox, _a) {
    var top = _a.top;
    return parseFloat(top);
  },
  left: function (_bbox, _a) {
    var left = _a.left;
    return parseFloat(left);
  },
  bottom: function (_a, _b) {
    var y = _a.y;
    var top = _b.top;
    return parseFloat(top) + (y.max - y.min);
  },
  right: function (_a, _b) {
    var x = _a.x;
    var left = _b.left;
    return parseFloat(left) + (x.max - x.min);
  },
  // Transform
  x: getTranslateFromMatrix(4, 13),
  y: getTranslateFromMatrix(5, 14)
};
var convertChangedValueTypes = function (target, visualElement, changedKeys) {
  var originBbox = visualElement.measureViewportBox();
  var element = visualElement.getInstance();
  var elementComputedStyle = getComputedStyle(element);
  var display = elementComputedStyle.display;
  var origin = {};
  // If the element is currently set to display: "none", make it visible before
  // measuring the target bounding box
  if (display === "none") {
    visualElement.setStaticValue("display", target.display || "block");
  }
  /**
   * Record origins before we render and update styles
   */
  changedKeys.forEach(function (key) {
    origin[key] = positionalValues[key](originBbox, elementComputedStyle);
  });
  // Apply the latest values (as set in checkAndConvertChangedValueTypes)
  visualElement.syncRender();
  var targetBbox = visualElement.measureViewportBox();
  changedKeys.forEach(function (key) {
    // Restore styles to their **calculated computed style**, not their actual
    // originally set style. This allows us to animate between equivalent pixel units.
    var value = visualElement.getValue(key);
    setAndResetVelocity(value, origin[key]);
    target[key] = positionalValues[key](targetBbox, elementComputedStyle);
  });
  return target;
};
var checkAndConvertChangedValueTypes = function (visualElement, target, origin, transitionEnd) {
  if (origin === void 0) {
    origin = {};
  }
  if (transitionEnd === void 0) {
    transitionEnd = {};
  }
  target = tslib.__assign({}, target);
  transitionEnd = tslib.__assign({}, transitionEnd);
  var targetPositionalKeys = Object.keys(target).filter(isPositionalKey);
  // We want to remove any transform values that could affect the element's bounding box before
  // it's measured. We'll reapply these later.
  var removedTransformValues = [];
  var hasAttemptedToRemoveTransformValues = false;
  var changedValueTypeKeys = [];
  targetPositionalKeys.forEach(function (key) {
    var value = visualElement.getValue(key);
    if (!visualElement.hasValue(key)) return;
    var from = origin[key];
    var fromType = findDimensionValueType(from);
    var to = target[key];
    var toType;
    // TODO: The current implementation of this basically throws an error
    // if you try and do value conversion via keyframes. There's probably
    // a way of doing this but the performance implications would need greater scrutiny,
    // as it'd be doing multiple resize-remeasure operations.
    if (isKeyframesTarget(to)) {
      var numKeyframes = to.length;
      var fromIndex = to[0] === null ? 1 : 0;
      from = to[fromIndex];
      fromType = findDimensionValueType(from);
      for (var i = fromIndex; i < numKeyframes; i++) {
        if (!toType) {
          toType = findDimensionValueType(to[i]);
          heyListen.invariant(toType === fromType || isNumOrPxType(fromType) && isNumOrPxType(toType), "Keyframes must be of the same dimension as the current value");
        } else {
          heyListen.invariant(findDimensionValueType(to[i]) === toType, "All keyframes must be of the same type");
        }
      }
    } else {
      toType = findDimensionValueType(to);
    }
    if (fromType !== toType) {
      // If they're both just number or px, convert them both to numbers rather than
      // relying on resize/remeasure to convert (which is wasteful in this situation)
      if (isNumOrPxType(fromType) && isNumOrPxType(toType)) {
        var current = value.get();
        if (typeof current === "string") {
          value.set(parseFloat(current));
        }
        if (typeof to === "string") {
          target[key] = parseFloat(to);
        } else if (Array.isArray(to) && toType === styleValueTypes.px) {
          target[key] = to.map(parseFloat);
        }
      } else if ((fromType === null || fromType === void 0 ? void 0 : fromType.transform) && (toType === null || toType === void 0 ? void 0 : toType.transform) && (from === 0 || to === 0)) {
        // If one or the other value is 0, it's safe to coerce it to the
        // type of the other without measurement
        if (from === 0) {
          value.set(toType.transform(from));
        } else {
          target[key] = fromType.transform(to);
        }
      } else {
        // If we're going to do value conversion via DOM measurements, we first
        // need to remove non-positional transform values that could affect the bbox measurements.
        if (!hasAttemptedToRemoveTransformValues) {
          removedTransformValues = removeNonTranslationalTransform(visualElement);
          hasAttemptedToRemoveTransformValues = true;
        }
        changedValueTypeKeys.push(key);
        transitionEnd[key] = transitionEnd[key] !== undefined ? transitionEnd[key] : target[key];
        setAndResetVelocity(value, to);
      }
    }
  });
  if (changedValueTypeKeys.length) {
    var scrollY_1 = changedValueTypeKeys.indexOf("height") >= 0 ? window.pageYOffset : null;
    var convertedTarget = convertChangedValueTypes(target, visualElement, changedValueTypeKeys);
    // If we removed transform values, reapply them before the next render
    if (removedTransformValues.length) {
      removedTransformValues.forEach(function (_a) {
        var _b = tslib.__read(_a, 2),
          key = _b[0],
          value = _b[1];
        visualElement.getValue(key).set(value);
      });
    }
    // Reapply original values
    visualElement.syncRender();
    // Restore scroll position
    if (scrollY_1 !== null) window.scrollTo({
      top: scrollY_1
    });
    return {
      target: convertedTarget,
      transitionEnd: transitionEnd
    };
  } else {
    return {
      target: target,
      transitionEnd: transitionEnd
    };
  }
};
/**
 * Convert value types for x/y/width/height/top/left/bottom/right
 *
 * Allows animation between `'auto'` -> `'100%'` or `0` -> `'calc(50% - 10vw)'`
 *
 * @internal
 */
function unitConversion(visualElement, target, origin, transitionEnd) {
  return hasPositionalKey(target) ? checkAndConvertChangedValueTypes(visualElement, target, origin, transitionEnd) : {
    target: target,
    transitionEnd: transitionEnd
  };
}

/**
 * Parse a DOM variant to make it animatable. This involves resolving CSS variables
 * and ensuring animations like "20%" => "calc(50vw)" are performed in pixels.
 */
var parseDomVariant = function (visualElement, target, origin, transitionEnd) {
  var resolved = resolveCSSVariables(visualElement, target, transitionEnd);
  target = resolved.target;
  transitionEnd = resolved.transitionEnd;
  return unitConversion(visualElement, target, origin, transitionEnd);
};
function getComputedStyle$1(element) {
  return window.getComputedStyle(element);
}
var htmlConfig = {
  treeType: "dom",
  readValueFromInstance: function (domElement, key) {
    if (isTransformProp(key)) {
      var defaultType = getDefaultValueType(key);
      return defaultType ? defaultType.default || 0 : 0;
    } else {
      var computedStyle = getComputedStyle$1(domElement);
      return (isCSSVariable$1(key) ? computedStyle.getPropertyValue(key) : computedStyle[key]) || 0;
    }
  },
  sortNodePosition: function (a, b) {
    /**
     * compareDocumentPosition returns a bitmask, by using the bitwise &
     * we're returning true if 2 in that bitmask is set to true. 2 is set
     * to true if b preceeds a.
     */
    return a.compareDocumentPosition(b) & 2 ? 1 : -1;
  },
  getBaseTarget: function (props, key) {
    var _a;
    return (_a = props.style) === null || _a === void 0 ? void 0 : _a[key];
  },
  measureViewportBox: function (element, _a) {
    var transformPagePoint = _a.transformPagePoint;
    return measureViewportBox(element, transformPagePoint);
  },
  /**
   * Reset the transform on the current Element. This is called as part
   * of a batched process across the entire layout tree. To remove this write
   * cycle it'd be interesting to see if it's possible to "undo" all the current
   * layout transforms up the tree in the same way this.getBoundingBoxWithoutTransforms
   * works
   */
  resetTransform: function (element, domElement, props) {
    var transformTemplate = props.transformTemplate;
    domElement.style.transform = transformTemplate ? transformTemplate({}, "") : "none";
    // Ensure that whatever happens next, we restore our transform on the next frame
    element.scheduleRender();
  },
  restoreTransform: function (instance, mutableState) {
    instance.style.transform = mutableState.style.transform;
  },
  removeValueFromRenderState: function (key, _a) {
    var vars = _a.vars,
      style = _a.style;
    delete vars[key];
    delete style[key];
  },
  /**
   * Ensure that HTML and Framer-specific value types like `px`->`%` and `Color`
   * can be animated by Motion.
   */
  makeTargetAnimatable: function (element, _a, _b, isMounted) {
    var transformValues = _b.transformValues;
    if (isMounted === void 0) {
      isMounted = true;
    }
    var transition = _a.transition,
      transitionEnd = _a.transitionEnd,
      target = tslib.__rest(_a, ["transition", "transitionEnd"]);
    var origin = getOrigin(target, transition || {}, element);
    /**
     * If Framer has provided a function to convert `Color` etc value types, convert them
     */
    if (transformValues) {
      if (transitionEnd) transitionEnd = transformValues(transitionEnd);
      if (target) target = transformValues(target);
      if (origin) origin = transformValues(origin);
    }
    if (isMounted) {
      checkTargetForNewValues(element, target, origin);
      var parsed = parseDomVariant(element, target, origin, transitionEnd);
      transitionEnd = parsed.transitionEnd;
      target = parsed.target;
    }
    return tslib.__assign({
      transition: transition,
      transitionEnd: transitionEnd
    }, target);
  },
  scrapeMotionValuesFromProps: scrapeMotionValuesFromProps$1,
  build: function (element, renderState, latestValues, options, props) {
    if (element.isVisible !== undefined) {
      renderState.style.visibility = element.isVisible ? "visible" : "hidden";
    }
    buildHTMLStyles(renderState, latestValues, options, props.transformTemplate);
  },
  render: renderHTML
};
var htmlVisualElement = visualElement(htmlConfig);
var svgVisualElement = visualElement(tslib.__assign(tslib.__assign({}, htmlConfig), {
  getBaseTarget: function (props, key) {
    return props[key];
  },
  readValueFromInstance: function (domElement, key) {
    var _a;
    if (isTransformProp(key)) {
      return ((_a = getDefaultValueType(key)) === null || _a === void 0 ? void 0 : _a.default) || 0;
    }
    key = !camelCaseAttributes.has(key) ? camelToDash(key) : key;
    return domElement.getAttribute(key);
  },
  scrapeMotionValuesFromProps: scrapeMotionValuesFromProps,
  build: function (_element, renderState, latestValues, options, props) {
    buildSVGAttrs(renderState, latestValues, options, props.transformTemplate);
  },
  render: renderSVG
}));
var createDomVisualElement = function (Component, options) {
  return isSVGComponent(Component) ? svgVisualElement(options, {
    enableHardwareAcceleration: false
  }) : htmlVisualElement(options, {
    enableHardwareAcceleration: true
  });
};
function pixelsToPercent(pixels, axis) {
  if (axis.max === axis.min) return 0;
  return pixels / (axis.max - axis.min) * 100;
}
/**
 * We always correct borderRadius as a percentage rather than pixels to reduce paints.
 * For example, if you are projecting a box that is 100px wide with a 10px borderRadius
 * into a box that is 200px wide with a 20px borderRadius, that is actually a 10%
 * borderRadius in both states. If we animate between the two in pixels that will trigger
 * a paint each time. If we animate between the two in percentage we'll avoid a paint.
 */
var correctBorderRadius = {
  correct: function (latest, node) {
    if (!node.target) return latest;
    /**
     * If latest is a string, if it's a percentage we can return immediately as it's
     * going to be stretched appropriately. Otherwise, if it's a pixel, convert it to a number.
     */
    if (typeof latest === "string") {
      if (styleValueTypes.px.test(latest)) {
        latest = parseFloat(latest);
      } else {
        return latest;
      }
    }
    /**
     * If latest is a number, it's a pixel value. We use the current viewportBox to calculate that
     * pixel value as a percentage of each axis
     */
    var x = pixelsToPercent(latest, node.target.x);
    var y = pixelsToPercent(latest, node.target.y);
    return "".concat(x, "% ").concat(y, "%");
  }
};
var varToken = "_$css";
var correctBoxShadow = {
  correct: function (latest, _a) {
    var treeScale = _a.treeScale,
      projectionDelta = _a.projectionDelta;
    var original = latest;
    /**
     * We need to first strip and store CSS variables from the string.
     */
    var containsCSSVariables = latest.includes("var(");
    var cssVariables = [];
    if (containsCSSVariables) {
      latest = latest.replace(cssVariableRegex, function (match) {
        cssVariables.push(match);
        return varToken;
      });
    }
    var shadow = styleValueTypes.complex.parse(latest);
    // TODO: Doesn't support multiple shadows
    if (shadow.length > 5) return original;
    var template = styleValueTypes.complex.createTransformer(latest);
    var offset = typeof shadow[0] !== "number" ? 1 : 0;
    // Calculate the overall context scale
    var xScale = projectionDelta.x.scale * treeScale.x;
    var yScale = projectionDelta.y.scale * treeScale.y;
    shadow[0 + offset] /= xScale;
    shadow[1 + offset] /= yScale;
    /**
     * Ideally we'd correct x and y scales individually, but because blur and
     * spread apply to both we have to take a scale average and apply that instead.
     * We could potentially improve the outcome of this by incorporating the ratio between
     * the two scales.
     */
    var averageScale = popmotion.mix(xScale, yScale, 0.5);
    // Blur
    if (typeof shadow[2 + offset] === "number") shadow[2 + offset] /= averageScale;
    // Spread
    if (typeof shadow[3 + offset] === "number") shadow[3 + offset] /= averageScale;
    var output = template(shadow);
    if (containsCSSVariables) {
      var i_1 = 0;
      output = output.replace(varToken, function () {
        var cssVariable = cssVariables[i_1];
        i_1++;
        return cssVariable;
      });
    }
    return output;
  }
};
var MeasureLayoutWithContext = /** @class */function (_super) {
  tslib.__extends(MeasureLayoutWithContext, _super);
  function MeasureLayoutWithContext() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * This only mounts projection nodes for components that
   * need measuring, we might want to do it for all components
   * in order to incorporate transforms
   */
  MeasureLayoutWithContext.prototype.componentDidMount = function () {
    var _this = this;
    var _a = this.props,
      visualElement = _a.visualElement,
      layoutGroup = _a.layoutGroup,
      switchLayoutGroup = _a.switchLayoutGroup,
      layoutId = _a.layoutId;
    var projection = visualElement.projection;
    addScaleCorrector(defaultScaleCorrectors);
    if (projection) {
      if (layoutGroup === null || layoutGroup === void 0 ? void 0 : layoutGroup.group) layoutGroup.group.add(projection);
      if ((switchLayoutGroup === null || switchLayoutGroup === void 0 ? void 0 : switchLayoutGroup.register) && layoutId) {
        switchLayoutGroup.register(projection);
      }
      projection.root.didUpdate();
      projection.addEventListener("animationComplete", function () {
        _this.safeToRemove();
      });
      projection.setOptions(tslib.__assign(tslib.__assign({}, projection.options), {
        onExitComplete: function () {
          return _this.safeToRemove();
        }
      }));
    }
    globalProjectionState.hasEverUpdated = true;
  };
  MeasureLayoutWithContext.prototype.getSnapshotBeforeUpdate = function (prevProps) {
    var _this = this;
    var _a = this.props,
      layoutDependency = _a.layoutDependency,
      visualElement = _a.visualElement,
      drag = _a.drag,
      isPresent = _a.isPresent;
    var projection = visualElement.projection;
    if (!projection) return null;
    /**
     * TODO: We use this data in relegate to determine whether to
     * promote a previous element. There's no guarantee its presence data
     * will have updated by this point - if a bug like this arises it will
     * have to be that we markForRelegation and then find a new lead some other way,
     * perhaps in didUpdate
     */
    projection.isPresent = isPresent;
    if (drag || prevProps.layoutDependency !== layoutDependency || layoutDependency === undefined) {
      projection.willUpdate();
    } else {
      this.safeToRemove();
    }
    if (prevProps.isPresent !== isPresent) {
      if (isPresent) {
        projection.promote();
      } else if (!projection.relegate()) {
        /**
         * If there's another stack member taking over from this one,
         * it's in charge of the exit animation and therefore should
         * be in charge of the safe to remove. Otherwise we call it here.
         */
        sync__default["default"].postRender(function () {
          var _a;
          if (!((_a = projection.getStack()) === null || _a === void 0 ? void 0 : _a.members.length)) {
            _this.safeToRemove();
          }
        });
      }
    }
    return null;
  };
  MeasureLayoutWithContext.prototype.componentDidUpdate = function () {
    var projection = this.props.visualElement.projection;
    if (projection) {
      projection.root.didUpdate();
      if (!projection.currentAnimation && projection.isLead()) {
        this.safeToRemove();
      }
    }
  };
  MeasureLayoutWithContext.prototype.componentWillUnmount = function () {
    var _a = this.props,
      visualElement = _a.visualElement,
      layoutGroup = _a.layoutGroup,
      promoteContext = _a.switchLayoutGroup;
    var projection = visualElement.projection;
    if (projection) {
      projection.scheduleCheckAfterUnmount();
      if (layoutGroup === null || layoutGroup === void 0 ? void 0 : layoutGroup.group) layoutGroup.group.remove(projection);
      if (promoteContext === null || promoteContext === void 0 ? void 0 : promoteContext.deregister) promoteContext.deregister(projection);
    }
  };
  MeasureLayoutWithContext.prototype.safeToRemove = function () {
    var safeToRemove = this.props.safeToRemove;
    safeToRemove === null || safeToRemove === void 0 ? void 0 : safeToRemove();
  };
  MeasureLayoutWithContext.prototype.render = function () {
    return null;
  };
  return MeasureLayoutWithContext;
}(React__default["default"].Component);
function MeasureLayout(props) {
  var _a = tslib.__read(usePresence(), 2),
    isPresent = _a[0],
    safeToRemove = _a[1];
  var layoutGroup = React.useContext(LayoutGroupContext);
  return React__default["default"].createElement(MeasureLayoutWithContext, tslib.__assign({}, props, {
    layoutGroup: layoutGroup,
    switchLayoutGroup: React.useContext(SwitchLayoutGroupContext),
    isPresent: isPresent,
    safeToRemove: safeToRemove
  }));
}
var defaultScaleCorrectors = {
  borderRadius: tslib.__assign(tslib.__assign({}, correctBorderRadius), {
    applyTo: ["borderTopLeftRadius", "borderTopRightRadius", "borderBottomLeftRadius", "borderBottomRightRadius"]
  }),
  borderTopLeftRadius: correctBorderRadius,
  borderTopRightRadius: correctBorderRadius,
  borderBottomLeftRadius: correctBorderRadius,
  borderBottomRightRadius: correctBorderRadius,
  boxShadow: correctBoxShadow
};
var layoutFeatures = {
  measureLayout: MeasureLayout
};

/**
 * Animate a single value or a `MotionValue`.
 *
 * The first argument is either a `MotionValue` to animate, or an initial animation value.
 *
 * The second is either a value to animate to, or an array of keyframes to animate through.
 *
 * The third argument can be either tween or spring options, and optional lifecycle methods: `onUpdate`, `onPlay`, `onComplete`, `onRepeat` and `onStop`.
 *
 * Returns `AnimationPlaybackControls`, currently just a `stop` method.
 *
 * ```javascript
 * const x = useMotionValue(0)
 *
 * useEffect(() => {
 *   const controls = animate(x, 100, {
 *     type: "spring",
 *     stiffness: 2000,
 *     onComplete: v => {}
 *   })
 *
 *   return controls.stop
 * })
 * ```
 *
 * @public
 */
function animate(from, to, transition) {
  if (transition === void 0) {
    transition = {};
  }
  var value = isMotionValue(from) ? from : motionValue(from);
  startAnimation("", value, to, transition);
  return {
    stop: function () {
      return value.stop();
    },
    isAnimating: function () {
      return value.isAnimating();
    }
  };
}
var borders = ["TopLeft", "TopRight", "BottomLeft", "BottomRight"];
var numBorders = borders.length;
var asNumber = function (value) {
  return typeof value === "string" ? parseFloat(value) : value;
};
var isPx = function (value) {
  return typeof value === "number" || styleValueTypes.px.test(value);
};
function mixValues(target, follow, lead, progress, shouldCrossfadeOpacity, isOnlyMember) {
  var _a, _b, _c, _d;
  if (shouldCrossfadeOpacity) {
    target.opacity = popmotion.mix(0,
    // (follow?.opacity as number) ?? 0,
    // TODO Reinstate this if only child
    (_a = lead.opacity) !== null && _a !== void 0 ? _a : 1, easeCrossfadeIn(progress));
    target.opacityExit = popmotion.mix((_b = follow.opacity) !== null && _b !== void 0 ? _b : 1, 0, easeCrossfadeOut(progress));
  } else if (isOnlyMember) {
    target.opacity = popmotion.mix((_c = follow.opacity) !== null && _c !== void 0 ? _c : 1, (_d = lead.opacity) !== null && _d !== void 0 ? _d : 1, progress);
  }
  /**
   * Mix border radius
   */
  for (var i = 0; i < numBorders; i++) {
    var borderLabel = "border".concat(borders[i], "Radius");
    var followRadius = getRadius(follow, borderLabel);
    var leadRadius = getRadius(lead, borderLabel);
    if (followRadius === undefined && leadRadius === undefined) continue;
    followRadius || (followRadius = 0);
    leadRadius || (leadRadius = 0);
    var canMix = followRadius === 0 || leadRadius === 0 || isPx(followRadius) === isPx(leadRadius);
    if (canMix) {
      target[borderLabel] = Math.max(popmotion.mix(asNumber(followRadius), asNumber(leadRadius), progress), 0);
      if (styleValueTypes.percent.test(leadRadius) || styleValueTypes.percent.test(followRadius)) {
        target[borderLabel] += "%";
      }
    } else {
      target[borderLabel] = leadRadius;
    }
  }
  /**
   * Mix rotation
   */
  if (follow.rotate || lead.rotate) {
    target.rotate = popmotion.mix(follow.rotate || 0, lead.rotate || 0, progress);
  }
}
function getRadius(values, radiusName) {
  var _a;
  return (_a = values[radiusName]) !== null && _a !== void 0 ? _a : values.borderRadius;
}
// /**
//  * We only want to mix the background color if there's a follow element
//  * that we're not crossfading opacity between. For instance with switch
//  * AnimateSharedLayout animations, this helps the illusion of a continuous
//  * element being animated but also cuts down on the number of paints triggered
//  * for elements where opacity is doing that work for us.
//  */
// if (
//     !hasFollowElement &&
//     latestLeadValues.backgroundColor &&
//     latestFollowValues.backgroundColor
// ) {
//     /**
//      * This isn't ideal performance-wise as mixColor is creating a new function every frame.
//      * We could probably create a mixer that runs at the start of the animation but
//      * the idea behind the crossfader is that it runs dynamically between two potentially
//      * changing targets (ie opacity or borderRadius may be animating independently via variants)
//      */
//     leadState.backgroundColor = followState.backgroundColor = mixColor(
//         latestFollowValues.backgroundColor as string,
//         latestLeadValues.backgroundColor as string
//     )(p)
// }
var easeCrossfadeIn = compress(0, 0.5, popmotion.circOut);
var easeCrossfadeOut = compress(0.5, 0.95, popmotion.linear);
function compress(min, max, easing) {
  return function (p) {
    // Could replace ifs with clamp
    if (p < min) return 0;
    if (p > max) return 1;
    return easing(popmotion.progress(min, max, p));
  };
}

/**
 * Reset an axis to the provided origin box.
 *
 * This is a mutative operation.
 */
function copyAxisInto(axis, originAxis) {
  axis.min = originAxis.min;
  axis.max = originAxis.max;
}
/**
 * Reset a box to the provided origin box.
 *
 * This is a mutative operation.
 */
function copyBoxInto(box, originBox) {
  copyAxisInto(box.x, originBox.x);
  copyAxisInto(box.y, originBox.y);
}

/**
 * Remove a delta from a point. This is essentially the steps of applyPointDelta in reverse
 */
function removePointDelta(point, translate, scale, originPoint, boxScale) {
  point -= translate;
  point = scalePoint(point, 1 / scale, originPoint);
  if (boxScale !== undefined) {
    point = scalePoint(point, 1 / boxScale, originPoint);
  }
  return point;
}
/**
 * Remove a delta from an axis. This is essentially the steps of applyAxisDelta in reverse
 */
function removeAxisDelta(axis, translate, scale, origin, boxScale, originAxis, sourceAxis) {
  if (translate === void 0) {
    translate = 0;
  }
  if (scale === void 0) {
    scale = 1;
  }
  if (origin === void 0) {
    origin = 0.5;
  }
  if (originAxis === void 0) {
    originAxis = axis;
  }
  if (sourceAxis === void 0) {
    sourceAxis = axis;
  }
  if (styleValueTypes.percent.test(translate)) {
    translate = parseFloat(translate);
    var relativeProgress = popmotion.mix(sourceAxis.min, sourceAxis.max, translate / 100);
    translate = relativeProgress - sourceAxis.min;
  }
  if (typeof translate !== "number") return;
  var originPoint = popmotion.mix(originAxis.min, originAxis.max, origin);
  if (axis === originAxis) originPoint -= translate;
  axis.min = removePointDelta(axis.min, translate, scale, originPoint, boxScale);
  axis.max = removePointDelta(axis.max, translate, scale, originPoint, boxScale);
}
/**
 * Remove a transforms from an axis. This is essentially the steps of applyAxisTransforms in reverse
 * and acts as a bridge between motion values and removeAxisDelta
 */
function removeAxisTransforms(axis, transforms, _a, origin, sourceAxis) {
  var _b = tslib.__read(_a, 3),
    key = _b[0],
    scaleKey = _b[1],
    originKey = _b[2];
  removeAxisDelta(axis, transforms[key], transforms[scaleKey], transforms[originKey], transforms.scale, origin, sourceAxis);
}
/**
 * The names of the motion values we want to apply as translation, scale and origin.
 */
var xKeys = ["x", "scaleX", "originX"];
var yKeys = ["y", "scaleY", "originY"];
/**
 * Remove a transforms from an box. This is essentially the steps of applyAxisBox in reverse
 * and acts as a bridge between motion values and removeAxisDelta
 */
function removeBoxTransforms(box, transforms, originBox, sourceBox) {
  removeAxisTransforms(box.x, transforms, xKeys, originBox === null || originBox === void 0 ? void 0 : originBox.x, sourceBox === null || sourceBox === void 0 ? void 0 : sourceBox.x);
  removeAxisTransforms(box.y, transforms, yKeys, originBox === null || originBox === void 0 ? void 0 : originBox.y, sourceBox === null || sourceBox === void 0 ? void 0 : sourceBox.y);
}
function isAxisDeltaZero(delta) {
  return delta.translate === 0 && delta.scale === 1;
}
function isDeltaZero(delta) {
  return isAxisDeltaZero(delta.x) && isAxisDeltaZero(delta.y);
}
function boxEquals(a, b) {
  return a.x.min === b.x.min && a.x.max === b.x.max && a.y.min === b.y.min && a.y.max === b.y.max;
}
var NodeStack = /** @class */function () {
  function NodeStack() {
    this.members = [];
  }
  NodeStack.prototype.add = function (node) {
    addUniqueItem(this.members, node);
    node.scheduleRender();
  };
  NodeStack.prototype.remove = function (node) {
    removeItem(this.members, node);
    if (node === this.prevLead) {
      this.prevLead = undefined;
    }
    if (node === this.lead) {
      var prevLead = this.members[this.members.length - 1];
      if (prevLead) {
        this.promote(prevLead);
      }
    }
  };
  NodeStack.prototype.relegate = function (node) {
    var indexOfNode = this.members.findIndex(function (member) {
      return node === member;
    });
    if (indexOfNode === 0) return false;
    /**
     * Find the next projection node that is present
     */
    var prevLead;
    for (var i = indexOfNode; i >= 0; i--) {
      var member = this.members[i];
      if (member.isPresent !== false) {
        prevLead = member;
        break;
      }
    }
    if (prevLead) {
      this.promote(prevLead);
      return true;
    } else {
      return false;
    }
  };
  NodeStack.prototype.promote = function (node, preserveFollowOpacity) {
    var _a;
    var prevLead = this.lead;
    if (node === prevLead) return;
    this.prevLead = prevLead;
    this.lead = node;
    node.show();
    if (prevLead) {
      prevLead.instance && prevLead.scheduleRender();
      node.scheduleRender();
      node.resumeFrom = prevLead;
      if (preserveFollowOpacity) {
        node.resumeFrom.preserveOpacity = true;
      }
      if (prevLead.snapshot) {
        node.snapshot = prevLead.snapshot;
        node.snapshot.latestValues = prevLead.animationValues || prevLead.latestValues;
        node.snapshot.isShared = true;
      }
      if ((_a = node.root) === null || _a === void 0 ? void 0 : _a.isUpdating) {
        node.isLayoutDirty = true;
      }
      var crossfade = node.options.crossfade;
      if (crossfade === false) {
        prevLead.hide();
      }
      /**
       * TODO:
       *   - Test border radius when previous node was deleted
       *   - boxShadow mixing
       *   - Shared between element A in scrolled container and element B (scroll stays the same or changes)
       *   - Shared between element A in transformed container and element B (transform stays the same or changes)
       *   - Shared between element A in scrolled page and element B (scroll stays the same or changes)
       * ---
       *   - Crossfade opacity of root nodes
       *   - layoutId changes after animation
       *   - layoutId changes mid animation
       */
    }
  };
  NodeStack.prototype.exitAnimationComplete = function () {
    this.members.forEach(function (node) {
      var _a, _b, _c, _d, _e;
      (_b = (_a = node.options).onExitComplete) === null || _b === void 0 ? void 0 : _b.call(_a);
      (_e = (_c = node.resumingFrom) === null || _c === void 0 ? void 0 : (_d = _c.options).onExitComplete) === null || _e === void 0 ? void 0 : _e.call(_d);
    });
  };
  NodeStack.prototype.scheduleRender = function () {
    this.members.forEach(function (node) {
      node.instance && node.scheduleRender(false);
    });
  };
  /**
   * Clear any leads that have been removed this render to prevent them from being
   * used in future animations and to prevent memory leaks
   */
  NodeStack.prototype.removeLeadSnapshot = function () {
    if (this.lead && this.lead.snapshot) {
      this.lead.snapshot = undefined;
    }
  };
  return NodeStack;
}();
var identityProjection = "translate3d(0px, 0px, 0) scale(1, 1) scale(1, 1)";
function buildProjectionTransform(delta, treeScale, latestTransform) {
  /**
   * The translations we use to calculate are always relative to the viewport coordinate space.
   * But when we apply scales, we also scale the coordinate space of an element and its children.
   * For instance if we have a treeScale (the culmination of all parent scales) of 0.5 and we need
   * to move an element 100 pixels, we actually need to move it 200 in within that scaled space.
   */
  var xTranslate = delta.x.translate / treeScale.x;
  var yTranslate = delta.y.translate / treeScale.y;
  var transform = "translate3d(".concat(xTranslate, "px, ").concat(yTranslate, "px, 0) ");
  /**
   * Apply scale correction for the tree transform.
   * This will apply scale to the screen-orientated axes.
   */
  transform += "scale(".concat(1 / treeScale.x, ", ").concat(1 / treeScale.y, ") ");
  if (latestTransform) {
    var rotate = latestTransform.rotate,
      rotateX = latestTransform.rotateX,
      rotateY = latestTransform.rotateY;
    if (rotate) transform += "rotate(".concat(rotate, "deg) ");
    if (rotateX) transform += "rotateX(".concat(rotateX, "deg) ");
    if (rotateY) transform += "rotateY(".concat(rotateY, "deg) ");
  }
  /**
   * Apply scale to match the size of the element to the size we want it.
   * This will apply scale to the element-orientated axes.
   */
  var elementScaleX = delta.x.scale * treeScale.x;
  var elementScaleY = delta.y.scale * treeScale.y;
  transform += "scale(".concat(elementScaleX, ", ").concat(elementScaleY, ")");
  return transform === identityProjection ? "none" : transform;
}
var compareByDepth = function (a, b) {
  return a.depth - b.depth;
};
var FlatTree = /** @class */function () {
  function FlatTree() {
    this.children = [];
    this.isDirty = false;
  }
  FlatTree.prototype.add = function (child) {
    addUniqueItem(this.children, child);
    this.isDirty = true;
  };
  FlatTree.prototype.remove = function (child) {
    removeItem(this.children, child);
    this.isDirty = true;
  };
  FlatTree.prototype.forEach = function (callback) {
    this.isDirty && this.children.sort(compareByDepth);
    this.isDirty = false;
    this.children.forEach(callback);
  };
  return FlatTree;
}();

/**
 * We use 1000 as the animation target as 0-1000 maps better to pixels than 0-1
 * which has a noticeable difference in spring animations
 */
var animationTarget = 1000;
function createProjectionNode(_a) {
  var attachResizeListener = _a.attachResizeListener,
    defaultParent = _a.defaultParent,
    measureScroll = _a.measureScroll,
    checkIsScrollRoot = _a.checkIsScrollRoot,
    resetTransform = _a.resetTransform;
  return /** @class */function () {
    function ProjectionNode(id, latestValues, parent) {
      var _this = this;
      if (latestValues === void 0) {
        latestValues = {};
      }
      if (parent === void 0) {
        parent = defaultParent === null || defaultParent === void 0 ? void 0 : defaultParent();
      }
      /**
       * A Set containing all this component's children. This is used to iterate
       * through the children.
       *
       * TODO: This could be faster to iterate as a flat array stored on the root node.
       */
      this.children = new Set();
      /**
       * Options for the node. We use this to configure what kind of layout animations
       * we should perform (if any).
       */
      this.options = {};
      /**
       * We use this to detect when its safe to shut down part of a projection tree.
       * We have to keep projecting children for scale correction and relative projection
       * until all their parents stop performing layout animations.
       */
      this.isTreeAnimating = false;
      this.isAnimationBlocked = false;
      /**
       * Flag to true if we think this layout has been changed. We can't always know this,
       * currently we set it to true every time a component renders, or if it has a layoutDependency
       * if that has changed between renders. Additionally, components can be grouped by LayoutGroup
       * and if one node is dirtied, they all are.
       */
      this.isLayoutDirty = false;
      /**
       * Block layout updates for instant layout transitions throughout the tree.
       */
      this.updateManuallyBlocked = false;
      this.updateBlockedByResize = false;
      /**
       * Set to true between the start of the first `willUpdate` call and the end of the `didUpdate`
       * call.
       */
      this.isUpdating = false;
      /**
       * If this is an SVG element we currently disable projection transforms
       */
      this.isSVG = false;
      /**
       * Flag to true (during promotion) if a node doing an instant layout transition needs to reset
       * its projection styles.
       */
      this.needsReset = false;
      /**
       * Flags whether this node should have its transform reset prior to measuring.
       */
      this.shouldResetTransform = false;
      /**
       * An object representing the calculated contextual/accumulated/tree scale.
       * This will be used to scale calculcated projection transforms, as these are
       * calculated in screen-space but need to be scaled for elements to actually
       * make it to their calculated destinations.
       *
       * TODO: Lazy-init
       */
      this.treeScale = {
        x: 1,
        y: 1
      };
      /**
       *
       */
      this.eventHandlers = new Map();
      // Note: Currently only running on root node
      this.potentialNodes = new Map();
      this.checkUpdateFailed = function () {
        if (_this.isUpdating) {
          _this.isUpdating = false;
          _this.clearAllSnapshots();
        }
      };
      this.updateProjection = function () {
        _this.nodes.forEach(resolveTargetDelta);
        _this.nodes.forEach(calcProjection);
      };
      this.hasProjected = false;
      this.isVisible = true;
      this.animationProgress = 0;
      /**
       * Shared layout
       */
      // TODO Only running on root node
      this.sharedNodes = new Map();
      this.id = id;
      this.latestValues = latestValues;
      this.root = parent ? parent.root || parent : this;
      this.path = parent ? tslib.__spreadArray(tslib.__spreadArray([], tslib.__read(parent.path), false), [parent], false) : [];
      this.parent = parent;
      this.depth = parent ? parent.depth + 1 : 0;
      id && this.root.registerPotentialNode(id, this);
      for (var i = 0; i < this.path.length; i++) {
        this.path[i].shouldResetTransform = true;
      }
      if (this.root === this) this.nodes = new FlatTree();
    }
    ProjectionNode.prototype.addEventListener = function (name, handler) {
      if (!this.eventHandlers.has(name)) {
        this.eventHandlers.set(name, new SubscriptionManager());
      }
      return this.eventHandlers.get(name).add(handler);
    };
    ProjectionNode.prototype.notifyListeners = function (name) {
      var args = [];
      for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
      }
      var subscriptionManager = this.eventHandlers.get(name);
      subscriptionManager === null || subscriptionManager === void 0 ? void 0 : subscriptionManager.notify.apply(subscriptionManager, tslib.__spreadArray([], tslib.__read(args), false));
    };
    ProjectionNode.prototype.hasListeners = function (name) {
      return this.eventHandlers.has(name);
    };
    ProjectionNode.prototype.registerPotentialNode = function (id, node) {
      this.potentialNodes.set(id, node);
    };
    /**
     * Lifecycles
     */
    ProjectionNode.prototype.mount = function (instance, isLayoutDirty) {
      var _this = this;
      var _a;
      if (isLayoutDirty === void 0) {
        isLayoutDirty = false;
      }
      if (this.instance) return;
      this.isSVG = instance instanceof SVGElement && instance.tagName !== "svg";
      this.instance = instance;
      var _b = this.options,
        layoutId = _b.layoutId,
        layout = _b.layout,
        visualElement = _b.visualElement;
      if (visualElement && !visualElement.getInstance()) {
        visualElement.mount(instance);
      }
      this.root.nodes.add(this);
      (_a = this.parent) === null || _a === void 0 ? void 0 : _a.children.add(this);
      this.id && this.root.potentialNodes.delete(this.id);
      if (isLayoutDirty && (layout || layoutId)) {
        this.isLayoutDirty = true;
      }
      if (attachResizeListener) {
        var unblockTimeout_1;
        var resizeUnblockUpdate_1 = function () {
          return _this.root.updateBlockedByResize = false;
        };
        attachResizeListener(instance, function () {
          _this.root.updateBlockedByResize = true;
          clearTimeout(unblockTimeout_1);
          unblockTimeout_1 = window.setTimeout(resizeUnblockUpdate_1, 250);
          if (globalProjectionState.hasAnimatedSinceResize) {
            globalProjectionState.hasAnimatedSinceResize = false;
            _this.nodes.forEach(finishAnimation);
          }
        });
      }
      if (layoutId) {
        this.root.registerSharedNode(layoutId, this);
      }
      // Only register the handler if it requires layout animation
      if (this.options.animate !== false && visualElement && (layoutId || layout)) {
        this.addEventListener("didUpdate", function (_a) {
          var _b, _c, _d, _e, _f;
          var delta = _a.delta,
            hasLayoutChanged = _a.hasLayoutChanged,
            hasRelativeTargetChanged = _a.hasRelativeTargetChanged,
            newLayout = _a.layout;
          if (_this.isTreeAnimationBlocked()) {
            _this.target = undefined;
            _this.relativeTarget = undefined;
            return;
          }
          // TODO: Check here if an animation exists
          var layoutTransition = (_c = (_b = _this.options.transition) !== null && _b !== void 0 ? _b : visualElement.getDefaultTransition()) !== null && _c !== void 0 ? _c : defaultLayoutTransition;
          var _g = visualElement.getProps(),
            onLayoutAnimationStart = _g.onLayoutAnimationStart,
            onLayoutAnimationComplete = _g.onLayoutAnimationComplete;
          /**
           * The target layout of the element might stay the same,
           * but its position relative to its parent has changed.
           */
          var targetChanged = !_this.targetLayout || !boxEquals(_this.targetLayout, newLayout) || hasRelativeTargetChanged;
          /**
           * If the layout hasn't seemed to have changed, it might be that the
           * element is visually in the same place in the document but its position
           * relative to its parent has indeed changed. So here we check for that.
           */
          var hasOnlyRelativeTargetChanged = !hasLayoutChanged && hasRelativeTargetChanged;
          if (((_d = _this.resumeFrom) === null || _d === void 0 ? void 0 : _d.instance) || hasOnlyRelativeTargetChanged || hasLayoutChanged && (targetChanged || !_this.currentAnimation)) {
            if (_this.resumeFrom) {
              _this.resumingFrom = _this.resumeFrom;
              _this.resumingFrom.resumingFrom = undefined;
            }
            _this.setAnimationOrigin(delta, hasOnlyRelativeTargetChanged);
            var animationOptions = tslib.__assign(tslib.__assign({}, getValueTransition(layoutTransition, "layout")), {
              onPlay: onLayoutAnimationStart,
              onComplete: onLayoutAnimationComplete
            });
            if (visualElement.shouldReduceMotion) {
              animationOptions.delay = 0;
              animationOptions.type = false;
            }
            _this.startAnimation(animationOptions);
          } else {
            /**
             * If the layout hasn't changed and we have an animation that hasn't started yet,
             * finish it immediately. Otherwise it will be animating from a location
             * that was probably never commited to screen and look like a jumpy box.
             */
            if (!hasLayoutChanged && _this.animationProgress === 0) {
              _this.finishAnimation();
            }
            _this.isLead() && ((_f = (_e = _this.options).onExitComplete) === null || _f === void 0 ? void 0 : _f.call(_e));
          }
          _this.targetLayout = newLayout;
        });
      }
    };
    ProjectionNode.prototype.unmount = function () {
      var _a, _b;
      this.options.layoutId && this.willUpdate();
      this.root.nodes.remove(this);
      (_a = this.getStack()) === null || _a === void 0 ? void 0 : _a.remove(this);
      (_b = this.parent) === null || _b === void 0 ? void 0 : _b.children.delete(this);
      this.instance = undefined;
      sync.cancelSync.preRender(this.updateProjection);
    };
    // only on the root
    ProjectionNode.prototype.blockUpdate = function () {
      this.updateManuallyBlocked = true;
    };
    ProjectionNode.prototype.unblockUpdate = function () {
      this.updateManuallyBlocked = false;
    };
    ProjectionNode.prototype.isUpdateBlocked = function () {
      return this.updateManuallyBlocked || this.updateBlockedByResize;
    };
    ProjectionNode.prototype.isTreeAnimationBlocked = function () {
      var _a;
      return this.isAnimationBlocked || ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isTreeAnimationBlocked()) || false;
    };
    // Note: currently only running on root node
    ProjectionNode.prototype.startUpdate = function () {
      var _a;
      if (this.isUpdateBlocked()) return;
      this.isUpdating = true;
      (_a = this.nodes) === null || _a === void 0 ? void 0 : _a.forEach(resetRotation);
    };
    ProjectionNode.prototype.willUpdate = function (shouldNotifyListeners) {
      var _a, _b, _c;
      if (shouldNotifyListeners === void 0) {
        shouldNotifyListeners = true;
      }
      if (this.root.isUpdateBlocked()) {
        (_b = (_a = this.options).onExitComplete) === null || _b === void 0 ? void 0 : _b.call(_a);
        return;
      }
      !this.root.isUpdating && this.root.startUpdate();
      if (this.isLayoutDirty) return;
      this.isLayoutDirty = true;
      for (var i = 0; i < this.path.length; i++) {
        var node = this.path[i];
        node.shouldResetTransform = true;
        /**
         * TODO: Check we haven't updated the scroll
         * since the last didUpdate
         */
        node.updateScroll();
      }
      var _d = this.options,
        layoutId = _d.layoutId,
        layout = _d.layout;
      if (layoutId === undefined && !layout) return;
      var transformTemplate = (_c = this.options.visualElement) === null || _c === void 0 ? void 0 : _c.getProps().transformTemplate;
      this.prevTransformTemplateValue = transformTemplate === null || transformTemplate === void 0 ? void 0 : transformTemplate(this.latestValues, "");
      this.updateSnapshot();
      shouldNotifyListeners && this.notifyListeners("willUpdate");
    };
    // Note: Currently only running on root node
    ProjectionNode.prototype.didUpdate = function () {
      var updateWasBlocked = this.isUpdateBlocked();
      // When doing an instant transition, we skip the layout update,
      // but should still clean up the measurements so that the next
      // snapshot could be taken correctly.
      if (updateWasBlocked) {
        this.unblockUpdate();
        this.clearAllSnapshots();
        this.nodes.forEach(clearMeasurements);
        return;
      }
      if (!this.isUpdating) return;
      this.isUpdating = false;
      /**
       * Search for and mount newly-added projection elements.
       *
       * TODO: Every time a new component is rendered we could search up the tree for
       * the closest mounted node and query from there rather than document.
       */
      if (this.potentialNodes.size) {
        this.potentialNodes.forEach(mountNodeEarly);
        this.potentialNodes.clear();
      }
      /**
       * Write
       */
      this.nodes.forEach(resetTransformStyle);
      /**
       * Read ==================
       */
      // Update layout measurements of updated children
      this.nodes.forEach(updateLayout);
      /**
       * Write
       */
      // Notify listeners that the layout is updated
      this.nodes.forEach(notifyLayoutUpdate);
      this.clearAllSnapshots();
      // Flush any scheduled updates
      sync.flushSync.update();
      sync.flushSync.preRender();
      sync.flushSync.render();
    };
    ProjectionNode.prototype.clearAllSnapshots = function () {
      this.nodes.forEach(clearSnapshot);
      this.sharedNodes.forEach(removeLeadSnapshots);
    };
    ProjectionNode.prototype.scheduleUpdateProjection = function () {
      sync__default["default"].preRender(this.updateProjection, false, true);
    };
    ProjectionNode.prototype.scheduleCheckAfterUnmount = function () {
      var _this = this;
      /**
       * If the unmounting node is in a layoutGroup and did trigger a willUpdate,
       * we manually call didUpdate to give a chance to the siblings to animate.
       * Otherwise, cleanup all snapshots to prevents future nodes from reusing them.
       */
      sync__default["default"].postRender(function () {
        if (_this.isLayoutDirty) {
          _this.root.didUpdate();
        } else {
          _this.root.checkUpdateFailed();
        }
      });
    };
    /**
     * Update measurements
     */
    ProjectionNode.prototype.updateSnapshot = function () {
      if (this.snapshot || !this.instance) return;
      var measured = this.measure();
      var layout = this.removeTransform(this.removeElementScroll(measured));
      roundBox(layout);
      this.snapshot = {
        measured: measured,
        layout: layout,
        latestValues: {}
      };
    };
    ProjectionNode.prototype.updateLayout = function () {
      var _a;
      if (!this.instance) return;
      // TODO: Incorporate into a forwarded scroll offset
      this.updateScroll();
      if (!(this.options.alwaysMeasureLayout && this.isLead()) && !this.isLayoutDirty) {
        return;
      }
      /**
       * When a node is mounted, it simply resumes from the prevLead's
       * snapshot instead of taking a new one, but the ancestors scroll
       * might have updated while the prevLead is unmounted. We need to
       * update the scroll again to make sure the layout we measure is
       * up to date.
       */
      if (this.resumeFrom && !this.resumeFrom.instance) {
        for (var i = 0; i < this.path.length; i++) {
          var node = this.path[i];
          node.updateScroll();
        }
      }
      var measured = this.measure();
      roundBox(measured);
      var prevLayout = this.layout;
      this.layout = {
        measured: measured,
        actual: this.removeElementScroll(measured)
      };
      this.layoutCorrected = createBox();
      this.isLayoutDirty = false;
      this.projectionDelta = undefined;
      this.notifyListeners("measure", this.layout.actual);
      (_a = this.options.visualElement) === null || _a === void 0 ? void 0 : _a.notifyLayoutMeasure(this.layout.actual, prevLayout === null || prevLayout === void 0 ? void 0 : prevLayout.actual);
    };
    ProjectionNode.prototype.updateScroll = function () {
      if (this.options.layoutScroll && this.instance) {
        this.isScrollRoot = checkIsScrollRoot(this.instance);
        this.scroll = measureScroll(this.instance);
      }
    };
    ProjectionNode.prototype.resetTransform = function () {
      var _a;
      if (!resetTransform) return;
      var isResetRequested = this.isLayoutDirty || this.shouldResetTransform;
      var hasProjection = this.projectionDelta && !isDeltaZero(this.projectionDelta);
      var transformTemplate = (_a = this.options.visualElement) === null || _a === void 0 ? void 0 : _a.getProps().transformTemplate;
      var transformTemplateValue = transformTemplate === null || transformTemplate === void 0 ? void 0 : transformTemplate(this.latestValues, "");
      var transformTemplateHasChanged = transformTemplateValue !== this.prevTransformTemplateValue;
      if (isResetRequested && (hasProjection || hasTransform(this.latestValues) || transformTemplateHasChanged)) {
        resetTransform(this.instance, transformTemplateValue);
        this.shouldResetTransform = false;
        this.scheduleRender();
      }
    };
    ProjectionNode.prototype.measure = function () {
      var visualElement = this.options.visualElement;
      if (!visualElement) return createBox();
      var box = visualElement.measureViewportBox();
      // Remove viewport scroll to give page-relative coordinates
      var scroll = this.root.scroll;
      if (scroll) {
        translateAxis(box.x, scroll.x);
        translateAxis(box.y, scroll.y);
      }
      return box;
    };
    ProjectionNode.prototype.removeElementScroll = function (box) {
      var boxWithoutScroll = createBox();
      copyBoxInto(boxWithoutScroll, box);
      /**
       * Performance TODO: Keep a cumulative scroll offset down the tree
       * rather than loop back up the path.
       */
      for (var i = 0; i < this.path.length; i++) {
        var node = this.path[i];
        var scroll_1 = node.scroll,
          options = node.options,
          isScrollRoot = node.isScrollRoot;
        if (node !== this.root && scroll_1 && options.layoutScroll) {
          /**
           * If this is a new scroll root, we want to remove all previous scrolls
           * from the viewport box.
           */
          if (isScrollRoot) {
            copyBoxInto(boxWithoutScroll, box);
            var rootScroll = this.root.scroll;
            /**
             * Undo the application of page scroll that was originally added
             * to the measured bounding box.
             */
            if (rootScroll) {
              translateAxis(boxWithoutScroll.x, -rootScroll.x);
              translateAxis(boxWithoutScroll.y, -rootScroll.y);
            }
          }
          translateAxis(boxWithoutScroll.x, scroll_1.x);
          translateAxis(boxWithoutScroll.y, scroll_1.y);
        }
      }
      return boxWithoutScroll;
    };
    ProjectionNode.prototype.applyTransform = function (box, transformOnly) {
      if (transformOnly === void 0) {
        transformOnly = false;
      }
      var withTransforms = createBox();
      copyBoxInto(withTransforms, box);
      for (var i = 0; i < this.path.length; i++) {
        var node = this.path[i];
        if (!transformOnly && node.options.layoutScroll && node.scroll && node !== node.root) {
          transformBox(withTransforms, {
            x: -node.scroll.x,
            y: -node.scroll.y
          });
        }
        if (!hasTransform(node.latestValues)) continue;
        transformBox(withTransforms, node.latestValues);
      }
      if (hasTransform(this.latestValues)) {
        transformBox(withTransforms, this.latestValues);
      }
      return withTransforms;
    };
    ProjectionNode.prototype.removeTransform = function (box) {
      var _a;
      var boxWithoutTransform = createBox();
      copyBoxInto(boxWithoutTransform, box);
      for (var i = 0; i < this.path.length; i++) {
        var node = this.path[i];
        if (!node.instance) continue;
        if (!hasTransform(node.latestValues)) continue;
        hasScale(node.latestValues) && node.updateSnapshot();
        var sourceBox = createBox();
        var nodeBox = node.measure();
        copyBoxInto(sourceBox, nodeBox);
        removeBoxTransforms(boxWithoutTransform, node.latestValues, (_a = node.snapshot) === null || _a === void 0 ? void 0 : _a.layout, sourceBox);
      }
      if (hasTransform(this.latestValues)) {
        removeBoxTransforms(boxWithoutTransform, this.latestValues);
      }
      return boxWithoutTransform;
    };
    /**
     *
     */
    ProjectionNode.prototype.setTargetDelta = function (delta) {
      this.targetDelta = delta;
      this.root.scheduleUpdateProjection();
    };
    ProjectionNode.prototype.setOptions = function (options) {
      var _a;
      this.options = tslib.__assign(tslib.__assign(tslib.__assign({}, this.options), options), {
        crossfade: (_a = options.crossfade) !== null && _a !== void 0 ? _a : true
      });
    };
    ProjectionNode.prototype.clearMeasurements = function () {
      this.scroll = undefined;
      this.layout = undefined;
      this.snapshot = undefined;
      this.prevTransformTemplateValue = undefined;
      this.targetDelta = undefined;
      this.target = undefined;
      this.isLayoutDirty = false;
    };
    /**
     * Frame calculations
     */
    ProjectionNode.prototype.resolveTargetDelta = function () {
      var _a;
      var _b = this.options,
        layout = _b.layout,
        layoutId = _b.layoutId;
      /**
       * If we have no layout, we can't perform projection, so early return
       */
      if (!this.layout || !(layout || layoutId)) return;
      /**
       * If we don't have a targetDelta but do have a layout, we can attempt to resolve
       * a relativeParent. This will allow a component to perform scale correction
       * even if no animation has started.
       */
      // TODO If this is unsuccessful this currently happens every frame
      if (!this.targetDelta && !this.relativeTarget) {
        // TODO: This is a semi-repetition of further down this function, make DRY
        this.relativeParent = this.getClosestProjectingParent();
        if (this.relativeParent && this.relativeParent.layout) {
          this.relativeTarget = createBox();
          this.relativeTargetOrigin = createBox();
          calcRelativePosition(this.relativeTargetOrigin, this.layout.actual, this.relativeParent.layout.actual);
          copyBoxInto(this.relativeTarget, this.relativeTargetOrigin);
        }
      }
      /**
       * If we have no relative target or no target delta our target isn't valid
       * for this frame.
       */
      if (!this.relativeTarget && !this.targetDelta) return;
      /**
       * Lazy-init target data structure
       */
      if (!this.target) {
        this.target = createBox();
        this.targetWithTransforms = createBox();
      }
      /**
       * If we've got a relative box for this component, resolve it into a target relative to the parent.
       */
      if (this.relativeTarget && this.relativeTargetOrigin && ((_a = this.relativeParent) === null || _a === void 0 ? void 0 : _a.target)) {
        calcRelativeBox(this.target, this.relativeTarget, this.relativeParent.target);
        /**
         * If we've only got a targetDelta, resolve it into a target
         */
      } else if (this.targetDelta) {
        if (Boolean(this.resumingFrom)) {
          // TODO: This is creating a new object every frame
          this.target = this.applyTransform(this.layout.actual);
        } else {
          copyBoxInto(this.target, this.layout.actual);
        }
        applyBoxDelta(this.target, this.targetDelta);
      } else {
        /**
         * If no target, use own layout as target
         */
        copyBoxInto(this.target, this.layout.actual);
      }
      /**
       * If we've been told to attempt to resolve a relative target, do so.
       */
      if (this.attemptToResolveRelativeTarget) {
        this.attemptToResolveRelativeTarget = false;
        this.relativeParent = this.getClosestProjectingParent();
        if (this.relativeParent && Boolean(this.relativeParent.resumingFrom) === Boolean(this.resumingFrom) && !this.relativeParent.options.layoutScroll && this.relativeParent.target) {
          this.relativeTarget = createBox();
          this.relativeTargetOrigin = createBox();
          calcRelativePosition(this.relativeTargetOrigin, this.target, this.relativeParent.target);
          copyBoxInto(this.relativeTarget, this.relativeTargetOrigin);
        }
      }
    };
    ProjectionNode.prototype.getClosestProjectingParent = function () {
      if (!this.parent || hasTransform(this.parent.latestValues)) return undefined;
      if ((this.parent.relativeTarget || this.parent.targetDelta) && this.parent.layout) {
        return this.parent;
      } else {
        return this.parent.getClosestProjectingParent();
      }
    };
    ProjectionNode.prototype.calcProjection = function () {
      var _a;
      var _b = this.options,
        layout = _b.layout,
        layoutId = _b.layoutId;
      /**
       * If this section of the tree isn't animating we can
       * delete our target sources for the following frame.
       */
      this.isTreeAnimating = Boolean(((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isTreeAnimating) || this.currentAnimation || this.pendingAnimation);
      if (!this.isTreeAnimating) {
        this.targetDelta = this.relativeTarget = undefined;
      }
      if (!this.layout || !(layout || layoutId)) return;
      var lead = this.getLead();
      /**
       * Reset the corrected box with the latest values from box, as we're then going
       * to perform mutative operations on it.
       */
      copyBoxInto(this.layoutCorrected, this.layout.actual);
      /**
       * Apply all the parent deltas to this box to produce the corrected box. This
       * is the layout box, as it will appear on screen as a result of the transforms of its parents.
       */
      applyTreeDeltas(this.layoutCorrected, this.treeScale, this.path, Boolean(this.resumingFrom) || this !== lead);
      var target = lead.target;
      if (!target) return;
      if (!this.projectionDelta) {
        this.projectionDelta = createDelta();
        this.projectionDeltaWithTransform = createDelta();
      }
      var prevTreeScaleX = this.treeScale.x;
      var prevTreeScaleY = this.treeScale.y;
      var prevProjectionTransform = this.projectionTransform;
      /**
       * Update the delta between the corrected box and the target box before user-set transforms were applied.
       * This will allow us to calculate the corrected borderRadius and boxShadow to compensate
       * for our layout reprojection, but still allow them to be scaled correctly by the user.
       * It might be that to simplify this we may want to accept that user-set scale is also corrected
       * and we wouldn't have to keep and calc both deltas, OR we could support a user setting
       * to allow people to choose whether these styles are corrected based on just the
       * layout reprojection or the final bounding box.
       */
      calcBoxDelta(this.projectionDelta, this.layoutCorrected, target, this.latestValues);
      this.projectionTransform = buildProjectionTransform(this.projectionDelta, this.treeScale);
      if (this.projectionTransform !== prevProjectionTransform || this.treeScale.x !== prevTreeScaleX || this.treeScale.y !== prevTreeScaleY) {
        this.hasProjected = true;
        this.scheduleRender();
        this.notifyListeners("projectionUpdate", target);
      }
    };
    ProjectionNode.prototype.hide = function () {
      this.isVisible = false;
      // TODO: Schedule render
    };
    ProjectionNode.prototype.show = function () {
      this.isVisible = true;
      // TODO: Schedule render
    };
    ProjectionNode.prototype.scheduleRender = function (notifyAll) {
      var _a, _b, _c;
      if (notifyAll === void 0) {
        notifyAll = true;
      }
      (_b = (_a = this.options).scheduleRender) === null || _b === void 0 ? void 0 : _b.call(_a);
      notifyAll && ((_c = this.getStack()) === null || _c === void 0 ? void 0 : _c.scheduleRender());
      if (this.resumingFrom && !this.resumingFrom.instance) {
        this.resumingFrom = undefined;
      }
    };
    ProjectionNode.prototype.setAnimationOrigin = function (delta, hasOnlyRelativeTargetChanged) {
      var _this = this;
      var _a;
      if (hasOnlyRelativeTargetChanged === void 0) {
        hasOnlyRelativeTargetChanged = false;
      }
      var snapshot = this.snapshot;
      var snapshotLatestValues = (snapshot === null || snapshot === void 0 ? void 0 : snapshot.latestValues) || {};
      var mixedValues = tslib.__assign({}, this.latestValues);
      var targetDelta = createDelta();
      this.relativeTarget = this.relativeTargetOrigin = undefined;
      this.attemptToResolveRelativeTarget = !hasOnlyRelativeTargetChanged;
      var relativeLayout = createBox();
      var isSharedLayoutAnimation = snapshot === null || snapshot === void 0 ? void 0 : snapshot.isShared;
      var isOnlyMember = (((_a = this.getStack()) === null || _a === void 0 ? void 0 : _a.members.length) || 0) <= 1;
      var shouldCrossfadeOpacity = Boolean(isSharedLayoutAnimation && !isOnlyMember && this.options.crossfade === true && !this.path.some(hasOpacityCrossfade));
      this.animationProgress = 0;
      this.mixTargetDelta = function (latest) {
        var _a;
        var progress = latest / 1000;
        mixAxisDelta(targetDelta.x, delta.x, progress);
        mixAxisDelta(targetDelta.y, delta.y, progress);
        _this.setTargetDelta(targetDelta);
        if (_this.relativeTarget && _this.relativeTargetOrigin && _this.layout && ((_a = _this.relativeParent) === null || _a === void 0 ? void 0 : _a.layout)) {
          calcRelativePosition(relativeLayout, _this.layout.actual, _this.relativeParent.layout.actual);
          mixBox(_this.relativeTarget, _this.relativeTargetOrigin, relativeLayout, progress);
        }
        if (isSharedLayoutAnimation) {
          _this.animationValues = mixedValues;
          mixValues(mixedValues, snapshotLatestValues, _this.latestValues, progress, shouldCrossfadeOpacity, isOnlyMember);
        }
        _this.root.scheduleUpdateProjection();
        _this.scheduleRender();
        _this.animationProgress = progress;
      };
      this.mixTargetDelta(0);
    };
    ProjectionNode.prototype.startAnimation = function (options) {
      var _this = this;
      var _a, _b;
      this.notifyListeners("animationStart");
      (_a = this.currentAnimation) === null || _a === void 0 ? void 0 : _a.stop();
      if (this.resumingFrom) {
        (_b = this.resumingFrom.currentAnimation) === null || _b === void 0 ? void 0 : _b.stop();
      }
      if (this.pendingAnimation) {
        sync.cancelSync.update(this.pendingAnimation);
        this.pendingAnimation = undefined;
      }
      /**
       * Start the animation in the next frame to have a frame with progress 0,
       * where the target is the same as when the animation started, so we can
       * calculate the relative positions correctly for instant transitions.
       */
      this.pendingAnimation = sync__default["default"].update(function () {
        globalProjectionState.hasAnimatedSinceResize = true;
        _this.currentAnimation = animate(0, animationTarget, tslib.__assign(tslib.__assign({}, options), {
          onUpdate: function (latest) {
            var _a;
            _this.mixTargetDelta(latest);
            (_a = options.onUpdate) === null || _a === void 0 ? void 0 : _a.call(options, latest);
          },
          onComplete: function () {
            var _a;
            (_a = options.onComplete) === null || _a === void 0 ? void 0 : _a.call(options);
            _this.completeAnimation();
          }
        }));
        if (_this.resumingFrom) {
          _this.resumingFrom.currentAnimation = _this.currentAnimation;
        }
        _this.pendingAnimation = undefined;
      });
    };
    ProjectionNode.prototype.completeAnimation = function () {
      var _a;
      if (this.resumingFrom) {
        this.resumingFrom.currentAnimation = undefined;
        this.resumingFrom.preserveOpacity = undefined;
      }
      (_a = this.getStack()) === null || _a === void 0 ? void 0 : _a.exitAnimationComplete();
      this.resumingFrom = this.currentAnimation = this.animationValues = undefined;
      this.notifyListeners("animationComplete");
    };
    ProjectionNode.prototype.finishAnimation = function () {
      var _a;
      if (this.currentAnimation) {
        (_a = this.mixTargetDelta) === null || _a === void 0 ? void 0 : _a.call(this, animationTarget);
        this.currentAnimation.stop();
      }
      this.completeAnimation();
    };
    ProjectionNode.prototype.applyTransformsToTarget = function () {
      var _a = this.getLead(),
        targetWithTransforms = _a.targetWithTransforms,
        target = _a.target,
        layout = _a.layout,
        latestValues = _a.latestValues;
      if (!targetWithTransforms || !target || !layout) return;
      copyBoxInto(targetWithTransforms, target);
      /**
       * Apply the latest user-set transforms to the targetBox to produce the targetBoxFinal.
       * This is the final box that we will then project into by calculating a transform delta and
       * applying it to the corrected box.
       */
      transformBox(targetWithTransforms, latestValues);
      /**
       * Update the delta between the corrected box and the final target box, after
       * user-set transforms are applied to it. This will be used by the renderer to
       * create a transform style that will reproject the element from its actual layout
       * into the desired bounding box.
       */
      calcBoxDelta(this.projectionDeltaWithTransform, this.layoutCorrected, targetWithTransforms, latestValues);
    };
    ProjectionNode.prototype.registerSharedNode = function (layoutId, node) {
      var _a, _b, _c;
      if (!this.sharedNodes.has(layoutId)) {
        this.sharedNodes.set(layoutId, new NodeStack());
      }
      var stack = this.sharedNodes.get(layoutId);
      stack.add(node);
      node.promote({
        transition: (_a = node.options.initialPromotionConfig) === null || _a === void 0 ? void 0 : _a.transition,
        preserveFollowOpacity: (_c = (_b = node.options.initialPromotionConfig) === null || _b === void 0 ? void 0 : _b.shouldPreserveFollowOpacity) === null || _c === void 0 ? void 0 : _c.call(_b, node)
      });
    };
    ProjectionNode.prototype.isLead = function () {
      var stack = this.getStack();
      return stack ? stack.lead === this : true;
    };
    ProjectionNode.prototype.getLead = function () {
      var _a;
      var layoutId = this.options.layoutId;
      return layoutId ? ((_a = this.getStack()) === null || _a === void 0 ? void 0 : _a.lead) || this : this;
    };
    ProjectionNode.prototype.getPrevLead = function () {
      var _a;
      var layoutId = this.options.layoutId;
      return layoutId ? (_a = this.getStack()) === null || _a === void 0 ? void 0 : _a.prevLead : undefined;
    };
    ProjectionNode.prototype.getStack = function () {
      var layoutId = this.options.layoutId;
      if (layoutId) return this.root.sharedNodes.get(layoutId);
    };
    ProjectionNode.prototype.promote = function (_a) {
      var _b = _a === void 0 ? {} : _a,
        needsReset = _b.needsReset,
        transition = _b.transition,
        preserveFollowOpacity = _b.preserveFollowOpacity;
      var stack = this.getStack();
      if (stack) stack.promote(this, preserveFollowOpacity);
      if (needsReset) {
        this.projectionDelta = undefined;
        this.needsReset = true;
      }
      if (transition) this.setOptions({
        transition: transition
      });
    };
    ProjectionNode.prototype.relegate = function () {
      var stack = this.getStack();
      if (stack) {
        return stack.relegate(this);
      } else {
        return false;
      }
    };
    ProjectionNode.prototype.resetRotation = function () {
      var visualElement = this.options.visualElement;
      if (!visualElement) return;
      // If there's no detected rotation values, we can early return without a forced render.
      var hasRotate = false;
      // Keep a record of all the values we've reset
      var resetValues = {};
      // Check the rotate value of all axes and reset to 0
      for (var i = 0; i < transformAxes.length; i++) {
        var axis = transformAxes[i];
        var key = "rotate" + axis;
        // If this rotation doesn't exist as a motion value, then we don't
        // need to reset it
        if (!visualElement.getStaticValue(key)) {
          continue;
        }
        hasRotate = true;
        // Record the rotation and then temporarily set it to 0
        resetValues[key] = visualElement.getStaticValue(key);
        visualElement.setStaticValue(key, 0);
      }
      // If there's no rotation values, we don't need to do any more.
      if (!hasRotate) return;
      // Force a render of this element to apply the transform with all rotations
      // set to 0.
      visualElement === null || visualElement === void 0 ? void 0 : visualElement.syncRender();
      // Put back all the values we reset
      for (var key in resetValues) {
        visualElement.setStaticValue(key, resetValues[key]);
      }
      // Schedule a render for the next frame. This ensures we won't visually
      // see the element with the reset rotate value applied.
      visualElement.scheduleRender();
    };
    ProjectionNode.prototype.getProjectionStyles = function (styleProp) {
      var _a, _b, _c, _d, _e, _f;
      if (styleProp === void 0) {
        styleProp = {};
      }
      // TODO: Return lifecycle-persistent object
      var styles = {};
      if (!this.instance || this.isSVG) return styles;
      if (!this.isVisible) {
        return {
          visibility: "hidden"
        };
      } else {
        styles.visibility = "";
      }
      var transformTemplate = (_a = this.options.visualElement) === null || _a === void 0 ? void 0 : _a.getProps().transformTemplate;
      if (this.needsReset) {
        this.needsReset = false;
        styles.opacity = "";
        styles.pointerEvents = resolveMotionValue(styleProp.pointerEvents) || "";
        styles.transform = transformTemplate ? transformTemplate(this.latestValues, "") : "none";
        return styles;
      }
      var lead = this.getLead();
      if (!this.projectionDelta || !this.layout || !lead.target) {
        var emptyStyles = {};
        if (this.options.layoutId) {
          emptyStyles.opacity = (_b = this.latestValues.opacity) !== null && _b !== void 0 ? _b : 1;
          emptyStyles.pointerEvents = resolveMotionValue(styleProp.pointerEvents) || "";
        }
        if (this.hasProjected && !hasTransform(this.latestValues)) {
          emptyStyles.transform = transformTemplate ? transformTemplate({}, "") : "none";
          this.hasProjected = false;
        }
        return emptyStyles;
      }
      var valuesToRender = lead.animationValues || lead.latestValues;
      this.applyTransformsToTarget();
      styles.transform = buildProjectionTransform(this.projectionDeltaWithTransform, this.treeScale, valuesToRender);
      if (transformTemplate) {
        styles.transform = transformTemplate(valuesToRender, styles.transform);
      }
      var _g = this.projectionDelta,
        x = _g.x,
        y = _g.y;
      styles.transformOrigin = "".concat(x.origin * 100, "% ").concat(y.origin * 100, "% 0");
      if (lead.animationValues) {
        /**
         * If the lead component is animating, assign this either the entering/leaving
         * opacity
         */
        styles.opacity = lead === this ? (_d = (_c = valuesToRender.opacity) !== null && _c !== void 0 ? _c : this.latestValues.opacity) !== null && _d !== void 0 ? _d : 1 : this.preserveOpacity ? this.latestValues.opacity : valuesToRender.opacityExit;
      } else {
        /**
         * Or we're not animating at all, set the lead component to its actual
         * opacity and other components to hidden.
         */
        styles.opacity = lead === this ? (_e = valuesToRender.opacity) !== null && _e !== void 0 ? _e : "" : (_f = valuesToRender.opacityExit) !== null && _f !== void 0 ? _f : 0;
      }
      /**
       * Apply scale correction
       */
      for (var key in scaleCorrectors) {
        if (valuesToRender[key] === undefined) continue;
        var _h = scaleCorrectors[key],
          correct = _h.correct,
          applyTo = _h.applyTo;
        var corrected = correct(valuesToRender[key], lead);
        if (applyTo) {
          var num = applyTo.length;
          for (var i = 0; i < num; i++) {
            styles[applyTo[i]] = corrected;
          }
        } else {
          styles[key] = corrected;
        }
      }
      /**
       * Disable pointer events on follow components. This is to ensure
       * that if a follow component covers a lead component it doesn't block
       * pointer events on the lead.
       */
      if (this.options.layoutId) {
        styles.pointerEvents = lead === this ? resolveMotionValue(styleProp.pointerEvents) || "" : "none";
      }
      return styles;
    };
    ProjectionNode.prototype.clearSnapshot = function () {
      this.resumeFrom = this.snapshot = undefined;
    };
    // Only run on root
    ProjectionNode.prototype.resetTree = function () {
      this.root.nodes.forEach(function (node) {
        var _a;
        return (_a = node.currentAnimation) === null || _a === void 0 ? void 0 : _a.stop();
      });
      this.root.nodes.forEach(clearMeasurements);
      this.root.sharedNodes.clear();
    };
    return ProjectionNode;
  }();
}
function updateLayout(node) {
  node.updateLayout();
}
function notifyLayoutUpdate(node) {
  var _a, _b, _c, _d;
  var snapshot = (_b = (_a = node.resumeFrom) === null || _a === void 0 ? void 0 : _a.snapshot) !== null && _b !== void 0 ? _b : node.snapshot;
  if (node.isLead() && node.layout && snapshot && node.hasListeners("didUpdate")) {
    var _e = node.layout,
      layout_1 = _e.actual,
      measuredLayout = _e.measured;
    // TODO Maybe we want to also resize the layout snapshot so we don't trigger
    // animations for instance if layout="size" and an element has only changed position
    if (node.options.animationType === "size") {
      eachAxis(function (axis) {
        var axisSnapshot = snapshot.isShared ? snapshot.measured[axis] : snapshot.layout[axis];
        var length = calcLength(axisSnapshot);
        axisSnapshot.min = layout_1[axis].min;
        axisSnapshot.max = axisSnapshot.min + length;
      });
    } else if (node.options.animationType === "position") {
      eachAxis(function (axis) {
        var axisSnapshot = snapshot.isShared ? snapshot.measured[axis] : snapshot.layout[axis];
        var length = calcLength(layout_1[axis]);
        axisSnapshot.max = axisSnapshot.min + length;
      });
    }
    var layoutDelta = createDelta();
    calcBoxDelta(layoutDelta, layout_1, snapshot.layout);
    var visualDelta = createDelta();
    if (snapshot.isShared) {
      calcBoxDelta(visualDelta, node.applyTransform(measuredLayout, true), snapshot.measured);
    } else {
      calcBoxDelta(visualDelta, layout_1, snapshot.layout);
    }
    var hasLayoutChanged = !isDeltaZero(layoutDelta);
    var hasRelativeTargetChanged = false;
    if (!node.resumeFrom) {
      node.relativeParent = node.getClosestProjectingParent();
      /**
       * If the relativeParent is itself resuming from a different element then
       * the relative snapshot is not relavent
       */
      if (node.relativeParent && !node.relativeParent.resumeFrom) {
        var _f = node.relativeParent,
          parentSnapshot = _f.snapshot,
          parentLayout = _f.layout;
        if (parentSnapshot && parentLayout) {
          var relativeSnapshot = createBox();
          calcRelativePosition(relativeSnapshot, snapshot.layout, parentSnapshot.layout);
          var relativeLayout = createBox();
          calcRelativePosition(relativeLayout, layout_1, parentLayout.actual);
          if (!boxEquals(relativeSnapshot, relativeLayout)) {
            hasRelativeTargetChanged = true;
          }
        }
      }
    }
    node.notifyListeners("didUpdate", {
      layout: layout_1,
      snapshot: snapshot,
      delta: visualDelta,
      layoutDelta: layoutDelta,
      hasLayoutChanged: hasLayoutChanged,
      hasRelativeTargetChanged: hasRelativeTargetChanged
    });
  } else if (node.isLead()) {
    (_d = (_c = node.options).onExitComplete) === null || _d === void 0 ? void 0 : _d.call(_c);
  }
  /**
   * Clearing transition
   * TODO: Investigate why this transition is being passed in as {type: false } from Framer
   * and why we need it at all
   */
  node.options.transition = undefined;
}
function clearSnapshot(node) {
  node.clearSnapshot();
}
function clearMeasurements(node) {
  node.clearMeasurements();
}
function resetTransformStyle(node) {
  var visualElement = node.options.visualElement;
  if (visualElement === null || visualElement === void 0 ? void 0 : visualElement.getProps().onBeforeLayoutMeasure) {
    visualElement.notifyBeforeLayoutMeasure();
  }
  node.resetTransform();
}
function finishAnimation(node) {
  node.finishAnimation();
  node.targetDelta = node.relativeTarget = node.target = undefined;
}
function resolveTargetDelta(node) {
  node.resolveTargetDelta();
}
function calcProjection(node) {
  node.calcProjection();
}
function resetRotation(node) {
  node.resetRotation();
}
function removeLeadSnapshots(stack) {
  stack.removeLeadSnapshot();
}
function mixAxisDelta(output, delta, p) {
  output.translate = popmotion.mix(delta.translate, 0, p);
  output.scale = popmotion.mix(delta.scale, 1, p);
  output.origin = delta.origin;
  output.originPoint = delta.originPoint;
}
function mixAxis(output, from, to, p) {
  output.min = popmotion.mix(from.min, to.min, p);
  output.max = popmotion.mix(from.max, to.max, p);
}
function mixBox(output, from, to, p) {
  mixAxis(output.x, from.x, to.x, p);
  mixAxis(output.y, from.y, to.y, p);
}
function hasOpacityCrossfade(node) {
  return node.animationValues && node.animationValues.opacityExit !== undefined;
}
var defaultLayoutTransition = {
  duration: 0.45,
  ease: [0.4, 0, 0.1, 1]
};
function mountNodeEarly(node, id) {
  /**
   * Rather than searching the DOM from document we can search the
   * path for the deepest mounted ancestor and search from there
   */
  var searchNode = node.root;
  for (var i = node.path.length - 1; i >= 0; i--) {
    if (Boolean(node.path[i].instance)) {
      searchNode = node.path[i];
      break;
    }
  }
  var searchElement = searchNode && searchNode !== node.root ? searchNode.instance : document;
  var element = searchElement.querySelector("[data-projection-id=\"".concat(id, "\"]"));
  if (element) node.mount(element, true);
}
function roundAxis(axis) {
  axis.min = Math.round(axis.min);
  axis.max = Math.round(axis.max);
}
function roundBox(box) {
  roundAxis(box.x);
  roundAxis(box.y);
}
var DocumentProjectionNode = createProjectionNode({
  attachResizeListener: function (ref, notify) {
    return addDomEvent(ref, "resize", notify);
  },
  measureScroll: function () {
    return {
      x: document.documentElement.scrollLeft || document.body.scrollLeft,
      y: document.documentElement.scrollTop || document.body.scrollTop
    };
  },
  checkIsScrollRoot: function () {
    return true;
  }
});
var rootProjectionNode = {
  current: undefined
};
var HTMLProjectionNode = createProjectionNode({
  measureScroll: function (instance) {
    return {
      x: instance.scrollLeft,
      y: instance.scrollTop
    };
  },
  defaultParent: function () {
    if (!rootProjectionNode.current) {
      var documentNode = new DocumentProjectionNode(0, {});
      documentNode.mount(window);
      documentNode.setOptions({
        layoutScroll: true
      });
      rootProjectionNode.current = documentNode;
    }
    return rootProjectionNode.current;
  },
  resetTransform: function (instance, value) {
    instance.style.transform = value !== null && value !== void 0 ? value : "none";
  },
  checkIsScrollRoot: function (instance) {
    return Boolean(window.getComputedStyle(instance).position === "fixed");
  }
});
var featureBundle = tslib.__assign(tslib.__assign(tslib.__assign(tslib.__assign({}, animations), gestureAnimations), drag), layoutFeatures);
/**
 * HTML & SVG components, optimised for use with gestures and animation. These can be used as
 * drop-in replacements for any HTML & SVG component, all CSS & SVG properties are supported.
 *
 * @public
 */
var motion = /*@__PURE__*/createMotionProxy(function (Component, config) {
  return createDomMotionConfig(Component, config, featureBundle, createDomVisualElement, HTMLProjectionNode);
});
/**
 * Create a DOM `motion` component with the provided string. This is primarily intended
 * as a full alternative to `motion` for consumers who have to support environments that don't
 * support `Proxy`.
 *
 * ```javascript
 * import { createDomMotionComponent } from "framer-motion"
 *
 * const motion = {
 *   div: createDomMotionComponent('div')
 * }
 * ```
 *
 * @public
 */
function createDomMotionComponent(key) {
  return createMotionComponent(createDomMotionConfig(key, {
    forwardMotionProps: false
  }, featureBundle, createDomVisualElement, HTMLProjectionNode));
}

/**
 * @public
 */
var m = createMotionProxy(createDomMotionConfig);
function useIsMounted() {
  var isMounted = React.useRef(false);
  useIsomorphicLayoutEffect(function () {
    isMounted.current = true;
    return function () {
      isMounted.current = false;
    };
  }, []);
  return isMounted;
}
function useForceUpdate() {
  var isMounted = useIsMounted();
  var _a = tslib.__read(React.useState(0), 2),
    forcedRenderCount = _a[0],
    setForcedRenderCount = _a[1];
  var forceRender = React.useCallback(function () {
    isMounted.current && setForcedRenderCount(forcedRenderCount + 1);
  }, [forcedRenderCount]);
  /**
   * Defer this to the end of the next animation frame in case there are multiple
   * synchronous calls.
   */
  var deferredForceRender = React.useCallback(function () {
    return sync__default["default"].postRender(forceRender);
  }, [forceRender]);
  return [deferredForceRender, forcedRenderCount];
}
var PresenceChild = function (_a) {
  var children = _a.children,
    initial = _a.initial,
    isPresent = _a.isPresent,
    onExitComplete = _a.onExitComplete,
    custom = _a.custom,
    presenceAffectsLayout = _a.presenceAffectsLayout;
  var presenceChildren = useConstant(newChildrenMap);
  var id = useId();
  var context = React.useMemo(function () {
    return {
      id: id,
      initial: initial,
      isPresent: isPresent,
      custom: custom,
      onExitComplete: function (childId) {
        var e_1, _a;
        presenceChildren.set(childId, true);
        try {
          for (var _b = tslib.__values(presenceChildren.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
            var isComplete = _c.value;
            if (!isComplete) return; // can stop searching when any is incomplete
          }
        } catch (e_1_1) {
          e_1 = {
            error: e_1_1
          };
        } finally {
          try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
          } finally {
            if (e_1) throw e_1.error;
          }
        }
        onExitComplete === null || onExitComplete === void 0 ? void 0 : onExitComplete();
      },
      register: function (childId) {
        presenceChildren.set(childId, false);
        return function () {
          return presenceChildren.delete(childId);
        };
      }
    };
  },
  /**
   * If the presence of a child affects the layout of the components around it,
   * we want to make a new context value to ensure they get re-rendered
   * so they can detect that layout change.
   */
  presenceAffectsLayout ? undefined : [isPresent]);
  React.useMemo(function () {
    presenceChildren.forEach(function (_, key) {
      return presenceChildren.set(key, false);
    });
  }, [isPresent]);
  /**
   * If there's no `motion` components to fire exit animations, we want to remove this
   * component immediately.
   */
  React__namespace.useEffect(function () {
    !isPresent && !presenceChildren.size && (onExitComplete === null || onExitComplete === void 0 ? void 0 : onExitComplete());
  }, [isPresent]);
  return React__namespace.createElement(PresenceContext.Provider, {
    value: context
  }, children);
};
function newChildrenMap() {
  return new Map();
}
var getChildKey = function (child) {
  return child.key || "";
};
function updateChildLookup(children, allChildren) {
  children.forEach(function (child) {
    var key = getChildKey(child);
    allChildren.set(key, child);
  });
}
function onlyElements(children) {
  var filtered = [];
  // We use forEach here instead of map as map mutates the component key by preprending `.$`
  React.Children.forEach(children, function (child) {
    if (React.isValidElement(child)) filtered.push(child);
  });
  return filtered;
}
/**
 * `AnimatePresence` enables the animation of components that have been removed from the tree.
 *
 * When adding/removing more than a single child, every child **must** be given a unique `key` prop.
 *
 * Any `motion` components that have an `exit` property defined will animate out when removed from
 * the tree.
 *
 * ```jsx
 * import { motion, AnimatePresence } from 'framer-motion'
 *
 * export const Items = ({ items }) => (
 *   <AnimatePresence>
 *     {items.map(item => (
 *       <motion.div
 *         key={item.id}
 *         initial={{ opacity: 0 }}
 *         animate={{ opacity: 1 }}
 *         exit={{ opacity: 0 }}
 *       />
 *     ))}
 *   </AnimatePresence>
 * )
 * ```
 *
 * You can sequence exit animations throughout a tree using variants.
 *
 * If a child contains multiple `motion` components with `exit` props, it will only unmount the child
 * once all `motion` components have finished animating out. Likewise, any components using
 * `usePresence` all need to call `safeToRemove`.
 *
 * @public
 */
var AnimatePresence = function (_a) {
  var children = _a.children,
    custom = _a.custom,
    _b = _a.initial,
    initial = _b === void 0 ? true : _b,
    onExitComplete = _a.onExitComplete,
    exitBeforeEnter = _a.exitBeforeEnter,
    _c = _a.presenceAffectsLayout,
    presenceAffectsLayout = _c === void 0 ? true : _c;
  // We want to force a re-render once all exiting animations have finished. We
  // either use a local forceRender function, or one from a parent context if it exists.
  var _d = tslib.__read(useForceUpdate(), 1),
    forceRender = _d[0];
  var forceRenderLayoutGroup = React.useContext(LayoutGroupContext).forceRender;
  if (forceRenderLayoutGroup) forceRender = forceRenderLayoutGroup;
  var isMounted = useIsMounted();
  // Filter out any children that aren't ReactElements. We can only track ReactElements with a props.key
  var filteredChildren = onlyElements(children);
  var childrenToRender = filteredChildren;
  var exiting = new Set();
  // Keep a living record of the children we're actually rendering so we
  // can diff to figure out which are entering and exiting
  var presentChildren = React.useRef(childrenToRender);
  // A lookup table to quickly reference components by key
  var allChildren = React.useRef(new Map()).current;
  // If this is the initial component render, just deal with logic surrounding whether
  // we play onMount animations or not.
  var isInitialRender = React.useRef(true);
  useIsomorphicLayoutEffect(function () {
    isInitialRender.current = false;
    updateChildLookup(filteredChildren, allChildren);
    presentChildren.current = childrenToRender;
  });
  useUnmountEffect(function () {
    isInitialRender.current = true;
    allChildren.clear();
    exiting.clear();
  });
  if (isInitialRender.current) {
    return React__namespace.createElement(React__namespace.Fragment, null, childrenToRender.map(function (child) {
      return React__namespace.createElement(PresenceChild, {
        key: getChildKey(child),
        isPresent: true,
        initial: initial ? undefined : false,
        presenceAffectsLayout: presenceAffectsLayout
      }, child);
    }));
  }
  // If this is a subsequent render, deal with entering and exiting children
  childrenToRender = tslib.__spreadArray([], tslib.__read(childrenToRender), false);
  // Diff the keys of the currently-present and target children to update our
  // exiting list.
  var presentKeys = presentChildren.current.map(getChildKey);
  var targetKeys = filteredChildren.map(getChildKey);
  // Diff the present children with our target children and mark those that are exiting
  var numPresent = presentKeys.length;
  for (var i = 0; i < numPresent; i++) {
    var key = presentKeys[i];
    if (targetKeys.indexOf(key) === -1) {
      exiting.add(key);
    }
  }
  // If we currently have exiting children, and we're deferring rendering incoming children
  // until after all current children have exiting, empty the childrenToRender array
  if (exitBeforeEnter && exiting.size) {
    childrenToRender = [];
  }
  // Loop through all currently exiting components and clone them to overwrite `animate`
  // with any `exit` prop they might have defined.
  exiting.forEach(function (key) {
    // If this component is actually entering again, early return
    if (targetKeys.indexOf(key) !== -1) return;
    var child = allChildren.get(key);
    if (!child) return;
    var insertionIndex = presentKeys.indexOf(key);
    var onExit = function () {
      allChildren.delete(key);
      exiting.delete(key);
      // Remove this child from the present children
      var removeIndex = presentChildren.current.findIndex(function (presentChild) {
        return presentChild.key === key;
      });
      presentChildren.current.splice(removeIndex, 1);
      // Defer re-rendering until all exiting children have indeed left
      if (!exiting.size) {
        presentChildren.current = filteredChildren;
        if (isMounted.current === false) return;
        forceRender();
        onExitComplete && onExitComplete();
      }
    };
    childrenToRender.splice(insertionIndex, 0, React__namespace.createElement(PresenceChild, {
      key: getChildKey(child),
      isPresent: false,
      onExitComplete: onExit,
      custom: custom,
      presenceAffectsLayout: presenceAffectsLayout
    }, child));
  });
  // Add `MotionContext` even to children that don't need it to ensure we're rendering
  // the same tree between renders
  childrenToRender = childrenToRender.map(function (child) {
    var key = child.key;
    return exiting.has(key) ? child : React__namespace.createElement(PresenceChild, {
      key: getChildKey(child),
      isPresent: true,
      presenceAffectsLayout: presenceAffectsLayout
    }, child);
  });
  if (env !== "production" && exitBeforeEnter && childrenToRender.length > 1) {
    console.warn("You're attempting to animate multiple children within AnimatePresence, but its exitBeforeEnter prop is set to true. This will lead to odd visual behaviour.");
  }
  return React__namespace.createElement(React__namespace.Fragment, null, exiting.size ? childrenToRender : childrenToRender.map(function (child) {
    return React.cloneElement(child);
  }));
};

/**
 * @deprecated
 */
var DeprecatedLayoutGroupContext = React.createContext(null);
var notify = function (node) {
  return !node.isLayoutDirty && node.willUpdate(false);
};
function nodeGroup() {
  var nodes = new Set();
  var subscriptions = new WeakMap();
  var dirtyAll = function () {
    return nodes.forEach(notify);
  };
  return {
    add: function (node) {
      nodes.add(node);
      subscriptions.set(node, node.addEventListener("willUpdate", dirtyAll));
    },
    remove: function (node) {
      var _a;
      nodes.delete(node);
      (_a = subscriptions.get(node)) === null || _a === void 0 ? void 0 : _a();
      subscriptions.delete(node);
      dirtyAll();
    },
    dirty: dirtyAll
  };
}
var shouldInheritGroup = function (inherit) {
  return inherit === true;
};
var shouldInheritId = function (inherit) {
  return shouldInheritGroup(inherit === true) || inherit === "id";
};
var LayoutGroup = function (_a) {
  var _b, _c;
  var children = _a.children,
    id = _a.id,
    inheritId = _a.inheritId,
    _d = _a.inherit,
    inherit = _d === void 0 ? true : _d;
  // Maintain backwards-compatibility with inheritId until 7.0
  if (inheritId !== undefined) inherit = inheritId;
  var layoutGroupContext = React.useContext(LayoutGroupContext);
  var deprecatedLayoutGroupContext = React.useContext(DeprecatedLayoutGroupContext);
  var _e = tslib.__read(useForceUpdate(), 2),
    forceRender = _e[0],
    key = _e[1];
  var context = React.useRef(null);
  var upstreamId = (_b = layoutGroupContext.id) !== null && _b !== void 0 ? _b : deprecatedLayoutGroupContext;
  if (context.current === null) {
    if (shouldInheritId(inherit) && upstreamId) {
      id = id ? upstreamId + "-" + id : upstreamId;
    }
    context.current = {
      id: id,
      group: shouldInheritGroup(inherit) ? (_c = layoutGroupContext === null || layoutGroupContext === void 0 ? void 0 : layoutGroupContext.group) !== null && _c !== void 0 ? _c : nodeGroup() : nodeGroup()
    };
  }
  var memoizedContext = React.useMemo(function () {
    return tslib.__assign(tslib.__assign({}, context.current), {
      forceRender: forceRender
    });
  }, [key]);
  return React__namespace.createElement(LayoutGroupContext.Provider, {
    value: memoizedContext
  }, children);
};
var id = 0;
var AnimateSharedLayout = function (_a) {
  var children = _a.children;
  React__namespace.useEffect(function () {
    heyListen.warning(false, "AnimateSharedLayout is deprecated: https://www.framer.com/docs/guide-upgrade/##shared-layout-animations");
  }, []);
  return React__namespace.createElement(LayoutGroup, {
    id: useConstant(function () {
      return "asl-".concat(id++);
    })
  }, children);
};

/**
 * `MotionConfig` is used to set configuration options for all children `motion` components.
 *
 * ```jsx
 * import { motion, MotionConfig } from "framer-motion"
 *
 * export function App() {
 *   return (
 *     <MotionConfig transition={{ type: "spring" }}>
 *       <motion.div animate={{ x: 100 }} />
 *     </MotionConfig>
 *   )
 * }
 * ```
 *
 * @public
 */
function MotionConfig(_a) {
  var children = _a.children,
    isValidProp = _a.isValidProp,
    config = tslib.__rest(_a, ["children", "isValidProp"]);
  isValidProp && loadExternalIsValidProp(isValidProp);
  /**
   * Inherit props from any parent MotionConfig components
   */
  config = tslib.__assign(tslib.__assign({}, React.useContext(MotionConfigContext)), config);
  /**
   * Don't allow isStatic to change between renders as it affects how many hooks
   * motion components fire.
   */
  config.isStatic = useConstant(function () {
    return config.isStatic;
  });
  /**
   * Creating a new config context object will re-render every `motion` component
   * every time it renders. So we only want to create a new one sparingly.
   */
  var context = React.useMemo(function () {
    return config;
  }, [JSON.stringify(config.transition), config.transformPagePoint, config.reducedMotion]);
  return React__namespace.createElement(MotionConfigContext.Provider, {
    value: context
  }, children);
}

/**
 * Used in conjunction with the `m` component to reduce bundle size.
 *
 * `m` is a version of the `motion` component that only loads functionality
 * critical for the initial render.
 *
 * `LazyMotion` can then be used to either synchronously or asynchronously
 * load animation and gesture support.
 *
 * ```jsx
 * // Synchronous loading
 * import { LazyMotion, m, domAnimations } from "framer-motion"
 *
 * function App() {
 *   return (
 *     <LazyMotion features={domAnimations}>
 *       <m.div animate={{ scale: 2 }} />
 *     </LazyMotion>
 *   )
 * }
 *
 * // Asynchronous loading
 * import { LazyMotion, m } from "framer-motion"
 *
 * function App() {
 *   return (
 *     <LazyMotion features={() => import('./path/to/domAnimations')}>
 *       <m.div animate={{ scale: 2 }} />
 *     </LazyMotion>
 *   )
 * }
 * ```
 *
 * @public
 */
function LazyMotion(_a) {
  var children = _a.children,
    features = _a.features,
    _b = _a.strict,
    strict = _b === void 0 ? false : _b;
  var _c = tslib.__read(React.useState(!isLazyBundle(features)), 2),
    setIsLoaded = _c[1];
  var loadedRenderer = React.useRef(undefined);
  /**
   * If this is a synchronous load, load features immediately
   */
  if (!isLazyBundle(features)) {
    var renderer = features.renderer,
      loadedFeatures = tslib.__rest(features, ["renderer"]);
    loadedRenderer.current = renderer;
    loadFeatures(loadedFeatures);
  }
  React.useEffect(function () {
    if (isLazyBundle(features)) {
      features().then(function (_a) {
        var renderer = _a.renderer,
          loadedFeatures = tslib.__rest(_a, ["renderer"]);
        loadFeatures(loadedFeatures);
        loadedRenderer.current = renderer;
        setIsLoaded(true);
      });
    }
  }, []);
  return React__namespace.createElement(LazyContext.Provider, {
    value: {
      renderer: loadedRenderer.current,
      strict: strict
    }
  }, children);
}
function isLazyBundle(features) {
  return typeof features === "function";
}
var ReorderContext = React.createContext(null);
function checkReorder(order, value, offset, velocity) {
  if (!velocity) return order;
  var index = order.findIndex(function (item) {
    return item.value === value;
  });
  if (index === -1) return order;
  var nextOffset = velocity > 0 ? 1 : -1;
  var nextItem = order[index + nextOffset];
  if (!nextItem) return order;
  var item = order[index];
  var nextLayout = nextItem.layout;
  var nextItemCenter = popmotion.mix(nextLayout.min, nextLayout.max, 0.5);
  if (nextOffset === 1 && item.layout.max + offset > nextItemCenter || nextOffset === -1 && item.layout.min + offset < nextItemCenter) {
    return moveItem(order, index, index + nextOffset);
  }
  return order;
}
function ReorderGroup(_a, externalRef) {
  var children = _a.children,
    _b = _a.as,
    as = _b === void 0 ? "ul" : _b,
    _c = _a.axis,
    axis = _c === void 0 ? "y" : _c,
    onReorder = _a.onReorder,
    values = _a.values,
    props = tslib.__rest(_a, ["children", "as", "axis", "onReorder", "values"]);
  var Component = useConstant(function () {
    return motion(as);
  });
  var order = [];
  var isReordering = React.useRef(false);
  heyListen.invariant(Boolean(values), "Reorder.Group must be provided a values prop");
  var context = {
    axis: axis,
    registerItem: function (value, layout) {
      /**
       * Ensure entries can't add themselves more than once
       */
      if (layout && order.findIndex(function (entry) {
        return value === entry.value;
      }) === -1) {
        order.push({
          value: value,
          layout: layout[axis]
        });
        order.sort(compareMin);
      }
    },
    updateOrder: function (id, offset, velocity) {
      if (isReordering.current) return;
      var newOrder = checkReorder(order, id, offset, velocity);
      if (order !== newOrder) {
        isReordering.current = true;
        onReorder(newOrder.map(getValue).filter(function (value) {
          return values.indexOf(value) !== -1;
        }));
      }
    }
  };
  React.useEffect(function () {
    isReordering.current = false;
  });
  return React__namespace.createElement(Component, tslib.__assign({}, props, {
    ref: externalRef
  }), React__namespace.createElement(ReorderContext.Provider, {
    value: context
  }, children));
}
var Group = React.forwardRef(ReorderGroup);
function getValue(item) {
  return item.value;
}
function compareMin(a, b) {
  return a.layout.min - b.layout.min;
}

/**
 * Creates a `MotionValue` to track the state and velocity of a value.
 *
 * Usually, these are created automatically. For advanced use-cases, like use with `useTransform`, you can create `MotionValue`s externally and pass them into the animated component via the `style` prop.
 *
 * ```jsx
 * export const MyComponent = () => {
 *   const scale = useMotionValue(1)
 *
 *   return <motion.div style={{ scale }} />
 * }
 * ```
 *
 * @param initial - The initial state.
 *
 * @public
 */
function useMotionValue(initial) {
  var value = useConstant(function () {
    return motionValue(initial);
  });
  /**
   * If this motion value is being used in static mode, like on
   * the Framer canvas, force components to rerender when the motion
   * value is updated.
   */
  var isStatic = React.useContext(MotionConfigContext).isStatic;
  if (isStatic) {
    var _a = tslib.__read(React.useState(initial), 2),
      setLatest_1 = _a[1];
    React.useEffect(function () {
      return value.onChange(setLatest_1);
    }, []);
  }
  return value;
}
var isCustomValueType = function (v) {
  return typeof v === "object" && v.mix;
};
var getMixer = function (v) {
  return isCustomValueType(v) ? v.mix : undefined;
};
function transform() {
  var args = [];
  for (var _i = 0; _i < arguments.length; _i++) {
    args[_i] = arguments[_i];
  }
  var useImmediate = !Array.isArray(args[0]);
  var argOffset = useImmediate ? 0 : -1;
  var inputValue = args[0 + argOffset];
  var inputRange = args[1 + argOffset];
  var outputRange = args[2 + argOffset];
  var options = args[3 + argOffset];
  var interpolator = popmotion.interpolate(inputRange, outputRange, tslib.__assign({
    mixer: getMixer(outputRange[0])
  }, options));
  return useImmediate ? interpolator(inputValue) : interpolator;
}
function useOnChange(value, callback) {
  useIsomorphicLayoutEffect(function () {
    if (isMotionValue(value)) return value.onChange(callback);
  }, [callback]);
}
function useMultiOnChange(values, handler) {
  useIsomorphicLayoutEffect(function () {
    var subscriptions = values.map(function (value) {
      return value.onChange(handler);
    });
    return function () {
      return subscriptions.forEach(function (unsubscribe) {
        return unsubscribe();
      });
    };
  });
}
function useCombineMotionValues(values, combineValues) {
  /**
   * Initialise the returned motion value. This remains the same between renders.
   */
  var value = useMotionValue(combineValues());
  /**
   * Create a function that will update the template motion value with the latest values.
   * This is pre-bound so whenever a motion value updates it can schedule its
   * execution in Framesync. If it's already been scheduled it won't be fired twice
   * in a single frame.
   */
  var updateValue = function () {
    return value.set(combineValues());
  };
  /**
   * Synchronously update the motion value with the latest values during the render.
   * This ensures that within a React render, the styles applied to the DOM are up-to-date.
   */
  updateValue();
  /**
   * Subscribe to all motion values found within the template. Whenever any of them change,
   * schedule an update.
   */
  useMultiOnChange(values, function () {
    return sync__default["default"].update(updateValue, false, true);
  });
  return value;
}
function useTransform(input, inputRangeOrTransformer, outputRange, options) {
  var transformer = typeof inputRangeOrTransformer === "function" ? inputRangeOrTransformer : transform(inputRangeOrTransformer, outputRange, options);
  return Array.isArray(input) ? useListTransform(input, transformer) : useListTransform([input], function (_a) {
    var _b = tslib.__read(_a, 1),
      latest = _b[0];
    return transformer(latest);
  });
}
function useListTransform(values, transformer) {
  var latest = useConstant(function () {
    return [];
  });
  return useCombineMotionValues(values, function () {
    latest.length = 0;
    var numValues = values.length;
    for (var i = 0; i < numValues; i++) {
      latest[i] = values[i].get();
    }
    return transformer(latest);
  });
}
function useDefaultMotionValue(value, defaultValue) {
  if (defaultValue === void 0) {
    defaultValue = 0;
  }
  return isMotionValue(value) ? value : useMotionValue(defaultValue);
}
function ReorderItem(_a, externalRef) {
  var children = _a.children,
    style = _a.style,
    value = _a.value,
    _b = _a.as,
    as = _b === void 0 ? "li" : _b,
    onDrag = _a.onDrag,
    _c = _a.layout,
    layout = _c === void 0 ? true : _c,
    props = tslib.__rest(_a, ["children", "style", "value", "as", "onDrag", "layout"]);
  var Component = useConstant(function () {
    return motion(as);
  });
  var context = React.useContext(ReorderContext);
  var point = {
    x: useDefaultMotionValue(style === null || style === void 0 ? void 0 : style.x),
    y: useDefaultMotionValue(style === null || style === void 0 ? void 0 : style.y)
  };
  var zIndex = useTransform([point.x, point.y], function (_a) {
    var _b = tslib.__read(_a, 2),
      latestX = _b[0],
      latestY = _b[1];
    return latestX || latestY ? 1 : "unset";
  });
  var measuredLayout = React.useRef(null);
  heyListen.invariant(Boolean(context), "Reorder.Item must be a child of Reorder.Group");
  var _d = context,
    axis = _d.axis,
    registerItem = _d.registerItem,
    updateOrder = _d.updateOrder;
  React.useEffect(function () {
    registerItem(value, measuredLayout.current);
  }, [context]);
  return React__namespace.createElement(Component, tslib.__assign({
    drag: axis
  }, props, {
    dragSnapToOrigin: true,
    style: tslib.__assign(tslib.__assign({}, style), {
      x: point.x,
      y: point.y,
      zIndex: zIndex
    }),
    layout: layout,
    onDrag: function (event, gesturePoint) {
      var velocity = gesturePoint.velocity;
      velocity[axis] && updateOrder(value, point[axis].get(), velocity[axis]);
      onDrag === null || onDrag === void 0 ? void 0 : onDrag(event, gesturePoint);
    },
    onLayoutMeasure: function (measured) {
      measuredLayout.current = measured;
    },
    ref: externalRef
  }), children);
}
var Item = React.forwardRef(ReorderItem);
var Reorder = {
  Group: Group,
  Item: Item
};

/**
 * @public
 */
var domAnimation = tslib.__assign(tslib.__assign({
  renderer: createDomVisualElement
}, animations), gestureAnimations);

/**
 * @public
 */
var domMax = tslib.__assign(tslib.__assign(tslib.__assign(tslib.__assign({}, domAnimation), drag), layoutFeatures), {
  projectionNodeConstructor: HTMLProjectionNode
});

/**
 * Combine multiple motion values into a new one using a string template literal.
 *
 * ```jsx
 * import {
 *   motion,
 *   useSpring,
 *   useMotionValue,
 *   useMotionTemplate
 * } from "framer-motion"
 *
 * function Component() {
 *   const shadowX = useSpring(0)
 *   const shadowY = useMotionValue(0)
 *   const shadow = useMotionTemplate`drop-shadow(${shadowX}px ${shadowY}px 20px rgba(0,0,0,0.3))`
 *
 *   return <motion.div style={{ filter: shadow }} />
 * }
 * ```
 *
 * @public
 */
function useMotionTemplate(fragments) {
  var values = [];
  for (var _i = 1; _i < arguments.length; _i++) {
    values[_i - 1] = arguments[_i];
  }
  /**
   * Create a function that will build a string from the latest motion values.
   */
  var numFragments = fragments.length;
  function buildValue() {
    var output = "";
    for (var i = 0; i < numFragments; i++) {
      output += fragments[i];
      var value = values[i];
      if (value) output += values[i].get();
    }
    return output;
  }
  return useCombineMotionValues(values, buildValue);
}

/**
 * Creates a `MotionValue` that, when `set`, will use a spring animation to animate to its new state.
 *
 * It can either work as a stand-alone `MotionValue` by initialising it with a value, or as a subscriber
 * to another `MotionValue`.
 *
 * @remarks
 *
 * ```jsx
 * const x = useSpring(0, { stiffness: 300 })
 * const y = useSpring(x, { damping: 10 })
 * ```
 *
 * @param inputValue - `MotionValue` or number. If provided a `MotionValue`, when the input `MotionValue` changes, the created `MotionValue` will spring towards that value.
 * @param springConfig - Configuration options for the spring.
 * @returns `MotionValue`
 *
 * @public
 */
function useSpring(source, config) {
  if (config === void 0) {
    config = {};
  }
  var isStatic = React.useContext(MotionConfigContext).isStatic;
  var activeSpringAnimation = React.useRef(null);
  var value = useMotionValue(isMotionValue(source) ? source.get() : source);
  React.useMemo(function () {
    return value.attach(function (v, set) {
      /**
       * A more hollistic approach to this might be to use isStatic to fix VisualElement animations
       * at that level, but this will work for now
       */
      if (isStatic) return set(v);
      if (activeSpringAnimation.current) {
        activeSpringAnimation.current.stop();
      }
      activeSpringAnimation.current = popmotion.animate(tslib.__assign(tslib.__assign({
        from: value.get(),
        to: v,
        velocity: value.getVelocity()
      }, config), {
        onUpdate: set
      }));
      return value.get();
    });
  }, [JSON.stringify(config)]);
  useOnChange(source, function (v) {
    return value.set(parseFloat(v));
  });
  return value;
}

/**
 * Creates a `MotionValue` that updates when the velocity of the provided `MotionValue` changes.
 *
 * ```javascript
 * const x = useMotionValue(0)
 * const xVelocity = useVelocity(x)
 * const xAcceleration = useVelocity(xVelocity)
 * ```
 *
 * @public
 */
function useVelocity(value) {
  var velocity = useMotionValue(value.getVelocity());
  React.useEffect(function () {
    return value.velocityUpdateSubscribers.add(function (newVelocity) {
      velocity.set(newVelocity);
    });
  }, [value]);
  return velocity;
}
var createScrollMotionValues = function () {
  return {
    scrollX: motionValue(0),
    scrollY: motionValue(0),
    scrollXProgress: motionValue(0),
    scrollYProgress: motionValue(0)
  };
};
function useScroll(_a) {
  if (_a === void 0) {
    _a = {};
  }
  var container = _a.container,
    target = _a.target,
    options = tslib.__rest(_a, ["container", "target"]);
  var values = useConstant(createScrollMotionValues);
  useIsomorphicLayoutEffect(function () {
    return dom.scroll(function (_a) {
      var x = _a.x,
        y = _a.y;
      values.scrollX.set(x.current);
      values.scrollXProgress.set(x.progress);
      values.scrollY.set(y.current);
      values.scrollYProgress.set(y.progress);
    }, tslib.__assign(tslib.__assign({}, options), {
      container: (container === null || container === void 0 ? void 0 : container.current) || undefined,
      target: (target === null || target === void 0 ? void 0 : target.current) || undefined
    }));
  }, []);
  return values;
}
function useElementScroll(ref) {
  warnOnce(false, "useElementScroll is deprecated. Convert to useScroll({ container: ref }).");
  return useScroll({
    container: ref
  });
}
function useViewportScroll() {
  warnOnce(false, "useViewportScroll is deprecated. Convert to useScroll().");
  return useScroll();
}
var getCurrentTime = typeof performance !== "undefined" ? function () {
  return performance.now();
} : function () {
  return Date.now();
};
function useAnimationFrame(callback) {
  var initialTimestamp = useConstant(getCurrentTime);
  var isStatic = React.useContext(MotionConfigContext).isStatic;
  React.useEffect(function () {
    if (isStatic) return;
    var provideTimeSinceStart = function (_a) {
      var timestamp = _a.timestamp;
      callback(timestamp - initialTimestamp);
    };
    sync__default["default"].update(provideTimeSinceStart, true);
    return function () {
      return sync.cancelSync.update(provideTimeSinceStart);
    };
  }, [callback]);
}
function useTime() {
  var time = useMotionValue(0);
  useAnimationFrame(function (t) {
    return time.set(t);
  });
  return time;
}

/**
 * @public
 */
function animationControls() {
  /**
   * Track whether the host component has mounted.
   */
  var hasMounted = false;
  /**
   * Pending animations that are started before a component is mounted.
   * TODO: Remove this as animations should only run in effects
   */
  var pendingAnimations = [];
  /**
   * A collection of linked component animation controls.
   */
  var subscribers = new Set();
  var controls = {
    subscribe: function (visualElement) {
      subscribers.add(visualElement);
      return function () {
        return void subscribers.delete(visualElement);
      };
    },
    start: function (definition, transitionOverride) {
      /**
       * TODO: We only perform this hasMounted check because in Framer we used to
       * encourage the ability to start an animation within the render phase. This
       * isn't behaviour concurrent-safe so when we make Framer concurrent-safe
       * we can ditch this.
       */
      if (hasMounted) {
        var animations_1 = [];
        subscribers.forEach(function (visualElement) {
          animations_1.push(animateVisualElement(visualElement, definition, {
            transitionOverride: transitionOverride
          }));
        });
        return Promise.all(animations_1);
      } else {
        return new Promise(function (resolve) {
          pendingAnimations.push({
            animation: [definition, transitionOverride],
            resolve: resolve
          });
        });
      }
    },
    set: function (definition) {
      heyListen.invariant(hasMounted, "controls.set() should only be called after a component has mounted. Consider calling within a useEffect hook.");
      return subscribers.forEach(function (visualElement) {
        setValues(visualElement, definition);
      });
    },
    stop: function () {
      subscribers.forEach(function (visualElement) {
        stopAnimation(visualElement);
      });
    },
    mount: function () {
      hasMounted = true;
      pendingAnimations.forEach(function (_a) {
        var animation = _a.animation,
          resolve = _a.resolve;
        controls.start.apply(controls, tslib.__spreadArray([], tslib.__read(animation), false)).then(resolve);
      });
      return function () {
        hasMounted = false;
        controls.stop();
      };
    }
  };
  return controls;
}

/**
 * Creates `AnimationControls`, which can be used to manually start, stop
 * and sequence animations on one or more components.
 *
 * The returned `AnimationControls` should be passed to the `animate` property
 * of the components you want to animate.
 *
 * These components can then be animated with the `start` method.
 *
 * ```jsx
 * import * as React from 'react'
 * import { motion, useAnimation } from 'framer-motion'
 *
 * export function MyComponent(props) {
 *    const controls = useAnimation()
 *
 *    controls.start({
 *        x: 100,
 *        transition: { duration: 0.5 },
 *    })
 *
 *    return <motion.div animate={controls} />
 * }
 * ```
 *
 * @returns Animation controller with `start` and `stop` methods
 *
 * @public
 */
function useAnimationControls() {
  var controls = useConstant(animationControls);
  React.useEffect(controls.mount, []);
  return controls;
}
var useAnimation = useAnimationControls;

/**
 * Cycles through a series of visual properties. Can be used to toggle between or cycle through animations. It works similar to `useState` in React. It is provided an initial array of possible states, and returns an array of two arguments.
 *
 * An index value can be passed to the returned `cycle` function to cycle to a specific index.
 *
 * ```jsx
 * import * as React from "react"
 * import { motion, useCycle } from "framer-motion"
 *
 * export const MyComponent = () => {
 *   const [x, cycleX] = useCycle(0, 50, 100)
 *
 *   return (
 *     <motion.div
 *       animate={{ x: x }}
 *       onTap={() => cycleX()}
 *      />
 *    )
 * }
 * ```
 *
 * @param items - items to cycle through
 * @returns [currentState, cycleState]
 *
 * @public
 */
function useCycle() {
  var items = [];
  for (var _i = 0; _i < arguments.length; _i++) {
    items[_i] = arguments[_i];
  }
  var index = React.useRef(0);
  var _a = tslib.__read(React.useState(items[index.current]), 2),
    item = _a[0],
    setItem = _a[1];
  var runCycle = React.useCallback(function (next) {
    index.current = typeof next !== "number" ? popmotion.wrap(0, items.length, index.current + 1) : next;
    setItem(items[index.current]);
  }, tslib.__spreadArray([items.length], tslib.__read(items), false));
  return [item, runCycle];
}
function useInView(ref, _a) {
  var _b = _a === void 0 ? {} : _a,
    root = _b.root,
    margin = _b.margin,
    amount = _b.amount,
    _c = _b.once,
    once = _c === void 0 ? false : _c;
  var _d = tslib.__read(React.useState(false), 2),
    isInView = _d[0],
    setInView = _d[1];
  React.useEffect(function () {
    var _a;
    if (!ref.current || once && isInView) return;
    var onEnter = function () {
      setInView(true);
      return once ? undefined : function () {
        return setInView(false);
      };
    };
    var options = {
      root: (_a = root === null || root === void 0 ? void 0 : root.current) !== null && _a !== void 0 ? _a : undefined,
      margin: margin,
      amount: amount === "some" ? "any" : amount
    };
    return dom.inView(ref.current, onEnter, options);
  }, [root, ref, margin, once]);
  return isInView;
}

/**
 * Can manually trigger a drag gesture on one or more `drag`-enabled `motion` components.
 *
 * ```jsx
 * const dragControls = useDragControls()
 *
 * function startDrag(event) {
 *   dragControls.start(event, { snapToCursor: true })
 * }
 *
 * return (
 *   <>
 *     <div onPointerDown={startDrag} />
 *     <motion.div drag="x" dragControls={dragControls} />
 *   </>
 * )
 * ```
 *
 * @public
 */
var DragControls = /** @class */function () {
  function DragControls() {
    this.componentControls = new Set();
  }
  /**
   * Subscribe a component's internal `VisualElementDragControls` to the user-facing API.
   *
   * @internal
   */
  DragControls.prototype.subscribe = function (controls) {
    var _this = this;
    this.componentControls.add(controls);
    return function () {
      return _this.componentControls.delete(controls);
    };
  };
  /**
   * Start a drag gesture on every `motion` component that has this set of drag controls
   * passed into it via the `dragControls` prop.
   *
   * ```jsx
   * dragControls.start(e, {
   *   snapToCursor: true
   * })
   * ```
   *
   * @param event - PointerEvent
   * @param options - Options
   *
   * @public
   */
  DragControls.prototype.start = function (event, options) {
    this.componentControls.forEach(function (controls) {
      controls.start(event.nativeEvent || event, options);
    });
  };
  return DragControls;
}();
var createDragControls = function () {
  return new DragControls();
};
/**
 * Usually, dragging is initiated by pressing down on a `motion` component with a `drag` prop
 * and moving it. For some use-cases, for instance clicking at an arbitrary point on a video scrubber, we
 * might want to initiate that dragging from a different component than the draggable one.
 *
 * By creating a `dragControls` using the `useDragControls` hook, we can pass this into
 * the draggable component's `dragControls` prop. It exposes a `start` method
 * that can start dragging from pointer events on other components.
 *
 * ```jsx
 * const dragControls = useDragControls()
 *
 * function startDrag(event) {
 *   dragControls.start(event, { snapToCursor: true })
 * }
 *
 * return (
 *   <>
 *     <div onPointerDown={startDrag} />
 *     <motion.div drag="x" dragControls={dragControls} />
 *   </>
 * )
 * ```
 *
 * @public
 */
function useDragControls() {
  return useConstant(createDragControls);
}
function useInstantLayoutTransition() {
  return startTransition;
}
function startTransition(cb) {
  if (!rootProjectionNode.current) return;
  rootProjectionNode.current.isUpdating = false;
  rootProjectionNode.current.blockUpdate();
  cb === null || cb === void 0 ? void 0 : cb();
}
function useInstantTransition() {
  var _a = tslib.__read(useForceUpdate(), 2),
    forceUpdate = _a[0],
    forcedRenderCount = _a[1];
  var startInstantLayoutTransition = useInstantLayoutTransition();
  React.useEffect(function () {
    /**
     * Unblock after two animation frames, otherwise this will unblock too soon.
     */
    sync__default["default"].postRender(function () {
      return sync__default["default"].postRender(function () {
        return instantAnimationState.current = false;
      });
    });
  }, [forcedRenderCount]);
  return function (callback) {
    startInstantLayoutTransition(function () {
      instantAnimationState.current = true;
      forceUpdate();
      callback();
    });
  };
}
function useResetProjection() {
  var reset = React__namespace.useCallback(function () {
    var root = rootProjectionNode.current;
    if (!root) return;
    root.resetTree();
  }, []);
  return reset;
}
var createObject = function () {
  return {};
};
var stateVisualElement = visualElement({
  build: function () {},
  measureViewportBox: createBox,
  resetTransform: function () {},
  restoreTransform: function () {},
  removeValueFromRenderState: function () {},
  render: function () {},
  scrapeMotionValuesFromProps: createObject,
  readValueFromInstance: function (_state, key, options) {
    return options.initialState[key] || 0;
  },
  makeTargetAnimatable: function (element, _a) {
    var transition = _a.transition,
      transitionEnd = _a.transitionEnd,
      target = tslib.__rest(_a, ["transition", "transitionEnd"]);
    var origin = getOrigin(target, transition || {}, element);
    checkTargetForNewValues(element, target, origin);
    return tslib.__assign({
      transition: transition,
      transitionEnd: transitionEnd
    }, target);
  }
});
var useVisualState = makeUseVisualState({
  scrapeMotionValuesFromProps: createObject,
  createRenderState: createObject
});
/**
 * This is not an officially supported API and may be removed
 * on any version.
 */
function useAnimatedState(initialState) {
  var _a = tslib.__read(React.useState(initialState), 2),
    animationState = _a[0],
    setAnimationState = _a[1];
  var visualState = useVisualState({}, false);
  var element = useConstant(function () {
    return stateVisualElement({
      props: {},
      visualState: visualState
    }, {
      initialState: initialState
    });
  });
  React.useEffect(function () {
    element.mount({});
    return element.unmount;
  }, [element]);
  React.useEffect(function () {
    element.setProps({
      onUpdate: function (v) {
        setAnimationState(tslib.__assign({}, v));
      }
    });
  }, [setAnimationState, element]);
  var startAnimation = useConstant(function () {
    return function (animationDefinition) {
      return animateVisualElement(element, animationDefinition);
    };
  });
  return [animationState, startAnimation];
}

// Keep things reasonable and avoid scale: Infinity. In practise we might need
// to add another value, opacity, that could interpolate scaleX/Y [0,0.01] => [0,1]
// to simply hide content at unreasonable scales.
var maxScale = 100000;
var invertScale = function (scale) {
  return scale > 0.001 ? 1 / scale : maxScale;
};
var hasWarned = false;
/**
 * Returns a `MotionValue` each for `scaleX` and `scaleY` that update with the inverse
 * of their respective parent scales.
 *
 * This is useful for undoing the distortion of content when scaling a parent component.
 *
 * By default, `useInvertedScale` will automatically fetch `scaleX` and `scaleY` from the nearest parent.
 * By passing other `MotionValue`s in as `useInvertedScale({ scaleX, scaleY })`, it will invert the output
 * of those instead.
 *
 * ```jsx
 * const MyComponent = () => {
 *   const { scaleX, scaleY } = useInvertedScale()
 *   return <motion.div style={{ scaleX, scaleY }} />
 * }
 * ```
 *
 * @deprecated
 */
function useInvertedScale(scale) {
  var parentScaleX = useMotionValue(1);
  var parentScaleY = useMotionValue(1);
  var visualElement = useVisualElementContext();
  heyListen.invariant(!!(scale || visualElement), "If no scale values are provided, useInvertedScale must be used within a child of another motion component.");
  heyListen.warning(hasWarned, "useInvertedScale is deprecated and will be removed in 3.0. Use the layout prop instead.");
  hasWarned = true;
  if (scale) {
    parentScaleX = scale.scaleX || parentScaleX;
    parentScaleY = scale.scaleY || parentScaleY;
  } else if (visualElement) {
    parentScaleX = visualElement.getValue("scaleX", 1);
    parentScaleY = visualElement.getValue("scaleY", 1);
  }
  var scaleX = useTransform(parentScaleX, invertScale);
  var scaleY = useTransform(parentScaleY, invertScale);
  return {
    scaleX: scaleX,
    scaleY: scaleY
  };
}
exports.AnimatePresence = AnimatePresence;
exports.AnimateSharedLayout = AnimateSharedLayout;
exports.DeprecatedLayoutGroupContext = DeprecatedLayoutGroupContext;
exports.DragControls = DragControls;
exports.FlatTree = FlatTree;
exports.LayoutGroup = LayoutGroup;
exports.LayoutGroupContext = LayoutGroupContext;
exports.LazyMotion = LazyMotion;
exports.MotionConfig = MotionConfig;
exports.MotionConfigContext = MotionConfigContext;
exports.MotionContext = MotionContext;
exports.MotionValue = MotionValue;
exports.PresenceContext = PresenceContext;
exports.Reorder = Reorder;
exports.SwitchLayoutGroupContext = SwitchLayoutGroupContext;
exports.addPointerEvent = addPointerEvent;
exports.addScaleCorrector = addScaleCorrector;
exports.animate = animate;
exports.animateVisualElement = animateVisualElement;
exports.animationControls = animationControls;
exports.animations = animations;
exports.calcLength = calcLength;
exports.checkTargetForNewValues = checkTargetForNewValues;
exports.createBox = createBox;
exports.createDomMotionComponent = createDomMotionComponent;
exports.createMotionComponent = createMotionComponent;
exports.domAnimation = domAnimation;
exports.domMax = domMax;
exports.filterProps = filterProps;
exports.isBrowser = isBrowser;
exports.isDragActive = isDragActive;
exports.isMotionValue = isMotionValue;
exports.isValidMotionProp = isValidMotionProp;
exports.m = m;
exports.makeUseVisualState = makeUseVisualState;
exports.motion = motion;
exports.motionValue = motionValue;
exports.resolveMotionValue = resolveMotionValue;
exports.transform = transform;
exports.useAnimation = useAnimation;
exports.useAnimationControls = useAnimationControls;
exports.useAnimationFrame = useAnimationFrame;
exports.useCycle = useCycle;
exports.useDeprecatedAnimatedState = useAnimatedState;
exports.useDeprecatedInvertedScale = useInvertedScale;
exports.useDomEvent = useDomEvent;
exports.useDragControls = useDragControls;
exports.useElementScroll = useElementScroll;
exports.useForceUpdate = useForceUpdate;
exports.useInView = useInView;
exports.useInstantLayoutTransition = useInstantLayoutTransition;
exports.useInstantTransition = useInstantTransition;
exports.useIsPresent = useIsPresent;
exports.useIsomorphicLayoutEffect = useIsomorphicLayoutEffect;
exports.useMotionTemplate = useMotionTemplate;
exports.useMotionValue = useMotionValue;
exports.usePresence = usePresence;
exports.useReducedMotion = useReducedMotion;
exports.useReducedMotionConfig = useReducedMotionConfig;
exports.useResetProjection = useResetProjection;
exports.useScroll = useScroll;
exports.useSpring = useSpring;
exports.useTime = useTime;
exports.useTransform = useTransform;
exports.useUnmountEffect = useUnmountEffect;
exports.useVelocity = useVelocity;
exports.useViewportScroll = useViewportScroll;
exports.useVisualElementContext = useVisualElementContext;
exports.visualElement = visualElement;
exports.wrapHandler = wrapHandler;

/***/ }),

/***/ "../../../node_modules/framesync/dist/framesync.cjs.js":
/*!*************************************************************!*\
  !*** ../../../node_modules/framesync/dist/framesync.cjs.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
const defaultTimestep = 1 / 60 * 1000;
const getCurrentTime = typeof performance !== "undefined" ? () => performance.now() : () => Date.now();
const onNextFrame = typeof window !== "undefined" ? callback => window.requestAnimationFrame(callback) : callback => setTimeout(() => callback(getCurrentTime()), defaultTimestep);
function createRenderStep(runNextFrame) {
  let toRun = [];
  let toRunNextFrame = [];
  let numToRun = 0;
  let isProcessing = false;
  let flushNextFrame = false;
  const toKeepAlive = new WeakSet();
  const step = {
    schedule: (callback, keepAlive = false, immediate = false) => {
      const addToCurrentFrame = immediate && isProcessing;
      const buffer = addToCurrentFrame ? toRun : toRunNextFrame;
      if (keepAlive) toKeepAlive.add(callback);
      if (buffer.indexOf(callback) === -1) {
        buffer.push(callback);
        if (addToCurrentFrame && isProcessing) numToRun = toRun.length;
      }
      return callback;
    },
    cancel: callback => {
      const index = toRunNextFrame.indexOf(callback);
      if (index !== -1) toRunNextFrame.splice(index, 1);
      toKeepAlive.delete(callback);
    },
    process: frameData => {
      if (isProcessing) {
        flushNextFrame = true;
        return;
      }
      isProcessing = true;
      [toRun, toRunNextFrame] = [toRunNextFrame, toRun];
      toRunNextFrame.length = 0;
      numToRun = toRun.length;
      if (numToRun) {
        for (let i = 0; i < numToRun; i++) {
          const callback = toRun[i];
          callback(frameData);
          if (toKeepAlive.has(callback)) {
            step.schedule(callback);
            runNextFrame();
          }
        }
      }
      isProcessing = false;
      if (flushNextFrame) {
        flushNextFrame = false;
        step.process(frameData);
      }
    }
  };
  return step;
}
const maxElapsed = 40;
let useDefaultElapsed = true;
let runNextFrame = false;
let isProcessing = false;
const frame = {
  delta: 0,
  timestamp: 0
};
const stepsOrder = ["read", "update", "preRender", "render", "postRender"];
const steps = stepsOrder.reduce((acc, key) => {
  acc[key] = createRenderStep(() => runNextFrame = true);
  return acc;
}, {});
const sync = stepsOrder.reduce((acc, key) => {
  const step = steps[key];
  acc[key] = (process, keepAlive = false, immediate = false) => {
    if (!runNextFrame) startLoop();
    return step.schedule(process, keepAlive, immediate);
  };
  return acc;
}, {});
const cancelSync = stepsOrder.reduce((acc, key) => {
  acc[key] = steps[key].cancel;
  return acc;
}, {});
const flushSync = stepsOrder.reduce((acc, key) => {
  acc[key] = () => steps[key].process(frame);
  return acc;
}, {});
const processStep = stepId => steps[stepId].process(frame);
const processFrame = timestamp => {
  runNextFrame = false;
  frame.delta = useDefaultElapsed ? defaultTimestep : Math.max(Math.min(timestamp - frame.timestamp, maxElapsed), 1);
  frame.timestamp = timestamp;
  isProcessing = true;
  stepsOrder.forEach(processStep);
  isProcessing = false;
  if (runNextFrame) {
    useDefaultElapsed = false;
    onNextFrame(processFrame);
  }
};
const startLoop = () => {
  runNextFrame = true;
  useDefaultElapsed = true;
  if (!isProcessing) onNextFrame(processFrame);
};
const getFrameData = () => frame;
exports.cancelSync = cancelSync;
exports["default"] = sync;
exports.flushSync = flushSync;
exports.getFrameData = getFrameData;

/***/ }),

/***/ "../../../node_modules/get-nonce/dist/es2015/index.js":
/*!************************************************************!*\
  !*** ../../../node_modules/get-nonce/dist/es2015/index.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.setNonce = exports.getNonce = void 0;
var currentNonce;
var setNonce = function (nonce) {
  currentNonce = nonce;
};
exports.setNonce = setNonce;
var getNonce = function () {
  if (currentNonce) {
    return currentNonce;
  }
  if (true) {
    return __webpack_require__.nc;
  }
  return undefined;
};
exports.getNonce = getNonce;

/***/ }),

/***/ "../../../node_modules/graphql-ws/lib/client.mjs":
/*!*******************************************************!*\
  !*** ../../../node_modules/graphql-ws/lib/client.mjs ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var _exportNames = {
  createClient: true
};
exports.createClient = createClient;
var _common = __webpack_require__(/*! ./common.mjs */ "../../../node_modules/graphql-ws/lib/common.mjs");
Object.keys(_common).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _common[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _common[key];
    }
  });
});
var _utils = __webpack_require__(/*! ./utils.mjs */ "../../../node_modules/graphql-ws/lib/utils.mjs");
/**
 *
 * client
 *
 */
var __await = void 0 && (void 0).__await || function (v) {
  return this instanceof __await ? (this.v = v, this) : new __await(v);
};
var __asyncGenerator = void 0 && (void 0).__asyncGenerator || function (thisArg, _arguments, generator) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var g = generator.apply(thisArg, _arguments || []),
    i,
    q = [];
  return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () {
    return this;
  }, i;
  function verb(n) {
    if (g[n]) i[n] = function (v) {
      return new Promise(function (a, b) {
        q.push([n, v, a, b]) > 1 || resume(n, v);
      });
    };
  }
  function resume(n, v) {
    try {
      step(g[n](v));
    } catch (e) {
      settle(q[0][3], e);
    }
  }
  function step(r) {
    r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
  }
  function fulfill(value) {
    resume("next", value);
  }
  function reject(value) {
    resume("throw", value);
  }
  function settle(f, v) {
    if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]);
  }
};

/** This file is the entry point for browsers, re-export common elements. */

/**
 * Creates a disposable GraphQL over WebSocket client.
 *
 * @category Client
 */
function createClient(options) {
  const {
    url,
    connectionParams,
    lazy = true,
    onNonLazyError = console.error,
    lazyCloseTimeout: lazyCloseTimeoutMs = 0,
    keepAlive = 0,
    disablePong,
    connectionAckWaitTimeout = 0,
    retryAttempts = 5,
    retryWait = async function randomisedExponentialBackoff(retries) {
      let retryDelay = 1000; // start with 1s delay
      for (let i = 0; i < retries; i++) {
        retryDelay *= 2;
      }
      await new Promise(resolve => setTimeout(resolve, retryDelay +
      // add random timeout from 300ms to 3s
      Math.floor(Math.random() * (3000 - 300) + 300)));
    },
    shouldRetry = isLikeCloseEvent,
    isFatalConnectionProblem,
    on,
    webSocketImpl,
    /**
     * Generates a v4 UUID to be used as the ID using `Math`
     * as the random number generator. Supply your own generator
     * in case you need more uniqueness.
     *
     * Reference: https://gist.github.com/jed/982883
     */
    generateID = function generateUUID() {
      return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, c => {
        const r = Math.random() * 16 | 0,
          v = c == 'x' ? r : r & 0x3 | 0x8;
        return v.toString(16);
      });
    },
    jsonMessageReplacer: replacer,
    jsonMessageReviver: reviver
  } = options;
  let ws;
  if (webSocketImpl) {
    if (!isWebSocket(webSocketImpl)) {
      throw new Error('Invalid WebSocket implementation provided');
    }
    ws = webSocketImpl;
  } else if (typeof WebSocket !== 'undefined') {
    ws = WebSocket;
  } else if (typeof __webpack_require__.g !== 'undefined') {
    ws = __webpack_require__.g.WebSocket ||
    // @ts-expect-error: Support more browsers
    __webpack_require__.g.MozWebSocket;
  } else if (typeof window !== 'undefined') {
    ws = window.WebSocket ||
    // @ts-expect-error: Support more browsers
    window.MozWebSocket;
  }
  if (!ws) throw new Error("WebSocket implementation missing; on Node you can `import WebSocket from 'ws';` and pass `webSocketImpl: WebSocket` to `createClient`");
  const WebSocketImpl = ws;
  // websocket status emitter, subscriptions are handled differently
  const emitter = (() => {
    const message = (() => {
      const listeners = {};
      return {
        on(id, listener) {
          listeners[id] = listener;
          return () => {
            delete listeners[id];
          };
        },
        emit(message) {
          var _a;
          if ('id' in message) (_a = listeners[message.id]) === null || _a === void 0 ? void 0 : _a.call(listeners, message);
        }
      };
    })();
    const listeners = {
      connecting: (on === null || on === void 0 ? void 0 : on.connecting) ? [on.connecting] : [],
      opened: (on === null || on === void 0 ? void 0 : on.opened) ? [on.opened] : [],
      connected: (on === null || on === void 0 ? void 0 : on.connected) ? [on.connected] : [],
      ping: (on === null || on === void 0 ? void 0 : on.ping) ? [on.ping] : [],
      pong: (on === null || on === void 0 ? void 0 : on.pong) ? [on.pong] : [],
      message: (on === null || on === void 0 ? void 0 : on.message) ? [message.emit, on.message] : [message.emit],
      closed: (on === null || on === void 0 ? void 0 : on.closed) ? [on.closed] : [],
      error: (on === null || on === void 0 ? void 0 : on.error) ? [on.error] : []
    };
    return {
      onMessage: message.on,
      on(event, listener) {
        const l = listeners[event];
        l.push(listener);
        return () => {
          l.splice(l.indexOf(listener), 1);
        };
      },
      emit(event, ...args) {
        // we copy the listeners so that unlistens dont "pull the rug under our feet"
        for (const listener of [...listeners[event]]) {
          // @ts-expect-error: The args should fit
          listener(...args);
        }
      }
    };
  })();
  // invokes the callback either when an error or closed event is emitted,
  // first one that gets called prevails, other emissions are ignored
  function errorOrClosed(cb) {
    const listening = [
    // errors are fatal and more critical than close events, throw them first
    emitter.on('error', err => {
      listening.forEach(unlisten => unlisten());
      cb(err);
    }),
    // closes can be graceful and not fatal, throw them second (if error didnt throw)
    emitter.on('closed', event => {
      listening.forEach(unlisten => unlisten());
      cb(event);
    })];
  }
  let connecting,
    locks = 0,
    lazyCloseTimeout,
    retrying = false,
    retries = 0,
    disposed = false;
  async function connect() {
    // clear the lazy close timeout immediatelly so that close gets debounced
    // see: https://github.com/enisdenjo/graphql-ws/issues/388
    clearTimeout(lazyCloseTimeout);
    const [socket, throwOnClose] = await (connecting !== null && connecting !== void 0 ? connecting : connecting = new Promise((connected, denied) => (async () => {
      if (retrying) {
        await retryWait(retries);
        // subscriptions might complete while waiting for retry
        if (!locks) {
          connecting = undefined;
          return denied({
            code: 1000,
            reason: 'All Subscriptions Gone'
          });
        }
        retries++;
      }
      emitter.emit('connecting');
      const socket = new WebSocketImpl(typeof url === 'function' ? await url() : url, _common.GRAPHQL_TRANSPORT_WS_PROTOCOL);
      let connectionAckTimeout, queuedPing;
      function enqueuePing() {
        if (isFinite(keepAlive) && keepAlive > 0) {
          clearTimeout(queuedPing); // in case where a pong was received before a ping (this is valid behaviour)
          queuedPing = setTimeout(() => {
            if (socket.readyState === WebSocketImpl.OPEN) {
              socket.send((0, _common.stringifyMessage)({
                type: _common.MessageType.Ping
              }));
              emitter.emit('ping', false, undefined);
            }
          }, keepAlive);
        }
      }
      errorOrClosed(errOrEvent => {
        connecting = undefined;
        clearTimeout(connectionAckTimeout);
        clearTimeout(queuedPing);
        denied(errOrEvent);
        if (isLikeCloseEvent(errOrEvent) && errOrEvent.code === 4499) {
          socket.close(4499, 'Terminated'); // close event is artificial and emitted manually, see `Client.terminate()` below
          socket.onerror = null;
          socket.onclose = null;
        }
      });
      socket.onerror = err => emitter.emit('error', err);
      socket.onclose = event => emitter.emit('closed', event);
      socket.onopen = async () => {
        try {
          emitter.emit('opened', socket);
          const payload = typeof connectionParams === 'function' ? await connectionParams() : connectionParams;
          // connectionParams might take too long causing the server to kick off the client
          // the necessary error/close event is already reported - simply stop execution
          if (socket.readyState !== WebSocketImpl.OPEN) return;
          socket.send((0, _common.stringifyMessage)(payload ? {
            type: _common.MessageType.ConnectionInit,
            payload
          } : {
            type: _common.MessageType.ConnectionInit
            // payload is completely absent if not provided
          }, replacer));
          if (isFinite(connectionAckWaitTimeout) && connectionAckWaitTimeout > 0) {
            connectionAckTimeout = setTimeout(() => {
              socket.close(_common.CloseCode.ConnectionAcknowledgementTimeout, 'Connection acknowledgement timeout');
            }, connectionAckWaitTimeout);
          }
          enqueuePing(); // enqueue ping (noop if disabled)
        } catch (err) {
          emitter.emit('error', err);
          socket.close(_common.CloseCode.InternalClientError, (0, _utils.limitCloseReason)(err instanceof Error ? err.message : new Error(err).message, 'Internal client error'));
        }
      };
      let acknowledged = false;
      socket.onmessage = ({
        data
      }) => {
        try {
          const message = (0, _common.parseMessage)(data, reviver);
          emitter.emit('message', message);
          if (message.type === 'ping' || message.type === 'pong') {
            emitter.emit(message.type, true, message.payload); // received
            if (message.type === 'pong') {
              enqueuePing(); // enqueue next ping (noop if disabled)
            } else if (!disablePong) {
              // respond with pong on ping
              socket.send((0, _common.stringifyMessage)(message.payload ? {
                type: _common.MessageType.Pong,
                payload: message.payload
              } : {
                type: _common.MessageType.Pong
                // payload is completely absent if not provided
              }));
              emitter.emit('pong', false, message.payload);
            }
            return; // ping and pongs can be received whenever
          }
          if (acknowledged) return; // already connected and acknowledged
          if (message.type !== _common.MessageType.ConnectionAck) throw new Error(`First message cannot be of type ${message.type}`);
          clearTimeout(connectionAckTimeout);
          acknowledged = true;
          emitter.emit('connected', socket, message.payload); // connected = socket opened + acknowledged
          retrying = false; // future lazy connects are not retries
          retries = 0; // reset the retries on connect
          connected([socket, new Promise((_, reject) => errorOrClosed(reject))]);
        } catch (err) {
          socket.onmessage = null; // stop reading messages as soon as reading breaks once
          emitter.emit('error', err);
          socket.close(_common.CloseCode.BadResponse, (0, _utils.limitCloseReason)(err instanceof Error ? err.message : new Error(err).message, 'Bad response'));
        }
      };
    })()));
    // if the provided socket is in a closing state, wait for the throw on close
    if (socket.readyState === WebSocketImpl.CLOSING) await throwOnClose;
    let release = () => {
      // releases this connection
    };
    const released = new Promise(resolve => release = resolve);
    return [socket, release, Promise.race([
    // wait for
    released.then(() => {
      if (!locks) {
        // and if no more locks are present, complete the connection
        const complete = () => socket.close(1000, 'Normal Closure');
        if (isFinite(lazyCloseTimeoutMs) && lazyCloseTimeoutMs > 0) {
          // if the keepalive is set, allow for the specified calmdown time and
          // then complete if the socket is still open.
          lazyCloseTimeout = setTimeout(() => {
            if (socket.readyState === WebSocketImpl.OPEN) complete();
          }, lazyCloseTimeoutMs);
        } else {
          // otherwise complete immediately
          complete();
        }
      }
    }),
    // or
    throwOnClose])];
  }
  /**
   * Checks the `connect` problem and evaluates if the client should retry.
   */
  function shouldRetryConnectOrThrow(errOrCloseEvent) {
    // some close codes are worth reporting immediately
    if (isLikeCloseEvent(errOrCloseEvent) && (isFatalInternalCloseCode(errOrCloseEvent.code) || [_common.CloseCode.InternalServerError, _common.CloseCode.InternalClientError, _common.CloseCode.BadRequest, _common.CloseCode.BadResponse, _common.CloseCode.Unauthorized,
    // CloseCode.Forbidden, might grant access out after retry
    _common.CloseCode.SubprotocolNotAcceptable,
    // CloseCode.ConnectionInitialisationTimeout, might not time out after retry
    // CloseCode.ConnectionAcknowledgementTimeout, might not time out after retry
    _common.CloseCode.SubscriberAlreadyExists, _common.CloseCode.TooManyInitialisationRequests
    // 4499, // Terminated, probably because the socket froze, we want to retry
    ].includes(errOrCloseEvent.code))) throw errOrCloseEvent;
    // client was disposed, no retries should proceed regardless
    if (disposed) return false;
    // normal closure (possibly all subscriptions have completed)
    // if no locks were acquired in the meantime, shouldnt try again
    if (isLikeCloseEvent(errOrCloseEvent) && errOrCloseEvent.code === 1000) return locks > 0;
    // retries are not allowed or we tried to many times, report error
    if (!retryAttempts || retries >= retryAttempts) throw errOrCloseEvent;
    // throw non-retryable connection problems
    if (!shouldRetry(errOrCloseEvent)) throw errOrCloseEvent;
    // @deprecated throw fatal connection problems immediately
    if (isFatalConnectionProblem === null || isFatalConnectionProblem === void 0 ? void 0 : isFatalConnectionProblem(errOrCloseEvent)) throw errOrCloseEvent;
    // looks good, start retrying
    return retrying = true;
  }
  // in non-lazy (hot?) mode always hold one connection lock to persist the socket
  if (!lazy) {
    (async () => {
      locks++;
      for (;;) {
        try {
          const [,, throwOnClose] = await connect();
          await throwOnClose; // will always throw because releaser is not used
        } catch (errOrCloseEvent) {
          try {
            if (!shouldRetryConnectOrThrow(errOrCloseEvent)) return;
          } catch (errOrCloseEvent) {
            // report thrown error, no further retries
            return onNonLazyError === null || onNonLazyError === void 0 ? void 0 : onNonLazyError(errOrCloseEvent);
          }
        }
      }
    })();
  }
  return {
    on: emitter.on,
    subscribe(payload, sink) {
      const id = generateID(payload);
      let done = false,
        errored = false,
        releaser = () => {
          // for handling completions before connect
          locks--;
          done = true;
        };
      (async () => {
        locks++;
        for (;;) {
          try {
            const [socket, release, waitForReleaseOrThrowOnClose] = await connect();
            // if done while waiting for connect, release the connection lock right away
            if (done) return release();
            const unlisten = emitter.onMessage(id, message => {
              switch (message.type) {
                case _common.MessageType.Next:
                  {
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any -- payload will fit type
                    sink.next(message.payload);
                    return;
                  }
                case _common.MessageType.Error:
                  {
                    errored = true, done = true;
                    sink.error(message.payload);
                    releaser();
                    return;
                  }
                case _common.MessageType.Complete:
                  {
                    done = true;
                    releaser(); // release completes the sink
                    return;
                  }
              }
            });
            socket.send((0, _common.stringifyMessage)({
              id,
              type: _common.MessageType.Subscribe,
              payload
            }, replacer));
            releaser = () => {
              if (!done && socket.readyState === WebSocketImpl.OPEN)
                // if not completed already and socket is open, send complete message to server on release
                socket.send((0, _common.stringifyMessage)({
                  id,
                  type: _common.MessageType.Complete
                }, replacer));
              locks--;
              done = true;
              release();
            };
            // either the releaser will be called, connection completed and
            // the promise resolved or the socket closed and the promise rejected.
            // whatever happens though, we want to stop listening for messages
            await waitForReleaseOrThrowOnClose.finally(unlisten);
            return; // completed, shouldnt try again
          } catch (errOrCloseEvent) {
            if (!shouldRetryConnectOrThrow(errOrCloseEvent)) return;
          }
        }
      })().then(() => {
        // delivering either an error or a complete terminates the sequence
        if (!errored) sink.complete();
      }) // resolves on release or normal closure
      .catch(err => {
        sink.error(err);
      }); // rejects on close events and errors
      return () => {
        // dispose only of active subscriptions
        if (!done) releaser();
      };
    },
    iterate(request) {
      const pending = [];
      const deferred = {
        done: false,
        error: null,
        resolve: () => {
          // noop
        }
      };
      const dispose = this.subscribe(request, {
        next(val) {
          pending.push(val);
          deferred.resolve();
        },
        error(err) {
          deferred.done = true;
          deferred.error = err;
          deferred.resolve();
        },
        complete() {
          deferred.done = true;
          deferred.resolve();
        }
      });
      const iterator = function iterator() {
        return __asyncGenerator(this, arguments, function* iterator_1() {
          for (;;) {
            if (!pending.length) {
              // only wait if there are no pending messages available
              yield __await(new Promise(resolve => deferred.resolve = resolve));
            }
            // first flush
            while (pending.length) {
              // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
              yield yield __await(pending.shift());
            }
            // then error
            if (deferred.error) {
              throw deferred.error;
            }
            // or complete
            if (deferred.done) {
              return yield __await(void 0);
            }
          }
        });
      }();
      iterator.throw = async err => {
        if (!deferred.done) {
          deferred.done = true;
          deferred.error = err;
          deferred.resolve();
        }
        return {
          done: true,
          value: undefined
        };
      };
      iterator.return = async () => {
        dispose();
        return {
          done: true,
          value: undefined
        };
      };
      return iterator;
    },
    async dispose() {
      disposed = true;
      if (connecting) {
        // if there is a connection, close it
        const [socket] = await connecting;
        socket.close(1000, 'Normal Closure');
      }
    },
    terminate() {
      if (connecting) {
        // only if there is a connection
        emitter.emit('closed', {
          code: 4499,
          reason: 'Terminated',
          wasClean: false
        });
      }
    }
  };
}
function isLikeCloseEvent(val) {
  return (0, _utils.isObject)(val) && 'code' in val && 'reason' in val;
}
function isFatalInternalCloseCode(code) {
  if ([1000, 1001, 1006, 1005, 1012, 1013, 1013 // Bad Gateway
  ].includes(code)) return false;
  // all other internal errors are fatal
  return code >= 1000 && code <= 1999;
}
function isWebSocket(val) {
  return typeof val === 'function' && 'constructor' in val && 'CLOSED' in val && 'CLOSING' in val && 'CONNECTING' in val && 'OPEN' in val;
}

/***/ }),

/***/ "../../../node_modules/graphql-ws/lib/common.mjs":
/*!*******************************************************!*\
  !*** ../../../node_modules/graphql-ws/lib/common.mjs ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.MessageType = exports.GRAPHQL_TRANSPORT_WS_PROTOCOL = exports.DEPRECATED_GRAPHQL_WS_PROTOCOL = exports.CloseCode = void 0;
exports.isMessage = isMessage;
exports.parseMessage = parseMessage;
exports.stringifyMessage = stringifyMessage;
exports.validateMessage = validateMessage;
var _utils = __webpack_require__(/*! ./utils.mjs */ "../../../node_modules/graphql-ws/lib/utils.mjs");
/**
 *
 * common
 *
 */

/**
 * The WebSocket sub-protocol used for the [GraphQL over WebSocket Protocol](https://github.com/graphql/graphql-over-http/blob/main/rfcs/GraphQLOverWebSocket.md).
 *
 * @category Common
 */
const GRAPHQL_TRANSPORT_WS_PROTOCOL = exports.GRAPHQL_TRANSPORT_WS_PROTOCOL = 'graphql-transport-ws';
/**
 * The deprecated subprotocol used by [subscriptions-transport-ws](https://github.com/apollographql/subscriptions-transport-ws).
 *
 * @private
 */
const DEPRECATED_GRAPHQL_WS_PROTOCOL = exports.DEPRECATED_GRAPHQL_WS_PROTOCOL = 'graphql-ws';
/**
 * `graphql-ws` expected and standard close codes of the [GraphQL over WebSocket Protocol](https://github.com/graphql/graphql-over-http/blob/main/rfcs/GraphQLOverWebSocket.md).
 *
 * @category Common
 */
var CloseCode;
(function (CloseCode) {
  CloseCode[CloseCode["InternalServerError"] = 4500] = "InternalServerError";
  CloseCode[CloseCode["InternalClientError"] = 4005] = "InternalClientError";
  CloseCode[CloseCode["BadRequest"] = 4400] = "BadRequest";
  CloseCode[CloseCode["BadResponse"] = 4004] = "BadResponse";
  /** Tried subscribing before connect ack */
  CloseCode[CloseCode["Unauthorized"] = 4401] = "Unauthorized";
  CloseCode[CloseCode["Forbidden"] = 4403] = "Forbidden";
  CloseCode[CloseCode["SubprotocolNotAcceptable"] = 4406] = "SubprotocolNotAcceptable";
  CloseCode[CloseCode["ConnectionInitialisationTimeout"] = 4408] = "ConnectionInitialisationTimeout";
  CloseCode[CloseCode["ConnectionAcknowledgementTimeout"] = 4504] = "ConnectionAcknowledgementTimeout";
  /** Subscriber distinction is very important */
  CloseCode[CloseCode["SubscriberAlreadyExists"] = 4409] = "SubscriberAlreadyExists";
  CloseCode[CloseCode["TooManyInitialisationRequests"] = 4429] = "TooManyInitialisationRequests";
})(CloseCode || (exports.CloseCode = CloseCode = {}));
/**
 * Types of messages allowed to be sent by the client/server over the WS protocol.
 *
 * @category Common
 */
var MessageType;
(function (MessageType) {
  MessageType["ConnectionInit"] = "connection_init";
  MessageType["ConnectionAck"] = "connection_ack";
  MessageType["Ping"] = "ping";
  MessageType["Pong"] = "pong";
  MessageType["Subscribe"] = "subscribe";
  MessageType["Next"] = "next";
  MessageType["Error"] = "error";
  MessageType["Complete"] = "complete";
})(MessageType || (exports.MessageType = MessageType = {}));
/**
 * Validates the message against the GraphQL over WebSocket Protocol.
 *
 * Invalid messages will throw descriptive errors.
 *
 * @category Common
 */
function validateMessage(val) {
  if (!(0, _utils.isObject)(val)) {
    throw new Error(`Message is expected to be an object, but got ${(0, _utils.extendedTypeof)(val)}`);
  }
  if (!val.type) {
    throw new Error(`Message is missing the 'type' property`);
  }
  if (typeof val.type !== 'string') {
    throw new Error(`Message is expects the 'type' property to be a string, but got ${(0, _utils.extendedTypeof)(val.type)}`);
  }
  switch (val.type) {
    case MessageType.ConnectionInit:
    case MessageType.ConnectionAck:
    case MessageType.Ping:
    case MessageType.Pong:
      {
        if (val.payload != null && !(0, _utils.isObject)(val.payload)) {
          throw new Error(`"${val.type}" message expects the 'payload' property to be an object or nullish or missing, but got "${val.payload}"`);
        }
        break;
      }
    case MessageType.Subscribe:
      {
        if (typeof val.id !== 'string') {
          throw new Error(`"${val.type}" message expects the 'id' property to be a string, but got ${(0, _utils.extendedTypeof)(val.id)}`);
        }
        if (!val.id) {
          throw new Error(`"${val.type}" message requires a non-empty 'id' property`);
        }
        if (!(0, _utils.isObject)(val.payload)) {
          throw new Error(`"${val.type}" message expects the 'payload' property to be an object, but got ${(0, _utils.extendedTypeof)(val.payload)}`);
        }
        if (typeof val.payload.query !== 'string') {
          throw new Error(`"${val.type}" message payload expects the 'query' property to be a string, but got ${(0, _utils.extendedTypeof)(val.payload.query)}`);
        }
        if (val.payload.variables != null && !(0, _utils.isObject)(val.payload.variables)) {
          throw new Error(`"${val.type}" message payload expects the 'variables' property to be a an object or nullish or missing, but got ${(0, _utils.extendedTypeof)(val.payload.variables)}`);
        }
        if (val.payload.operationName != null && (0, _utils.extendedTypeof)(val.payload.operationName) !== 'string') {
          throw new Error(`"${val.type}" message payload expects the 'operationName' property to be a string or nullish or missing, but got ${(0, _utils.extendedTypeof)(val.payload.operationName)}`);
        }
        if (val.payload.extensions != null && !(0, _utils.isObject)(val.payload.extensions)) {
          throw new Error(`"${val.type}" message payload expects the 'extensions' property to be a an object or nullish or missing, but got ${(0, _utils.extendedTypeof)(val.payload.extensions)}`);
        }
        break;
      }
    case MessageType.Next:
      {
        if (typeof val.id !== 'string') {
          throw new Error(`"${val.type}" message expects the 'id' property to be a string, but got ${(0, _utils.extendedTypeof)(val.id)}`);
        }
        if (!val.id) {
          throw new Error(`"${val.type}" message requires a non-empty 'id' property`);
        }
        if (!(0, _utils.isObject)(val.payload)) {
          throw new Error(`"${val.type}" message expects the 'payload' property to be an object, but got ${(0, _utils.extendedTypeof)(val.payload)}`);
        }
        break;
      }
    case MessageType.Error:
      {
        if (typeof val.id !== 'string') {
          throw new Error(`"${val.type}" message expects the 'id' property to be a string, but got ${(0, _utils.extendedTypeof)(val.id)}`);
        }
        if (!val.id) {
          throw new Error(`"${val.type}" message requires a non-empty 'id' property`);
        }
        if (!(0, _utils.areGraphQLErrors)(val.payload)) {
          throw new Error(`"${val.type}" message expects the 'payload' property to be an array of GraphQL errors, but got ${JSON.stringify(val.payload)}`);
        }
        break;
      }
    case MessageType.Complete:
      {
        if (typeof val.id !== 'string') {
          throw new Error(`"${val.type}" message expects the 'id' property to be a string, but got ${(0, _utils.extendedTypeof)(val.id)}`);
        }
        if (!val.id) {
          throw new Error(`"${val.type}" message requires a non-empty 'id' property`);
        }
        break;
      }
    default:
      throw new Error(`Invalid message 'type' property "${val.type}"`);
  }
  return val;
}
/**
 * Checks if the provided value is a valid GraphQL over WebSocket message.
 *
 * @deprecated Use `validateMessage` instead.
 *
 * @category Common
 */
function isMessage(val) {
  try {
    validateMessage(val);
    return true;
  } catch (_a) {
    return false;
  }
}
/**
 * Parses the raw websocket message data to a valid message.
 *
 * @category Common
 */
function parseMessage(data, reviver) {
  return validateMessage(typeof data === 'string' ? JSON.parse(data, reviver) : data);
}
/**
 * Stringifies a valid message ready to be sent through the socket.
 *
 * @category Common
 */
function stringifyMessage(msg, replacer) {
  validateMessage(msg);
  return JSON.stringify(msg, replacer);
}

/***/ }),

/***/ "../../../node_modules/graphql-ws/lib/index.js":
/*!*****************************************************!*\
  !*** ../../../node_modules/graphql-ws/lib/index.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



var __createBinding = void 0 && (void 0).__createBinding || (Object.create ? function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  var desc = Object.getOwnPropertyDescriptor(m, k);
  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
    desc = {
      enumerable: true,
      get: function () {
        return m[k];
      }
    };
  }
  Object.defineProperty(o, k2, desc);
} : function (o, m, k, k2) {
  if (k2 === undefined) k2 = k;
  o[k2] = m[k];
});
var __exportStar = void 0 && (void 0).__exportStar || function (m, exports) {
  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
__exportStar(__webpack_require__(/*! ./client */ "../../../node_modules/graphql-ws/lib/client.mjs"), exports);
__exportStar(__webpack_require__(/*! ./server */ "../../../node_modules/graphql-ws/lib/server.mjs"), exports);
__exportStar(__webpack_require__(/*! ./common */ "../../../node_modules/graphql-ws/lib/common.mjs"), exports);

/***/ }),

/***/ "../../../node_modules/graphql-ws/lib/server.mjs":
/*!*******************************************************!*\
  !*** ../../../node_modules/graphql-ws/lib/server.mjs ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.handleProtocols = handleProtocols;
exports.makeServer = makeServer;
var _graphql = __webpack_require__(/*! graphql */ "../../../node_modules/graphql/index.mjs");
var _common = __webpack_require__(/*! ./common.mjs */ "../../../node_modules/graphql-ws/lib/common.mjs");
var _utils = __webpack_require__(/*! ./utils.mjs */ "../../../node_modules/graphql-ws/lib/utils.mjs");
/**
 *
 * server
 *
 */
var __asyncValues = void 0 && (void 0).__asyncValues || function (o) {
  if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
  var m = o[Symbol.asyncIterator],
    i;
  return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () {
    return this;
  }, i);
  function verb(n) {
    i[n] = o[n] && function (v) {
      return new Promise(function (resolve, reject) {
        v = o[n](v), settle(resolve, reject, v.done, v.value);
      });
    };
  }
  function settle(resolve, reject, d, v) {
    Promise.resolve(v).then(function (v) {
      resolve({
        value: v,
        done: d
      });
    }, reject);
  }
};
/**
 * Makes a Protocol complient WebSocket GraphQL server. The server
 * is actually an API which is to be used with your favourite WebSocket
 * server library!
 *
 * Read more about the [GraphQL over WebSocket Protocol](https://github.com/graphql/graphql-over-http/blob/main/rfcs/GraphQLOverWebSocket.md).
 *
 * @category Server
 */
function makeServer(options) {
  const {
    schema,
    context,
    roots,
    validate,
    execute,
    subscribe,
    connectionInitWaitTimeout = 3000,
    // 3 seconds
    onConnect,
    onDisconnect,
    onClose,
    onSubscribe,
    onOperation,
    onNext,
    onError,
    onComplete,
    jsonMessageReviver: reviver,
    jsonMessageReplacer: replacer
  } = options;
  return {
    opened(socket, extra) {
      const ctx = {
        connectionInitReceived: false,
        acknowledged: false,
        subscriptions: {},
        extra
      };
      if (socket.protocol !== _common.GRAPHQL_TRANSPORT_WS_PROTOCOL) {
        socket.close(_common.CloseCode.SubprotocolNotAcceptable, 'Subprotocol not acceptable');
        return async (code, reason) => {
          /* nothing was set up, just notify the closure */
          await (onClose === null || onClose === void 0 ? void 0 : onClose(ctx, code, reason));
        };
      }
      // kick the client off (close socket) if the connection has
      // not been initialised after the specified wait timeout
      const connectionInitWait = connectionInitWaitTimeout > 0 && isFinite(connectionInitWaitTimeout) ? setTimeout(() => {
        if (!ctx.connectionInitReceived) socket.close(_common.CloseCode.ConnectionInitialisationTimeout, 'Connection initialisation timeout');
      }, connectionInitWaitTimeout) : null;
      socket.onMessage(async function onMessage(data) {
        var _a, e_1, _b, _c;
        var _d;
        let message;
        try {
          message = (0, _common.parseMessage)(data, reviver);
        } catch (err) {
          return socket.close(_common.CloseCode.BadRequest, 'Invalid message received');
        }
        switch (message.type) {
          case _common.MessageType.ConnectionInit:
            {
              if (ctx.connectionInitReceived) return socket.close(_common.CloseCode.TooManyInitialisationRequests, 'Too many initialisation requests');
              // @ts-expect-error: I can write
              ctx.connectionInitReceived = true;
              if ((0, _utils.isObject)(message.payload))
                // @ts-expect-error: I can write
                ctx.connectionParams = message.payload;
              const permittedOrPayload = await (onConnect === null || onConnect === void 0 ? void 0 : onConnect(ctx));
              if (permittedOrPayload === false) return socket.close(_common.CloseCode.Forbidden, 'Forbidden');
              await socket.send((0, _common.stringifyMessage)((0, _utils.isObject)(permittedOrPayload) ? {
                type: _common.MessageType.ConnectionAck,
                payload: permittedOrPayload
              } : {
                type: _common.MessageType.ConnectionAck
                // payload is completely absent if not provided
              }, replacer));
              // @ts-expect-error: I can write
              ctx.acknowledged = true;
              return;
            }
          case _common.MessageType.Ping:
            {
              if (socket.onPing)
                // if the onPing listener is registered, automatic pong is disabled
                return await socket.onPing(message.payload);
              await socket.send((0, _common.stringifyMessage)(message.payload ? {
                type: _common.MessageType.Pong,
                payload: message.payload
              } : {
                type: _common.MessageType.Pong
                // payload is completely absent if not provided
              }));
              return;
            }
          case _common.MessageType.Pong:
            return await ((_d = socket.onPong) === null || _d === void 0 ? void 0 : _d.call(socket, message.payload));
          case _common.MessageType.Subscribe:
            {
              if (!ctx.acknowledged) return socket.close(_common.CloseCode.Unauthorized, 'Unauthorized');
              const {
                id,
                payload
              } = message;
              if (id in ctx.subscriptions) return socket.close(_common.CloseCode.SubscriberAlreadyExists, `Subscriber for ${id} already exists`);
              // if this turns out to be a streaming operation, the subscription value
              // will change to an `AsyncIterable`, otherwise it will stay as is
              ctx.subscriptions[id] = null;
              const emit = {
                next: async (result, args) => {
                  let nextMessage = {
                    id,
                    type: _common.MessageType.Next,
                    payload: result
                  };
                  const maybeResult = await (onNext === null || onNext === void 0 ? void 0 : onNext(ctx, nextMessage, args, result));
                  if (maybeResult) nextMessage = Object.assign(Object.assign({}, nextMessage), {
                    payload: maybeResult
                  });
                  await socket.send((0, _common.stringifyMessage)(nextMessage, replacer));
                },
                error: async errors => {
                  let errorMessage = {
                    id,
                    type: _common.MessageType.Error,
                    payload: errors
                  };
                  const maybeErrors = await (onError === null || onError === void 0 ? void 0 : onError(ctx, errorMessage, errors));
                  if (maybeErrors) errorMessage = Object.assign(Object.assign({}, errorMessage), {
                    payload: maybeErrors
                  });
                  await socket.send((0, _common.stringifyMessage)(errorMessage, replacer));
                },
                complete: async notifyClient => {
                  const completeMessage = {
                    id,
                    type: _common.MessageType.Complete
                  };
                  await (onComplete === null || onComplete === void 0 ? void 0 : onComplete(ctx, completeMessage));
                  if (notifyClient) await socket.send((0, _common.stringifyMessage)(completeMessage, replacer));
                }
              };
              try {
                let execArgs;
                const maybeExecArgsOrErrors = await (onSubscribe === null || onSubscribe === void 0 ? void 0 : onSubscribe(ctx, message));
                if (maybeExecArgsOrErrors) {
                  if ((0, _utils.areGraphQLErrors)(maybeExecArgsOrErrors)) return await emit.error(maybeExecArgsOrErrors);else if (Array.isArray(maybeExecArgsOrErrors)) throw new Error('Invalid return value from onSubscribe hook, expected an array of GraphQLError objects');
                  // not errors, is exec args
                  execArgs = maybeExecArgsOrErrors;
                } else {
                  // you either provide a schema dynamically through
                  // `onSubscribe` or you set one up during the server setup
                  if (!schema) throw new Error('The GraphQL schema is not provided');
                  const args = {
                    operationName: payload.operationName,
                    document: (0, _graphql.parse)(payload.query),
                    variableValues: payload.variables
                  };
                  execArgs = Object.assign(Object.assign({}, args), {
                    schema: typeof schema === 'function' ? await schema(ctx, message, args) : schema
                  });
                  const validationErrors = (validate !== null && validate !== void 0 ? validate : _graphql.validate)(execArgs.schema, execArgs.document);
                  if (validationErrors.length > 0) return await emit.error(validationErrors);
                }
                const operationAST = (0, _graphql.getOperationAST)(execArgs.document, execArgs.operationName);
                if (!operationAST) return await emit.error([new _graphql.GraphQLError('Unable to identify operation')]);
                // if `onSubscribe` didnt specify a rootValue, inject one
                if (!('rootValue' in execArgs)) execArgs.rootValue = roots === null || roots === void 0 ? void 0 : roots[operationAST.operation];
                // if `onSubscribe` didn't specify a context, inject one
                if (!('contextValue' in execArgs)) execArgs.contextValue = typeof context === 'function' ? await context(ctx, message, execArgs) : context;
                // the execution arguments have been prepared
                // perform the operation and act accordingly
                let operationResult;
                if (operationAST.operation === 'subscription') operationResult = await (subscribe !== null && subscribe !== void 0 ? subscribe : _graphql.subscribe)(execArgs);
                // operation === 'query' || 'mutation'
                else operationResult = await (execute !== null && execute !== void 0 ? execute : _graphql.execute)(execArgs);
                const maybeResult = await (onOperation === null || onOperation === void 0 ? void 0 : onOperation(ctx, message, execArgs, operationResult));
                if (maybeResult) operationResult = maybeResult;
                if ((0, _utils.isAsyncIterable)(operationResult)) {
                  /** multiple emitted results */
                  if (!(id in ctx.subscriptions)) {
                    // subscription was completed/canceled before the operation settled
                    if ((0, _utils.isAsyncGenerator)(operationResult)) operationResult.return(undefined);
                  } else {
                    ctx.subscriptions[id] = operationResult;
                    try {
                      for (var _e = true, operationResult_1 = __asyncValues(operationResult), operationResult_1_1; operationResult_1_1 = await operationResult_1.next(), _a = operationResult_1_1.done, !_a; _e = true) {
                        _c = operationResult_1_1.value;
                        _e = false;
                        const result = _c;
                        await emit.next(result, execArgs);
                      }
                    } catch (e_1_1) {
                      e_1 = {
                        error: e_1_1
                      };
                    } finally {
                      try {
                        if (!_e && !_a && (_b = operationResult_1.return)) await _b.call(operationResult_1);
                      } finally {
                        if (e_1) throw e_1.error;
                      }
                    }
                  }
                } else {
                  /** single emitted result */
                  // if the client completed the subscription before the single result
                  // became available, he effectively canceled it and no data should be sent
                  if (id in ctx.subscriptions) await emit.next(operationResult, execArgs);
                }
                // lack of subscription at this point indicates that the client
                // completed the subscription, he doesnt need to be reminded
                await emit.complete(id in ctx.subscriptions);
              } finally {
                // whatever happens to the subscription, we finally want to get rid of the reservation
                delete ctx.subscriptions[id];
              }
              return;
            }
          case _common.MessageType.Complete:
            {
              const subscription = ctx.subscriptions[message.id];
              delete ctx.subscriptions[message.id]; // deleting the subscription means no further activity should take place
              if ((0, _utils.isAsyncGenerator)(subscription)) await subscription.return(undefined);
              return;
            }
          default:
            throw new Error(`Unexpected message of type ${message.type} received`);
        }
      });
      // wait for close, cleanup and the disconnect callback
      return async (code, reason) => {
        if (connectionInitWait) clearTimeout(connectionInitWait);
        for (const sub of Object.values(ctx.subscriptions)) {
          if ((0, _utils.isAsyncGenerator)(sub)) await sub.return(undefined);
        }
        if (ctx.acknowledged) await (onDisconnect === null || onDisconnect === void 0 ? void 0 : onDisconnect(ctx, code, reason));
        await (onClose === null || onClose === void 0 ? void 0 : onClose(ctx, code, reason));
      };
    }
  };
}
/**
 * Helper utility for choosing the "graphql-transport-ws" subprotocol from
 * a set of WebSocket subprotocols.
 *
 * Accepts a set of already extracted WebSocket subprotocols or the raw
 * Sec-WebSocket-Protocol header value. In either case, if the right
 * protocol appears, it will be returned.
 *
 * By specification, the server should not provide a value with Sec-WebSocket-Protocol
 * if it does not agree with client's subprotocols. The client has a responsibility
 * to handle the connection afterwards.
 *
 * @category Server
 */
function handleProtocols(protocols) {
  switch (true) {
    case protocols instanceof Set && protocols.has(_common.GRAPHQL_TRANSPORT_WS_PROTOCOL):
    case Array.isArray(protocols) && protocols.includes(_common.GRAPHQL_TRANSPORT_WS_PROTOCOL):
    case typeof protocols === 'string' && protocols.split(',').map(p => p.trim()).includes(_common.GRAPHQL_TRANSPORT_WS_PROTOCOL):
      return _common.GRAPHQL_TRANSPORT_WS_PROTOCOL;
    default:
      return false;
  }
}

/***/ }),

/***/ "../../../node_modules/graphql-ws/lib/utils.mjs":
/*!******************************************************!*\
  !*** ../../../node_modules/graphql-ws/lib/utils.mjs ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.areGraphQLErrors = areGraphQLErrors;
exports.extendedTypeof = extendedTypeof;
exports.isAsyncGenerator = isAsyncGenerator;
exports.isAsyncIterable = isAsyncIterable;
exports.isObject = isObject;
exports.limitCloseReason = limitCloseReason;
/** @private */
function extendedTypeof(val) {
  if (val === null) {
    return 'null';
  }
  if (Array.isArray(val)) {
    return 'array';
  }
  return typeof val;
}
/** @private */
function isObject(val) {
  return extendedTypeof(val) === 'object';
}
/** @private */
function isAsyncIterable(val) {
  return typeof Object(val)[Symbol.asyncIterator] === 'function';
}
/** @private */
function isAsyncGenerator(val) {
  return isObject(val) && typeof Object(val)[Symbol.asyncIterator] === 'function' && typeof val.return === 'function'
  // for lazy ones, we only need the return anyway
  // typeof val.throw === 'function' &&
  // typeof val.next === 'function'
  ;
}
/** @private */
function areGraphQLErrors(obj) {
  return Array.isArray(obj) &&
  // must be at least one error
  obj.length > 0 &&
  // error has at least a message
  obj.every(ob => 'message' in ob);
}
/**
 * Limits the WebSocket close event reason to not exceed a length of one frame.
 * Reference: https://datatracker.ietf.org/doc/html/rfc6455#section-5.2.
 *
 * @private
 */
function limitCloseReason(reason, whenTooLong) {
  return reason.length < 124 ? reason : whenTooLong;
}

/***/ }),

/***/ "../../../node_modules/graphql/error/GraphQLError.mjs":
/*!************************************************************!*\
  !*** ../../../node_modules/graphql/error/GraphQLError.mjs ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.GraphQLError = void 0;
exports.formatError = formatError;
exports.printError = printError;
var _isObjectLike = __webpack_require__(/*! ../jsutils/isObjectLike.mjs */ "../../../node_modules/graphql/jsutils/isObjectLike.mjs");
var _location = __webpack_require__(/*! ../language/location.mjs */ "../../../node_modules/graphql/language/location.mjs");
var _printLocation = __webpack_require__(/*! ../language/printLocation.mjs */ "../../../node_modules/graphql/language/printLocation.mjs");
function toNormalizedOptions(args) {
  const firstArg = args[0];
  if (firstArg == null || 'kind' in firstArg || 'length' in firstArg) {
    return {
      nodes: firstArg,
      source: args[1],
      positions: args[2],
      path: args[3],
      originalError: args[4],
      extensions: args[5]
    };
  }
  return firstArg;
}
/**
 * A GraphQLError describes an Error found during the parse, validate, or
 * execute phases of performing a GraphQL operation. In addition to a message
 * and stack trace, it also includes information about the locations in a
 * GraphQL document and/or execution result that correspond to the Error.
 */

class GraphQLError extends Error {
  /**
   * An array of `{ line, column }` locations within the source GraphQL document
   * which correspond to this error.
   *
   * Errors during validation often contain multiple locations, for example to
   * point out two things with the same name. Errors during execution include a
   * single location, the field which produced the error.
   *
   * Enumerable, and appears in the result of JSON.stringify().
   */

  /**
   * An array describing the JSON-path into the execution response which
   * corresponds to this error. Only included for errors during execution.
   *
   * Enumerable, and appears in the result of JSON.stringify().
   */

  /**
   * An array of GraphQL AST Nodes corresponding to this error.
   */

  /**
   * The source GraphQL document for the first location of this error.
   *
   * Note that if this Error represents more than one node, the source may not
   * represent nodes after the first node.
   */

  /**
   * An array of character offsets within the source GraphQL document
   * which correspond to this error.
   */

  /**
   * The original error thrown from a field resolver during execution.
   */

  /**
   * Extension fields to add to the formatted error.
   */

  /**
   * @deprecated Please use the `GraphQLErrorOptions` constructor overload instead.
   */
  constructor(message, ...rawArgs) {
    var _this$nodes, _nodeLocations$, _ref;
    const {
      nodes,
      source,
      positions,
      path,
      originalError,
      extensions
    } = toNormalizedOptions(rawArgs);
    super(message);
    this.name = 'GraphQLError';
    this.path = path !== null && path !== void 0 ? path : undefined;
    this.originalError = originalError !== null && originalError !== void 0 ? originalError : undefined; // Compute list of blame nodes.

    this.nodes = undefinedIfEmpty(Array.isArray(nodes) ? nodes : nodes ? [nodes] : undefined);
    const nodeLocations = undefinedIfEmpty((_this$nodes = this.nodes) === null || _this$nodes === void 0 ? void 0 : _this$nodes.map(node => node.loc).filter(loc => loc != null)); // Compute locations in the source for the given nodes/positions.

    this.source = source !== null && source !== void 0 ? source : nodeLocations === null || nodeLocations === void 0 ? void 0 : (_nodeLocations$ = nodeLocations[0]) === null || _nodeLocations$ === void 0 ? void 0 : _nodeLocations$.source;
    this.positions = positions !== null && positions !== void 0 ? positions : nodeLocations === null || nodeLocations === void 0 ? void 0 : nodeLocations.map(loc => loc.start);
    this.locations = positions && source ? positions.map(pos => (0, _location.getLocation)(source, pos)) : nodeLocations === null || nodeLocations === void 0 ? void 0 : nodeLocations.map(loc => (0, _location.getLocation)(loc.source, loc.start));
    const originalExtensions = (0, _isObjectLike.isObjectLike)(originalError === null || originalError === void 0 ? void 0 : originalError.extensions) ? originalError === null || originalError === void 0 ? void 0 : originalError.extensions : undefined;
    this.extensions = (_ref = extensions !== null && extensions !== void 0 ? extensions : originalExtensions) !== null && _ref !== void 0 ? _ref : Object.create(null); // Only properties prescribed by the spec should be enumerable.
    // Keep the rest as non-enumerable.

    Object.defineProperties(this, {
      message: {
        writable: true,
        enumerable: true
      },
      name: {
        enumerable: false
      },
      nodes: {
        enumerable: false
      },
      source: {
        enumerable: false
      },
      positions: {
        enumerable: false
      },
      originalError: {
        enumerable: false
      }
    }); // Include (non-enumerable) stack trace.

    /* c8 ignore start */
    // FIXME: https://github.com/graphql/graphql-js/issues/2317

    if (originalError !== null && originalError !== void 0 && originalError.stack) {
      Object.defineProperty(this, 'stack', {
        value: originalError.stack,
        writable: true,
        configurable: true
      });
    } else if (Error.captureStackTrace) {
      Error.captureStackTrace(this, GraphQLError);
    } else {
      Object.defineProperty(this, 'stack', {
        value: Error().stack,
        writable: true,
        configurable: true
      });
    }
    /* c8 ignore stop */
  }
  get [Symbol.toStringTag]() {
    return 'GraphQLError';
  }
  toString() {
    let output = this.message;
    if (this.nodes) {
      for (const node of this.nodes) {
        if (node.loc) {
          output += '\n\n' + (0, _printLocation.printLocation)(node.loc);
        }
      }
    } else if (this.source && this.locations) {
      for (const location of this.locations) {
        output += '\n\n' + (0, _printLocation.printSourceLocation)(this.source, location);
      }
    }
    return output;
  }
  toJSON() {
    const formattedError = {
      message: this.message
    };
    if (this.locations != null) {
      formattedError.locations = this.locations;
    }
    if (this.path != null) {
      formattedError.path = this.path;
    }
    if (this.extensions != null && Object.keys(this.extensions).length > 0) {
      formattedError.extensions = this.extensions;
    }
    return formattedError;
  }
}
exports.GraphQLError = GraphQLError;
function undefinedIfEmpty(array) {
  return array === undefined || array.length === 0 ? undefined : array;
}
/**
 * See: https://spec.graphql.org/draft/#sec-Errors
 */

/**
 * Prints a GraphQLError to a string, representing useful location information
 * about the error's position in the source.
 *
 * @deprecated Please use `error.toString` instead. Will be removed in v17
 */
function printError(error) {
  return error.toString();
}
/**
 * Given a GraphQLError, format it according to the rules described by the
 * Response Format, Errors section of the GraphQL Specification.
 *
 * @deprecated Please use `error.toJSON` instead. Will be removed in v17
 */

function formatError(error) {
  return error.toJSON();
}

/***/ }),

/***/ "../../../node_modules/graphql/error/index.mjs":
/*!*****************************************************!*\
  !*** ../../../node_modules/graphql/error/index.mjs ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "GraphQLError", ({
  enumerable: true,
  get: function () {
    return _GraphQLError.GraphQLError;
  }
}));
Object.defineProperty(exports, "formatError", ({
  enumerable: true,
  get: function () {
    return _GraphQLError.formatError;
  }
}));
Object.defineProperty(exports, "locatedError", ({
  enumerable: true,
  get: function () {
    return _locatedError.locatedError;
  }
}));
Object.defineProperty(exports, "printError", ({
  enumerable: true,
  get: function () {
    return _GraphQLError.printError;
  }
}));
Object.defineProperty(exports, "syntaxError", ({
  enumerable: true,
  get: function () {
    return _syntaxError.syntaxError;
  }
}));
var _GraphQLError = __webpack_require__(/*! ./GraphQLError.mjs */ "../../../node_modules/graphql/error/GraphQLError.mjs");
var _syntaxError = __webpack_require__(/*! ./syntaxError.mjs */ "../../../node_modules/graphql/error/syntaxError.mjs");
var _locatedError = __webpack_require__(/*! ./locatedError.mjs */ "../../../node_modules/graphql/error/locatedError.mjs");

/***/ }),

/***/ "../../../node_modules/graphql/error/locatedError.mjs":
/*!************************************************************!*\
  !*** ../../../node_modules/graphql/error/locatedError.mjs ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.locatedError = locatedError;
var _toError = __webpack_require__(/*! ../jsutils/toError.mjs */ "../../../node_modules/graphql/jsutils/toError.mjs");
var _GraphQLError = __webpack_require__(/*! ./GraphQLError.mjs */ "../../../node_modules/graphql/error/GraphQLError.mjs");
/**
 * Given an arbitrary value, presumably thrown while attempting to execute a
 * GraphQL operation, produce a new GraphQLError aware of the location in the
 * document responsible for the original Error.
 */

function locatedError(rawOriginalError, nodes, path) {
  var _nodes;
  const originalError = (0, _toError.toError)(rawOriginalError); // Note: this uses a brand-check to support GraphQL errors originating from other contexts.

  if (isLocatedGraphQLError(originalError)) {
    return originalError;
  }
  return new _GraphQLError.GraphQLError(originalError.message, {
    nodes: (_nodes = originalError.nodes) !== null && _nodes !== void 0 ? _nodes : nodes,
    source: originalError.source,
    positions: originalError.positions,
    path,
    originalError
  });
}
function isLocatedGraphQLError(error) {
  return Array.isArray(error.path);
}

/***/ }),

/***/ "../../../node_modules/graphql/error/syntaxError.mjs":
/*!***********************************************************!*\
  !*** ../../../node_modules/graphql/error/syntaxError.mjs ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.syntaxError = syntaxError;
var _GraphQLError = __webpack_require__(/*! ./GraphQLError.mjs */ "../../../node_modules/graphql/error/GraphQLError.mjs");
/**
 * Produces a GraphQLError representing a syntax error, containing useful
 * descriptive information about the syntax error's position in the source.
 */

function syntaxError(source, position, description) {
  return new _GraphQLError.GraphQLError(`Syntax Error: ${description}`, {
    source,
    positions: [position]
  });
}

/***/ }),

/***/ "../../../node_modules/graphql/execution/collectFields.mjs":
/*!*****************************************************************!*\
  !*** ../../../node_modules/graphql/execution/collectFields.mjs ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.collectFields = collectFields;
exports.collectSubfields = collectSubfields;
var _kinds = __webpack_require__(/*! ../language/kinds.mjs */ "../../../node_modules/graphql/language/kinds.mjs");
var _definition = __webpack_require__(/*! ../type/definition.mjs */ "../../../node_modules/graphql/type/definition.mjs");
var _directives = __webpack_require__(/*! ../type/directives.mjs */ "../../../node_modules/graphql/type/directives.mjs");
var _typeFromAST = __webpack_require__(/*! ../utilities/typeFromAST.mjs */ "../../../node_modules/graphql/utilities/typeFromAST.mjs");
var _values = __webpack_require__(/*! ./values.mjs */ "../../../node_modules/graphql/execution/values.mjs");
/**
 * Given a selectionSet, collects all of the fields and returns them.
 *
 * CollectFields requires the "runtime type" of an object. For a field that
 * returns an Interface or Union type, the "runtime type" will be the actual
 * object type returned by that field.
 *
 * @internal
 */

function collectFields(schema, fragments, variableValues, runtimeType, selectionSet) {
  const fields = new Map();
  collectFieldsImpl(schema, fragments, variableValues, runtimeType, selectionSet, fields, new Set());
  return fields;
}
/**
 * Given an array of field nodes, collects all of the subfields of the passed
 * in fields, and returns them at the end.
 *
 * CollectSubFields requires the "return type" of an object. For a field that
 * returns an Interface or Union type, the "return type" will be the actual
 * object type returned by that field.
 *
 * @internal
 */

function collectSubfields(schema, fragments, variableValues, returnType, fieldNodes) {
  const subFieldNodes = new Map();
  const visitedFragmentNames = new Set();
  for (const node of fieldNodes) {
    if (node.selectionSet) {
      collectFieldsImpl(schema, fragments, variableValues, returnType, node.selectionSet, subFieldNodes, visitedFragmentNames);
    }
  }
  return subFieldNodes;
}
function collectFieldsImpl(schema, fragments, variableValues, runtimeType, selectionSet, fields, visitedFragmentNames) {
  for (const selection of selectionSet.selections) {
    switch (selection.kind) {
      case _kinds.Kind.FIELD:
        {
          if (!shouldIncludeNode(variableValues, selection)) {
            continue;
          }
          const name = getFieldEntryKey(selection);
          const fieldList = fields.get(name);
          if (fieldList !== undefined) {
            fieldList.push(selection);
          } else {
            fields.set(name, [selection]);
          }
          break;
        }
      case _kinds.Kind.INLINE_FRAGMENT:
        {
          if (!shouldIncludeNode(variableValues, selection) || !doesFragmentConditionMatch(schema, selection, runtimeType)) {
            continue;
          }
          collectFieldsImpl(schema, fragments, variableValues, runtimeType, selection.selectionSet, fields, visitedFragmentNames);
          break;
        }
      case _kinds.Kind.FRAGMENT_SPREAD:
        {
          const fragName = selection.name.value;
          if (visitedFragmentNames.has(fragName) || !shouldIncludeNode(variableValues, selection)) {
            continue;
          }
          visitedFragmentNames.add(fragName);
          const fragment = fragments[fragName];
          if (!fragment || !doesFragmentConditionMatch(schema, fragment, runtimeType)) {
            continue;
          }
          collectFieldsImpl(schema, fragments, variableValues, runtimeType, fragment.selectionSet, fields, visitedFragmentNames);
          break;
        }
    }
  }
}
/**
 * Determines if a field should be included based on the `@include` and `@skip`
 * directives, where `@skip` has higher precedence than `@include`.
 */

function shouldIncludeNode(variableValues, node) {
  const skip = (0, _values.getDirectiveValues)(_directives.GraphQLSkipDirective, node, variableValues);
  if ((skip === null || skip === void 0 ? void 0 : skip.if) === true) {
    return false;
  }
  const include = (0, _values.getDirectiveValues)(_directives.GraphQLIncludeDirective, node, variableValues);
  if ((include === null || include === void 0 ? void 0 : include.if) === false) {
    return false;
  }
  return true;
}
/**
 * Determines if a fragment is applicable to the given type.
 */

function doesFragmentConditionMatch(schema, fragment, type) {
  const typeConditionNode = fragment.typeCondition;
  if (!typeConditionNode) {
    return true;
  }
  const conditionalType = (0, _typeFromAST.typeFromAST)(schema, typeConditionNode);
  if (conditionalType === type) {
    return true;
  }
  if ((0, _definition.isAbstractType)(conditionalType)) {
    return schema.isSubType(conditionalType, type);
  }
  return false;
}
/**
 * Implements the logic to compute the key of a given field's entry
 */

function getFieldEntryKey(node) {
  return node.alias ? node.alias.value : node.name.value;
}

/***/ }),

/***/ "../../../node_modules/graphql/execution/execute.mjs":
/*!***********************************************************!*\
  !*** ../../../node_modules/graphql/execution/execute.mjs ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.assertValidExecutionArguments = assertValidExecutionArguments;
exports.buildExecutionContext = buildExecutionContext;
exports.buildResolveInfo = buildResolveInfo;
exports.defaultTypeResolver = exports.defaultFieldResolver = void 0;
exports.execute = execute;
exports.executeSync = executeSync;
exports.getFieldDef = getFieldDef;
var _devAssert = __webpack_require__(/*! ../jsutils/devAssert.mjs */ "../../../node_modules/graphql/jsutils/devAssert.mjs");
var _inspect = __webpack_require__(/*! ../jsutils/inspect.mjs */ "../../../node_modules/graphql/jsutils/inspect.mjs");
var _invariant = __webpack_require__(/*! ../jsutils/invariant.mjs */ "../../../node_modules/graphql/jsutils/invariant.mjs");
var _isIterableObject = __webpack_require__(/*! ../jsutils/isIterableObject.mjs */ "../../../node_modules/graphql/jsutils/isIterableObject.mjs");
var _isObjectLike = __webpack_require__(/*! ../jsutils/isObjectLike.mjs */ "../../../node_modules/graphql/jsutils/isObjectLike.mjs");
var _isPromise = __webpack_require__(/*! ../jsutils/isPromise.mjs */ "../../../node_modules/graphql/jsutils/isPromise.mjs");
var _memoize = __webpack_require__(/*! ../jsutils/memoize3.mjs */ "../../../node_modules/graphql/jsutils/memoize3.mjs");
var _Path = __webpack_require__(/*! ../jsutils/Path.mjs */ "../../../node_modules/graphql/jsutils/Path.mjs");
var _promiseForObject = __webpack_require__(/*! ../jsutils/promiseForObject.mjs */ "../../../node_modules/graphql/jsutils/promis