/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.hazelcast;

import com.hazelcast.map.IMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.mybatis.caches.hazelcast.DummyReadWriteLock;

public abstract class AbstractHazelcastCache
implements Cache {
    protected final ReadWriteLock readWriteLock = new DummyReadWriteLock();
    protected final String id;
    protected final IMap<Object, Object> cacheMap;

    protected AbstractHazelcastCache(String id, IMap<Object, Object> imap) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an id");
        }
        if (imap == null) {
            throw new IllegalArgumentException("Cache instances require a cacheMap");
        }
        this.id = id;
        this.cacheMap = imap;
    }

    public void clear() {
        this.cacheMap.clear();
    }

    public String getId() {
        return this.id;
    }

    public Object getObject(Object key) {
        return this.cacheMap.get(key);
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public int getSize() {
        return this.cacheMap.size();
    }

    public void putObject(Object key, Object value) {
        if (value != null) {
            this.cacheMap.set(key, value);
        } else if (this.cacheMap.containsKey(key)) {
            this.cacheMap.remove(key);
        }
    }

    public Object removeObject(Object key) {
        return this.cacheMap.remove(key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cache)) {
            return false;
        }
        Cache otherCache = (Cache)obj;
        return this.id.equals(otherCache.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Hazelcast {" + this.id + "}";
    }
}

