/**
 *    Copyright 2012-2017 the original author or authors.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package org.mybatis.caches.memcached;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Got from https://github.com/raykrueger/hibernate-memcached
 * 
 * @author Ray Krueger
 */
public final class StringUtils {

  private static final char[] DIGITS = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e',
      'f' };

  private StringUtils() {
    // Prevent Instantiation
  }

  public static String sha1Hex(String data) {
    if (data == null) {
      throw new IllegalArgumentException("data must not be null");
    }

    byte[] bytes = digest("SHA1", data);

    return toHexString(bytes);
  }

  private static String toHexString(byte[] bytes) {
    int l = bytes.length;

    char[] out = new char[l << 1];

    for (int i = 0, j = 0; i < l; i++) {
      out[j++] = DIGITS[(0xF0 & bytes[i]) >>> 4];
      out[j++] = DIGITS[0x0F & bytes[i]];
    }

    return new String(out);
  }

  private static byte[] digest(String algorithm, String data) {
    MessageDigest digest;
    try {
      digest = MessageDigest.getInstance(algorithm);
    } catch (NoSuchAlgorithmException e) {
      throw new RuntimeException(e);
    }

    return digest.digest(data.getBytes());
  }

}
