/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.LocalCacheScope;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.Alias;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.guice.AbstractMyBatisModule;
import org.mybatis.guice.Preconditions;
import org.mybatis.guice.binder.AliasBinder;
import org.mybatis.guice.binder.TypeHandlerBinder;
import org.mybatis.guice.configuration.ConfigurationProvider;
import org.mybatis.guice.configuration.Mappers;
import org.mybatis.guice.configuration.MappingTypeHandlers;
import org.mybatis.guice.configuration.TypeAliases;
import org.mybatis.guice.environment.EnvironmentProvider;
import org.mybatis.guice.session.SqlSessionFactoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MyBatisModule
extends AbstractMyBatisModule {
    private Class<? extends ObjectFactory> objectFactoryType = DefaultObjectFactory.class;
    private MapBinder<String, Class<?>> aliases;
    private MapBinder<Class<?>, TypeHandler<?>> handlers;
    private Multibinder<TypeHandler<?>> mappingTypeHandlers;
    private Multibinder<Interceptor> interceptors;
    private Multibinder<Class<?>> mappers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void internalConfigure() {
        Preconditions.checkState(this.aliases == null, "Re-entry is not allowed.");
        Preconditions.checkState(this.handlers == null, "Re-entry is not allowed.");
        Preconditions.checkState(this.interceptors == null, "Re-entry is not allowed.");
        Preconditions.checkState(this.mappers == null, "Re-entry is not allowed.");
        this.aliases = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<String>(){}, (TypeLiteral)new TypeLiteral<Class<?>>(){}, TypeAliases.class);
        this.handlers = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<TypeHandler<?>>(){});
        this.interceptors = Multibinder.newSetBinder((Binder)this.binder(), Interceptor.class);
        this.mappingTypeHandlers = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<TypeHandler<?>>(){}, MappingTypeHandlers.class);
        this.mappers = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<?>>(){}, Mappers.class);
        try {
            this.initialize();
            Object var2_1 = null;
            this.aliases = null;
            this.handlers = null;
            this.interceptors = null;
            this.mappers = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.aliases = null;
            this.handlers = null;
            this.interceptors = null;
            this.mappers = null;
            throw throwable;
        }
        this.bind(Environment.class).toProvider(EnvironmentProvider.class).in(Scopes.SINGLETON);
        this.bind(Configuration.class).toProvider(ConfigurationProvider.class).in(Scopes.SINGLETON);
        this.bind(SqlSessionFactory.class).toProvider(SqlSessionFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(ObjectFactory.class).to(this.objectFactoryType).in(Scopes.SINGLETON);
    }

    protected final void environmentId(String environmentId) {
        Preconditions.checkArgument(environmentId != null, "Parameter 'environmentId' must be not null");
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"mybatis.environment.id")).to(environmentId);
    }

    protected final void lazyLoadingEnabled(boolean lazyLoadingEnabled) {
        this.bindBoolean("mybatis.configuration.lazyLoadingEnabled", lazyLoadingEnabled);
    }

    protected final void aggressiveLazyLoading(boolean aggressiveLazyLoading) {
        this.bindBoolean("mybatis.configuration.aggressiveLazyLoading", aggressiveLazyLoading);
    }

    protected final void multipleResultSetsEnabled(boolean multipleResultSetsEnabled) {
        this.bindBoolean("mybatis.configuration.multipleResultSetsEnabled", multipleResultSetsEnabled);
    }

    protected final void useGeneratedKeys(boolean useGeneratedKeys) {
        this.bindBoolean("mybatis.configuration.useGeneratedKeys", useGeneratedKeys);
    }

    protected final void useColumnLabel(boolean useColumnLabel) {
        this.bindBoolean("mybatis.configuration.useColumnLabel", useColumnLabel);
    }

    protected final void useCacheEnabled(boolean useCacheEnabled) {
        this.bindBoolean("mybatis.configuration.cacheEnabled", useCacheEnabled);
    }

    protected final void failFast(boolean failFast) {
        this.bindBoolean("mybatis.configuration.failFast", failFast);
    }

    protected final void mapUnderscoreToCamelCase(boolean mapUnderscoreToCamelCase) {
        this.bindBoolean("mybatis.configuration.mapUnderscoreToCamelCase", mapUnderscoreToCamelCase);
    }

    private final void bindBoolean(String name, boolean value) {
        this.bindConstant().annotatedWith((Annotation)Names.named((String)name)).to(value);
    }

    protected final void executorType(ExecutorType executorType) {
        Preconditions.checkArgument(executorType != null, "Parameter 'executorType' must be not null");
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"mybatis.configuration.defaultExecutorType")).to((Enum)executorType);
    }

    protected final void localCacheScope(LocalCacheScope localeCacheScope) {
        Preconditions.checkArgument(localeCacheScope != null, "Parameter 'localCacheScope' must be not null");
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"mybatis.configuration.localCacheScope")).to((Enum)localeCacheScope);
    }

    protected final void autoMappingBehavior(AutoMappingBehavior autoMappingBehavior) {
        Preconditions.checkArgument(autoMappingBehavior != null, "Parameter 'autoMappingBehavior' must be not null");
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"mybatis.configuration.autoMappingBehavior")).to((Enum)autoMappingBehavior);
    }

    protected final void bindDataSourceProviderType(Class<? extends javax.inject.Provider<DataSource>> dataSourceProviderType) {
        Preconditions.checkArgument(dataSourceProviderType != null, "Parameter 'dataSourceProviderType' must be not null");
        this.bind(DataSource.class).toProvider(dataSourceProviderType).in(Scopes.SINGLETON);
    }

    protected final void bindDataSourceProvider(javax.inject.Provider<DataSource> dataSourceProvider) {
        Preconditions.checkArgument(dataSourceProvider != null, "Parameter 'dataSourceProvider' must be not null");
        this.bindDataSourceProvider((Provider<DataSource>)Providers.guicify(dataSourceProvider));
    }

    protected final void bindDataSourceProvider(Provider<DataSource> dataSourceProvider) {
        Preconditions.checkArgument(dataSourceProvider != null, "Parameter 'dataSourceProvider' must be not null");
        this.bind(DataSource.class).toProvider(dataSourceProvider).in(Scopes.SINGLETON);
    }

    protected final void bindTransactionFactoryType(Class<? extends TransactionFactory> transactionFactoryType) {
        Preconditions.checkArgument(transactionFactoryType != null, "Parameter 'transactionFactoryType' must be not null");
        this.bind(TransactionFactory.class).to(transactionFactoryType).in(Scopes.SINGLETON);
    }

    protected final void bindTransactionFactory(javax.inject.Provider<TransactionFactory> transactionFactoryProvider) {
        Preconditions.checkArgument(transactionFactoryProvider != null, "Parameter 'transactionFactoryProvider' must be not null");
        this.bindTransactionFactory((Provider<TransactionFactory>)Providers.guicify(transactionFactoryProvider));
    }

    protected final void bindTransactionFactory(Provider<TransactionFactory> transactionFactoryProvider) {
        Preconditions.checkArgument(transactionFactoryProvider != null, "Parameter 'transactionFactoryProvider' must be not null");
        this.bind(TransactionFactory.class).toProvider(transactionFactoryProvider).in(Scopes.SINGLETON);
    }

    protected final void bindObjectFactoryType(Class<? extends ObjectFactory> objectFactoryType) {
        Preconditions.checkArgument(objectFactoryType != null, "Parameter 'objectFactoryType' must be not null");
        this.objectFactoryType = objectFactoryType;
    }

    protected final AliasBinder addAlias(final String alias) {
        Preconditions.checkArgument(alias != null && alias.length() > 0, "Empty or null 'alias' is not valid");
        return new AliasBinder(){

            @Override
            public void to(Class<?> clazz) {
                Preconditions.checkArgument(clazz != null, "Null type not valid for alias '%s'", alias);
                MyBatisModule.this.aliases.addBinding((Object)alias).toInstance(clazz);
            }
        };
    }

    protected final void addSimpleAlias(Class<?> type) {
        Preconditions.checkArgument(type != null, "Parameter 'type' must be not null");
        String alias = type.getSimpleName();
        Alias annotation = type.getAnnotation(Alias.class);
        if (annotation != null) {
            alias = annotation.value();
        }
        this.addAlias(alias).to(type);
    }

    protected final void addSimpleAliases(Collection<Class<?>> types) {
        Preconditions.checkArgument(types != null, "Parameter 'types' must be not null");
        for (Class<?> type : types) {
            this.addSimpleAlias(type);
        }
    }

    protected final void addSimpleAliases(String packageName, ResolverUtil.Test test) {
        this.addSimpleAliases(MyBatisModule.getClasses(test, packageName));
    }

    protected final void addSimpleAliases(String packageName) {
        this.addSimpleAliases(MyBatisModule.getClasses(packageName));
    }

    protected final <T> TypeHandlerBinder<T> handleType(final Class<T> type) {
        Preconditions.checkArgument(type != null, "Parameter 'type' must be not null");
        return new TypeHandlerBinder<T>(){

            @Override
            public void with(Class<? extends TypeHandler<? extends T>> handler) {
                Preconditions.checkArgument(handler != null, "TypeHandler must not be null for '%s'", type.getName());
                MyBatisModule.this.handlers.addBinding((Object)type).to(handler).in(Scopes.SINGLETON);
            }
        };
    }

    protected final void addTypeHandlerClass(Class<? extends TypeHandler<?>> handlerClass) {
        Preconditions.checkArgument(handlerClass != null, "Parameter 'handlerClass' must not be null");
        this.mappingTypeHandlers.addBinding().to(handlerClass).in(Scopes.SINGLETON);
    }

    protected final void addTypeHandlersClasses(Collection<Class<? extends TypeHandler<?>>> handlersClasses) {
        Preconditions.checkArgument(handlersClasses != null, "Parameter 'handlersClasses' must not be null");
        for (Class<TypeHandler<?>> clazz : handlersClasses) {
            this.mappingTypeHandlers.addBinding().to(clazz).in(Scopes.SINGLETON);
        }
    }

    protected final void addTypeHandlerClasses(String packageName) {
        Preconditions.checkArgument(packageName != null, "Parameter 'packageName' must not be null");
        this.addTypeHandlersClasses(new ResolverUtil().find((ResolverUtil.Test)new ResolverUtil.IsA(TypeHandler.class), packageName).getClasses());
    }

    protected final void addInterceptorClass(Class<? extends Interceptor> interceptorClass) {
        Preconditions.checkArgument(interceptorClass != null, "Parameter 'interceptorClass' must not be null");
        this.interceptors.addBinding().to(interceptorClass).in(Scopes.SINGLETON);
    }

    protected final void addInterceptorsClasses(Collection<Class<? extends Interceptor>> interceptorsClasses) {
        Preconditions.checkArgument(interceptorsClasses != null, "Parameter 'interceptorsClasses' must not be null");
        for (Class<? extends Interceptor> interceptorClass : interceptorsClasses) {
            this.addInterceptorClass(interceptorClass);
        }
    }

    protected final void addInterceptorsClasses(String packageName) {
        Preconditions.checkArgument(packageName != null, "Parameter 'packageName' must not be null");
        this.addInterceptorsClasses(new ResolverUtil().find((ResolverUtil.Test)new ResolverUtil.IsA(Interceptor.class), packageName).getClasses());
    }

    protected final void addMapperClass(Class<?> mapperClass) {
        Preconditions.checkArgument(mapperClass != null, "Parameter 'mapperClass' must not be null");
        this.mappers.addBinding().toInstance(mapperClass);
        this.bindMapper(mapperClass);
    }

    protected final void addMapperClasses(Collection<Class<?>> mapperClasses) {
        Preconditions.checkArgument(mapperClasses != null, "Parameter 'mapperClasses' must not be null");
        for (Class<?> mapperClass : mapperClasses) {
            this.addMapperClass(mapperClass);
        }
    }

    protected final void addMapperClasses(String packageName) {
        this.addMapperClasses(MyBatisModule.getClasses(packageName));
    }

    protected final void addMapperClasses(String packageName, ResolverUtil.Test test) {
        this.addMapperClasses(MyBatisModule.getClasses(test, packageName));
    }

    private static Set<Class<?>> getClasses(String packageName) {
        return MyBatisModule.getClasses((ResolverUtil.Test)new ResolverUtil.IsA(Object.class), packageName);
    }

    private static Set<Class<?>> getClasses(ResolverUtil.Test test, String packageName) {
        Preconditions.checkArgument(test != null, "Parameter 'test' must not be null");
        Preconditions.checkArgument(packageName != null, "Parameter 'packageName' must not be null");
        return new ResolverUtil().find(test, packageName).getClasses();
    }
}

