/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.builtin;

import com.google.inject.Inject;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.jndi.JndiDataSourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JndiDataSourceProvider
implements Provider<DataSource> {
    private final Properties properties = new Properties();

    @Inject(optional=true)
    public void setInitialContext(@Named(value="jndi.initialContext") String initialContext) {
        this.properties.setProperty("initial_context", initialContext);
    }

    @Inject(optional=true)
    public void setDataSource(@Named(value="jndi.dataSource") String dataSource) {
        this.properties.setProperty("data_source", dataSource);
    }

    public DataSource get() {
        JndiDataSourceFactory factory = new JndiDataSourceFactory();
        factory.setProperties(this.properties);
        return factory.getDataSource();
    }
}

