/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.dbcp;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DriverAdapterCPDSProvider
implements Provider<ConnectionPoolDataSource> {
    private final DriverAdapterCPDS adapter = new DriverAdapterCPDS();

    @Inject
    public DriverAdapterCPDSProvider(@Named(value="JDBC.driver") String driver, @Named(value="JDBC.url") String url) {
        try {
            this.adapter.setDriver(driver);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Driver '" + driver + "' not found in the classpath", e);
        }
        this.adapter.setUrl(url);
    }

    @com.google.inject.Inject(optional=true)
    public void setUser(@Named(value="JDBC.username") String username) {
        this.adapter.setUser(username);
    }

    @com.google.inject.Inject(optional=true)
    public void setPassword(@Named(value="JDBC.password") String password) {
        this.adapter.setPassword(password);
    }

    @com.google.inject.Inject(optional=true)
    public void setDescription(@Named(value="DBCP.description") String description) {
        this.adapter.setDescription(description);
    }

    @com.google.inject.Inject(optional=true)
    public void setLoginTimeout(@Named(value="JDBC.loginTimeout") int seconds) {
        this.adapter.setLoginTimeout(seconds);
    }

    @com.google.inject.Inject(optional=true)
    public void setMaxActive(@Named(value="DBCP.maxActive") int maxActive) {
        this.adapter.setMaxActive(maxActive);
    }

    @com.google.inject.Inject(optional=true)
    public void setMaxIdle(@Named(value="DBCP.maxIdle") int maxIdle) {
        this.adapter.setMaxIdle(maxIdle);
    }

    @com.google.inject.Inject(optional=true)
    public void setMaxPreparedStatements(@Named(value="DBCP.maxOpenPreparedStatements") int maxPreparedStatements) {
        this.adapter.setMaxPreparedStatements(maxPreparedStatements);
    }

    @com.google.inject.Inject(optional=true)
    public void setMinEvictableIdleTimeMillis(@Named(value="DBCP.minEvictableIdleTimeMillis") int minEvictableIdleTimeMillis) {
        this.adapter.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    @com.google.inject.Inject(optional=true)
    public void setNumTestsPerEvictionRun(@Named(value="DBCP.numTestsPerEvictionRun") int numTestsPerEvictionRun) {
        this.adapter.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    @com.google.inject.Inject(optional=true)
    public void setPoolPreparedStatements(@Named(value="DBCP.poolPreparedStatements") boolean poolPreparedStatements) {
        this.adapter.setPoolPreparedStatements(poolPreparedStatements);
    }

    @com.google.inject.Inject(optional=true)
    public void setTimeBetweenEvictionRunsMillis(@Named(value="DBCP.timeBetweenEvictionRunsMillis") int timeBetweenEvictionRunsMillis) {
        this.adapter.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public ConnectionPoolDataSource get() {
        return this.adapter;
    }
}

