/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.helper;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.util.Providers;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.inject.Provider;
import org.mybatis.guice.datasource.helper.KeyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Formatter
implements Provider<String> {
    private static final String VAR_BEGIN = "$";
    private static final String PIPE_SEPARATOR = "|";
    private final List<Provider<String>> appenders = new ArrayList<Provider<String>>();
    private final List<KeyResolver> resolvers = new ArrayList<KeyResolver>();

    public Formatter(String pattern) {
        int pos;
        int prev = 0;
        while ((pos = pattern.indexOf(VAR_BEGIN, prev)) >= 0) {
            if (pos > 0) {
                this.appenders.add((Provider<String>)Providers.of((Object)pattern.substring(prev, pos)));
            }
            if (pos == pattern.length() - 1) {
                this.appenders.add((Provider<String>)Providers.of((Object)VAR_BEGIN));
                prev = pos + 1;
                continue;
            }
            if (pattern.charAt(pos + 1) != '{') {
                if (pattern.charAt(pos + 1) == '$') {
                    this.appenders.add((Provider<String>)Providers.of((Object)VAR_BEGIN));
                    prev = pos + 2;
                    continue;
                }
                this.appenders.add((Provider<String>)Providers.of((Object)pattern.substring(pos, pos + 2)));
                prev = pos + 2;
                continue;
            }
            int endName = pattern.indexOf(125, pos);
            if (endName < 0) {
                throw new IllegalArgumentException("Syntax error in property: " + pattern);
            }
            StringTokenizer keyTokenizer = new StringTokenizer(pattern.substring(pos + 2, endName), PIPE_SEPARATOR);
            String key = keyTokenizer.nextToken();
            String defaultValue = null;
            if (keyTokenizer.hasMoreTokens()) {
                defaultValue = keyTokenizer.nextToken();
            }
            KeyResolver resolver = new KeyResolver(key, defaultValue);
            this.appenders.add(resolver);
            this.resolvers.add(resolver);
            prev = endName + 1;
        }
        if (prev < pattern.length()) {
            this.appenders.add((Provider<String>)Providers.of((Object)pattern.substring(prev)));
        }
    }

    @Inject
    public void setInjector(Injector injector) {
        for (KeyResolver resolver : this.resolvers) {
            resolver.setInjector(injector);
        }
    }

    public String get() {
        StringBuilder buffer = new StringBuilder();
        for (Provider<String> appender : this.appenders) {
            buffer.append((String)appender.get());
        }
        return buffer.toString();
    }

    public String toString() {
        return this.appenders.toString();
    }
}

