/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.transactional;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionManager;
import org.mybatis.guice.transactional.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransactionalMethodInterceptor
implements MethodInterceptor {
    private static final Class<?>[] CAUSE_TYPES = new Class[]{Throwable.class};
    private static final Class<?>[] MESSAGE_CAUSE_TYPES = new Class[]{String.class, Throwable.class};
    private final Log log = LogFactory.getLog(this.getClass());
    @Inject
    private SqlSessionManager sqlSessionManager;

    public void setSqlSessionManager(SqlSessionManager sqlSessionManager) {
        this.sqlSessionManager = sqlSessionManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        String debugPrefix;
        block24: {
            block25: {
                boolean isSessionInherited;
                Method interceptedMethod = invocation.getMethod();
                Transactional transactional = interceptedMethod.getAnnotation(Transactional.class);
                debugPrefix = null;
                if (this.log.isDebugEnabled()) {
                    debugPrefix = String.format("[Intercepted method: %s]", interceptedMethod.toGenericString());
                }
                if (isSessionInherited = this.sqlSessionManager.isManagedSessionStarted()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(String.format("%s - SqlSession already set for thread: %s", debugPrefix, Thread.currentThread().getId()));
                    }
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(String.format("%s - SqlSession not set for thread: %s, creating a new one", debugPrefix, Thread.currentThread().getId()));
                    }
                    this.sqlSessionManager.startManagedSession(transactional.executorType(), transactional.isolation().getTransactionIsolationLevel());
                }
                object = null;
                try {
                    try {
                        object = invocation.proceed();
                        if (!isSessionInherited && !transactional.rollbackOnly()) {
                            this.sqlSessionManager.commit(transactional.force());
                        }
                    }
                    catch (Throwable t) {
                        Object[] initargsType;
                        Object[] initargs;
                        String errorMessage;
                        this.sqlSessionManager.rollback(transactional.force());
                        for (Class<?> exceptionClass : interceptedMethod.getExceptionTypes()) {
                            if (!exceptionClass.isAssignableFrom(t.getClass())) continue;
                            throw t;
                        }
                        if (transactional.rethrowExceptionsAs().isAssignableFrom(t.getClass())) {
                            throw t;
                        }
                        if (transactional.exceptionMessage().length() != 0) {
                            errorMessage = String.format(transactional.exceptionMessage(), invocation.getArguments());
                            initargs = new Object[]{errorMessage, t};
                            initargsType = MESSAGE_CAUSE_TYPES;
                        } else {
                            initargs = new Object[]{t};
                            initargsType = CAUSE_TYPES;
                        }
                        Constructor<? extends Throwable> exceptionConstructor = TransactionalMethodInterceptor.getMatchingConstructor(transactional.rethrowExceptionsAs(), initargsType);
                        Throwable rethrowEx = null;
                        if (exceptionConstructor == null) {
                            errorMessage = String.format("Impossible to re-throw '%s', it needs the constructor with %s or %s argument(s).", transactional.rethrowExceptionsAs().getName(), Arrays.toString(CAUSE_TYPES), Arrays.toString(MESSAGE_CAUSE_TYPES));
                            this.log.error(errorMessage);
                            rethrowEx = new RuntimeException(errorMessage);
                            throw rethrowEx;
                        }
                        try {
                            rethrowEx = exceptionConstructor.newInstance(initargs);
                            throw rethrowEx;
                        }
                        catch (Exception e) {
                            errorMessage = String.format("Impossible to re-throw '%s', it needs the constructor with %s argument(s).", transactional.rethrowExceptionsAs().getName(), Arrays.toString(initargsType));
                            this.log.error(errorMessage, (Throwable)e);
                            rethrowEx = new RuntimeException(errorMessage, e);
                            throw rethrowEx;
                        }
                    }
                    Object var15_7 = null;
                    if (isSessionInherited) break block24;
                    if (!transactional.rollbackOnly()) break block25;
                }
                catch (Throwable throwable) {
                    Object var15_8 = null;
                    if (isSessionInherited) {
                        if (!this.log.isDebugEnabled()) throw throwable;
                        this.log.debug(String.format("%s - SqlSession of thread: %s is inherited, skipped close operation", debugPrefix, Thread.currentThread().getId()));
                        throw throwable;
                    }
                    if (transactional.rollbackOnly()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(debugPrefix + " - SqlSession of thread: " + Thread.currentThread().getId() + " was in rollbackOnly mode, rolling it back");
                        }
                        this.sqlSessionManager.rollback(true);
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(String.format("%s - SqlSession of thread: %s terminated its life-cycle, closing it", debugPrefix, Thread.currentThread().getId()));
                    }
                    this.sqlSessionManager.close();
                    throw throwable;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug(debugPrefix + " - SqlSession of thread: " + Thread.currentThread().getId() + " was in rollbackOnly mode, rolling it back");
                }
                this.sqlSessionManager.rollback(true);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("%s - SqlSession of thread: %s terminated its life-cycle, closing it", debugPrefix, Thread.currentThread().getId()));
            }
            this.sqlSessionManager.close();
            return object;
        }
        if (!this.log.isDebugEnabled()) return object;
        this.log.debug(String.format("%s - SqlSession of thread: %s is inherited, skipped close operation", debugPrefix, Thread.currentThread().getId()));
        return object;
    }

    private static <E extends Throwable> Constructor<E> getMatchingConstructor(Class<E> type, Class<?>[] argumentsType) {
        for (Class<E> currentType = type; Object.class != currentType; currentType = currentType.getSuperclass()) {
            for (Constructor<?> constructor : currentType.getConstructors()) {
                if (!Arrays.equals(argumentsType, constructor.getParameterTypes())) continue;
                return constructor;
            }
        }
        return null;
    }
}

