/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.builtin;

import com.google.inject.Inject;
import java.sql.SQLException;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;

public final class PooledDataSourceProvider
implements Provider<DataSource> {
    private final PooledDataSource dataSource;

    @javax.inject.Inject
    public PooledDataSourceProvider(@Named(value="JDBC.driver") String driver, @Named(value="JDBC.url") String url, @Named(value="JDBC.driverClassLoader") ClassLoader driverClassLoader) {
        this.dataSource = new PooledDataSource(driverClassLoader, driver, url, null, null);
    }

    @Inject(optional=true)
    public void setUser(@Named(value="JDBC.username") String username) {
        this.dataSource.setUsername(username);
    }

    @Inject(optional=true)
    public void setPassword(@Named(value="JDBC.password") String password) {
        this.dataSource.setPassword(password);
    }

    @Inject(optional=true)
    public void setAutoCommit(@Named(value="JDBC.autoCommit") boolean autoCommit) {
        this.dataSource.setDefaultAutoCommit(autoCommit);
    }

    @Inject(optional=true)
    public void setLoginTimeout(@Named(value="JDBC.loginTimeout") int loginTimeout) {
        try {
            this.dataSource.setLoginTimeout(loginTimeout);
        }
        catch (SQLException e) {
            throw new RuntimeException("Impossible to set login timeout '" + loginTimeout + "' to Unpooled Data Source", e);
        }
    }

    @Inject(optional=true)
    public void setDriverProperties(@Named(value="JDBC.driverProperties") Properties driverProperties) {
        this.dataSource.setDriverProperties(driverProperties);
    }

    @Inject(optional=true)
    public void setMaximumActiveConnections(@Named(value="mybatis.pooled.maximumActiveConnections") int maximumActiveConnections) {
        this.dataSource.setPoolMaximumActiveConnections(maximumActiveConnections);
    }

    @Inject(optional=true)
    public void setMaximumCheckoutTime(@Named(value="mybatis.pooled.maximumCheckoutTime") int maximumCheckoutTime) {
        this.dataSource.setPoolMaximumCheckoutTime(maximumCheckoutTime);
    }

    @Inject(optional=true)
    public void setMaximumIdleConnections(@Named(value="mybatis.pooled.maximumIdleConnections") int maximumIdleConnections) {
        this.dataSource.setPoolMaximumIdleConnections(maximumIdleConnections);
    }

    @Inject(optional=true)
    public void setPingConnectionsNotUsedFor(@Named(value="mybatis.pooled.pingConnectionsNotUsedFor") int pingConnectionsNotUsedFor) {
        this.dataSource.setPoolPingConnectionsNotUsedFor(pingConnectionsNotUsedFor);
    }

    @Inject(optional=true)
    public void setPingEnabled(@Named(value="mybatis.pooled.pingEnabled") boolean pingEnabled) {
        this.dataSource.setPoolPingEnabled(pingEnabled);
    }

    @Inject(optional=true)
    public void setPingEnabled(@Named(value="mybatis.pooled.pingQuery") String pingQuery) {
        this.dataSource.setPoolPingQuery(pingQuery);
    }

    @Inject(optional=true)
    public void setTimeToWait(@Named(value="mybatis.pooled.timeToWait") int timeToWait) {
        this.dataSource.setPoolTimeToWait(timeToWait);
    }

    public DataSource get() {
        return this.dataSource;
    }
}

