/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.type;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.Constructor;
import javax.inject.Provider;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;

public final class TypeHandlerProvider<TH extends TypeHandler<? extends T>, T>
implements Provider<TH> {
    private final Class<TH> typeHandlerType;
    private final Class<T> handledType;
    @Inject
    private Injector injector;

    public TypeHandlerProvider(Class<TH> typeHandlerType, Class<T> handledType) {
        this.typeHandlerType = typeHandlerType;
        this.handledType = handledType;
    }

    public TH get() {
        TypeHandler instance = null;
        if (this.handledType != null) {
            try {
                Constructor<TH> c = this.typeHandlerType.getConstructor(Class.class);
                instance = (TypeHandler)c.newInstance(this.handledType);
                this.injector.injectMembers((Object)instance);
            }
            catch (NoSuchMethodException c) {
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + this.typeHandlerType, (Throwable)e);
            }
        }
        if (instance == null) {
            try {
                instance = (TypeHandler)this.typeHandlerType.newInstance();
                this.injector.injectMembers((Object)instance);
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + this.typeHandlerType, (Throwable)e);
            }
        }
        return (TH)instance;
    }
}

