/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice;

import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import jakarta.inject.Provider;
import jakarta.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.mybatis.guice.MyBatisModule;
import org.mybatis.guice.Preconditions;
import org.mybatis.guice.transactional.Transactional;
import org.mybatis.guice.transactional.TransactionalMethodInterceptor;
import org.mybatis.guice.transactional.TxTransactionalMethodInterceptor;
import org.mybatis.guice.transactional.XASqlSessionManagerProvider;

public abstract class MyBatisJtaModule
extends MyBatisModule {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private TransactionManager transactionManager;
    private Class<? extends Provider<? extends XAResource>> xaResourceProvider = XASqlSessionManagerProvider.class;

    public MyBatisJtaModule() {
    }

    public MyBatisJtaModule(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    protected void bindTransactionInterceptors() {
        TransactionManager manager = this.getTransactionManager();
        if (manager == null) {
            this.log.debug("bind default transaction interceptors");
            super.bindTransactionInterceptors();
        } else {
            this.log.debug("bind XA transaction interceptors");
            TransactionalMethodInterceptor interceptor = new TransactionalMethodInterceptor();
            this.requestInjection(interceptor);
            TxTransactionalMethodInterceptor interceptorTx = new TxTransactionalMethodInterceptor();
            this.requestInjection(interceptorTx);
            this.bind(XAResource.class).toProvider(this.xaResourceProvider);
            this.bind(TransactionManager.class).toInstance((Object)manager);
            this.bindInterceptor(Matchers.any(), Matchers.not((Matcher)DECLARED_BY_OBJECT).and(Matchers.annotatedWith(Transactional.class)), new MethodInterceptor[]{interceptorTx, interceptor});
            this.bindInterceptor(Matchers.annotatedWith(Transactional.class), Matchers.not((Matcher)DECLARED_BY_OBJECT).and(Matchers.not((Matcher)Matchers.annotatedWith(Transactional.class))), new MethodInterceptor[]{interceptorTx, interceptor});
        }
    }

    protected TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    protected void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected void bindDefaultTransactionProvider() {
        Class factoryType = this.getTransactionManager() == null ? JdbcTransactionFactory.class : ManagedTransactionFactory.class;
        this.bindTransactionFactoryType(factoryType);
    }

    protected void bindXAResourceProvider(Class<? extends Provider<? extends XAResource>> xaResourceProvider) {
        Preconditions.checkArgument(xaResourceProvider != null, "Parameter 'xaResourceProvider' must be not null");
        this.xaResourceProvider = xaResourceProvider;
    }

    protected static class ProviderImpl<T>
    implements Provider<T> {
        private T wrapper;

        public ProviderImpl(T wrapper) {
            this.wrapper = wrapper;
        }

        public T get() {
            return this.wrapper;
        }
    }
}

