/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.builtin;

import com.google.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.jndi.JndiDataSourceFactory;

public final class JndiDataSourceProvider
implements Provider<DataSource> {
    private final Properties properties = new Properties();

    @jakarta.inject.Inject
    public JndiDataSourceProvider(@Named(value="jndi.dataSource") String dataSource) {
        this.properties.setProperty("data_source", dataSource);
    }

    @Inject(optional=true)
    public void setInitialContext(@Named(value="jndi.initialContext") String initialContext) {
        this.properties.setProperty("initial_context", initialContext);
    }

    @Inject(optional=true)
    public void setEnvInitialContextFactory(@Named(value="java.naming.factory.initial") String initialContextFactory) {
        this.properties.setProperty("env.java.naming.factory.initial", initialContextFactory);
    }

    @Inject(optional=true)
    public void setEnvProviderURL(@Named(value="java.naming.provider.url") String providerUrl) {
        this.properties.setProperty("env.java.naming.provider.url", providerUrl);
    }

    public DataSource get() {
        JndiDataSourceFactory factory = new JndiDataSourceFactory();
        factory.setProperties(this.properties);
        return factory.getDataSource();
    }
}

