/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.c3p0;

import com.google.inject.Inject;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.beans.PropertyVetoException;
import java.util.Properties;
import javax.sql.DataSource;

public final class C3p0DataSourceProvider
implements Provider<DataSource> {
    private final ComboPooledDataSource dataSource = new ComboPooledDataSource();
    private String username;
    private String password;

    @jakarta.inject.Inject
    public C3p0DataSourceProvider(@Named(value="JDBC.driver") String driver, @Named(value="JDBC.url") String url) {
        try {
            this.dataSource.setDriverClass(driver);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException("Impossible to initialize C3P0 Data Source with driver class '" + driver + "', see nested exceptions", e);
        }
        this.dataSource.setJdbcUrl(url);
    }

    @Inject(optional=true)
    public void setUser(@Named(value="JDBC.username") String username) {
        this.username = username;
    }

    @Inject(optional=true)
    public void setPassword(@Named(value="JDBC.password") String password) {
        this.password = password;
    }

    @Inject(optional=true)
    public void setAcquireIncrement(@Named(value="c3p0.acquireIncrement") int acquireIncrement) {
        this.dataSource.setAcquireIncrement(acquireIncrement);
    }

    @Inject(optional=true)
    public void setAcquireRetryAttempts(@Named(value="c3p0.acquireRetryAttempts") int acquireRetryAttempts) {
        this.dataSource.setAcquireRetryAttempts(acquireRetryAttempts);
    }

    @Inject(optional=true)
    public void setAcquireRetryDelay(@Named(value="c3p0.acquireRetryDelay") int acquireRetryDelay) {
        this.dataSource.setAcquireRetryDelay(acquireRetryDelay);
    }

    @Inject(optional=true)
    public void setAutoCommitOnClose(@Named(value="JDBC.autoCommit") boolean autoCommit) {
        this.dataSource.setAutoCommitOnClose(autoCommit);
    }

    @Inject(optional=true)
    public void setDriverProperties(@Named(value="JDBC.driverProperties") Properties driverProperties) {
        this.dataSource.setProperties(driverProperties);
    }

    @Inject(optional=true)
    public void setAautomaticTestTable(@Named(value="c3p0.automaticTestTable") String automaticTestTable) {
        this.dataSource.setAutomaticTestTable(automaticTestTable);
    }

    @Inject(optional=true)
    public void setBreakAfterAcquireFailure(@Named(value="c3p0.breakAfterAcquireFailure") boolean breakAfterAcquireFailure) {
        this.dataSource.setBreakAfterAcquireFailure(breakAfterAcquireFailure);
    }

    @Inject(optional=true)
    public void setCheckoutTimeout(@Named(value="c3p0.checkoutTimeout") int checkoutTimeout) {
        this.dataSource.setCheckoutTimeout(checkoutTimeout);
    }

    @Inject(optional=true)
    public void setConnectionCustomizerClassName(@Named(value="c3p0.connectionCustomizerClassName") String connectionCustomizerClassName) {
        this.dataSource.setConnectionCustomizerClassName(connectionCustomizerClassName);
    }

    @Inject(optional=true)
    public void setConnectionTesterClassName(@Named(value="c3p0.connectionTesterClassName") String connectionTesterClassName) {
        try {
            this.dataSource.setConnectionTesterClassName(connectionTesterClassName);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException("Impossible to set C3P0 Data Source connection tester class name '" + connectionTesterClassName + "', see nested exceptions", e);
        }
    }

    @Inject(optional=true)
    public void setIdleConnectionTestPeriod(@Named(value="c3p0.idleConnectionTestPeriod") int idleConnectionTestPeriod) {
        this.dataSource.setIdleConnectionTestPeriod(idleConnectionTestPeriod);
    }

    @Inject(optional=true)
    public void setInitialPoolSize(@Named(value="c3p0.initialPoolSize") int initialPoolSize) {
        this.dataSource.setInitialPoolSize(initialPoolSize);
    }

    @Inject(optional=true)
    public void setMaxAdministrativeTaskTime(@Named(value="c3p0.maxAdministrativeTaskTime") int maxAdministrativeTaskTime) {
        this.dataSource.setMaxAdministrativeTaskTime(maxAdministrativeTaskTime);
    }

    @Inject(optional=true)
    public void setMaxConnectionAge(@Named(value="c3p0.maxConnectionAge") int maxConnectionAge) {
        this.dataSource.setMaxConnectionAge(maxConnectionAge);
    }

    @Inject(optional=true)
    public void setMaxIdleTime(@Named(value="c3p0.maxIdleTime") int maxIdleTime) {
        this.dataSource.setMaxIdleTime(maxIdleTime);
    }

    @Inject(optional=true)
    public void setMaxIdleTimeExcessConnections(@Named(value="c3p0.maxIdleTimeExcessConnections") int maxIdleTimeExcessConnections) {
        this.dataSource.setMaxIdleTimeExcessConnections(maxIdleTimeExcessConnections);
    }

    @Inject(optional=true)
    public void setMaxPoolSize(@Named(value="c3p0.maxPoolSize") int maxPoolSize) {
        this.dataSource.setMaxPoolSize(maxPoolSize);
    }

    @Inject(optional=true)
    public void setMaxStatements(@Named(value="c3p0.maxStatements") int maxStatements) {
        this.dataSource.setMaxStatements(maxStatements);
    }

    @Inject(optional=true)
    public void setMaxStatementsPerConnection(@Named(value="c3p0.maxStatementsPerConnection") int maxStatementsPerConnection) {
        this.dataSource.setMaxStatementsPerConnection(maxStatementsPerConnection);
    }

    @Inject(optional=true)
    public void setMinPoolSize(@Named(value="c3p0.minPoolSize") int minPoolSize) {
        this.dataSource.setMinPoolSize(minPoolSize);
    }

    @Inject(optional=true)
    public void setPreferredTestQuery(@Named(value="c3p0.preferredTestQuery") String preferredTestQuery) {
        this.dataSource.setPreferredTestQuery(preferredTestQuery);
    }

    @Inject(optional=true)
    public void setPropertyCycle(@Named(value="c3p0.propertyCycle") int propertyCycle) {
        this.dataSource.setPropertyCycle(propertyCycle);
    }

    @Inject(optional=true)
    public void setTestConnectionOnCheckin(@Named(value="c3p0.testConnectionOnCheckin") boolean testConnectionOnCheckin) {
        this.dataSource.setTestConnectionOnCheckin(testConnectionOnCheckin);
    }

    @Inject(optional=true)
    public void setTestConnectionOnCheckout(@Named(value="c3p0.testConnectionOnCheckout") boolean testConnectionOnCheckout) {
        this.dataSource.setTestConnectionOnCheckout(testConnectionOnCheckout);
    }

    @Inject(optional=true)
    public void setUnreturnedConnectionTimeout(@Named(value="c3p0.unreturnedConnectionTimeout") int unreturnedConnectionTimeout) {
        this.dataSource.setUnreturnedConnectionTimeout(unreturnedConnectionTimeout);
    }

    @Inject(optional=true)
    public void setUsesTraditionalReflectiveProxies(@Named(value="c3p0.usesTraditionalReflectiveProxies") boolean usesTraditionalReflectiveProxies) {
        this.dataSource.setUsesTraditionalReflectiveProxies(usesTraditionalReflectiveProxies);
    }

    public DataSource get() {
        if (this.username != null) {
            this.dataSource.setUser(this.username);
        }
        if (this.password != null) {
            this.dataSource.setPassword(this.password);
        }
        return this.dataSource;
    }
}

