/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.dbcp;

import com.google.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Map;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import org.mybatis.guice.datasource.dbcp.PerUserDefaultAutoCommit;
import org.mybatis.guice.datasource.dbcp.PerUserDefaultReadOnly;
import org.mybatis.guice.datasource.dbcp.PerUserDefaultTransactionIsolation;
import org.mybatis.guice.datasource.dbcp.PerUserMaxIdle;
import org.mybatis.guice.datasource.dbcp.PerUserMaxTotal;
import org.mybatis.guice.datasource.dbcp.PerUserMaxWaitMillis;

public final class PerUserPoolDataSourceProvider
implements Provider<DataSource> {
    private final PerUserPoolDataSource dataSource = new PerUserPoolDataSource();

    @Inject(optional=true)
    public void setConnectionPoolDataSource(ConnectionPoolDataSource cpds) {
        this.dataSource.setConnectionPoolDataSource(cpds);
    }

    @Inject(optional=true)
    public void setDataSourceName(@Named(value="DBCP.name") String name) {
        this.dataSource.setDataSourceName(name);
    }

    @Inject(optional=true)
    public void setDefaultAutoCommit(@Named(value="JDBC.autoCommit") boolean autoCommit) {
        this.dataSource.setDefaultAutoCommit(Boolean.valueOf(autoCommit));
    }

    @Inject(optional=true)
    public void setDefaultReadOnly(@Named(value="DBCP.defaultReadOnly") boolean defaultReadOnly) {
        this.dataSource.setDefaultReadOnly(Boolean.valueOf(defaultReadOnly));
    }

    @Inject(optional=true)
    public void setDefaultTransactionIsolation(@Named(value="DBCP.defaultTransactionIsolation") int defaultTransactionIsolation) {
        this.dataSource.setDefaultTransactionIsolation(defaultTransactionIsolation);
    }

    @Inject(optional=true)
    public void setDescription(@Named(value="DBCP.description") String description) {
        this.dataSource.setDescription(description);
    }

    @Inject(optional=true)
    public void setJndiEnvironment(@Named(value="DBCP.jndi.key") String key, @Named(value="DBCP.jndi.value") String value) {
        this.dataSource.setJndiEnvironment(key, value);
    }

    @Inject(optional=true)
    public void setLoginTimeout(@Named(value="JDBC.loginTimeout") int loginTimeout) {
        this.dataSource.setLoginTimeout(loginTimeout);
    }

    @Inject(optional=true)
    public void setDefaultMinEvictableIdleTimeMillis(@Named(value="DBCP.defaultMinEvictableIdleTimeMillis") int defaultMinEvictableIdleTimeMillis) {
        this.dataSource.setDefaultMinEvictableIdleTimeMillis((long)defaultMinEvictableIdleTimeMillis);
    }

    @Inject(optional=true)
    public void setDefaultNumTestsPerEvictionRun(@Named(value="DBCP.defaultNumTestsPerEvictionRun") int defaultNumTestsPerEvictionRun) {
        this.dataSource.setDefaultNumTestsPerEvictionRun(defaultNumTestsPerEvictionRun);
    }

    @Inject(optional=true)
    public void setRollbackAfterValidation(@Named(value="DBCP.rollbackAfterValidation") boolean rollbackAfterValidation) {
        this.dataSource.setRollbackAfterValidation(rollbackAfterValidation);
    }

    @Inject(optional=true)
    public void setDefaultTestOnBorrow(@Named(value="DBCP.defaultTestOnBorrow") boolean defaultTestOnBorrow) {
        this.dataSource.setDefaultTestOnBorrow(defaultTestOnBorrow);
    }

    @Inject(optional=true)
    public void setDefaultTestOnReturn(@Named(value="DBCP.defaultTestOnReturn") boolean defaultTestOnReturn) {
        this.dataSource.setDefaultTestOnReturn(defaultTestOnReturn);
    }

    @Inject(optional=true)
    public void setDefaultTestWhileIdle(@Named(value="DBCP.defaultTestWhileIdle") boolean defaultTestWhileIdle) {
        this.dataSource.setDefaultTestWhileIdle(defaultTestWhileIdle);
    }

    @Inject(optional=true)
    public void setDefaultTimeBetweenEvictionRunsMillis(@Named(value="DBCP.defaultTimeBetweenEvictionRunsMillis") int defaultTimeBetweenEvictionRunsMillis) {
        this.dataSource.setDefaultTimeBetweenEvictionRunsMillis((long)defaultTimeBetweenEvictionRunsMillis);
    }

    @Inject(optional=true)
    public void setValidationQuery(@Named(value="DBCP.validationQuery") String validationQuery) {
        this.dataSource.setValidationQuery(validationQuery);
    }

    @Inject(optional=true)
    public void setDefaultMaxTotal(@Named(value="DBCP.defaultMaxTotal") int defaultMaxTotal) {
        this.dataSource.setDefaultMaxTotal(defaultMaxTotal);
    }

    @Inject(optional=true)
    public void setDefaultMaxIdle(@Named(value="DBCP.defaultMaxIdle") int defaultMaxIdle) {
        this.dataSource.setDefaultMaxIdle(defaultMaxIdle);
    }

    @Inject(optional=true)
    public void setDefaultMaxWaitMillis(@Named(value="DBCP.defaultMaxWaitMillis") int defaultMaxWaitMillis) {
        this.dataSource.setDefaultMaxWaitMillis((long)defaultMaxWaitMillis);
    }

    @Inject(optional=true)
    public void setPerUserDefaultAutoCommit(@PerUserDefaultAutoCommit Map<String, Boolean> perUserDefaultAutoCommit) {
        for (Map.Entry<String, Boolean> entry : perUserDefaultAutoCommit.entrySet()) {
            this.dataSource.setPerUserDefaultAutoCommit(entry.getKey(), entry.getValue());
        }
    }

    @Inject(optional=true)
    public void setPerUserDefaultReadOnly(@PerUserDefaultReadOnly Map<String, Boolean> perUserDefaultReadOnly) {
        for (Map.Entry<String, Boolean> entry : perUserDefaultReadOnly.entrySet()) {
            this.dataSource.setPerUserDefaultReadOnly(entry.getKey(), entry.getValue());
        }
    }

    @Inject(optional=true)
    public void setPerUserDefaultTransactionIsolation(@PerUserDefaultTransactionIsolation Map<String, Integer> perUserDefaultTransactionIsolation) {
        for (Map.Entry<String, Integer> entry : perUserDefaultTransactionIsolation.entrySet()) {
            this.dataSource.setPerUserDefaultTransactionIsolation(entry.getKey(), entry.getValue());
        }
    }

    @Inject(optional=true)
    public void setPerUserMaxTotal(@PerUserMaxTotal Map<String, Integer> perUserMaxTotal) {
        for (Map.Entry<String, Integer> entry : perUserMaxTotal.entrySet()) {
            this.dataSource.setPerUserMaxTotal(entry.getKey(), entry.getValue());
        }
    }

    @Inject(optional=true)
    public void setPerUserMaxIdle(@PerUserMaxIdle Map<String, Integer> perUserMaxIdle) {
        for (Map.Entry<String, Integer> entry : perUserMaxIdle.entrySet()) {
            this.dataSource.setPerUserMaxIdle(entry.getKey(), entry.getValue());
        }
    }

    @Inject(optional=true)
    public void setPerUserMaxWaitMillis(@PerUserMaxWaitMillis Map<String, Long> perUserMaxWaitMillis) {
        for (Map.Entry<String, Long> entry : perUserMaxWaitMillis.entrySet()) {
            this.dataSource.setPerUserMaxWaitMillis(entry.getKey(), entry.getValue());
        }
    }

    public DataSource get() {
        return this.dataSource;
    }
}

