/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.helper;

import com.google.inject.Injector;
import com.google.inject.util.Providers;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.mybatis.guice.datasource.helper.KeyResolver;

public final class JdbcUrlAntFormatter
implements Provider<String> {
    private static final String VAR_BEGIN = "$";
    private static final String PIPE_SEPARATOR = "|";
    private final List<Provider<String>> appenders = new ArrayList<Provider<String>>();
    private final List<KeyResolver> resolvers = new ArrayList<KeyResolver>();

    public JdbcUrlAntFormatter(String pattern) {
        this.initializeAppender(pattern);
    }

    private void initializeAppender(String pattern) {
        int currentIndex;
        int previousIndex = 0;
        while ((currentIndex = pattern.indexOf(VAR_BEGIN, previousIndex)) >= 0) {
            this.processPatternSubstring(pattern, previousIndex, currentIndex);
            previousIndex = this.updatePrevPosition(pattern, currentIndex);
        }
        this.appendRemainingPatternSubstring(pattern, previousIndex);
    }

    private void processPatternSubstring(String pattern, int previousIndex, int currentIndex) {
        if (currentIndex > 0) {
            this.appenders.add((Provider<String>)Providers.of((Object)pattern.substring(previousIndex, currentIndex)));
        }
        if (currentIndex == pattern.length() - 1) {
            this.appenders.add((Provider<String>)Providers.of((Object)VAR_BEGIN));
        } else if (pattern.charAt(currentIndex + 1) != '{') {
            this.handleNonCurlyBracePattern(pattern, currentIndex);
        } else {
            this.handleCurlyBracePattern(pattern, currentIndex);
        }
    }

    private void handleNonCurlyBracePattern(String pattern, int currentIndex) {
        if (pattern.charAt(currentIndex + 1) == '$') {
            this.appenders.add((Provider<String>)Providers.of((Object)VAR_BEGIN));
        } else {
            this.appenders.add((Provider<String>)Providers.of((Object)pattern.substring(currentIndex, currentIndex + 2)));
        }
    }

    private void handleCurlyBracePattern(String pattern, int currentIndex) {
        int endName = pattern.indexOf(125, currentIndex);
        if (endName < 0) {
            throw new IllegalArgumentException("Syntax error in property: " + pattern);
        }
        this.processKeyResolver(pattern, currentIndex, endName);
    }

    private void processKeyResolver(String pattern, int startPos, int endPos) {
        StringTokenizer keyTokenizer = new StringTokenizer(pattern.substring(startPos + 2, endPos), PIPE_SEPARATOR);
        String key = keyTokenizer.nextToken();
        String defaultValue = keyTokenizer.hasMoreTokens() ? keyTokenizer.nextToken() : null;
        KeyResolver resolver = new KeyResolver(key, defaultValue);
        this.appenders.add(resolver);
        this.resolvers.add(resolver);
    }

    private int updatePrevPosition(String pattern, int currentIndex) {
        if (pattern.charAt(currentIndex + 1) == '{') {
            return pattern.indexOf(125, currentIndex) + 1;
        }
        return currentIndex + (pattern.charAt(currentIndex + 1) == '$' ? 2 : 1);
    }

    private void appendRemainingPatternSubstring(String pattern, int previousIndex) {
        if (previousIndex < pattern.length()) {
            this.appenders.add((Provider<String>)Providers.of((Object)pattern.substring(previousIndex)));
        }
    }

    @Inject
    public void setInjector(Injector injector) {
        for (KeyResolver resolver : this.resolvers) {
            resolver.setInjector(injector);
        }
    }

    public String get() {
        StringBuilder buffer = new StringBuilder();
        for (Provider<String> appender : this.appenders) {
            buffer.append((String)appender.get());
        }
        return buffer.toString();
    }

    public String toString() {
        return this.appenders.toString();
    }
}

