/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.hikaricp;

import com.google.inject.Inject;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.sql.DataSource;

public final class HikariCPProvider
implements Provider<DataSource> {
    private final HikariConfig configuration = new HikariConfig();
    private Integer loginTimeout;

    public DataSource get() {
        HikariDataSource dataSource = new HikariDataSource(this.configuration);
        if (this.loginTimeout != null) {
            try {
                dataSource.setLoginTimeout(this.loginTimeout.intValue());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set login timeout '" + this.loginTimeout + "' for the HikariCP datasource", e);
            }
        }
        return dataSource;
    }

    @Inject(optional=true)
    public void setAllowPoolSuspension(@Named(value="hikaricp.allowPoolSuspension") boolean allowPoolSuspension) {
        this.configuration.setAllowPoolSuspension(allowPoolSuspension);
    }

    @Inject(optional=true)
    public void setAutoCommit(@Named(value="hikaricp.autoCommit") boolean autoCommit) {
        this.configuration.setAutoCommit(autoCommit);
    }

    @Inject(optional=true)
    public void setCatalog(@Named(value="hikaricp.catalog") String catalog) {
        this.configuration.setCatalog(catalog);
    }

    @Inject(optional=true)
    public void setConnectionInitSql(@Named(value="hikaricp.connectionInitSql") String connectionInitSql) {
        this.configuration.setConnectionInitSql(connectionInitSql);
    }

    @Inject(optional=true)
    public void setConnectionTestQuery(@Named(value="hikaricp.connectionTestQuery") String connectionTestQuery) {
        this.configuration.setConnectionTestQuery(connectionTestQuery);
    }

    @Inject(optional=true)
    public void setConnectionTimeout(@Named(value="hikaricp.connectionTimeoutMs") long connectionTimeoutMs) {
        this.configuration.setConnectionTimeout(connectionTimeoutMs);
    }

    @Inject(optional=true)
    public void setDriverClassName(@Named(value="hikaricp.driverClassName") String driverClassName) {
        this.configuration.setDriverClassName(driverClassName);
    }

    @Inject(optional=true)
    public void setHealthCheckProperties(@Named(value="hikaricp.healthCheckProperties") Properties healthCheckProperties) {
        this.configuration.setHealthCheckProperties(healthCheckProperties);
    }

    @Inject(optional=true)
    public void setHealthCheckRegistry(@Named(value="hikaricp.healthCheckRegistry") Object healthCheckRegistry) {
        this.configuration.setHealthCheckRegistry(healthCheckRegistry);
    }

    @Inject(optional=true)
    public void setIdleTimeout(@Named(value="hikaricp.idleTimeoutMs") long idleTimeoutMs) {
        this.configuration.setIdleTimeout(idleTimeoutMs);
    }

    @Inject(optional=true)
    public void setInitializationFailTimeout(@Named(value="hikaricp.initializationFailTimeout") long initializationFailTimeout) {
        this.configuration.setInitializationFailTimeout(initializationFailTimeout);
    }

    @Inject(optional=true)
    public void setIsolateInternalQueries(@Named(value="hikaricp.isolateInternalQueries") boolean isolateInternalQueries) {
        this.configuration.setIsolateInternalQueries(isolateInternalQueries);
    }

    @jakarta.inject.Inject
    public void setJdbcUrl(@Named(value="JDBC.url") String jdbcUrl) {
        this.configuration.setJdbcUrl(jdbcUrl);
    }

    @Inject(optional=true)
    public void setLeakDetectionThreshold(@Named(value="hikaricp.leakDetectionThresholdMs") long leakDetectionThresholdMs) {
        this.configuration.setLeakDetectionThreshold(leakDetectionThresholdMs);
    }

    @Inject(optional=true)
    public void setLoginTimeout(@Named(value="JDBC.loginTimeout") int loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    @Inject(optional=true)
    public void setMaxLifetime(@Named(value="hikaricp.maxLifetimeMs") long maxLifetimeMs) {
        this.configuration.setMaxLifetime(maxLifetimeMs);
    }

    @Inject(optional=true)
    public void setMaximumPoolSize(@Named(value="hikaricp.maxPoolSize") int maxPoolSize) {
        this.configuration.setMaximumPoolSize(maxPoolSize);
    }

    @Inject(optional=true)
    public void setMetricRegistry(@Named(value="hikaricp.metricRegistry") Object metricRegistry) {
        this.configuration.setMetricRegistry(metricRegistry);
    }

    @Inject(optional=true)
    public void setMetricsTrackerFactory(@Named(value="hikaricp.metricsTrackerFactory") MetricsTrackerFactory metricsTrackerFactory) {
        this.configuration.setMetricsTrackerFactory(metricsTrackerFactory);
    }

    @Inject(optional=true)
    public void setMinimumIdle(@Named(value="hikaricp.minimumIdle") int minimumIdle) {
        this.configuration.setMinimumIdle(minimumIdle);
    }

    @jakarta.inject.Inject
    public void setPassword(@Named(value="JDBC.password") String password) {
        this.configuration.setPassword(password);
    }

    @Inject(optional=true)
    public void setPoolName(@Named(value="hikaricp.poolName") String poolName) {
        this.configuration.setPoolName(poolName);
    }

    @Inject(optional=true)
    public void setReadOnly(@Named(value="hikaricp.readOnly") boolean readOnly) {
        this.configuration.setReadOnly(readOnly);
    }

    @Inject(optional=true)
    public void setRegisterMbeans(@Named(value="hikaricp.registerMbeans") boolean registerMbeans) {
        this.configuration.setRegisterMbeans(registerMbeans);
    }

    @Inject(optional=true)
    public void setScheduledExecutor(@Named(value="hikaricp.scheduledExecutorService") ScheduledExecutorService scheduledExecutorService) {
        this.configuration.setScheduledExecutor(scheduledExecutorService);
    }

    @Inject(optional=true)
    public void setSchema(@Named(value="hikaricp.schema") String schema) {
        this.configuration.setSchema(schema);
    }

    @Inject(optional=true)
    public void setThreadFactory(@Named(value="hikaricp.threadFactory") ThreadFactory threadFactory) {
        this.configuration.setThreadFactory(threadFactory);
    }

    @Inject(optional=true)
    public void setTransactionIsolation(@Named(value="hikaricp.transactionIsolation") String transactionIsolation) {
        this.configuration.setTransactionIsolation(transactionIsolation);
    }

    @jakarta.inject.Inject
    public void setUsername(@Named(value="JDBC.username") String username) {
        this.configuration.setUsername(username);
    }

    @Inject(optional=true)
    public void setValidationTimeout(@Named(value="hikaricp.validationTimeoutMs") long validationTimeoutMs) {
        this.configuration.setValidationTimeout(validationTimeoutMs);
    }
}

