/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.provision;

import com.google.inject.Binder;
import com.google.inject.MembersInjector;
import com.google.inject.spi.ProvisionListener;
import jakarta.inject.Provider;
import org.mybatis.guice.configuration.ConfigurationSettingListener;
import org.mybatis.guice.configuration.settings.ConfigurationSetting;
import org.mybatis.guice.configuration.settings.MapperConfigurationSetting;

public final class ConfigurationProviderProvisionListener
implements ProvisionListener {
    private final ConfigurationProviderProvisionAction action;

    ConfigurationProviderProvisionListener(ConfigurationProviderProvisionAction action) {
        this.action = action;
    }

    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
        ConfigurationSettingListener configurationSettingListener = (ConfigurationSettingListener)provision.provision();
        this.action.perform(configurationSettingListener);
    }

    public static <P extends Provider<? extends ConfigurationSetting>> ConfigurationProviderProvisionListener create(final P configurationSettingProvider, Binder binder) {
        final MembersInjector membersInjector = binder.getMembersInjector(configurationSettingProvider.getClass());
        return new ConfigurationProviderProvisionListener(new ConfigurationProviderProvisionAction(){

            @Override
            public void perform(ConfigurationSettingListener configurationSettingListener) {
                membersInjector.injectMembers((Object)configurationSettingProvider);
                configurationSettingListener.addConfigurationSetting((ConfigurationSetting)configurationSettingProvider.get());
            }
        });
    }

    public static ConfigurationProviderProvisionListener create(final ConfigurationSetting configurationSetting) {
        return new ConfigurationProviderProvisionListener(new ConfigurationProviderProvisionAction(){

            @Override
            public void perform(ConfigurationSettingListener configurationSettingListener) {
                configurationSettingListener.addConfigurationSetting(configurationSetting);
            }
        });
    }

    public static ConfigurationProviderProvisionListener create(final MapperConfigurationSetting mapperConfigurationSetting) {
        return new ConfigurationProviderProvisionListener(new ConfigurationProviderProvisionAction(){

            @Override
            public void perform(ConfigurationSettingListener configurationSettingListener) {
                configurationSettingListener.addMapperConfigurationSetting(mapperConfigurationSetting);
            }
        });
    }

    private static interface ConfigurationProviderProvisionAction {
        public void perform(ConfigurationSettingListener var1);
    }
}

