/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.transactional;

import jakarta.inject.Inject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionManager;
import org.mybatis.guice.transactional.Transactional;

public final class TransactionalMethodInterceptor
implements MethodInterceptor {
    private static final Class<?>[] CAUSE_TYPES = new Class[]{Throwable.class};
    private static final Class<?>[] MESSAGE_CAUSE_TYPES = new Class[]{String.class, Throwable.class};
    private final Log log = LogFactory.getLog(this.getClass());
    @Inject
    private SqlSessionManager sqlSessionManager;

    public void setSqlSessionManager(SqlSessionManager sqlSessionManager) {
        this.sqlSessionManager = sqlSessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        block29: {
            boolean needsRollback;
            boolean isSessionInherited;
            String debugPrefix;
            Transactional transactional;
            block26: {
                block27: {
                    Method interceptedMethod = invocation.getMethod();
                    transactional = interceptedMethod.getAnnotation(Transactional.class);
                    if (transactional == null) {
                        transactional = interceptedMethod.getDeclaringClass().getAnnotation(Transactional.class);
                    }
                    debugPrefix = null;
                    if (this.log.isDebugEnabled()) {
                        debugPrefix = String.format("[Intercepted method: %s]", interceptedMethod.toGenericString());
                    }
                    if (isSessionInherited = this.sqlSessionManager.isManagedSessionStarted()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(String.format("%s - SqlSession already set for thread: %s", debugPrefix, Thread.currentThread().getId()));
                        }
                    } else {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(String.format("%s - SqlSession not set for thread: %s, creating a new one", debugPrefix, Thread.currentThread().getId()));
                        }
                        this.sqlSessionManager.startManagedSession(transactional.executorType(), transactional.isolation().getTransactionIsolationLevel());
                    }
                    object = null;
                    needsRollback = transactional.rollbackOnly();
                    object = invocation.proceed();
                    if (isSessionInherited) break block26;
                    try {
                        if (needsRollback) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(debugPrefix + " - SqlSession of thread: " + Thread.currentThread().getId() + " rolling back");
                            }
                            this.sqlSessionManager.rollback(true);
                            break block27;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(debugPrefix + " - SqlSession of thread: " + Thread.currentThread().getId() + " committing");
                        }
                        this.sqlSessionManager.commit(transactional.force());
                    }
                    catch (Throwable throwable) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(String.format("%s - SqlSession of thread: %s terminated its life-cycle, closing it", debugPrefix, Thread.currentThread().getId()));
                        }
                        this.sqlSessionManager.close();
                        throw throwable;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("%s - SqlSession of thread: %s terminated its life-cycle, closing it", debugPrefix, Thread.currentThread().getId()));
                }
                this.sqlSessionManager.close();
                break block29;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("%s - SqlSession of thread: %s is inherited, skipped close operation", debugPrefix, Thread.currentThread().getId()));
            }
            break block29;
            catch (Throwable t) {
                try {
                    needsRollback = true;
                    throw this.convertThrowableIfNeeded(invocation, transactional, t);
                }
                catch (Throwable throwable) {
                    block31: {
                        block30: {
                            block28: {
                                if (isSessionInherited) break block30;
                                try {
                                    if (needsRollback) {
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug(debugPrefix + " - SqlSession of thread: " + Thread.currentThread().getId() + " rolling back");
                                        }
                                        this.sqlSessionManager.rollback(true);
                                        break block28;
                                    }
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug(debugPrefix + " - SqlSession of thread: " + Thread.currentThread().getId() + " committing");
                                    }
                                    this.sqlSessionManager.commit(transactional.force());
                                }
                                catch (Throwable throwable2) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug(String.format("%s - SqlSession of thread: %s terminated its life-cycle, closing it", debugPrefix, Thread.currentThread().getId()));
                                    }
                                    this.sqlSessionManager.close();
                                    throw throwable2;
                                }
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(String.format("%s - SqlSession of thread: %s terminated its life-cycle, closing it", debugPrefix, Thread.currentThread().getId()));
                            }
                            this.sqlSessionManager.close();
                            break block31;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(String.format("%s - SqlSession of thread: %s is inherited, skipped close operation", debugPrefix, Thread.currentThread().getId()));
                        }
                    }
                    throw throwable;
                }
            }
        }
        return object;
    }

    private Throwable convertThrowableIfNeeded(MethodInvocation invocation, Transactional transactional, Throwable t) {
        Object[] initargsType;
        Object[] initargs;
        String errorMessage;
        Method interceptedMethod = invocation.getMethod();
        for (Class<?> exceptionClass : interceptedMethod.getExceptionTypes()) {
            if (!exceptionClass.isAssignableFrom(t.getClass())) continue;
            return t;
        }
        if (transactional.rethrowExceptionsAs().isAssignableFrom(t.getClass())) {
            return t;
        }
        if (transactional.exceptionMessage().length() != 0) {
            errorMessage = String.format(transactional.exceptionMessage(), invocation.getArguments());
            initargs = new Object[]{errorMessage, t};
            initargsType = MESSAGE_CAUSE_TYPES;
        } else {
            initargs = new Object[]{t};
            initargsType = CAUSE_TYPES;
        }
        Constructor<? extends Throwable> exceptionConstructor = TransactionalMethodInterceptor.getMatchingConstructor(transactional.rethrowExceptionsAs(), initargsType);
        Throwable rethrowEx = null;
        if (exceptionConstructor != null) {
            try {
                rethrowEx = exceptionConstructor.newInstance(initargs);
            }
            catch (Exception e) {
                errorMessage = String.format("Impossible to re-throw '%s', it needs the constructor with %s argument(s).", transactional.rethrowExceptionsAs().getName(), Arrays.toString(initargsType));
                this.log.error(errorMessage, (Throwable)e);
                rethrowEx = new RuntimeException(errorMessage, e);
            }
        } else {
            errorMessage = String.format("Impossible to re-throw '%s', it needs the constructor with %s or %s argument(s).", transactional.rethrowExceptionsAs().getName(), Arrays.toString(CAUSE_TYPES), Arrays.toString(MESSAGE_CAUSE_TYPES));
            this.log.error(errorMessage);
            rethrowEx = new RuntimeException(errorMessage);
        }
        return rethrowEx;
    }

    private static <E extends Throwable> Constructor<E> getMatchingConstructor(Class<E> type, Class<?>[] argumentsType) {
        for (Class<E> currentType = type; Object.class != currentType; currentType = currentType.getSuperclass()) {
            for (Constructor<?> constructor : currentType.getConstructors()) {
                if (!Arrays.equals(argumentsType, constructor.getParameterTypes())) continue;
                return constructor;
            }
        }
        return null;
    }
}

