/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.type;

import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;

public final class TypeHandlerProvider<TH extends TypeHandler<? extends T>, T>
implements Provider<TH> {
    private final TypeLiteral<TH> typeHandlerTypeLiteral;
    private final Class<T> handledType;
    @Inject
    private Injector injector;

    public TypeHandlerProvider(Class<TH> typeHandlerType, Class<T> handledType) {
        this.typeHandlerTypeLiteral = TypeLiteral.get(typeHandlerType);
        this.handledType = handledType;
    }

    public TypeHandlerProvider(TypeLiteral<TH> typeHandlerType, Class<T> handledType) {
        this.typeHandlerTypeLiteral = typeHandlerType;
        this.handledType = handledType;
    }

    TypeHandlerProvider(Injector injector, Class<TH> typeHandlerType, Class<T> handledType) {
        this(typeHandlerType, handledType);
        this.injector = injector;
    }

    TypeHandlerProvider(Injector injector, TypeLiteral<TH> typeHandlerType, Class<T> handledType) {
        this(typeHandlerType, handledType);
        this.injector = injector;
    }

    public TH get() {
        TypeHandler instance = null;
        if (this.handledType != null) {
            try {
                Constructor c = this.typeHandlerTypeLiteral.getRawType().getConstructor(Class.class);
                instance = (TypeHandler)c.newInstance(this.handledType);
                this.injector.injectMembers((Object)instance);
            }
            catch (NoSuchMethodException c) {
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + String.valueOf(this.typeHandlerTypeLiteral.getType()), (Throwable)e);
            }
        }
        if (instance == null) {
            try {
                instance = (TypeHandler)this.typeHandlerTypeLiteral.getRawType().newInstance();
                this.injector.injectMembers((Object)instance);
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + String.valueOf(this.typeHandlerTypeLiteral.getType()), (Throwable)e);
            }
        }
        return (TH)instance;
    }

    public int hashCode() {
        return Objects.hash(this.typeHandlerTypeLiteral, this.handledType);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeHandlerProvider other = (TypeHandlerProvider)obj;
        return Objects.equals(this.typeHandlerTypeLiteral, other.typeHandlerTypeLiteral) && Objects.equals(this.handledType, other.handledType);
    }
}

