/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration;

import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.commands.Command;
import org.apache.ibatis.migration.commands.Commands;
import org.apache.ibatis.migration.options.Options;
import org.apache.ibatis.migration.options.OptionsParser;
import org.apache.ibatis.migration.options.SelectedOptions;
import org.apache.ibatis.migration.utils.Util;

public class CommandLine {
    private final PrintStream console = System.out;
    private final String[] args;

    public CommandLine(String[] args) {
        this.args = args;
    }

    public void execute() {
        SelectedOptions selectedOptions = OptionsParser.parse(this.args);
        try {
            if (!this.validOptions(selectedOptions) || selectedOptions.needsHelp()) {
                this.printUsage();
            } else {
                this.runCommand(selectedOptions);
            }
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (this.hasColor(selectedOptions)) {
                this.console.printf("\u001b[0;31m\nERROR: %s%n", errorMessage + "\u001b[0m");
            } else {
                this.console.printf("\nERROR: %s%n", errorMessage);
            }
            if (selectedOptions.isTrace()) {
                e.printStackTrace();
            }
            System.exit(1);
        }
    }

    private void runCommand(SelectedOptions selectedOptions) {
        String commandString = selectedOptions.getCommand();
        this.console.printf("------------------------------------------------------------------------%n", new Object[0]);
        this.console.printf("-- MyBatis Migrations - %s%n", commandString);
        this.console.printf("------------------------------------------------------------------------%n", new Object[0]);
        long start = System.currentTimeMillis();
        boolean exceptionCaught = false;
        try {
            Command command = Commands.resolveCommand(commandString.toUpperCase(), selectedOptions);
            command.execute(selectedOptions.getParams());
            this.console.printf("------------------------------------------------------------------------%n", new Object[0]);
        }
        catch (Throwable t) {
            try {
                exceptionCaught = true;
                if (t instanceof MigrationException) {
                    throw (MigrationException)t;
                }
                throw new MigrationException(t);
            }
            catch (Throwable throwable) {
                this.console.printf("------------------------------------------------------------------------%n", new Object[0]);
                if (this.hasColor(selectedOptions)) {
                    this.console.printf("-- MyBatis Migrations %s%s%s%n", exceptionCaught ? "\u001b[0;31m" : "\u001b[0;32m", exceptionCaught ? "FAILURE" : "SUCCESS", "\u001b[0m");
                } else {
                    this.console.printf("-- MyBatis Migrations %s%n", exceptionCaught ? "FAILURE" : "SUCCESS");
                }
                this.console.printf("-- Total time: %ss%n", (System.currentTimeMillis() - start) / 1000L);
                this.console.printf("-- Finished at: %s%n", new Date());
                this.printMemoryUsage();
                this.console.printf("------------------------------------------------------------------------%n", new Object[0]);
                throw throwable;
            }
        }
        if (this.hasColor(selectedOptions)) {
            this.console.printf("-- MyBatis Migrations %s%s%s%n", exceptionCaught ? "\u001b[0;31m" : "\u001b[0;32m", exceptionCaught ? "FAILURE" : "SUCCESS", "\u001b[0m");
        } else {
            this.console.printf("-- MyBatis Migrations %s%n", exceptionCaught ? "FAILURE" : "SUCCESS");
        }
        this.console.printf("-- Total time: %ss%n", (System.currentTimeMillis() - start) / 1000L);
        this.console.printf("-- Finished at: %s%n", new Date());
        this.printMemoryUsage();
        this.console.printf("------------------------------------------------------------------------%n", new Object[0]);
    }

    protected boolean hasColor(SelectedOptions selectedOptions) {
        return selectedOptions.hasColor() || Util.getPropertyOptionAsBoolean(Options.COLOR.toString().toLowerCase());
    }

    private void printMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        int megaUnit = 0x100000;
        long usedMemory = (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
        long totalMemory = runtime.totalMemory() / 0x100000L;
        this.console.printf("-- Final Memory: %sM/%sM%n", usedMemory, totalMemory);
    }

    private boolean validOptions(SelectedOptions selectedOptions) {
        if (!selectedOptions.needsHelp() && selectedOptions.getCommand() == null) {
            this.console.printf("No command specified.%n", new Object[0]);
            return false;
        }
        return this.validBasePath(selectedOptions.getPaths().getBasePath());
    }

    private boolean validBasePath(File basePath) {
        boolean validDirectory;
        boolean bl = validDirectory = basePath.exists() && basePath.isDirectory();
        if (!validDirectory) {
            this.console.printf("Migrations path must be a directory: %s%n", basePath.getAbsolutePath());
        }
        return validDirectory;
    }

    private void printUsage() {
        this.console.printf("%nUsage: migrate command [parameter] [--path=<directory>] [--env=<environment>] [--template=<path to custom template>]%n%n", new Object[0]);
        this.console.printf("--path=<directory>   Path to repository.  Default current working directory.%n", new Object[0]);
        this.console.printf("--env=<environment>  Environment to configure. Default environment is 'development'.%n", new Object[0]);
        this.console.printf("--template=<template>  Path to custom template for creating new sql scripts.%n", new Object[0]);
        this.console.printf("--force              Forces script to continue even if SQL errors are encountered.%n", new Object[0]);
        this.console.printf("--help               Displays this usage message.%n", new Object[0]);
        this.console.printf("--trace              Shows additional error details (if any).%n", new Object[0]);
        this.console.printf("--quiet              Suppresses output.%n", new Object[0]);
        this.console.printf("--color              Colorize output.%n", new Object[0]);
        this.console.printf("%n", new Object[0]);
        this.console.printf("Commands:%n", new Object[0]);
        this.console.printf("  info               Display build version informations.%n", new Object[0]);
        this.console.printf("  init               Creates (if necessary) and initializes a migration path.%n", new Object[0]);
        this.console.printf("  bootstrap          Runs the bootstrap SQL script (see scripts/bootstrap.sql for more).%n", new Object[0]);
        this.console.printf("  new <description>  Creates a new migration with the provided description.%n", new Object[0]);
        this.console.printf("  up [n]             Run unapplied migrations, ALL by default, or 'n' specified.%n", new Object[0]);
        this.console.printf("  down [n]           Undoes migrations applied to the database. ONE by default or 'n' specified.%n", new Object[0]);
        this.console.printf("  version <version>  Migrates the database up or down to the specified version.%n", new Object[0]);
        this.console.printf("  pending            Force executes pending migrations out of order (not recommended).%n", new Object[0]);
        this.console.printf("  status             Prints the changelog from the database if the changelog table exists.%n", new Object[0]);
        this.console.printf("  script <v1> <v2>   Generates a delta migration script from version v1 to v2 (undo if v1 > v2).%n", new Object[0]);
        this.console.printf("%n", new Object[0]);
        this.console.printf("  * Shortcuts are accepted by using the first few (unambiguous) letters of each command..%n", new Object[0]);
        this.console.printf("%n", new Object[0]);
    }
}

