/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationLoader;
import org.apache.ibatis.migration.MigrationReader;
import org.apache.ibatis.migration.utils.Util;

public class FileMigrationLoader
implements MigrationLoader {
    protected final File scriptsDir;
    protected final String charset;
    protected final Properties variables;

    public FileMigrationLoader(File scriptsDir, String charset, Properties variables) {
        this.scriptsDir = scriptsDir;
        this.charset = charset;
        this.variables = variables;
    }

    @Override
    public List<Change> getMigrations() {
        ArrayList<Change> migrations = new ArrayList<Change>();
        if (this.scriptsDir.isDirectory()) {
            Object[] filenames = this.scriptsDir.list();
            if (filenames == null) {
                throw new MigrationException(this.scriptsDir + " does not exist.");
            }
            Arrays.sort(filenames);
            for (Object filename : filenames) {
                if (!((String)filename).endsWith(".sql") || this.isSpecialFile((String)filename)) continue;
                Change change = this.parseChangeFromFilename((String)filename);
                migrations.add(change);
            }
        }
        return migrations;
    }

    protected boolean isSpecialFile(String filename) {
        return "bootstrap.sql".equals(filename) || "onabort.sql".equals(filename);
    }

    protected Change parseChangeFromFilename(String filename) {
        try {
            Change change = new Change();
            int lastIndexOfDot = filename.lastIndexOf(46);
            String[] parts = filename.substring(0, lastIndexOfDot).split("_");
            change.setId(new BigDecimal(parts[0]));
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i < parts.length; ++i) {
                if (i > 1) {
                    builder.append(" ");
                }
                builder.append(parts[i]);
            }
            change.setDescription(builder.toString());
            change.setFilename(filename);
            return change;
        }
        catch (Exception e) {
            throw new MigrationException("Error parsing change from file.  Cause: " + e, e);
        }
    }

    @Override
    public Reader getScriptReader(Change change, boolean undo) {
        try {
            return new MigrationReader(Util.file(this.scriptsDir, change.getFilename()), this.charset, undo, this.variables);
        }
        catch (IOException e) {
            throw new MigrationException("Error reading " + change.getFilename(), e);
        }
    }

    @Override
    public Reader getBootstrapReader() {
        String fileName = "bootstrap.sql";
        return this.getSoleScriptReader(fileName);
    }

    @Override
    public Reader getOnAbortReader() {
        String fileName = "onabort.sql";
        return this.getSoleScriptReader(fileName);
    }

    protected Reader getSoleScriptReader(String fileName) {
        try {
            File scriptFile = Util.file(this.scriptsDir, fileName);
            if (scriptFile.exists()) {
                return new MigrationReader(scriptFile, this.charset, false, this.variables);
            }
            return null;
        }
        catch (IOException e) {
            throw new MigrationException("Error reading " + fileName, e);
        }
    }
}

