/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.migration.ConnectionProvider;
import org.apache.ibatis.migration.driver.DriverShim;

public class JdbcConnectionProvider
implements ConnectionProvider {
    private static final Map<String, Driver> registeredDrivers = JdbcConnectionProvider.registeredDrivers();
    private final String url;
    private final String username;
    private final String password;

    public JdbcConnectionProvider(String driver, String url, String username, String password) {
        this(null, driver, url, username, password);
    }

    public JdbcConnectionProvider(ClassLoader classLoader, String driver, String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.registerDriver(classLoader, driver);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    private void registerDriver(ClassLoader classLoader, String driver) {
        registeredDrivers.computeIfAbsent(driver, d -> this.createDriverClass(classLoader, (String)d));
    }

    private Driver createDriverClass(ClassLoader classLoader, String driver) {
        try {
            Class<?> driverClass = classLoader == null ? Class.forName(driver) : Class.forName(driver, true, classLoader);
            Driver driverInstance = (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DriverShim driverShim = new DriverShim(driverInstance);
            DriverManager.registerDriver(driverShim);
            return driverShim;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to register driver " + driver, e);
        }
    }

    private static Map<String, Driver> registeredDrivers() {
        HashMap<String, Driver> registeredDrivers = new HashMap<String, Driver>();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            registeredDrivers.put(driver.getClass().getName(), driver);
        }
        return registeredDrivers;
    }
}

