/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.commands.BaseCommand;
import org.apache.ibatis.migration.hook.MigrationHook;
import org.apache.ibatis.migration.hook.NewHookContext;
import org.apache.ibatis.migration.options.SelectedOptions;
import org.apache.ibatis.migration.utils.Util;

public final class NewCommand
extends BaseCommand {
    private static final String CUSTOM_NEW_COMMAND_TEMPLATE_PROPERTY = "new_command.template";

    public NewCommand(SelectedOptions options) {
        super(options);
    }

    @Override
    public void execute(String ... params) {
        if (this.paramsEmpty(params)) {
            throw new MigrationException("No description specified for new migration.");
        }
        String description = params[0];
        Properties variables = new Properties();
        variables.setProperty("description", description);
        this.existingEnvironmentFile();
        String filename = this.getNextIDAsString() + "_" + description.replace(' ', '_') + ".sql";
        HashMap<String, Object> hookBindings = new HashMap<String, Object>();
        MigrationHook hook = this.createNewHook();
        if (hook != null) {
            hookBindings.put("hookContext", new NewHookContext(description, filename));
            hook.before(hookBindings);
        }
        if (this.options.getTemplate() != null) {
            this.copyExternalResourceTo(this.options.getTemplate(), Util.file(this.paths.getScriptPath(), filename), variables);
        } else {
            String customConfiguredTemplate = Util.getPropertyOption(CUSTOM_NEW_COMMAND_TEMPLATE_PROPERTY);
            if (customConfiguredTemplate != null && !customConfiguredTemplate.isEmpty()) {
                this.copyExternalResourceTo(Util.migrationsHome() + File.separator + customConfiguredTemplate, Util.file(this.paths.getScriptPath(), filename), variables);
            } else {
                this.printStream.append("Your migrations configuration did not find your custom template.  Using the default template.");
                this.copyDefaultTemplate(variables, filename);
            }
            if (hook != null) {
                hookBindings.put("hookContext", new NewHookContext(description, filename));
                hook.after(hookBindings);
            }
        }
        this.printStream.println("Done!");
        this.printStream.println();
    }

    private void copyDefaultTemplate(Properties variables, String filename) {
        this.copyResourceTo("org/apache/ibatis/migration/template_migration.sql", Util.file(this.paths.getScriptPath(), filename), variables);
    }

    private MigrationHook createNewHook() {
        String before = this.environment().getHookBeforeNew();
        String after = this.environment().getHookAfterNew();
        if (before == null && after == null) {
            return null;
        }
        return this.createFileMigrationHook(before, null, null, after);
    }
}

