/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.hook;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.hook.HookScript;
import org.apache.ibatis.migration.options.SelectedPaths;
import org.apache.ibatis.migration.utils.Util;

public class Jsr223HookScript
implements HookScript {
    private static final String MIGRATION_PATHS = "migrationPaths";
    private static final String KEY_FUNCTION = "_function";
    private static final String KEY_OBJECT = "_object";
    private static final String KEY_METHOD = "_method";
    private static final String KEY_ARG = "_arg";
    protected final String language;
    protected final File scriptFile;
    protected final String charset;
    protected final Properties variables;
    protected final SelectedPaths paths;
    protected final PrintStream printStream;
    protected String functionName;
    protected String objectName;
    protected String methodName;
    protected List<String> args = new ArrayList<String>();
    protected Map<String, String> localVars = new HashMap<String, String>();

    public Jsr223HookScript(String language, File scriptFile, String charset, String[] options, SelectedPaths paths, Properties variables, PrintStream printStream) {
        this.language = language;
        this.scriptFile = scriptFile;
        this.charset = charset;
        this.paths = paths;
        this.variables = variables;
        this.printStream = printStream;
        for (String option : options) {
            int sep = option.indexOf(61);
            if (sep <= -1) continue;
            String key = option.substring(0, sep);
            String value = option.substring(sep + 1);
            if (KEY_FUNCTION.equals(key)) {
                this.functionName = value;
                continue;
            }
            if (KEY_METHOD.equals(key)) {
                this.methodName = value;
                continue;
            }
            if (KEY_OBJECT.equals(key)) {
                this.objectName = value;
                continue;
            }
            if (KEY_ARG.equals(key)) {
                this.args.add(value);
                continue;
            }
            this.localVars.put(key, value);
        }
    }

    @Override
    public void execute(Map<String, Object> bindingMap) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(this.language);
        Bindings bindings = engine.getContext().getBindings(100);
        this.bindVariables(bindingMap, this.variables.entrySet());
        this.bindVariables(bindingMap, this.localVars.entrySet());
        bindings.put(MIGRATION_PATHS, (Object)this.paths);
        bindings.putAll((Map<? extends String, ? extends Object>)bindingMap);
        try {
            this.printStream.println(Util.horizontalLine("Applying JSR-223 hook : " + this.scriptFile.getName(), 80));
            engine.eval(new InputStreamReader((InputStream)new FileInputStream(this.scriptFile), Charset.forName(this.charset)));
            if (this.functionName != null || this.objectName != null && this.methodName != null) {
                Invocable invocable = (Invocable)((Object)engine);
                if (this.functionName != null) {
                    this.printStream.println(Util.horizontalLine("Invoking function : " + this.functionName, 80));
                    invocable.invokeFunction(this.functionName, this.args.toArray());
                } else {
                    this.printStream.println(Util.horizontalLine("Invoking method : " + this.methodName, 80));
                    Object targetObject = engine.get(this.objectName);
                    invocable.invokeMethod(targetObject, this.methodName, this.args.toArray());
                }
            }
            this.bindVariables(bindingMap, bindings.entrySet());
        }
        catch (ClassCastException e) {
            throw new MigrationException("Script engine '" + engine.getClass().getName() + "' does not support function/method invocation.", e);
        }
        catch (IOException e) {
            throw new MigrationException("Failed to read JSR-223 hook script file.", e);
        }
        catch (ScriptException e) {
            throw new MigrationException("Failed to execute JSR-223 hook script.", e);
        }
        catch (NoSuchMethodException e) {
            throw new MigrationException("Method or function not found in JSR-223 hook script: " + this.functionName, e);
        }
    }

    private <S, T> void bindVariables(Map<String, Object> bindingMap, Set<Map.Entry<S, T>> vars) {
        for (Map.Entry<S, T> entry : vars) {
            bindingMap.put((String)entry.getKey(), entry.getValue());
        }
    }
}

