/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.operations;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.ConnectionProvider;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationLoader;
import org.apache.ibatis.migration.hook.HookContext;
import org.apache.ibatis.migration.hook.MigrationHook;
import org.apache.ibatis.migration.operations.ChangelogOperation;
import org.apache.ibatis.migration.operations.DatabaseOperation;
import org.apache.ibatis.migration.operations.ScriptRunner;
import org.apache.ibatis.migration.options.DatabaseOperationOption;
import org.apache.ibatis.migration.utils.Util;

public final class DownOperation
extends DatabaseOperation {
    private Integer steps;

    public DownOperation() {
        this(null);
    }

    public DownOperation(Integer steps) {
        this.steps = steps;
    }

    public DownOperation operate(ConnectionProvider connectionProvider, MigrationLoader migrationsLoader, DatabaseOperationOption option, PrintStream printStream) {
        return this.operate(connectionProvider, migrationsLoader, option, printStream, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DownOperation operate(ConnectionProvider connectionProvider, MigrationLoader migrationsLoader, DatabaseOperationOption option, PrintStream printStream, MigrationHook hook) {
        try (Connection con = connectionProvider.getConnection();){
            if (option == null) {
                option = new DatabaseOperationOption();
            }
            List<Change> changesInDb = Collections.emptyList();
            if (this.changelogExists(con, option)) {
                changesInDb = this.getChangelog(con, option);
            }
            if (changesInDb.isEmpty()) {
                this.println(printStream, "Changelog exist, but no migration found.");
            } else {
                List<Change> migrations = migrationsLoader.getMigrations();
                Collections.sort(migrations);
                String skippedOrMissing = this.checkSkippedOrMissing(changesInDb, migrations);
                Collections.reverse(migrations);
                int stepCount = 0;
                ScriptRunner runner = this.getScriptRunner(con, option, printStream);
                HashMap<String, Object> hookBindings = new HashMap<String, Object>();
                for (Change change : migrations) {
                    if (!change.equals(changesInDb.get(changesInDb.size() - 1))) continue;
                    if (stepCount == 0 && hook != null) {
                        hookBindings.put("hookContext", new HookContext(connectionProvider, runner, null));
                        hook.before(hookBindings);
                    }
                    if (hook != null) {
                        hookBindings.put("hookContext", new HookContext(connectionProvider, runner, change.clone()));
                        hook.beforeEach(hookBindings);
                    }
                    this.println(printStream, Util.horizontalLine("Undoing: " + change.getFilename(), 80));
                    runner.runScript(migrationsLoader.getScriptReader(change, true));
                    if (this.changelogExists(con, option)) {
                        this.deleteChange(con, change, option);
                    } else {
                        this.println(printStream, "Changelog doesn't exist. No further migrations will be undone (normal for the last migration).");
                        stepCount = this.steps;
                    }
                    this.println(printStream);
                    if (hook != null) {
                        hookBindings.put("hookContext", new HookContext(connectionProvider, runner, change.clone()));
                        hook.afterEach(hookBindings);
                    }
                    if (this.steps == null || ++stepCount >= this.steps) break;
                    changesInDb.remove(changesInDb.size() - 1);
                }
                if (stepCount > 0 && hook != null) {
                    hookBindings.put("hookContext", new HookContext(connectionProvider, runner, null));
                    hook.after(hookBindings);
                }
                this.println(printStream, skippedOrMissing);
            }
            DownOperation downOperation = this;
            return downOperation;
        }
        catch (Throwable e) {
            while (e instanceof MigrationException) {
                e = e.getCause();
            }
            throw new MigrationException("Error undoing last migration.  Cause: " + e, e);
        }
    }

    protected void deleteChange(Connection con, Change change, DatabaseOperationOption option) throws SQLException {
        ChangelogOperation operation = new ChangelogOperation(con, option);
        operation.deleteById(change.getId());
    }
}

