/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.operations;

import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.ConnectionProvider;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationLoader;
import org.apache.ibatis.migration.hook.MigrationHook;
import org.apache.ibatis.migration.operations.DatabaseOperation;
import org.apache.ibatis.migration.operations.DownOperation;
import org.apache.ibatis.migration.operations.UpOperation;
import org.apache.ibatis.migration.options.DatabaseOperationOption;

public final class VersionOperation
extends DatabaseOperation {
    private BigDecimal version;

    public VersionOperation(BigDecimal version) {
        this.version = version;
        if (version == null) {
            throw new IllegalArgumentException("The version must be null.");
        }
    }

    public VersionOperation operate(ConnectionProvider connectionProvider, MigrationLoader migrationsLoader, DatabaseOperationOption option, PrintStream printStream) {
        return this.operate(connectionProvider, migrationsLoader, option, printStream, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VersionOperation operate(ConnectionProvider connectionProvider, MigrationLoader migrationsLoader, DatabaseOperationOption option, PrintStream printStream, MigrationHook upHook, MigrationHook downHook) {
        if (option == null) {
            option = new DatabaseOperationOption();
        }
        try (Connection con = connectionProvider.getConnection();){
            int steps;
            Change lastChangeInDb;
            List changesInDb = this.changelogExists(con, option) ? this.getChangelog(con, option) : Collections.emptyList();
            List<Change> migrations = migrationsLoader.getMigrations();
            Change specified = new Change(this.version);
            if (!migrations.contains(specified)) {
                throw new MigrationException("A migration for the specified version number does not exist.");
            }
            Change change = lastChangeInDb = changesInDb.isEmpty() ? null : (Change)changesInDb.get(changesInDb.size() - 1);
            if (lastChangeInDb == null || specified.compareTo(lastChangeInDb) > 0) {
                this.println(printStream, "Upgrading to: " + this.version);
                steps = 0;
                for (Change change2 : migrations) {
                    if (lastChangeInDb != null && change2.compareTo(lastChangeInDb) <= 0 || change2.compareTo(specified) >= 1) continue;
                    ++steps;
                }
                new UpOperation(steps).operate(connectionProvider, migrationsLoader, option, printStream, upHook);
            } else if (specified.compareTo(lastChangeInDb) < 0) {
                this.println(printStream, "Downgrading to: " + this.version);
                steps = 0;
                for (Change change3 : migrations) {
                    if (change3.compareTo(specified) <= -1 || change3.compareTo(lastChangeInDb) >= 0) continue;
                    ++steps;
                }
                new DownOperation(steps).operate(connectionProvider, migrationsLoader, option, printStream, downHook);
            } else {
                this.println(printStream, "Already at version: " + this.version);
            }
            this.println(printStream);
            VersionOperation versionOperation = this;
            return versionOperation;
        }
        catch (SQLException e) {
            throw new MigrationException("Error creating connection.  Cause: " + e, e);
        }
    }
}

