/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.utils;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public enum Util {

    private static final String MIGRATIONS_HOME = "MIGRATIONS_HOME";
    private static final String MIGRATIONS_HOME_PROPERTY_DEPRECATED = "migrationHome";
    private static final String MIGRATIONS_HOME_PROPERTY = "migrationsHome";
    private static final String MIGRATIONS_PROPERTIES = "migration.properties";

    public static String migrationsHome() {
        String migrationsHome = System.getenv(MIGRATIONS_HOME);
        if (migrationsHome == null && (migrationsHome = System.getProperty(MIGRATIONS_HOME_PROPERTY)) == null) {
            migrationsHome = System.getProperty(MIGRATIONS_HOME_PROPERTY_DEPRECATED);
        }
        return migrationsHome;
    }

    public static boolean getPropertyOptionAsBoolean(String key) {
        return Boolean.valueOf(Util.getPropertyOption(key));
    }

    public static String getPropertyOption(String key) {
        String migrationsHome = Util.migrationsHome();
        if (migrationsHome == null || migrationsHome.isEmpty()) {
            return null;
        }
        try {
            String path = migrationsHome + File.separator + MIGRATIONS_PROPERTIES;
            Properties properties = new Properties();
            properties.load(new FileInputStream(path));
            return properties.getProperty(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isOption(String arg) {
        return arg.startsWith("--") && !arg.trim().endsWith("=");
    }

    public static File file(File path, String fileName) {
        return new File(path.getAbsolutePath() + File.separator + fileName);
    }

    public static String horizontalLine(String caption, int length) {
        StringBuilder builder = new StringBuilder();
        builder.append("==========");
        if (caption.length() > 0) {
            caption = " " + caption + " ";
            builder.append(caption);
        }
        for (int i = 0; i < length - caption.length() - 10; ++i) {
            builder.append("=");
        }
        return builder.toString();
    }
}

