/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.core;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpMessage;

public class RestHeader {
    private Map<String, Object> map = new HashMap<String, Object>();

    public static RestHeader getDefault() {
        RestHeader header = new RestHeader();
        header.put("User-Agent", "Mozilla/5.0");
        return header;
    }

    public void addAuthorization(String username, String password) {
        if (username != null) {
            this.map.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes()));
        }
    }

    public void addJsonContentType() {
        this.map.put("Content-Type", "application/json");
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public Set<String> keySets() {
        return this.map.keySet();
    }

    public void put(String key, String value) {
        this.map.put(key, value);
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public String toString() {
        return this.map.toString();
    }

    public void updateHeaders(HttpMessage httpMessage) {
        for (String key : this.map.keySet()) {
            httpMessage.setHeader(key, String.valueOf(this.map.get(key)));
        }
    }
}

