/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.mycontroller.restclient.core.RestHeader;
import org.mycontroller.restclient.core.RestHttpResponse;
import org.mycontroller.restclient.core.RestObjectMapper;
import org.mycontroller.restclient.core.TRUST_HOST_TYPE;
import org.mycontroller.restclient.core.typeresolvers.CollectionJavaTypeResolver;
import org.mycontroller.restclient.core.typeresolvers.MapJavaTypeResolver;
import org.mycontroller.restclient.core.typeresolvers.SimpleJavaTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestHttpClient {
    private static final Logger _logger = LoggerFactory.getLogger(RestHttpClient.class);
    private CloseableHttpClient client = null;
    private RequestConfig customRequestConfig = null;
    private ObjectMapper mapper = new RestObjectMapper();
    private SimpleJavaTypeResolver simpleJavaTypeResolver = new SimpleJavaTypeResolver();
    private CollectionJavaTypeResolver collectionJavaTypeResolver = new CollectionJavaTypeResolver();
    private MapJavaTypeResolver mapJavaTypeResolver = new MapJavaTypeResolver();

    public RestHttpClient() {
        this.client = HttpClientBuilder.create().build();
    }

    public RestHttpClient(TRUST_HOST_TYPE trustHostType) {
        this.customRequestConfig = RequestConfig.custom().setCookieSpec("standard").build();
        this.client = trustHostType == TRUST_HOST_TYPE.ANY ? this.getHttpClientTrustAll() : this.getHttpClient();
    }

    protected CloseableHttpClient getHttpClient() {
        return HttpClients.custom().setDefaultRequestConfig(this.customRequestConfig).build();
    }

    private CloseableHttpClient getHttpClientTrustAll() {
        SSLContextBuilder builder = new SSLContextBuilder();
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            builder.loadTrustMaterial(keyStore, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] trustedCert, String nameConstraints) throws CertificateException {
                    return true;
                }
            });
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)new AnyHostnameVerifier());
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(this.customRequestConfig).build();
        }
        catch (Exception ex) {
            _logger.error("Exception, ", (Throwable)ex);
            throw new RuntimeException("Unable to create trust ANY http client. Error: " + ex.getMessage());
        }
    }

    private RestHttpResponse execute(HttpUriRequest request) {
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute(request);
            RestHttpResponse restHttpResponse = RestHttpResponse.get(request.getURI(), (HttpResponse)response);
            return restHttpResponse;
        }
        catch (Exception ex) {
            _logger.debug("Exception,", (Throwable)ex);
            throw new RuntimeException(MessageFormat.format("Failed to execute, Request:{0}, error:{1}", request, ex.getMessage()));
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    _logger.error("Exception,", (Throwable)ex);
                }
            }
        }
    }

    private URI getURI(String url, Map<String, Object> queryParameters) throws URISyntaxException {
        if (queryParameters != null && !queryParameters.isEmpty()) {
            ArrayList<BasicNameValuePair> queryParams = new ArrayList<BasicNameValuePair>();
            for (String key : queryParameters.keySet()) {
                queryParams.add(new BasicNameValuePair(key, String.valueOf(queryParameters.get(key))));
            }
            return new URIBuilder(url).addParameters(queryParams).build();
        }
        return new URIBuilder(url).build();
    }

    protected RestHttpResponse doDelete(String url, Integer expectedResponseCode) {
        return this.doDelete(url, RestHeader.getDefault(), expectedResponseCode);
    }

    protected RestHttpResponse doDelete(String url, RestHeader header, Integer expectedResponseCode) {
        HttpDelete delete = new HttpDelete(url);
        header.updateHeaders((HttpMessage)delete);
        RestHttpResponse httpResponse = this.execute((HttpUriRequest)delete);
        this.validateResponse(httpResponse, expectedResponseCode);
        return httpResponse;
    }

    protected RestHttpResponse doGet(String url, Integer expectedResponseCode) {
        return this.doGet(url, null, RestHeader.getDefault(), expectedResponseCode);
    }

    protected RestHttpResponse doGet(String url, Map<String, Object> queryParameters, Integer expectedResponseCode) {
        return this.doGet(url, queryParameters, RestHeader.getDefault(), expectedResponseCode);
    }

    protected RestHttpResponse doGet(String url, Map<String, Object> queryParameters, RestHeader header, Integer expectedResponseCode) {
        try {
            HttpGet get = new HttpGet(this.getURI(url, queryParameters));
            header.updateHeaders((HttpMessage)get);
            RestHttpResponse httpResponse = this.execute((HttpUriRequest)get);
            this.validateResponse(httpResponse, expectedResponseCode);
            return httpResponse;
        }
        catch (Exception ex) {
            _logger.error("Exception when calling url:[{}], headers:[{}]", new Object[]{url, header, ex});
            throw new RuntimeException(MessageFormat.format("Failed to execute, url:{0}, error:{1}", url, ex.getMessage()));
        }
    }

    protected RestHttpResponse doGet(String url, RestHeader header, Integer expectedResponseCode) {
        return this.doGet(url, null, header, expectedResponseCode);
    }

    protected RestHttpResponse doPost(String url, Map<String, Object> queryParameters, RestHeader header, HttpEntity entity, Integer expectedResponseCode) {
        try {
            HttpPost post = new HttpPost(this.getURI(url, queryParameters));
            header.updateHeaders((HttpMessage)post);
            post.setEntity(entity);
            RestHttpResponse httpResponse = this.execute((HttpUriRequest)post);
            this.validateResponse(httpResponse, expectedResponseCode);
            return httpResponse;
        }
        catch (Exception ex) {
            _logger.error("Exception when calling url:[{}], headers:[{}], queryParameters:[{}]", new Object[]{url, header, queryParameters, ex});
            throw new RuntimeException(MessageFormat.format("Failed to execute, url:{0}, error:{1}", url, ex.getMessage()));
        }
    }

    protected RestHttpResponse doPost(String url, Map<String, Object> queryParameters, RestHeader header, Integer expectedResponseCode) {
        HttpEntity stringEntity = null;
        return this.doPost(url, queryParameters, header, stringEntity, expectedResponseCode);
    }

    protected RestHttpResponse doPost(String url, Map<String, Object> queryParameters, RestHeader header, String entity, Integer expectedResponseCode) {
        _logger.debug("Entity: {}", (Object)entity);
        try {
            return this.doPost(url, queryParameters, header, (HttpEntity)new StringEntity(entity), expectedResponseCode);
        }
        catch (UnsupportedEncodingException ex) {
            _logger.error("Exception when calling url:[{}], queryParameters:[{}], headers:[{}], entity:[{}]", new Object[]{url, queryParameters, header, entity, ex});
            throw new RuntimeException(MessageFormat.format("Failed to execute, url:{0}, error:{1}", url, ex.getMessage()));
        }
    }

    protected RestHttpResponse doPost(String url, RestHeader header, String entity, Integer expectedResponseCode) {
        return this.doPost(url, null, header, entity, expectedResponseCode);
    }

    protected RestHttpResponse doPut(String url, RestHeader header, HttpEntity entity, Integer expectedResponseCode) {
        HttpPut put = new HttpPut(url);
        header.updateHeaders((HttpMessage)put);
        put.setEntity(entity);
        RestHttpResponse httpResponse = this.execute((HttpUriRequest)put);
        this.validateResponse(httpResponse, expectedResponseCode);
        return httpResponse;
    }

    protected RestHttpResponse doPut(String url, RestHeader header, Integer expectedResponseCode) {
        HttpEntity stringEntity = null;
        return this.doPut(url, header, stringEntity, expectedResponseCode);
    }

    protected RestHttpResponse doPut(String url, RestHeader header, String entity, Integer expectedResponseCode) {
        _logger.debug("Entity: {}", (Object)entity);
        try {
            return this.doPut(url, header, (HttpEntity)new StringEntity(entity), expectedResponseCode);
        }
        catch (UnsupportedEncodingException ex) {
            _logger.error("Exception when calling url:[{}], headers:[{}], entity:[{}]", new Object[]{url, header, entity, ex});
            throw new RuntimeException(MessageFormat.format("Failed to execute, url:{0}, error:{1}", url, ex.getMessage()));
        }
    }

    public String getHeader(RestHttpResponse response, String name) {
        Header[] headers = response.getHeaders();
        for (int index = 0; index < headers.length; ++index) {
            Header header = headers[index];
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header.getValue();
        }
        return null;
    }

    public void updateOnNull(Map<String, Object> data, String key, Object value) {
        if (data.get(key) == null) {
            data.put(key, value);
        }
    }

    public void validateResponse(RestHttpResponse response, Integer expectedResponseCode) {
        _logger.debug("{}", (Object)response);
        if (expectedResponseCode != null && !response.getResponseCode().equals(expectedResponseCode)) {
            throw new RuntimeException("Did not match with expected response code[" + expectedResponseCode + "], " + response.toString());
        }
    }

    public SimpleJavaTypeResolver simpleResolver() {
        return this.simpleJavaTypeResolver;
    }

    public CollectionJavaTypeResolver collectionResolver() {
        return this.collectionJavaTypeResolver;
    }

    public MapJavaTypeResolver mapResolver() {
        return this.mapJavaTypeResolver;
    }

    public Object readValue(String entity, JavaType javaType) {
        try {
            return this.mapper.readValue(entity, javaType);
        }
        catch (IOException ex) {
            _logger.error("Exception: entity[{}]", (Object)entity, (Object)ex);
            throw new RuntimeException("Exception: " + ex.getMessage());
        }
    }

    public String toJsonString(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            _logger.error("Exception,", (Throwable)ex);
            throw new RuntimeException("Exception: " + ex.getMessage());
        }
    }

    class AnyHostnameVerifier
    implements HostnameVerifier {
        AnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public static enum STATUS_CODE {
        OK(200),
        CREATED(201),
        ACCEPTED(202),
        NO_CONTENT(204),
        BAD_REQUEST(400),
        UNAUTHORIZED(401),
        FORBIDDEN(403),
        NOT_FOUND(404);

        int code;

        private STATUS_CODE(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

