/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.mycontroller.restclient.core.RestHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestHttpResponse {
    private static final Logger _logger = LoggerFactory.getLogger(RestHttpResponse.class);
    private URI uri;
    private String entity;
    private Integer responseCode;
    private Header[] headers;
    private String exception;

    public static RestHttpResponse get(URI uri, HttpResponse response) throws UnsupportedOperationException, IOException {
        _logger.debug("{}", (Object)response);
        RestHttpResponse mcResponse = RestHttpResponse.builder().uri(uri).responseCode(response.getStatusLine().getStatusCode()).headers(response.getAllHeaders()).build();
        if (response.getStatusLine().getStatusCode() != RestHttpClient.STATUS_CODE.NO_CONTENT.getCode()) {
            mcResponse.entity = IOUtils.toString((InputStream)response.getEntity().getContent());
        }
        return mcResponse;
    }

    RestHttpResponse(URI uri, String entity, Integer responseCode, Header[] headers, String exception) {
        this.uri = uri;
        this.entity = entity;
        this.responseCode = responseCode;
        this.headers = headers;
        this.exception = exception;
    }

    public static RestHttpResponseBuilder builder() {
        return new RestHttpResponseBuilder();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getEntity() {
        return this.entity;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public String getException() {
        return this.exception;
    }

    public String toString() {
        return "RestHttpResponse(uri=" + this.getUri() + ", entity=" + this.getEntity() + ", responseCode=" + this.getResponseCode() + ", headers=" + Arrays.deepToString(this.getHeaders()) + ", exception=" + this.getException() + ")";
    }

    public static class RestHttpResponseBuilder {
        private URI uri;
        private String entity;
        private Integer responseCode;
        private Header[] headers;
        private String exception;

        RestHttpResponseBuilder() {
        }

        public RestHttpResponseBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public RestHttpResponseBuilder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public RestHttpResponseBuilder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public RestHttpResponseBuilder headers(Header[] headers) {
            this.headers = headers;
            return this;
        }

        public RestHttpResponseBuilder exception(String exception) {
            this.exception = exception;
            return this;
        }

        public RestHttpResponse build() {
            return new RestHttpResponse(this.uri, this.entity, this.responseCode, this.headers, this.exception);
        }

        public String toString() {
            return "RestHttpResponse.RestHttpResponseBuilder(uri=" + this.uri + ", entity=" + this.entity + ", responseCode=" + this.responseCode + ", headers=" + Arrays.deepToString(this.headers) + ", exception=" + this.exception + ")";
        }
    }
}

