/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.emoncms;

import java.util.HashMap;
import java.util.Map;
import org.mycontroller.restclient.core.RestHeader;
import org.mycontroller.restclient.core.RestHttpClient;
import org.mycontroller.restclient.core.RestHttpResponse;
import org.mycontroller.restclient.core.TRUST_HOST_TYPE;

public class EmoncmsClient
extends RestHttpClient {
    public static final String DEFAULT_URL = "https://emoncms.org";
    private String writeApiKey;
    private String baseUrl;
    private RestHeader header;

    public EmoncmsClient(String url, String writeApiKey, TRUST_HOST_TYPE trustHostType) {
        super(trustHostType == null ? TRUST_HOST_TYPE.DEFAULT : trustHostType);
        this.baseUrl = url;
        this.writeApiKey = writeApiKey;
        this.initClient();
    }

    public EmoncmsClient(String writeApiKey, TRUST_HOST_TYPE trustHostType) {
        this(DEFAULT_URL, writeApiKey, trustHostType);
    }

    private void initClient() {
        this.header = RestHeader.getDefault();
        this.header.addJsonContentType();
        this.header.put("Authorization", "Bearer " + this.writeApiKey);
    }

    public String post(Map<String, Object> data) {
        return this.post("0", data, null);
    }

    public String post(String node, Map<String, Object> data) {
        return this.post(node, data, null);
    }

    public String post(String node, Map<String, Object> data, Long timestampUnix) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("fulljson", this.toJsonString(data));
        queryParameters.put("node", node);
        if (timestampUnix != null) {
            queryParameters.put("time", timestampUnix);
        }
        RestHttpResponse response = this.doGet(this.baseUrl + "/input/post", queryParameters, this.header, RestHttpClient.STATUS_CODE.OK.getCode());
        return response.getEntity();
    }
}

