/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.influxdb;

import java.util.HashMap;
import org.mycontroller.restclient.core.RestHeader;
import org.mycontroller.restclient.core.RestHttpClient;
import org.mycontroller.restclient.core.RestHttpResponse;
import org.mycontroller.restclient.core.TRUST_HOST_TYPE;
import org.mycontroller.restclient.influxdb.model.Pong;
import org.mycontroller.restclient.influxdb.model.Query;
import org.mycontroller.restclient.influxdb.model.QueryResult;

public class InfluxDBClient
extends RestHttpClient {
    private String username;
    private String password;
    private String database;
    private String baseUrl;
    private RestHeader header;
    private StringBuilder dataBuilder = new StringBuilder();

    public InfluxDBClient(String baseUrl, String database, TRUST_HOST_TYPE trustHostType) {
        this(baseUrl, null, null, database, trustHostType);
    }

    public InfluxDBClient(String baseUrl, String username, String password, String database, TRUST_HOST_TYPE trustHostType) {
        super(trustHostType == null ? TRUST_HOST_TYPE.DEFAULT : trustHostType);
        this.username = username;
        this.password = password;
        this.database = database;
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.initClient();
    }

    private void initClient() {
        this.header = RestHeader.getDefault();
        this.header.addJsonContentType();
        this.header.addAuthorization(this.username, this.password);
    }

    public String getData(String measurement, String tags, String fieldName, String value, Long timestamp) {
        this.dataBuilder.setLength(0);
        this.dataBuilder.append(measurement);
        if (tags != null && tags.length() > 0) {
            this.dataBuilder.append(",").append(tags.replaceAll(" ", "_"));
        }
        this.dataBuilder.append(" ").append(fieldName.replaceAll(" ", "_")).append("=").append(value).append(" ").append(timestamp).append("000000");
        return this.dataBuilder.toString();
    }

    public Pong ping() {
        RestHttpResponse response = this.doGet(this.baseUrl + "/ping", null);
        if (response.getResponseCode().equals(RestHttpClient.STATUS_CODE.NO_CONTENT.getCode())) {
            return Pong.builder().version(this.getHeader(response, "X-Influxdb-Version")).reachable(true).build();
        }
        return Pong.builder().reachable(false).statusCode(response.getResponseCode()).errorMessage(response.getEntity()).build();
    }

    public QueryResult query(Query query) {
        query.setDb(this.database);
        if (query.getEpoch() == null) {
            query.setEpoch("ms");
        }
        RestHttpResponse response = this.doGet(this.baseUrl + "/query", query.getQueryMap(), this.header, RestHttpClient.STATUS_CODE.OK.getCode());
        return (QueryResult)this.readValue(response.getEntity(), this.simpleResolver().get(QueryResult.class));
    }

    public QueryResult queryManagement(Query query) {
        query.setDb(this.database);
        RestHttpResponse response = this.doPost(this.baseUrl + "/query", query.getQueryMap(), this.header, (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return (QueryResult)this.readValue(response.getEntity(), this.simpleResolver().get(QueryResult.class));
    }

    public void write(String data) {
        HashMap<String, Object> queryParms = new HashMap<String, Object>();
        queryParms.put("db", this.database);
        this.doPost(this.baseUrl + "/write", queryParms, this.header, data, (Integer)RestHttpClient.STATUS_CODE.NO_CONTENT.getCode());
    }
}

