/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.influxdb.model;

public class Pong {
    private String version;
    private boolean reachable;
    private String errorMessage;
    private Integer statusCode;

    Pong(String version, boolean reachable, String errorMessage, Integer statusCode) {
        this.version = version;
        this.reachable = reachable;
        this.errorMessage = errorMessage;
        this.statusCode = statusCode;
    }

    public static PongBuilder builder() {
        return new PongBuilder();
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String toString() {
        return "Pong(version=" + this.getVersion() + ", reachable=" + this.isReachable() + ", errorMessage=" + this.getErrorMessage() + ", statusCode=" + this.getStatusCode() + ")";
    }

    public static class PongBuilder {
        private String version;
        private boolean reachable;
        private String errorMessage;
        private Integer statusCode;

        PongBuilder() {
        }

        public PongBuilder version(String version) {
            this.version = version;
            return this;
        }

        public PongBuilder reachable(boolean reachable) {
            this.reachable = reachable;
            return this;
        }

        public PongBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public PongBuilder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Pong build() {
            return new Pong(this.version, this.reachable, this.errorMessage, this.statusCode);
        }

        public String toString() {
            return "Pong.PongBuilder(version=" + this.version + ", reachable=" + this.reachable + ", errorMessage=" + this.errorMessage + ", statusCode=" + this.statusCode + ")";
        }
    }
}

