/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.phantio;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.mycontroller.restclient.core.RestHeader;
import org.mycontroller.restclient.core.RestHttpClient;
import org.mycontroller.restclient.core.RestHttpResponse;
import org.mycontroller.restclient.core.TRUST_HOST_TYPE;
import org.mycontroller.restclient.phantio.model.PostResponse;
import org.mycontroller.restclient.phantio.model.Stats;

public class PhantIOClient
extends RestHttpClient {
    public static final String DEFAULT_URL = "https://data.sparkfun.com";
    private String publicKey;
    private String privateKey;
    private String baseUrl;
    private RestHeader header;

    public PhantIOClient(String publicKey, String privateKey, TRUST_HOST_TYPE trustHostType) {
        this(DEFAULT_URL, publicKey, privateKey, trustHostType);
    }

    public PhantIOClient(String baseUrl, String publicKey, String privateKey, TRUST_HOST_TYPE trustHostType) {
        super(trustHostType == null ? TRUST_HOST_TYPE.DEFAULT : trustHostType);
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.initClient();
    }

    private void initClient() {
        this.header = RestHeader.getDefault();
        this.header.addJsonContentType();
        this.header.put("Phant-Private-Key", this.privateKey);
    }

    public String clear() {
        RestHttpResponse response = this.doDelete(this.baseUrl + MessageFormat.format("/input/{0}", this.publicKey), this.header, RestHttpClient.STATUS_CODE.ACCEPTED.getCode());
        return response.getEntity();
    }

    public List<Map<String, Object>> get(Long limit) {
        return this.get(TimeZone.getDefault().getID(), limit);
    }

    public List<Map<String, Object>> get(String timezone, Long limit) {
        HashMap<String, Object> queryParms = new HashMap<String, Object>();
        queryParms.put("timezone", timezone);
        queryParms.put("limit", limit);
        RestHttpResponse response = this.doGet(this.baseUrl + MessageFormat.format("output/{0}.json", this.publicKey), queryParms, this.header, RestHttpClient.STATUS_CODE.OK.getCode());
        return (List)this.readValue(response.getEntity(), this.collectionResolver().get(List.class, Map.class, String.class, Object.class));
    }

    public PostResponse post(Map<String, Object> data) {
        RestHttpResponse response = this.doPost(this.baseUrl + MessageFormat.format("/input/{0}", this.publicKey), this.header, this.toJsonString(data), (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return (PostResponse)this.readValue(response.getEntity(), this.simpleResolver().get(PostResponse.class));
    }

    public Stats stats() {
        RestHttpResponse response = this.doGet(this.baseUrl + MessageFormat.format("/output/{0}/stats.json", this.publicKey), this.header, (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return (Stats)this.readValue(response.getEntity(), this.simpleResolver().get(Stats.class));
    }
}

