/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.philipshue;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.mycontroller.restclient.core.RestHeader;
import org.mycontroller.restclient.core.RestHttpClient;
import org.mycontroller.restclient.core.RestHttpResponse;
import org.mycontroller.restclient.core.TRUST_HOST_TYPE;
import org.mycontroller.restclient.philipshue.model.LightState;
import org.mycontroller.restclient.philipshue.model.State;

public class LightsClient
extends RestHttpClient {
    private String username;
    private String baseUrl;
    private RestHeader header;

    public LightsClient(String baseUrl, String username, TRUST_HOST_TYPE trustHostType) {
        super(trustHostType == null ? TRUST_HOST_TYPE.DEFAULT : trustHostType);
        this.username = username;
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.initClient();
    }

    private void initClient() {
        this.baseUrl = MessageFormat.format("{0}/api/{1}", this.baseUrl, this.username);
        this.header = RestHeader.getDefault();
        this.header.addJsonContentType();
    }

    public void delete(String id) {
        this.doDelete(this.baseUrl + MessageFormat.format("/lights/{0}", id), this.header, RestHttpClient.STATUS_CODE.OK.getCode());
    }

    public Map<String, LightState> listAll() {
        RestHttpResponse response = this.doGet(this.baseUrl + "/lights", this.header, (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return (Map)this.readValue(response.getEntity(), this.mapResolver().get(Map.class, String.class, LightState.class));
    }

    public Map<String, LightState> listNew() {
        RestHttpResponse response = this.doGet(this.baseUrl + "/lights/new", this.header, (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return (Map)this.readValue(response.getEntity(), this.mapResolver().get(Map.class, String.class, LightState.class));
    }

    public String searchNew() {
        RestHttpResponse response = this.doPost(this.baseUrl + "/lights", this.header, null, (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return (String)this.readValue(response.getEntity(), this.simpleResolver().get(String.class));
    }

    public LightState state(String id) {
        RestHttpResponse response = this.doGet(this.baseUrl + MessageFormat.format("/lights/{0}", id), this.header, (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return (LightState)this.readValue(response.getEntity(), this.simpleResolver().get(LightState.class));
    }

    public void updateName(String id, String name) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", name);
        this.doPut(this.baseUrl + MessageFormat.format("/lights/{0}", id), this.header, this.toJsonString(data), (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
    }

    public void updateState(String id, State state) {
        this.doPut(this.baseUrl + MessageFormat.format("/lights/{0}/state", id), this.header, this.toJsonString(state), (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
    }
}

