/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.plivo;

import java.text.MessageFormat;
import java.util.Map;
import org.mycontroller.restclient.core.RestHeader;
import org.mycontroller.restclient.core.RestHttpClient;
import org.mycontroller.restclient.core.RestHttpResponse;
import org.mycontroller.restclient.core.TRUST_HOST_TYPE;
import org.mycontroller.restclient.plivo.model.Account;
import org.mycontroller.restclient.plivo.model.Message;
import org.mycontroller.restclient.plivo.model.MessageResponse;

public class PlivoClient
extends RestHttpClient {
    public static final String URL = "https://api.plivo.com";
    public static final String VERSION = "v1";
    private String authId;
    private String authToken;
    private String baseUrl;
    private RestHeader header;

    public PlivoClient(String authId, String authToken, TRUST_HOST_TYPE trustHostType) {
        super(trustHostType == null ? TRUST_HOST_TYPE.DEFAULT : trustHostType);
        this.authId = authId;
        this.authToken = authToken;
        this.initClient();
    }

    private void initClient() {
        this.baseUrl = String.format("%s/%s/Account/%s", URL, VERSION, this.authId);
        this.header = RestHeader.getDefault();
        this.header.addJsonContentType();
        this.header.addAuthorization(this.authId, this.authToken);
    }

    public Account accountDetails() {
        RestHttpResponse response = this.doGet(this.baseUrl + "/", this.header, (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return (Account)this.readValue(response.getEntity(), this.simpleResolver().get(Account.class));
    }

    public Map<String, Object> messageStatus(String messageUuid) {
        RestHttpResponse response = this.doGet(this.baseUrl + MessageFormat.format("/Message/{0}/", messageUuid), this.header, (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return (Map)this.readValue(response.getEntity(), this.mapResolver().get(Map.class, String.class, Object.class));
    }

    public MessageResponse sendMessage(Message message) {
        RestHttpResponse response = this.doPost(this.baseUrl + "/Message/", this.header, this.toJsonString(message), (Integer)RestHttpClient.STATUS_CODE.ACCEPTED.getCode());
        return (MessageResponse)this.readValue(response.getEntity(), this.simpleResolver().get(MessageResponse.class));
    }
}

