/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.pushbullet;

import java.text.MessageFormat;
import java.util.List;
import org.mycontroller.restclient.core.RestHeader;
import org.mycontroller.restclient.core.RestHttpClient;
import org.mycontroller.restclient.core.RestHttpResponse;
import org.mycontroller.restclient.core.TRUST_HOST_TYPE;
import org.mycontroller.restclient.pushbullet.model.Device;
import org.mycontroller.restclient.pushbullet.model.Devices;
import org.mycontroller.restclient.pushbullet.model.Push;
import org.mycontroller.restclient.pushbullet.model.PushResponse;
import org.mycontroller.restclient.pushbullet.model.User;

public class PushbulletClient
extends RestHttpClient {
    public static final String URL = "https://api.pushbullet.com";
    public static final String VERSION = "v2";
    private String authToken;
    private String baseUrl;
    private RestHeader header;

    public PushbulletClient(String authToken, TRUST_HOST_TYPE trustHostType) {
        super(trustHostType == null ? TRUST_HOST_TYPE.DEFAULT : trustHostType);
        this.authToken = authToken;
        this.initClient();
    }

    private void initClient() {
        this.baseUrl = MessageFormat.format("{0}/{1}", URL, VERSION);
        this.header = RestHeader.getDefault();
        this.header.addJsonContentType();
        this.header.put("Access-Token", this.authToken);
    }

    public PushResponse createPush(Push push) {
        RestHttpResponse response = this.doPost(this.baseUrl + "/pushes", this.header, this.toJsonString(push), (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return (PushResponse)this.readValue(response.getEntity(), this.simpleResolver().get(PushResponse.class));
    }

    public User currentUser() {
        RestHttpResponse response = this.doGet(this.baseUrl + "/users/me", this.header, (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return (User)this.readValue(response.getEntity(), this.simpleResolver().get(User.class));
    }

    public List<Device> devices() {
        RestHttpResponse response = this.doGet(this.baseUrl + "/devices", this.header, (Integer)RestHttpClient.STATUS_CODE.OK.getCode());
        return ((Devices)this.readValue(response.getEntity(), this.simpleResolver().get(Devices.class))).getDevices();
    }
}

