/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.telegrambot;

import com.fasterxml.jackson.databind.JavaType;
import java.util.Map;
import org.mycontroller.restclient.core.RestHeader;
import org.mycontroller.restclient.core.RestHttpClient;
import org.mycontroller.restclient.core.RestHttpResponse;
import org.mycontroller.restclient.core.TRUST_HOST_TYPE;
import org.mycontroller.restclient.telegrambot.model.Message;
import org.mycontroller.restclient.telegrambot.model.Response;
import org.mycontroller.restclient.telegrambot.model.User;

public class TelegramBotClient
extends RestHttpClient {
    public static final String URL = "https://api.telegram.org";
    private String token;
    private String baseUrl;
    private RestHeader header;

    public TelegramBotClient(String token, TRUST_HOST_TYPE trustHostType) {
        super(trustHostType == null ? TRUST_HOST_TYPE.DEFAULT : trustHostType);
        this.token = token;
        this.initClient();
    }

    private void initClient() {
        this.baseUrl = String.format("%s/bot%s", URL, this.token);
        this.header = RestHeader.getDefault();
        this.header.addJsonContentType();
    }

    private Object readResponse(String entity, JavaType javaType) {
        Response response = (Response)this.readValue(entity, this.simpleResolver().get(Response.class));
        if (response.isOk()) {
            return this.readValue(response.getResult(), javaType);
        }
        throw new RuntimeException(response.toString());
    }

    public User getMe() {
        RestHttpResponse response = this.doGet(this.baseUrl + "/getMe", this.header, null);
        return (User)this.readResponse(response.getEntity(), this.simpleResolver().get(User.class));
    }

    public Map<String, Object> sendMessage(Message message) {
        RestHttpResponse response = this.doPost(this.baseUrl + "/sendMessage", this.header, this.toJsonString(message), null);
        return (Map)this.readResponse(response.getEntity(), this.mapResolver().get(Map.class, String.class, Object.class));
    }
}

