/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.twilio;

import java.text.MessageFormat;
import org.mycontroller.restclient.core.RestHeader;
import org.mycontroller.restclient.core.RestHttpClient;
import org.mycontroller.restclient.core.RestHttpResponse;
import org.mycontroller.restclient.core.TRUST_HOST_TYPE;
import org.mycontroller.restclient.twilio.model.Message;
import org.mycontroller.restclient.twilio.model.MessageResponse;

public class TwilioClient
extends RestHttpClient {
    public static final String URL = "https://api.twilio.com";
    public static final String VERSION = "2010-04-01";
    private String accountSid;
    private String authToken;
    private String baseUrl;
    private RestHeader header;

    public TwilioClient(String accountSid, String authToken, TRUST_HOST_TYPE trustHostType) {
        super(trustHostType == null ? TRUST_HOST_TYPE.DEFAULT : trustHostType);
        this.accountSid = accountSid;
        this.authToken = authToken;
        this.initClient();
    }

    private void initClient() {
        this.baseUrl = MessageFormat.format("{0}/{1}/{2}", URL, VERSION, this.accountSid);
        this.header = RestHeader.getDefault();
        this.header.addJsonContentType();
        this.header.addAuthorization(this.accountSid, this.authToken);
    }

    public MessageResponse sendMessage(Message message) {
        RestHttpResponse response = this.doPost(this.baseUrl + "/Messages", this.header, this.toJsonString(message), (Integer)RestHttpClient.STATUS_CODE.CREATED.getCode());
        return (MessageResponse)this.readValue(response.getEntity(), this.simpleResolver().get(MessageResponse.class));
    }
}

