/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.twilio.model;

import java.beans.ConstructorProperties;
import lombok.NonNull;

public class Message {
    @NonNull
    private String to;
    @NonNull
    private String from;
    @NonNull
    private String body;

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    @NonNull
    public String getTo() {
        return this.to;
    }

    @NonNull
    public String getFrom() {
        return this.from;
    }

    @NonNull
    public String getBody() {
        return this.body;
    }

    public void setTo(@NonNull String to) {
        if (to == null) {
            throw new NullPointerException("to");
        }
        this.to = to;
    }

    public void setFrom(@NonNull String from) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        this.from = from;
    }

    public void setBody(@NonNull String body) {
        if (body == null) {
            throw new NullPointerException("body");
        }
        this.body = body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String toString() {
        return "Message(to=" + this.getTo() + ", from=" + this.getFrom() + ", body=" + this.getBody() + ")";
    }

    public Message() {
    }

    @ConstructorProperties(value={"to", "from", "body"})
    public Message(@NonNull String to, @NonNull String from, @NonNull String body) {
        if (to == null) {
            throw new NullPointerException("to");
        }
        if (from == null) {
            throw new NullPointerException("from");
        }
        if (body == null) {
            throw new NullPointerException("body");
        }
        this.to = to;
        this.from = from;
        this.body = body;
    }

    public static class MessageBuilder {
        private String to;
        private String from;
        private String body;

        MessageBuilder() {
        }

        public MessageBuilder to(String to) {
            this.to = to;
            return this;
        }

        public MessageBuilder from(String from) {
            this.from = from;
            return this;
        }

        public MessageBuilder body(String body) {
            this.body = body;
            return this;
        }

        public Message build() {
            return new Message(this.to, this.from, this.body);
        }

        public String toString() {
            return "Message.MessageBuilder(to=" + this.to + ", from=" + this.from + ", body=" + this.body + ")";
        }
    }
}

