/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.wunderground;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.mycontroller.restclient.core.RestHeader;
import org.mycontroller.restclient.core.RestHttpClient;
import org.mycontroller.restclient.core.RestHttpResponse;
import org.mycontroller.restclient.core.TRUST_HOST_TYPE;
import org.mycontroller.restclient.wunderground.model.Criteria;
import org.mycontroller.restclient.wunderground.model.WUResponse;

public class WundergroundClient
extends RestHttpClient {
    public static final String URL = "https://api.wunderground.com";
    public static final String UPLOAD_URL = "https://weatherstation.wunderground.com/weatherstation/updateweatherstation.php";
    private String apiKey;
    private String baseUrl;
    private RestHeader header;

    public WundergroundClient(String apiKey, TRUST_HOST_TYPE trustHostType) {
        super(trustHostType == null ? TRUST_HOST_TYPE.DEFAULT : trustHostType);
        this.apiKey = apiKey;
        this.initClient();
    }

    private void initClient() {
        this.baseUrl = URL;
        this.header = RestHeader.getDefault();
        this.header.addJsonContentType();
    }

    public WUResponse query(Criteria criteria) {
        HashMap<String, Object> queryParams = null;
        if (criteria.getGeoIP() != null) {
            queryParams = new HashMap<String, Object>();
            queryParams.put("geo_ip", criteria.getGeoIP());
        }
        RestHttpResponse response = this.doGet(this.baseUrl + MessageFormat.format("/api/{0}/{1}/lang:{2}/q/{3}.json", this.apiKey, criteria.getFeatures().queryString(), criteria.getLanguageCode(), criteria.getLocation()), queryParams, this.header, RestHttpClient.STATUS_CODE.OK.getCode());
        return (WUResponse)this.readValue(response.getEntity(), this.simpleResolver().get(WUResponse.class));
    }

    public String send(Map<String, Object> data) {
        this.updateOnNull(data, "action", "updateraw");
        this.updateOnNull(data, "dateutc", "now");
        RestHttpResponse response = this.doGet(UPLOAD_URL, data, this.header, RestHttpClient.STATUS_CODE.OK.getCode());
        return response.getEntity();
    }
}

