/*
 * Decompiled with CFR 0.152.
 */
package org.mycontroller.restclient.wunderground.model;

import org.mycontroller.restclient.wunderground.model.Features;

public class Criteria {
    private Features features;
    private String languageCode;
    private String location;
    private String geoIP;

    public Features getFeatures() {
        if (this.features == null) {
            this.features = Features.getDefault();
        }
        return this.features;
    }

    public String getLanguageCode() {
        if (this.languageCode == null) {
            this.languageCode = "EN";
        }
        return this.languageCode;
    }

    public String getLocation() {
        if (this.location == null) {
            this.location = "autoip";
        }
        return this.location;
    }

    Criteria(Features features, String languageCode, String location, String geoIP) {
        this.features = features;
        this.languageCode = languageCode;
        this.location = location;
        this.geoIP = geoIP;
    }

    public static CriteriaBuilder builder() {
        return new CriteriaBuilder();
    }

    public String getGeoIP() {
        return this.geoIP;
    }

    public String toString() {
        return "Criteria(features=" + this.getFeatures() + ", languageCode=" + this.getLanguageCode() + ", location=" + this.getLocation() + ", geoIP=" + this.getGeoIP() + ")";
    }

    public static class CriteriaBuilder {
        private Features features;
        private String languageCode;
        private String location;
        private String geoIP;

        CriteriaBuilder() {
        }

        public CriteriaBuilder features(Features features) {
            this.features = features;
            return this;
        }

        public CriteriaBuilder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public CriteriaBuilder location(String location) {
            this.location = location;
            return this;
        }

        public CriteriaBuilder geoIP(String geoIP) {
            this.geoIP = geoIP;
            return this;
        }

        public Criteria build() {
            return new Criteria(this.features, this.languageCode, this.location, this.geoIP);
        }

        public String toString() {
            return "Criteria.CriteriaBuilder(features=" + this.features + ", languageCode=" + this.languageCode + ", location=" + this.location + ", geoIP=" + this.geoIP + ")";
        }
    }
}

